
//This class will show a numeric representation of a fraction.
class FlipCard extends Container { // use JS6 extends keyword
	constructor (rectangleInit, backColour) {
		//for testing
		//this.debugFlag = false;

		super(); // use JS6 super() to call the Container constructor

		this.turningTime = 300; //The time in milliseconds to spend turning the card
		//this.useHighlight = !false; //This indicates whether a click on the card will toggle a highlight or flip the card
		this.highlightChangeFunction; //Set this if you want the representationArray to be updated when the highlight is toggle on and off
		this.selected = false;
		this.previouslySelected = false; //a matched card sticking around in the face down game

		//The defaults are below, but if something is passed in it will replace it
		this.rectangleInit = {width:200, height:200, corner:20, color:"white", borderColor:black};
		if (rectangleInit != null){
			this.rectangleInit = rectangleInit;
		}

		//This is the reverse of the above, we assume a colour was passed and then if not, use the default of white
		this.backColour = backColour;
		if (this.backColour==null){
			this.backColour = "white";//"#2157B0";
		}

		//So these values can be used later
		this.drawWidth = this.rectangleInit.width;
		this.drawHeight = this.rectangleInit.height;

		this.distanceToTap = 0.25*cardWidth;

		//This is the container that is going to hold all our content.
		//change borderWidth to something bigger than 0.1 and borderColor to black to see all contentContainers
		this.contentContainer = new Rectangle({width:this.drawWidth, height:this.drawHeight, color:"rgba(0,0,0,0)"/*, borderColor:"rgba(0,0,0,0)", borderWidth:0.01*/});
		this.contentContainer.addTo(this);

		//Creating our highlight and setting alpha to zero
		this.highlightInit = {width:this.drawWidth, height:this.drawHeight, corner:this.rectangleInit.corner, borderColor:"yellow", borderWidth:0.1*Math.max(this.drawWidth, this.drawHeight)};
		this.cardHighlight = new Rectangle(this.highlightInit).addTo(this.contentContainer);
		this.cardHighlight.alpha = 0;

		//This is the card front which will hold our representation
		this.cardFront = new Rectangle(this.rectangleInit).addTo(this.contentContainer);
		this.cardFront.name = "cardFront";

		//This will be our backgroundRectangle
		this.rectangleInit.color = this.backColour;
		this.cardBack = new Rectangle(this.rectangleInit).addTo(this.contentContainer);
		this.cardBack.name = "cardback";
		this.cardBack.scaleX = 0;
		this.cardBack.x = this.rectangleInit.width/2;

		this.desiredLogoSize = 0.8*Math.min(this.drawWidth,this.drawHeight)
		this.logoWidth = 103;//This is the actual pixel size of the imported logo
		this.logoHeight = 35;

		this.mathiesLogo = new Bitmap("assets/mathieslogoSmall.png", this.logoWidth, this.logoHeight).addTo(this.cardBack).sca(this.desiredLogoSize/this.logoWidth);
		this.mathiesLogo.mouseEnabled = false; //to prevent cross domain issues
		this.mathiesLogo.x = 0.1*Math.min(this.drawWidth,this.drawHeight);
		this.mathiesLogo.y = 0.5*((Math.min(this.drawWidth,this.drawHeight) - this.logoHeight*this.desiredLogoSize/this.logoWidth));
		//this.cardBack.cache(0,0,this.drawWidth, this.drawHeight);

		this.hiding = true;
		if (!playFaceUp){

			//Don't use this, use the instantFlip method instead so that fraction representations can be drawn first
		}

		//Allowing the card to be flippable
		this.tap(this.cardClicked, this.distanceToTap);
		this.name = "FlipCard";

		//To allow chaining
		return this;
	}

	instantFlip(){
		var swapInBetween = this.cardBack.scaleX;
		this.cardBack.scaleX = this.cardFront.scaleX;
		this.cardFront.scaleX = swapInBetween;
		swapInBetween = this.cardBack.x;
		this.cardBack.x = this.cardFront.x;
		this.cardFront.x = swapInBetween;
		this.hiding = !this.hiding;
	}

	cardClicked(e){
		//We are going to use the currentTarget which gives us the object that the tap was setup on
		var cardTarget = e.currentTarget;
		if (!playFaceUp && !cardTarget.previouslySelected){
			cardTarget.turnCard();
		}
		cardTarget.toggleHighlight();
	}

	turnCard(){
		//Pause any animations that are currently happening
		this.cardBack.pauseAnimate();
		this.cardFront.pauseAnimate();

		//Switch whether we are hiding or showing
		this.hiding = !this.hiding;
		var xPos = this.rectangleInit.width/2;

		//This is set at the top of the class
		var turnTime = this.turningTime;

		//going to flip by animating the scaleX and x at the same time
		if (this.hiding){
			//Immediately turn the back of the card to a scale of zero
			this.cardBack.animate({scaleX:0, x:xPos}, turnTime, null, "linear");

			//Wait half the animation time and then show the front
			this.cardFront.animate({scaleX:1, x:0}, turnTime, null, "linear", null, turnTime);
		} else {
			//Just do the reverse of the above if we are showing instead of hiding
			this.cardFront.animate({scaleX:0, x:xPos}, turnTime, null, "linear");
			this.cardBack.animate({scaleX:1, x:0}, turnTime, null,"linear",  null, turnTime);
		}
	}

	toggleHighlight(doBroadcast){
		if (doBroadcast == null){
			doBroadcast = true;
		}
		if (!this.previouslySelected){
			if (this.cardHighlight.alpha == 0){
				this.cardHighlight.alpha = 0.8;
				this.alpha = 1;
				this.selected = true;
			} else {
				this.cardHighlight.alpha = 0;
				this.alpha = 0.9;
				this.selected = false;
			}
		}
		this.cardHighlight.visible = playFaceUp;

		if (doBroadcast && this.highlightChangeFunction != null && !redrawInProgress){
			//zog("toggleHighlight calling highlightChangeFunction line:144 file:FlipCard.js");
			this.highlightChangeFunction(this);
		}

		frame.stage.update();
	}

	finishTurn(){
		//zog("Finished turning card");
	}

	//for testing
	/*addTo(cont){
		zog("this: "+this+" line:157 file:FlipCard.js");
		if (this.debugFlag){
			zog("debugFlag set line:159 file:FlipCard.js");
			zog(this.debugFlag[0] = 20); // error on purpose or use Throw - to get a stack trace
		}
		super.addTo(cont);
	}*/
}