
//This class will show a numeric representation of a fraction.
class FooterLine extends Container { // use JS6 extends keyword
	constructor (footerHeight, menuLine) {
		super(); // use JS6 super() to call the Container constructor
		this.name = "FooterLine";
		if (footerHeight == null){
			this.footerHeight = 9;
		} else {
			this.footerHeight = footerHeight;
		}
		this.menuLine = menuLine;
		this.position(this.footerHeight);
		//To allow chaining
		return this;
	}

	position(){
		//the background of the FooterLine
		if (this.contentContainer){
			this.contentContainer.parent.removeChild(this.contentContainer);
		}
		this.contentContainer = new Rectangle({width:this.menuLine.contentContainer.width, height:this.footerHeight, color:"#2157B0", borderColor:"black", borderWidth:1});
		this.contentContainer.addTo(this);
		this.contentContainer.mouseChildren = true;

		//size and position the level indicator
		this.levelIndicator = new LevelIndicator(Math.max(this.menuLine.instructionLabel.size*0.667, this.footerHeight*.4))
			.addTo(this.contentContainer);
		this.levelIndicator.loc(this.menuLine.instructionLabel.x, this.footerHeight/2 - this.levelIndicator.levelLabel.height/2);

		//size and position the mute button
		this.muteButton = this.makeButton("sound", "mute").addTo(this.contentContainer);
		this.muteButton
			.loc(this.contentContainer.width - 1.2*this.footerHeight, this.footerHeight*0.1)
			.tap(function(e){
					muteAllSounds = !muteAllSounds;
					if (!muteAllSounds){
						playGameSound("right");
					}
				}, this.footerHeight*0.4);
		if (muteAllSounds){
			//get the toggleIcon showing
			this.muteButton.toggle();
		}
	}

	makeButton(type, toggle) {
		var spacing = 10;
		var iconScale = .6;
		var iconColor = white
		var buttonSize = 40;
		var buttonColor = mathiesBlue;
		var buttonRoll = mathiesBlueRollover;
		var rollIconColor = dark;

		this.icon =  pizzazz.makeIcon({
			type:type,
			color:iconColor,
			scale:iconScale
		});
		this.drawSoundLines(this.icon.shape, buttonSize);

		this.rollIcon =  pizzazz.makeIcon({
			type:type,
			color:rollIconColor,
			scale:iconScale
		});
		this.drawSoundLines(this.rollIcon.shape, buttonSize);


		if (toggle) {
			this.toggleIcon = pizzazz.makeIcon({
				type:toggle,
				color:iconColor,
				scale:iconScale
			});
			this.toggleIcon.shape.x-=buttonSize*0.05;
			//this.drawSoundLines(this.toggleIcon.shape, buttonSize);
			this.rollToggleIcon = pizzazz.makeIcon({
				type:toggle,
				color:rollIconColor,
				scale:iconScale
			});
			this.rollToggleIcon.shape.x-=buttonSize*0.05;
			//this.drawSoundLines(this.rollToggleIcon.shape, buttonSize);
		}
		// 10. once the icons are made, add them to the Button with icon, rollIcon, toggle and rollToggle params
		var button = new Button({
			width:buttonSize,
			height:buttonSize,
			backgroundColor:buttonColor,
			borderColor:black,
			borderWidth:1,
			rollBackgroundColor:buttonRoll,
			gradient:.3,
			corner:buttonSize/2,
			icon:this.icon,
			rollIcon:this.rollIcon,
			toggleIcon:this.toggleIcon,
			rollToggleIcon:this.rollToggleIcon,
			shadowColor:-1
		});
		button.sca(this.footerHeight*0.8/40);
		return button;
	}

	drawSoundLines(buttonShape, buttonShapeSize){
		buttonShape.graphics.moveTo(buttonShapeSize*0.4,-buttonShapeSize*0.15);
		buttonShape.graphics.curveTo(buttonShapeSize*0.6,buttonShapeSize*0, buttonShapeSize*0.4,buttonShapeSize*0.15);
		buttonShape.graphics.moveTo(buttonShapeSize*0.55,-buttonShapeSize*0.25);
		buttonShape.graphics.curveTo(buttonShapeSize*0.75,buttonShapeSize*0, buttonShapeSize*0.55,buttonShapeSize*0.25);
		buttonShape.x-=buttonShapeSize*0.05;
	}
}