//This class will show a numeric representation of a fraction.
class GameContainer extends Container { // use JS6 extends keyword

	constructor (rectangleInit, backColour) {
		//zog("creating a GameContainer line:5 file:GameContainer.js debug: "+debug);
		super(); // use JS6 super() to call the Container constructor
		this.numberOfQuestions = questionArray.length;
		//the questionArray is sorted once at the beginning - on subsequent start over's the allCards are sorted
		if (!debug){
			questionArray.sort(function(a, b){return b.sortOrder - a.sortOrder});
		} else {
			zog("See debug - not sorting questions line:12 file:GameContainer.js");
		}
		this.allCards = [];
		this.selectedCards = [];
		this.previouslySelectedCards = [];
		this.numberOfCardsFlipped = 0;
		this.numberOfCardsCleared = 0;
		this.goingHome = false;

		this.redraw();

		timeout(100, resize); //seem to be having some trouble with this transition - or at least Agnes is
	}

	redraw(rerandomize){
		var oldInstruction;
		if (this.dealingWithMatch){
			this.dealWithMatch();
		}
		if (!redrawInProgress && this.dealingWithNoMatch){
			this.dealWithNoMatch();
		}
		this.inactiveCards = [];
		if (this.menuLine && this.menuLine.parent){
			this.menuLine.parent.removeChild(this.menuLine);
			oldInstruction = this.menuLine.instructionLabel.text;
		}
		this.menuLine = new MenuLine();
		if (oldInstruction){
			this.menuLine.instructionLabel.text = oldInstruction;
		}

		if (rerandomize){
			if (!debug){
				questionArray.sort(function(a, b){return b.sortOrder - a.sortOrder});
				this.allCards.sort(function(a, b){return b.sortOrder - a.sortOrder});
			} else {
				zog("See debug - not sorting questions line:49 file:GameContainer.js");
			}
		}
		//this.traceQuestionArray(" line:52 file:GameContainer.js");

		var newAllCards = [];
		var newSelectedCards = [];

		for(var j=0;j<this.numberOfQuestions;j++){
			var myCard = new FlipCard(this.getCardInit());
			newAllCards.push(myCard);
			myCard.highlightChangeFunction = this.cardFlipHandler;
			myCard.name = "card"+j;
			this.initialCardWidth = cardWidth;
			var questionRep;
			var repObject = questionArray[j].representation;

			if (this.allCards[j] && (repObject.repClass == WholeDots || repObject.repClass == WholeTenFrame || repObject.repClass == WholeDice)){
				questionRep = this.allCards[j].representation;
				questionRep.sca(questionRep.scaleX*(cardWidth/questionRep.previousCardWidth));
			} else {
				questionRep = new repObject.repClass(
				repObject.whole,
				cardWidth*0.85,
				cardHeight*0.85,
				repObject.customParms);
			}

			questionRep.center(myCard);
			questionRep.addTo(myCard.cardFront);
			myCard.representation = questionRep;
			myCard.representation.previousCardWidth = cardWidth;
			myCard.instantFlip();
			questionArray[j].sortOrder = Math.random(); //for next rerandomize
			myCard.sortOrder = questionArray[j].sortOrder;
			if (this.allCards[j]){
				if (this.selectedCards.indexOf(this.allCards[j]) > -1){
					newSelectedCards.push(myCard);
					//zog("need to select the new card line:87 file:GameContainer.js");
				}
				if (!this.allCards[j].contentContainer.parent){
					this.inactiveCards.push(myCard);
				}
				if (this.allCards[j].parent){
					this.allCards[j].parent.removeChild(this.allCards[j]);
				}
			}
		}
		this.allCards = newAllCards;
		//this.traceCards(" line:98 file:GameContainer.js");
		this.selectedCards = newSelectedCards;
		this.positionCards();
	}

	getCardInit(){
		return {width:cardWidth, height:cardHeight, corner:cardWidth*0.2, color:"#2157B0", borderColor:"black"};
	}

	positionCards(){
		//Going to position all cards in a row
		var margin = getMargin();
		this.menuLine
			.addTo(this)
			.loc(margin, margin);
		var curX = margin;
		var curY = 2*margin + menuHeight;
		var maxX = 0;
		var numberInRow = 0;
		var currentCard;
		for(var i=0;i<this.allCards.length;i++){
			currentCard = this.allCards[i];
			if (this.inactiveCards.indexOf(currentCard) == -1){
				currentCard.addTo(this);
				if (playFaceUp){
					//currentCard.turnCard();
					currentCard.instantFlip();
				}
				if (this.selectedCards.indexOf(currentCard) > -1){
					if (!playFaceUp){
						//currentCard.turnCard();
						currentCard.instantFlip();
					}
					currentCard.toggleHighlight(false);
					currentCard.cardHighlight.visible = playFaceUp;
				}
			} else {
				//zog("This card should stay off the stage - inactive line:135 file:GameContainer.js");
				currentCard.debugFlag = true;
				currentCard.contentContainer.parent.removeChild(currentCard.contentContainer);
				//zog("currentCard: "+currentCard+" line:138 file:GameContainer.js "+currentCard.debugFlag);
			}

			numberInRow++;
			if (curX + cardWidth + margin > stageWidth || numberInRow > numberOfColumns){
				curY += cardHeight + margin;
				curX = margin;
				numberInRow = 1;
			}
			currentCard.x = curX;
			currentCard.y = curY;
			if (currentCard.x + cardWidth > maxX){
				maxX = currentCard.x + cardWidth;
			}
			curX += cardWidth + margin;
		}
		this.menuLine.position(maxX);
		if (this.footerLine && this.footerLine.parent){
			this.footerLine.parent.removeChild(this.footerLine);
		}
		this.footerLine = new FooterLine(getFooterHeight(), this.menuLine)
			.addTo(this)
			.loc(this.menuLine.x, curY + cardHeight + margin);
		if ((this.footerLine.y + this.footerLine.height) > stageHeight){
			zog("Warning footer gone off the stage line:162 file:GameContainer.js");
		}

		if (this.happyStar){
			this.happyStar.parent.removeChild(this.happyStar);
		}
		this.happyStar = new Star(cardWidth*0.2, "yellow", "black", Math.floor(margin/6), true).addTo(this).center().alp(0); //radius, starColour, starOutlineColour, starOutlineThickness, showFace //0.4
		this.happyStar.name = "gameContainer Feedback Star";
	}

	cardFlipHandler(whichCard){
		//zog("cardFlipHandler starts line:173 file:GameContainer.js");
		if (redrawInProgress){
			return;
		}
		if (!assetsLoaded){
			loadAssets(true);
		}
		if (gameContainer.dealingWithMatch){
			gameContainer.dealWithMatch();
		}
		if (gameContainer.dealingWithNoMatch){
			gameContainer.dealWithNoMatch();
		}
		var wasPreviouslySelected = whichCard.previouslySelected;
		gameContainer.dealWithPreviouslySelected();
		if (wasPreviouslySelected){
			return;
		}
		if (whichCard.selected){
			gameContainer.numberOfCardsFlipped++;
			if (gameContainer.numberOfCardsFlipped < 3){
				gameContainer.selectedCards.push(whichCard);
				//gameContainer.zogCards(gameContainer.selectedCards, "line:195 file:GameContainer.js");
			} else {
				//zog("Too many hards selected - flip this one back! line:197 file:GameContainer.js");
				if (!playFaceUp){
					whichCard.turnCard();
				}
				whichCard.toggleHighlight(false);
			}
		} else {
			var cardIndex = gameContainer.selectedCards.indexOf(whichCard);
			if (cardIndex == -1){
				//zog("Not really a flip - no longer in selectedCards line:206 file:GameContainer.js");
			} else {
				gameContainer.selectedCards.splice(cardIndex, 1);
				//gameContainer.zogCards(gameContainer.selectedCards, "line:209 file:GameContainer.js");
				gameContainer.numberOfCardsFlipped--;
			}
		}
		if (gameContainer.numberOfCardsFlipped == 2){
			//zog("check for matches line:214 file:GameContainer.js");
			if (gameContainer.selectedCards.length == 2){
				if (Math.abs(gameContainer.selectedCards[0].representation.decimalValueOf() - gameContainer.selectedCards[1].representation.decimalValueOf()) < 0.001){

					gameContainer.numberOfCardsCleared = gameContainer.numberOfCardsCleared + 2;
					if (gameContainer.numberOfCardsCleared == gameContainer.numberOfQuestions){
						gameContainer.menuLine.instructionLabel.text = localization.gameContainer.matchedAll[localizationIndex];
					} else {
						gameContainer.menuLine.instructionLabel.text = localization.gameContainer.madeAMatch[localizationIndex];
					}
					gameContainer.dealingWithMatch = true;
					if (!playFaceUp){
						gameContainer.selectedCards[0].previouslySelected = true;
						gameContainer.selectedCards[1].previouslySelected = true;
						gameContainer.previouslySelectedCards = [gameContainer.selectedCards[0], gameContainer.selectedCards[1]];
					}
					gameContainer.animateHappyStar();
				} else {
					gameContainer.menuLine.instructionLabel.text = localization.gameContainer.notAMatch[localizationIndex];
					gameContainer.dealingWithNoMatch = true;
					if (!gameContainer.goingHome){
						playGameSound("boing");
					}
				}
			} else {
				zog("Garwsh Mickey line:239 file:GameContainer.js Number selected is: "+gameContainer.selectedCards.length);
			}
		} else if (gameContainer.numberOfCardsFlipped == 0){
			gameContainer.menuLine.instructionLabel.text = localization.gameContainer.pickACard[localizationIndex];
		} else if (gameContainer.numberOfCardsFlipped == 1){
			gameContainer.menuLine.instructionLabel.text = localization.gameContainer.chooseAMatchingCard[localizationIndex];
		}
	}

	animateHappyStar(target){
		//not really necessary just hate that this is not this, if you know what I mean
		if (target != gameContainer){
			gameContainer.animateHappyStar(gameContainer);
			return;
		}
		this.happyStar.sca(0.25);
		this.happyStar.rotation = 0;
		var firstDelay;
		if (playFaceUp){
			firstDelay = 0;
		} else {
			//wait for the second card to flip
			firstDelay = this.selectedCards[0].turningTime;
		}
		this.happyStar.animate({alpha:1, rotation:"360", scale:1, x:this.selectedCards[0].x + cardWidth*0.2, y:this.selectedCards[0].y + cardWidth*0.1}, 500, "linear", this.happyStarAtFirstCard, this, firstDelay);
	}

	happyStarAtFirstCard(e){
		//zog("happyStarAtFirstCard starts line:267 file:GameContainer.js "+e);
		if (!e.goingHome){
			playGameSound("right");
		}

		if (!e.selectedCards[1]){
			//the game is being played real fast!
			//zog("too fast! line:274 file:GameContainer.js");
			e.dealWithMatch();
		} else {
			e.happyStar.rotation = 0;
			e.happyStar.animate({rotation:"720", x:e.selectedCards[1].x + cardWidth*0.2, y:e.selectedCards[1].y + cardWidth*0.1}, 500, "linear", e.happyStarAtSecondCard, e, 1000);
		}
	}

	happyStarAtSecondCard(e){
		//zog("happyStarAtFirstCard starts line:283 file:GameContainer.js "+e);
		timeout(1000, e.dealWithMatch);
	}

	dealWithMatch(){
		//zog("dealWithMatch starts line:288 file:GameContainer.js");
		var seeGameOver = (gameContainer.numberOfCardsCleared == gameContainer.numberOfQuestions);
		if (gameContainer.dealingWithMatch){
			if (playFaceUp || seeGameOver){
				if (gameContainer.selectedCards[0].contentContainer.parent){
					gameContainer.selectedCards[0].contentContainer.parent.removeChild(gameContainer.selectedCards[0].contentContainer);
				}
				if (gameContainer.selectedCards[1].contentContainer.parent){
					gameContainer.selectedCards[1].contentContainer.parent.removeChild(gameContainer.selectedCards[1].contentContainer);
				}
			} else {
				gameContainer.menuLine.instructionLabel.text = localization.gameContainer.madeAMatchLater[localizationIndex];
			}
			gameContainer.finishDealing();
			if (seeGameOver && !gameContainer.goingHome){
				gameOver();
			}
		}
	}

	dealWithNoMatch(){
		if (gameContainer.dealingWithNoMatch){
			gameContainer.selectedCards[0].toggleHighlight(false);
			gameContainer.selectedCards[1].toggleHighlight(false);
			if (!playFaceUp){
				gameContainer.selectedCards[0].turnCard();
				gameContainer.selectedCards[1].turnCard();
			}
			gameContainer.finishDealing();
		}
	}

	finishDealing(){
		//zog("finishDealing starts line:321 file:GameContainer.js");
		if (playFaceUp){
			gameContainer.menuLine.instructionLabel.text = localization.gameContainer.pickACard[localizationIndex];
		}
		gameContainer.selectedCards = [];
		gameContainer.numberOfCardsFlipped = 0;
		gameContainer.dealingWithMatch = false;
		gameContainer.dealingWithNoMatch = false;
		gameContainer.happyStar.pauseAnimate();
		gameContainer.happyStar.alp(0).rot(0);
		stage.update();
	}

	dealWithPreviouslySelected(){
		//zog("dealWithPreviouslySelected starts line:335 file:GameContainer.js");
		var currentCard;
		for (var p=0;p<gameContainer.previouslySelectedCards.length; p++){
			currentCard = gameContainer.previouslySelectedCards[p];
			if (currentCard.contentContainer.parent){
				currentCard.contentContainer.parent.removeChild(currentCard.contentContainer);
			}
			currentCard.previouslySelected = false;
		}
		gameContainer.previouslySelectedCards = [];

		if (gameContainer.numberOfCardsFlipped == 0){
			gameContainer.menuLine.instructionLabel.text = localization.gameContainer.pickACard[localizationIndex];
		} else if (gameContainer.numberOfCardsFlipped == 1){
			gameContainer.menuLine.instructionLabel.text = localization.gameContainer.chooseAMatchingCard[localizationIndex];
		}
	}

	zogCards(cardArray, lineString){
		if (!lineString){
			lineString = "line:355 file:GameContainer.js";
		}
		zog("zogCards "+lineString);
		for(var i=0;i<cardArray.length;i++){
			zog("\t"+cardArray[i].representation.zogString());
		}
	}

	changePlayMode(){
		//zog("changePlayMode starts line:364 file:GameContainer.js");
		redrawInProgress = true;
		if (gameContainer.dealingWithMatch){
			gameContainer.dealWithMatch();
		}
		if (gameContainer.dealingWithNoMatch){
			gameContainer.dealWithNoMatch();
		}
		this.dealWithPreviouslySelected();
		playFaceUp = !playFaceUp;
		var currentCard;
		for(var i=0;i<this.allCards.length;i++){
			currentCard = this.allCards[i];
			if (currentCard.parent){
				if (!currentCard.selected){
					currentCard.turnCard();
				} else {
					currentCard.cardHighlight.visible = playFaceUp;
				}
			}
		}
		redrawInProgress = false;
	}

	startTheSameGameAgain(target){
		//zog("startTheSameGameAgain starts line:389 file:GameContainer.js");
		if (target != gameContainer){
			gameContainer.startTheSameGameAgain(gameContainer);
			return;
		}
		if (gameOverDialog && gameOverDialog.parent){
			//zog("gameOverDialog being removed line:395 file:GameContainer.js");
			gameOverDialog.parent.removeChild(gameOverDialog);
		}
		this.addTo(stage);

		this.finishDealing();
		var myCard;
		for(var i=0;i<this.allCards.length;i++){
			myCard = this.allCards[i];
			myCard.contentContainer.addTo(myCard);
		}
		setCardDimensions(); //in case the window size changed while on the closing screen
		this.menuLine.instructionLabel.text = localization.gameContainer.pickACard[localizationIndex]; //will be preserved by redraw
		this.redraw(!debug);

		this.previouslySelectedCards = [];
		this.numberOfCardsCleared = 0;
		timeout(100, resize); //seem to be having some trouble with this transition
	}

	traceCards(lineString){
		if (!lineString){
			lineString = " line:417 file:GameContainer.js";
		}
		var currentCard;
		for(var i=0;i<this.allCards.length;i++){
			currentCard = this.allCards[i];
			zog(i+": "+currentCard.representation.zogString()+lineString);
		}
	}

	traceQuestionArray(lineString){
		if (!lineString){
			lineString = " line:428 file:GameContainer.js";
		}
		var traceString = "";
		var currentRep;
		for(var i=0;i<questionArray.length;i++){
			currentRep = questionArray[i].representation;
			traceString += questionArray[i].representation.repClassName + " "+questionArray[i].representation.whole + "\n";
		}
		zog(traceString+lineString);
	}

	//for testing
	/*addChild(cont){
		zog("cont: "+cont+" line:441 file:GameContainer.js");
		super.addChild(cont);
	}*/
}