
//This class will show a numeric representation of a fraction.
class GameOverDialog extends Container { // use JS6 extends keyword
	constructor (rectangleInit, backColour) {
		super(); // use JS6 super() to call the Container constructor

		this.distanceToTap = 10;
		this.margin = getMargin();
		this.buttonSize = 40;
		this.gameOverDialogBorderWidth = 10;
		this.name = "GameOverDialog";
		this.drawWidth = frame.width - this.gameOverDialogBorderWidth;
		this.drawHeight = frame.height - this.gameOverDialogBorderWidth;

		//The defaults are below, but if something is passed in it will replace it
		this.rectangleInit = {width:this.drawWidth, height:this.drawHeight, corner:30, color:globalBackgroundColour, borderColor:mathiesBlue, borderWidth:this.gameOverDialogBorderWidth};

		if (rectangleInit != null){
			this.rectangleInit = rectangleInit;
		}

		//We assume a colour was passed and then if not, use the default of white
		this.backColour = backColour;
		if (this.backColour==null){
			this.backColour = "white";//"#2157B0";
		}

		//Let us first draw our backgroundRectangle
		this.backgroundRectangle = new Rectangle(this.rectangleInit).addTo(this);
		this.backgroundRectangle.name = "gameOverDialogBackground";

		//mathies logo
		this.desiredLogoSize = 0.2*Math.min(this.drawWidth,this.drawHeight)
		this.logoWidth = 103;//This is the actual pixel size of the imported logo
		this.logoHeight = 35;
		this.mathiesLogo = new Bitmap("assets/mathieslogoSmall.png", this.logoWidth, this.logoHeight).addTo(this).sca(this.desiredLogoSize/this.logoWidth);
		this.mathiesLogo.mouseEnabled = false; //to prevent cross domain issues

		//Home Button
		var iconProportion = 0.60;
		this.homeButton = new Button({
			icon:new House(this.buttonSize*iconProportion, this.buttonSize*iconProportion*0.8, "white", "black", 1),
			width:this.buttonSize,
			height:this.buttonSize,
			backgroundColor:goButtonGreen,
			rollBackgroundColor:goButtonGreenLight,
			borderWidth:1,
			borderColor:"black",
			gradient:.3,
			corner:this.buttonSize/2
			}).addTo(this).tap(startAtOpeningDialogAgain, this.distanceToTap);
		this.homeButton.icon.loc(this.buttonSize*(1 - iconProportion)/2, this.buttonSize*(1 - iconProportion*0.8)/2);

		//info button
		this.informationButton = new Button({
			label:"",
			width:this.buttonSize,
			height:this.buttonSize,
			backgroundColor:mathiesBlue,
			rollBackgroundColor:mathiesBlueRollover,
			borderWidth:1,
			borderColor:"black",
			gradient:.3,
			corner:this.buttonSize/2
		}).addTo(this).tap(openingDialog.showInformationDialog, this.distanceToTap);

		this.infoLabel = new Label({
			 text:"i",
			 size:28,
			 font:"times new roman",
			 color:"white",
			 fontOptions:"italic bold"
			});
		this.infoLabel.addTo(this.informationButton).center(this.informationButton);
		this.infoLabel.y-=1;

		//Now we create our titles
		this.textContainer = new Container();
		this.textContainer.addTo(this);

		this.titleLabel = new Label({
			text:localization.gameName[localizationIndex],
			size:30,
			font:"arial",
			color:mathiesBlue,
			fontOptions:"bold",
			align:"center"
		});

		this.titleLabel.addTo(this.textContainer);

		//Create subtitle
		this.subTitle = new Label({
			text:localization.gameOverDialog.gameOver[localizationIndex],
			size:24,
			font:"arial",
			color:"black",
			fontOptions:"bold"
		});

		this.subTitle.addTo(this.textContainer);

		//create level Indicator
		this.levelIndicator = new LevelIndicator(24,"black", "bold");
		this.levelIndicator.addTo(this.textContainer);

		//Make the buttons and put them on their own container
		this.buttonContainer = new Container();
		this.buttonContainer.addTo(this);

		this.playAgainText = new Label({
			text:localization.gameOverDialog.playAgain[localizationIndex],
			size:24,
			font:"arial",
			color:"black",
			fontOptions:"bold"
		});

		this.playAgainText.addTo(this.buttonContainer);

		//replay cards - same cards but shuffled
		var replayCardsLabel = new Label({
			text:localization.gameOverDialog.sameCards[localizationIndex],
			size:35,
			backgroundColor:0,
			color:"white",
			fontOptions:"bold"
		});
		this.replayCardsButton = new Button({
			label:replayCardsLabel,
			width:375,
			height:85,
			backgroundColor:mathiesBlue,
			rollBackgroundColor:mathiesBlueRollover,
			borderWidth:2,
			borderColor:"black",
			gradient:.3,
			corner:30
		});

		this.replayCardsButton.tap(gameContainer.startTheSameGameAgain, this.distanceToTap);
		this.replayCardsButton.addTo(this.buttonContainer);

		//replay level - same types of cards, but new values
		var replayLevelLabel = new Label({
			text:localization.gameOverDialog.sameLevel[localizationIndex],
			size:35,
			backgroundColor:0,
			color:"white",
			fontOptions:"bold"
		});
		this.replayLevelButton = new Button({
			label:replayLevelLabel,
			width:375,
			height:85,
			backgroundColor:mathiesBlue,
			rollBackgroundColor:mathiesBlueRollover,
			borderWidth:2,
			borderColor:"black",
			gradient:.3,
			corner:30
		});

		this.replayLevelButton.tap(startWithSameChoices, this.distanceToTap);
		this.replayLevelButton.addTo(this.buttonContainer);

		//new level
		var newLevelLabel = new Label({
			text:localization.gameOverDialog.newLevel[localizationIndex],
			size:35,
			backgroundColor:0,
			color:"white",
			fontOptions:"bold"
		});
		this.newLevelButton = new Button({
			label:newLevelLabel,
			width:375,
			height:85,
			backgroundColor:goButtonGreen,
			rollBackgroundColor:goButtonGreenLight,
			borderWidth:2,
			borderColor:"black",
			gradient:.3,
			corner:30
		});

		this.newLevelButton.tap(startAtOpeningDialogAgain, this.distanceToTap);
		this.newLevelButton.addTo(this.buttonContainer);

		//mathies games
		var mathiesLabel = new Label({
			text:localization.gameOverDialog.mathies[localizationIndex],
			size:35,
			backgroundColor:0,
			color:"white",
			fontOptions:"bold"
		});
		this.mathiesButton = new Button({
			label:mathiesLabel,
			width:375,
			height:85,
			backgroundColor:mathiesLightBlue,
			rollBackgroundColor:mathiesLightBlueRollover,
			borderWidth:2,
			borderColor:"black",
			gradient:.3,
			corner:30
		});

		if (localizationIndex == 0){
			this.mathiesButton.tap(function(){window.open('https://mathies.ca/games.php', '_blank');}, this.distanceToTap);
		} else {
			this.mathiesButton.tap(function(){window.open('https://mathies.ca/francais.php?referringPage=Jeux', '_blank');}, this.distanceToTap);
		}
		this.mathiesButton.addTo(this.buttonContainer);

		timeout(100, this.positionObjectsProxy)
		this.positionObjects();

		//To allow chaining
		return this;
	}

	//We use this proxy so that I can use global this-style references
	positionObjectsProxy(){
		if (gameOverDialog.parent){
			gameOverDialog.positionObjects();
		}
	}

	//Call this function if the window resizes or you need to reposition things
	positionObjects(){

		this.margin = getMargin();

		this.drawWidth = frame.width;
		this.drawHeight = frame.height;

		//So these values can be used later
		this.rectangleInit.width = this.drawWidth - this.gameOverDialogBorderWidth;
		this.rectangleInit.height = this.drawHeight  - this.gameOverDialogBorderWidth;

		//Let us first draw our backgroundRectangle
		if(this.backgroundRectangle.parent){
			this.backgroundRectangle.parent.removeChild(this.backgroundRectangle);
		}
		this.backgroundRectangle = new Rectangle(this.rectangleInit).addTo(this,0);//0 places the rectangle on the bottom layer
		this.backgroundRectangle.x = this.gameOverDialogBorderWidth/2;
		this.backgroundRectangle.y = this.gameOverDialogBorderWidth/2;
		this.backgroundRectangle.name = "gameOverDialogBackground";

		//figure out the aspect ratio
		this.aspectRatio = this.drawWidth/this.drawHeight;

		//allow 15% of the height for the top row of buttons and logo
		var availableLogoHeight = 0.15*(this.backgroundRectangle.height - 2*this.gameOverDialogBorderWidth);

		//first grid lines for testing spacing
		/*if (this.grid && this.grid.parent){
			this.grid.parent.removeChild(this.grid);
		}
		this.grid = new Shape().addTo(this);

		this.grid.graphics.ss(1,"square").s("gray");

		this.grid.graphics.mt(this.gameOverDialogBorderWidth, availableLogoHeight + this.gameOverDialogBorderWidth);
		this.grid.graphics.lt(this.drawWidth, availableLogoHeight + this.gameOverDialogBorderWidth);*/

		//Deal with logo
		this.desiredLogoSize = 0.25*Math.min(this.drawWidth,this.drawHeight);
		this.mathiesLogo.sca(this.desiredLogoSize/this.logoWidth);
		if (this.mathiesLogo.height >availableLogoHeight){
			this.mathiesLogo.sca(1);
			this.mathiesLogo.sca(availableLogoHeight/this.logoHeight);
		}
		this.mathiesLogo.x = 2*this.gameOverDialogBorderWidth;
		this.mathiesLogo.y = this.mathiesLogo.x;

		//size and position home and info buttons
		var maxButtonSize = Math.min(40, this.mathiesLogo.height);
		this.buttonSize = Math.max(20,maxButtonSize);
		this.homeButton.width = this.buttonSize;
		this.homeButton.height = this.buttonSize;
		this.homeButton.x = this.drawWidth - 1.2*this.homeButton.width - this.gameOverDialogBorderWidth;
		this.homeButton.y = 2*this.gameOverDialogBorderWidth;

		this.informationButton.width = this.buttonSize;
		this.informationButton.height = this.buttonSize;
		this.informationButton.x = this.homeButton.x - 1.2*this.informationButton.width;
		this.informationButton.y = this.homeButton.y;

		var remainingHeight = 0.85*(this.backgroundRectangle.height - 2*this.gameOverDialogBorderWidth - this.margin);//remove the top and bottom blue borders and one margin for some space between containers

		if(this.aspectRatio>1.5){//going to make two buttons per row so there are 4 sections
			this.numSections = 3;
			this.sectionProportion = 0.33;
		} else{//going to make a column of 4 buttons so there are 6 sections
			this.numSections = 5;
			this.sectionProportion = 0.2;
		}

		var availableHeight = this.sectionProportion*remainingHeight;

		//draw remaining grid lines to test spacing
		/*for(var i = 0; i < this.numSections; i++){
			this.grid.graphics.mt(this.gameOverDialogBorderWidth , this.gameOverDialogBorderWidth + availableLogoHeight + availableHeight*(i+1));
			this.grid.graphics.lt(this.drawWidth , this.gameOverDialogBorderWidth + availableLogoHeight + availableHeight*(i+1));
		}*/

		//set all text using the correct localization so things centre properly
		this.titleLabel.text = localization.gameName[localizationIndex];
		this.subTitle.text = localization.gameOverDialog.gameOver[localizationIndex];
		this.levelIndicator.text = localization.level[localizationIndex] + " " + localization.levelDescriptions[localizationIndex][currentLevel];
		this.playAgainText.text = localization.gameOverDialog.playAgain[localizationIndex];
		this.replayCardsButton.label.text = localization.gameOverDialog.sameCards[localizationIndex];
		this.replayLevelButton.label.text = localization.gameOverDialog.sameLevel[localizationIndex];
		this.newLevelButton.label.text = localization.gameOverDialog.newLevel[localizationIndex];
		this.mathiesButton.label.text = localization.gameOverDialog.mathies[localizationIndex];

		//for scaling the containers
		var horScale;
		var vertScale;
		var newScale;

		//scale and position textContainer
		this.textContainer.sca(1);

		this.titleLabel.x =this.titleLabel.width/2;
		this.titleLabel.y = 0;

		this.subTitle.x = (this.titleLabel.width - this.subTitle.width)/2;
		this.subTitle.y = this.titleLabel.y + this.titleLabel.height + this.margin;

		this.levelIndicator.x = (this.titleLabel.width - this.levelIndicator.width)/2;
		this.levelIndicator.y = this.subTitle.y + this.subTitle.height + this.margin;

		var availableWidth = this.drawWidth - 6*this.gameOverDialogBorderWidth;
		if(this.textContainer.width > availableWidth || this.textContainer.height > availableHeight){
			horScale = availableWidth/this.textContainer.width;
			vertScale = availableHeight/this.textContainer.height;
			newScale = Math.min(horScale,vertScale);
			this.textContainer.sca(newScale);
		}

		this.textContainer.x = (this.drawWidth - this.textContainer.width)/2;
		this.textContainer.y = availableLogoHeight + this.gameOverDialogBorderWidth;

		//scale the buttonContainer
		var availableButtonHeight
		availableWidth = 0.7*this.drawWidth;
		if(this.aspectRatio>1.5){//going to make two buttons per row
			availableButtonHeight = 2*availableHeight;
		} else{//going to make a column of 4 buttons
			availableButtonHeight = 4*availableHeight;
		}

		this.buttonContainer.sca(1);

		this.playAgainText.x = 0;
		this.playAgainText.y = 0;//this.margin;

		this.replayCardsButton.x = 0;
		this.replayCardsButton.y = this.playAgainText.y + this.playAgainText.height + 2*this.margin;

		//position the other buttons and the container
		if (this.aspectRatio > 1.5){//make 2 rows of buttons

			this.replayLevelButton.x = this.replayCardsButton.x;
			this.replayLevelButton.y = this.replayCardsButton.y + this.replayLevelButton.height + 2*this.margin;

			this.newLevelButton.x = this.replayCardsButton.width + 2*this.margin;
			this.newLevelButton.y = this.replayCardsButton.y;

			this.mathiesButton.x = this.newLevelButton.x;
			this.mathiesButton.y = this.newLevelButton.y + this.mathiesButton.height + 2*this.margin;

		} else {//make a column of 4 buttons

			this.replayLevelButton.x = this.replayCardsButton.x;//0;
			this.replayLevelButton.y = this.replayCardsButton.y + this.replayLevelButton.height + 2*this.margin;

			this.newLevelButton.x = this.replayCardsButton.x;//0;
			this.newLevelButton.y = this.replayLevelButton.y + this.newLevelButton.height + 2*this.margin;

			this.mathiesButton.x = this.replayCardsButton.x;//0;
			this.mathiesButton.y = this.newLevelButton.y + this.mathiesButton.height + 2*this.margin;

		}

		if (this.buttonContainer.width > availableWidth || this.buttonContainer.height > availableButtonHeight){
			horScale = availableWidth/this.buttonContainer.width;
			vertScale = availableButtonHeight/this.buttonContainer.height;
			newScale = Math.min(horScale,vertScale);
			this.buttonContainer.sca(newScale);
		}

		if (this.aspectRatio > 1.5){
			this.buttonContainer.y = this.gameOverDialogBorderWidth + availableLogoHeight +this.margin + availableHeight*2 - this.buttonContainer.height/2;
		} else {
			this.buttonContainer.y = this.gameOverDialogBorderWidth + availableLogoHeight +this.margin + availableHeight*3 - this.buttonContainer.height/2;
		}

		this.buttonContainer.x = (this.drawWidth - this.buttonContainer.width)/2;

		if(matchInformationDialog && matchInformationDialog.parent){
			openingDialog.showInformationDialog();
		}

		frame.stage.update();
	}
}