class GingerBreadPerson extends Container {
	constructor (personHeight, personFillColour, personOutlineColour, personOutlineThickness, showFace){

		super();

		if (personHeight == null){
			this.drawHeight = 50;
		} else {
			this.drawHeight = personHeight;
		}
		this.widthPercent = 1;
		this.drawWidth = this.widthPercent*this.drawHeight;

		if (personFillColour == null){
			this.personFillColour = yellow;
		} else {
			this.personFillColour = personFillColour;
		}

		if (personOutlineColour == null){
			this.personOutlineColour = yellow;
		} else {
			this.personOutlineColour = personOutlineColour;
		}

		if (personOutlineThickness == null){
			this.personOutlineThickness = 2;
		} else {
			this.personOutlineThickness = personOutlineThickness;
		}

		if (showFace == null){
			this.showFace = false;
		} else {
			this.showFace = showFace;
		}

		var degree = Math.PI/180;
		var angle = -90;

		this.body = new Shape().addTo(this);
		this.body.graphics.ss(this.personOutlineThickness).s(this.personOutlineColour).f(this.personFillColour);
		var rWid = this.drawWidth;
		var rHt = this.drawHeight;

		//from as2 class
		//head
		this.body.graphics.moveTo(0.3596 * rWid,0.315 * rHt);
		this.body.graphics.curveTo(0.1936 * rWid,0.16 * rHt, 0.3596 * rWid,0.048 * rHt);
		this.body.graphics.curveTo(0.5118 * rWid,-0.02 * rHt, 0.6680 * rWid,0.048 * rHt);
		this.body.graphics.curveTo(0.8299 * rWid,0.183 * rHt, 0.6680 * rWid,0.318 * rHt);

		//right arm
		this.body.graphics.curveTo(0.7607 * rWid,0.31 * rHt, 0.9170 * rWid,0.345 * rHt);
		this.body.graphics.curveTo(1.0789 * rWid,0.45 * rHt, 0.9170 * rWid,0.533 * rHt);
		this.body.graphics.curveTo(0.7607 * rWid,0.545 * rHt, 0.6777 * rWid,0.525 * rHt);

		//right leg
		this.body.graphics.lineTo(0.8340 * rWid,0.753 * rHt);
		this.body.graphics.curveTo(0.9682 * rWid,0.72 * rHt, 0.9862 * rWid,0.805 * rHt);
		this.body.graphics.curveTo(1 * rWid,0.875 * rHt, 0.8686 * rWid,0.923 * rHt);
		this.body.graphics.curveTo(0.7607 * rWid,0.935 * rHt, 0.6819 * rWid,0.925 * rHt);
		this.body.graphics.curveTo(0.6155 * rWid,0.92 * rHt, 0.5851 * rWid,0.878 * rHt);
		this.body.graphics.lineTo(0.5021 * rWid,0.778 * rHt);

		//left leg
		this.body.graphics.lineTo(0.4191 * rWid,0.878 * rHt);
		this.body.graphics.curveTo(0.3734 * rWid,0.92 * rHt, 0.3250 * rWid,0.925 * rHt);
		this.body.graphics.curveTo(0.2490 * rWid,0.935 * rHt, 0.1521 * rWid,0.925 * rHt);
		this.body.graphics.curveTo(0.0595 * rWid,0.9 * rHt, 0.0277 * rWid,0.838 * rHt);
		this.body.graphics.curveTo(0, 0.763 * rHt, 0.0941 * rWid,0.75 * rHt);
		this.body.graphics.curveTo(0.1107 * rWid,0.74 * rHt, 0.1632 * rWid,0.753 * rHt);
		this.body.graphics.curveTo(0.2946 * rWid,0.628 * rHt, 0.3292 * rWid,0.518 * rHt);

		//left arm
		this.body.graphics.curveTo(0.1383 * rWid,0.548 * rHt, 0.1217 * rWid, 0.538 * rHt);
		this.body.graphics.curveTo(0, 0.45 * rHt, 0.1217 * rWid,0.335 * rHt);
		this.body.graphics.curveTo(0.1798 * rWid,0.3 * rHt, 0.3596 * rWid,0.315 * rHt);


		if (showFace){
			this.happyFace = new Shape().addTo(this);
			this.happyFace.graphics.ss(1).s("rgba(0,0,0,0)").f(this.personOutlineColour);
			//eyes
			this.happyFace.graphics.drawEllipse(this.drawWidth*0.39, this.drawHeight*0.12, this.drawWidth*0.08, this.drawHeight*0.12);
			this.happyFace.graphics.drawEllipse(this.drawWidth*0.53, this.drawHeight*0.12, this.drawWidth*0.08, this.drawHeight*0.12);

			//mouth
			this.happyFace.graphics.ss(2).s("#000000").f(this.personOutlineColour);
			this.happyFace.graphics.moveTo(0.44*this.drawWidth, 0.3*this.drawHeight);
			this.happyFace.graphics.curveTo(0.5*this.drawWidth, 0.4*this.drawHeight, 0.56*this.drawWidth, 0.3*this.drawHeight);
		}
		this.resetBounds(0,0,this.drawHeight,this.widthPercent*this.drawHeight);

		return this;
	}
}