class HappyFace extends Container {
	constructor (radius, faceColour, faceOutlineColour, faceOutlineThickness, showFace){

		super();

		if (radius == null){
			this.outerRadius = 20;
		} else {
			this.outerRadius = radius;
		}

		this.innerRadius = 0.8*this.outerRadius;

		if (faceColour == null){
			this.faceColour = yellow;
		} else {
			this.faceColour = faceColour;
		}

		if (faceOutlineColour == null){
			this.faceOutlineColour = yellow;
		} else {
			this.faceOutlineColour = faceOutlineColour;
		}

		if (faceOutlineThickness == null){
			this.faceOutlineThickness = 2;
		} else {
			this.faceOutlineThickness = faceOutlineThickness;
		}

		if (showFace == null){
			this.showFace = false;
		} else {
			this.showFace = showFace;
		}

		var degree = Math.PI/180;
		var angle = -90;

		this.happyFace = new Circle(this.outerRadius, this.faceColour, this.faceOutlineColour, this.faceOutlineThickness).addTo(this);

		if (showFace){
			this.happyFace = new Shape().addTo(this);

			//left eye
			this.happyFace.graphics.ss(this.faceOutlineThickness).s(this.faceOutlineColour).f(this.faceOutlineColour).de(-this.innerRadius*0.35, -this.innerRadius*0.45, this.innerRadius*0.15, this.innerRadius*0.25);
			//right eye
			this.happyFace.graphics.de(this.innerRadius*0.35, -this.innerRadius*0.45, this.innerRadius*0.15, this.innerRadius*0.25);
			//smile
			this.happyFace.graphics.mt(-this.innerRadius*0.30, this.innerRadius*0.20).qt(0, this.innerRadius*1.15, this.innerRadius*0.4, this.innerRadius*0.30).qt(0, this.innerRadius*0.7, -this.innerRadius*0.30, this.innerRadius*0.20).es;
		}
		//this.resetBounds(0,0,this.outerRadius*2,this.outerRadius*2);

		return this;
	}
}