class House extends Container {
	constructor (drawWidth, drawHeight, houseColour, houseOutlineColour, houseOutlineThickness){

		super();

		if (drawWidth == null) {
			this.drawWidth = 30;
		} else {
			this.drawWidth = drawWidth;
		}

		if (drawHeight == null) {
			this.drawHeight = 30;
		} else {
			this.drawHeight = drawHeight;
		}

		if (houseColour == null) {
			this.houseColour = "lightblue";
		} else {
			this.houseColour = houseColour;
		}

		if (houseOutlineColour == null) {
			this.houseOutlineColour = "gray";
		} else {
			this.houseOutlineColour = houseOutlineColour;
		}

		if (houseOutlineThickness == null) {
			this.houseOutlineThickness = 1;
		} else {
			this.houseOutlineThickness = houseOutlineThickness;
		}

		this.house = new Shape().addTo(this);
		//start at the peak of the house
		this.house.graphics.ss(this.houseOutlineThickness).s(this.houseOutlineColour).f(this.houseColour).mt(this.drawWidth/2, 0);
		//right half of roof
		this.house.graphics.lt(this.drawWidth, 0.4*this.drawHeight);
		this.house.graphics.lt(0.8*this.drawWidth, 0.4*this.drawHeight);
		//base of house
		this.house.graphics.lt(0.8*this.drawWidth, this.drawHeight);
		this.house.graphics.lt(0.2*this.drawWidth, this.drawHeight);
		this.house.graphics.lt(0.2*this.drawWidth, 0.4*this.drawHeight);
		//left half of roof
		this.house.graphics.lt(0, 0.4*this.drawHeight);
		this.house.graphics.lt(this.drawWidth/2, 0);
		this.house.graphics.es;
		//door
		this.house.graphics.ss(this.houseOutlineThickness).s(this.houseOutlineColour).f(this.houseOutlineColour);
		this.house.graphics.rect(0.4*this.drawWidth, 0.7*this.drawHeight, 0.2*this.drawWidth, 0.3*this.drawHeight);
	}
}