
//This class will show a numeric representation of a fraction.
class InformationDialog extends Container { // use JS6 extends keyword
	constructor (rectangleInit) {
		super(); // use JS6 super() to call the Container constructor

      	//This is the border we are
      	this.InformationDialogBorderWidth = 10;

		//The defaults are below, but if something is passed in it will replace it
		this.rectangleInit = {width:frame.width - this.InformationDialogBorderWidth, height:frame.height - this.InformationDialogBorderWidth, corner:30, color:globalBackgroundColour, borderColor:"#2157B0", borderWidth:this.InformationDialogBorderWidth};

		//So these values can be used later
		this.drawWidth = this.rectangleInit.width;
		this.drawHeight = this.rectangleInit.height;

		//Let us first draw our backgroundRectangle (this is recreated in the position)
		this.backgroundRectangle = new Rectangle(this.rectangleInit).addTo(this);
		this.backgroundRectangle.name = "InformationDialogBackground";

		//Going to scale our logo to be the size we want it to be
		this.desiredLogoSize = 0.25*Math.min(this.drawWidth,this.drawHeight)
		this.logoWidth = 103;//This is the actual pixel size of the imported logo
		this.logoHeight = 35;
		this.mathiesLogo = new Bitmap("assets/mathieslogoSmall.png", this.logoWidth, this.logoHeight).addTo(this).sca(this.desiredLogoSize/this.logoWidth);
		this.mathiesLogo.mouseEnabled = false; //to prevent cross domain issues
		this.mathiesLogo.x = getMargin();
		this.mathiesLogo.y = this.mathiesLogo.x;

		//To allow chaining
		return this;
	}
}