
//This class shows the information dialog.
class MatchInformationDialog extends Container { // use JS6 extends keyword
	constructor (rectangleInit) {
		super(); // use JS6 super() to call the Container constructor

		//This is the border we are
		this.dialogDrawWidth = localizationIndex==0?600:620;
		this.dialogDrawHeight = 1;

		this.buttonWidths = [[250,250,250],[250,320,250]];

		//The defaults are below, but if something is passed in it will replace it
		this.backgroundRectangle = new Rectangle(
			{width:frame.width,
			 height:frame.height,
			 color:black}).addTo(this).tap(this.closeMe);
		this.backgroundRectangle.alpha = 0.7;

		this.titleBar = new Rectangle({width:this.dialogDrawWidth,
			 height:30,
			 color:mathiesBlue,
			 borderColor:"black",
			 borderWidth:1}).addTo(this);
		this.titleBar.mouseChildren = true;

		this.closeButton = new Button({
			label:"x",
			width:23,
			height:23,
			color:"white",
			backgroundColor:"#444444",
			rollBackgroundColor:"#555555",
			borderWidth:1,
			borderColor:"black",
			gradient:.3,
			corner:0

		}).addTo(this.titleBar).tap(this.closeMe);
		this.closeButton.x = this.dialogDrawWidth - this.closeButton.width -3;
		this.closeButton.y = 3;
		this.closeButton.label.size = 16;
		this.closeButton.label.y-=1;

		this.infoLabel = new Label({
		 text:localization.informationDialog.informationTitle[localizationIndex],
		 size:20,
		 font:"arial",
		 color:"white"
		 //outlineColor:darkBlack,
		// outlineWidth:3
		}).addTo(this.titleBar);
		this.infoLabel.x = this.dialogDrawWidth - this.infoLabel.width - 2*getMargin() - this.closeButton.width;
		this.infoLabel.y = 5;

		this.titleLabel = new Label({
		 text:localization.informationDialog.infoDialogTitle[localizationIndex],
		 size:20,
		 font:"arial",
		 color:"white"
		 //outlineColor:darkBlack,
		// outlineWidth:3
		}).addTo(this.titleBar);
		this.titleLabel.x = getMargin();
		this.titleLabel.y = 5;

		//Support Page Button
		this.feedbackButton = new Button({
			label:localization.informationDialog.feedbackButton[localizationIndex],
			width:this.buttonWidths[localizationIndex][1],
			height:40,
			backgroundColor:mathiesBlue,
			rollBackgroundColor:mathiesBlueRollover,
			borderWidth:2,
			borderColor:"black",
			gradient:.3,
			corner:20
		}).addTo(this).tap(this.feedbackButtonClicked);
		this.feedbackButton.label.size = 25;

		//Label that gives copyright
		this.copyrigthLabel = new Label({
		 text:localization.informationDialog.copyright[localizationIndex],
		 size:20,
		 lineHeight:24,
		 font:"arial",
		 color:"black"
		}).addTo(this);

		//more tools available
		this.moreToolsAvailableLabel = new Label({
		 text:localization.informationDialog.infoDialogMoreAvailable[localizationIndex],
		 size:20,
		 font:"arial",
		 color:"black"
		}).addTo(this);

		//Support Page Button
		this.mathiesToolsButton = new Button({
			label:localization.informationDialog.mathiesToolsButton[localizationIndex],
			width:this.buttonWidths[localizationIndex][2],
			height:40,
			backgroundColor:mathiesBlue,
			rollBackgroundColor:mathiesBlueRollover,
			borderWidth:2,
			borderColor:"black",
			gradient:.3,
			corner:20
		}).addTo(this).tap(this.mathiesToolsButtonClicked);
		this.mathiesToolsButton.label.size = 25;

		//Now we space out all the objects so we can get an accurate height measurement
		this.positionAllObjects();

		this.dialogDrawHeight = this.mathiesToolsButton.y + this.mathiesToolsButton.height + getMargin();
		//this.dialogDrawWidth = this.copyrigthLabel.width + 2*getMargin();

		//Create the content container with the correct height and width
		this.contentContainter = new Rectangle(
			{width:this.dialogDrawWidth,
			 height:this.dialogDrawHeight,
			 color:"white",
			 borderColor:"black",
			 borderWidth:3}).addTo(this);
		this.contentContainter.x = 0.5*(frame.width - this.contentContainter.width);
		this.contentContainter.y = 0.5*(frame.height - this.contentContainter.height);
		this.contentContainter.mouseChildren = true;
		this.mathiesToolsButton.addTo(this.contentContainter);

		this.titleBar.addTo(this.contentContainter);
		this.moreToolsAvailableLabel.addTo(this.contentContainter);
		this.feedbackButton.addTo(this.contentContainter);
		this.copyrigthLabel.addTo(this.contentContainter);
		this.moreToolsAvailableLabel.addTo(this.contentContainter);

		this.positionAllObjects();

		var newScale = 1;
		if(this.contentContainter.width>(0.8*frame.width)){
			newScale=(0.8*frame.width/this.contentContainter.width);
		}
		if(this.contentContainter.height>(0.8*frame.height)){
			newScale=(0.8*frame.height/this.contentContainter.height);
		}
		if(newScale<1){
			this.contentContainter.sca(newScale);
			this.contentContainter.x = (frame.width - this.contentContainter.width)/2;
			this.contentContainter.y = (frame.height - this.contentContainter.height)/2;
		}

		//To allow chaining
		return this;
	}

	positionAllObjects(){
		this.titleBar.x = 0;
		this.titleBar.y = 0;
		this.objectVerticalSpacing = 20;

		this.feedbackButton.x = (this.dialogDrawWidth - this.feedbackButton.width)/2;
		this.feedbackButton.y = this.titleBar.height + this.objectVerticalSpacing;

		this.copyrigthLabel.x = (this.dialogDrawWidth - this.copyrigthLabel.width)/2;
		this.copyrigthLabel.y = this.feedbackButton.y + this.feedbackButton.height + this.objectVerticalSpacing;

		this.moreToolsAvailableLabel.x = (this.dialogDrawWidth - this.moreToolsAvailableLabel.width)/2;
		this.moreToolsAvailableLabel.y = this.copyrigthLabel.y + this.copyrigthLabel.height + this.objectVerticalSpacing;

		this.mathiesToolsButton.x = (this.dialogDrawWidth - this.mathiesToolsButton.width)/2;
		this.mathiesToolsButton.y = this.moreToolsAvailableLabel.y + this.moreToolsAvailableLabel.height + this.objectVerticalSpacing;
	}

	supportButtonClicked(){
		//zog("supportButtonClicked - line:174 file:MatchInformationDialog.js");
		if(localizationIndex==0){
			var win=window.open("https://support.mathies.ca/en/mainSpace/mathiesTools.php", '_blank');
		} else {
			var win=window.open("https://support.mathies.ca/fr/mainSpace/Outils_mathies.php", '_blank');
		}
	}

	feedbackButtonClicked(){
		//zog("feedbackButtonClicked - line:183 file:MatchInformationDialog.js");
		if(localizationIndex==0){
			var win=window.open("https://oame.on.ca/clips/feedback.htm?tool=FractionMatch", '_blank');
		} else {
			var win=window.open("https://oame.on.ca/clips/retroaction.htm?tool=FractionMatch", '_blank');
		}
	}

	mathiesToolsButtonClicked(){
		//zog("mathiesToolsButtonClicked - line:192 file:MatchInformationDialog.js");
		if(localizationIndex==0){
			var win=window.open("https://mathies.ca/games.php", '_blank');
		} else {
			var win=window.open("https://mathies.ca/francais.php?referringPage=Jeux", '_blank');
		}
	}

	closeMe(){
		if(matchInformationDialog.parent){
			matchInformationDialog.parent.removeChild(matchInformationDialog)
		}
		stage.update();
	}
}