
//This class will show a numeric representation of a fraction.
class MenuLine extends Container { // use JS6 extends keyword
	constructor () {
		super(); // use JS6 super() to call the Container constructor
		this.name = "MenuLine";

		this.instructionLabel = new Label({
			text:localization.gameContainer.pickACard[localizationIndex],
			size:this.getLabelSize(),
			font:fontFace,
			color:"white",
			fontOptions:"bold"
		});

		//To allow chaining
		return this;
	}

	position(maxX){
		var margin = getMargin();
		this.buttonSize = Math.floor(menuHeight*0.85);

		//the background of the menuLine
		if (this.contentContainer){
			this.contentContainer.parent.removeChild(this.contentContainer);
		}
		this.contentContainer = new Rectangle({width:maxX, height:menuHeight, color:"#2157B0", borderColor:"black", borderWidth:1});
		this.contentContainer.addTo(this);
		this.contentContainer.mouseChildren = true;

		//size and position the instructionLabel
		this.instructionLabel.addTo(this.contentContainer);
		this.instructionLabel.size = this.getLabelSize();
		this.instructionLabel.x = margin;
		this.instructionLabel.y = menuHeight/2 - this.instructionLabel.height/2;

		//the flip button
		var iconProportion = 0.60;
		this.cardScaleFactor = this.buttonSize*iconProportion/cardWidth;
		var cardInit = this.parent.getCardInit();
		cardInit.borderWidth = Math.round(1/this.cardScaleFactor); //beef up the dark border for contrast
		this.flipButton = new Button({
			icon:new FlipCard(cardInit),
			width:this.buttonSize,
			height:this.buttonSize,
			backgroundColor:outerColor,
			rollBackgroundColor:darkWhite,
			borderWidth:1,
			borderColor:"black",
			gradient:.3,
			corner:this.buttonSize/2,
			}).addTo(this.contentContainer).tap(this.togglePlayMode, menuHeight/2);
		this.flipButton.icon.sca(this.cardScaleFactor);
		this.flipButton.icon.center();
		if (playFaceUp){
			this.flipButton.icon.instantFlip(); //treated the opposite of the current situation
		}
		this.flipButton.x = this.contentContainer.width - 3*this.buttonSize;
		this.flipButton.y = menuHeight/2 - this.buttonSize/2;
		this.flipButton.name = "Menu Flip Button";
		this.drawArrowsOnFlipButton();

		//Home Button
		var iconProportion = 0.60;
		this.homeButton = new Button({
			icon:new House(this.buttonSize*iconProportion, this.buttonSize*iconProportion*0.8, "white", "black", 1),
			width:this.buttonSize,
			height:this.buttonSize,
			backgroundColor:goButtonGreen,
			rollBackgroundColor:goButtonGreenLight,
			borderWidth:1,
			borderColor:"black",
			gradient:.3,
			corner:this.buttonSize/2,
			}).addTo(this.contentContainer).tap(this.homeButtonTapHandler, menuHeight/2);
		this.homeButton.icon.loc(this.buttonSize*(1 - iconProportion)/2, this.buttonSize*(1 - iconProportion*0.8)/2);
		this.homeButton.x = this.contentContainer.width - 1.5*this.buttonSize;
		this.homeButton.y = menuHeight/2 - this.buttonSize/2;

		timeout(100, this.waitForImage);
		timeout(2500, this.waitForImage); //if takes a while to load
	}

	homeButtonTapHandler(e){
		//zog("homeButtonTapHandler starts line:86 file:MenuLine.js");
		gameContainer.goingHome = true;
		startAtOpeningDialogAgain();
	}

	getLabelSize(){
		var proportion = 0.5;
		if (localizationIndex == 1){
			proportion = 0.38;
		}
		var labelSize = Math.floor(Math.min(menuHeight*proportion, 40));
		//zog("labelSize: "+labelSize+" line:98 file:MenuLine.js");

		if (this.contentContainer){
			labelSize = Math.floor(Math.min(labelSize, (this.contentContainer.width - 3.5*this.buttonSize)*proportion/7));
			//zog("labelSize: "+labelSize+" line:102 file:MenuLine.js");
		}
		labelSize = Math.max(labelSize, 6);
		return labelSize;
	}

	togglePlayMode(e){
		gameContainer.menuLine.flipButton.icon.turnCard();
		gameContainer.changePlayMode();
	}

	waitForImage(){
		stage.update();
	}

	drawArrowsOnFlipButton(){
		var arrow1 = new Arrow(cardWidth*0.8, null, null, cardWidth/10);
		arrow1.addTo(this.flipButton.icon.cardBack).loc(cardWidth*.1, cardWidth*.25);
		var arrow2 = new Arrow(cardWidth*0.8, null, null, cardWidth/10, "left");
		arrow2.addTo(this.flipButton.icon.cardBack).loc(cardWidth*.1, cardWidth*.75);
		var arrow3 = new Arrow(cardWidth*0.8, white, white, cardWidth/10);
		arrow3.addTo(this.flipButton.icon.cardFront).loc(cardWidth*.1, cardWidth*.25);
		var arrow4 = new Arrow(cardWidth*0.8, white, white, cardWidth/10, "left");
		arrow4.addTo(this.flipButton.icon.cardFront).loc(cardWidth*.1, cardWidth*.75);
		stage.update();
	}
}