
//This class will show a numeric representation of a fraction.
class OpeningDialog extends Container { // use JS6 extends keyword
	constructor (rectangleInit) {
		super(); // use JS6 super() to call the Container constructor

		//we are creating a new openingDialog every time we start a new game selection so set playFaceUp to true
		this.startFaceUp = playFaceUp; //This is to make sure that the setting prevails across games
		playFaceUp = true;
		this.distanceToTap = 10;

		//This is the border we are
		this.openingDialogBorderWidth = 10;
		this.openingDialogButtonSize = 40;
		this.aspectRatio = frame.width/frame.height;

		if(mobile()=="ios" && this.aspectRatio>0.7 && this.aspectRatio < 1.6){
			//If this is an iPad, beef up the buttons a bit
			this.openingDialogButtonSize = 55;
		}

		//The defaults are below, but if something is passed in it will replace it
		this.rectangleInit = {width:frame.width - this.openingDialogBorderWidth, height:frame.height - this.openingDialogBorderWidth, corner:30, color:globalBackgroundColour, borderColor:"#2157B0", borderWidth:this.openingDialogBorderWidth};
		this.representationValuesArray = [5, 7, 12, 34];

		this.cardOptions = [];	//Will store all our cards
		this.cardIndex = -1;	//The current selection on the radio button for level

		//So these values can be used later
		this.drawWidth = this.rectangleInit.width;
		this.drawHeight = this.rectangleInit.height;

		this.soundButton = this.makeButton("sound", "mute").addTo(this).tap(this.soundButtonHandler, this.distanceToTap);
		if (muteAllSounds){
			//get the toggleIcon showing
			this.soundButton.toggle();
		}

		//Let us first draw our backgroundRectangle (this is recreated in the position)
		this.backgroundRectangle = new Rectangle(this.rectangleInit).addTo(this);
		this.backgroundRectangle.name = "openingDialogBackground";

		//Going to scale our logo to be the size we want it to be
		this.desiredLogoSize = 0.2*Math.min(this.drawWidth,this.drawHeight)
		this.logoWidth = 103;//This is the actual pixel size of the imported logo
		this.logoHeight = 35;
		this.mathiesLogo = new Bitmap("assets/mathieslogoSmall.png", this.logoWidth, this.logoHeight).addTo(this).sca(this.desiredLogoSize/this.logoWidth);
		this.mathiesLogo.mouseEnabled = false; //to prevent cross domain issues
		this.mathiesLogo.x = getMargin();
		this.mathiesLogo.y = this.mathiesLogo.x;

		this.playButtonHeight= 57;
		this.playButtonWidth = 125;

		//These are our green and grey play buttons
		this.playButton = new Button({
			label:localization.play[localizationIndex],
			width:this.playButtonWidth,
			height:this.playButtonHeight,
			backgroundColor:goButtonGreen,
			rollBackgroundColor:goButtonGreenLight,
			borderWidth:1,
			borderColor:"black",
			gradient:.3,
			corner:20
		}).addTo(this).tap(this.playButtonClicked, this.distanceToTap);

		this.playButtonDisabled = new Button({
			label:localization.play[localizationIndex],
			width:this.playButtonWidth,
			height:this.playButtonHeight,
			backgroundColor:"grey",
			rollBackgroundColor:"grey",
			borderWidth:1,
			borderColor:"black",
			gradient:.3,
			corner:20
		}).addTo(this);
		this.playButtonDisabled.alp(0.3).tap(this.pulseSecondText, this.distanceToTap);

		//the flip button
		var iconProportion = 0.60;
		this.cardScaleFactor = this.openingDialogButtonSize*iconProportion/cardWidth;
		var cardInit = {width:cardWidth, height:cardHeight, corner:cardWidth*0.2, color:"#2157B0", borderColor:"black"};
		cardInit.borderWidth = Math.round(1/this.cardScaleFactor); //beef up the dark border for contrast
		this.faceUpButton = new Button({
			icon:new FlipCard(cardInit),
			width:this.openingDialogButtonSize,
			height:this.openingDialogButtonSize,
			backgroundColor:outerColor,
			rollBackgroundColor:darkWhite,
			borderWidth:1,
			borderColor:"black",
			gradient:.3,
			corner:this.openingDialogButtonSize/2,
			}).addTo(this).tap(this.togglePlayMode, this.distanceToTap);
		this.faceUpButton.icon.sca(this.cardScaleFactor);
		this.faceUpButton.icon.center();

		this.faceUpButton.name = "Menu Flip Button";
		this.drawArrowsOnfaceUpButton();

		this.faceUpLabel = new Label({
		 text:localization.faceUp[localizationIndex],
		 size:18,
		 font:"arial",
		 color:"black",
		 fontOptions:"bold"
		 //outlineColor:darkBlack,
		 //outlineWidth:1
		}).addTo(this);
		this.faceUpLabel.x = this.faceUpButton.width*1.2;
		this.faceUpButton.label = this.faceUpLabel;

		//Now we create our title
		//The label showing the wholeLabel
		this.titleLabel = new Label({
			text:localization.gameName[localizationIndex],
			size:30,
			font:"arial",
			color:mathiesBlue,
			fontOptions:"bold",
			align:"center"
			//outlineColor:darkBlack,
			// outlineWidth:3
		});
		this.titleLabel.addTo(this);

		//The label showing the first instruction in english or french
		this.firstInstructionLabel = new Label({
			text:localization.openingDialogTitle[localizationIndex],
			size:24,
			font:"arial",
			color:darkBlack,
			fontOptions:"bold"
		});

		this.firstInstructionLabel.addTo(this);

		//The secondary instructions for when they choose a level
		this.secondInstructionLabel = new Label({
			text:localization.openingDialogSecondInstruction[localizationIndex],
			size:24,
			font:"arial",
			color:darkBlack,
			fontOptions:"bold"
		});

		this.secondInstructionLabel.addTo(this);

		//Let's create our options radio buttons
		var optionButtonSize = 50;
		this.levelOptions = [];
		for(var j=0;j<2;j++){
			this.levelOptions.push(new RadioButtons(optionButtonSize, copyArray(localization.levelDescriptions[j]), true, "white", "white"));
			this.currentLevelOptions = this.levelOptions[j];
			this.currentLevelOptions.openingDialog = this; //making sure that our radio button has a reference to this dialog

			//Make sure that we catch the event when the options are changed
			this.currentLevelOptions.on("change", this.changeLevelChoice);
			this.name = "OpeningDialog";
		}
		this.currentLevelOptions = this.levelOptions[localizationIndex];

		//Now we are going to build a rounded rectangle for the options to go on
		this.levelOptionsRectangle = new Rectangle({width:this.currentLevelOptions.width*1.1, height:this.currentLevelOptions.height*1.1, corner:10, color:"#2157B0", borderColor:"black", borderWidth:3}).addTo(this);
		this.currentLevelOptions.addTo(this.levelOptionsRectangle).center(this.levelOptionsRectangle);
		this.levelOptionsRectangle.mouseChildren=true;

		//This is the language changing button
		this.languageButton = new Button({
			label:"fr",
			width:this.openingDialogButtonSize,
			height:this.openingDialogButtonSize,
			backgroundColor:mathiesBlue,
			rollBackgroundColor:mathiesBlueRollover,
			borderWidth:1,
			borderColor:"black",
			gradient:.3,
			corner:this.openingDialogButtonSize/2
		}).addTo(this).tap(this.changeLanguage, this.distanceToTap);
		this.languageButton.label.size = 28;

		this.informationButton = new Button({
			label:"",
			width:this.openingDialogButtonSize,
			height:this.openingDialogButtonSize,
			backgroundColor:mathiesBlue,
			rollBackgroundColor:mathiesBlueRollover,
			borderWidth:1,
			borderColor:"black",
			gradient:.3,
			corner:this.openingDialogButtonSize/2
		}).addTo(this).tap(this.showInformationDialog, this.distanceToTap);

		this.infoLabel = new Label({
			 text:"i",
			 size:28,
			 font:"times new roman",
			 color:"white",
			 fontOptions:"italic bold"
			});
		this.infoLabel.addTo(this.informationButton).center(this.informationButton);
		this.infoLabel.y-=1;

		//Let's create all our card instances
		this.cardSize = Math.min(0.8*(frame.height - this.firstInstructionLabel.y+this.firstInstructionLabel.height), 0.8*(frame.width - this.currentLevelOptions.x+this.currentLevelOptions.width))/4;
		this.cardContainer = new Container().addTo(this); //This is going to hold the cards so that they can be scaled as a group
		this.playButtonContainer = new Container().addTo(this); //This is going to hold the cards so that they can be scaled as a group

		this.dotColoursBucket = copyArray(dotColours)
		//Go through our values array which we've setup with fraction and mixed values
		for(var i=0;i<this.representationValuesArray.length;i++){
			this.cardOptions.push([]);
			currentLevel = i; //We do this for the numberlines so that they know how to create themselves
			//Now we go through our constructor array and create our cards and representations
			for(var j=0;j<representationLevelsArray[i].length;j++){

				//We are going to create our cards and create some highlights
				var myCard = new FlipCard({width:this.cardSize, height:this.cardSize, corner:this.cardSize*0.2, color:"#2157B0", borderColor:"blue"});
				myCard.useHighlight = true;
				myCard.alpha = 0.8;
				myCard.highlightChangeFunction = this.updateRepresentationArrayProxy;
				myCard.myRepresentationConstructor = representationLevelsArray[i][j];

				//We need to worry about a couple of custom parameters.
				var customParms = {displayAsMixed:i>1};

				//If this is a fraction dot, gotta send in a colour
				if (myCard.myRepresentationConstructor == WholeDots){
					var randomIndex = Math.floor(Math.random()*this.dotColoursBucket.length);
					customParms.dotColour = this.dotColoursBucket.splice(randomIndex, 1)[0];
				}

				if (myCard.myRepresentationConstructor == WholeTenFrame){
					customParms.showFace = true;//i<2;
				}

				//Going to pass the values to the actual representation.
				var testRep = new representationLevelsArray[i][j](
					this.representationValuesArray[i],
					this.cardSize*0.85,
					this.cardSize*0.85,
					customParms).addTo(myCard.cardFront);

				testRep.center(myCard.cardFront);
				myCard.addTo(this.cardContainer);
				myCard.x = j*this.cardSize*1.1;
				this.cardOptions[i].push(myCard)
			}
		}

		representationArray = [];

		timeout(100, this.positionObjectsProxy)
		this.positionObjects();

		//If you want to skip the selection step, just uncomment this line and it will automatically choose a level (to see the representations faster)
		//timeout(150, this.selectFirstOptionAutomatically)

		//timeout(1000, this.playNarration1);

		if(!this.startFaceUp){
			openingDialog = this;
			this.togglePlayMode();
		}

		//To allow chaining
		return this;
	}
	playNarration1(){
		//Currently, the playNarration variable in globalVars is set to false by default.
		if(playNarration){
			playGameSound("narration1");
		}
	}

	selectFirstOptionAutomatically(){
		openingDialog.levelOptions[0].selectedIndex = 2;
		openingDialog.changeLevelChoice();
	}

	pulseSecondText(){
		var turnTime = 300;
		openingDialog.secondInstructionLabel.animate({scaleX:1.1, scaleY:1.1}, 300, null, "linear");
		openingDialog.secondInstructionLabel.animate({scaleX:1, scaleY:1}, 300, null,"linear",  null, 300);
	}

	makeButton(type, toggle) {
		var spacing = 10;
		var iconScale = .6;
		var iconColor = white
		var buttonSize = this.openingDialogButtonSize;
		var buttonColor = mathiesBlue;
		var buttonRoll = mathiesBlueRollover;
		var rollIconColor = dark;

		this.icon =  pizzazz.makeIcon({
			type:type,
			color:iconColor,
			scale:iconScale
		});
		this.drawSoundLines(this.icon.shape, this.openingDialogButtonSize);

		this.rollIcon =  pizzazz.makeIcon({
			type:type,
			color:rollIconColor,
			scale:iconScale
		});
		this.drawSoundLines(this.rollIcon.shape, this.openingDialogButtonSize);


		if (toggle) {
			this.toggleIcon = pizzazz.makeIcon({
				type:toggle,
				color:iconColor,
				scale:iconScale
			});
			this.toggleIcon.shape.x-=this.openingDialogButtonSize*0.05;
			//this.drawSoundLines(this.toggleIcon.shape, this.openingDialogButtonSize);
			this.rollToggleIcon = pizzazz.makeIcon({
				type:toggle,
				color:rollIconColor,
				scale:iconScale
			});
			this.rollToggleIcon.shape.x-=this.openingDialogButtonSize*0.05;
			//this.drawSoundLines(this.rollToggleIcon.shape, this.openingDialogButtonSize);
		}
		// 10. once the icons are made, add them to the Button with icon, rollIcon, toggle and rollToggle params
		var button = new Button({
			width:buttonSize,
			height:buttonSize,
			backgroundColor:buttonColor,
			borderColor:black,
			borderWidth:1,
			rollBackgroundColor:buttonRoll,
			gradient:.3,
			corner:buttonSize/2,
			icon:this.icon,
			rollIcon:this.rollIcon,
			toggleIcon:this.toggleIcon,
			rollToggleIcon:this.rollToggleIcon,
			shadowColor:-1
		});
		return button;
	}

	drawSoundLines(buttonShape, buttonShapeSize){
		buttonShape.graphics.moveTo(buttonShapeSize*0.4,-buttonShapeSize*0.15);
		buttonShape.graphics.curveTo(buttonShapeSize*0.6,buttonShapeSize*0, buttonShapeSize*0.4,buttonShapeSize*0.15);
		buttonShape.graphics.moveTo(buttonShapeSize*0.55,-buttonShapeSize*0.25);
		buttonShape.graphics.curveTo(buttonShapeSize*0.75,buttonShapeSize*0, buttonShapeSize*0.55,buttonShapeSize*0.25);
		buttonShape.x-=buttonShapeSize*0.05;
	}

	drawArrowsOnfaceUpButton(){
		var arrow1 = new Arrow(cardWidth*0.8, null, null, cardWidth/10);
		arrow1.addTo(this.faceUpButton.icon.cardBack).loc(cardWidth*.1, cardWidth*.25);
		var arrow2 = new Arrow(cardWidth*0.8, null, null, cardWidth/10, "left");
		arrow2.addTo(this.faceUpButton.icon.cardBack).loc(cardWidth*.1, cardWidth*.75);
		var arrow3 = new Arrow(cardWidth*0.8, white, white, cardWidth/10);
		arrow3.addTo(this.faceUpButton.icon.cardFront).loc(cardWidth*.1, cardWidth*.25);
		var arrow4 = new Arrow(cardWidth*0.8, white, white, cardWidth/10, "left");
		arrow4.addTo(this.faceUpButton.icon.cardFront).loc(cardWidth*.1, cardWidth*.75);
		stage.update();
	}

	togglePlayMode(e){
		if(openingDialog.faceUpButton.icon.cardFront.scaleX>0){
			openingDialog.faceUpButton.label.text = localization.faceDown[localizationIndex];
		} else {
			openingDialog.faceUpButton.label.text = localization.faceUp[localizationIndex];
		}
		openingDialog.faceUpButton.icon.turnCard();

	}

	showInformationDialog(){
		if(matchInformationDialog && matchInformationDialog.parent){
			matchInformationDialog.parent.removeChild(matchInformationDialog);
		}
		matchInformationDialog = new MatchInformationDialog().center(stage);
		stage.update();
	}

	playButtonClicked(){
		playFaceUp = openingDialog.faceUpButton.icon.cardFront.scaleX > 0;
		loadAssets();
	}

	//We use this proxy so that I can use global this-style references
	updateRepresentationArrayProxy(){
		openingDialog.updateRepresentationArray();
	}

	//This function updates the global representationArray (which is used by the GameContainer to create its cards)
	updateRepresentationArray(){
		representationArray = []; //emptying the representation array
		for(var i=0;i<this.cardOptions.length;i++){
			for(var j=0;j<this.cardOptions[i].length;j++){
				if(this.cardOptions[i][j].parent!=null && this.cardOptions[i][j].cardHighlight.alpha>0 && representationArray.indexOf(this.cardOptions[i][j].myRepresentationConstructor)<0){
					representationArray.push(this.cardOptions[i][j].myRepresentationConstructor);
				}
			}
		}
		openingDialog.positionObjects();
	}

	positionObjectsProxy(){
		//zog("positionObjectsProxy - line:410 file:OpeningDialog.js");
		openingDialog.positionObjects();
	}

	//this will change the global localizationIndex which controls whether we see French or English through the tool
	changeLanguage(e){

		if (openingDialog.languageButton.label.text=="fr"){
			localizationIndex = 1;
		} else {
			localizationIndex = 0;
		}
		openingDialog.positionObjects();
	}

	//Make sure to update the global variable about our new choice
	changeLevelChoice(e){
		var beforeChoice = openingDialog.cardIndex;
		currentLevel = openingDialog.levelOptions[localizationIndex].selectedIndex;
		//Making sure the french and english match
		openingDialog.cardIndex = currentLevel;
		if(openingDialog.levelOptions[0].selectedIndex!=currentLevel){
			openingDialog.levelOptions[0].selectedIndex = currentLevel;
		}
		if(openingDialog.levelOptions[1].selectedIndex!=currentLevel){
			openingDialog.levelOptions[1].selectedIndex = currentLevel;
		}

		if(beforeChoice<0 || openingDialog.levelOptions[localizationIndex].selectedIndex<0){
			//We already have the cardContainer showing, let's just position things
			openingDialog.animateRadioChoice();
		} else {
			openingDialog.positionObjects();
			openingDialog.updateRepresentationArray();
		}
	}

	animateRadioChoice(){
		if (this.cardIndex!=-1){
			//We have a choice made!
			//Time to make the initial instruction disappear and the radio button options move and scale down if necessary
			this.aspectRatio = Math.max(1,this.drawWidth/this.drawHeight);
			this.shrunkLevelOptionsRectanglePercent = 0.4 - 0.07*this.aspectRatio;
			var curScale = this.levelOptionsRectangle.scaleX;
			this.levelOptionsRectangle.sca(1);

			var maxHeight = Math.max(70, this.drawHeight*this.shrunkLevelOptionsRectanglePercent);
			var endScale = 1;
			if(maxHeight > 0.8*this.drawWidth){
				maxHeight = 0.8*this.drawWidth;
			}
			if(maxHeight<this.levelOptionsRectangle.height){
				endScale = (maxHeight/this.levelOptionsRectangle.height);
			}

			this.animateX = (this.drawWidth - endScale/this.levelOptionsRectangle.scaleX*this.levelOptionsRectangle.width)/2;
			this.animateY = this.getRadioButtonPosition();

			this.levelOptionsRectangle.sca(curScale);

			openingDialog.levelOptionsRectangle.animate({scaleX:endScale, scaleY:endScale, x:openingDialog.animateX, y:openingDialog.animateY}, 1000, null, openingDialog.fadeInCards, "linear");
			openingDialog.firstInstructionLabel.animate({alpha:0}, 500);
			timeout(1000, this.playNarration2);
		} else {
			//The cards are no longer needed if we are animating back to a level choice
			if(this.cardContainer.parent){
				this.cardContainer.parent.removeChild(this.cardContainer);
			}

			if(this.secondInstructionLabel.parent){
				this.secondInstructionLabel.parent.removeChild(this.secondInstructionLabel);
			}

			if(this.playButtonDisabled.parent){
				this.playButtonDisabled.parent.removeChild(this.playButtonDisabled);
			}

			if(this.playButton.parent){
				this.playButton.parent.removeChild(this.playButton);
			}

			if(this.faceUpButton.parent){
				this.faceUpButton.parent.removeChild(this.faceUpButton);
			}

			if(this.faceUpLabel.parent){
				this.faceUpLabel.parent.removeChild(this.faceUpLabel);
			}
			var curScale = this.levelOptionsRectangle.scaleX;
			this.levelOptionsRectangle.sca(1);

			var spaceForOptions = Math.min(this.drawWidth*0.8, this.drawHeight - this.firstInstructionLabel.y-this.firstInstructionLabel.height);
			var newScale = 1;
			if(spaceForOptions < this.levelOptionsRectangle.height){
				newScale = 0.9*(spaceForOptions/this.levelOptionsRectangle.height);
				this.levelOptionsRectangle.sca(newScale);
			}
			this.animateX = (this.drawWidth - this.levelOptionsRectangle.width)/2;
			this.animateY = this.firstInstructionLabel.y+this.firstInstructionLabel.height + (this.drawHeight - this.firstInstructionLabel.y-this.firstInstructionLabel.height - this.levelOptionsRectangle.height)/2;

			this.levelOptionsRectangle.sca(curScale);

			openingDialog.levelOptionsRectangle.animate({scaleX:newScale, scaleY:newScale, x:openingDialog.animateX, y:openingDialog.animateY}, 1000, null, openingDialog.fadeOutCards, "linear");
			openingDialog.firstInstructionLabel.animate({alpha:1}, 500);
		}
		stage.update();
	}

	playNarration2(){
		if(playNarration){
			playGameSound("narration2");
		}
		playNarration = false;
	}

	fadeInCards(){
	//Needs to be done twice to get the positioning right
		openingDialog.positionObjectsProxy();
		openingDialog.positionObjectsProxy();
	}

	fadeOutCards(){
		openingDialog.positionObjects();
	}

	getRadioButtonPosition(){
		if(this.drawWidth<this.drawHeight){
			return Math.max(this.informationButton.y+this.informationButton.height*1.1, this.titleLabel.y + this.titleLabel.height*1.5);
		} else {
			return (this.titleLabel.y + this.titleLabel.height*1.5);
		}
	}

	//Call this function if the window resizes or you need to reposition things
	positionObjects(){
		this.drawWidth = frame.width - this.openingDialogBorderWidth;
		this.drawHeight = frame.height - this.openingDialogBorderWidth;
		this.maxTextHeight = 0.05*this.drawHeight;

		var cardGap = frame.width*0.07;

		//So these values can be used later
		this.rectangleInit.width = this.drawWidth;
		this.rectangleInit.height = this.drawHeight;
		this.aspectRatio = Math.max(1,this.drawWidth/this.drawHeight);

		this.shrunkLevelOptionsRectanglePercent = 0.4 - 0.07*this.aspectRatio;

		//Let us first draw our backgroundRectangle
		if(this.backgroundRectangle.parent){
			this.backgroundRectangle.parent.removeChild(this.backgroundRectangle);
		}
		this.backgroundRectangle = new Rectangle(this.rectangleInit).addTo(this,0);
		this.backgroundRectangle.x = this.openingDialogBorderWidth/2;
		this.backgroundRectangle.y = this.openingDialogBorderWidth/2;
		this.backgroundRectangle.name = "openingDialogBackground";

		if (localizationIndex==0){
			this.languageButton.label.text = "fr";
		} else {
			this.languageButton.label.text = "en";
		}
		this.languageButton.label.center(this.languageButton);

		this.languageButton.x = this.drawWidth - this.languageButton.width*1.2;
		this.languageButton.y = 2*this.openingDialogBorderWidth;

		this.informationButton.x = this.languageButton.x - this.languageButton.width*1.2;
		this.informationButton.y = this.languageButton.y;

		//Let's take a look at the logo and make sure it is of appropriate size
		this.desiredLogoSize = this.drawWidth - this.informationButton.x;
		this.mathiesLogo.sca(this.desiredLogoSize/this.logoWidth);

		this.mathiesLogo.x = 2*this.openingDialogBorderWidth;
		this.mathiesLogo.y = this.mathiesLogo.x;

		this.hideAllCards();

		//We do the localization before positioning to make sure things center properly
		this.firstInstructionLabel.text = localization.openingDialogTitle[localizationIndex];
		this.secondInstructionLabel.text = localization.openingDialogSecondInstruction[localizationIndex];
		this.titleLabel.text = localization.gameName[localizationIndex];
		this.playButton.label.text = localization.play[localizationIndex];
		this.playButtonDisabled.label.text = localization.play[localizationIndex];

		// var currentOptions = localization.levelDescriptions[localizationIndex];
		// for(var i=0;i<currentOptions.length;i++){
		// 	if(this.levelOptions.buttons[i].label.text!=currentOptions[i]){
		// 		this.levelOptions.buttons[i].label.text=currentOptions[i];
		// 	}
		// }

		//Let's scale our instruction labels
		this.firstInstructionLabel.sca(1);
		var availWidth = this.drawWidth - 2*this.openingDialogBorderWidth;
		if (this.firstInstructionLabel.width>availWidth || this.firstInstructionLabel.height>this.maxTextHeight){
			this.firstInstructionLabel.sca(Math.min(this.maxTextHeight/this.firstInstructionLabel.height, availWidth/this.firstInstructionLabel.width));
		}

		//Positioning our first instructions after checking localization
		this.firstInstructionLabel.x = (this.drawWidth - this.firstInstructionLabel.width)/2 +this.openingDialogBorderWidth/2;
		this.firstInstructionLabel.y = this.drawHeight*0.2;


		this.aspectRatio = this.drawWidth/this.drawHeight;

		//Let's scale our instruction labels
		this.titleLabel.sca(1);
		var availWidth = Math.min(this.drawWidth*0.5, this.drawWidth - 2*this.openingDialogBorderWidth - this.mathiesLogo.x - this.mathiesLogo.width*1.1 - 2.3*this.languageButton.width);
		//we are in portrait, so position title under the mathies logo
		if(this.aspectRatio<0.7){
			availWidth = this.informationButton.x - this.mathiesLogo.x - getMargin();
		}

		var availHeight = localizationIndex==0?this.maxTextHeight:this.maxTextHeight*1.6;
		if (this.titleLabel.width>availWidth || this.titleLabel.height>availHeight){
			var newScale = Math.min((availHeight/this.titleLabel.height), (availWidth/this.titleLabel.width));
			this.titleLabel.sca(newScale);
		}

		//Time to position our title
		if(this.aspectRatio<0.7){

			this.titleLabel.x = this.mathiesLogo.x + this.titleLabel.width/2;
			this.titleLabel.y = this.mathiesLogo.y+this.mathiesLogo.height*1.1;
		} else {
			this.titleLabel.x = 0.5*(this.drawWidth - this.titleLabel.labelWidth);
			this.titleLabel.y = 2*this.openingDialogBorderWidth;
		}

		//If we have an index selected, put the options to the left
		var maxHeight = Math.max(70, this.drawHeight*this.shrunkLevelOptionsRectanglePercent);
		this.levelOptionsRectangle.sca(1);
		if(maxHeight > 0.8*this.drawWidth){
			maxHeight = 0.8*this.drawWidth;
		}
		if (this.currentLevelOptions!=this.levelOptions[localizationIndex]){

			this.levelOptions[localizationIndex].addTo(this.levelOptionsRectangle);
			this.levelOptions[localizationIndex].x = this.currentLevelOptions.x;
			this.levelOptions[localizationIndex].y = this.currentLevelOptions.y;
			if (this.currentLevelOptions.parent){
				this.currentLevelOptions.parent.removeChild(this.currentLevelOptions);
			}

			this.currentLevelOptions = this.levelOptions[localizationIndex];
		}


		if (this.cardIndex>-1){
			//If we currently have a choice selected and we need to be at the top
			if(maxHeight<this.levelOptionsRectangle.height){
				this.levelOptionsRectangle.sca((maxHeight/this.levelOptionsRectangle.height));
			}
			this.levelOptionsRectangle.x = (this.drawWidth - this.levelOptionsRectangle.width)/2;
			this.levelOptionsRectangle.y = this.getRadioButtonPosition();
		} else {
			var spaceForOptions = Math.min(this.drawWidth*0.8, this.drawHeight - this.firstInstructionLabel.y-this.firstInstructionLabel.height);

			if(spaceForOptions < this.levelOptionsRectangle.height){
				this.levelOptionsRectangle.sca(0.9*(spaceForOptions/this.levelOptionsRectangle.height));
			}
			this.levelOptionsRectangle.x = (this.drawWidth - this.levelOptionsRectangle.width)/2;
			this.levelOptionsRectangle.y = this.firstInstructionLabel.y+this.firstInstructionLabel.height + (this.drawHeight - this.firstInstructionLabel.y-this.firstInstructionLabel.height - this.levelOptionsRectangle.height)/2;
		}

		this.cardIndex = this.currentLevelOptions.selectedIndex;

		//remove the secondary instructions for now and add later if needed
		if (this.secondInstructionLabel.parent!=null){
			this.secondInstructionLabel.parent.removeChild(this.secondInstructionLabel);
		}

		//If we need to we are going to add the appropriate cards to the card container
		this.cardContainer.sca(1);
		var numRows = 1;
		if (this.cardIndex>-1){
			var xCardPos = 0;
			var yCardPos = 0;

			if(this.aspectRatio<1){
				numRows = 2;
			}

			var numberOfCards = this.cardOptions[this.cardIndex].length;
			for(var i=0;i<numberOfCards;i++){
				this.cardOptions[this.cardIndex][i].addTo(this.cardContainer);
				this.cardOptions[this.cardIndex][i].x = xCardPos;
				this.cardOptions[this.cardIndex][i].y = yCardPos;
				xCardPos = xCardPos+this.cardOptions[this.cardIndex][i].width*1.1;
				if((numRows == 2 && i == Math.ceil(numberOfCards/2)-1)){
					yCardPos = yCardPos + this.cardOptions[this.cardIndex][i].width*1.1;
					xCardPos = numberOfCards%2==0?0:this.cardOptions[this.cardIndex][i].width*0.55;
				}
			}

			//We've got a choice in the radio buttons, so add the second instruction label
			this.secondInstructionLabel.addTo(this);
		}

		//Time to position the card container.
		//First we scale it to 1, see how much space we have and then scale down
		this.cardContainer.addTo(this);
		this.cardContainer.sca(1);
		this.secondInstructionLabel.sca(1);
		var availWidth = this.drawWidth - 4*this.openingDialogBorderWidth;
		if (this.secondInstructionLabel.width>availWidth || this.secondInstructionLabel.height>this.maxTextHeight){
			var newScale = Math.min((this.maxTextHeight/this.secondInstructionLabel.height), (availWidth/this.secondInstructionLabel.width));
			this.secondInstructionLabel.sca(newScale);
		}
		this.playButtonContainer.sca(1);
		var extraSpace = 0;
		if(this.aspectRatio>0.7 && this.aspectRatio < 0.9){
			//this is typically what the iPads are at
			extraSpace = this.playButtonContainer.height;
		}

		var availableHeight = this.drawHeight - extraSpace - 4*this.openingDialogBorderWidth - this.levelOptionsRectangle.y - this.levelOptionsRectangle.height - this.secondInstructionLabel.height - this.playButtonContainer.height;
		var availableWidth = 0.8*this.drawWidth;

		var newScale = (availableHeight/this.cardContainer.height);

		newScale = Math.min(newScale, availableWidth/this.cardContainer.width);
		if(numRows==1){
			//If the cards are all in a row, make sure they don't get bigger than the level options rectangle
			newScale = Math.min(this.levelOptionsRectangle.height/this.cardContainer.height, newScale);
		} else if(numRows==2){
			newScale = Math.min(2*this.levelOptionsRectangle.height/this.cardContainer.height, newScale);
		}
		this.cardContainer.sca(newScale);
		this.cardContainer.x = (this.drawWidth - this.cardContainer.width)/2;

		//Let's scale our instruction labels
		var availWidth = this.drawWidth - 4*this.openingDialogBorderWidth;
		if (this.secondInstructionLabel.width>availWidth){
			this.secondInstructionLabel.sca(availWidth/this.secondInstructionLabel.width);
		}

		//Now we add the secondary instructions if the cardContainer is showing something
		this.secondInstructionLabel.x = this.cardContainer.x;

		//Now let us position and add the play buttons (they are on a scalable container now)
		if (this.playButtonDisabled.parent!=null){
			this.playButtonDisabled.parent.removeChild(this.playButtonDisabled);
		}

		if (this.playButton.parent!=null){
			this.playButton.parent.removeChild(this.playButton);
		}

		if (this.cardIndex > -1){
			if (representationArray.length < 2){
				this.playButtonDisabled.addTo(this.playButtonContainer);
			} else {
				this.playButton.addTo(this.playButtonContainer);
			}
		}

		if (this.faceUpButton.parent!=null){
			this.faceUpButton.parent.removeChild(this.faceUpButton);
		}

		if (this.faceUpLabel.parent!=null){
			this.faceUpLabel.parent.removeChild(this.faceUpLabel);
		}

		if (this.soundButton.parent != null){
			this.soundButton.parent.removeChild(this.soundButton);
		}

		if (this.cardIndex > -1){
			this.faceUpButton.addTo(this);
			this.faceUpLabel.addTo(this);
		}

		this.soundButton.addTo(this);

		if(this.faceUpButton.icon.cardBack.scaleX>0){
			this.faceUpButton.label.text = localization.faceDown[localizationIndex];
		} else {
			this.faceUpButton.label.text = localization.faceUp[localizationIndex];
		}
		var heightScale = (this.languageButton.height)/this.playButtonContainer.height;
		var widthScale = (this.cardContainer.width - this.soundButton.width)/this.playButtonContainer.width;
		var chosenScale = Math.min(1,Math.min(widthScale, heightScale));
		this.playButtonContainer.sca(chosenScale);

		//After all the scaling is calculated, we position the pieces vertically to be spaced out nicely
		this.playButtonContainer.x = this.cardContainer.x;
		this.playButtonContainer.y = this.drawHeight - this.playButtonContainer.height - this.openingDialogBorderWidth;
		this.cardContainer.y = this.playButtonContainer.y - this.cardContainer.height - 2*this.openingDialogBorderWidth;
		this.secondInstructionLabel.y = this.cardContainer.y - this.secondInstructionLabel.height - 2*this.openingDialogBorderWidth;
		var emptySpaceAvailable = this.secondInstructionLabel.y - (this.levelOptionsRectangle.y + this.levelOptionsRectangle.height);

		if(emptySpaceAvailable>10){
			this.cardContainer.y -= emptySpaceAvailable/2;
			this.secondInstructionLabel.y = this.cardContainer.y - this.secondInstructionLabel.height - 2*this.openingDialogBorderWidth;
		}

		if(emptySpaceAvailable > 1.5*this.playButtonContainer.height){
			chosenScale = chosenScale*1.5;
			this.playButtonContainer.sca(chosenScale);
			this.playButtonContainer.y = this.drawHeight - this.playButtonContainer.height - this.openingDialogBorderWidth;
		}

		this.faceUpButton.sca(1);
		var faceUpButtonScale = 0.8*this.playButtonContainer.height/this.faceUpButton.height;
		this.faceUpButton.sca(faceUpButtonScale);

		this.soundButton.x = this.drawWidth - this.soundButton.height - this.openingDialogBorderWidth;
		this.soundButton.y = this.drawHeight - this.soundButton.height - this.openingDialogBorderWidth;

		var whiteSpaceBelowCards = frame.height - this.openingDialogBorderWidth - this.cardContainer.y - this.cardContainer.height;
		this.playButtonContainer.y = this.cardContainer.y + this.cardContainer.height + (whiteSpaceBelowCards - this.playButtonContainer.height)/2;

		this.faceUpButton.x = this.playButtonContainer.x + this.playButtonContainer.width + this.faceUpButton.width*0.5;
		this.faceUpButton.y = this.playButtonContainer.y + (this.playButtonContainer.height - this.faceUpButton.height)/2 ;
		this.faceUpLabel.sca(faceUpButtonScale);
		this.faceUpButton.label.y = this.faceUpButton.y + (this.faceUpButton.height - this.faceUpButton.label.height)/2;
		this.faceUpLabel.x = this.faceUpButton.x + this.faceUpButton.width*1.2;
		//If the secondary instructions are wider than the cards, center the instructions (looks better on phones)
		if(this.secondInstructionLabel.width>this.cardContainer.width){
			this.secondInstructionLabel.x = (this.drawWidth - this.secondInstructionLabel.width)/2 + this.openingDialogBorderWidth/2;
		}

		if(matchInformationDialog && matchInformationDialog.parent){
			this.showInformationDialog();
		}

		frame.stage.update();
	}

	soundButtonHandler(){
		muteAllSounds = !muteAllSounds;
		if (!muteAllSounds){
			playGameSound("right");
		}
	}

	//Go through our array of cards and removeChild any that have a parent
	hideAllCards(){
		for(var i=0;i<this.cardOptions.length;i++){
			for(var j=0;j<this.cardOptions[i].length;j++){
				if(this.cardOptions[i][j].parent){
					this.cardOptions[i][j].parent.removeChild(this.cardOptions[i][j]);
				}
			}
		}
	}
}