class Star extends Container {
	constructor (radius, starColour, starOutlineColour, starOutlineThickness, showFace){

		super();

		if (radius == null){
			this.outerRadius = 20;
			this.innerRadius = 8;
		} else {
			this.outerRadius = radius;
			this.innerRadius = radius *0.4;
		}

		if (starColour == null){
			this.starColour = yellow;
		} else {
			this.starColour = starColour;
		}

		if (starOutlineColour == null){
			this.starOutlineColour = yellow;
		} else {
			this.starOutlineColour = starOutlineColour;
		}

		if (starOutlineThickness == null){
			this.starOutlineThickness = 2;
		} else {
			this.starOutlineThickness = starOutlineThickness;
		}

		if (showFace == null){
			this.showFace = false;
		} else {
			this.showFace = showFace;
		}

		var degree = Math.PI/180;
		var angle = -90;

		this.star = new Shape().addTo(this);
		this.star.graphics.ss(this.starOutlineThickness).s(this.starOutlineColour).f(this.starColour).mt(this.outerRadius*Math.cos(angle*degree),this.outerRadius*Math.sin(angle*degree));
		for (var i = 0; i < 5; i++){
			angle +=36;
			this.star.graphics.lt(this.innerRadius*Math.cos(angle*degree),this.innerRadius*Math.sin(angle*degree));
			angle +=36;
			this.star.graphics.lt(this.outerRadius*Math.cos(angle*degree),this.outerRadius*Math.sin(angle*degree));
		}

		if (showFace){
			this.happyFace = new Shape().addTo(this);

			//left eye
			this.happyFace.graphics.ss(this.starOutlineThickness).s(this.starOutlineColour).f(this.starOutlineColour).de(-this.innerRadius*0.35, -this.innerRadius*0.45, this.innerRadius*0.15, this.innerRadius*0.25);
			//right eye
			this.happyFace.graphics.de(this.innerRadius*0.35, -this.innerRadius*0.45, this.innerRadius*0.15, this.innerRadius*0.25);
			//smile
			this.happyFace.graphics.mt(-this.innerRadius*0.30, this.innerRadius*0.20).qt(0, this.innerRadius*1.15, this.innerRadius*0.4, this.innerRadius*0.30).qt(0, this.innerRadius*0.7, -this.innerRadius*0.30, this.innerRadius*0.20).es;
		}
		//this.resetBounds(0,0,this.outerRadius*2,this.outerRadius*2);

		return this;
	}
}