
//This class will show a numeric representation of a fraction.
class WholeDice extends WholeNumberRepresentation { // use JS6 extends keyword  - based on edu.clips2.integer.ubDiceDisplay
	constructor (whole, drawWidth, drawHeight, customParms) {
		super(whole, drawWidth, drawHeight, customParms); // use JS6 super() to call the Container constructor
		this.name = "WholeDice";
		if (!customParms){
			customParms = {};
		}

		if (customParms.dotColour){
			this.dotColour = customParms.dotColour;
		} else {
			this.dotColour = white;
		}

		this.whole = whole;

		var classInfo =
		{
			propertyDefaults:
				[
					{
						wid:90,
						ht:90,
						numberColumns:2,
						maxNumberOfPips:6, //5, 6, and 9 are good values...
						dieAlign:'left',
						dieVAlign:'top',
						numberRows:1
					},
					{
						dieInit:{}
					},
					{
						shapeArrayInit:
							{
								hPadding:4,
								vPadding:4
							}
					},
					{
						outlineShapeInit:
							{
								lineStyleFormatInit:{thickness:0, alpha:0},
								fillFormatInit:{drawingFillType:'none'}
							}
					}
				]
		};

		/** the number to show on the die */
		this.numberToDisplay = this.whole;
		/**nomimal width in pixels for the arrangement to fit inside*/
		this.wid = customParms.wid?customParms.wid:classInfo.propertyDefaults[0].wid;
		this.wid = this.drawWidth;
		/**nomimal height in pixels for the arrangement to fit inside*/
		this.ht = customParms.ht?customParms.ht:classInfo.propertyDefaults[0].ht;
		this.ht = this.drawHeight;
		/** the number of columns to use (if necessary) to display the dice*/
		this.numberColumns = customParms.numberColumns?customParms.numberColumns:classInfo.propertyDefaults[0].numberColumns;
		/** the most pips that can show on each die arrangement */
		this.maxNumberOfPips = customParms.maxNumberOfPips?customParms.maxNumberOfPips:classInfo.propertyDefaults[0].maxNumberOfPips;
		/** used to configure each die*/
		this.dieInit = customParms.dieInit?customParms.dieInit:classInfo.propertyDefaults[1].dieInit;
		/** used to configure the layout of the dice*/
		this.shapeArrayInit = customParms.shapeArrayInit?customParms.shapeArrayInit:classInfo.propertyDefaults[2].shapeArrayInit;
		/** used to configure the outline rectangle*/
		this.outlineShapeInit = customParms.outlineShapeInit?customParms.outlineShapeInit:classInfo.propertyDefaults[3].outlineShapeInit;

		/**how to arrange the dice used inside the availble space horizontally.  'left' (default) | 'centre', 'right'*/
		this.dieAlign = customParms.dieAlign?customParms.dieAlign:classInfo.propertyDefaults[0].dieAlign;
		/**how to arrange the dice used inside the availble space vertically.  'top' (default) | 'middle', 'bottom'*/
		this.dieVAlign = customParms.dieVAlign?customParms.dieVAlign:classInfo.propertyDefaults[0].dieVAlign;
		/** the number of rows to use (if necessary) to display the dice.*/
		this.numberRows = customParms.numberRows?customParms.numberRows:classInfo.propertyDefaults[0].numberRows;
		//playing the role of _outlineShape
		this.diceContainer = new Container();
		this.diceContainer.name = "diceContainer";
		this.diceContainer.addTo(this.contentContainer);
		this.drawDice();

		this.diceContainer.center();

		return this;
	}

	/**
	 * Gives the actual width of a rectangle bounding the visible randomDots. Will be less than or equal to wid property.
	 * @return The width of a rectangle bounding the visible randomDots objects in pixels.
	 */
	getWidth() {
		return this.effectiveWidth;
	}
	/**
	 * Gives the actual height of a classInfo.propertyDefaults[0].paddingAround;rectangle bounding the visible randomDots. Will be less than or equal to the ht property.
	 * @return The height of a rectangle bounding the visible randomDot objects in pixels.
	 */
	getHeight() {
		return this.effectiveHeight;
	}

	getDimensions(){
		return {width: this.drawWidth, height:this.drawHeight};
	}

	drawDice() {
		//draw the outline
		//understand hPadding, vPadding
		var flattenedShapeArrayInit = this.shapeArrayInit;

		//determine the number to go on each die
		//used to fill up a die before moving to the next
		//now we would like up to 2 dice for levels 0 and 1, and up to four die for level 2
		var numberToDistribute = this.numberToDisplay;
		var numberArray = [];
		if (this.numberToDisplay == 0){
			numberArray = [0];
		} else {
			var maxNumberOfDice = 2;
			if (currentLevel > 1){
				var maxNumberOfDice = 4;
			}
			var minNumberOfDice = Math.ceil(this.numberToDisplay/6);
			var numberOfDice = minNumberOfDice + Math.floor(Math.random()*(maxNumberOfDice - minNumberOfDice + 1));
			while (numberToDistribute > 0){
				var maxPipsForCurrentDie = Math.min(6, numberToDistribute - (numberOfDice - 1)); //each of the other dice needs at least one pip
				var minPipsForCurrentDie = Math.max(1, numberToDistribute - 6*(numberOfDice - 1));
				var pipsForCurrentDie = minPipsForCurrentDie + Math.floor(Math.random()*(maxPipsForCurrentDie - minPipsForCurrentDie + 1));
				numberArray.push(pipsForCurrentDie);
				numberToDistribute -= pipsForCurrentDie;
				/*if (numberToDistribute > this.maxNumberOfPips){
					numberArray.push(this.maxNumberOfPips);
					numberToDistribute -= this.maxNumberOfPips;
				} else {
					numberArray.push(numberToDistribute);
					numberToDistribute = 0;
				}*/
				numberOfDice--;
			}
		}
		var actualNumberColumns = Math.min(numberArray.length, this.numberColumns);
		var actualNumberRows = Math.ceil(numberArray.length/actualNumberColumns);
		/*if (actualNumberRows > this.numberRows){
			zog("Warning:  more rows ("+actualNumberRows+") than expecting, "+this.numberRows+", line:146 file:WholeDice.js");
		}*/
		actualNumberRows = Math.max(actualNumberRows, this.numberRows);
		var maxSize = Math.min((this.wid - (this.numberColumns - 1)*flattenedShapeArrayInit.hPadding)/this.numberColumns, (this.ht - this.numberRows*flattenedShapeArrayInit.vPadding)/actualNumberRows);

		//create the array of ubDieInits
		var creatorArray = [];
		creatorArray.push([]);
		var currRow = 0;
		var currCol = 0;
		var flatDieInit = this.dieInit;
		if (!flatDieInit.size){
			flatDieInit.size = maxSize;
		} else if (flatDieInit.size > maxSize){
			zog("Warning:  supplied size is bigger than the calculated size line:160 file:WholeDice.js");
		}
		flatDieInit.contentContainer = this.diceContainer;
		for (var n=0; n<numberArray.length; n++){
			flatDieInit.numberToDisplay = numberArray[n];
			creatorArray[currRow].push({creatorClass:ubDie, creatorInit:copyObject(flatDieInit)});
			currCol += 1;
			if (currCol >= this.numberColumns && n < numberArray.length - 1){
				//jump to a new row
				currCol = 0;
				currRow += 1;
				/*if (currRow >= this.numberRows){
					zog("Warning: moving to an unexpected row line:172 file:WholeDice.js for "+this.numberToDisplay+" on row "+currRow);
				}*/
				creatorArray.push([]);
			}
		};
		//create the array of shapes
		flattenedShapeArrayInit = mergeObjects(
			{
				creatorArray:creatorArray,
				columnWidth:flatDieInit.size,
				rowHeight:flatDieInit.size
			}, flattenedShapeArrayInit, true);
		//flattenedShapeArrayInit.contentContainer = this.diceContainer;

		if (this._shapeArray && this._shapeArray.parent){
			this._shapeArray.parent.removeChild(this._shapeArray);
		}
		this._shapeArray = new ubShapeArray(flattenedShapeArrayInit)
		.addTo(this.diceContainer);

		//figure out the actual dimensions of the dice
		this.effectiveWidth= this._shapeArray.width;
		this.effectiveHeight = this._shapeArray.height;

		//deal with any dieAlign and dieVAlign
		/*if (this.dieAlign != 'left'){
			if (this.dieAlign == 'right'){
				this._shapeArray.x += this.wid - this._shapeArray._width;
			} else {
				this._shapeArray.x += (this.wid - this._shapeArray._width)/2;
			}
		}

		if (this.dieVAlign != 'top'){
			if (this.dieVAlign == 'bottom'){
				this._shapeArray.y += this.ht - this._shapeArray._height;
			} else {
				this._shapeArray.y += (this.ht - this._shapeArray._height)/2;
			}
		}*/

		/*if (this.align != 'left'){
			if (this.align == 'right'){
				this._outlineShape.x -= this.wid;
			} else {
				this._outlineShape.x -= this.wid/2;
			}
		}

		if (this.vAlign != 'top'){
			if (this.vAlign == 'bottom'){
				this._outlineShape.y -= this.ht;
			} else {
				this._outlineShape.y -= this.ht/2;
			}
		}*/
	}

	zogString(){
		return "WholeDots "+this.whole;
	}
}