//This class will show a dot representation of a whole Number.
//see edu.clips2.draw.drawComposite.ubRandomDots

class WholeDots extends WholeNumberRepresentation { // use JS6 extends keyword
	constructor (whole, drawWidth, drawHeight, customParms) {
		super(whole, drawWidth, drawHeight, customParms); // use JS6 super() to call the Container constructor
		this.name = "WholeDots";

		if (customParms && customParms.dotColour){
			this.dotColour = customParms.dotColour;
		} else {
			this.dotColour = white;
		}

		this.whole = whole;

		var dotClassInfo =
		{
			propertyDefaults:
				[
					{
						size:10,
						wid:88,
						ht:88,
						paddingBetween:1.5,
						paddingAround:0.6,
						showAreaBorder:false,
						jiggleDots:true,
						usePatterns:false,
						dotAlign:"centre",
						dotVAlign:"middle",
						randomizeNumber:0,
						alignOnlyVisibleDots:true
					},
					{
						dotInit:
						{
							color:this.dotColour/*, //"#2157B0",
							alpha:40
							},
							fillFormatInit:
							{
								drawingFillType:"gradient",
								fillType:"radial",
								colourCombo:"blue"
							}*/
						}
					}
				]
		};

		/** The default radius of the dots to be drawn (may be shrunk if there is not enough room in the wid and ht provided.*/
		//this.size = customParms.size?customParms.size:dotClassInfo.propertyDefaults[0].size;
		this.size = Math.floor(cardWidth/Math.max(5, Math.sqrt(this.whole)));

		/**The minimum distance between any dot and another dot as a percentage of the dot size (0.2 = 20% or dot radius)*/
		this.paddingBetween = customParms.paddingBetween?customParms.paddingBetween:dotClassInfo.propertyDefaults[0].paddingBetween;

		/**The empty space that is left between the borders of the bounding rectangle and the dots as a percentage of the dot size (0.2 = 20% or dot radius)*/
		this.paddingAround = customParms.paddingAround?customParms.paddingAround:dotClassInfo.propertyDefaults[0].paddingAround;

		/** used to configure the dots (or other shapes)*/
		this.dotInit = customParms.dotInit?customParms.dotInit:dotClassInfo.propertyDefaults[1].dotInit;

		/**Specifies whether the dots should not have some offsetting to make them look like they are not in a perfect grid.*/
		//this.jiggleDots = customParms.jiggleDots?customParms.jiggleDots:dotClassInfo.propertyDefaults[0].jiggleDots;
		this.maxSubitizable = 7;
		if (this.whole < 4){
			this.jiggleDots = true;
		} else if (this.whole < this.maxSubitizable + 1){
			this.jiggleDots = !useDotPattern;
			useDotPattern = !useDotPattern;
		} else {
			this.jiggleDots = false;
		}

		/**Will show the dots in more easily grouped and subatized configurations.*/
		//this.usePatterns = customParms.usePatterns?customParms.usePatterns:dotClassInfo.propertyDefaults[0].usePatterns;
		this.usePatterns = !this.jiggleDots;

		/**Determines how all dots as a group align themselves to the left/centre/right of the bounding area determined by wid */
		this.dotAlign = customParms.dotAlign?customParms.dotAlign:dotClassInfo.propertyDefaults[0].dotAlign;
		/**Determines how all dots as a group align themselves to the top/middle/bottom of the bounding area determined by ht */
		this.dotVAlign = customParms.dotVAlign?customParms.dotVAlign:dotClassInfo.propertyDefaults[0].dotVAlign;

		/**A seed number that will change the way that representations are randomized */
		this.randomizeNumber = customParms.randomizeNumber?customParms.randomizeNumber:dotClassInfo.propertyDefaults[0].randomizeNumber;

		/** Determines whether dotAlign and dotVAlign applies only  to the visible dots or to he entire movie clip holding all of the dots whether or not they are visible.  (Default:true)*/
		this.alignOnlyVisibleDots = customParms.alignOnlyVisibleDots?customParms.alignOnlyVisibleDots:dotClassInfo.propertyDefaults[0].alignOnlyVisibleDots;

		/**Holds all the dots after creation*/
		//this._dotArray = [];

		/**Can be used to draw a black border around the random dots. */
		this.showAreaBorder = customParms.showAreaBorder?customParms.showAreaBorder:dotClassInfo.propertyDefaults[0].showAreaBorder;

		this.dotContainer = new Rectangle({width:0.80*this.drawWidth, height:0.80*this.drawHeight, color:"rgba(0,0,0,0)"});
		this.dotContainer.addTo(this.contentContainer).center();
		this.drawDots();

		return this;
	}

	getWidth() {
		return this.effectiveWidth;
	}

	getHeight() {
		return this.effectiveHeight;
	}

	getDimensions(){
		return {width: this.drawWidth, height:this.drawHeight};
	}

	drawDots() {
		if (this.alignOnlyVisibleDots == undefined){
			this.alignOnlyVisibleDots = true;
		}

		var dotSize = Math.max(this.size, 5);
		var margin = this.paddingAround*dotSize;
		var actualWidth = this.drawWidth - 2*this.paddingAround*dotSize;
		var actualHeight = this.drawHeight - 2*this.paddingAround*dotSize;
		var tempCols = Math.floor(actualWidth/(dotSize*(this.paddingBetween)));
		var tempRows = Math.floor(actualHeight/(dotSize*(this.paddingBetween)));
		var possibleTotal = tempCols*tempRows;


		if (this.randomizeNumber == null || isNaN(this.randomizeNumber)){
			this.randomizeNumber = 0;
		}

		var safetyCounter = 0;

		//We are going to alternate between forcing the rows/columns to be at least 4 or 5
		var maxRows = Math.random()<0.5?4:5;

		while ((possibleTotal <= this.whole && safetyCounter < 3700) || (tempCols<maxRows && tempRows<maxRows)){
			safetyCounter++;
			//zog("possibleTotal: "+possibleTotal+" line:154 file:WholeDots.js cf. "+this.whole);
			dotSize = dotSize*0.9;

			margin = this.paddingAround*dotSize;

			actualWidth = this.drawWidth - 2*this.paddingAround*dotSize;
			actualHeight = this.drawHeight - 2*this.paddingAround*dotSize;

			tempCols = Math.floor(actualWidth/(dotSize*(1+this.paddingBetween)));
			tempRows = Math.floor(actualHeight/(dotSize*(1+this.paddingBetween)));

			possibleTotal = tempCols*tempRows;
		}

		var _dotInit =
			{
				radius:dotSize/2
			}
		for (var pp in this.dotInit){
			_dotInit[pp] = this.dotInit[pp];
		}

		var creatorArray = new ubShapeArray().creatorToCreatorArray(
			{
				creatorClass:Circle,
				creatorInit:_dotInit
			}, tempRows, tempCols);
		//zog("creatorArray: line:181 file:WholeDots.js");zta(creatorArray);

		this._shapeArray = new ubShapeArray(
			{
				rowHeight:dotSize,
				columnWidth:dotSize,
				hPadding:margin,
				vPadding:margin,
				creatorArray:creatorArray
			})
			.addTo(this.dotContainer);
		this._shapeArray.name = "_shapeArray";
		this._dotArray = this._shapeArray.getObjectArray();
		//zog("this._dotArray: line:194 file:WholeDots.js");zta(this._dotArray);

		//hide the pips unneeded for the whole

		var numVisible = possibleTotal;

		var numRows = this._dotArray.length;
		var numCols = this._dotArray[0].length;
		//zog(numRows + " by " + numCols+" line:202 file:WholeDots.js");

		var topR = 0;
		var bottomR = numRows - 1;

		var leftC = 0;
		var rightC = numCols - 1;

		var useRows = Math.random() < 0.5;

		//zog("Random dots - creating number "+this.whole+" and this.randomizeNumber = "+this.randomizeNumber+" line:212 file:WholeDots.js");
		safetyCounter = 0;
		while (numVisible > this.whole && safetyCounter < 3700){
			safetyCounter++;
			var theLine = 0;

			if (!this.usePatterns){
				var ranX = Math.floor(Math.random()*numRows);
				var ranY = Math.floor(Math.random()*numCols);
				/*var obj = this._dotArray[ranX][ranY];
				do {
					zog("obj: "+obj+" line:223 file:WholeDots.js");
					zog("obj.visible: "+obj.visible+" line:224 file:WholeDots.js");
					zog("obj.alpha: "+obj.alpha+" line:225 file:WholeDots.js");
					zog("obj.x: "+obj.x+" line:226 file:WholeDots.js "+obj.y);
					obj = obj.parent;
				} while (obj);*/
				if (this._dotArray[ranX][ranY].visible){
					this._dotArray[ranX][ranY].visible = false;
					numVisible--;
				}
			} else {
				if (useRows){
					//lets do rows

					//If we are only taking away from a single row and we happen to have odd rows - choose the middle one
					if (Math.random()<0.5 && (numVisible-this.whole)<numCols){
						theLine = Math.round(numRows/2);
						//zog("theLine: "+theLine+" line:240 file:WholeDots.js");
					} else {
						//Let's just take randomly from the top or bottom
						if(Math.random()<0.5){
							//let's go from the top
							theLine = topR;
							//zog("theLine: "+theLine+" line:246 file:WholeDots.js");
							topR++;
						} else {
							theLine = bottomR;
							//zog("theLine: "+theLine+" line:250 file:WholeDots.js");
							bottomR--;
						}
					}

					for (i=this.randomizeNumber;i<(numCols);i++){
						if(this._dotArray[theLine][i].visible){
							this._dotArray[theLine][i].visible = false;
							numVisible--;
						}
						if (numVisible == this.whole){
							var numToOffset = 0;
							for(var j=0;j<numCols;j++){
								if(!this._dotArray[theLine][j].visible){
									numToOffset++;
								}
							}
							var theOffset = (numToOffset)*(1+this.paddingBetween)*dotSize/2
							for(var j=(i+1);j<numCols;j++){
								this._dotArray[theLine][j].x-=theOffset;
							}
							break;
						}
					}
				} else {
					//lets do columns
					//If we are only taking away from a single row and we happen to have odd rows - choose the middle one
					if (Math.random() < 0.5 && (numVisible-this.whole) < numRows){
						theLine = Math.round(numCols/2);
						//zog("theLine: "+theLine+" line:279 file:WholeDots.js");
					} else {
						if(Math.random()<0.5){
							//let's go from the left
							theLine = leftC;
							//zog("theLine: "+theLine+" line:284 file:WholeDots.js");
							leftC++;
						} else {
							theLine = rightC;
							//zog("theLine: "+theLine+" line:288 file:WholeDots.js");
							rightC--;
						}
					}

					for (i=this.randomizeNumber;i<(numRows);i++){
						if (this._dotArray[i][theLine].visible){
							this._dotArray[i][theLine].visible = false;
							numVisible--;
						}
						if (numVisible==this.whole){
							var numToOffset = 0;
							for(var j=0;j<numRows;j++){
								if(!this._dotArray[j][theLine].visible){
									numToOffset++;
								}
							}
							var theOffset = (numToOffset)*(1+this.paddingBetween)*dotSize/2
							for(var j=(i+1);j<numRows;j++){
								this._dotArray[j][theLine].y-=theOffset;
							}
							break;
						}
					}
				}
			}
		}
		//zog("safetyCounter: "+safetyCounter+" line:315 file:WholeDots.js");
		var minX = this.drawWidth;
		var maxX = 0;
		var minY = this.drawHeight;
		var maxY = 0;
		if (this.jiggleDots){
			for (var i=0;i<this._dotArray.length;i++){
				for (var j=0;j<this._dotArray[i].length;j++){
					var dir = Math.random()<0.5?-1:1;
					var dir2 = Math.random()<0.5?-1:1;

					this._dotArray[i][j].x = this._dotArray[i][j].x + dir*Math.random()*this.paddingBetween*dotSize/2;
					this._dotArray[i][j].y = this._dotArray[i][j].y + dir2*Math.random()*this.paddingBetween*dotSize/2;
					if (this._dotArray[i][j].x > maxX){
						maxX = this._dotArray[i][j].x;
					}
					if (this._dotArray[i][j].x < minX){
						minX = this._dotArray[i][j].x;
					}
					if (this._dotArray[i][j].y > maxY){
						maxY = this._dotArray[i][j].y;
					}
					if (this._dotArray[i][j].y < minY){
						minY = this._dotArray[i][j].y;
					}
				}
			}
		}
		//determine where the visible dots actually are
		for (var i=0;i<this._dotArray.length;i++){
			for (var j=0;j<this._dotArray[i].length;j++){
				if (this._dotArray[i][j].visible == true){
					if (this._dotArray[i][j].x > maxX){
						maxX = this._dotArray[i][j].x;
					}
					if (this._dotArray[i][j].x < minX){
						minX = this._dotArray[i][j].x;
					}
					if (this._dotArray[i][j].y > maxY){
						maxY = this._dotArray[i][j].y;
					}
					if (this._dotArray[i][j].y < minY){
						minY = this._dotArray[i][j].y;
					}
				}

			}
		}

		//figure out the actual dimensions of the rectangle which encompasses the dots
		this.effectiveWidth = maxX + dotSize - minX;
		this.effectiveHeight = maxY + dotSize - minY;

		var hOffset = 0;
		var vOffset = 0;

		//this changes the registration point of the entire movie clip
		/*if (this.align != 'left'){
			if (this.align == 'right'){
				this._shapeLayer.x -= this.drawWidth;
			} else {
				this._shapeLayer.x -= this.drawWidth/2;
			}
		}

		if (this.vAlign != 'top'){
			if (this.vAlign == 'bottom'){
				this._shapeLayer.y -= this.drawHeight;
			} else {
				this._shapeLayer.y -= this.drawHeight/2;
			}
		}*/

		var hOffset = 0;
		var vOffset = 0;
		if (this.alignOnlyVisibleDots){//align only the visible dots
			if (this.dotAlign == "centre"){
				//hOffset = (this.drawWidth-(2*margin-minX+maxX+dotSize))/2;
				//hOffset = dotSize/2 /*+ (this.drawWidth)/2*/;
				hOffset = margin - minX;
			} else if (this.dotAlign == "right"){
				hOffset = (this.drawWidth-(margin+maxX+dotSize));
			} else{
				hOffset = -minX - margin;
			}

			if (this.dotVAlign == "middle"){
				//vOffset = (this.drawHeight-(2*margin+maxY-minY+dotSize))/2;
				//vOffset = dotSize/2;
				vOffset = margin - minY;
			} else if (this.dotVAlign == "bottom"){
				vOffset = (this.drawHeight-(margin+maxY+dotSize));
			} else{
				vOffset = -minY - margin;
			}
		} else {//align the movie clip holding the dots whether or not they are visible, this was originally the only alginment option
			if (this.dotAlign == "centre"){
				hOffset = (this.drawWidth-(2*margin+tempCols*dotSize+(tempCols-1)*dotSize*paddingBetween))/2;
			} else if (this.dotAlign == "right"){
				hOffset = (this.drawWidth-(2*margin+tempCols*dotSize+(tempCols-1)*dotSize*paddingBetween));
			}

			if (this.dotVAlign == "middle"){
				vOffset = (this.drawHeight-(2*margin+tempRows*dotSize+(tempRows-1)*dotSize*paddingBetween))/2;
			} else if (this.dotVAlign == "bottom"){
				vOffset = (this.drawHeight-(2*margin+tempRows*dotSize+(tempRows-1)*dotSize*paddingBetween));
			}
		}
		//if (/*this.usePatterns &&*/ this.whole > 1){
			var scaleFactor = Math.min(Math.min(this.dotContainer.width/this.effectiveWidth, this.dotContainer.height/this.effectiveHeight), 3);
			this._shapeArray
				.sca(scaleFactor)
				.loc((this.dotContainer.width - this.effectiveWidth*scaleFactor)/2 + scaleFactor*(dotSize/2 - minX), (this.dotContainer.height - this.effectiveHeight*scaleFactor)/2 + scaleFactor*(dotSize/2 - minY));

			/*new Rectangle({width:this.effectiveWidth, height:this.effectiveHeight, color:"rgba(0,0,0,0)", borderColor:red, borderWidth:1})
				.addTo(this.dotContainer)
				.sca(scaleFactor)
				.loc((this.dotContainer.width - this.effectiveWidth*scaleFactor)/2, (this.dotContainer.height - this.effectiveHeight*scaleFactor)/2);*/
		//}
	}


	zogString(){
		return "WholeDots "+this.whole;
	}
}