
//This class will show a numeric representation of a fraction.
class WholeHands extends WholeNumberRepresentation { // use JS6 extends keyword
	constructor (whole, drawWidth, drawHeight, customParms) {
		super(whole, drawWidth, drawHeight, customParms); // use JS6 super() to call the Container constructor

		if (customParms && customParms.labelColour){
			this.labelColour = customParms.labelColour;
		} else {
			this.labelColour = "white";
		}
		this.handPictures = [];
		this.logoWidth = 120;
		this.logoHeight = 120;
		this.desiredLogoSize = drawWidth*0.6;
		for(var i=0;i<=5;i++){
			var nextHand = new Bitmap("assets/hand"+i+".png", this.logoWidth, this.logoHeight).sca(this.desiredLogoSize/this.logoWidth);
			nextHand.mouseEnabled = false;
			this.handPictures.push(nextHand);
		}

		this.whole = whole;
		var numberOfHands = Math.max(1,Math.ceil(this.whole/5));

		this.wholeContainer = new Rectangle({width:2*this.desiredLogoSize, height:2*this.desiredLogoSize, color:"rgba(0,0,0,0)", borderColor:"rgba(0,0,0,0)"});

		//We are going to position the hands explicitly on the wholeContainer rectangle based on how many hands we've got
		if(numberOfHands==1){
			this.handPictures[this.whole].clone().addTo(this.wholeContainer).pos(this.desiredLogoSize/2,this.desiredLogoSize/2);
		} else if(numberOfHands==2){
			this.handPictures[5].clone().addTo(this.wholeContainer).pos(0,this.desiredLogoSize/2);
			var leftOvers = this.whole%5==0?5:this.whole%5;
			this.handPictures[leftOvers].clone().addTo(this.wholeContainer).pos(2*this.desiredLogoSize,this.desiredLogoSize/2).scaleX = -this.handPictures[this.whole%5].scaleX;
		} else if(numberOfHands==3){
			this.handPictures[5].clone().addTo(this.wholeContainer).pos(0,0);
			this.handPictures[5].clone().addTo(this.wholeContainer).pos(2*this.desiredLogoSize,0).scaleX = -this.handPictures[5].scaleX;
			var leftOvers = this.whole%5==0?5:this.whole%5;
			this.handPictures[leftOvers].clone().addTo(this.wholeContainer).pos(0,this.desiredLogoSize);
		} else if(numberOfHands == 4){
			this.handPictures[5].clone().addTo(this.wholeContainer).pos(0,0);
			this.handPictures[5].clone().addTo(this.wholeContainer).pos(2*this.desiredLogoSize,0).scaleX = -this.handPictures[5].scaleX;;
			this.handPictures[5].clone().addTo(this.wholeContainer).pos(0,this.desiredLogoSize);
			var leftOvers = this.whole%5==0?5:this.whole%5;
			this.handPictures[leftOvers].clone().addTo(this.wholeContainer).pos(2*this.desiredLogoSize,this.desiredLogoSize).scaleX = -this.handPictures[this.whole%5].scaleX;;
		}

		this.wholeContainer.addTo(this.contentContainer).center(this.contentContainer);
		this.positionObjects();

		return this;
	}

	//If you want to re-position the labels, call this function
	positionObjects(){
		this.wholeContainer.center(this.contentContainer);
		this.contentContainer.center(this.contentContainer.parent);

		return this; //for chaining
	}

	zogString(){
		return "WholeHands "+this.whole;
	}
}