class WholeNumberLine extends WholeNumberRepresentation { // use JS6 extends keyword
	constructor (whole, drawWidth, drawHeight, customParms) {
		super(whole, drawWidth, drawHeight, customParms); // use JS6 super() to call the Container constructor
		if (customParms && customParms.usePoint){
			this.usePoint = customParms.usePoint;
		} else {
			this.usePoint = false;
		}

		//the main line
		var roundedWidth = Math.floor(this.drawWidth);
		var roundedHeight = Math.floor(this.drawHeight*0.035); //Math.floor(Math.max(this.drawHeight*0.025, stageHeight*0.006));
		var majorTickArray = [];
		var line = new Shape().addTo(this.contentContainer); // width, height
		line.graphics.ss(roundedHeight).s(white).mt(0, this.drawHeight/2).lt(roundedWidth, this.drawHeight/2);

		var maxTick = 5;
		var majorTickInterval = 5;
		var semiMajorTickInterval = 0;
		var minorTickInterval = 1;
		if (currentLevel == 1){
			maxTick = 10;
			majorTickInterval = 10;
			semiMajorTickInterval = 5;
		} else if (currentLevel > 1){
			maxTick = Math.ceil(whole/10)*10;
			majorTickInterval = 10;
			if (this.whole > 30){
				minorTickInterval = 5;
			} else {
				semiMajorTickInterval = 5;
			}
		}
		//draw the minor ticks
		var halfMinorTickHeight = Math.max(Math.round(roundedHeight*1.5), 5);		
		var numberOfMinorTicks = maxTick/minorTickInterval;
		var minorTickWeight= Math.max(1, Math.ceil(roundedHeight/4));
		minorTickWeight = Math.round(Math.max(minorTickWeight, roundedWidth/(36*3)));
		for(var k=1;k<numberOfMinorTicks;k++){
			var tick = new Shape().addTo(this.contentContainer);
			var xPos = k*minorTickInterval/maxTick*roundedWidth;
			tick.graphics.ss(minorTickWeight).s(light).mt(xPos, this.drawHeight/2 + halfMinorTickHeight).lt(xPos, this.drawHeight/2 - halfMinorTickHeight);
		}

		//semi-major ticks
		if (semiMajorTickInterval > 0){
			var semiMajorTickWeight= Math.max(1, Math.round(roundedHeight/2));
			var halfSemiMajorTickHeight = Math.max(Math.round(roundedHeight*2.25), 7);
			var numberOfSemiMajorTicks = maxTick/semiMajorTickInterval;
			for(var k=1;k<numberOfSemiMajorTicks;k++){
				var tick = new Shape().addTo(this.contentContainer);
				var xPos = k*semiMajorTickInterval/maxTick*roundedWidth;
				tick.graphics.ss(semiMajorTickWeight).s(light).mt(xPos, this.drawHeight/2 + halfSemiMajorTickHeight).lt(xPos, this.drawHeight/2 - halfSemiMajorTickHeight);
			}
		}

		//draw the major ticks (should go over the minor ticks and cover them up)
		var numberOfMajorTicks = maxTick/majorTickInterval;
		var halfMajorTickHeight = Math.max(Math.round(roundedHeight*2.5), 8);
		for(var j=0;j<= numberOfMajorTicks;j++){
			var tick = new Shape().addTo(this.contentContainer);
			var xPos = j*majorTickInterval/maxTick*roundedWidth;
			tick.graphics.ss(roundedHeight).s(white).mt(xPos, this.drawHeight/2 + halfMajorTickHeight).lt(xPos, this.drawHeight/2 - halfMajorTickHeight);
			majorTickArray.push(tick);
		}

		//draw the point
		var lineColour = '#ff4046';//'#ff2433'; //'#e89694'; //a lighter red
		if (this.usePoint || this.decimalValueOf() == 0){
			var radius = Math.max(1*roundedHeight, Math.floor(Math.min(1/maxTick*roundedWidth, roundedHeight*1.5)));
			var posPoint = new Circle(radius, lineColour).addTo(this.contentContainer);
			posPoint.x = this.decimalValueOf()/maxTick*roundedWidth;
			posPoint.y = this.drawHeight/2;
		} else {
			var tick = new Shape().addTo(this.contentContainer);
			var xPos = k/maxTick*roundedWidth;
			var redLineWeight = Math.floor(roundedHeight*2);
			tick.graphics.ss(redLineWeight).s(lineColour).mt(0, this.drawHeight/2 -2*roundedHeight).lt(this.decimalValueOf()/maxTick*roundedWidth, this.drawHeight/2 -2*roundedHeight);
		}

		//the zero and one label
		var labelHeight = Math.min(Math.round(roundedHeight*4.5), cardHeight/5);
		var labelArray = [];
		for(var j=0;j<2;j++){
			var tickLabel = new Label({
				text:j*majorTickInterval,
				size:labelHeight,
				font:fontFace,
				color:white,
				fontOptions:"bold"
			});
			tickLabel.addTo(this.contentContainer);
			labelArray.push(tickLabel);
		}
		//labelArray[0].y = this.drawHeight/2 +3*roundedHeight;
		var aMajorTick = majorTickArray[0];
		labelArray[0].y = Math.ceil(this.drawHeight/2 + halfMajorTickHeight*1.25);
		labelArray[1].y = labelArray[0].y;
		labelArray[0].x = -labelArray[0].width/2;
		labelArray[1].x = Math.min(this.contentContainer.width - labelArray[1].width + Math.floor(labelHeight/3), majorTickInterval/maxTick*roundedWidth - labelArray[1].width/2); //keep off the edge of the card

		return this; //for chaining
	}

	zogString(){
		return "WholeNumberLine "+this.whole+" ("+this.usePoint+")";
	}
}