class WholeNumberRepresentation extends Container { // use JS6 extends keyword

	//This constructor expects
	constructor (whole, drawWidth, drawHeight, customParms) {
		//handle whole as an array of parameters
		//code from https://idiallo.com/blog/javascript-how-do-i-check-if-this-variable-is-an-array
		var s = typeof whole;
		if (s === 'object') {
			if (whole) {
				if (whole instanceof Array) {
					whole = whole[0];
					drawWidth = whole[1];
					drawHeight = whole[2];
					customParms = whole[3];
				}
			}
		}
		super(); // use JS6 super() to call the Container constructor
		this.defaultSize = 200; //in case dimensions are not passed in

		if (whole==null){
			this.whole = 0;
		} else {
			this.whole = whole;
		}

		if (drawWidth==null){
			this.drawWidth = this.defaultSize;
		} else {
			this.drawWidth = drawWidth;
		}

		if (drawHeight==null){
			this.drawHeight = this.defaultSize;
		} else {
			this.drawHeight = drawHeight;
		}

		this.customParms = customParms;

		//This is the container that is going to hold all our content.
		//change borderWidth to something bigger than 0.1 to see all contentContainers
		this.contentContainer = new Rectangle({width:this.drawWidth, height:this.drawHeight, color:"rgba(0,0,0,0)"/*, borderColor:black, borderWidth:1*/});
		this.contentContainer.addTo(this);
	}

	//This function will take as input a whole, numerator and denominator and return true if it is equivalent to this instance's value
	equivalentTo(givenWhole){
		if(givenDenominator==0){
			zog("WARNING - can't pass a denominator of zero! - line 16:wholeNumberRepresentation.js")
			return false;
		}
		//shouldn't be rounding errors, but this will still work
		return Math.abs(this.whole - givenWhole)<0.0001;
	}

	decimalValueOf(){
		return (this.whole);
	}

	zogString(){
		return "wholeNumberRepresentation "+this.whole;
	}
}