
//This class will show a numeric representation of a fraction.
class WholeNumeric extends WholeNumberRepresentation { // use JS6 extends keyword
	constructor (whole, drawWidth, drawHeight, customParms) {
		super(whole, drawWidth, drawHeight, customParms); // use JS6 super() to call the Container constructor

		if (customParms && customParms.labelColour){
			this.labelColour = customParms.labelColour;
		} else {
			this.labelColour = "white";
		}

		this.whole = whole;


		this.wholeContainer = new Container();

		//The label showing the wholeLabel
		this.wholeLabel = new Label({
			text:this.whole,
			size:Math.min(this.drawWidth,this.drawHeight)*0.8,
			font:"arial",
			color:this.labelColour,
			fontOptions:"bold"
		});

		this.wholeLabel.addTo(this.wholeContainer);

		this.wholeContainer.addTo(this.contentContainer);
		this.positionLabels();

		return this;
	}

	//If you want to re-position the labels, call this function
	positionLabels(){
		//We are going to start assuming that the whole is hidden
		this.wholeLabel.center(this.wholeContainer);
		this.wholeContainer.center(this.contentContainer);

		return this; //for chaining
	}

	zogString(){
		return "WholeNumeric "+this.whole;
	}
}