
//This class will show a numeric representation of a fraction.
class WholeRekenrek extends WholeNumberRepresentation { // use JS6 extends keyword
	constructor (whole, drawWidth, drawHeight, customParms) {
		super(whole, drawWidth, drawHeight, customParms); // use JS6 super() to call the Container constructor

		if (customParms && customParms.labelColour){
			this.labelColour = customParms.labelColour;
		} else {
			this.labelColour = "white";
		}

		this.whole = whole;
		this.numberOfRods = Math.max(1,Math.ceil(this.whole/10));

		this.wholeContainer = new Container();

		var ballCounter = 0;
		this.balls = [];
		this.circleRadius = 25;
		this.diameter = 2*this.circleRadius;
		this.allRods = [];

		//We have to darken up the gradient if we are using white beads
	    var curY = 0;
	    for(var i=0;i<this.numberOfRods;i++){
	    	var nextRod = new Rectangle({height:4, width:this.diameter*12, corner:2, color:"#000000"}).addTo(this.wholeContainer).pos(0,curY);
	    	this.allRods.push(nextRod);
	    	curY += 1.7*this.diameter;
	    }


		for(var j=0;j<this.numberOfRods;j++){
			for(var i=0;i<10;i++){
				if((10*j + i) < this.whole){
					this.currentColour = i<5?"#BBBBBB":"red";
					this.radialColour = i<5?"#FFFFFF":"#FFFFFF";
					var circle = new Circle(this.circleRadius, this.currentColour, "#000000", 1).addTo(this.allRods[j]).pos(2*(i+1)*this.circleRadius, -this.circleRadius);
					var circle2 = new Circle(this.circleRadius);
					this.radialRadius = 0.5*this.circleRadius;
					circle2.colorCommand.radialGradient([this.radialColour,this.currentColour], [0, 0.9], this.radialRadius, this.radialRadius, 0.5*this.radialRadius, this.radialRadius, this.radialRadius, 1.5*this.radialRadius);
					circle2.alp(0.5).rotation = 180;
					circle2.addTo(circle);
				}
			}
		}

		this.wholeContainer.sca(this.drawWidth/this.wholeContainer.width);


		this.wholeContainer.addTo(this.contentContainer);
		this.positionLabels();

		return this;
	}

	//If you want to re-position the labels, call this function
	positionLabels(){
		//We are going to start assuming that the whole is hidden
		this.wholeContainer.center(this.contentContainer);

		return this; //for chaining
	}

	zogString(){
		return "WholeRekenrek "+this.whole;
	}
}