
//This class will show a numeric representation of a fraction.
class WholeTally extends WholeNumberRepresentation { // use JS6 extends keyword
	constructor (whole, drawWidth, drawHeight, customParms) {
		super(whole, drawWidth, drawHeight, customParms); // use JS6 super() to call the Container constructor

		if (customParms && customParms.labelColour){
			this.labelColour = customParms.labelColour;
		} else {
			this.labelColour = "white";
		}

		this.whole = whole;
		this.drawWidth = drawWidth;
		this.drawHeight = drawHeight;

		this.wholeContainer = new Rectangle({width:0.95*this.drawWidth, height:0.95*this.drawHeight, color:"rgba(0, 255, 0, 0)", borderColor:"rgba(0,0,0,0)"});

		this.numSetsOfFive = Math.floor(this.whole/5);

		this.tallyWeight = Math.max(1,Math.floor(this.wholeContainer.height*0.02));
		this.tallySpace = Math.max(4,Math.floor(this.wholeContainer.height*0.06));
		
		if (this.whole>40){
			this.tallyHeight = 0.10*this.wholeContainer.height;
		} else if (this.whole >30){
			this.tallyHeight = 0.15*this.wholeContainer.height;
		} else if (this.whole >20){
			this.tallyHeight = 0.20*this.wholeContainer.height;
		} else {
			this.tallyHeight = 0.25*this.wholeContainer.height;
		}
		this.offSet = 2*this.tallySpace;

		var xPos = 0; 
		var yPos = 0;

		//Note: the tallies report a width and height of null or nan.. so we need to figure out their actutal dimensions in order to center them on the cards
		this.actualWidth = 0;
		this.actualHeight = 0;

		this.tally = new Shape().addTo(this.wholeContainer);
		this.tally.graphics.ss(this.tallyWeight,"round").s("white");


		//draw the sets of five
		for(var f = 0; f<this.numSetsOfFive; f++){

			if (f%2 == 0) {
				xPos = 0; 
				yPos = (this.tallyHeight + this.offSet)*Math.floor(f/2);
			} else {
				xPos = 4*(this.tallySpace + this.tallyWeight) + this.offSet;
			}

			//make 4 vertical lines
			for(var c = 0; c <4; c++){
				this.tally.graphics.mt(0.5*this.offSet + c*this.tallySpace + f%2*xPos , yPos);
				this.tally.graphics.lt(0.5*this.offSet + c*this.tallySpace + f%2*xPos ,  yPos + this.tallyHeight);
			}

			//make the diagonal line
			this.tally.graphics.mt(3*this.tallySpace + 4*this.tallyWeight + 0.5*this.offSet + f%2*xPos, 0.15*this.tallyHeight + yPos);
			this.tally.graphics.lt(f%2*xPos , 0.85*this.tallyHeight + yPos);
		}

		//draw vertical lines
		if (this.numSetsOfFive%2 == 0){
			xPos = 0;
			yPos = (this.tallyHeight + this.offSet)*Math.floor(this.numSetsOfFive/2);
		} else {
			xPos = 4*(this.tallySpace + this.tallyWeight) + this.offSet; 
		}

		for(var i = 0; i < (this.whole - 5*this.numSetsOfFive); i++){
			this.tally.graphics.mt(0.5*this.offSet + i*this.tallySpace + xPos, yPos);
			this.tally.graphics.lt(0.5*this.offSet + i*this.tallySpace + xPos, yPos + this.tallyHeight);
		}

		this.tally.graphics.es();

		if(this.whole >=10){
			this.actualWidth = 2*(4*this.tallyWeight + 3*this.tallySpace + 0.5*this.offSet) + this.offSet;
		}else{
			if (this.whole <5){
				this.actualWidth = (this.whole - 5*this.numSetsOfFive)*this.tallyWeight + (this.whole - 5*this.numSetsOfFive - 1)*this.tallySpace;
			} else {
				this.actualWidth = xPos + (this.whole - 5*this.numSetsOfFive)*this.tallyWeight + (this.whole - 5*this.numSetsOfFive - 1)*this.tallySpace +0.25*this.offSet;
				if(this.whole == 5){
					this.actualWidth -=0.75*this.offSet;//adjuating for the offset added in xPos
				}
			}
		}

		if(this.whole%10 == 0){
			this.actualHeight = yPos - this.offSet;
		} else {
			this.actualHeight = yPos + this.tallyHeight;
		}

		this.wholeContainer.addTo(this.contentContainer);
		this.positionTallies();

		return this;
	}

	//If you want to re-position the Tallies, call this function
	positionTallies(){

		//liven up this code if you want to see a bounding rectangle around the tally representation.. for centering purposes
		
		/*this.testContainer = new Rectangle({width:this.actualWidth, height:this.actualHeight, color:"rgba(255, 0, 0, 0.3)", borderColor:"rgba(0,0,0,1)"});
		this.testContainer.addTo(this.wholeContainer); 
		this.testContainer.pos(this.wholeContainer.width/2 - this.actualWidth/2, this.wholeContainer.height/2 - this.actualHeight/2);*/

		this.tally.pos(this.wholeContainer.width/2 - this.actualWidth/2, this.wholeContainer.height/2 - this.actualHeight/2);
		if(this.whole <5){
			this.tally.x -= this.offSet/4;
		}

		this.wholeContainer.center(this.contentContainer);

		return this; //for chaining
	}

	zogString(){
		return "WholeTally "+this.whole;
	}
}