
//This class will show a numeric representation of a fraction.
class WholeTenFrame extends WholeNumberRepresentation { // use JS6 extends keyword
	constructor (whole, drawWidth, drawHeight, customParms) {
		super(whole, drawWidth, drawHeight, customParms); // use JS6 super() to call the Container constructor

		if (customParms && customParms.labelColour != null){
			this.labelColour = customParms.labelColour;
		} else {
			this.labelColour = "white";
		}

		if (customParms && customParms.showFace != null){
			this.showFace = customParms.showFace;
		} else {
			this.showFace = currentLevel<2;
		}

		if (customParms && customParms.useVerticalFrames != null){
			this.useVerticalFrames = customParms.useVerticalFrames;
		} else {
			this.useVerticalFrames = Math.random()<0.5;
		}

		this.whole = whole;
		this.tenFrameWidth = 50;
		this.amountLeftOver = this.whole;

		this.wholeContainer = new Container();

		var numberOfTenFrames = Math.max(1, Math.ceil(this.whole/10));
		var xPos = 0;
		var yPos = 0;
		for(var i=0;i<numberOfTenFrames;i++){
			var numberOfDots = this.amountLeftOver>=10?10:this.amountLeftOver;
			this.amountLeftOver = this.amountLeftOver-10;
			var nextFrame = this.getNewTenFrame(numberOfDots).addTo(this.wholeContainer).loc(xPos,yPos);
			if(this.useVerticalFrames){
				xPos += this.tenFrameWidth*2.5;
				yPos = 0;
			} else {
				xPos = 0;
				yPos += this.tenFrameWidth*2.5;
			}

		}

		var newScale = Math.min(this.drawWidth/this.wholeContainer.width, this.drawHeight/this.wholeContainer.height);
		this.wholeContainer.sca(newScale)
		this.wholeContainer.addTo(this.contentContainer);
		this.positionFrames();

		return this;
	}

	getNewTenFrame(numDots){
		var widthMultiplier = this.useVerticalFrames?2:5;
		var heightMultiplier = this.useVerticalFrames?5:2;
		var newTenFrame = new Rectangle(widthMultiplier*this.tenFrameWidth, heightMultiplier*this.tenFrameWidth, white, black, 2);
		// //Long line across
		// newTenFrame.shape.graphics.moveTo(0,this.tenFrameWidth);
		// newTenFrame.shape.graphics.lineTo(5*this.tenFrameWidth,this.tenFrameWidth);
		// //4 small division lines vertically
		// for(var i=1;i<=4;i++){
		// 	newTenFrame.shape.graphics.moveTo(i*this.tenFrameWidth,0);
		// 	newTenFrame.shape.graphics.lineTo(i*this.tenFrameWidth,2*this.tenFrameWidth);
		// }

		var widthPercent = 0.34;
		var starMargin = this.tenFrameWidth*(1-2*widthPercent)/2;
		var starSize = widthPercent*this.tenFrameWidth;
		var repType = Math.floor(Math.random()*3.99);
		var repColour = Math.floor(Math.random()*(tenFrameColours.length-0.01));
		var randomizeColours = Math.random()<0.5;
		var randomizeRep = Math.random()<0.5;

		var xPos = 0;
		var yPos = 0;
		for(var j=0;j<10;j++){
			//Sometimes we will randomize the colours and representations, sometimes we won't
			if(randomizeColours){
				repColour = Math.floor(Math.random()*(tenFrameColours.length-0.01));
			}
			if(randomizeRep){
				repType = Math.floor(Math.random()*2.99);
			}

			//Going to build individual squares to build the ten frame out of so that centering of the icons is easier
			var boundingSquare = new Rectangle(this.tenFrameWidth, this.tenFrameWidth, white, black, 2).addTo(newTenFrame).loc(xPos,yPos);
			if(j<numDots){
				if(repType==0){
					var nextStar = new GingerBreadPerson(2*starSize, tenFrameColours[repColour], "black", 2, this.showFace).addTo(boundingSquare).center(boundingSquare);
				} else if(repType==1){
					var nextStar = new Star(starSize, tenFrameColours[repColour], "black", 2, this.showFace).addTo(boundingSquare).center(boundingSquare);
				} else {
					var nextStar = new HappyFace(starSize, tenFrameColours[repColour], "black", 2, this.showFace).addTo(boundingSquare).center(boundingSquare);
				}
			}
			var breakPoint = 5
			if((j+1)%breakPoint==0){
				if(this.useVerticalFrames){
					xPos += this.tenFrameWidth;
					yPos = 0;
				} else {
					xPos = 0;
					yPos += this.tenFrameWidth;
				}
			} else {
				if(this.useVerticalFrames){
					yPos = yPos + this.tenFrameWidth;
				} else {
					xPos = xPos + this.tenFrameWidth;
				}
			}
		}
		return newTenFrame;
	}

	//If you want to re-position the labels, call this function
	positionFrames(){
		//We are going to start assuming that the whole is hidden
		this.wholeContainer.center(this.contentContainer);

		return this; //for chaining
	}

	zogString(){
		return "WholeTenFrame "+this.whole;
	}
}