//All the global vars needed for the game
var stage;
var stageWidth, stageHeight;
var frame;

var mathiesBlue = "#2157B0";
var mathiesBlueRollover = "CornflowerBlue";
var mathiesLightBlue = "DeepSkyBlue";
var mathiesLightBlueRollover = "SkyBlue";
var globalBackgroundColour = "white";//"#343334";
var darkWhite = "#DDDDDD";
var darkBlack = "black";
var goButtonGreen = "#068e08";
var goButtonGreenLight = "#8ae98b";
var starColour = "yellow";//"#b76e79";

var currentLevel = 3; //0 to 3 - see questionGenerator.js
var numberOfStars = [1, 2, 1, 2];

var dotColours = [
			"#ff9900", //Peach
			"#FFFF00", //Yellow
			"#32CD32", //LightGreen
			pink,
			light
		];

var tenFrameColours = [
			"#00FF00",
			"#FFFF00",
			"#00FFFF",
			"#FF00FF"
			];
var useDotPattern = false;

var levelMaximums = [5,10,20,50];
var levelMinimums = [0,0,10,20];

var playNarration = false;

var muteAllSounds = false;

var questionArray = [];

var playFaceUp = true;

var representationArray = [];

var fontFace = "arial";

var localizationIndex = 0; //0 - English, 1 - French
var localization; //object with translations (see Localization.js)
var debug = false; //a flag for operating in debug mode;
var target; //for testing

var cardWidth = 100;
var cardHeight = 100;
var menuHeight = 80;

var numberOfRows = 4;
var numberOfColumns = 6;

var openingDialog;
var matchInformationDialog;
var gameContainer;
var gameOverDialog;

var redrawInProgress = false;

function getNumberOfCards(){
	if (currentLevel == 0){
		return 12;
	} else if (currentLevel == 1){
		return 12;
	} else if (currentLevel == 2){
		return 12;
	} else {
		return 12;
	}
}

function getMargin(){
	return Math.max(5, Math.min(stageWidth, stageHeight)/50);
}

function getFooterHeight(){
	var footerHeight = Math.max(menuHeight/2, 55); // 16
	footerHeight = Math.min(footerHeight, menuHeight);
	//zog("footerHeight: "+footerHeight+" line:89 file:globalVars.js");
	return footerHeight;
}

var menuCardProportion = 0.33;

function playGameSound(theSound){
	if (!muteAllSounds){

		//If we are loading this locally, we will get it from the document directly, otherwise, use the zim library
		if(loadedLocally){
			document.getElementById(theSound).play();

			//Had to use these two methods so right.mp3 would play on iPad
		} else {
			var assetToPlay = theSound+".mp3";
			frame.asset(assetToPlay).play({volume:.15});
		}
	}
}

function setCardDimensions(){
	//the width and height should the cards, margin and buttons
	var margin = getMargin();
	cardWidth = Math.floor(Math.min((stageWidth - (numberOfColumns + 1)*margin)/numberOfColumns, (stageHeight - menuHeight - (numberOfRows + 3)*margin)/numberOfRows));
	//zog("cardWidth: "+cardWidth+" line:114 file:globalVars.js");
	cardHeight = cardWidth;
	menuHeight = Math.min(menuHeight, Math.floor(cardWidth*menuCardProportion));
	//zog("menuHeight: "+menuHeight+" line:117 file:globalVars.js");
	menuHeight = Math.max(menuHeight, Math.floor(Math.min(stageWidth, stageHeight)/9));
	//zog("menuHeight: "+menuHeight+" line:119 file:globalVars.js");
	setGridDimensions();
}

function setGridDimensions(){
	var numberOfCards = getNumberOfCards();
	var bestNumberOfRows = 4;
	var bestNumberOfColumns = 6;
	var bestDistance = Number.MAX_VALUE;
	var currentDistance;

	//find best arrangement given proportions of the screen
	//zog("stageWidth "+stageWidth+" stageHeight "+stageHeight);
	var targetTangent = Math.atan(stageHeight/stageWidth);
	var currentTangent;
	var cols;
	var margin = getMargin();
	var footerHeight = getFooterHeight();
	var actualMenuCardProportion = (menuHeight + footerHeight + 3*margin)/cardWidth;
	var marginProportion = margin/cardWidth;
	for (var rows = 1; rows <= numberOfCards; rows++) {
		cols = numberOfCards/rows;
		if (Math.floor(cols) == cols){
			//possible arrangement
			currentTangent = Math.atan((rows + (rows + 1)*marginProportion + actualMenuCardProportion)/(cols + (cols + 1)*marginProportion));
			currentDistance = Math.abs(currentTangent - targetTangent);
			if (currentDistance < bestDistance){
				bestDistance = currentDistance;
				bestNumberOfRows = rows;
				//zog("bestNumberOfRows: "+bestNumberOfRows+" line:148 file:globalVars.js");
				bestNumberOfColumns = cols;
			}
		}
	}
	numberOfRows = bestNumberOfRows;
	numberOfColumns = bestNumberOfColumns;
	cardWidth = Math.floor(Math.min((stageWidth - (numberOfColumns + 1)*margin)/numberOfColumns, (stageHeight - menuHeight - footerHeight - (numberOfRows + 3)*margin)/numberOfRows));
	cardHeight = cardWidth;
	//zog("cardWidth: "+cardWidth+" line:157 file:globalVars.js");
	//zog("dimensions "+numberOfRows+" by "+numberOfColumns);
}

function choose(arr, numToChoose){
	var bucket = [];
	var chosen = [];
	for (var i=0;i<numToChoose;i++) {
		if (bucket.length == 0){
			bucket = copyArray(arr);
		}
		var randomIndex = Math.floor(Math.random()*bucket.length);
		chosen.push(bucket.splice(randomIndex, 1)[0]);
	}
	return chosen;
}

function gup(name) {
	// Reads the requested parameter from the URL
	// from http:www.netlobo.com/url_query_string_javascript.html
	/*
	Most of the server-side programming languages, like PHP, ASP, or JSP, give you easy access to parameters in the query string of a URL. Javascript does not give you easy access. With javascript you must write your own function to parse the window.location.href value to get the query string parameters you want.
	*/
	name = name.replace(/[\[]/,"\\\[").replace(/[\]]/,"\\\]");
	var regexS = "[\\?&]"+name+"=([^&#]*)";
	var regex = new RegExp( regexS );
	var results = regex.exec(window.location.href);
	if( results == null ){
		return "na";
	}
	else {
		//trace(name +" is "+results[1]);
		return results[1];
	}
}
// from https://nullprogram.com/blog/2013/03/24/
/*function create(constructor) {
	var args = Array.prototype.slice.call(arguments, 1); //this takes constructor off the arguments list
	zog("args "+args);
	var factory = constructor.bind.apply(constructor, arguments);
	return new factory();
};*/

function massageTitle(suppliedTitle){
	suppliedTitle = suppliedTitle.replace(/%20/g, ' '); //space
	suppliedTitle = suppliedTitle.replace(/%C3%A9/g, '\xe9'); //&eacute
	suppliedTitle = suppliedTitle.replace(/%27/g, "'"); //quote
	suppliedTitle = suppliedTitle.replace(/%E2%80%99/g, "'"); //quote
	suppliedTitle = suppliedTitle.replace(/%C3%AF/g, "\xef"); //&iuml;
	suppliedTitle = suppliedTitle.replace(/%2B/g, "+");
	suppliedTitle = suppliedTitle.replace(/%28/g, "(");
	suppliedTitle = suppliedTitle.replace(/%29/g, ")");
	suppliedTitle = suppliedTitle.replace(/%29/g, ")");
	return suppliedTitle;
}

function sendAnalytics(toolName){
	// --- Google Analytics - Start --

	var languageString = localizationIndex==0?"language=en":"language=fr"
	var labelName = loadedLocally?"tools/"+toolName+"(offline)&":"tools/"+toolName+"&";
	var finalLabel = labelName+languageString;

	(function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
		(i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
		m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
	})(window,document,'script','https://www.google-analytics.com/analytics.js','ga');
	ga('create', 'UA-39088263-1', 'auto');

	if (loadedLocally){
		//If we are doing this offline - need to make sure we disable protocols

		ga('set', 'checkProtocolTask', null); // Disable file protocol checking.
		ga('set', 'checkStorageTask', null); // Disable cookie storage checking.
		ga('set', 'historyImportTask', null); // Disable history checking (requires reading from cookies).
	}

	ga('send', 'event', 'AppLoad','Browser', finalLabel);
	// --- Google Analytics - End --
}