/*Generate an array of cards to draw with their matches

Level 	0	[0,1] with denominators 2, 3, 4, 6, 8
		1	[0, 1] with denominators 1 - 12
		2	[0,5] with denominators 2, 3, 4, 6, 8
		3	[0, 5] with denominators 1 - 12 (proper, improper, mixed)

*/

var nextDisplayAsMixed = true;
var fillOrders = ["first", "last", "random"];
var nextFillOrder = 0;
//https://venngage.com/blog/color-blind-friendly-palette/
//https://www.sessions.edu/color-calculator/

var dotColoursBucket = [];
var nextUsePoint = false;
var nextUseVerticalFrames = false;
var chosenWholes;
var chosenNumerators;
var chosenDenominators;

function generateQuestions(){
	var numberOfPairs;
	var wholeArray;

	var allowMixed = false;
	numberOfPairs = Math.floor(getNumberOfCards()/2);
	//zog("currentLevel: "+currentLevel+" line:29 file:questionGenerator.js");
	this.possibleWholes = [];

	var maxNumberOfWholes = numberOfPairs;
	var numberOfWholes = 0;

	var chosenWholes = [];

	var currentChoice;
	var safetyCounter = 0;

	this.refillWholeBucket();
	while (chosenWholes.length < numberOfPairs && safetyCounter < 20){
		//choose a fraction
		var randomIndex = Math.floor(Math.random()*this.possibleWholes.length);
		currentChoice = this.possibleWholes[randomIndex];
		currentValue = currentChoice;
		chosenWholes.push(currentChoice);

		//take the fraction out of the basket
		this.possibleWholes.splice(randomIndex, 1)[0];

		if(this.possibleWholes.length==0){
			this.refillWholeBucket();
		}

		numberOfWholes++;
		safetyCounter++;
	}

	/*
	//stack the deck
	chosenWholes[0] = 5;
	chosenWholes[1] = 10;
	chosenWholes[2] = 15;
	chosenWholes[3] = 20;
	chosenWholes[4] = 35;
	chosenWholes[5] = 50;
	*/

	//choose the representations
	var numberOfRepresentations = representationArray.length;
	var numberOfDistinctPairings = numberOfRepresentations*(numberOfRepresentations - 1)/2;
	var maxTimesToUsePairing = Math.floor(numberOfPairs/numberOfDistinctPairings);
	var maxTimesToUseRepresentation = Math.floor(2*numberOfPairs/numberOfRepresentations);
	var representationPairings = [];
	var representationPairingsMax = [];
	var representationMax = [];
	var chosenRepresentationPairings = [];

	for (var i=0;i<numberOfRepresentations;i++) {
		//zog(i+": "+this.getClassName(representationArray[i])+" line:83 file:questionGenerator.js");
		for (var j=i+1;j<numberOfRepresentations;j++) {
			representationPairings.push([representationArray[i], representationArray[j]]);
			representationPairingsMax.push(maxTimesToUsePairing);
			for (var k=0;k<maxTimesToUsePairing;k++) {
				chosenRepresentationPairings.push([representationArray[i], representationArray[j]]);
			}
			//zog("Pairing: "+this.getClassName(representationArray[i])+", "+this.getClassName(representationArray[j])+" line:90 file:questionGenerator.js");
		}
		representationMax.push(maxTimesToUseRepresentation - maxTimesToUsePairing*(numberOfRepresentations - 1));
	}
	var numExtraPairings = numberOfPairs - maxTimesToUsePairing*numberOfDistinctPairings;
	var numExtraReps = 2*numberOfPairs - maxTimesToUseRepresentation*numberOfRepresentations;
	var extraReps = choose(representationArray, numExtraReps);
	var representationExtras = [];
	for (var i=0;i<numberOfRepresentations;i++) {
		if (extraReps.indexOf(representationArray[i]) > -1){
			//zog("give an extra to: "+(this.getClassName(representationArray[i]))+" line:104 file:questionGenerator.js");
			representationExtras[i] = 1;
		} else {
			representationExtras[i] = 0;
		}
	}
	//zog("representationExtras: line:110 file:questionGenerator.js");zta(representationExtras);

	//randomly pick the remainder of the pairs without blowing the bank on any particular representation
	var safetyCounter = 0;
	var pairingsBucket = copyArray(representationPairings);
	var tempPairingsBucket = copyArray(representationPairings);
	var currentRandomPairing;
	while (chosenRepresentationPairings.length < numberOfPairs && safetyCounter < 100){
		safetyCounter++;
		var randomIndex = Math.floor(Math.random()*tempPairingsBucket.length);
		currentRandomPairing = tempPairingsBucket.splice(randomIndex, 1)[0];
		//zog("Choosing: "+this.getClassName(currentRandomPairing[0])+", "+this.getClassName(currentRandomPairing[1])+" line:121 file:questionGenerator.js");
		chosenRepresentationPairings.push(currentRandomPairing);
		if (chosenRepresentationPairings.length < numberOfPairs){
			//set up for the next choice
			//take the exact choice out of the pairings bucket
			for (var s=pairingsBucket.length - 1; s>-1; s--){
				if (pairingsBucket[s][0] == currentRandomPairing[0] && pairingsBucket[s][1] == currentRandomPairing[1]){
					//zog("Found: "+this.getClassName(pairingsBucket[s][0])+", "+this.getClassName(pairingsBucket[s][1])+" line:128 file:questionGenerator.js");
					pairingsBucket.splice(s, 1);
				}
			}
			//decrement maxs of the reps involved - if used all the extras, take out of the pairings bucket
			var index0 = representationArray.indexOf(currentRandomPairing[0]);
			var index1 = representationArray.indexOf(currentRandomPairing[1])
			representationMax[index0]--;
			representationMax[index1]--;
			if (representationMax[index0] == 0){
				//take this rep out of the bucket
				this.trimBucket(tempPairingsBucket, representationArray[index0]);
			}
			if (representationMax[index1] == 0){
				//take this rep out of the bucket
				this.trimBucket(tempPairingsBucket, representationArray[index1]);
			}
			if (pairingsBucket.length == 0){
				zog("This should never happen line:148 file:questionGenerator.js");
				pairingsBucket = copyArray(representationPairings);
			}

			if (tempPairingsBucket.length == 0){
				//first try to pair any leftovers with the ones that got extra
				tempPairingsBucket = [];
				for (var i=0;i<numberOfRepresentations;i++) {
					if (representationMax[i] > 0){
						var randomPair = [];
						for (var j=0;j<numberOfRepresentations;j++) {
							if (i != j && representationExtras[j] > 0){
								randomPair.push(j);
							}
						}
						if (randomPair.length > 0){
							var pickj = choose(randomPair, 1)[0];
							representationMax[pickj]++;
							representationExtras[pickj]--;
							if (i < pickj){
								tempPairingsBucket.push([representationArray[i], representationArray[pickj]]);
							} else {
								tempPairingsBucket.push([representationArray[pickj], representationArray[i]]);
							}
							//zog("Adding to Temp: "+this.getClassName(representationArray[i])+", "+this.getClassName(representationArray[pickj])+" line:176 file:questionGenerator.js");
							break; //only do one leftover
						}
					}
				}
				for (var i=0;i<numberOfRepresentations;i++) {
					representationMax[i] += representationExtras[i];
					representationExtras[i] = 0;
				}
				if (tempPairingsBucket.length == 0){
					tempPairingsBucket = copyArray(pairingsBucket);
					for (var i=0;i<numberOfRepresentations;i++) {
						if (representationMax[i] == 0){
							//take this rep out of the bucket
							this.trimBucket(tempPairingsBucket, representationArray[i]);
						}
					}
					//zog("tempPairingsBucket.length: "+tempPairingsBucket.length+" line:197 file:questionGenerator.js");
					if (tempPairingsBucket.length == 0){
						zog("we are backed into a corner line:199 file:questionGenerator.js");
						for (var i=0;i<numberOfRepresentations;i++) {
							if (representationMax[i] > 0){
								for (var j=i+1;j<numberOfRepresentations;j++) {
									if (representationMax[j] > 0){
										chosenRepresentationPairings.push([representationArray[i], representationArray[j]]);
										representationMax[i]--;
										representationMax[j]--;
									}
								}
								break;
							}
						}
					}
				}
			}
		}
	}
	//zog("safetyCounter: "+safetyCounter+" line:202 file:questionGenerator.js");

	//setup the questionArray
	//var traceString = "";
	questionArray = [];
	for (var i=0;i<numberOfPairs;i++) {
		questionArray.push(addQuestion(chosenRepresentationPairings[i][0], chosenWholes[i]));
		questionArray.push(addQuestion(chosenRepresentationPairings[i][1], chosenWholes[i]));
		//traceString += chosenWholes[i]+" -- ";
	}
	//zog(traceString);
}

function trimBucket(tempPairingsBucket, rep){
	for (var s=tempPairingsBucket.length - 1; s>-1; s--){
		if (tempPairingsBucket[s][0] == rep || tempPairingsBucket[s][1] == rep){
			//zog("Found: "+this.getClassName(pairingsBucket[s][0])+", "+this.getClassName(pairingsBucket[s][1])+" line:253 file:questionGenerator.js");
			tempPairingsBucket.splice(s, 1);
		}
	}
}

function refillWholeBucket(){
	for (var i=levelMinimums[currentLevel];i<=levelMaximums[currentLevel];i++){
		this.possibleWholes.push(i);
	}
	if (levelMaximums[currentLevel]==20){
		//We are going to add a single number between 2 and 9 that could be chosen for the 0-20 range
		this.possibleWholes.push(Math.floor(Math.random()*(7))+2);
	}
}

function addQuestion(repClass, whole){
	var customParms;
	var randomIndex;
	var repClassName = getClassName(repClass);
	if (repClass == WholeDots){
		if (dotColoursBucket.length == 0){
			dotColoursBucket = copyArray(dotColours);
		}
		var randomIndex = Math.floor(Math.random()*dotColoursBucket.length);
		customParms = {dotColour:dotColoursBucket.splice(randomIndex, 1)[0]};
	} else if (repClass == WholeNumberLine){
		customParms = {usePoint:nextUsePoint};
		nextUsePoint = !nextUsePoint;
	} else if (repClass == WholeTenFrame){
		customParms = {useVerticalFrames:nextUseVerticalFrames};
		nextUseVerticalFrames = !nextUseVerticalFrames;
	}
	//zog(whole+"  "+numerator+"/"+denominator);
	return {
		representation:
			{
				repClass:repClass,
				repClassName:repClassName,
				whole:whole,
				customParms:customParms
			},
		sortOrder:Math.random()
	};
}

function getClassName(repClass){
	if (repClass == WholeDots){
		return "WholeDots";
	} else if (repClass == WholeNumberLine){
		return "WholeNumberLine";
	} else if (repClass == WholeDice){
		return "WholeDice";
	} else if (repClass == WholeHands){
		return "WholeHands";
	} else if (repClass == WholeNumeric){
		return "WholeNumeric";
	} else if (repClass == WholeRekenrek){
		return "WholeRekenrek";
	} else if (repClass == WholeTally){
		return "WholeTally";
	} else if (repClass == WholeTenFrame){
		return "WholeTenFrame";
	}
}