class ubDie extends Container { // use JS6 extends keyword based on edu.clips2.draw.drawComposite.ubDie

	constructor (customParms) {
		super();

		var classInfo = {
			propertyDefaults:
				[
					{
						numberToDisplay:5,
						size:50,
						paddingBetween:0.2,
						paddingAround:0.6
					},
					{
						outlineInit:
							{
								color:white,
								borderColor:black
							}
					},
					{
						pipInit:
							{
								color:black
							}
					}
				]
		};

		if (!customParms){
			customParms = {};
		}

		/** height of one row of the Array in pixels */
		this.numberToDisplay = customParms.numberToDisplay != null?customParms.numberToDisplay:classInfo.propertyDefaults[0].numberToDisplay;
		/** width of one column of the Array in pixels */
		this.size = customParms.size?customParms.size:classInfo.propertyDefaults[0].size;
		/** the padding to use at the left of each cell, in pixels*/
		this.paddingBetween = customParms.paddingBetween?customParms.paddingBetween:classInfo.propertyDefaults[0].paddingBetween;
		/** the padding to use at the top of each cell, in pixels*/
		this.paddingAround = customParms.paddingAround?customParms.paddingAround:classInfo.propertyDefaults[0].paddingAround;

		this.outlineInit = customParms.outlineInit?customParms.outlineInit:classInfo.propertyDefaults[1].outlineInit;

		this.pipInit = customParms.pipInit?customParms.pipInit:classInfo.propertyDefaults[2].pipInit;

		this.drawDie();
		return this;
	}

	drawDie(){
		//zog("drawDie starts line:53 file:ubDie.js");
		if (this._outline && this._outline.parent){
			this._outline.parent.removeChild(this._outline);
		}

		//the rounded rectangle outline
		var outlineRoundedRadius = Math.round(this.size/12);
		if (outlineRoundedRadius < 3){
			//rounded looks gimpy for smaller dice
			outlineRoundedRadius = 0;
		}
		this.outlineInit.width = this.size;
		this.outlineInit.height = this.size;
		this.outlineInit.corner = outlineRoundedRadius;
		this._outline = new Rectangle(this.outlineInit).addTo(this);

		//create 9 pips
		this._pipLayer = new Container().addTo(this._outline);
		this._pipArray = [];

		var pipDiameter = Math.floor(this.size/(3 + 2*(this.paddingAround + this.paddingBetween)));
		var margin = Math.ceil(this.paddingAround*pipDiameter);
		var hSpace = Math.ceil(this.paddingBetween*pipDiameter);
		pipDiameter = (this.size - 2*(margin + hSpace))/3;

		var _pipInit = this.pipInit;
		_pipInit.radius = pipDiameter/2;

		var creatorArray = (new ubShapeArray()).creatorToCreatorArray(
			{
				creatorClass:Circle,
				creatorInit:_pipInit
			}, 3, 3);

		this._shapeArray = new ubShapeArray({
				rowHeight:pipDiameter,
				columnWidth:pipDiameter,
				hPadding:hSpace,
				vPadding:hSpace,
				creatorArray:creatorArray
			})
			.addTo(this._pipLayer)
			.loc(margin + this._outline.x, margin + this._outline.y);
		this._pipArray = this._shapeArray.getObjectArray();

		//hide the pips unneeded for the numberToDisplay
		if (this.numberToDisplay % 2 == 0){
			//even numbers don't need middle pip
			this._pipArray[1][1].visible = false;
			if (this.numberToDisplay < 8){
				this._pipArray[1][0].visible = false;
				this._pipArray[1][2].visible = false;
				if (this.numberToDisplay < 6){
					this._pipArray[0][1].visible = false;
					this._pipArray[2][1].visible = false;
					if (this.numberToDisplay < 4){
						this._pipArray[0][2].visible = false;
						this._pipArray[2][0].visible = false;
						if (this.numberToDisplay < 2){
							this._pipArray[0][0].visible = false;
							this._pipArray[2][2].visible = false;
						}
					}
				}
			}
		} else {
			//odd numbers
			if (this.numberToDisplay < 9){
				this._pipArray[1][0].visible = false;
				this._pipArray[1][2].visible = false;
				if (this.numberToDisplay < 7){
					this._pipArray[0][1].visible = false;
					this._pipArray[2][1].visible = false;
					if (this.numberToDisplay < 5){
						this._pipArray[0][2].visible = false;
						this._pipArray[2][0].visible = false;
						if (this.numberToDisplay < 3){
							this._pipArray[0][0].visible = false;
							this._pipArray[2][2].visible = false;
						}
					}
				}
			}
		}
		this._pipLayer.center();
	}

	getDimensions(){
		return {width:this.size, height:this.size};
	}
}