class ubShapeArray extends Container { // use JS6 extends keyword based on edu.clips2.draw.ubShapeArray

	constructor (customParms) {
		//zog("constructing a ubShapeArray line:4 file:ubShapeArray.js");
		super();

		var classInfo =
			{
				propertyDefaults:
					[
						{
							rowHeight:50,
							columnWidth:50,
							hPadding:5,
							vPadding:5
						}
					]
			};

		if (!customParms){
			customParms = {};
		}

		/** height of one row of the Array in pixels */
		this.rowHeight = customParms.rowHeight?customParms.rowHeight:classInfo.propertyDefaults[0].rowHeight;
		/** width of one column of the Array in pixels */
		this.columnWidth = customParms.columnWidth?customParms.columnWidth:classInfo.propertyDefaults[0].columnWidth;
		/** the padding to use at the left of each cell, in pixels*/
		this.hPadding = customParms.hPadding?customParms.hPadding:classInfo.propertyDefaults[0].hPadding;
		/** the padding to use at the top of each cell, in pixels*/
		this.vPadding = customParms.vPadding?customParms.vPadding:classInfo.propertyDefaults[0].vPadding;

		/** an array of creatorClass Inits of the dimensions desired*/
		//zog("customParms.creatorArray: line:34 file:ubShapeArray.js");zta(customParms.creatorArray);
		this.creatorArray = customParms.creatorArray?customParms.creatorArray:[];
		//zog("this.creatorArray: line:36 file:ubShapeArray.js");zta(this.creatorArray);
		this._objectArray = [];

		this.drawShapeArray();
		return this;
	}

	drawShapeArray(){
		//trace("draw starts line:44 file:ubShapeArray.js");
		this.removeObjects();
		this._objectArray = [];

		//zog("this.creatorArray.length: "+this.creatorArray.length+" line:48 file:ubShapeArray.js");
		for (var row=0; row < this.creatorArray.length; row ++){
			this._objectArray.push([]);
			//zog("this.creatorArray[row].length: "+this.creatorArray[row].length+" line:51 file:ubShapeArray.js");
			for (var col=0; col < this.creatorArray[row].length; col ++){
				/*var mergedCreatorInit = ubObject.mergeObjects(
					this.creatorArray[row][col].creatorInit, {
						x: col*(this.hPadding+this.columnWidth),
						y: row*(this.vPadding+this.rowHeight)
					}, true);*/
				var mergedCreatorInit =
					this.creatorArray[row][col].creatorInit;
				var shape = new this.creatorArray[row][col].creatorClass(mergedCreatorInit)
					.addTo(this)
					.loc(col*(this.hPadding+this.columnWidth), row*(this.vPadding+this.rowHeight));
				this._objectArray[row].push(shape);
			}
		}
		//zog("this._objectArray: line:66 file:ubShapeArray.js");zta(this._objectArray);
	}

	/*private function getDimensions(){
		return {width:this.size, height:this.size};
	}*/
	/**returns the two-dimensional array of objects*/
	getObjectArray(){
		//trace("getObjectArray starts line:74 file:ubShapeArray.js");
		return this._objectArray;
	}

	/**removes all the objects*/
	removeObjects(){
		//zog("stack at line:80 file:ubShapeArray.js:");console.trace();
		var currentObj;
		for (var row=0; row < this._objectArray.length; row ++){
			for (var col=0; col < this._objectArray[row].length; col ++){
				currentObj = this._objectArray[row][col];
				if (currentObj && currentObj.parent){
					currentObj.parent.removeChild(currentObj);
				}
			}
		}
	}

	/**used to create a creatorArray of the appropriate dimensions when all the shapes are the same*/
	creatorToCreatorArray(classCreator, numberRows, numberColumns){
		//zog(numberRows+ " by "+numberColumns+" line:94 file:ubShapeArray.js");
		var returnArray = [];
		for (var row=0; row < numberRows; row ++){
			returnArray.push([]);
			for (var col=0; col < numberColumns; col ++){
				returnArray[row].push(classCreator);
			}
		}
		return returnArray;
	}
}