// ZIM js Interactive Media framework https://zimjs.com by Dan Zen http://danzen.com (c) 2018
// Also see https://zimjs.com/distill to minify only the functions in your app
// free to use - donations welcome of course! https://zimjs.com/donate

// global variable to hold default frame - used by other ZIM modules like physics, etc.
var zimDefaultFrame;


////////////////  ZIM WRAP  //////////////

// Zim Wrap creates global wrapper functions for less typing

// set var zon=false before calling zim scripts to hide script comments
if (typeof zon == "undefined") var zon = true; // comments from zim scripts
if (typeof zns == 'undefined') var zns = false; // require zim namespace
/*--
zog(item1, item2, etc.)         ~ log

zog
global function

DESCRIPTION
Short version of console.log()
to log the item(s) to the console.
Use F12 to open your Browser console.
zog is dedicated to Pragma (Madeline Zen) who was coding with Dr Abstract (Dan Zen) from the start

Note: If zon (comments on) is set to false before ZIM runs, then all zog() commands are turned off

EXAMPLE
zog("hello", circle.x); // logs these values to the console
END EXAMPLE

PARAMETERS
item1, item2 (optional), etc. - items (expressions) to log to the console

RETURNS items it is logging separated by a space if more than one
--*///+0
// reported a bug in Firefox: https://bugzilla.mozilla.org/show_bug.cgi?id=1280818
// that after FF 46 binding the console did not show file and line number
// this is fixed in FF 50 - quite the conversation this stirred
var zog = zon?console.log.bind(console):function(){};
//-0

/*--
zid(string)                     ~ id

zid
global function

DESCRIPTION
Short version of document.getElementById(string)
to access an HTML tag by its id.

EXAMPLE
zid("logo").addEventListener("click", function(){});
END EXAMPLE

PARAMETERS
string - the id of the tag you are wanting to access

RETURNS HTML tag with id of string or null if not found
--*///+1
function zid(s) {
	z_d("1");
	return document.getElementById(s);
} //-1

/*--
zss(string)                     ~ css

zss
global function

DESCRIPTION
Short version of document.getElementById(string).style
to access the style property of an HTML tag by the tag id.

EXAMPLE
zss("logo").margin = "10px";
END EXAMPLE

PARAMETERS
string - the id of the tag whose style you are wanting to access

RETURNS style property of HTML tag with id of string or undefined if not found
--*///+2
function zss(s) {
	z_d("2");
	if (document.getElementById(s)) {return document.getElementById(s).style;}
	else if (zon) zog("zim wrap - zss(): id not found");
} //-2

/*--
zgo(url, target, width, height, fullscreen, modal)         ~ go

zgo
global function

DESCRIPTION
Short version of either window.location.href or window.open
to open a link in the same window or a specified window.

EXAMPLE
zid("logo").addEventListener("click", function(){zgo("http://zimjs.com");});

// with a ZIM object:
var button = new Button();
button.center(stage);
button.on("click", function() {zgo("http://zimjs.com");});
END EXAMPLE

PARAMETERS
url - the link to use (Absolute, Relative or Virtual)
target - (default null) the string name of a window (tab) _blank for new window each time
width - (default null) width of window (use with fullscreen true)
height - (default null) height of window (use with fullscreen true)
fullscreen - (default null) not really full screen but rather opens in a new window not tab
modal - (default false) set to true to force user to close window

RETURNS null if opening in same window or reference to the window otherwise
--*///+3
function zgo(u,t,w,h,f,m) {
	z_d("3");
	if ((zot(t) && t != "") || t == "_self") {
		window.location.href = u;
	} else {
		var added = "";
		if (w) added += "width=" + w + ",";
		if (h) added += "height=" + h + ",";
		if (f) added += "fullscreen=yes,";
		if (m) added += "modal=yes,alwaysRaised=yes";
		return window.open(u,t,added);
	}
} //-3

/*--
zum(string)                     ~ num

zum
global function

DESCRIPTION
Takes the units off a string number.
Converts "10px" string from styles to number 10, for instance.
If there is no value then this will return 0.

EXAMPLE
// in HTML
<div id="logo" style="position:relative; left:10px">LOGO</div>

// in JavaScript
var left = zum(zss("logo").left); // converts 10px to the Number 10
left += 20; // adds 20 to 10
zss("logo").left = left + "px"; // assigns 30px to left style
END EXAMPLE

PARAMETERS
string - the string representation of a number eg. "10px"

RETURNS a Number
--*///+4
function zum(s) {
	z_d("4");
	if (zot(s)) return;
	return Number(String(s).replace(/[^\d\.\-]/g, ''));
} //-4

/*--
zot(value)                      ~ not

zot
global function

DESCRIPTION
Test to see if value has no value (value must exist as var or parameter)
or if value has been set to null.
Good for setting function defaults.
Really just asking if the value == null.
Often we forget exactly how to do this - it is tricky:
value === null, value == undefined, value == 0, !value DO NOT WORK.

EXAMPLE
if (zot(width)) width = 100;
// equivalent to
if (width == null) width = 100;
END EXAMPLE

PARAMETERS
value - a variable or parameter you want to see if there is no value assigned

RETURNS Boolean true if value does not exist
--*///+4.5
function zot(v) {
	return v==null; // both null and undefined match but not false or 0
}//-4.5

/*--
zop(e)                          ~ stop

zop
global function

DESCRIPTION
Stop event propagation to subsequently added existing listeners.
Must pass it e || window.event from your event function.
NOTE: this is not canceling the default action -
to cancel default action use e.preventDefault();

EXAMPLE
zid("button").addEventListener("click", function(e) {
	// do something
	zop(e||window.event);
});
END EXAMPLE

PARAMETERS
e - the event object from your event function
 	collect the event object as e and then pass in e || window.event

RETURNS null
--*///+5
function zop(e) {
	z_d("5");
	if (zot(e)) return;
	if (e.stopImmediatePropagation) e.stopImmediatePropagation();
	if (window.event) window.event.cancelBubble=true;
} //-5

/*--
zil()                           ~ still

zil
global function

DESCRIPTION
Stop keys from moving content - arrows, spacebar, pgup, pgdown, home, end.
Stop scroll wheel from moving content - scrolling the canvas for instance.
ZIM Frame does this in the full, fit and outside scale modes.
If not using Frame, then you can do this once at the start of your code.
Returns an array of references to three listeners: [keydown, wheel and DOMMouseScroll].
Use these to removeEventListeners.
The arrows, etc, still work but just not their default window behaviour.

EXAMPLE
// at the top of your code
var listenersArray = zil();
// key and mousewheel arrows, spacebar, etc.
// will have their default actions stopped until you remove the listeners:
// window.removeEventListener("keydown", listenersArray[0]); // etc.
END EXAMPLE

RETURNS an Array
--*///+6
function zil() {
	z_d("6");
	var a = function(e) {if (!e) e = event; if (e.keyCode && (e.keyCode >= 32 && e.keyCode <= 40)) e.preventDefault();}
	var b = function(e) {if (!e) e = event; e.preventDefault();}
	var c = b;
	window.addEventListener("keydown", a, {passive:false});
	window.addEventListener("wheel", b, {passive:false});
	window.addEventListener("DOMMouseScroll", c, {passive:false});
	return [a, b, c];
} //-6

/*--
zet(selector)                   ~ set

zet
global function

DESCRIPTION
Uses document.querySelectorAll() to get a list of tags.
Returns a ZIM Zet object which can be used to add events or styles to the set.

EXAMPLE
zet(".class").on("click", function(){}); // would add function event to all tags with the class
zet("p").css("color", "goldenrod"); // would make the text of all paragraphs goldenrod
zet("#test").css({color:"red", "backgound-color":"blue", paddingLeft:"20px"});

// set a custom open property on all section bars to false
zet("section .bar").prop("open", false);
// set the custom open property on all section bars to true and set the innerHTML to CLOSE
zet("section .bar").prop({open: true, innerHTML: "CLOSE"});
END EXAMPLE

PARAMETERS
selector -  a CSS query selector such as a class, id, tag, or multiple selectors separated by commands
	can also be complex selectors suchs as ".class img"

METHODS (on the returned Zet object)
zet(selector).on(type, function) - a shortcut for addEventListener() and will be added to all tags matching the selector
zet(selector).off(type, function) - a shortcut for removeEventListener() and will be remove from all tags matching the selector
zet(selector).css(property, value) - gets and sets styles
	- gets the first programmatic property if a single string property is passed
	- sets the property to the value on each of the Zet's tags from the selector passed to zet()
	- if an object of properties and values is passed as the single parameter then sets all these properties
	- NOTE: style names do not need quotes unless the dash is used - so camelCase does not require quotes
	- NOTE: remember that commas are used for objects - not the semi-colon as in CSS
zet(selector).prop(property, value) - gets or sets a property on a set of tags
	- if an object of properties and values is provided as a single parameter, then sets all these on the set
	- else if no value is set then returns an array of the set tags values for the property
	- else if value is a single value then sets the property of the tags in the set to the value

PROPERTIES  (on the returned Zet object)
tags - an HTML NodeList tag list

RETURNS Zet object with on(), off(), css() methods and tags property (NodeList tag list)
--*///+6.1
function zet(selector) {
	z_d("6.1");
	function Zet() {
		var that = this;
		this.on = function(type, call) {
			if (zot(selector) || zot(type) || zot(call)) return;
			var tags = that.tags;
			for (var i=0; i<tags.length; i++) {
				tags[i].addEventListener(type, call);
			}
		}
		this.off = function(type, call) {
			if (zot(selector) || zot(type) || zot(call)) return;
			var tags = that.tags;
			for (var i=0; i<tags.length; i++) {
				tags[i].removeEventListener(type, call);
			}
		}
		Object.defineProperty(that, 'tags', {
			get: function() {
				if (zot(selector)) return [];
				if (typeof selector == 'string' || selector instanceof String) {
					return document.querySelectorAll(selector);
				} else { // selector is already an object - assume a tag
					if (typeof (selector).innerHTML == "string") return [selector];
					return [];
				}
			},
			set: function(t) {
			}
		});
		this.css = function(property, value) {
			// if property is object then assign all props in object
			var tags = that.tags;
			for (var i=0; i<tags.length; i++) {
				if (arguments.length == 1 && arguments[0].constructor === {}.constructor) {
					for (var p in property) {
						tags[i].style[p] = property[p];
					}
				} else if (arguments.length == 1) {
					return that.tags[0].style[property];
				} else {
			    	tags[i].style[property] = value;
				}
			}
		}
		this.prop = function(property, value) {
			if (zot(property)) return;
			var tags = that.tags;
			var a = [];
			for (var i=0; i<tags.length; i++) {
				if (zot(value)) {
					if (property.constructor === {}.constructor) {
						for (var p in property) {
							tags[i][p] = property[p];
						}
					} else {
						a.push(tags[i][property]);
					}
				} else {
			    	tags[i][property] = value;
				}
			}
			if (zot(value)) return a;
		}
	}
	return new Zet();
} //-6.1

/*--
zob(func, args, sig, scope)     ~ object

zob
global function

DESCRIPTION
A system to build functions or classes that allow traditional parameters
or a configuration object passed in as a single parameter.
The configuration object has property names that match the function arguments.

To use zob on your own functions, pass in a function and the function's arguments
and insert zob into first line of your function as shown below.
Replace yourFunction with a reference to your function but keep arguments as is.

EXAMPLE
function test(a,b,c){
	var duo; if (duo = zob(test, arguments)) return duo;
};
test(1,null,3); // traditional parameters in order
test({a:1,c:3}); // configuration object with zob
END EXAMPLE

NOTE: if you are minifying the file then you need to do an extra step
add a string version of the signature of your function above the duo call
then pass the signature in as a parameter to zob()

EXAMPLE
function test(a,b,c){
	var sig = "a,b,c";
	var duo; if (duo = zob(test, arguments, sig)) return duo;
};
END EXAMPLE

NOTE: if you are running the function as a constructor with the new keyword
then you need to pass in this (keyword) as the last parameter (sig can be null)
this allows zob() to test to see if we need to rerun the function as a constructor

EXAMPLE
var duo; if (duo = zob(yourFunction, arguments, sig, this)) return duo;
END EXAMPLE

many of the ZIM functions and classes use this "DUO" technique
the documentation for parameters will tell you if they support DUO
works also with JS6 default parameter values

PARAMETERS
func - reference to the function you want to use params or a config object with
args - reference to the arguments property of the function (literally, use "arguments" with no quotes)
sig - (default null) a string listing of the parameters just how they are in the () not including the ()
	required if you are minifying the file as minifying changes the signature
scope - (default null) reference to this (litterally, use "this" without the quotes)
	required if the function is being run with the new keyword

RETURNS um... a Boolean
--*///+7
function isDUO(a) {return a.length == 1 && a[0] != undefined && a[0].constructor === {}.constructor;}
function zob(func, args, sig, scope) {
	var zimon = (zim && (zim.ZIMONON || window.ZIMONON));
	if (isDUO(args)) {
		z_d("7");
		var zp = args[0];
		var za = (zot(sig))?func.toString().split(/\n/,1)[0].match(/\((.*)\)/)[1].replace(/\s+/g,"").split(","):sig.replace(/\s+/g,"").split(",");
		var zv = []; var zi; var zt;
		for (zi=0; zi<za.length; zi++) {zt=za[zi].split("=")[0]; za[zi]=zt; zv.push(zp[zt]);}
		for (zi in zp) {if (za.indexOf(zi)<0) {if (zon) zog(func,"bad argument "+zi);}};
		var zr; if (zr=(func.prototype.isPrototypeOf(scope))?new (func.bind.apply(func,[null].concat(zv)))():func.apply(null,zv)) {if (zimon && !zr.arguments) {zr.arguments = [zp]}; return zr;} else {return true;}
	} else {
		if (zimon && scope && args && zot(scope.arguments)) {
			scope.arguments = Array.prototype.slice.call(args);
		}
	}
}//-7

/*--
zik(Array|function|object|Pick)      ~ pick

zik
global function

DESCRIPTION - DEPRECIATED as of ZIM 10
Has now been replaced with ZIM Pick() class which formalizes zik() and ZIM VEE into a more general class.
See ZIM Pick() under the Code module Classes.
--*///+7.5
function zik(v) {
	z_d("7.5");
	z_d("17.6");
	if (zot(v)) return;
	return zim.Pick.choose(v);
}//-7.5

/*--
zta(item1, item2, etc.)         ~ table

zta
global function

DESCRIPTION
Short version of console.table()
to log the Arrays or Objects to the console as a table
Use F12 to open your Browser console.

Note: if zon (comments on) is set to false before ZIM runs then all zta() commands will be turned off

EXAMPLE
zta(["will", "this", "wind"]); // logs as a table
END EXAMPLE

PARAMETERS
item1, item2 (optional), etc. - Arrays or Objects to log to the console

RETURNS items it is logging
--*///+7.6
var zta = console.table&&zon?console.table.bind(console):function(){};
//-7.6

// the above functions are global for quick usage
// start the zim module pattern - from here on, everything is stored on the zim namespace

var zim = function(zim) {

	// zim colors -- also stored on Frame object for legacy
	zim.orange	= "#f58e25";
	zim.green  	= "#acd241";
	zim.pink  	= "#e472c4";
	zim.blue   	= "#50c4b7";
	zim.brown  	= "#d1a170";
	zim.yellow  = "#ebcb35";
	zim.purple	= "#993399";
	zim.red 	= "#fb4758"; // dedicated to Alexa
	zim.silver	= "#999999";
	zim.tin		= "#777777";
	zim.grey   	= "#555555";
	zim.gray 	= "#555555";
	zim.lighter = "#eeeeee";
	zim.moon 	= "#dddddd";
	zim.light 	= "#cccccc";
	zim.dark 	= "#333333";
	zim.darker 	= "#111111";
	zim.black 	= "#000000";
	zim.white	= "#ffffff";
	zim.clear 	= "rgba(0,0,0,0)";
	zim.faint 	= "rgba(0,0,0,.01)";

////////////////  ZIM CODE  //////////////

// Zim Code adds some general code functionality along with Browser and DOM code
// some of these are common Web solutions over the years (sorry for lack of credit)

// SUBSECTION FEATURED

/*--
zim.shuffle = function(array)

shuffle
zim function

DESCRIPTION
Randomly shuffles elements of an array.
Actually changes the original array (and also returns it).

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var array = ["happy", "sad", "spooked"];
var randomFromArray = shuffle(array)[0];
// this will be randomized each time it is run
END EXAMPLE

EXAMPLE
var array = shuffle(["happy", "sad", "spooked"]);
for (var i=0; i<array.length) zog(array[i]);
// this will get random and unique elements of the array
END EXAMPLE

PARAMETERS
array - the Array to shuffle

RETURNS the modified Array
--*///+8
	zim.shuffle = function(array) {
		z_d("8");
		if (zot(array)) return;
		var i = array.length, j, temp;
		if (i == 0) return array;
		while(--i) {
			j = Math.floor(Math.random()*(i+1));
			temp=array[i];
			array[i]=array[j];
			array[j]=temp;
		}
		return array;
	}//-8

/*--
zim.rand = function(a, b, integer, negative)

rand
zim function

DESCRIPTION
Returns a random integer between and including a and b if integer is true.
Returns a random number (with decimals) including a and up to b but not b if integer is false.
b is optional and if left out will default to 0 (includes 0).
integer is a boolean and defaults to true.
If a and b are 0 then just returns Math.random().

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var speed = rand(10,20); // 10, 11, 12... 18, 19 or 20

var colors = ["blue", "yellow", "green"];
var color = colors[rand(colors.length-1)]; // note the length-1

// the equivalent of:
var color = colors[Math.floor(Math.random()*colors.length)];

// OR a technique often used without using rand():
var color = shuffle(colors)[0];

// here we get a speed that is either from 5 to 10 or -5 to -10
var speed = rand(5,10,null,true);
END EXAMPLE

PARAMETERS
a - the first Number for the range
	if a and b are not provided, rand() acts like Math.random()
	if parameter b is not provided, rand will use range 0 to and including a
b - (default 0) second Number for the range
	it does not matter if a>b or a<b
integer - (default true) set to false to include decimals in results
	if false, range will include decimals up to but not including the highest number
	if a or b have decimals this is set to false
negative - (default false) includes the negative range as well as the positive

RETURNS a Number
--*///+9
	zim.rand = function(a, b, integer, negative) {
		z_d("9");
		if (zot(a) && zot(b)) return Math.random();
		if (zot(a) || isNaN(a)) a = 0;
		if (zot(b) || isNaN(b)) b = 0;
		if (a%1!=0 || b%1!=0) integer = false;
		if (zot(integer)) integer = true;
		if (negative) if (Math.random()>.5) {a*=-1; b*=-1;};
		if (integer) if (a>b) {a++;} else if (b>a) {b++;}
		var r;
		if (a == 0 && b == 0) return 0;
		else if (b == 0) r = Math.random()*a;
		else r = Math.min(a,b) + Math.random()*(Math.max(a,b)-Math.min(a,b));
		if (integer) return Math.floor(r);
		else return r;
	}//-9

/*--
zim.series = function(array|item1, item2, item3)

series
zim function

DESCRIPTION
Returns a function that will return each value passed as a parameter (or an Array) in order
This goes in sequence each time the function is called
Use this to pass a series in to any ZIM VEE value so a looping series is obtained

NOTE: was called makeSeries() which is now depreciated

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
// note - do not call the variable name series
var s = series(red, green, blue);
s(); // red
s(); // green
s(); // blue
s(); // red, etc.

// or
var colors = [red, green, blue];
var s = series(colors);
s(); // red
s(); // green
s(); // blue
s(); // red, etc.

new Tile(new Rectangle(10,10,[blue, red]), 10, 10); would randomize colors
new Tile(new Rectangle(10,10,series(blue, red)), 10, 10); would alternate colors
END EXAMPLE

EXAMPLE
STYLE = {color:series(pink, green, blue)}
loop(9, function (i) {
	new Circle(100).loc(110+i*100, 400)
});
END EXAMPLE

PARAMETERS
array|item1 - the first item - or an array of results that will be called in order as the resulting function is called
    // when used with ZIM VEE - the values may be further ZIM VEE values (including more series values)
item2 - the second item if the first is not an array
item3 - the third item, etc. to as many items as needed

PROPERTIES
array - an array of items passed in to the function

RETURNS a function that can be called many times - each time returning the next value in the series
--*///+13.61
	zim.series = function() {
		z_d("13.61");
		var array;
		if (arguments.length == 0) return function(){};
		if (arguments.length == 1 && Array.isArray(arguments[0])) array = arguments[0];
		else array = arguments;
        var count = 0;
        var f = function() {
            return array[(count++)%array.length];
        }
        f.array = array;
		f.type = "series";
        return f;
	}//-13.61

/*--
zim.makeSeries = function(array)
	depreciated - use series()
--*///+13.6
	zim.makeSeries = function(array) {
		z_d("13.6");
        if (zot(array)) return function(){};
        var count = 0;
        var f = function() {
            return array[(count++)%array.length];
        }
        f.array = array;
        return f;
	}//-13.6

/*--
zim.loop = function(obj, call, reverse, step, start, end)

loop
zim function

DESCRIPTION
1. If you pass in a Number for obj then loop() does function call that many times
and passes function call the currentIndex, totalLoops, startIndex, endIndex, obj.
By default, the index starts at 0 and counts up to one less than the number.
So this is like: for (var i=0; i<obj; i++) {}

2. If you pass in an Array then loop() loops through the array
and passes the function call the element in the array, currentIndex, totalLoops, startIndex, endIndex and the array.
So this is like: for (var i=0; i<obj; i++) {element = array[i]}

3. If you pass in an Object literal then loop() loops through the object
and passes the function call the property name, value, currentIndex, totalLoops, startIndex, endIndex, obj
So this is like: for (var i in obj) {property = i; value = obj[i];}

4. If you pass an HTML NodeList or HTMLCollection then loop() loops and gives each tag in the NodeList or HTMLCollection
see ZIM zet() for an example of getting a NodeList (like the $() in JQuery)

5. See also the loop method under ZIM Methods to see how to loop through a ZIM Container

NOTE: If you pass in true for reverse, the loop is run backwards counting to 0 (by default)
NOTE: use return to act like a continue in a loop and go to the next loop
NOTE: return a value to return out of the loop completely like a break (and return a result if desired)

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var container = new Container();
loop(1000, function(i) { // gets passed an index i, totalLoops 1000, startIndex 0, endIndex 999, obj 1000
	// make 1000 rectangles
	container.addChild(new Rectangle());
});
stage.addChild(container);

// to continue or break from loop have the function return the string "continue" or "break"
loop(10, function(i) {
	if (i%2==0) return; // skip even
	if (i>6) return "break"; // quit loop when > 6
	zog(i);
});

var colors = [green, yellow, pink];
loop(colors, function(color, index, start, end, array) { // do not have to collect all these
	zog(color); // each color
});

var person = {name:"Dan Zen", occupation:"Inventor", location:"Dundas"}
var result = loop(person, function(prop, val, index, total, start, end, object) { // do not have to collect all these
	zog(prop, val); // each key value pair
	if (val == "criminal") return "criminal"; // this would return out of the loop to the containing function
});
if (result == "criminal") alert("oh no!");

var tags = zet(".heading").tags; // get an NodeList of tags styled with heading class
loop(tags, function(tag, i) {
	tag.innerHTML = i + ". " + tag.innerHTML; // add an index number in front
});
END EXAMPLE

PARAMETERS supports DUO - parameters or single object with properties below
obj - a Number of times to loop or an Array or Object or NodeList to loop through
call - the function to call
	the function will receive (as its final parameters) the index, total, start, end, obj
		where the index is the current index, total is how many times the loop will run
		start is the start index, end is the end index and obj is the object passed to the loop
	the starting parameters vary depending on the type of obj:
	if the obj is a number then the first parameter is the index (no extra starting parameters given)
	if the obj is an array then the first parameter is the element at the current index
	if the obj is an object literal then the first and second parameters are the property name and property value at the current index
reverse - (default false) set to true to run the loop backwards to 0
step - (default 1) each step will increase by this amount (positive whole number - use reverse to go backwards)
start - (default 0 or length-1 for reverse) index to start
end - (default length-1 or 0 for reverse) index to end

RETURNS any value returned from the loop - or undefined if no value is returned from a loop
--*///+9.5
	zim.loop = function(obj, call, reverse, step, start, end) {
		var sig = "obj, call, reverse, step, start, end";
		var duo; if (duo = zob(zim.loop, arguments, sig)) return duo;
		z_d("9.5");
		if (zot(obj) || zot(call)) return undefined;
		if (zot(reverse)) reverse = false;
		if (zot(step) || step <= 0) step = 1;

		var type = typeof obj=="number"?"number":(obj.constructor === Array?"array":(obj.constructor === {}.constructor?"object":(obj instanceof NodeList?"nodelist":(obj instanceof HTMLCollection?"htmlcollection":"invalid"))));

		if (type == "invalid") {
			return undefined;
		}
		if (type == "number" || type == "array" || type == "nodelist" || type == "htmlcollection") {
			var length = type=="number"?obj:obj.length;
			var total = getTotal(length-1);
			if (total == 0) return;
			if (reverse) {
				for(var i=start; i>=end; i-=step) {
					if (type=="number") {
						var r = call(i, total, start, end, obj);
					} else if (type=="array") {
						var r = call(obj[i], i, total, start, end, obj);
					} else { // nodelist
						var r = call(obj.item(i), i, total, start, end, obj);
					}
					if (typeof r != 'undefined') return r;
				}
			} else {
				for(var i=start; i<=end; i+=step) {
					if (type=="number") {
						var r = call(i, total, start, end, obj);
					} else if (type=="array") {
						var r = call(obj[i], i, total, start, end, obj);
					} else { // nodelist or htmlcollection
						var r = call(obj.item(i), i, total, start, end, obj);
					}
					if (typeof r != 'undefined') return r;
				}
			}
		} else if (type == "object") {
			var length = 0;
			var props = [];
			for (var i in obj) {
				length++;
				props.push(i);
			}
			var total = getTotal(length-1);
			if (total == 0) return;
			if (reverse) {
				for(var i=start; i>=end; i-=step) {
					var r = call(props[i], obj[props[i]], i, total, start, end, obj);
					if (typeof r != 'undefined') return r;
				}
			} else {
				for(var i=start; i<=end; i+=step) {
					var r = call(props[i], obj[props[i]], i, total, start, end, obj);
					if (typeof r != 'undefined') return r;
				}
			}
		}
		function getTotal(max) {
			if (zot(start)) start = reverse?max:0;
			if (zot(end)) end = reverse?0:max;
			if ((reverse && end > start) || (!reverse && start > end)) return 0;
			if ((start < 0 && end) <0 || (start > max && end > max)) return 0;
			start = Math.max(0, Math.min(start, max));
			end = Math.max(0, Math.min(end, max));
			return Math.floor((reverse?(start-end):(end-start)) / step) + 1;
		}
	}//-9.5

/*--
zim.timeout = function(time, call)

timeout
zim function

DESCRIPTION
Calls a function after the time delay - like window.setTimeout()
Uses window.requestAnimationFrame() that tends to rest when the window is not showing

NOTE: setTimeout has the time parameter last, timeout has it first
so that it is consistent with loop() and the CreateJS on() method

NOTE: to clear a timeout you use returnID.clear() - different than window.clearTimeout(returnID)

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
timeout(1000, function(){
	circle.x += 100;
	stage.update();
});
// moves the circle 100 pixels after one second

// GAME to press button within one second:
var timeout = timeout(1000, function() {
	zog("you lose!");
	button.enabled = false;
});
var button = new Button().center(stage);
button.on("click", function() {
	zog("you win!");
	timeout.clear();
});
END EXAMPLE

PARAMETERS
** supports VEE - parameters marked with ZIM VEE mean a zim Pick() object or Pick Literal can be passed
   Pick Literal formats: [1,3,2] - random; {min:10, max:20} - range; series(1,2,3) - order, function(){return result;} - function
time - |ZIM VEE| milliseconds to wait until function is called
call - function to call when the time passes - will receive the id object as a single parameter

RETURNS a ZIM timeoutObject to pause and clear the timeout with the following methods and properties:

METHODS - of ZIM timeoutObject
pause(state, immediate, restart) - (default true) will pause the timeout - set to false to unpause the timeout at the time remaining
	immediate (default false) set to true to make the timeout function run right away when unpausing (no effect when pausing)
	reset (default false) set to true to set the timeout back to 0 time passed when unpausing (no effect when pausing)

clear() - will clear the timeout

PROPERTIES - of ZIM timeoutObject
time - the time in milliseconds that has lapsed
paused - the paused state of the timeout
done - true if finished
--*///+9.7
	zim.timeout = function(time, call) {
		z_d("9.7");
		if (zot(call)) return;
		if (typeof call != 'function') return;
		if (zot(time)) time = 1000;
		time = zim.Pick.choose(time);
		var obj = {startTime:Date.now(), time:0, paused:false, done:false};
		var lastTime = obj.startTime;
		function next() {
			var now = Date.now()
			obj.time += now - lastTime;
			lastTime = now;
			if (obj.time >= time) {
				obj.done = true;
				(call)(obj);
				obj.clear();
				return;
			}
			obj.rid = requestAnimationFrame(next);
		}

		obj.pause = function(state, immediate, reset) {
			if (zot(state)) state = true;
			if (state) { // pausing
				cancelAnimationFrame(obj.rid);
			} else { // unpausing
				if (immediate) lastTime = 0; // a long time ago ;-)
				else if (reset) {lastTime = Date.now(); obj.time=0}
				else lastTime = Date.now();
				next();
			}
			obj.paused = state;
		}

		obj.clear = function() {
			if (obj) cancelAnimationFrame(obj.rid);
			for (var i in obj) {
				delete obj[i];
			}
			obj.pause = function() {};
			obj.clear = function() {};
		}
		next(); // thanks StevenWarren for the glitch fix!
		return obj;
	}//-9.7

/*--
zim.interval = function(time, call, total, immediate)

interval
zim function

DESCRIPTION
Calls a function after each time delay - like window.setInterval().
Can pass in an Array of two times to set random time delays each interval.
Can pass in how many times you want to run the function and whether it runs right away.
Uses window.requestAnimationFrame() that tends to rest when the window is not showing.

NOTE: setInterval has the time parameter last, interval has it first
so that it is consistent with loop() and the CreateJS on() method

NOTE: to clear a interval you use intervalObj.clear() - different than window.clearInterval(returnID)

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
interval(1000, function(){
	circle.x += 100;
	stage.update();
});
// every second the circle will move 100 pixels
// if you want smooth movement, use:

Ticker.add(function() {
	circle.x += 100; // no need for stage.update()
});

interval(1000, function(obj) {
	zog("counting " + obj.count); // starts counting at 1
	if (obj.count == 10) obj.clear(); // will now log 1 to 10
});
OR better:
interval(1000, function(obj) {
	zog("counting " + obj.count); // starts counting at 1
}, 10); // now will log 1 - 10 with total parameter set to 10

IMMEDIATE:
interval(1000, function(obj) {
	zog("counting " + obj.count); // starts counting at 0
}, 10, true); // now will log 0 - 9 with immediate parameter set to true

EXTERNAL control:
var interval = interval(1000, function() {
	zog("counting " + interval.count); // starts counting at 1
});
var button = new Button({label:"STOP", toggle:"START"}).center(stage);
button.on("click", function(){interval.pause(button.toggled);});

RANDOM intervals with ZIM Pick() literals
interval({min:200, max:800}, dropBombs); // bombs will fall at different rates between 200ms and 800ms
interval([1000, 2000], dropBombs); // bombs will fall at either 1000 or 2000 ms
var count = 1;
function increase() {return ++count*1000}
interval(increase, dropBombs); // bombs will fall at 1000, then again after 2000 more ms and 3000 ms more after that, etc.
END EXAMPLE

PARAMETERS
** supports VEE - parameters marked with ZIM VEE mean a zim Pick() object or Pick Literal can be passed
   Pick Literal formats: [1,3,2] - random; {min:10, max:20} - range; series(1,2,3) - order, function(){return result;} - function
time - |ZIM VEE| (default 1000) milliseconds for the interval (delay until the function runs - again and again)
call - function to call when the interval passes
	Will be passed a ZIM intervalObject as a single parameter
	This is the same as the return object from animate()
	See the Returns section below for methods and properties of the intervalObject
total - (default null - infinite) the number of times the function is called
	note: the count property counts intervals but the total property is based on function calls.
	The total will be equal to the end count with the immediate parameter set to false (default)
	but the total will be one less than the count if the immediate parameter is true (like an Array index and length)
immediate - (default false) set to true to call the function right away (and then still call every interval)
	This will not increase the count in the intervalObject because count counts intervals not function calls
	Use the provided parameter of the call function to access the intervalObject inside the call function

RETURNS a ZIM intervalObject to pause and clear the interval with the following methods and properties:

METHODS - of ZIM intervalObject
pause(state, immediate, reset) - (default true) will pause the interval - set to false to unpause the interval with time left
	immediate (default false) set to true to make the interval function run right away when unpausing (no effect when pausing)
	reset (default false) set to true to set the interval back to 0 time passed when unpausing (no effect when pausing)
clear() - will clear the interval

PROPERTIES - of ZIM intervalObject
time - |ZIM VEE| get or set the time for the interval (see time parameter)
count - get the number of times the interval has run (if immediate is true, the first count is 0)
total - get or set the number of times the interval will run if the total parameter is set - otherwise -1 for infinite
paused - get the paused state of the interval (see pause() method)
pauseTimeLeft - if paused, get how much time is left once unpaused
--*///+9.8
	zim.interval = function(time, call, total, immediate) {
		z_d("9.8");
		if (zot(call)) return;
		if (typeof call != 'function') return;
		if (zot(time)) time = 1000;
		if (zot(immediate)) immediate = false;
		if (!zot(total) && (isNaN(total) || total<=0)) return;
		if (zot(total)) total = -1;
		var obj = {count:0, total:total, paused:false, time:time, active:true};


		function interval() {
			obj.startTime = Date.now();
			obj.interval = zim.Pick.choose(obj.time);
			obj.id = setTimeout(function() {
				if (obj.paused) return;
				if (!obj.active) return;
				obj.rid = requestAnimationFrame(interval);
				obj.count++;
				(call)(obj);
				checkTotal();
			}, obj.interval);
		}
		if (immediate) {
			setTimeout(function() {
				(call)(obj);
				checkTotal();
			}, 10);
		}
		function checkTotal() {
			if (total == -1) return;
			if (obj.count >= (immediate?obj.total-1:obj.total)) obj.clear();
		}
		var pausedTimeout;
		obj.pause = function(state, immediate, reset) {
			if (zot(state)) state = true;
			if (state) { // pausing
				clearTimeout(pausedTimeout);
				clearTimeout(obj.id);
				cancelAnimationFrame(obj.rid);
				obj.pauseTimeLeft = obj.interval - (Date.now()-obj.startTime);
			} else { // unpausing
				if (!obj.paused) obj.pause(true);
				pausedTimeout = setTimeout(function() {
					obj.count++;
					(call)(obj);
					interval();
					checkTotal();
				}, immediate?0:reset?obj.interval:obj.pauseTimeLeft);
				obj.pauseTimeLeft = null;
			}
			obj.paused = state;
		}
		obj.clear = function() {
			obj.active = false;
			clearTimeout(pausedTimeout);
			cancelAnimationFrame(obj.rid);
			clearTimeout(obj.id);
			var count = obj.count;
			for (var i in obj) {
				delete obj[i];
			}
			obj.active = false;
			obj.count = count;
			obj.pause = function() {};
			obj.clear = function() {};
		}
		interval();
		return obj;
	}//-9.8

/*--
zim.async = function(url, callback)

async
zim function

DESCRIPTION
A way to send data back and forth to a server script without reloading the HTML page.
(like AJAX but without the bother)
Uses a dynamic script call with an optional callback (cross domain calls are okay)
also known as JSON-P pattern but JSON is unnecessary - note, no JSON in the examples below.
Pass a url to the server script (ie. php or node page)
and an optional callback function that you define in your code (cannot be an anonymous function).
async will automatically add a random number to the end of your script call to defeat cache.

NOTE: async uses GET so data is limited to GET length (as of ZIM 10 - this is 2K to 8K depending on Browser)
If more data is required, use an AJAX library

Note: async uses an r CGI key to send a random number to defeat cache.
Do not send an r property

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
// existing service:
// assuming that we have a callback function called test as shown below
async("http://ip-api.com/json?callback=async.test",test);
function test(data) {zog(data.country);}
// note that the callback we pass the service is async.test not just test
// this allows zim to handle scope issues and garbage collect the dynamic script when done
// if the service passes JSON you may need to JSON.decode() the data being returned
// this service passes an object literal not JSON despite its file name
END EXAMPLE

EXAMPLE
// CLIENT - your own server script:
// assuming we have a callback function called myFunction as shown below
async("http://yourserver.com/script.php?id=72&name=dan", myFunction);
function myFunction(data){zog(data);}

// SERVER - your script must output the following format as a string:
// "async.myFunction(somedata)"
// in the php file we would use:
header('Content-type: text/javascript');
echo "async.myFunction('success')";
// to return an object literal with nodejs express for example, you would use:
res.send('async.myFunction({list:[1,2,3], name:"whatever"})');
// the data parameter in the myFunction function defined earlier would be an object literal
// we could then do zog(data.list[0]) to log the value 1, etc.
END EXAMPLE

PARAMETERS
url - url to the server script (ie. php or node page)
	Note: async uses an r CGI key to send a random number to defeat cache - do not send an r property
callback - (default null) callback function that you define in your code (cannot be an anonymous function)

calling the return function on async does two things:
1. it handles scope issues so we can find your callback function
2. it handles garbage collection to remove the dynamic script tag that was used
if you do not specify a callback function then just send "" back from your server script
NOTE: we have experienced duplicate script calls if nothing is sent back

RETURNS undefined
--*///+29
	zim.async = function (url, callback) {
		z_d("29");
		if (zot(url)) return;
		var tag = document.createElement("script");
		if (callback) {
			var n = callback.toString().split(/\n/,1)[0].match(/^function\s?([^\s(]*)/)[1];
			// create callback bridge on async function object
			zim.async[n] = function() { // closure to access tag on callback bridge
				var t = tag;
				return function(d){
					// remove the script tag and do the callback
					if (t) t.parentNode.removeChild(t); t = null;
					callback(d);
				}
			}();
		} else {
			if (zim.async.z_s && zim.async.z_s.parentNode) zim.async.z_s.parentNode.removeChild(zim.async.z_s); // keep overwriting same script tag if no callback
			zim.async.z_s = tag;
		}
		if (!url.match(/\?/)) url += "?";
		tag.setAttribute("src", url + "&r="+Math.random());
		document.getElementsByTagName("head")[0].appendChild(tag);
	}//-29

/*--
zim.convertColor = function(color, toColorType, alpha)

convertColor
zim function

DESCRIPTION
Converts color to hex numbers - for example: "#333333"
Or converts color to HTML string - for example: "red"
Or converts color to RGB - for example: "rgb(0,0,0)"
Or converts color to RGBA - for example: "rgba(0,0,0,.5)"

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var color = convertColor("red"); // result is "#ff0000"
var color = convertColor("#ff0000", "string"); // result is "red"
var color = convertColor("f00", "string"); // result is "red" - note missing # okay and can use three digits
var color = convertColor(blue, "rgba", .5); // result is "rgba(80,196,183,0.5)"
var color = convertColor("rgb(256,256,0)", "rgba", .3); // result is ""rgba(256,256,0,.3)"
var color = convertColor("rgba(0,0,0,.2)", anyType, .5); // result is ""rgba(0,0,0,.5)"
END EXAMPLE

PARAMETERS
color - (default black) the HTML string or hex color (case insensitive)
	"rgb()" in only works with "rgba" out else returns rgb() value
	"rgba()" in only returns same thing with rgba() alpha set to alpha parameter
toColorType - (default "hex") or use "string", "rgb" or "rgba"
alpha - (default 1) the alpha used for the "rgba" toColorType

RETURNS a String with the converted color or black if a match is not found
--*///+27.5
	zim.convertColorCheck = false;
	zim.convertColor = function(color, toColorType, alpha) {
		if (!zim.convertColorCheck) {z_d("27.5"); zim.convertColorCheck=true;}
		if (zot(toColorType)) toColorType = "hex";
		if (zot(alpha)) alpha == 1;
		if (zot(color)) return;
		if (color.match(/rgba\(/)) {
			var c = color.split(",");
			c[3] = alpha+")";
			return c.join(",");
		}
		if (color.match(/rgb\(/)) {
			if (toColorType == "rgba") {
				var c = color.split(")");
				return c[0]+","+alpha+c[1];
			} else return color;
		}

		if (toColorType == "rgb" || toColorType == "rgba") {
			function hexToRgbA(hex){ // kennebec on StackOverflow
				var c;
				if(/^#([A-Fa-f0-9]{3}){1,2}$/.test(hex)){
					c= hex.substring(1).split('');
					if(c.length== 3){
						c= [c[0], c[0], c[1], c[1], c[2], c[2]];
					}
					c= '0x'+c.join('');
					if (toColorType == "rgb") {
						return 'rgb('+[(c>>16)&255, (c>>8)&255, c&255]+')';
					} else {
						return 'rgba('+[(c>>16)&255, (c>>8)&255, c&255].join(',')+','+alpha+')';
					}

				} else {
					if (toColorType == "rgb") {
						return "rgb(0,0,0)";
					} else {
						return "rgba(0,0,0,1)";
					}
				}
			}
			if (color.charAt(0)=="#") {
				return hexToRgbA(color);
			} else {
				return hexToRgbA(zim.convertColor(color));
			}
		} else if (toColorType == "hex") {
			if (color.charAt(0)=="#") return color; // already hex
		} else {
			if (color.charAt(0)=="#") {
				color = color.replace("#","");
				if (color.length == 3) {
					color = color.charAt(0)+color.charAt(0)+color.charAt(1)+color.charAt(1)+color.charAt(2)+color.charAt(2);
				}
			}
		}
		var colors = ['black','aliceblue','antiquewhite','aqua','aquamarine','azure','beige','bisque','blanchedalmond','blue','blueviolet','brown','burlywood','cadetblue','chartreuse','chocolate','coral','cornflowerblue','cornsilk','crimson','cyan','darkblue','darkcyan','darkgoldenrod','darkgray','darkgrey','darkgreen','darkkhaki','darkmagenta','darkolivegreen','darkorange','darkorchid','darkred','darksalmon','darkseagreen','darkslateblue','darkslategray','darkslategrey','darkturquoise','darkviolet','deeppink','deepskyblue','dimgray','dimgrey','dodgerblue','firebrick','floralwhite','forestgreen','fuchsia','gainsboro','ghostwhite','gold','goldenrod','gray','grey','green','greenyellow','honeydew','hotpink','indianred','indigo','ivory','khaki','lavender','lavenderblush','lawngreen','lemonchiffon','lightblue','lightcoral','lightcyan','lightgoldenrodyellow','lightgray','lightgrey','lightgreen','lightpink','lightsalmon','lightseagreen','lightskyblue','lightslategray','lightslategrey','lightsteelblue','lightyellow','lime','limegreen','linen','magenta','maroon','mediumaquamarine','mediumblue','mediumorchid','mediumpurple','mediumseagreen','mediumslateblue','mediumspringgreen','mediumturquoise','mediumvioletred','midnightblue','mintcream','mistyrose','moccasin','navajowhite','navy','oldlace','olive','olivedrab','orange','orangered','orchid','palegoldenrod','palegreen','paleturquoise','palevioletred','papayawhip','peachpuff','peru','pink','plum','powderblue','purple','rebeccapurple','red','rosybrown','royalblue','saddlebrown','salmon','sandybrown','seagreen','seashell','sienna','silver','skyblue','slateblue','slategray','slategrey','snow','springgreen','steelblue','tan','teal','thistle','tomato','turquoise','violet','wheat','white','whitesmoke','yellow','yellowgreen'];
		var hex = ['000000','f0f8ff','faebd7','00ffff','7fffd4','f0ffff','f5f5dc','ffe4c4','ffebcd','0000ff','8a2be2','a52a2a','deb887','5f9ea0','7fff00','d2691e','ff7f50','6495ed','fff8dc','dc143c','00ffff','00008b','008b8b','b8860b','a9a9a9','a9a9a9','006400','bdb76b','8b008b','556b2f','ff8c00','9932cc','8b0000','e9967a','8fbc8f','483d8b','2f4f4f','2f4f4f','00ced1','9400d3','ff1493','00bfff','696969','696969','1e90ff','b22222','fffaf0','228b22','ff00ff','dcdcdc','f8f8ff','ffd700','daa520','808080','808080','008000','adff2f','f0fff0','ff69b4','cd5c5c','4b0082','fffff0','f0e68c','e6e6fa','fff0f5','7cfc00','fffacd','add8e6','f08080','e0ffff','fafad2','d3d3d3','d3d3d3','90ee90','ffb6c1','ffa07a','20b2aa','87cefa','778899','778899','b0c4de','ffffe0','00ff00','32cd32','faf0e6','ff00ff','800000','66cdaa','0000cd','ba55d3','9370db','3cb371','7b68ee','00fa9a','48d1cc','c71585','191970','f5fffa','ffe4e1','ffe4b5','ffdead','000080','fdf5e6','808000','6b8e23','ffa500','ff4500','da70d6','eee8aa','98fb98','afeeee','db7093','ffefd5','ffdab9','cd853f','ffc0cb','dda0dd','b0e0e6','800080','663399','ff0000','bc8f8f','4169e1','8b4513','fa8072','f4a460','2e8b57','fff5ee','a0522d','c0c0c0','87ceeb','6a5acd','708090','708090','fffafa','00ff7f','4682b4','d2b48c','008080','d8bfd8','ff6347','40e0d0','ee82ee','f5deb3','ffffff','f5f5f5','ffff00','9acd32'];
		if (toColorType == "string") {
			return colors[hex.indexOf(color.toLowerCase())!=-1?hex.indexOf(color):0];
		} else {
			return "#"+hex[colors.indexOf(color.toLowerCase())!=-1?colors.indexOf(color):0];
		}
	}//-27.5

/*--
zim.colorRange = function(color1, color2, ratio)

colorRange
zim function

DESCRIPTION
Gets the color in a range between two colors based on a ratio from 0-1
Used internally by setColorRange() method and colorRange property of ZIM shapes
including animating color from current color to a new color

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
zog(colorRange(green, blue, .5)); // #7ecb7c
var rect = new Rectangle(100,100,red).center().setColorRange(purple);
rect.colorRange = .1; will change color to #f1455e (closer to red than purple)
rect.animate({color:purple}, 1000); // will animate color to purple in one second
rect.wiggle("colorRange", .5, .2, .5, 1000, 5000); // wiggles the color in the range
END EXAMPLE

PARAMETERS
color1 - (default null) the first color as an HTML string or hex color (case insensitive)
color2 - (default black) the second color as an HTML string or hex color (case insensitive)
ratio - (default .5) the ratio where 0 is the first color and 1 the second color

RETURNS a hex color string
--*///+27.6
	zim.colorRangeCheck = false;
	zim.colorRange = function(color1, color2, ratio) {
		ratio = Math.max(0, Math.min(1, ratio));
		if (!zim.colorRangeCheck) {z_d("27.6"); zim.colorRangeCheck=true;}
		// thanks Chris Dolphin - StackOverflow
		// modified by Dan Zen to use hex input and output
		// possibly converting and converting back - but not quite...
		if (zot(color1)) color1 = "white";
		if (zot(color2)) color2 = "black";
		var c1 = zim.convertColor(color1, "rgb");
		var c2 = zim.convertColor(color2, "rgb");
		var color1 = c1.substring(4, c1.length - 1).split(',');
		var color2 = c2.substring(4, c2.length - 1).split(',');
		var difference;
		var newColor = "#";
		var c;
		for (var i=0; i<color1.length; i++) {
			difference = color2[i] - color1[i];
			c = Math.floor(parseInt(color1[i], 10) + difference * ratio).toString(16);
			if (c.length < 2) c = "0"+c;
			newColor += c;
		}
		return newColor;
	}//-27.6


/*--
zim.pointAlongCurve = function(points, ratio, getAngle)

pointAlongCurve
zim function

DESCRIPTION
Finds a point along a cubic Bezier curve - such as that used in Blob and Squiggle
as well as the Shape.graphics.bezierCurveTo() or tiny api bt()
Used internally for animating along Blob and Bezier curves

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
// point1, control1, control2, point2
var points = [{x:100,y:100}, {x:200,y:100}, {x:200,y:100}, {x:200,y:200}]
var shape = new Shape().addTo();
shape.graphics
	.s("black").ss(2)
	.mt(points[0].x,points[0].y)
	.bt(points[1].x,points[1].y, points[2].x,points[2].y, points[3].x,points[3].y);
new Circle(10,red).loc(pointAlongCurve(points, .2));
END EXAMPLE

PARAMETERS
points - an array of point objects (or objects with an x and y property)
	for a cubic Bezier - point1, control1, control2, point2
ratio - (default .5) the ratio where 0 is at the first point and 1 is at the second point
getAngle - (default false) request a calculated angle of tangent at point

RETURNS a point object with x and y properties on the curve at the ratio
	as well as an angle property for the tangent if getAngle is true
--*///+27.7
	zim.pointAlongCurve = function(points, ratio, getAngle) {
		z_d("27.7");
		// Thanks markE - StackOverflow
		if (!points || !points[0] || !points[1] || !points[2] || !points[3]) return;
		var x=CubicN(ratio,points[0].x,points[1].x,points[2].x,points[3].x);
		var y=CubicN(ratio,points[0].y,points[1].y,points[2].y,points[3].y);
		if (getAngle) {
			var nextRatio = ratio+.05;
			if (nextRatio > 1) {
				ratio -= .05;
				nextRatio -= .05;
				// redo the ratio
				var x0=CubicN(ratio,points[0].x,points[1].x,points[2].x,points[3].x);
				var y0=CubicN(ratio,points[0].y,points[1].y,points[2].y,points[3].y);
			} else {
				var x0 = x;
				var y0 = y;
			}
			var x2 = CubicN(nextRatio,points[0].x,points[1].x,points[2].x,points[3].x);
			var y2 = CubicN(nextRatio,points[0].y,points[1].y,points[2].y,points[3].y);
			var angle = zim.angle(x0, y0, x2, y2);
			return({x:x,y:y,angle:angle});
		}
		return({x:x,y:y});
	}
	// cubic helper formula at percent distance
	function CubicN(pct, a,b,c,d) {
		var t2 = pct * pct;
		var t3 = t2 * pct;
		return a + (-a * 3 + pct * (3 * a - a * pct)) * pct
		+ (3 * b + pct * (-6 * b + b * 3 * pct)) * pct
		+ (c * 3 - c * 3 * pct) * t2
		+ d * t3;
	}//-27.7

/*--
zim.distanceAlongCurve = function(points)

distanceAlongCurve
zim function

DESCRIPTION
Finds approximate distance along a cubic Bezier curve - such as that used in Blob and Squiggle
as well as the Shape.graphics.bezierCurveTo() or tiny api bt()
Used internally for animating along Blob and Bezier curves

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
// point1, control1, control2, point2
var points = [{x:100,y:100}, {x:200,y:100}, {x:200,y:100}, {x:200,y:200}]
var shape = new Shape();
shape.graphics
	.s("black").ss(2)
	.mt(points[0].x,points[0].y)
	.bt(points[1].x,points[1].y, points[2].x,points[2].y, points[3].x,points[3].y);
zog(distanceAlongCurve(points)); // 170.7
END EXAMPLE

PARAMETERS
points - an array of point objects (or objects with an x and y property)
	for a cubic Bezier - point1, control1, control2, point2

RETURNS an approximate distance along the curve
--*///+27.8
	zim.distanceAlongCurve = function(points) {
		z_d("27.8");
		// Thanks David F. Knight in OpenGl.org forumn
		// points are [startPt, controlPt1, controlPt2, endPt]
		var chord = zim.dist(points[0], points[3]);
		var controlDist = zim.dist(points[0], points[1]) + zim.dist(points[1], points[2]) + zim.dist(points[2], points[3]);
		return (chord + controlDist)/2;
	}//-27.8

/*--
zim.closestPointAlongCurve = function(point, segmentPoints, num, interpolate, percentage)

closestPointAlongCurve
zim function

DESCRIPTION
Finds the closest point along a cubic Bezier curve before the given point.
Blob and Squiggle use cubic Bezier as does the Shape.graphics.bezierCurveTo() or tiny api bt()
Used internally for adding points to a Blob and Bezier curves

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var blob = new Blob().center();
var points = blob.segmentPoints;
stage.on("stagemousedown", function (e) {
	var point = blob.globalToLocal(e.stageX, e.stageY)
	zog(closestPointAlongCurve({x:point.x, y:point.y}, points))
	// gives index of point on curve before mouse location
});
END EXAMPLE

PARAMETERS
point - an object with an x and y property
	this could be {x:100, y:140} or circle, etc.
	the results tell which segment to add the point to
	the segment starting with the returned index
segmentPoints - an array of cubic Bezier point data
	each being an array of points for a cubic Bezier
	in the format of [point1, control1, control2, point2]
	Note, this is not the same as Blob or Squiggle points
	but rather use the segmentPoints property of Blob and Squiggle
num - (default 10) the number of points per segment used to calculate answer
interpolate - (default false) will return closest test point - not index of closest existing point
percentage - (default false) will return percent (0-100) the nearest point is on the path (overrides interpolate)
RETURNS the index of the closest point in segmentPoints before the given point
	or if interpolate is true, will return the closest testPoint (use higher num for better result)
	or if percentage is true, will return percent (0-100) the nearest point is on the path (overrides interpolate)
--*///+27.9
	zim.closestPointAlongCurve = function(point, segmentPoints, num, interpolate, percentage) {
		z_d("27.9");
		var closest = 10000000;
		var closestTestPoint;
		var index = 0;
		var secondaryIndex = 0;
		if (zot(num)) num = 10;
		zim.loop(segmentPoints, function(points, i, t) {
			// add num more points to estimate closest
			zim.loop(num, function (j, total) {
				// var d = zim.dist(point, zim.pointAlongCurve(segmentPoints(that.points[i], that.points[i<t-1?i+1:0]), j/10));
				var testPoint = zim.pointAlongCurve(points, j/total);
				var d = zim.dist(point, testPoint);
				if (d < closest) {
					closest = d;
					closestTestPoint = testPoint
					index = i;
					secondaryIndex = j;
				}
			});
		});
		if (percentage) {
			return (index*num+secondaryIndex)/(segmentPoints.length*num)*100;
		} else if (interpolate) {
			return closestTestPoint;
		}
		return index;

	}//-27.9

/*--
zim.transformPoints = function(points, transformType, amount, x, y)

transformPoints
zim function

DESCRIPTION
Scales, rotates, or moves points about provided x and y - or 0, 0 if x and y are not provided
Used internally by Squiggle and Blob transformPoints method

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
// from https://zimjs.com/nio/paths.html
var points = [[0,75,0,0,-150,150,150,-150],[300,75,0,0,0,0,0,0,"none"]];
var newPoints = transformPoints(points, "scale", 2);
// [[0,150,0,0,-300,300,300,-300],[600,150,0,0,0,0,0,0,"none"]]
END EXAMPLE

EXAMPLE
// or used with Squiggle:
var points = [[0,75,0,0,-150,150,150,-150],[300,75,0,0,0,0,0,0,"none"]];
var squiggle = new Squiggle({points:points}).transformPoints("scale", 2);
// a squiggle with points twice as big as before
END EXAMPLE

PARAMETERS
points - an array of points in the Squiggle and Blob format (controlType is left as is)
	[[controlX, controlY, circleX, circleY, rect1X, rect1Y, rect2X, rect2Y, controlType], [etc]]
transformType - String any of: "scale", "scaleX", "scaleY", "rotation", "x", "y"
amount - the amount to transform
x, y - (default 0, 0) the x and y position to transform about

RETURNS an array of points with numbers transformed
--*///+27.95
	zim.transformPoints = function(points, transformType, amount, x, y) {
		z_d("27.95");
		if (zot(points) || !Array.isArray(points)) return;
		if (zot(x)) x = 0;
		if (zot(y)) y = 0;
		var points = zim.copy(points);
		var xStart = x;
		var yStart = y;
		if (transformType == "rotation") {
			if (x != 0) points = zim.transformPoints(points, "x", -xStart);
			if (y != 0) points = zim.transformPoints(points, "y", -yStart);
		}
		var point;
		for (var i=0; i<points.length; i++) {
			point = points[i];
			if (!Array.isArray(point)) continue;
			// [[controlX, controlY, circleX, circleY, rect1X, rect1Y, rect2X, rect2Y, controlType], [etc]]
			if (transformType == "x") {
				point[0] += amount;
			} else if (transformType == "y") {
				point[1] += amount;
			} else if (transformType == "scaleX") {
				point[0] = (point[0]-x)*amount+x;
				point[4] = (point[4])*amount;
				point[6] = (point[6])*amount;
			} else if (transformType == "scaleY") {
				point[1] = (point[1]-y)*amount+y;
				point[5] = (point[5])*amount;
				point[7] = (point[7])*amount;
			} else if (transformType == "scale") {
				point[0] = (point[0]-x)*amount+x;
				point[4] = (point[4])*amount;
				point[6] = (point[6])*amount;
				point[1] = (point[1]-y)*amount+y;
				point[5] = (point[5])*amount;
				point[7] = (point[7])*amount;
			} else if (transformType == "rotation") {
				var a = amount*Math.PI/180;
				var x1 = point[0];
				var y1 = point[1];
				point[0] = x1*Math.cos(a) - y1*Math.sin(a);
				point[1] = y1*Math.cos(a) + x1*Math.sin(a);

				x1 = point[4];
				y1 = point[5];
				point[4] = x1*Math.cos(a) - y1*Math.sin(a);
				point[5] = y1*Math.cos(a) + x1*Math.sin(a);

				x1 = point[6];
				y1 = point[7];
				point[6] = x1*Math.cos(a) - y1*Math.sin(a);
				point[7] = y1*Math.cos(a) + x1*Math.sin(a);
			}
		}
		if (transformType == "rotation") {
			if (x != 0) points = zim.transformPoints(points, "x", xStart);
			if (y != 0) points = zim.transformPoints(points, "y", yStart);
		}
		return points;
	}//-27.95

/*--
zim.makeID = function(length, type, letterCase)

makeID
zim function

DESCRIPTION
makes a random letter, number or mixed id of specified length

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var id1 = makeID(); // five random letters and numbers (starts with letter)
var id2 = makeID(null, "string"); // five random uppercase letters
var id3 = makeID(10, "number"); // ten random numbers
var id4 = makeID(5, ["Z", "I", "M", 1, 2, 3, 4, 5, "-"]); // random five characters from array (possibly repeating)
END EXAMPLE

PARAMETERS
length - (default 5) the length of the id
type - (default "mixed") set to "letters" or "numbers" as well
	note: no O, 0, 1, I or L due to identification problems
	pass in an array of characters to make an id from only those characters
letterCase - (default uppercase) - set to "lowercase" or "mixed" as well

RETURNS a String id (even if type is number)
--*///+13.5
	zim.makeID = function(type, length, letterCase) {
		z_d("13.5");
		if (zot(type)) type = "mixed";
		if (zot(length)) length = 5;
		if (zot(letterCase)) letterCase = "uppercase";
		var choices;
		var nums = [2,3,4,5,6,7,8,9];
		var lets = "abcdefghjkmnpqrstuvwxyz".split("");
		if (type.constructor === Array) {
			choices = type;
		} else if (type == "numbers") {
			choices = nums;
		} else if (type == "letters") {
			choices = lets;
		} else {
			choices = nums.concat(lets);
		}
		var id = "";
		var c; // character - note, char is a reserved word for compressor!
		var rand;
		for (var i=0; i<length; i++) {
			c = choices[Math.floor(Math.random()*choices.length)];
			rand = Math.random();
			if (letterCase == "uppercase" || (letterCase == "mixed" && rand > .5)) {
				if (c.toUpperCase) c = c.toUpperCase();
			} else {
				if (c.toLowerCase) c = c.toLowerCase();
			}
			id += String(c);
		}
		return id;
	}//-13.5

/*--
zim.swapProperties = function(property, objA, objB)

swapProperties
zim function

DESCRIPTION
Pass in a property as a string and two object references
and this function will swap the property values.

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
// exchanges the x position of two ZIM circles
swapProperties("x", circle1, circle2); stage.update();
END EXAMPLE

PARAMETERS
property - a String of the property to swap values eg. "alpha"
objA, objB - the objects on which to swap properties

RETURNS Boolean indicating success
--*///+17.1
	zim.swapProperties = function(property, objA, objB) {
		z_d("17.1");
		if (zot(objA) || zot(objB) || zot(objA[property]) || zot(objB[property])) return false;
		var temp = objB[property];
		objB[property] = objA[property];
		objA[property] = temp;
		return true;
	}//-17.1

/*--
zim.mobile = function(orientation)

mobile
zim function

DESCRIPTION
Detects if app is on a mobile device - if so, returns the mobile device type:
android, ios, blackberry, windows, other (all which evaluate to true) else returns false.
orientation defaults to true and if there is window.orientation then it assumes mobile
BUT this may return true for some desktop and laptop touch screens
so you can turn the orientation check off by setting orientation to false.
If orientation is set to false the check may miss non-mainstream devices
The check looks at the navigator.userAgent for the following regular expression:
/ip(hone|od|ad)|android|blackberry|nokia|opera mini|mobile|phone|nexus|webos/i
Microsoft mobile gets detected by nokia, mobile or phone.

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
if (mobile()) {
	var pane = new Pane(300, 200, "Desktop Only");
	pane.show();
}
END EXAMPLE

PARAMETERS
orientation - (default true) uses window.orientation property to determine mobile
	this may call certain touch screens mobile
	but setting to false uses a test on mobile names which could be incomplete

RETURNS a String or false
--*///+28
	zim.mobile = function(orientation) {
		z_d("28");
		if (zot(orientation)) orientation = true;
		if (/ip(hone|od|ad)/i.test(navigator.userAgent)) return "ios";
		if (/android|nexus/i.test(navigator.userAgent)) return "android";
		if (/blackberry/i.test(navigator.userAgent)) return "blackberry";
		if (/nokia|phone|mobile/i.test(navigator.userAgent)) return "windows";
		if (/opera mini|webos/i.test(navigator.userAgent)) return "other";
		if (orientation && window.orientation !== undefined) return true;
		return false;
	}//-28

//
/*--
zim.vee = function(obj)

vee
zim function

DESCRIPTION
Determines if obj is a ZIM Pick() object or a Pick Literal - used by ZIM VEE parameters
Pick Literal format is [], {min:a, max:b}, function(){}, {noPick:x} or a function(){}
See https://zimjs.com/docs.html?type=Pick
ZIM Pick is a way to pass in dynamic parameters or style properties
This is very handy to pass in a series() function or an array for random pickings, etc.
Used to create dynamic particles with the Emitter or tile specific items in order, etc.
Pick.choose() accepts any value and if not in ZIM Pick format, will just return the object

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var color = [red, green, blue];
// ternary operator - if in Pick format, add "random" else ""
new Label((vee(color)?"random ":"") + "colors").center();
END EXAMPLE

PARAMETERS
orientation - (default true) uses window.orientation property to determine mobile
	this may call certain touch screens mobile
	but setting to false uses a test on mobile names which could be incomplete

RETURNS a Boolean true if Pick format or false if not (such as just a number, string, new Circle, etc.)
--*///+28.5
	zim.vee = function(obj) {
		z_d("28.5");
		return !zot(obj) && (obj.type == "Pick" || Array.isArray(obj) || (obj.constructor == {}.constructor && (!zot(obj.max) || !zot(obj.noPick))) || typeof obj == "function");
	}//-28.5

/*--
zim.extend = function(subclass, superclass, override, prefix, prototype)

extend
zim function - modified CreateJS extend and promote utility methods

DESCRIPTION
For ES5 - place after a sub class to extend a super class.
Extending a super class means that the sub class receives all the properties and methods of the super class.
For example, a ZIM Container() extends a CreateJS Container and then adds more methods and properties
but all the CreateJS Container methods and properties are still there too like x, y, addChild(), etc.

For ES6 - do not use zim.extend() but rather use the built in ES6 structures as follows:

EXAMPLE
// ES6 - do NOT use zim.extend()
class Person() {
	constructor () {
		zog("I am a person");
	}
}
class Woman extends Person { // use JS6 extends keyword
	constructor () {
		super(); // use JS6 super() to call the Person constructor - will do the zog()
		// Woman code
	}
}

// ES6 to extend a zim Container for example (do NOT use zim.extend() in ES6)
class ChineseCoin extends Container { // use JS6 extends keyword
	constructor () {
		super(); // must call the zim Container before using keyword this
		new Circle(100, "gold").addTo(this); // this will be the zim Container
		new Rectangle(100, 100, "brown").center(this);
	}
}
var coin = new ChineseCoin().center(stage); // coin is a zim Container with Circle and Rectangle inside
END EXAMPLE

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
// ES5 examples using functions to make classes
// ES5 has no extends keyword and no super keyword so we use zim.extends()
function Person() {
	this.talk = function() {
		zog("I am a person");
	}
}
function Woman() {
	this.super_constructor(); // part of the zim.extend() system
}
extend(Woman, Person); // here is the zim.extend() for ES5
var woman = new Woman();
woman.talk();
END EXAMPLE

NOTE: CreateJS display objects require their constructor to be called otherwise it is like quantum entanglement (seriously)
extend() adds access to the super class constructor so it can be called in the subclass as follows:
this.super_constructor();
It also provides access to super class methods that are overridden

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
// ES5 example - see the ES6 set of examples for ES6 ;-)
// make a Collection class that will extend a Container
// the Collection class will call the Container constructor
// and override the the ZIM Container center method in the class body
// and override the CreateJS Container addChild method in the prototype
// either method would work in either place - it is often a matter of preference
// but you might need to use a method in the class body to access local variables
// The ZIM extend() method parameter values need to change depending on where you override
// see the comments inline for the instructions

var Collection = function() {
	// for CreateJS the super constructor must be run
	this.super_constructor();

	// override the zim center() method
	// methods in the function call that override must be passed in as an array of strings
	// to the override parameter of extend() to be able to access the super_method
	this.center = function(where) {
		this.super_center(where);
		this.y -= 50;
	}
}
// override the super class addChild() that comes from the CreateJS Container
// methods on the prototype that override are automatically provided a super_method
// unless the prototype parameter of extend() is set to false (default is true)
Collection.prototype.addChild = function(c) {
	this.super_addChild(c); // call the super class addChild
	zog("added a child to Collection");
}

// make the Collection extend a Container()
// it will receive all the properties and methods of the Container plus its own
extend(Collection, Container, "center"); // or pass an array of overridden methods

// use the Collection
var c = new Collection();
c.addChild(new Rectangle(100, 100, green)); // zogs "added a child to Collection"
c.center(stage); // centers the collection but then offsets it 50 pixels up
END EXAMPLE

NOTE: the superclass constructor is always available as this.prefix_constructor() no matter the override or prototype settings
NOTE: this.prefix_constructor(); should be called at the top of the subclass to avoid problems when multiple copies of object
NOTE: to extend a class that already extends a ZIM class then change the prefix to a unique name:

EXAMPLE
// if we already had the Collection example above and we want to extend that
// then we must use a new prefix when using extend()

var Records = function() {
	this.Collection_constructor();
}
extend(Records, Collection, null, "Collection");

// you will still have this.super_center(), this.super_addChild() if needed
// plus any newly overridden methods available as this.Collection_methodName() etc.
var r = new Records();
r.addChild(new Circle(20, pink));
r.super_center(stage); // call the original center (without vertical shift)

// to extend again, use yet another prefix - for example: "Records"
var Jazz = function() {
	this.Records_constructor();
}
extend(Jazz, Records, null, "Records");
END EXAMPLE

PARAMETERS supports DUO - parameters or single object with properties below
NOTE: do NOT use zim.extend() with ES6 - see ES6 examples at top instead
subclass - the class to extend
superclass - the class to extend from (an existing class)
override - (default null) an Array of methods (as Strings) to override.
	You can override any function by just defining that function in the subclass
	the override parameter gives you access to the overridden function in the superclass prototype
	only methods on the superclass prototype can be accessed once overridden - not methods in the superclass body
	if there is only one method being overridden then a single string is fine ("test" or ["test"] is fine)
	any methods passed to this parameter will be given prefix_methodName() access on the sub class (this.prefix_methodName())
	where the prefix is below (note, the prototype setting has no bearing on these manual overrides)
	this list is only needed for methods in the subclass body
	methods assigned to the prototype of the subclass that override are automatically given prefixes
prefix - (default "super") a prefix that will be followed by "_" and then the overridden method name
	by default this.super_constructor() would call the super class constructor
	if prefix is set to "Person" then this.Person_constructor() would call the super class constructor
	the same system is used to call overridden files in override or prototype
prototype - (default true) will search the subclass prototype for overriding methods
	the overridden methods are then available as this.prefix_methodName()
	set to false to avoid searching the super class for methods overridden by the sub class prototype
	just quickens the code minutely if there is no need

NOTE: extend() is included in Distill if DISPLAY, METHODS or FRAME Module classes are used (otherwise NOT included)

RETURNS the subclass
--*///+50.35
	zim.extend = function(subclass, superclass, override, prefix, prototype) {
		var sig = "subclass, superclass, override, prefix, prototype";
		var duo; if (duo = zob(zim.extend, arguments, sig)) return duo;
		if (zot(subclass) || zot(superclass)) {
			if (zon && subclass!=zim.StageGL) zog("zim.extend() - please supply a class and its superclass");
			return;
		}
		if (zot(prefix)) prefix = "super";
		if (zot(override)) override = [];
		if (!Array.isArray(override)) override = [override];
		if (zot(prototype)) prototype = true;
		// modified CreateJS extend() to include any prototype members already added
		// see http://www.createjs.com/docs/easeljs/classes/Utility%20Methods.html
		var existingP = {};
		for (var f in subclass.prototype) Object.defineProperty(existingP,f,Object.getOwnPropertyDescriptor(subclass.prototype, f));
		function o() {this.constructor = subclass;}
		o.prototype = superclass.prototype;
		subclass.prototype = new o();
		for (f in existingP) Object.defineProperty(subclass.prototype,f,Object.getOwnPropertyDescriptor(existingP,f));

		// modified CreateJS promote() to promote methods other than constructor only if methods is true
		// zim does not override with prototypes so it is uneccessary to loop through the super class methods
		// added checking an array of string values of methods defined in class (not prototype) that are being overridden
		var subP = subclass.prototype;
		var supP = (Object.getPrototypeOf&&Object.getPrototypeOf(subP))||subP.__proto__;
		if (supP) {
			subP[(prefix+="_") + "constructor"] = supP.constructor; // constructor is not always innumerable
			var n;
			for (var i=0; i<override.length; i++) {
				n = override[i];
				if (typeof supP[n] == "function") {subP[prefix + n] = supP[n];}
			}
			if (prototype) {
				for (n in supP) {
					if (subP.hasOwnProperty(n) && (typeof supP[n] == "function")) {subP[prefix + n] = supP[n];}
				}
			}
		}
		return subclass;
	}
	//-50.35

// SUBSECTION BASICS

/*--
zim.copy = function(obj, clone, cloneContainers)

copy
zim function

DESCRIPTION
Copies arrays and basic objects:
modified http://stackoverflow.com/users/35881/a-levy
If you have var obj = {prop:"val"};
and then try and copy obj to obj2 like so: obj2 = obj;
then obj2 and obj refer to the same object.
This means that after obj.prop = "new"; both obj.prop and obj2.prop would be "new".
copy(obj) returns a new object so both will work independently
and after obj.prop = "new"; obj2.prop would still be "val".

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var obj = {hair:blue, cars:["audi", "honda"]};
var cop = copy(obj);
cop.hair = "green";
zog(obj.hair, obj.cop); // blue, green
obj.cars.push("vw");
zog(obj.cars.length, cop.cars.length); // 3, 2

// copy with clone for cloneable objects
// without the second parameter as true these obj[0] and obj2[0] would be the same
// and when we do the second addTo it would just move the circle to the second position
var obj = [
	new Circle(20,green),
	new Rectangle(30,30,green),
	new Triangle(40,40,40,green)
];
var obj2 = copy(obj, true); // copy and clone
obj[0].addTo(stage).pos(100, 200);
obj2[0].addTo(stage).pos(300, 400);
END EXAMPLE

PARAMETERS
obj - the object to copy
clone - (default false) set to true to clone any cloneable object while copying
cloneContainers - (default true if clone true) set to false to not copy objects with type="Container"

RETURNS a new Object
--*///+10
	zim.copyCheck = false;
	zim.copy = function(obj, clone, cloneContainer) {
		if (!zim.copyCheck) {z_d("10"); zim.copyCheck = true;}
		if (zot(clone)) clone = false;
		if (zot(cloneContainer)) cloneContainer = true;
		if (obj==null || !(obj instanceof Array || obj.constructor == {}.constructor)) return clone&&obj!=null?(obj.clone?(obj.type&&((obj.type!="Container"&&obj.type!="Stage"&&obj.type!="StageGL")||cloneContainer)?obj.clone():obj):obj):obj;
		if (obj instanceof Array) {
			var array = [];
			for (var i=0; i<obj.length; i++) {
				array[i] = zim.copy(obj[i], clone, cloneContainer);
			}
			return array;
		}
		if (obj.constructor == {}.constructor) {
			var copy = {};
			for (var attr in obj) {
				var answer = zim.copy(obj[attr], clone, cloneContainer);
				if (obj.hasOwnProperty(attr)) copy[attr] = answer;
			}
			return copy;
		}
	}//-10

/*--
zim.merge = function(objects)

merge
zim function

DESCRIPTION
Merges any number of objects {} you pass in as parameters.
Overwrites properties if they have the same name.
Returns a merged object with original objects kept intact.

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var one = {food:"chocolate"};
var two = {drink:"milk"};
var tri = merge(one, two);
zog(tri.food, tri.drink); // chocolate, milk
END EXAMPLE

PARAMETERS
objects - a list of objects (any number) to merge together

RETURNS a new Object
--*///+12
	zim.mergeCheck = false;
	zim.merge = function() {
		if (!zim.mergeCheck) {z_d("12"); zim.mergeCheck = true;}
		var obj = {}; var i; var j;
		for (i=0; i<arguments.length; i++) {
			for (j in arguments[i]) {
				if (arguments[i].hasOwnProperty(j)) {
					obj[j] = arguments[i][j];
				}
			}
		}
		return obj;
	}//-12

/*--
zim.arraysEqual = function(a, b, strict)

arraysEqual
zim function

DESCRIPTION
Finds out if arrays are same (including nested arrays).
Works for arrays with strings and numbers (not necessarily other objects).
(Slightly modified Evan Steinkerchnerv & Tomas Zato)

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var one = [1,2,"wow",[3,4]];
var two = [1,2,"wow",[3,4]];
zog(arraysEqual(one, two)); // true
one[3][1] = 5;
zog(arraysEqual(one, two)); // false
END EXAMPLE

PARAMETERS
a, b - the arrays to check to see if they are equal
strict - (default true) set to false so order in arrays does not matter

RETURNS a Boolean
--*///+11
	zim.arraysEqual = function(a, b, strict) {
		z_d("11");
		if (zot(a) || zot(b)) return false;
		if (zot(strict)) strict = true; // must be the same order
		if (a.length != b.length) return false;

		for (var i = 0; i < a.length; i++) {
			if (a[i] instanceof Array && b[i] instanceof Array) {
				if (!zim.arraysEqual(a[i], b[i], strict))	return false;
			}
			else if (strict && a[i] != b[i]) {
				return false;
			}
			else if (!strict) {
				return zim.arraysEqual(a.sort(), b.sort(), true);
			}
		}
		return true;
	}//-11

/*--
zim.isEmpty = function(obj)

isEmpty
zim function

DESCRIPTION
returns whether an object literal is empty

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var o = {};
zog( isEmpty(o) ); // true
o.test = 9;
zog( isEmpty(o) ); // false
END EXAMPLE

PARAMETERS
obj - the object literal to test

RETURNS a Boolean
--*///+11.5
	zim.isEmpty = function(obj) {
		z_d("11.5");
		if (zot(obj)) return;
		var count = 0;
		for (var o in obj) {
			count++; break;
		}
		return (count == 0);
	}//-11.5

/*--
zim.isJSON = function(str)

isJSON
zim function

DESCRIPTION
returns whether a string is a JSON string

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var s = '{"age":7,"name":"Dan Zen"}';
zog( isJSON(s) ); // true
var b = "hello";
zog( isJSON(b) ); // false
END EXAMPLE

PARAMETERS
str - the string to test

RETURNS a Boolean
--*///+11.6
	zim.isJSON = function(str) {
		z_d("11.6");
		try {
			return (JSON.parse(str).constructor == {}.constructor);
		} catch (e) {
			return false;
		}
	}//-11.6


/*--
zim.decimals = function(num, places, addZeros, addZerosBefore, includeZero, time)

decimals
zim function

DESCRIPTION
Rounds number to the number of decimal places specified by places.
Negative number places round to tens, hundreds, etc.
If addZeros is set to a number it adds 0 in empty spaces up to that many places after the decimal
If addZerosBefore is set to a number it adds 0 in empty spaces up to that many places before the decimal

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var score = 1.234;
score = decimals(score);
zog(score); // 1.2
zog(decimals(1.8345, 2)); // 1.83
zog(decimals(123,-1)); // 120
zog(decimals(2.3,null,2)); // 2.30
zog(decimals(3,null,null,2)); // 03
zog(decimals(.12,2,2,1,null,true)); // 0:12
END EXAMPLE

PARAMETERS
num - the Number to operate on
places - (default 1) how many decimals to include (negative for left of decimal place)
addZeros - (default 0) set to number of places to fill in zeros after decimal (and return String)
addZerosBefore - (default 0) set to number of places to fill in zeros before decimal (and return String)
includeZero - (default true) set to false to always have zero just be 0 without any extra zeros
time - (default false) a swap of : for . to handle minutes and seconds (not hours)

RETURNS a rounded Number or a String if addZeros, addZerosBefore or time is true
--*///+13
	zim.zut = function(e) {
		if (zot(e) || typeof e == "object") return true;
	}
	zim.zimDecimalCheck = false;
	zim.decimals = function(num, places, addZeros, addZerosBefore, includeZero, time, evt) {
		if (!zim.zimDecimalCheck) z_d("13");
		zim.zimDecimalCheck = true;
		if (zot(num)) return 0;
		if (zot(places)) places = 1;
		if (zot(addZeros)) addZeros = 0;
		if (zot(addZerosBefore)) addZerosBefore = 0;
		if (zot(addZerosBefore)) addZerosBefore = 0;
		if (zot(includeZero)) includeZero = true;
		if (zot(time)) time = false;
		// if (addZeros && places < 0) {
		// 	var place = String(num).indexOf(".");
		// 	var length = String(num).length;
		// 	var left = (place < 0) ? length : place;
		// 	for (var i=0; i<-places-left; i++) {num = "0" + num;}
		// 	return num;
		// }
		var answer = Math.round(num*Math.pow(10, places))/Math.pow(10, places);
		if (time) {
			var secs = answer - Math.floor(answer);
			answer = zim.decimals(Math.floor(answer) + secs*60/100, 2);
		}

		// if (addZeros && places > 0 && answer != 0) {
		// 	var place = String(answer).indexOf(".");
		// 	var length = String(answer).length;
		// 	if (place < 0) {place = length++; answer+=".";}
		// 	for (var i=0; i<places-(length-place-1); i++) {answer += "0";}
		// }
		var sign = zim.sign(answer);
		if (addZeros > 0) {
			var place = String(answer).indexOf(".");
			var length = String(answer).length;
			if (place < 0) {place = length++; answer+=".";}
			for (var i=0; i<addZeros-(length-place-1); i++) {answer += "0";}
		}
		if (addZerosBefore > 0) {
			if (sign == -1) answer = answer.substr(1,answer.length-1);
			var place = String(answer).indexOf(".");
			var length = String(answer).length;
			var left = (place < 0) ? length : place;
			for (var i=0; i<addZerosBefore-left; i++) {answer = "0" + answer;}
			if (sign == -1) answer = "-" + answer;
		}
		if ((addZeros + addZerosBefore > 0) && !includeZero && Number(answer) == 0) answer = 0;
		if (time) answer = String(answer).replace(".", ":");
		return zim.zut(evt) ? answer : null;
	}//-13

/*--
zim.sign = function(num)

sign
zim function

DESCRIPTION
returns -1, 0 or 1 depending on whether the number is less than, equal to or greater than 0

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var speed = 20;
zog(sign(speed)); // 1

var speed = 0;
zog(sign(speed)); // 0

var speed = -20;
zog(sSign(speed)); // -1
END EXAMPLE

PARAMETERS
num - the Number to operate on

RETURNS -1, 0 or 1
--*///+13.1
	zim.zimSignCheck = false;
	zim.sign = function(num) {
		if (!zim.zimSignCheck) z_d("13.1");
		zim.zimSignCheck = true;
		return num?num<0?-1:1:0;
	}//-13.1


/*--
zim.constrain = function(num, min, max, negative)

constrain
zim function

DESCRIPTION
returns a number constrained to min and max

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var cirle.x = constrain(circle.x, circle.radius, stageW-circle.radius);
// circle.x will not be smaller than the radius or bigger than stageW-radius

var speed = constrain(speed, minSpeed, maxSpeed, true);
// will confine the speed between minSpeed and maxSpeed if speed is positive
// and confine the speed between -maxSpeed and -minSpeed if the speed is negative
END EXAMPLE

PARAMETERS
num - the number to be constrained
min - (default 0) the minimum value of the return number
max - (default Number.MAX_VALUE) the maximum value of the return number
negative - (default false) allow the negative range of min and max when num is negative

RETURNS num if between min and max otherwise returns min if less or max if greater (inclusive)
RETURNS num between -max and -min if num is negative and negative parameter is set to true
--*///+13.2
	zim.constrain = function(num, min, max, negative) {
		z_d("13.2");
		if (zot(num)) return;
		if (zot(min)) min = 0;
		if (zot(max)) max = Number.MAX_VALUE;
		if (max < min) {max2 = min; max = min; min = max2;} // ES6 Fix to come
		if (zot(negative)) negative = false;
		if (negative && num < 0) {
			return Math.max(-max, Math.min(num, -min));
		} else {
			return Math.max(min, Math.min(num, max));
		}
	}//-13.2

/*--
zim.dist = function(a, b, c, d)

dist
zim function

DESCRIPTION
Calculates the distance between two points.

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
// using point values for each
var p1 = new Point(100, 100); // or {x:100, y:100}
var p2 = new Point(200, 200);
zog(dist(p1, p2)); // 141.42...
END EXAMPLE

EXAMPLE
// using x and y values for each
// do not rely on stage.mouseX, stage.mouseY - they do not work on touchscreen!
var stageX;
var stageY;
stage.on("stagemousemove", function (e) {stageX = e.stageX; stageY = e.stageY});
var distance = dist(stageW/2, stageH/2, stageX, stageY);
// distance of mouse from center of stage
END EXAMPLE

PARAMETERS
a - first Point - any object with x and y values - eg. a zim Container or zim Point or {x:10, y:30}
	or if four parameter values, an x value of the first point
b - second Point - any object with x and y values
	or if four parameter values, a y value of the first point
c - (default null) an x value of a second point - if using x and y values
d - (default null) a y value of a second point - if using x and y values

RETURNS a positive Number that is the distance (could be on an angle)
--*///+13.3
	zim.zimDistCheck = false;
	zim.dist = function(a, b, c, d) {
		if (!zim.zimDistCheck) z_d("13.3");
		zim.zimDistCheck = true;
		if (zot(a) || zot(b)) return;
		if (!zot(a.x) && !zot(b.x)) {
			d = b.y;
			c = b.x;
			b = a.y;
			a = a.x;
		} else {
			if (zot(c)) c = 0;
			if (zot(d)) d = 0;
		}
		return Math.sqrt((Math.pow(c-a, 2) + Math.pow(d-b, 2)));
	}//-13.3

//
/*--
zim.rectIntersect = function(a, b, margin)

rectIntersect
zim function

DESCRIPTION
Returns true if two rectangles are intersecting - this is a very fast but exact calculation

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
// using point values for each
var r1 = {x:100, y:100, width:300, height:200}
var r2 = new Boundary(50,200,100,100);
zog(rectIntersect(r1, r2)); // true
END EXAMPLE

PARAMETERS
a - first rectangle with x, y, width and height properties - such as a bounds or Boundary
	make sure that these are in the same coordinate systems - use ZIM boundsToGlobal for instance
b - second rectangle with x, y, width and height properties
margin - (default 0) positive value adds margin (more likely to intersect) and negative subtracts (less likely to intersect)

RETURNS a Boolean as to whether rectangles are intersecting
--*///+13.32
	zim.zimRectIntersectCheck = false;
	zim.rectIntersect = function(a, b, margin) {
		if (!zim.zimRectIntersectCheck) z_d("13.32");
		zim.zimRectIntersectCheck = true;
		if (zot(margin)) margin = 0;
		if (a.x >= b.x + b.width + margin || a.x + a.width + margin <= b.x ||
			a.y >= b.y + b.height + margin || a.y + a.height + margin <= b.y ) {
			return false;
		} else {
			return true;
		}
	}//-13.32

//
/*--
zim.boundsAroundPoints = function(points)

boundsAroundPoints
zim function

DESCRIPTION
Returns a rectangle {x,y,width,height} around an array of points {x,y}

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var blob = new Blob();
var points = blob.interpolate();
zog(boundsAroundPoints(points)); // {x:-100, y:-100, width:200, height:200}
// could call this after resizing the blob to get the rough bounds of the blob (or squiggle)
// interpolate defaults to 1 so setting 5 would be even more precise, etc.
END EXAMPLE

PARAMETERS
points - an array of points with x and y properties.

RETURNS an object with x, y, width and height properties
representing the rectangle around the points provided
--*///+13.34
	zim.zimBoundsAroundPointsCheck = false;
	zim.boundsAroundPoints = function(points) {
		if (!zim.zimBoundsAroundPointsCheck) z_d("13.34");
		zim.zimBoundsAroundPointsCheck = true;
		var tX = 10000;
		var tY = 10000;
		var bX = -10000;
		var bY = -10000;
		for (var i=0; i<points.length; i++) {
			var p = points[i];
			if (p.x < tX) tX = p.x;
			if (p.x > bX) bX = p.x;
			if (p.y < tY) tY = p.y;
			if (p.y > bY) bY = p.y;
		}
		return {x:tX, y:tY, width:bX-tX, height:bY-tY};
	}//-13.34

/*--
zim.angle = function(x1, y1, x2, y2)

angle
zim function

DESCRIPTION
Calculates the angle between two points relative to the positive x axis

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var angle = angle(stageW/2, stageH/2, stageW/2+100, stageH/2+100); // 45
// angle from center of stage to 100, 100 to the right and down from the center of the stage

var angle2 = angle(stageW/2, stageH/2, stageW/2-100, stageH/2+100); // 135

var angle3 = angle(stageW/2, stageH/2, stageW/2+100, stageH/2-100); // 315
END EXAMPLE

PARAMETERS
x1, y1 - first point x and y
	unless no second point in which case x1, y1 will be second point and first point will be 0, 0
x2, y2 - second point x and y

RETURNS a positive Number that is the angle between first and second point relative to positive x axis
--*///+13.4
	zim.angle = function(x1, y1, x2, y2) {
		z_d("13.4");
		if (zot(x1) || zot(y1)) return;
		if (zot(x2)) {x2 = x1; x1 = 0};
		if (zot(y2)) {y2 = y1; y1 = 0};
		return (Math.atan2(y2-y1, x2-x1)*180/Math.PI+360)%360;
	}//-13.4

/*--
zim.smoothStep = function(num, min, max)

smoothStep
zim function

DESCRIPTION
smoothStep takes an input value and outputs a value between 0 and 1
that represents a transition between the min and max with easing at both ends.
If you want the easing to be more pronounced, then reduce difference between min and max.
If the value falls outside the min or max then it is set to the min or max.
Remember the return value is between 0 and 1 so you can multiply by max-min and add it to min
to get a value at the original scale.
Used to make blobs with Noise(): https://zimjs.com/noise/blobs.html

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
// here we use smoothStep to make a gradient between black and white
// not an even one right across but a gradient across a transition zone of 40-100

// create an empty Bitmap size 200, 200 and center it on the stage
var bmp = new Bitmap(null, 200, 200).center(stage);

// we need to loop and get a value for each pixel
// normally we loop across the rows and then do each column
// but here we are making a horizontal gradient
// so we will loop across the x and get the desired value
// then when we loop across the y in the inner loop, we just use that same value
for (var x = 0; x < bmp.width; x++) {
	// making gradient in x only so calculate smoothStep here
	// x will be from 0 to the width of 200
	// we pass in a min of 40 and a max of 100
	// the result of smoothStep is between 0 and 1
	// so from 0 to 40 the return of smoothStep will be 0
	// and from 100 to 200 the return of smoothStep will be 1
	// In between, the return value starts off close to 0, then speeds up
	// and then slows down to 1 in a curve that is somewhat like the letter f
	// When we multiply by 255 and apply that result to each color,
	// we get black and then a range of greys and then white
	var value = smoothStep(x, 40, 100)*255;

	// now we loop down the column for the x position
	for (var y = 0; y < bmp.height; y++) {
		// imageData is four values per pixel
		// the red, green, blue and alpha
		// in one big long array - each value will be constrained to between 0 and 255
		// this i value will increase by 4 each time
		// then we write the same value for red, green, blue to get a shade of grey
		var i = (x + y * bmp.width) * 4;
		bmp.imageData.data[i] = value; // red (0-255)
		bmp.imageData.data[i + 1] = value; // green (0-255)
		bmp.imageData.data[i + 2] = value; // blue (0-255)
		bmp.imageData.data[i + 3] = 255; // alpha (0-255)
	}
}
bmp.drawImageData(); // draw the imageData to the Bitmap
END EXAMPLE

PARAMETERS
num - the input value with respect to min and max
min - the lower edge for smoothStep (often termed edge0) - anything smaller will be set to min
max - the upper edge for smoothStep (often termed edge1) - anything bigger will be set to max

RETURNS a number between 0 and 1 that represents a transition factor
--*///+13.7
	zim.smoothStep = function(num, min, max) {
		z_d("13.7");
	    var x = zim.constrain((num - min)/(max - min), 0, 1);
	    return x*x*x*(x*(x*6 - 15) + 10); // Perlin
	}//-13.7

// SUBSECTION CLASSES

/*--
zim.Noise = function(seed)

Noise
zim class

DESCRIPTION
Noise creates OpenSimplex Noise: https://en.wikipedia.org/wiki/OpenSimplex_noise
Converted from https://www.npmjs.com/package/open-simplex-noise
See examples at https://zimjs.com/noise/
In general, this is special noise where the pixels relate to one another in a complex way.
This connection, lets us do things like create terrains or blobs, etc. that look organic.
There is 1D, 2D, 3D, and 4D noise where we pass in one value, two values, three values and four values.
We always get back a number between -1 and 1 and this result relates to the results around it.

1D - we can plot 1D by drawing line segments across the stage (x) and setting the y value to the result of simplex1D(x)
This makes a 2D mountain-like terrain across the stage

2D - if we keep the plot from the 1D but use 2D and change the second parameter, we can animate the line.
We just need to adjust the second parameter by a very small amount each time such as .005.
Or we can plot put the return value of simplex2D onto its x,y matching location in a Bitmap
mapping it to a greyscale to make a traditional noise pattern.
We can adjust the "size" of the noise by dividing the x and y values (frequency).
If we use the ZIM smoothStep() function we can smoothen these to make blobs.
We can also use the return value as height for 3D terrain.

3D - if we keep the traditional noise/blob pattern from the 2D but use simplex3D and animate the third parameter,
we can animate the 2D noise in time which looks great when we animate blobs!
This plotting is thousands of computations and will bog the computer if too big.

4D - will allow us to animate 3D values, etc.

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
// 1D Noise to make a jagged line across the stage
var noise = new Noise();
var shape = new Shape(stageW, stageH).addTo(stage);
shape.graphics.s("black").ss(2).mt(0, stageH/2);
loop(stageW/50, function(i) {
	shape.graphics.lt((i+1)*50, stageH/2 + noise.simplex1D(i)*200);
});
// the above can be animated by using simplex2D and animating the second number by small amounts
END EXAMPLE

EXAMPLE
// 2D noise
// create a Noise object:
var noise = new Noise();

// create an empty Bitmap size 200, 200 into which to draw the noise
var bmp = new Bitmap(null, 200, 200).center(stage);

// we fill the bitmap starting from top left going across in the inner loop,
// then down, then across, etc. until we get to bottom right.
for (var y = 0; y < bmp.height; y++) {
	for (var x = 0; x < bmp.width; x++) {
		// the noise methods return a number from -1 to 1
		// by adding 1 we get a number between 0 and 2 and we divide by 2 to get 0-1
		// and we multiply this by 255 to get a number between 0 and 255
		var value = (noise.simplex2D(x,y)+1)/2 * 255;
		// imageData is one big array with four values per pixel
		// the red, green, blue and alpha
		// each value will constrained to between 0 and 255
		// the i value is how many on the current row plus the columns from the previous rows
		// and we set it to increase by 4 each time giving us a place for each color and alpha
		// We write the same value for red, green, blue to get a shade of grey
		var i = (x + y * bmp.width) * 4;
		bmp.imageData.data[i] = value; // red (0-255)
		bmp.imageData.data[i + 1] = value; // green (0-255)
		bmp.imageData.data[i + 2] = value; // blue (0-255)
		bmp.imageData.data[i + 3] = 255; // alpha (0-255)
	}
}
bmp.drawImageData(); // this draws the imageData to the Bitmap

// Here is the same example to get blobs using smoothStep:

var f = 25; // try changing this number around
for (var y = 0; y < bmp.height; y++) {
	for (var x = 0; x < bmp.width; x++) {
		var value = noise.simplex2D(x/f, y/f)+1)/2; // 0-1
		// smoothStep sets less than .3 to 0 and greater than .35 to 1
		// and transitions between using an easing formula in the shape of an f
		var value = smoothStep(value, .3, .35) * 255;
		var i = (x + y * bmp.width) * 4;
		bmp.imageData.data[i] = value; // red (0-255)
		bmp.imageData.data[i + 1] = value; // green (0-255)
		bmp.imageData.data[i + 2] = value; // blue (0-255)
		bmp.imageData.data[i + 3] = 255; // alpha (0-255)
	}
}
bmp.drawImageData();
END EXAMPLE

PARAMETERS
seed - (default Math.random()*1000000) keeping the same seed can remake a pattern the same

METHODS
simplex1D(x) - returns a noise value between -1 and 1
	In each method, the noise value relates to its neighbor rather than a completely random value
simplex2D(x,y) - returns a noise value between -1 and 1
simplex3D(x,y,z) - returns a noise value between -1 and 1
simplex4D(x,y,z,w) - returns a noise value between -1 and 1

PROPERTIES
seed - read only - the seed that was used for the Noise object
--*///+13.9
	zim.Noise = function(seed) {
		"use strict";
		z_d("13.9");

		if (zot(seed)) seed = Math.random()*1000000;
		var clientSeed = seed;
		this.seed = seed;

		var that = this;

		var con = {}; // holds the constants
		con.NORM_2D = 1.0 / 47.0;
		con.NORM_3D = 1.0 / 103.0;
		con.NORM_4D = 1.0 / 30.0;
		con.SQUISH_2D = (Math.sqrt(2 + 1) - 1) / 2;
		con.SQUISH_3D = (Math.sqrt(3 + 1) - 1) / 3;
		con.SQUISH_4D = (Math.sqrt(4 + 1) - 1) / 4;
		con.STRETCH_2D = (1 / Math.sqrt(2 + 1) - 1) / 2;
		con.STRETCH_3D = (1 / Math.sqrt(3 + 1) - 1) / 3;
		con.STRETCH_4D = (1 / Math.sqrt(4 + 1) - 1) / 4;
		con.base2D = [
			[1, 1, 0, 1, 0, 1, 0, 0, 0],
			[1, 1, 0, 1, 0, 1, 2, 1, 1]
		];
		con.base3D = [
			[0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 1],
			[2, 1, 1, 0, 2, 1, 0, 1, 2, 0, 1, 1, 3, 1, 1, 1],
			[1, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 1, 2, 1, 1, 0, 2, 1, 0, 1, 2, 0, 1, 1]
		];
		con.base4D = [
			[0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1, 0, 0, 0, 1],
			[3, 1, 1, 1, 0, 3, 1, 1, 0, 1, 3, 1, 0, 1, 1, 3, 0, 1, 1, 1, 4, 1, 1, 1, 1],
			[
				1, 1, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 2, 1, 1, 0, 0, 2, 1, 0, 1, 0, 2, 1, 0, 0, 1, 2, 0, 1, 1,
				0, 2, 0, 1, 0, 1, 2, 0, 0, 1, 1
			],
			[
				3, 1, 1, 1, 0, 3, 1, 1, 0, 1, 3, 1, 0, 1, 1, 3, 0, 1, 1, 1, 2, 1, 1, 0, 0, 2, 1, 0, 1, 0, 2, 1, 0, 0, 1, 2, 0, 1, 1,
				0, 2, 0, 1, 0, 1, 2, 0, 0, 1, 1
			]
		];
		con.gradients2D = [5, 2, 2, 5, -5, 2, -2, 5, 5, -2, 2, -5, -5, -2, -2, -5];
		con.gradients3D = [
			-11, 4, 4, -4, 11, 4, -4, 4, 11,
			11, 4, 4, 4, 11, 4, 4, 4, 11,
			-11, -4, 4, -4, -11, 4, -4, -4, 11,
			11, -4, 4, 4, -11, 4, 4, -4, 11,
			-11, 4, -4, -4, 11, -4, -4, 4, -11,
			11, 4, -4, 4, 11, -4, 4, 4, -11,
			-11, -4, -4, -4, -11, -4, -4, -4, -11,
			11, -4, -4, 4, -11, -4, 4, -4, -11
		];
		con.gradients4D = [
			3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3,
			-3, 1, 1, 1, -1, 3, 1, 1, -1, 1, 3, 1, -1, 1, 1, 3,
			3, -1, 1, 1, 1, -3, 1, 1, 1, -1, 3, 1, 1, -1, 1, 3,
			-3, -1, 1, 1, -1, -3, 1, 1, -1, -1, 3, 1, -1, -1, 1, 3,
			3, 1, -1, 1, 1, 3, -1, 1, 1, 1, -3, 1, 1, 1, -1, 3,
			-3, 1, -1, 1, -1, 3, -1, 1, -1, 1, -3, 1, -1, 1, -1, 3,
			3, -1, -1, 1, 1, -3, -1, 1, 1, -1, -3, 1, 1, -1, -1, 3,
			-3, -1, -1, 1, -1, -3, -1, 1, -1, -1, -3, 1, -1, -1, -1, 3,
			3, 1, 1, -1, 1, 3, 1, -1, 1, 1, 3, -1, 1, 1, 1, -3,
			-3, 1, 1, -1, -1, 3, 1, -1, -1, 1, 3, -1, -1, 1, 1, -3,
			3, -1, 1, -1, 1, -3, 1, -1, 1, -1, 3, -1, 1, -1, 1, -3,
			-3, -1, 1, -1, -1, -3, 1, -1, -1, -1, 3, -1, -1, -1, 1, -3,
			3, 1, -1, -1, 1, 3, -1, -1, 1, 1, -3, -1, 1, 1, -1, -3,
			-3, 1, -1, -1, -1, 3, -1, -1, -1, 1, -3, -1, -1, 1, -1, -3,
			3, -1, -1, -1, 1, -3, -1, -1, 1, -1, -3, -1, 1, -1, -1, -3,
			-3, -1, -1, -1, -1, -3, -1, -1, -1, -1, -3, -1, -1, -1, -1, -3
		];
		con.lookupPairs2D = [0, 1, 1, 0, 4, 1, 17, 0, 20, 2, 21, 2, 22, 5, 23, 5, 26, 4, 39, 3, 42, 4, 43, 3];
		con.lookupPairs3D = [
			0, 2, 1, 1, 2, 2, 5, 1, 6, 0, 7, 0, 32, 2, 34, 2, 129, 1, 133, 1, 160, 5, 161, 5, 518, 0, 519, 0, 546, 4, 550, 4, 645,
			3, 647, 3, 672, 5, 673, 5, 674, 4, 677, 3, 678, 4, 679, 3, 680, 13, 681, 13, 682, 12, 685, 14, 686, 12, 687, 14, 712,
			20, 714, 18, 809, 21, 813, 23, 840, 20, 841, 21, 1198, 19, 1199, 22, 1226, 18, 1230, 19, 1325, 23, 1327, 22, 1352, 15,
			1353, 17, 1354, 15, 1357, 17, 1358, 16, 1359, 16, 1360, 11, 1361, 10, 1362, 11, 1365, 10, 1366, 9, 1367, 9, 1392, 11,
			1394, 11, 1489, 10, 1493, 10, 1520, 8, 1521, 8, 1878, 9, 1879, 9, 1906, 7, 1910, 7, 2005, 6, 2007, 6, 2032, 8, 2033,
			8, 2034, 7, 2037, 6, 2038, 7, 2039, 6
		];
		con.lookupPairs4D = [
			0, 3, 1, 2, 2, 3, 5, 2, 6, 1, 7, 1, 8, 3, 9, 2, 10, 3, 13, 2, 16, 3, 18, 3, 22, 1, 23, 1, 24, 3, 26, 3, 33, 2, 37, 2,
			38, 1, 39, 1, 41, 2, 45, 2, 54, 1, 55, 1, 56, 0, 57, 0, 58, 0, 59, 0, 60, 0, 61, 0, 62, 0, 63, 0, 256, 3, 258, 3, 264,
			3, 266, 3, 272, 3, 274, 3, 280, 3, 282, 3, 2049, 2, 2053, 2, 2057, 2, 2061, 2, 2081, 2, 2085, 2, 2089, 2, 2093, 2,
			2304, 9, 2305, 9, 2312, 9, 2313, 9, 16390, 1, 16391, 1, 16406, 1, 16407, 1, 16422, 1, 16423, 1, 16438, 1, 16439, 1,
			16642, 8, 16646, 8, 16658, 8, 16662, 8, 18437, 6, 18439, 6, 18469, 6, 18471, 6, 18688, 9, 18689, 9, 18690, 8, 18693,
			6, 18694, 8, 18695, 6, 18696, 9, 18697, 9, 18706, 8, 18710, 8, 18725, 6, 18727, 6, 131128, 0, 131129, 0, 131130, 0,
			131131, 0, 131132, 0, 131133, 0, 131134, 0, 131135, 0, 131352, 7, 131354, 7, 131384, 7, 131386, 7, 133161, 5, 133165,
			5, 133177, 5, 133181, 5, 133376, 9, 133377, 9, 133384, 9, 133385, 9, 133400, 7, 133402, 7, 133417, 5, 133421, 5,
			133432, 7, 133433, 5, 133434, 7, 133437, 5, 147510, 4, 147511, 4, 147518, 4, 147519, 4, 147714, 8, 147718, 8, 147730,
			8, 147734, 8, 147736, 7, 147738, 7, 147766, 4, 147767, 4, 147768, 7, 147770, 7, 147774, 4, 147775, 4, 149509, 6,
			149511, 6, 149541, 6, 149543, 6, 149545, 5, 149549, 5, 149558, 4, 149559, 4, 149561, 5, 149565, 5, 149566, 4, 149567,
			4, 149760, 9, 149761, 9, 149762, 8, 149765, 6, 149766, 8, 149767, 6, 149768, 9, 149769, 9, 149778, 8, 149782, 8,
			149784, 7, 149786, 7, 149797, 6, 149799, 6, 149801, 5, 149805, 5, 149814, 4, 149815, 4, 149816, 7, 149817, 5, 149818,
			7, 149821, 5, 149822, 4, 149823, 4, 149824, 37, 149825, 37, 149826, 36, 149829, 34, 149830, 36, 149831, 34, 149832,
			37, 149833, 37, 149842, 36, 149846, 36, 149848, 35, 149850, 35, 149861, 34, 149863, 34, 149865, 33, 149869, 33,
			149878, 32, 149879, 32, 149880, 35, 149881, 33, 149882, 35, 149885, 33, 149886, 32, 149887, 32, 150080, 49, 150082,
			48, 150088, 49, 150098, 48, 150104, 47, 150106, 47, 151873, 46, 151877, 45, 151881, 46, 151909, 45, 151913, 44,
			151917, 44, 152128, 49, 152129, 46, 152136, 49, 152137, 46, 166214, 43, 166215, 42, 166230, 43, 166247, 42, 166262,
			41, 166263, 41, 166466, 48, 166470, 43, 166482, 48, 166486, 43, 168261, 45, 168263, 42, 168293, 45, 168295, 42,
			168512, 31, 168513, 28, 168514, 31, 168517, 28, 168518, 25, 168519, 25, 280952, 40, 280953, 39, 280954, 40, 280957,
			39, 280958, 38, 280959, 38, 281176, 47, 281178, 47, 281208, 40, 281210, 40, 282985, 44, 282989, 44, 283001, 39,
			283005, 39, 283208, 30, 283209, 27, 283224, 30, 283241, 27, 283256, 22, 283257, 22, 297334, 41, 297335, 41, 297342,
			38, 297343, 38, 297554, 29, 297558, 24, 297562, 29, 297590, 24, 297594, 21, 297598, 21, 299365, 26, 299367, 23,
			299373, 26, 299383, 23, 299389, 20, 299391, 20, 299584, 31, 299585, 28, 299586, 31, 299589, 28, 299590, 25, 299591,
			25, 299592, 30, 299593, 27, 299602, 29, 299606, 24, 299608, 30, 299610, 29, 299621, 26, 299623, 23, 299625, 27,
			299629, 26, 299638, 24, 299639, 23, 299640, 22, 299641, 22, 299642, 21, 299645, 20, 299646, 21, 299647, 20, 299648,
			61, 299649, 60, 299650, 61, 299653, 60, 299654, 59, 299655, 59, 299656, 58, 299657, 57, 299666, 55, 299670, 54,
			299672, 58, 299674, 55, 299685, 52, 299687, 51, 299689, 57, 299693, 52, 299702, 54, 299703, 51, 299704, 56, 299705,
			56, 299706, 53, 299709, 50, 299710, 53, 299711, 50, 299904, 61, 299906, 61, 299912, 58, 299922, 55, 299928, 58,
			299930, 55, 301697, 60, 301701, 60, 301705, 57, 301733, 52, 301737, 57, 301741, 52, 301952, 79, 301953, 79, 301960,
			76, 301961, 76, 316038, 59, 316039, 59, 316054, 54, 316071, 51, 316086, 54, 316087, 51, 316290, 78, 316294, 78,
			316306, 73, 316310, 73, 318085, 77, 318087, 77, 318117, 70, 318119, 70, 318336, 79, 318337, 79, 318338, 78, 318341,
			77, 318342, 78, 318343, 77, 430776, 56, 430777, 56, 430778, 53, 430781, 50, 430782, 53, 430783, 50, 431000, 75,
			431002, 72, 431032, 75, 431034, 72, 432809, 74, 432813, 69, 432825, 74, 432829, 69, 433032, 76, 433033, 76, 433048,
			75, 433065, 74, 433080, 75, 433081, 74, 447158, 71, 447159, 68, 447166, 71, 447167, 68, 447378, 73, 447382, 73,
			447386, 72, 447414, 71, 447418, 72, 447422, 71, 449189, 70, 449191, 70, 449197, 69, 449207, 68, 449213, 69, 449215,
			68, 449408, 67, 449409, 67, 449410, 66, 449413, 64, 449414, 66, 449415, 64, 449416, 67, 449417, 67, 449426, 66,
			449430, 66, 449432, 65, 449434, 65, 449445, 64, 449447, 64, 449449, 63, 449453, 63, 449462, 62, 449463, 62, 449464,
			65, 449465, 63, 449466, 65, 449469, 63, 449470, 62, 449471, 62, 449472, 19, 449473, 19, 449474, 18, 449477, 16,
			449478, 18, 449479, 16, 449480, 19, 449481, 19, 449490, 18, 449494, 18, 449496, 17, 449498, 17, 449509, 16, 449511,
			16, 449513, 15, 449517, 15, 449526, 14, 449527, 14, 449528, 17, 449529, 15, 449530, 17, 449533, 15, 449534, 14,
			449535, 14, 449728, 19, 449729, 19, 449730, 18, 449734, 18, 449736, 19, 449737, 19, 449746, 18, 449750, 18, 449752,
			17, 449754, 17, 449784, 17, 449786, 17, 451520, 19, 451521, 19, 451525, 16, 451527, 16, 451528, 19, 451529, 19,
			451557, 16, 451559, 16, 451561, 15, 451565, 15, 451577, 15, 451581, 15, 451776, 19, 451777, 19, 451784, 19, 451785,
			19, 465858, 18, 465861, 16, 465862, 18, 465863, 16, 465874, 18, 465878, 18, 465893, 16, 465895, 16, 465910, 14,
			465911, 14, 465918, 14, 465919, 14, 466114, 18, 466118, 18, 466130, 18, 466134, 18, 467909, 16, 467911, 16, 467941,
			16, 467943, 16, 468160, 13, 468161, 13, 468162, 13, 468163, 13, 468164, 13, 468165, 13, 468166, 13, 468167, 13,
			580568, 17, 580570, 17, 580585, 15, 580589, 15, 580598, 14, 580599, 14, 580600, 17, 580601, 15, 580602, 17, 580605,
			15, 580606, 14, 580607, 14, 580824, 17, 580826, 17, 580856, 17, 580858, 17, 582633, 15, 582637, 15, 582649, 15,
			582653, 15, 582856, 12, 582857, 12, 582872, 12, 582873, 12, 582888, 12, 582889, 12, 582904, 12, 582905, 12, 596982,
			14, 596983, 14, 596990, 14, 596991, 14, 597202, 11, 597206, 11, 597210, 11, 597214, 11, 597234, 11, 597238, 11,
			597242, 11, 597246, 11, 599013, 10, 599015, 10, 599021, 10, 599023, 10, 599029, 10, 599031, 10, 599037, 10, 599039,
			10, 599232, 13, 599233, 13, 599234, 13, 599235, 13, 599236, 13, 599237, 13, 599238, 13, 599239, 13, 599240, 12,
			599241, 12, 599250, 11, 599254, 11, 599256, 12, 599257, 12, 599258, 11, 599262, 11, 599269, 10, 599271, 10, 599272,
			12, 599273, 12, 599277, 10, 599279, 10, 599282, 11, 599285, 10, 599286, 11, 599287, 10, 599288, 12, 599289, 12,
			599290, 11, 599293, 10, 599294, 11, 599295, 10
		];
		con.p2D = [0, 0, 1, -1, 0, 0, -1, 1, 0, 2, 1, 1, 1, 2, 2, 0, 1, 2, 0, 2, 1, 0, 0, 0];
		con.p3D = [
			0, 0, 1, -1, 0, 0, 1, 0, -1, 0, 0, -1, 1, 0, 0, 0, 1, -1, 0, 0, -1, 0, 1, 0, 0, -1, 1, 0, 2, 1, 1, 0, 1, 1, 1, -1, 0,
			2, 1, 0, 1, 1, 1, -1, 1, 0, 2, 0, 1, 1, 1, -1, 1, 1, 1, 3, 2, 1, 0, 3, 1, 2, 0, 1, 3, 2, 0, 1, 3, 1, 0, 2, 1, 3, 0, 2,
			1, 3, 0, 1, 2, 1, 1, 1, 0, 0, 2, 2, 0, 0, 1, 1, 0, 1, 0, 2, 0, 2, 0, 1, 1, 0, 0, 1, 2, 0, 0, 2, 2, 0, 0, 0, 0, 1, 1,
			-1, 1, 2, 0, 0, 0, 0, 1, -1, 1, 1, 2, 0, 0, 0, 0, 1, 1, 1, -1, 2, 3, 1, 1, 1, 2, 0, 0, 2, 2, 3, 1, 1, 1, 2, 2, 0, 0,
			2, 3, 1, 1, 1, 2, 0, 2, 0, 2, 1, 1, -1, 1, 2, 0, 0, 2, 2, 1, 1, -1, 1, 2, 2, 0, 0, 2, 1, -1, 1, 1, 2, 0, 0, 2, 2, 1,
			-1, 1, 1, 2, 0, 2, 0, 2, 1, 1, 1, -1, 2, 2, 0, 0, 2, 1, 1, 1, -1, 2, 0, 2, 0
		];
		con.p4D = [
			0, 0, 1, -1, 0, 0, 0, 1, 0, -1, 0, 0, 1, 0, 0, -1, 0, 0, -1, 1, 0, 0, 0, 0, 1, -1, 0, 0, 0, 1, 0, -1, 0, 0, -1, 0, 1,
			0, 0, 0, -1, 1, 0, 0, 0, 0, 1, -1, 0, 0, -1, 0, 0, 1, 0, 0, -1, 0, 1, 0, 0, 0, -1, 1, 0, 2, 1, 1, 0, 0, 1, 1, 1, -1,
			0, 1, 1, 1, 0, -1, 0, 2, 1, 0, 1, 0, 1, 1, -1, 1, 0, 1, 1, 0, 1, -1, 0, 2, 0, 1, 1, 0, 1, -1, 1, 1, 0, 1, 0, 1, 1, -1,
			0, 2, 1, 0, 0, 1, 1, 1, -1, 0, 1, 1, 1, 0, -1, 1, 0, 2, 0, 1, 0, 1, 1, -1, 1, 0, 1, 1, 0, 1, -1, 1, 0, 2, 0, 0, 1, 1,
			1, -1, 0, 1, 1, 1, 0, -1, 1, 1, 1, 4, 2, 1, 1, 0, 4, 1, 2, 1, 0, 4, 1, 1, 2, 0, 1, 4, 2, 1, 0, 1, 4, 1, 2, 0, 1, 4, 1,
			1, 0, 2, 1, 4, 2, 0, 1, 1, 4, 1, 0, 2, 1, 4, 1, 0, 1, 2, 1, 4, 0, 2, 1, 1, 4, 0, 1, 2, 1, 4, 0, 1, 1, 2, 1, 2, 1, 1,
			0, 0, 3, 2, 1, 0, 0, 3, 1, 2, 0, 0, 1, 2, 1, 0, 1, 0, 3, 2, 0, 1, 0, 3, 1, 0, 2, 0, 1, 2, 0, 1, 1, 0, 3, 0, 2, 1, 0,
			3, 0, 1, 2, 0, 1, 2, 1, 0, 0, 1, 3, 2, 0, 0, 1, 3, 1, 0, 0, 2, 1, 2, 0, 1, 0, 1, 3, 0, 2, 0, 1, 3, 0, 1, 0, 2, 1, 2,
			0, 0, 1, 1, 3, 0, 0, 2, 1, 3, 0, 0, 1, 2, 2, 3, 1, 1, 1, 0, 2, 1, 1, 1, -1, 2, 2, 0, 0, 0, 2, 3, 1, 1, 0, 1, 2, 1, 1,
			-1, 1, 2, 2, 0, 0, 0, 2, 3, 1, 0, 1, 1, 2, 1, -1, 1, 1, 2, 2, 0, 0, 0, 2, 3, 1, 1, 1, 0, 2, 1, 1, 1, -1, 2, 0, 2, 0,
			0, 2, 3, 1, 1, 0, 1, 2, 1, 1, -1, 1, 2, 0, 2, 0, 0, 2, 3, 0, 1, 1, 1, 2, -1, 1, 1, 1, 2, 0, 2, 0, 0, 2, 3, 1, 1, 1, 0,
			2, 1, 1, 1, -1, 2, 0, 0, 2, 0, 2, 3, 1, 0, 1, 1, 2, 1, -1, 1, 1, 2, 0, 0, 2, 0, 2, 3, 0, 1, 1, 1, 2, -1, 1, 1, 1, 2,
			0, 0, 2, 0, 2, 3, 1, 1, 0, 1, 2, 1, 1, -1, 1, 2, 0, 0, 0, 2, 2, 3, 1, 0, 1, 1, 2, 1, -1, 1, 1, 2, 0, 0, 0, 2, 2, 3, 0,
			1, 1, 1, 2, -1, 1, 1, 1, 2, 0, 0, 0, 2, 2, 1, 1, 1, -1, 0, 1, 1, 1, 0, -1, 0, 0, 0, 0, 0, 2, 1, 1, -1, 1, 0, 1, 1, 0,
			1, -1, 0, 0, 0, 0, 0, 2, 1, -1, 1, 1, 0, 1, 0, 1, 1, -1, 0, 0, 0, 0, 0, 2, 1, 1, -1, 0, 1, 1, 1, 0, -1, 1, 0, 0, 0, 0,
			0, 2, 1, -1, 1, 0, 1, 1, 0, 1, -1, 1, 0, 0, 0, 0, 0, 2, 1, -1, 0, 1, 1, 1, 0, -1, 1, 1, 0, 0, 0, 0, 0, 2, 1, 1, 1, -1,
			0, 1, 1, 1, 0, -1, 2, 2, 0, 0, 0, 2, 1, 1, -1, 1, 0, 1, 1, 0, 1, -1, 2, 2, 0, 0, 0, 2, 1, 1, -1, 0, 1, 1, 1, 0, -1, 1,
			2, 2, 0, 0, 0, 2, 1, 1, 1, -1, 0, 1, 1, 1, 0, -1, 2, 0, 2, 0, 0, 2, 1, -1, 1, 1, 0, 1, 0, 1, 1, -1, 2, 0, 2, 0, 0, 2,
			1, -1, 1, 0, 1, 1, 0, 1, -1, 1, 2, 0, 2, 0, 0, 2, 1, 1, -1, 1, 0, 1, 1, 0, 1, -1, 2, 0, 0, 2, 0, 2, 1, -1, 1, 1, 0, 1,
			0, 1, 1, -1, 2, 0, 0, 2, 0, 2, 1, -1, 0, 1, 1, 1, 0, -1, 1, 1, 2, 0, 0, 2, 0, 2, 1, 1, -1, 0, 1, 1, 1, 0, -1, 1, 2, 0,
			0, 0, 2, 2, 1, -1, 1, 0, 1, 1, 0, 1, -1, 1, 2, 0, 0, 0, 2, 2, 1, -1, 0, 1, 1, 1, 0, -1, 1, 1, 2, 0, 0, 0, 2, 3, 1, 1,
			0, 0, 0, 2, 2, 0, 0, 0, 2, 1, 1, 1, -1, 3, 1, 0, 1, 0, 0, 2, 0, 2, 0, 0, 2, 1, 1, 1, -1, 3, 1, 0, 0, 1, 0, 2, 0, 0, 2,
			0, 2, 1, 1, 1, -1, 3, 1, 1, 0, 0, 0, 2, 2, 0, 0, 0, 2, 1, 1, -1, 1, 3, 1, 0, 1, 0, 0, 2, 0, 2, 0, 0, 2, 1, 1, -1, 1,
			3, 1, 0, 0, 0, 1, 2, 0, 0, 0, 2, 2, 1, 1, -1, 1, 3, 1, 1, 0, 0, 0, 2, 2, 0, 0, 0, 2, 1, -1, 1, 1, 3, 1, 0, 0, 1, 0, 2,
			0, 0, 2, 0, 2, 1, -1, 1, 1, 3, 1, 0, 0, 0, 1, 2, 0, 0, 0, 2, 2, 1, -1, 1, 1, 3, 1, 0, 1, 0, 0, 2, 0, 2, 0, 0, 2, -1,
			1, 1, 1, 3, 1, 0, 0, 1, 0, 2, 0, 0, 2, 0, 2, -1, 1, 1, 1, 3, 1, 0, 0, 0, 1, 2, 0, 0, 0, 2, 2, -1, 1, 1, 1, 3, 3, 2, 1,
			0, 0, 3, 1, 2, 0, 0, 4, 1, 1, 1, 1, 3, 3, 2, 0, 1, 0, 3, 1, 0, 2, 0, 4, 1, 1, 1, 1, 3, 3, 0, 2, 1, 0, 3, 0, 1, 2, 0,
			4, 1, 1, 1, 1, 3, 3, 2, 0, 0, 1, 3, 1, 0, 0, 2, 4, 1, 1, 1, 1, 3, 3, 0, 2, 0, 1, 3, 0, 1, 0, 2, 4, 1, 1, 1, 1, 3, 3,
			0, 0, 2, 1, 3, 0, 0, 1, 2, 4, 1, 1, 1, 1, 3, 3, 2, 1, 0, 0, 3, 1, 2, 0, 0, 2, 1, 1, 1, -1, 3, 3, 2, 0, 1, 0, 3, 1, 0,
			2, 0, 2, 1, 1, 1, -1, 3, 3, 0, 2, 1, 0, 3, 0, 1, 2, 0, 2, 1, 1, 1, -1, 3, 3, 2, 1, 0, 0, 3, 1, 2, 0, 0, 2, 1, 1, -1,
			1, 3, 3, 2, 0, 0, 1, 3, 1, 0, 0, 2, 2, 1, 1, -1, 1, 3, 3, 0, 2, 0, 1, 3, 0, 1, 0, 2, 2, 1, 1, -1, 1, 3, 3, 2, 0, 1, 0,
			3, 1, 0, 2, 0, 2, 1, -1, 1, 1, 3, 3, 2, 0, 0, 1, 3, 1, 0, 0, 2, 2, 1, -1, 1, 1, 3, 3, 0, 0, 2, 1, 3, 0, 0, 1, 2, 2,
			1, -1, 1, 1, 3, 3, 0, 2, 1, 0, 3, 0, 1, 2, 0, 2, -1, 1, 1, 1, 3, 3, 0, 2, 0, 1, 3, 0, 1, 0, 2, 2, -1, 1, 1, 1, 3, 3,
			0, 0, 2, 1, 3, 0, 0, 1, 2, 2, -1, 1, 1, 1
		];

		// helper classes

		function shuffleSeed(seed) {
			var newSeed = new Uint32Array(1);
			newSeed[0] = seed[0] * 1664525 + 1013904223;
			return newSeed;
		}

		function Contribution2(multiplier, xsb, ysb) {
			this.dx = -xsb - multiplier * con.SQUISH_2D;
			this.dy = -ysb - multiplier * con.SQUISH_2D;
			this.xsb = xsb;
			this.ysb = ysb;
		}

		function Contribution3(multiplier, xsb, ysb, zsb) {
			this.dx = -xsb - multiplier * con.SQUISH_3D;
			this.dy = -ysb - multiplier * con.SQUISH_3D;
			this.dz = -zsb - multiplier * con.SQUISH_3D;
			this.xsb = xsb;
			this.ysb = ysb;
			this.zsb = zsb;
		}

		function Contribution4(multiplier, xsb, ysb, zsb, wsb) {
			this.dx = -xsb - multiplier * con.SQUISH_4D;
			this.dy = -ysb - multiplier * con.SQUISH_4D;
			this.dz = -zsb - multiplier * con.SQUISH_4D;
			this.dw = -wsb - multiplier * con.SQUISH_4D;
			this.xsb = xsb;
			this.ysb = ysb;
			this.zsb = zsb;
			this.wsb = wsb;
		}

		// initialize

		var contributions2D = [];
		for (var i = 0; i < con.p2D.length; i += 4) {
			var baseSet = con.base2D[con.p2D[i]];
			var previous = null;
			var current = null;
			for (var k = 0; k < baseSet.length; k += 3) {
				current = new Contribution2(baseSet[k], baseSet[k + 1], baseSet[k + 2]);
				if (previous === null)
					contributions2D[i / 4] = current;
				else
					previous.next = current;
				previous = current;
			}
			current.next = new Contribution2(con.p2D[i + 1], con.p2D[i + 2], con.p2D[i + 3]);
		}
		this.lookup2D = [];
		for (var i = 0; i < con.lookupPairs2D.length; i += 2) {
			this.lookup2D[con.lookupPairs2D[i]] = contributions2D[con.lookupPairs2D[i + 1]];
		}
		var contributions3D = [];
		for (var i = 0; i < con.p3D.length; i += 9) {
			var baseSet = con.base3D[con.p3D[i]];
			var previous = null;
			var current = null;
			for (var k = 0; k < baseSet.length; k += 4) {
				current = new Contribution3(baseSet[k], baseSet[k + 1], baseSet[k + 2], baseSet[k + 3]);
				if (previous === null)
					contributions3D[i / 9] = current;
				else
					previous.next = current;
				previous = current;
			}
			current.next = new Contribution3(con.p3D[i + 1], con.p3D[i + 2], con.p3D[i + 3], con.p3D[i + 4]);
			current.next.next = new Contribution3(con.p3D[i + 5], con.p3D[i + 6], con.p3D[i + 7], con.p3D[i + 8]);
		}
		this.lookup3D = [];
		for (var i = 0; i < con.lookupPairs3D.length; i += 2) {
			this.lookup3D[con.lookupPairs3D[i]] = contributions3D[con.lookupPairs3D[i + 1]];
		}
		var contributions4D = [];
		for (var i = 0; i < con.p4D.length; i += 16) {
			var baseSet = con.base4D[con.p4D[i]];
			var previous = null;
			var current = null;
			for (var k = 0; k < baseSet.length; k += 5) {
				current = new Contribution4(baseSet[k], baseSet[k + 1], baseSet[k + 2], baseSet[k + 3], baseSet[k + 4]);
				if (previous === null)
					contributions4D[i / 16] = current;
				else
					previous.next = current;
				previous = current;
			}
			current.next = new Contribution4(con.p4D[i + 1], con.p4D[i + 2], con.p4D[i + 3], con.p4D[i + 4], con.p4D[i + 5]);
			current.next.next = new Contribution4(con.p4D[i + 6], con.p4D[i + 7], con.p4D[i + 8], con.p4D[i + 9], con.p4D[i + 10]);
			current.next.next.next = new Contribution4(con.p4D[i + 11], con.p4D[i + 12], con.p4D[i + 13], con.p4D[i + 14], con.p4D[i + 15]);
		}
		this.lookup4D = [];
		for (var i = 0; i < con.lookupPairs4D.length; i += 2) {
			this.lookup4D[con.lookupPairs4D[i]] = contributions4D[con.lookupPairs4D[i + 1]];
		}

		// end initialize

		this.perm = new Uint8Array(256);
		this.perm2D = new Uint8Array(256);
		this.perm3D = new Uint8Array(256);
		this.perm4D = new Uint8Array(256);
		var source = new Uint8Array(256);
		for (var i = 0; i < 256; i++)
			source[i] = i;
		var seed = new Uint32Array(1);
		seed[0] = clientSeed;
		seed = shuffleSeed(shuffleSeed(shuffleSeed(seed)));
		for (var i = 255; i >= 0; i--) {
			seed = shuffleSeed(seed);
			var r = new Uint32Array(1);
			r[0] = (seed[0] + 31) % (i + 1);
			if (r[0] < 0)
				r[0] += (i + 1);
			this.perm[i] = source[r[0]];
			this.perm2D[i] = this.perm[i] & 0x0E;
			this.perm3D[i] = (this.perm[i] % 24) * 3;
			this.perm4D[i] = this.perm[i] & 0xFC;
			source[r[0]] = source[i];
		}

		this.simplex1D = function(x) {
			return that.simplex2D(x, 1);
		}

		this.simplex2D = function (x, y) {
			var stretchOffset = (x + y) * con.STRETCH_2D;
			var _a = [x + stretchOffset, y + stretchOffset], xs = _a[0], ys = _a[1];
			var _b = [Math.floor(xs), Math.floor(ys)], xsb = _b[0], ysb = _b[1];
			var squishOffset = (xsb + ysb) * con.SQUISH_2D;
			var _c = [x - (xsb + squishOffset), y - (ysb + squishOffset)], dx0 = _c[0], dy0 = _c[1];
			var _d = [xs - xsb, ys - ysb], xins = _d[0], yins = _d[1];
			var inSum = xins + yins;
			var hashVals = new Uint32Array(4);
			hashVals[0] = xins - yins + 1;
			hashVals[1] = inSum;
			hashVals[2] = inSum + yins;
			hashVals[3] = inSum + xins;
			var hash = hashVals[0] | (hashVals[1] << 1) | (hashVals[2] << 2) | (hashVals[3] << 4);
			var c = that.lookup2D[hash];
			var value = 0.0;
			while (typeof c !== 'undefined') {
				var _e = [dx0 + c.dx, dy0 + c.dy], dx = _e[0], dy = _e[1];
				var attn = 2 - dx * dx - dy * dy;
				if (attn > 0) {
					var _f = [xsb + c.xsb, ysb + c.ysb], px = _f[0], py = _f[1];
					var i = that.perm2D[(that.perm[px & 0xFF] + py) & 0xFF];
					var valuePart = con.gradients2D[i] * dx + con.gradients2D[i + 1] * dy;
					attn *= attn;
					value += attn * attn * valuePart;
				}
				c = c.next;
			}
			return value * con.NORM_2D;
		};

		this.simplex3D = function (x, y, z) {
			var stretchOffset = (x + y + z) * con.STRETCH_3D;
			var _a = [x + stretchOffset, y + stretchOffset, z + stretchOffset], xs = _a[0], ys = _a[1], zs = _a[2];
			var _b = [Math.floor(xs), Math.floor(ys), Math.floor(zs)], xsb = _b[0], ysb = _b[1], zsb = _b[2];
			var squishOffset = (xsb + ysb + zsb) * con.SQUISH_3D;
			var _c = [x - (xsb + squishOffset), y - (ysb + squishOffset), z - (zsb + squishOffset)], dx0 = _c[0], dy0 = _c[1], dz0 = _c[2];
			var _d = [xs - xsb, ys - ysb, zs - zsb], xins = _d[0], yins = _d[1], zins = _d[2];
			var inSum = xins + yins + zins;
			var hashVals = new Uint32Array(7);
			hashVals[0] = yins - zins + 1;
			hashVals[1] = xins - yins + 1;
			hashVals[2] = xins - zins + 1;
			hashVals[3] = inSum;
			hashVals[4] = inSum + zins;
			hashVals[5] = inSum + yins;
			hashVals[6] = inSum + xins;
			var hash = hashVals[0] | hashVals[1] << 1 | hashVals[2] << 2 | hashVals[3] << 3 | hashVals[4] << 5 |
				hashVals[5] << 7 | hashVals[6] << 9;
			var c = that.lookup3D[hash];
			var value = 0.0;
			while (typeof c !== 'undefined') {
				var _e = [dx0 + c.dx, dy0 + c.dy, dz0 + c.dz], dx = _e[0], dy = _e[1], dz = _e[2];
				var attn = 2 - dx * dx - dy * dy - dz * dz;
				if (attn > 0) {
					var _f = [xsb + c.xsb, ysb + c.ysb, zsb + c.zsb], px = _f[0], py = _f[1], pz = _f[2];
					var i = that.perm3D[(that.perm[(that.perm[px & 0xFF] + py) & 0xFF] + pz) & 0xFF];
					var valuePart = con.gradients3D[i] * dx + con.gradients3D[i + 1] * dy + con.gradients3D[i + 2] * dz;
					attn *= attn;
					value += attn * attn * valuePart;
				}
				c = c.next;
			}
			return value * con.NORM_3D;
		};

		this.simplex4D = function (x, y, z, w) {
			var stretchOffset = (x + y + z + w) * con.STRETCH_4D;
			var _a = [x + stretchOffset, y + stretchOffset, z + stretchOffset, w + stretchOffset], xs = _a[0], ys = _a[1], zs = _a[2], ws = _a[3];
			var _b = [Math.floor(xs), Math.floor(ys), Math.floor(zs), Math.floor(ws)], xsb = _b[0], ysb = _b[1], zsb = _b[2], wsb = _b[3];
			var squishOffset = (xsb + ysb + zsb + wsb) * con.SQUISH_4D;
			var dx0 = x - (xsb + squishOffset);
			var dy0 = y - (ysb + squishOffset);
			var dz0 = z - (zsb + squishOffset);
			var dw0 = w - (wsb + squishOffset);
			var _c = [xs - xsb, ys - ysb, zs - zsb, ws - wsb], xins = _c[0], yins = _c[1], zins = _c[2], wins = _c[3];
			var inSum = xins + yins + zins + wins;
			var hashVals = new Uint32Array(11);
			hashVals[0] = zins - wins + 1;
			hashVals[1] = yins - zins + 1;
			hashVals[2] = yins - wins + 1;
			hashVals[3] = xins - yins + 1;
			hashVals[4] = xins - zins + 1;
			hashVals[5] = xins - wins + 1;
			hashVals[6] = inSum << 6;
			hashVals[7] = inSum + wins;
			hashVals[8] = inSum + zins;
			hashVals[9] = inSum + yins;
			hashVals[10] = inSum + xins;
			var hash = hashVals[0] | hashVals[1] << 1 | hashVals[2] << 2 | hashVals[3] << 3 | hashVals[4] << 4 | hashVals[5] << 5 |
				hashVals[6] << 6 | hashVals[7] << 8 | hashVals[8] << 11 | hashVals[9] << 14 | hashVals[10] << 17;
			var c = that.lookup4D[hash];
			var value = 0.0;
			while (typeof c !== 'undefined') {
				var _d = [dx0 + c.dx, dy0 + c.dy, dz0 + c.dz, dw0 + c.dw], dx = _d[0], dy = _d[1], dz = _d[2], dw = _d[3];
				var attn = 2 - dx * dx - dy * dy - dz * dz - dw * dw;
				if (attn > 0) {
					var _e = [xsb + c.xsb, ysb + c.ysb, zsb + c.zsb, wsb + c.wsb], px = _e[0], py = _e[1], pz = _e[2], pw = _e[3];
					var i = that.perm4D[(that.perm[(that.perm[(that.perm[px & 0xFF] + py) & 0xFF] + pz) & 0xFF] + pw) & 0xFF];
					var valuePart = con.gradients4D[i] * dx + con.gradients4D[i + 1] * dy + con.gradients4D[i + 2] * dz + con.gradients4D[i + 3] * dw;
					attn *= attn;
					value += attn * attn * valuePart;
				}
				c = c.next;
			}
			return value * con.NORM_4D;
		};

	}//-13.9

/*--
zim.Point = function(x, y, z, q, r, s, t, u, v, w)

Point
zim class

DESCRIPTION
Stores x, y, z, q, r, s, t, u, v, w properties.
See also createjs.Point for a Point class with more features.

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var point = new Point(100, 100);
zog(point.x, point.y); // 100, 100
END EXAMPLE

PARAMETERS
x - (default 0) the x value of the point
y - (default 0) the y value of the point
z - (default 0) the z value of the point - probably not used
q - (default 0) the q value of the point - very probably not used
r - (default 0) the r value of the point - very probably not used
s - (default 0) the s value of the point - very probably not used
t - (default 0) the t value of the point - very probably not used
u - (default 0) the u value of the point - very probably not used
v - (default 0) the v value of the point - very probably not used
w - (default 0) the w value of the point - very probably not used

PROPERTIES
x - the x value of the point
y - the y value of the point
z - the z value of the point - probably not used
q - the q value of the point - very probably not used
r - the r value of the point - very probably not used
s - the s value of the point - very probably not used
t - the t value of the point - very probably not used
u - the u value of the point - very probably not used
v - the v value of the point - very probably not used
w - the w value of the point - very probably not used
--*///+13.45
	zim.Point = function(x, y, z, q, r, s, t, u, v, w) {
		z_d("13.45");
		if (zot(x)) x = 0;
		if (zot(y)) y = 0;
		if (zot(z)) z = 0;
		if (zot(q)) q = 0;
		if (zot(r)) r = 0;
		if (zot(s)) s = 0;
		if (zot(t)) t = 0;
		if (zot(u)) u = 0;
		if (zot(v)) v = 0;
		if (zot(w)) w = 0;
		this.x = x;
		this.y = y;
		this.z = z;
		this.q = q;
		this.r = r;
		this.s = s;
		this.t = t;
		this.u = u;
		this.v = v;
		this.w = w;
	}//-13.45

/*--
zim.Boundary = function(x, y, width, height)

Boundary
zim class

DESCRIPTION
Stores the data for a rectangle with x, y, width and height.
Can be used with ZIM drag(), gesture() for boundaries
and the Physics module for world boundary.

NOTE: A createjs.Rectangle or an object {} with x, y, width and height properties can also be used
Boundary was introduced to reduce confusion over having a ZIM Rectangle (Shape) and a CreateJS Rectangle (data)

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
new Circle(100, blue)
	.center()
	.drag(new Boundary(0,0,stageW,stageH));
// note: drag and gesture used to have rect parameters
// these have now been depreciated and replaced with boundary parameters

// CONTRACT
// the drag() boundary contains the registration point
// note: the gesture() boundary contains the whole shape of the object
// here, we keep the circle inside the stage by contracting the Boundary by the radius
var radius = 100;
new Circle(radius, red)
	.center()
	.drag(new Boundary(0,0,stageW,stageH).contract(radius));
END EXAMPLE

PARAMETERS
x - the x position of the Boundary
y - the y position of the Boundary
width - the width of the Boundary
height - the height of the Boundary

PROPERTIES
x - the x position of the Boundary
y - the y position of the Boundary
width - the width of the Boundary
height - the height of the Boundary

METHODS
contract(number|x, y, width, height) - number of pixels to make the Boundary smaller
	passing in a single number will contract this on all sides
	passing in two numbers will contract from horizontal and vertical accordingly
	passing in four numbers will contract from the sides accordingly
	note: to expand pass in a negative number
	returns object for chaining
--*///+13.46
	zim.Boundary = function(x, y, width, height) {
		z_d("13.46");
		if (zot(x) || zot(y) || zot(width) || zot(height)) return;
		this.x = x;
		this.y = y;
		this.width = width;
		this.height = height;
		this.contract = function(a,b,c,d) {
			if (zot(a)) return this;
			if (zot(b)) b = a;
			if (zot(c)) {
				c = a*2;
			} else {
				c = c+a;
			}
			if (zot(d)) {
				d = b*2;
			} else {
				d = d+b;
			}
			this.x += a;
			this.y += b;
			this.width -= c;
			this.height -= d;
			return this;
		}
	}//-13.46


/*--
zim.Damp = function(startValue, damp)

Damp
zim class

DESCRIPTION
Damping emulates things slowing down due to friction.
The movement heads towards the right value and looks organic.
This is similar if not the same as easing out when tweening.
Create your Damp object outside an interval or Ticker
then inside an interval or ticker call the convert method.

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var d = new Damp(parameters);
setInterval(function() {
	dampedValue = d.convert(desiredValue);
}, 100);
END EXAMPLE

you would then apply that desired value to a property such as x or y or scale
if you want to do both x and y then you need two Damp objects
and two convert calls (you can do both in one interval or ticker)

EXAMPLE
var circle = new Circle();
circle.center(stage);
var dampX = new Damp(circle.x);
var dampY = new Damp(circle.y);
// start moving once mouse enters stage
// this event will only run once (the last parameter is true)
stage.on("stagemousemove", start, null, true);
function start(e) {
	Ticker.add(function() {
		circle.x = dampX.convert(e.stageX);
		circle.y = dampY.convert(e.stageY);
	}, stage);
}
END EXAMPLE

PARAMETERS supports DUO - parameters or single object with properties below
startValue - (default 0) start object at this value and then start damping
damp - (default .1) the damp value with 1 being no damping and 0 being no movement

METHODS
convert(value) - converts a value into a damped value
immediate(value) - immediately goes to value and returns the Damp object

PROPERTIES
damp - can dynamically change the damping (usually just pass it in as a parameter to start)
lastValue - setting this would go immediately to this value (would not normally use)
--*///+14
	zim.Damp = function(startValue, damp) {
		z_d("14");
		var sig = "startValue, damp";
		var duo; if (duo = zob(zim.Damp, arguments, sig, this)) return duo;
		this.lastValue = (zot(startValue)) ? 0 : startValue;
		this.damp = (zot(damp)) ? .1 : damp;
	}
	zim.Damp.prototype.convert = function(desiredValue) {
		return this.lastValue = this.lastValue + (desiredValue - this.lastValue) * this.damp;
	}
	zim.Damp.prototype.immediate = function(desiredValue) {
		this.lastValue = desiredValue;
		return this;
	}//-14

/*--
zim.Proportion = function(baseMin, baseMax, targetMin, targetMax, factor, targetRound, clamp)

Proportion
zim class

DESCRIPTION
Proportion converts an input value to an output value on a different scale.
(sometimes called a map() function)
For instance, like a slider controlling the scale of an object or sound volume.
Make a Proportion object and then in an interval, ticker or event,
convert the base value to the target value using the convert method.

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
frame.loadAssets("mySound.mp3");
frame.on("complete", function() {
	var sound = frame.asset("mySound.mp3").play();
	var p = new Proportion(0, 10, 0, 1);
	var dial = new Dial(); // default range of 0 to 10
	dial.currentValue = 10;
	dial.on("change", function(){
		sound.volume = p.convert(dial.currentValue);
	}); // end of dial change
}); // end sound loaded
END EXAMPLE

PARAMETERS supports DUO - parameters or single object with properties below
baseMin - min for the input scale (say x value)
baseMax - max for the input scale (say x value)
targetMin - (default 0) min for the output scale (say volume)
targetMax - (default 1) max for the output scale (say volume)
factor - (default 1) is going the same direction and -1 is going in opposite direction
targetRound - (default false) set to true to round the converted number
clamp - (default true) set to false to let results go outside min and max range

METHODS
convert(input) - will return the output property (for instance, a volume)

NOTE: the object always starts by assuming baseMin as baseValue
just call the convert method right away if you want it to start at a different baseValue
for instance, if your slider went from 100 to 500 and you want to start at half way
make the object and call p.convert(300); on the next line
--*///+15
	zim.Proportion = function(baseMin, baseMax, targetMin, targetMax, factor, targetRound, clamp) {
		var sig = "baseMin, baseMax, targetMin, targetMax, factor, targetRound, clamp";
		var duo; if (duo = zob(zim.Proportion, arguments, sig, this)) return duo;
		z_d("15");
		// factor - set to 1 for increasing and -1 for decreasing
		// round - true to round results to whole number
		if (zot(targetMin)) targetMin = 0;
		if (zot(targetMax)) targetMax = 1;
		if (zot(factor)) factor = 1;
		if (zot(targetRound)) targetRound = false;
		if (zot(clamp)) clamp = true;

		// proportion
		var baseAmount;
		var proportion;
		var targetAmount;

		baseAmount = baseMin; // just start at the min otherwise call immediate(baseValue);

		this.convert = function(baseAmount) {
			if (isNaN(baseAmount) || (baseMax-baseMin==0)) {return;}
			if (clamp) {
				baseAmount = Math.max(baseAmount, baseMin);
				baseAmount = Math.min(baseAmount, baseMax);
			}
			proportion = (baseAmount - baseMin) / (baseMax - baseMin);
			if (factor > 0) {
				targetAmount = targetMin + (targetMax-targetMin) * proportion;
			} else {
				targetAmount = targetMax - (targetMax-targetMin) * proportion;
			}
			if (targetRound) {targetAmount = Math.round(targetAmount);}
			return targetAmount;
		}
	}//-15

/*--
zim.ProportionDamp = function(baseMin, baseMax, targetMin, targetMax, damp, factor, targetRound, clamp)

ProportionDamp
zim class

DESCRIPTION
ProportionDamp converts an input value to an output value on a different scale with damping.
Works like Proportion Class but with a damping parameter.
Damping needs constant calculating so do not put in mousemove event.
The below example scales the circle based on the mouse height.

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var circle = new Circle(50, "red");
circle.center(stage); // center method added in ZIM 4TH
var pd = new ProportionDamp(0, stageH, 0, 5, .2);
Ticker.add(function() {
	circle.sca(pd.convert(stage.mouseH)); // scale method added in ZIM 4TH
}, stage);
END EXAMPLE

PARAMETERS supports DUO - parameters or single object with properties below
baseMin - min for the input scale (say x value)
baseMax - max for the input scale (say x value)
targetMin - (default 0) min for the output scale (say volume)
targetMax - (default 1) max for the output scale (say volume)
damp - (default .1) the damp value with 1 being no damping and 0 being no movement
factor (default 1) is going the same direction and -1 is going in opposite direction
targetRound (default false) set to true to round the converted number

METHODS
convert(input) - converts a base value to a target value
immediate(input) - immediately sets the target value (no damping) and returns the ProportionDamp object
dispose() - clears interval

PROPERTIES
damp - can adjust this dynamically (usually just pass it in as a parameter to start)

NOTE: the object always starts by assuming baseMin as baseValue
if you want to start or go to an immediate value without easing then
call the pd.immediate(baseValue) method with your desired baseValue (not targetValue)
--*///+16
	zim.ProportionDamp = function(baseMin, baseMax, targetMin, targetMax, damp, factor, targetRound, clamp) {
		var sig = "baseMin, baseMax, targetMin, targetMax, damp, factor, targetRound, clamp";
		var duo; if (duo = zob(zim.ProportionDamp, arguments, sig, this)) return duo;
		z_d("16");
		// damp - can be changed via damp get/set method property
		// factor - set to 1 for increasing and -1 for decreasing
		// round - true to round results to whole number
		// zot() is found in danzen.js (the z version of not)
		if (zot(targetMin)) targetMin = 0;
		if (zot(targetMax)) targetMax = 1;
		if (zot(damp)) damp = .1;
		if (zot(factor)) factor = 1;
		if (zot(targetRound)) targetRound = false;
		if (zot(clamp)) clamp = true;

		this.damp = damp; // want to expose as a property we can change
		var that = this;

		// proportion
		var baseAmount;
		var proportion;
		var targetDifference;
		var targetAmount;

		// damping
		var differenceAmount;
		var desiredAmount=0;
		var lastAmount = 0;

		baseAmount = baseMin; // just start at the min otherwise call immediate(baseValue);
		lastAmount = targetMin;

		var interval = setInterval(calculate, 20);

		function calculate() {
			if (isNaN(baseAmount) || (baseMax-baseMin==0)) {return;}

			if (clamp) {
				baseAmount = Math.max(baseAmount, baseMin);
				baseAmount = Math.min(baseAmount, baseMax);
			}

			proportion = (baseAmount - baseMin) / (baseMax - baseMin);
			targetDifference = targetMax - targetMin;

			if (factor > 0) {
				targetAmount = targetMin + targetDifference * proportion;
			} else {
				targetAmount = targetMax - targetDifference * proportion;
			}

			desiredAmount = targetAmount;
			differenceAmount = desiredAmount - lastAmount;
			lastAmount += differenceAmount*that.damp;
		}

		this.immediate = function(n) {
			that.convert(n);
			calculate();
			lastAmount = targetAmount;
			if (targetRound) {lastAmount = Math.round(lastAmount);}
			return that;
		}

		this.convert = function(n) {
			baseAmount = n;
			if (targetRound) {
				return Math.round(lastAmount);
			} else {
				return lastAmount;
			}
		}

		this.dispose = function() {
			clearInterval(interval);
			return true;
		}
	}//-16

/*--
zim.Dictionary = function(unique)

Dictionary
zim class

DESCRIPTION
An object that uses objects as keys to give values.
Similar to an object literal with properties except the property names are objects instead of strings.
JavaScript currently does not have a dictionary, but other languages do.

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var o = {test:"test"};
var f = function(w) {zog(w)};
var c = new Circle();
var d = new Dictionary();
d.add(o, 1); d.add(f, 2); d.add(c, f);
zog(d.at(o)); // 1
zog(d.at(f)); // 2
d.at(c)("hello"); // hello
d.remove(o); // to clear o
zog(d.length); // 2
END EXAMPLE

EXAMPLE
var d = new Dictionary();
d.add(circle, "one");
d.add(circle, "two");
zog(d.at(circle)); // two - just the latest but "one" is still there
for (var i=0; i<d.length; i++) {
	if (d.objects[i] == circle) zog(d.values[i]); // one then two
}
// note, loop backwards to clear values at a key
END EXAMPLE

EXAMPLE
// with unique property add(key, val) removes the last val at that key
var d = new Dictionary(true);
d.add(circle, "one");
d.add(circle, "two");
zog(d.at(circle)); // two - and now only two is there
for (var i=0; i<d.length; i++) {
	if (d.objects[i] == circle) zog(d.values[i]); // two
}
// note, now d.remove(key) removes that unique entry for the key
END EXAMPLE

PARAMETERS
unique (default false) - set to true to only accept a single entry (the last added) for a key

METHODS
add(object, value) - adds a value that can be retrieved by an object reference
	if unique is false, this will not overwrite previous entries at the object key
	if unique is true, this will overwrite previous entries at the object key
	value is optional and will default to true
at(object) - retrieves the last value stored at the object (or returns null if not there)
remove(object) - removes the last value at the object from the Dictionary returns boolean success
clear() - removes all objects from Dictionary - returns object for chaining
dispose() - deletes Dictionary object

PROPERTIES
length - the number of items in the Dictionary
unique - whether the dictionary will overwrite values (going from false to true will not delete previous values)
objects - array of keys
values - array of values synched to keys
--*///+17
	zim.Dictionary = function(unique) {
		z_d("17");
		this.length = 0;
		this.unique = unique;
		var objects = this.objects = []; // store objects and values in synched arrays
		var values = this.values = [];

		this.add = function(o,v) {
			if (zot(o)) return;
			if (zot(v)) v = true;
			if (this.unique) this.remove(o);
			objects.push(o);
			values.push(v);
			this.length++;
		}

		this.at = function(o) {
			if (zot(o)) return;
			var i = objects.indexOf(o);
			if (i > -1) return values[i];
			return null;
		}

		this.remove = function(o) {
			if (zot(o)) return false;
			var i = objects.indexOf(o);
			if (i > -1) {
				objects.splice(i,1);
				values.splice(i,1);
				this.length--
				return true;
			} else {
				return false;
			}
		}

		this.clear = function() {
			objects = this.objects = []; // store objects and values in synched arrays
			values = this.values = [];
			this.length = null;
			return this;
		}

		this.dispose = function() {
			objects = null;
			values = null;
			this.length = null;
			return true;
		}
	}//-17

/*--
zim.Hierarchy = function(input)

Hierarchy
zim class

DESCRIPTION
A hierarchy is a nested structure for organized data (like XML).
For instance, Hierarchy manages the accordion feature of ZIM List()
where the list can be expanded and collapsed to show nested sections.

HOW IT WORKS
There are two formats that can be used as input.
Each will create a data property in final hierarchy format.

A. The SIMPLE input is an easier format to write but
has a limitation in that identifiers must be strings.
The Hierarchy replaces the identifiers with sequential ids
and stores the original identifiers as an obj property.

B. The COMPLEX input starts off like the final hierarchy data
which has the advantage of storing any type of object in the hierarchy.
The disadvantage is the ids must be hand coded and it is longer.
The Hierarchy will add level, open and opened properties
and create the data property in final hierarchy format.

STRATEGY
The complex format is tricky.
One way to deal with it is to pass in a SIMPLE string version.
Then replace the strings with final objects in the data property.
The Hierarchy class is used internally by ZIM so may not be needed.
However, it will help for custom tree menus, mindmaps, etc.

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE - SIMPLE INPUT
// 1. Here is linear input as an array - a boring tree - more like grass!
var simple = [1,2,3,4]; // so we would probably not use Hierarchy for this.

// 2. To hold nested data we use an object literal.
// The properties can hold linear arrays as values
// but if any of the values need to hold more values then use an object literal:
var simple = {
    "linear":[1,2,3,4], // an array is okay as all items are leaf nodes (end nodes)
    "nested":{ // an object literal is required as one or more items hold other items
        "A":[], // this holds nothing (a leaf node) but still needs an empty array
        "B":["one", "two", "three"], // this holds a linear list - all leaf nodes
        "C":{ // this holds another nested list where at least one item holds more
            "LEAF":[],
            "LINEAR":[1,2,3,4],
            "LEAF":[]
        }
    }
}

// pass the object into the input parameter:
var hierarchy = new Hierarchy(simple);
var data = hierarchy.data;

// data will be the following - note it is a more complex format
// but also a form that could hold any type of data as a value
// note the level matches the indent and all values have an id
data = {
    id0:{obj:"linear", level:0, open:false, opened:false, list:{
        id1:{obj:1, level:1},
        id2:{obj:2, level:1},
        id3:{obj:3, level:1},
        id4:{obj:4, level:1}
    }},
    id5:{obj:"nested", level:0, open:false, opened:false, list:{
        id6:{obj:"A", level:1},
        id7:{obj:"B", level:1, open:false, opened:false, list:{
            id8:{obj:"one", level:2},
            id9:{obj:"two", level:2},
            id10:{obj:"three", level:2}
        }},
        id11:{obj:"C", level:1, open:false, opened:false, list:{
            id12:{obj:"LEAF", level:2},
            id13:{obj:"LINEAR", level:2, open:false, opened:false, list:{
                id14:{obj:1, level:3},
                id15:{obj:2, level:3},
                id16:{obj:3, level:3},
                id17:{obj:4, level:3}
            }},
            id18:{obj:"LEAF", level:2}
        }}
    }}
}
END EXAMPLE

EXAMPLE - COMPLEX INPUT
// Here is a sample of passing in the more complex format.
// level, open, opened properties are not required
// they will be added by the Hierarchy.
// Note that there are no arrays in this data format so that each item has an id.
// This could be passed in to the data property of List
// to show an expandable hierarchy of objects rather than strings converted to buttons
var complex = {
	id0:{obj:new Rectangle(), list:{
		id1:{obj:new Triangle()},
		id2:{obj:new Triangle()},
		id3:{obj:new Triangle()}
	}},
	id4:{obj:new Circle(), list:{
		id5:{obj:new Button()},
		id6:{obj:new Button(), list:{
			id7:{obj:new CheckBox()},
			id8:{obj:new CheckBox()},
		}},
		id9:{obj:new Button(), list:{
			id10:{obj:new Label("Leaf")},
			id11:{obj:new Label("Nest"), list:{
				id12:{obj:1},
				id13:{obj:2},
				id14:{obj:3},
				id15:{obj:4},
			}},
			id16:{obj:new Label("Leaf")}
		}}
	}}
};
var hierarchy = new Hierarchy(complex);
var list = new List({list:hierarchy.data, align:"center"}).center();
END EXAMPLE

PARAMETERS
input (default null) - a simple formated input - see the examples
	this will be turned in to a more complex object literal available as the data property
	OR input a complex formated input - similar to the data property output
	but only ids, obj and list properties are required.
	The main purpose of Hierarchy is to create the complex data object
	but passing in a complex format allows objects other than strings to be used.

METHODS
processSimple(input) - enter simple input - returns a Hierarchy data object literal
	this is what the Hierarchy does when a simple input is provided to make its data property
	the input must be in the simple format as described in the SIMPLE example.
processComplex(input) - enter complex input - returns a Hierarchy data object literal
	this is what the Hierarchy does when complex data is provided to make its data property
	processComplex will add level, open, and opened properties to the data
	otherwise data must be in the same format as the final data property - see COMPLEX example
getLinearList(data) - enter final data format, to get a linear list top level objects
	and all open list objects within according to the open property
getLinearIds(data) - enter final data format, to get a linear list top level ids
	and all open lists ids within according to the open property
getData(id) - find the final data format for a given Hierarchy ID - eg. id0, id12, etc.
getNextSibling(id) - gets the id of the next sibling - skipping ids of any children
	will find parents next sibling if last child in parent
	or undefined if last child in hierarchy
getPrevSibling(id) - gets the id of the previous sibling - skipping ids of any children
	will find the parent if first child in parent
	or undefined if first child in hierarchy


PROPERTIES
data - a hierarchy formated object literal with ids that hold object literals
	ids are in the format of id0, id1, id2, etc. numbered in order of creation (top to bottom)
	the object literals have obj, level, open, opened and list properties
	leaf nodes (end nodes) will have {} as its list property value
--*///+17.5
	zim.Hierarchy = function(input) {
		z_d("17.5");
		var that = this;
        if (zot(input)) return;

        that.processSimple = function(list) {
            var count = 0;
            var m = {}
            function makeLevel(list, obj, level) {
                if (list.constructor == {}.constructor) {
                    loop(list, function (key, val) {
                        var newList = {};
                        obj["id"+count] = {obj:key, level:level, open:false, opened:false, list:newList}
                        count++;
                        makeLevel(val, newList, level+1);
                    });
                } else if (Array.isArray(list)) {
                    loop(list, function (val) {
                        var newList = {};
                        obj["id"+count] = {obj:val}
                        count++;
                    });
                }
            }
            makeLevel(input, m, 0);
            return m;
        }
		that.processComplex = function(input) {
			var count = 0;
			function innerFunction(inp, level) {
				loop(inp, function (key, val) {
					val.level = level;
					val.open = false;
					val.opened = false;
					if (val.list) innerFunction(val.list, level+1);
				});
			}
			innerFunction(input, 0);
			return input;
		}

		if (zot(input.id0)) {
			that.data = that.processSimple(input);
		} else {
			that.data = that.processComplex(input);
		}

        that.getLinearList = function(data) {
			if (zot(data)) data = that.data;
            return getLinear(data)[0];
        }
        that.getLinearIDs = function(data) {
			if (zot(data)) data = that.data;
            return getLinear(data)[1];
        }

        function getLinear(data) {
            var linear = [];
            var ids = [];
            function getLevel(data, level) {
                loop(data, function (item, list) {
                    linear.push(list.obj);
                    ids.push(item);
                    if (list.open) getLevel(list.list, level+1);
                })
            }
            getLevel(data, 0);
            return [linear, ids];
        }

        that.getData = function(id) {
            // recursively find the data for id
            var answer;
            function find(obj) {
                loop(obj, function (key, val) {
                    if (key == id) {
                        answer = val;
                        return answer;
                    }
                    find(val.list);
                });
            }
            find(that.data);
            return answer;
        }

        that.getNextSibling = function(id) {
            var current;
            var answer;
            function find(obj) {
                loop(obj, function (key, val) {
                    if (!answer && current) {
                        answer = key;
                        return answer;
                    }
                    if (key == id) {
                        current = val;
                    } else {
                        find(val.list);
                    }
                });
            }
            find(that.data);
            return answer;
        }

		that.getPrevSibling = function(id) {
			var lasts = [];
            function find(obj, lev) {
                loop(obj, function (key, val) {
                    if (key == id) {
                        return lasts[lev] || lasts[lev-1];
                    } else {
						lasts[lev] = key;
                        find(val.list, lev+1);
                    }
                });
            }
            find(that.data, 0);
            return answer;
        }

	}//-17.5

/*--
zim.Pick = function(choices)

Pick
zim class

HISTORY
Pick was originally zik() and ZIM VEE (introduced in ZIM 5) throughout the ZIM documentation
It was so handy that a general (non ZIM centric) name has been given to a class
that can be used by other libraries and languages.
See https://github.com/danzen/Pick for the complete general code and description

DESCRIPTION
Pick() provides a system to handle dynamic parameters.
It does so by providing formats for options and a choose() method to pick from the options.

For example, a particle emitter has an obj parameter to receive what type of particle to emit.
If a particle were randomly chosen from a rectangle, circle or triangle and passed into obj
then the emitter would only emit the randomly chosen particle - say, a bunch of triangles.
What is desired is that the emitter emitt rectangles, circles and triangles randomly.
Pick() provides a way to pass in all three shapes and have the emitter choose each time it emits.

FORMATS
The Pick() formats handle:
	1. a random selection: ["blue", "green", "yellow"] - array format
	2. a random range: {min:10, max:30} - range object format
	3. a series: series(10,20,30) - series format also Pick.series()
	4. a function result: function(){return new Date().minutes} - function format
	5. a normal value: 7 or "hello" - single-value format
	6. a noPick object: {noPick:["real", "array"]} - escape format
	7. a combination: [{min:10, max:20}, 30, 40] - combination format (recursive)

NOTE: the range format gets passed to ZIM rand() directly so see docs there
there are also integer and negative parameters both defaulting to false

PICK LITERAL
Formats are passed in to a Pick() object and the Pick object can be passed to a class or function parameter
In ZIM, the formats may be passed directly into the class or function parameter (as a Pick literal)
	new Circle(new Pick([10,20]), red); // Pick()
	new Circle([10,20], red); // Pick Literal
** The literal can run into conflicts such as for a ZIM corner parameter which accepts an array []
This would be avoided with a system always using Pick() and never the literal.
But... ZIM started off without the formalized Pick - and the literal is shorter ;-)

NOTE: Pick is used internally by by zim.interval, zim.animate, zim.Emitter, zim.Pen, etc.
as well as ZIM Shape basic parameters handy for cloning with Tile, Emitter, etc.

EXAMPLE
var loopCount = new Pick([1,2,3]);
var choice = Pick.choose(loopCount); // 1, 2, or 3

var loopCount = [1,2,3]; // Pick literal
var choice = Pick.choose(loopCount); // 1, 2, or 3

var choice = Pick.choose([1,2,3]); // 1, 2, or 3

var rotation = {min:10, max:20, integer:false, negative:true};
// an example of a Range object - this will give values between -20 and -10 or 10 and 20
// rotation now holds an object as to how to pick its value
// this can be passed into a zim.Emitter() for instance
// which will make multiple copies and rotate them based on Pick.choose()
// or this can be passed into an animation object
// and then into zim.Emitter() for the animate parameter

var emitter = new zim.Emitter({
	obj:new zim.Rectangle(),
	random:{rotation:rotation} // the emitter will use Pick.choose() to pick a rotation for each particle
});

function age() {
	// assuming user.age is some input value that exists
	if (user.age >= 18) return ["a", "b", ["c","d"]];
	else return ["e", "f"];
}
// below will be a, b, c or d if user is 18+ with a and b having more of a chance
// or e or f if not over 18
var show = Pick.choose(age);

// below we randomize the tile colors in the first example
// and make them in color order for the second example
new Tile(new Rectangle(10,10,["blue", "red"]), 10, 10); would randomize colors
new Tile(new Rectangle(10,10,series("blue", "red")), 10, 10); would alternate colors

// here we pass an array through without processing the array:
Pick.choose({noPick:[1,2,3,4,5]}); // result is [1,2,3,4,5]

// a range between one and three seconds - repeating after 3 choices
var pick = new Pick({min:1000, max:3000}).num(3);
interval(pick, function () {console.log("calling");}); // eg. 2.5s, 2.7s, 1.2s, 2.5s, 2.7s, 1.2s, etc.
END EXAMPLE

PARAMETERS
choices - any of the ZIM Pick formats:
	1. an array of choices to choose from randomly
	2. a range object with min and max (integer and negative) properties
	3. a zim.series() or Pick.series() to pick objects in order
	4. a function that returns a result
	5. a single not one of the above that passes through
	6. an escape object with a noPick property
	7. any combination of the above to pick recursively

METHODS
num(number) - a chainable method to limit the number of options until Pick.choose() will repeat like a series
loop(number, call(value, index, total)) - a way to loop through options
 	number is the number of times to loop
	call is a callback function that gets called each loop
	the callback will recieve a value (the choice), the index of the loop and the total (the number parameter)
	inside the function a return is like a continue and a return of any value is like a break in traditional for loops.

STATIC METHODS
Pick.choose(Pick Object or Pick Literal) - gets a value from the Pick object or Pick Literal
	so chooses from a random array, or range, or gets the next in the series, etc.
Pick.rand(a, b, integer, negative) - gets a random number - same as zim.rand()
	a - the first Number for the range
		if a and b are not provided, rand() acts like Math.random()
		if parameter b is not provided, rand will use range 0 to and including a
	b - (default 0) second Number for the range
		it does not matter if a>b or a<b
	integer - (default true) set to false to include decimals in results
		if false, range will include decimals up to but not including the highest number
		if a or b have decimals this is set to false
	negative - (default false) includes the negative range as well as the positive
Pick.series(array|item1, item2, item3, etc.) - same as zim.series()
	returns a function that can be called many times each time returning the next value in the series (eventually looping)
	array|item1 - the first item - or an array of results that will be called in order as the resulting function is called
	item2 - the second item if the first is not an array
	item3 - the third item, etc. to as many items as needed

PROPERTIES
type - the type of object as a String
choices - a reference to the choices object provided as the Pick(choices) parameter
--*///+17.6
	zim.pickCheck = false;
	zim.Pick = function(choices) {
		if (!zim.pickCheck) {z_d("17.6"); zim.pickCheck=true;}
        this.choices = choices;
        this.num = function(num) {
            var s = [];
            for (var i=0; i<num; i++) {s.push(zim.Pick.choose(this))}
            this.choices = zim.Pick.series(s);
            return this;
        }
        var that = this;
        this.loop = function(num, call) {
            var r;
            for (var i=0; i<num; i++) {
                r = call(zim.Pick.choose(that), i, num);
                if (typeof r != 'undefined') return r;
            }
         }
    };
    zim.Pick.prototype.type = "Pick";
    zim.Pick.series = function() {
		// see https://github.com/danzen/Pick for all inclusive class to use in other libraries / languages, etc.
		if (!zim.pickCheck) {z_d("17.6"); zim.pickCheck=true;}
		return zim.series.apply(null, arguments);
    }
    zim.Pick.rand = function(a, b, integer, negative) {
		// see https://github.com/danzen/Pick for all inclusive class to use in other libraries / languages, etc.
		if (!zim.pickCheck) {z_d("17.6"); zim.pickCheck=true;}
		return zim.rand(a, b, integer, negative);
    }
    zim.Pick.choose = function(obj, literal) {
		if (!zim.pickCheck) {z_d("17.6"); zim.pickCheck=true;}
        if (literal == null) literal = true;
		if (obj==null) return obj;
        if (obj.type=="Pick" || literal) {
            var c = obj.choices || obj;
            if (Array.isArray(c)) {
                var val = c[Math.floor(Math.random()*(c.length))];
                return zim.Pick.choose(val); // recursive
            } else if (c.constructor === {}.constructor) {
                if (!zot(c.noPick)) return c.noPick; // a passthrough for arrays and functions
                if (zot(c.max)) return c;
                if (zot(c.integer)) c.integer = false;
                var val = zim.Pick.rand(c.min, c.max, c.integer, c.negative);
                return val; // this is just a number in a range - no need for recursive
            } else if (typeof c == "function") {
                return zim.Pick.choose((c)()); // recursive
            }
            return obj;
        } else {
            return obj;
        }
	}//-17.6

	// DOM CODE

// SUBSECTION HTML FUNCTIONS

/*--
zim.scrollX = function(num, time)

scrollX
zim function

DESCRIPTION
This function gets or sets how many pixels from the left the browser window has been scrolled.
If num is provided then the function scrolls the window to this x position.
If num and time are provided it animates the window to the x position in time milliseconds.

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
// hide the logo if the page is scrolled left more than 200 pixels
if (scrollX < -200) zss("logo").display = "none";
END EXAMPLE

PARAMETERS
num - (default null) optional scroll position to go to (probably negative)
time - (default 0) time in milliseconds to take to go to the num position

RETURNS a Number
--*///+18
	zim.scrollX = function(num, time) {
		z_d("18");
		return zim.abstractScroll("X", "Left", num, time);
	}//-18


/*--
zim.scrollY = function(num, time)

scrollY
zim function

DESCRIPTION
This function gets or sets how many pixels from the top the browser window has been scrolled.
If num is provided then the function scrolls the window to this y position.
If num and time are provided it animates the window to the y position in time milliseconds.

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
// animate the scroll position down 100 pixels in half a second
scrollY(scrollY()-100, 500);
END EXAMPLE

PARAMETERS
num - (default null) optional scroll position to go to (probably negative)
time - (default 0) time in milliseconds to take to go to the num position

RETURNS a Number
--*///+19
	zim.scrollY = function(num, time) {
		z_d("19");
		return zim.abstractScroll("Y", "Top", num, time);
	}//-19

	//+20
	zim.abstractScroll = function(dir, side, num, time) {
		z_d("20");
		var perpend = (dir == "X") ? "Y" : "X"; // perpendicular direction
		if (zot(num)) {
			var safari = 0;
			var browser=navigator.applicationName;
			var navindex=navigator.userAgent.indexOf('Safari');
			if (navindex != -1 || browser=='Safari') {
				var safari = 1;
			}
			return (document.documentElement && document.documentElement["scroll"+side]) || document.body["scroll"+side];
		} else if (zot(time)) {
			window.scrollTo(zim["scroll"+perpend](), num);
		} else {
			var interval = 50;
			if (time < interval) time = interval;
			var steps = time/interval;
			var current = zim["scroll"+dir]();
			var amount = num - current;
			var diff = amount/steps;
			var count = 0;
			var scrollInterval = setInterval(function() {
				count++;
				current+=diff;
				window.scrollTo(zim["scroll"+perpend](), current);
				if (count >= steps) {
					window.scrollTo(zim["scroll"+perpend](), num);
					clearInterval(scrollInterval);
				}
			}, interval);
		}
		return num;
	}//-20

/*--
zim.windowWidth = function()

windowWidth
zim function

DESCRIPTION
Returns the width of a window.
(window.clientWidth or window.innerWidth)

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
if (windowWidth() < 500) zss("related").display = "none";
END EXAMPLE

RETURNS a Number
--*///+21
	zim.windowWidth = function() {
		z_d("21");
		var w = isNaN(window.innerWidth) ? window.clientWidth : window.innerWidth;
		var h = isNaN(window.innerHeight) ? window.clientHeight : window.innerHeight;
		if (mobile() && !zot(window.orientation)) {
			if ((w > h && Math.abs(window.orientation) != 90) || h > w && Math.abs(window.orientation) == 90) {
				var oldW = w;
				w = h;
				h = oldW;
			}
		}
		// 6. part of TEN PATCH
		// pay attention to swapRotation from Frame
		return (typeof zimDefaultFrame != "undefined" && zimDefaultFrame.swapRotation)?h:w;
	}//-21

/*--
zim.windowHeight = function()

windowHeight
zim function

DESCRIPTION
Returns the height of a window.
(window.clientHeight or window.innerHeight)

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
if (windowHeight() > 1000) zgo("big.html");
END EXAMPLE

RETURNS a Number
--*///+22
	zim.windowHeight = function() {
		z_d("22");
		var w = isNaN(window.innerWidth) ? window.clientWidth : window.innerWidth;
		var h = isNaN(window.innerHeight) ? window.clientHeight : window.innerHeight;
		if (mobile() && !zot(window.orientation)) {
			if ((w > h && Math.abs(window.orientation) != 90) || h > w && Math.abs(window.orientation) == 90) {
				var oldW = w;
				w = h;
				h = oldW;
			}
		}
		// 7. part of TEN PATCH
		// pay attention to swapRotation from Frame
		return (typeof zimDefaultFrame != "undefined" && zimDefaultFrame.swapRotation)?w:h;
	}//-22

/*--
zim.getQueryString = function(string)

getQueryString
zim function

DESCRIPTION
Turns the HTML query string into a object.

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
// currentHTML page myPage.html?party=true&toys=many
var details = getQueryString();
zog(details.party); // "true"
zog(details.toys); // "many"
loop(details, function(key, val, i) {
	zog(key, val, i);
});
// outputs:
// party true 0
// toys many 1
END EXAMPLE

EXAMPLE
// an array of values is created if a query string has multiple properties with the same name:
var collection = getQueryString("type=dog&age=10&age=20&age=30");
zog(collection.age); // [10,20,30]
END EXAMPLE

PARAMETERS
string - (default null) null will get string from end of HTML page after ?
	set the key value pairs (without question mark) to parse a custom string
	eg. party=true&toys=many

RETURNS an object literal with properties matching the keys and values matching the values (or undefined if no query string)
--*///+22.5
	zim.getQueryString = function(s) {
		z_d("22.5");
		if (zot(s)) s = location.search.replace("?","");
		if (s == "") return;
		var vars = s.split("&");
		var obj = {};
		for (var i=0; i<vars.length; i++) {
			var pair = vars[i].split("=");
			if (typeof obj[pair[0]] == "undefined") {
				obj[pair[0]] = decodeURIComponent((pair[1] + '').replace(/\+/g, '%20'));
			} else if (typeof obj[pair[0]] == "string") {
				obj[pair[0]] = [obj[pair[0]], decodeURIComponent((pair[1] + '').replace(/\+/g, '%20'))];
			} else {
				obj[pair[0]].push(decodeURIComponent((pair[1] + '').replace(/\+/g, '%20')));
			}
		}
		return obj;
	}//-22.5

/*--
zim.swapHTML = function(idA, idB)

swapHTML
zim function

DESCRIPTION
Pass in two tag ids as strings and this function will swap their innerHTML content.
The content (including nested tags) will be swapped.

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
// exchanges the content of two divs called question and answer
swapHTML("question","answer");
END EXAMPLE

PARAMETERS
idA, idB - String names of the tag id with which to swap innerHTML values

RETURNS Boolean indicating success
--*///+17.2
	zim.swapHTML = function(idA, idB) {
		z_d("17.2");
		return zim.swapProperties("innerHTML", zid(idA), zid(idB));
	}//-17.2

/*--
zim.urlEncode = function(string)

urlEncode
zim function

DESCRIPTION
Matches PHP urlencode and urldecode functions
for passing data on end of URL.
NOTE: only encode values of key=value pairs (not keys and not both keys and values)
NOTE: JSON automatically encodes and decodes

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var motto = "good = life & life = now";
zgo("submit.php?motto="+urlEncode(motto));
END EXAMPLE

PARAMETERS
string - a value to URL encode (space to plus, etc.)

RETURNS a String
--*///+23
	zim.urlEncode = function(s) {
		z_d("23");
		var s = (s + '').toString();
		return encodeURIComponent(s).replace(/!/g, '%21').replace(/'/g, '%27').replace(/\(/g, '%28').
		replace(/\)/g, '%29').replace(/\*/g, '%2A').replace(/%20/g, '+');
	}//-23

/*--
zim.urlDecode = function(string)

urlDecode
zim function

DESCRIPTION
Matches PHP urlencode and urldecode functions
for receiving raw data from a source that URLencodes.
NOTE: JSON automatically encodes and decodes

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var pairs = command.split("&");
var motto = urlDecode(pairs[0].split("=")[1]);
END EXAMPLE

PARAMETERS
string - a URLencoded String to decode

RETURNS a String
--*///+24
	zim.urlDecode = function(s) {
		z_d("24");
		 return decodeURIComponent((s + '').replace(/\+/g, '%20'));
	}//-24

/*--
zim.setCookie = function(name, value, days)

setCookie
zim function

DESCRIPTION
Sets an HTML cookie to remember some user data your site has set over time.
If no days, it will be a session cookie (while browser is open).

NOTE: cookies may not work unless files are on a server

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var visits = getCookie("visits");
if (zot(visits)) visits = 0;
setCookie("visits", ++visits);
END EXAMPLE

PARAMETERS
name - a String name for your cookie
value - a String value that you want to store
days - (default 0) for how many days do you want to store the cookie

ALSO: see getCookie and deleteCookie

RETURNS a Boolean indicating success
--*///+25
	zim.setCookie = function(name, value, days) {
		z_d("25");
		if (zot(name) || zot(value)) return;
		if (days) {
			var date = new Date();
			date.setTime(date.getTime()+(days*24*60*60*1000));
			var expires = "; expires="+date.toGMTString();
		} else {
			var expires = "";
		}
		document.cookie = name+"="+escape(value)+expires+"; path=/";
		return true;
	}//-25

/*--
zim.getCookie = function(name)

getCookie
zim function

DESCRIPTION
Gets an HTML cookie that you have previously set.

NOTE: cookies may not work unless files are on a server

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var visits = getCookie("visits");
if (zot(visits)) visits = 0;
setCookie("visits", ++visits);
END EXAMPLE

PARAMETERS
name - the String name of your stored cookie

ALSO: see setCookie and deleteCookie

RETURNS a String or undefined if not found
--*///+26
	zim.getCookie = function(name) {
		z_d("26");
		var outer = document.cookie.split(/;\s*/);
		var cookies = new Array();
		var inner;
		for (i=0; i<outer.length; i++) {
			inner = outer[i].split("=");
			cookies[inner[0]] = inner[1];
		}
		if (typeof cookies[name] == 'undefined') return undefined;
		return unescape(cookies[name]);
	}//-26

/*--
zim.deleteCookie = function(name)

deleteCookie
zim function

DESCRIPTION
Deletes an HTML cookie.

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
deleteCookie("visits"); // clears the cookie
END EXAMPLE

PARAMETERS
name - the String name of your stored cookie to delete

ALSO: see setCookie and getCookie

RETURNS a Boolean indicating success
--*///+27
	zim.deleteCookie = function(name) {
		z_d("27");
		if (zot(zim.getCookie(name))) return false;
		zim.setCookie(name,"",-1);
		return true;
	}//-27


if (typeof(createjs) == "undefined") {if (zon) {zog("ZIM >= 4.3.0 requires createjs namespace to be loaded (import createjs before zim)");} return zim;}



////////////////  ZIM DISPLAY  //////////////

// Zim Display (formerly Zim Build) adds common display classes for multies (interactive media)
// classes in this module require createjs namespace to exist and in particular easel.js
// available at http://createjs.com

/*--
zim.Coordinates = function(canvasID)

Helper functions for localToGlobal, globalToLocal and localToLocal

--*///+50.43
zim.coordinatesCheck = false;
function localToGlobal(x,y,scope,func) {
	if (!zim.coordinatesCheck) {z_d("50.43"); zim.coordinatesCheck=true;}
	if (x==null || y==null) return;
	var point = func.call(scope,x,y);
	var stage = scope.stage;
	if (typeof zimDefaultFrame == "undefined") {
		if (!stage) return point;
		zimDefaultFrame = {stage:stage, canvas:stage.canvas};
	}
	if (!stage) stage = zimDefaultFrame.stage;
	// if (scope == stage) return point;
	point.x /= stage&&stage.scaleX?stage.scaleX:1;
	point.y /= stage&&stage.scaleY?stage.scaleY:1;
	return point;
}
function globalToLocal(x,y,scope,func) {
	if (!zim.coordinatesCheck) {z_d("50.43"); zim.coordinatesCheck=true;}
	if (x==null || y==null) return;
	var stage = scope.stage;
	if (typeof zimDefaultFrame == "undefined") {
		if (!stage) return func.call(scope,x,y);
		zimDefaultFrame = {stage:stage, canvas:stage.canvas};
	}
	if (!stage) stage = zimDefaultFrame.stage;
	// if (scope == stage) return func.call(scope,x,y);
	x *= stage.scaleX;
	y *= stage.scaleY;
	var point = func.call(scope,x,y);
	return point;
}
function localToLocal(x,y,target,scope) {
	if (!zim.coordinatesCheck) {z_d("50.43"); zim.coordinatesCheck=true;}
	if (x==null || y==null || target==null) return;
	var point = scope.localToGlobal(x,y);
	var stage = scope.stage;
	if (typeof zimDefaultFrame == "undefined") {
		if (!stage) return target.globalToLocal(point.x, point.y);
		zimDefaultFrame = {stage:stage, canvas:stage.canvas};
	}
	if (!stage) stage = zimDefaultFrame.stage;
	if (target == stage) return point;
	if (point) return target.globalToLocal(point.x, point.y);
}
//-50.43

/*--
zim.Stage = function(canvasID)

Stage
zim class - extends a createjs.Stage which extends a createjs.Container

DESCRIPTION
An extension of a createjs.Stage that includes read only type, width and height properties, loop and hitTestGrid methods.
When using zim.Frame, there should be no reason to make a zim.Stage.
This was put in place to match the ZIM TypeScript typings for stage width and height.
Also see https://www.createjs.com/docs/easeljs/classes/Stage.html

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var stage = new Stage("canvasID");
END EXAMPLE

PARAMETERS
canvasID - (default null) string ID for canvas tag

METHODS
loop(call, reverse, step, start, end) - see the ZIM Display Methods loop() for details
	 see the ZIM Display Methods loop() for details
hitTestGrid(width, height, cols, rows, x, y, offsetX, offsetY, spacingX, spacingY, local, type)
	see the ZIM Display Methods hitTestGrid() for details
See the CreateJS Easel Docs for Stage methods, such as:
clear, update, toDataURL
And all the Container methods such as:
on, off, setBounds, getBounds, globalToLocal, etc.

PROPERTIES
type - holds the class name as a String
width - read only width set by ZIM Frame
height - read only height set by ZIM Frame

ALSO: See the CreateJS Easel Docs for Stage properties, such as:
autoClear, canvas, nextStage, etc.
and all the Container properties, such as:
children, mouseChildren, filters, cacheCanvas, etc.

EVENTS
See the CreateJS Easel Docs for Stage events, such as:
mouseenter, mouseleave, stagemousedown, stagemousemove, stagemouseup, drawstart, drawend, etc.
and all the Container events, such as:
click, dblclick, mousedown, mouseout, mouseover, pressmove, pressup, removed, rollout, rollover
--*///+50.44
zim.Stage = function(canvasID) {
		z_d("50.44");
		if (zot(canvasID)) return;
		var tag = canvasID.tagName=="CANVAS"?canvasID:zid(canvasID);
		if (zot(tag)) return;
		this.cjsStage_constructor(canvasID);
		this.setBounds(0,0,tag.width,tag.height);
		this.type = "Stage";
		this.cache = function(a,b,c,d,scale,options) {
			if (zot(c)) {
				if (zot(a)) {
					var bounds = this.getBounds();
					if (!zot(bounds)) {
						var added = this.borderWidth > 0 ? this.borderWidth/2 : 0;
						a = bounds.x-added;
						b = bounds.y-added;
						c = bounds.width+added*2;
						d = bounds.height+added*2;
					}
				} else {
					c = a;
					d = b;
					a = 0;
					b = 0;
				}
			}
			this.cjsStage_cache(a,b,c,d,scale,options);
			return this;
		}
		this.loop = function(call, reverse, step, start, end) {
			return zim.loop(this, call, reverse, step, start, end);
		}
		this.hitTestGrid = function(width, height, cols, rows, x, y, offsetX, offsetY, spacingX, spacingY, local, type) {
			return zim.hitTestGrid(this, width, height, cols, rows, x, y, offsetX, offsetY, spacingX, spacingY, local, type);
		}
		this.localToGlobal = function(x,y) {
			return localToGlobal(x,y,this,this.cjsStage_localToGlobal);
		}
		this.globalToLocal = function(x,y) {
			return globalToLocal(x,y,this,this.cjsStage_globalToLocal);
		}
		this.localToLocal = function(x,y,target) {
			return localToLocal(x,y,target,this);
		}
	}
	zim.extend(zim.Stage, createjs.Stage, ["cache","localToLocal","localToGlobal","globalToLocal"], "cjsStage", false);

	//-50.44

/*--
zim.StageGL = function(canvasID, options)

StageGL
zim class - extends a zim.Stage which extends a createjs.Stage

DESCRIPTION
An extension of a zim.Stage for WebGL support
See ZIM Stage and https://www.createjs.com/docs/easeljs/classes/StageGL.html

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var stage = new StageGL("canvasID", {preserveBuffer:true, antialias:true});
END EXAMPLE

PARAMETERS
canvasID - (default null) string ID for canvas tag
options - (default null) an object literal with the following properties
	FROM https://www.createjs.com/docs/easeljs/classes/StageGL.html
    preserveBuffer (default false)
    	If true, the canvas is NOT auto-cleared by WebGL (the spec discourages setting this to true). This is useful if you want persistent draw effects.
	antialias (default false)
		Specifies whether or not the browser's WebGL implementation should try to perform anti-aliasing. This will also enable linear pixel sampling on power-of-two textures (smoother images).
	transparent (default false)
		If true, the canvas is transparent. This is very expensive, and should be used with caution.
	premultiply (default false)
		Alters color handling. If true, this assumes the shader must account for pre-multiplied alpha. This can help avoid visual halo effects with some assets, but may also cause problems with other assets.
	autoPurge (default 1200)
	 	How often the system should automatically dump unused textures with purgeTextures(autoPurge) every autoPurge/2 draws. See purgeTextures for more information.

METHODS
loop(call, reverse, step, start, end) - see the ZIM Display Methods loop() for details
	 see the ZIM Display Methods loop() for details
hitTestGrid(width, height, cols, rows, x, y, offsetX, offsetY, spacingX, spacingY, local, type)
	see the ZIM Display Methods hitTestGrid() for details
See the CreateJS Easel Docs for StageGL methods:
https://www.createjs.com/docs/easeljs/classes/StageGL.html

PROPERTIES
type - holds the class name as a String
width - read only width set by ZIM Frame
height - read only height set by ZIM Frame

See the CreateJS Easel Docs for Stage properties:
https://www.createjs.com/docs/easeljs/classes/StageGL.html

EVENTS
See the CreateJS Easel Docs for StageGL events, such as:
mouseenter, mouseleave, stagemousedown, stagemousemove, stagemouseup, drawstart, drawend, etc.
and all the Container events, such as:
click, dblclick, mousedown, mouseout, mouseover, pressmove, pressup, removed, rollout, rollover
--*///+50.45
zim.StageGL = function(canvasID, options) {
		z_d("50.45");
		if (zot(canvasID)) return;
		var tag = canvasID.tagName=="CANVAS"?canvasID:zid(canvasID);
		if (zot(tag)) return;
		this.cjsStageGL_constructor(canvasID, options);
		this.setBounds(0,0,tag.width,tag.height);
		this.type = "StageGL";
		this.cache = function(a,b,c,d,scale,options) {
			if (zot(c)) {
				if (zot(a)) {
					var bounds = this.getBounds();
					if (!zot(bounds)) {
						var added = this.borderWidth > 0 ? this.borderWidth/2 : 0;
						a = bounds.x-added;
						b = bounds.y-added;
						c = bounds.width+added*2;
						d = bounds.height+added*2;
					}
				} else {
					c = a;
					d = b;
					a = 0;
					b = 0;
				}
			}
			this.cjsStageGL_cache(a,b,c,d,scale,options);
			return this;
		}
		this.loop = function(call, reverse, step, start, end) {
			return zim.loop(this, call, reverse, step, start, end);
		}
		this.hitTestGrid = function(width, height, cols, rows, x, y, offsetX, offsetY, spacingX, spacingY, local, type) {
			return zim.hitTestGrid(this, width, height, cols, rows, x, y, offsetX, offsetY, spacingX, spacingY, local, type);
		}
		this.localToGlobal = function(x,y) {
			return localToGlobal(x,y,this,this.cjsStageGL_localToGlobal);
		}
		this.globalToLocal = function(x,y) {
			return globalToLocal(x,y,this,this.cjsStageGL_globalToLocal);
		}
		this.localToLocal = function(x,y,target) {
			return localToLocal(x,y,target,this);
		}
	}
	zim.extend(zim.StageGL, createjs.StageGL, ["cache","localToLocal","localToGlobal","globalToLocal"], "cjsStageGL", false);

	//-50.45

/*--
zim.Container = function(a, b, c, d, style, group, inherit)

Container
zim class - extends a createjs.Container

DESCRIPTION
A Container object is used to hold other display objects or other containers.
You can then move or scale the container and all objects inside will move or scale.
You can apply an event on a container and use the target property of the event object
to access the object in the container that caused the event
or use the currentTarget property of the event object to access the container itself.
Containers do not have bounds unless some items in the container have bounds -
at which point the bounds are the combination of the bounds of the objects with bounds.
You can manually set the bounds with setBounds(x,y,w,h) - read the CreateJS docs.
Or pass in width and height, or boundsX, boundsY, width, height to have Container set bounds
Manually set bounds will not update automatically unless you setBounds(null).

NOTE: All the ZIM shapes and components extend the Container.
This means all shapes and components inherit the methods and properties below
and indeed, the Container inherits all the createjs.Container methods and properties.
See the CreateJS documentation for x, y, alpha, rotation, on(), addChild(), etc.

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var container = new Container();
stage.addChild(container);
container.x = 100; container.y = 100;

// demonstration of adding drag() to a Container
var rect = new Rectangle(100, 100, "blue");
container.addChild(rect); // add rectangle to container
var circle = new Circle(40, "red");
circle.center(container) // add the circle to the container and center
container.drag(); // will drag either the rectangle or the circle
container.drag({currentTarget:true}); // will drag both the rectangle and the circle

// below will reduce the alpha of the object in the container that was clicked (target)
container.on("click" function(e) {e.target.alpha = .5; stage.update();})
// below will reduce the alpha of all the objects in the container (currentTarget)
container.on("click" function(e) {e.currentTarget.alpha = .5; stage.update();})
END EXAMPLE

PARAMETERS
** supports DUO - parameters or single object with properties below
** supports OCT - parameter defaults can be set with STYLE control (like CSS)
** Container supports three different sets of parameters as follows:
a - (default null) - width and height equal to parameter a (x and y will be 0)
a, b - (default null) - the width and height (x and y will be 0)
a, b, c, d - (default null) - the x, y, width and height of the bounds
	if parameter a is not set, then the Container will take bounds that grow with its content
	the bounds of the Container can be set at any time with setBounds(a, b, c, d)
	if the bounds are set, then the Container bounds will not change as content is added
	the bounds can be removed with setBounds(null) and the Container will get auto bounds
style - (default true) set to false to ignore styles set with the STYLE - will receive original parameter defaults
group - (default null) set to String (or comma delimited String) so STYLE can set default styles to the group(s) (like a CSS class)
inherit - (default null) used internally but can receive an {} of styles directly


NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var circle = new Circle();
circle.center(stage); // add circle to stage and center
circle.drag();

// alternatively, we can still use the traditional ZIM functions:
center(circle, stage);
drag(circle);

// ZIM DUO works the same way as before - eg.
circle.drag({slide:true});
END EXAMPLE

METHODS
* This class has all the DISPLAY METHODS introduced in ZIM 4TH
* the methods are available to all ZIM Display objects that extend a ZIM Container
* such as ZIM Rectangle, Circle, Triangle, BLob
* as well as all components like: Label, Button, Slider, Dial, Tab, Pane, etc.
* as well as the ZIM display wrappers: Container, Shape, Sprite, MovieClip and Bitmap
cache(width||x, height||y, null||width, null||height, scale, options) - overrides CreateJS cache() and returns object for chaining
	If you do not provide the first four parameters, then the cache dimensions will be set to the bounds of the object
	width||x - (default getBounds().x) the width of the chache - or the x if first four parameters are provided
	height||y - (default getBounds().y) the height of the chache - or the y if first four parameters are provided
	width - (default getBounds().width) the width of the chache - or null if first two parameters are provided
	height - (default getBounds().height) the height of the chache - or null if first two parameters are provided
	scale - (default 1) set to 2 to cache with twice the fidelity if later scaling up
	options - (default null) additional parameters for cache logic - see CreateJS somewhere for details
setBounds(width||x, height||y, null||width, null||height) - overrides CreateJS setBounds() and returns object for chaining
	If you do not provide the any parameters, then the bounds will be reset to the calculated bounds
	width||x - (default null) the width of the bounds - or the x if four parameters are provided
	height||y - (default width) the height of the bounds - or the y if four parameters are provided
	width - (default null) the width of the bounds - or null if only the first two parameters are provided
	height - (default null) the height of the bounds - or null if only the first two parameters are provided
hasProp(property as String) - returns true if property exists on object else returns false
clone() - clones the container, its properties and all its children
dispose() - removes from parent, removes event listeners - must still set outside references to null for garbage collection

ALSO: See the CreateJS Easel Docs for Container methods, such as:
on(), off(), getBounds(), setBounds(), uncache(), updateCache(), dispatchEvent(),
addChild(), removeChild(), addChildAt(), getChildAt(), contains(), removeAllChildren(), etc.

PROPERTIES
type - holds the class name as a String
** bounds must be set first (or width and height parameters set) for these to work
** setting these adjusts scale not bounds and getting these uses the bounds dimension times the scale
width - gets or sets the width. Setting the width will scale the height to keep proportion (see widthOnly below)
height - gets or sets the height. Setting the height will scale the width to keep proportion (see heightOnly below)
widthOnly - gets or sets the width.  This sets only the width and may change the aspect ratio of the object
heightOnly - gets or sets the height.  This sets only the height and may change the aspect ratio of the object
depth - for ZIM VR - the depth used to shift left and right channel and for parallax in VR - also see dep() ZIM Display method
blendMode - how the object blends with what is underneath - such as "difference", "multiply", etc. same as CreateJS compositeOperation
group - used when the object is made to add STYLE with the group selector (like a CSS class)

ALSO: See the CreateJS Easel Docs for Container properties, such as:
x, y, rotation, scale, scaleX, scaleY, regX, regY, skewX, skewY,
alpha, cursor, shadow, mouseChildren, mouseEnabled, parent, numChildren, etc.

EVENTS
See the CreateJS Easel Docs for Container events, such as:
added, click, dblclick, mousedown, mouseout, mouseover, pressmove, pressup, removed, rollout, rollover
--*///+50.5

	zim.containerCheck = false;
	zim.Container = function(a, b, c, d, style, group, inherit) {
		var sig = "a, b, c, d, style, group, inherit";
		var duo; if (duo = zob(zim.Container, arguments, sig, this)) return duo;
		if (!zim.containerCheck) {z_d("50.5"); zim.containerCheck=true;}
		this.cjsContainer_constructor();
		this.type = "Container";
		this.group = group;
		var that = this;
		var DS = style===false?{}:zim.getStyle(this.type, this.group, inherit);

		if (zot(a)) a = DS.a!=null?DS.a:null;
		if (zot(b)) b = DS.b!=null?DS.b:null;
		if (zot(c)) c = DS.c!=null?DS.c:null;
		if (zot(d)) d = DS.d!=null?DS.d:null;

		var n = normalizeBounds(a, b, c, d);
		function normalizeBounds(a, b, c, d) {
			var bounds = [];
			if (zot(a)) {
				bounds = [a,b,c,d];
			} else if (!zot(c)) {
				bounds[0] = a;
				bounds[2] = c;
				bounds[1] = b;
				bounds[3] = d;
			} else {
				bounds[0] = 0;
				bounds[2] = a;
				bounds[1] = 0;
				bounds[3] = b;
			}
			if (zot(bounds[3])) bounds[3] = bounds[2];
			return bounds;
		}
		if (!zot(a)) this.setBounds(n[0],n[1],n[2],n[3]); // es6 to fix

		this.cache = function(a,b,c,d,scale,options) {
			var bounds = this.getBounds();
			if (zot(c)) {
				if (zot(a)) {
					if (!zot(bounds)) {
						var added = this.borderWidth > 0 ? this.borderWidth/2 : 0;
						a = bounds.x-added;
						b = bounds.y-added;
						c = bounds.width+added*2;
						d = bounds.height+added*2;
					}
				} else {
					c = a;
					d = b;
					a = 0;
					b = 0;
				}
			}
			if (this.type == "Triangle") {
				a-=this.borderWidth?this.borderWidth:0;
				c+=this.borderWidth?this.borderWidth*2:0;
				b-=this.borderWidth?this.borderWidth:0;
				d+=this.borderWidth?this.borderWidth*2:0;
			}
			this.cjsContainer_cache(a,b,c,d,scale,options);
			if (bounds) this.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
			return this;
		}
		this.localToGlobal = function(x,y) {
			return localToGlobal(x,y,this,this.cjsContainer_localToGlobal);
		}
		this.globalToLocal = function(x,y) {
			return globalToLocal(x,y,this,this.cjsContainer_globalToLocal);
		}
		this.localToLocal = function(x,y,target) {
			return localToLocal(x,y,target,this);
		}
		this.setBounds = function(a,b,c,d) {
			var n = normalizeBounds(a, b, c, d);
			this.cjsContainer_setBounds(n[0],n[1],n[2],n[3]);
			return this;
		}
		if (style!==false) zimStyleTransforms(this, DS); // global function - would have put on DisplayObject if had access to it
		this.clone = function() {
			var currentBounds = this.getBounds();
			if (zot(currentBounds)) currentBounds = {x:null, y:null, width:null, height:null};
			return this.cloneChildren(this.cloneProps(new zim.Container(currentBounds.x,currentBounds.y,currentBounds.width,currentBounds.height, style, this.group, inherit)));
		}
		this.hasProp = function(prop) {
			return (!zot(this[prop]) || this.hasOwnProperty(prop))
		}
	}
	zim.Container.prototype.dispose = function() {
		recursiveDispose(this);
		return true;
	}
	function recursiveDispose(obj) {
		obj.removeAllEventListeners();
		if (obj.numChildren) {
			for (var i=obj.numChildren-1; i>=0; i--) {
				recursiveDispose(obj.getChildAt(i));
			}
		}
		if (obj.parent) obj.parent.removeChild(obj);
	}
	zimify(zim.Container.prototype);
	zim.extend(zim.Container, createjs.Container, ["cache","setBounds","clone","localToLocal","localToGlobal","globalToLocal"], "cjsContainer", false);
	//-50.5

/*--
zim.Shape = function(a, b, c, d, graphics, style, group, inherit)

Shape
zim class - extends a createjs.Shape

DESCRIPTION
ZIM Shape lets you draw dynamic shapes beyond the ZIM provided shapes.
You make a new shape object and then draw in its graphics property
using similar commands to the HTML Canvas commands (and Flash Bitmap drawing).
See the CreateJS Easel Shapes and Graphics docs:
http://www.createjs.com/docs/easeljs/classes/Graphics.html

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var shape = new Shape().addTo();
shape.graphics.beginFill(red).drawRect(0,0,200,100);
// similar to Rectangle(200, 100, "Red");

// we can draw lines, etc.
var g = shape.graphics; // shorter reference to graphics object
g.beginStroke(blue).moveTo(200,200).lineTo(300,300);

// we can continue to draw as much as we want in the same shape
// there is also a tiny API with shortcuts: stroke, fill, etc.
g.s(purple).ss(5).f(blue).mt(400,400).qt(500,300,600,400);
END EXAMPLE

PARAMETERS
** supports DUO - parameters or single object with properties below
** supports OCT - parameter defaults can be set with STYLE control (like CSS)
** Shape supports three different sets of parameters as follows:
a - (default null) - width and height equal to parameter a (x and y will be 0)
a, b - (default null) - the width and height (x and y will be 0)
a, b, c, d - (default null) - the x, y, width and height of the bounds
graphics - (default null) a CreateJS Graphics instance (see CreateJS docs)
	or just use the graphics property of the shape object (like usual)
style - (default true) set to false to ignore styles set with the STYLE - will receive original parameter defaults
group - (default null) set to String (or comma delimited String) so STYLE can set default styles to the group(s) (like a CSS class)
inherit - (default null) used internally but can receive an {} of styles directly

METHODS
cache(width||x, height||y, null||width, null||height, scale, options) - overrides CreateJS cache() and returns object for chaining
	If you do not provide the first four parameters, then the cache dimensions will be set to the bounds of the object
	width||x - (default getBounds().x) the width of the chache - or the x if first four parameters are provided
	height||y - (default getBounds().y) the height of the chache - or the y if first four parameters are provided
	width - (default getBounds().width) the width of the chache - or null if first two parameters are provided
	height - (default getBounds().height) the height of the chache - or null if first two parameters are provided
	scale - (default 1) set to 2 to cache with twice the fidelity if later scaling up
	options - (default null) additional parameters for cache logic - see CreateJS somewhere for details
setBounds(width||x, height||y, null||width, null||height) - overrides CreateJS setBounds() and returns object for chaining
	width||x - (default null) the width of the bounds - or the x if four parameters are provided
	height||y - (default width) the height of the bounds - or the y if four parameters are provided
	width - (default null) the width of the bounds - or null if only the first two parameters are provided
	height - (default null) the height of the bounds - or null if only the first two parameters are provided
hasProp(property) - returns true if String property exists on object else returns false
clone(recursive) - makes a copy of the shape
	recursive defaults to true so copy will have own copy of graphics
	set recursive to false to have clone share graphic property
dispose() - removes from parent, removes event listeners - must still set outside references to null for garbage collection

ALSO: ZIM 4TH adds all the methods listed under Container (see above), such as:
drag(), hitTestRect(), animate(), sca(), reg(), mov(), center(), centerReg(),
addTo(), removeFrom(), loop(), outline(), place(), placeReg(), pos(), alp(), rot(), setMask(), etc.
ALSO: See the CreateJS Easel Docs for Container methods, such as:
on(), off(), getBounds(), setBounds(), uncache(), updateCache(), dispatchEvent(),
addChild(), removeChild(), addChildAt(), getChildAt(), contains(), removeAllChildren(), etc.

PROPERTIES
type - holds the class name as a String
** bounds must be set first (or width and height parameters set) for these to work
** setting these adjusts scale not bounds and getting these uses the bounds dimension times the scale
width - gets or sets the width. Setting the width will scale the height to keep proportion (see widthOnly below)
height - gets or sets the height. Setting the height will scale the width to keep proportion (see heightOnly below)
widthOnly - gets or sets the width.  This sets only the width and may change the aspect ratio of the object
heightOnly - gets or sets the height.  This sets only the height and may change the aspect ratio of the object
depth - for ZIM VR - the depth used to shift left and right channel and for parallax in VR - also see dep() ZIM Display method
blendMode - how the object blends with what is underneath - such as "difference", "multiply", etc. same as CreateJS compositeOperation
group - used when the object is made to add STYLE with the group selector (like a CSS class)

ALSO: See the CreateJS Easel Docs for Shape properties, such as:
graphics, x, y, rotation, scaleX, scaleY, regX, regY, skewX, skewY,
alpha, cursor, shadow, mouseEnabled, etc.

EVENTS
See the CreateJS Easel Docs for Shape events, such as:
added, click, dblclick, mousedown, mouseout, mouseover, pressmove, pressup, removed, rollout, rollover
--*///+50.6
	zim.Shape = function(a, b, c, d, graphics, style, group, inherit) {
		var sig = "a, b, c, d, graphics, style, group, inherit";
		var duo; if (duo = zob(zim.Shape, arguments, sig, this)) return duo;
		z_d("50.6");
		this.cjsShape_constructor(graphics);
		this.type = "Shape";
		this.group = group;
		var DS = style===false?{}:zim.getStyle(this.type, this.group, inherit);
		var that = this;

		if (zot(a)) a = DS.a!=null?DS.a:null;
		if (zot(b)) b = DS.b!=null?DS.b:null;
		if (zot(c)) c = DS.c!=null?DS.c:null;
		if (zot(d)) d = DS.d!=null?DS.d:null;

		var n = normalizeBounds(a, b, c, d);
		function normalizeBounds(a, b, c, d) {
			var bounds = [];
			if (!zot(c)) {
				bounds[0] = a;
				bounds[2] = c;
				bounds[1] = b;
				bounds[3] = d;
			} else {
				bounds[0] = 0;
				bounds[2] = a;
				bounds[1] = 0;
				bounds[3] = b;
			}
			if (zot(bounds[3])) bounds[3] = bounds[2];
			return bounds;
		}
		if (!zot(a)) this.setBounds(n[0],n[1],n[2],n[3]); // es6 to fix

		this.cache = function(a,b,c,d,scale,options) {
			if (zot(c)) {
				if (zot(a)) {
					var bounds = this.getBounds();
					if (!zot(bounds)) {
						var added = this.borderWidth > 0 ? this.borderWidth/2 : 0;
						a = bounds.x-added;
						b = bounds.y-added;
						c = bounds.width+added*2;
						d = bounds.height+added*2;
					}
				} else {
					c = a;
					d = b;
					a = 0;
					b = 0;
				}
			}
			this.cjsShape_cache(a,b,c,d,scale,options);
			return this;
		}
		this.setBounds = function(a,b,c,d) {
			var n = normalizeBounds(a, b, c, d);
			this.cjsShape_setBounds(n[0],n[1],n[2],n[3]);
			return this;
		}
		if (style!==false) zimStyleTransforms(this, DS); // global function - would have put on DisplayObject if had access to it
		this.clone = function(recursive) {
			if (zot(recursive)) recursive = true;
			var currentBounds = this.getBounds();
			if (zot(currentBounds)) currentBounds = {x:null, y:null, width:null, height:null};
			var c = that.cloneProps(new zim.Shape(currentBounds.x,currentBounds.y,currentBounds.width,currentBounds.height, graphics, style, group, inherit));
			if (recursive) c.graphics = that.graphics.clone();
			else c.graphics = that.graphics;
			return c;
		}
		this.localToGlobal = function(x,y) {
			return localToGlobal(x,y,this,this.cjsShape_localToGlobal);
		}
		this.globalToLocal = function(x,y) {
			return globalToLocal(x,y,this,this.cjsShape_globalToLocal);
		}
		this.localToLocal = function(x,y,target) {
			return localToLocal(x,y,target,this);
		}
		this.hasProp = function(prop) {
			return (!zot(this[prop]) || this.hasOwnProperty(prop))
		}
		this.dispose = function() {
			this.graphics.c();
			this.removeAllEventListeners();
			if (this.parent) this.parent.removeChild(this);
		}
	}
	zim.extend(zim.Shape, createjs.Shape, ["cache","clone","setBounds","localToLocal","localToGlobal","globalToLocal"], "cjsShape", false);
	zimify(zim.Shape.prototype);
	//-50.6



/*--
zim.Bitmap = function(image, width, height, id, style, group, inherit)

Bitmap
zim class - extends a createjs.Bitmap

DESCRIPTION
Makes a Bitmap object from an image.
It is best to use the assets and path parameters of ZIM Frame or the loadAssets() method of Frame
to preload the image and then use the asset() method to access the Bitmap.
See the ZIM Frame class and asset example on the ZIM Frame page of templates.

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var frame = new Frame();
frame.on("ready", function() {
	var stage = frame.stage;
	frame.loadAssets("logo.jpg");
	frame.on("complete", function() {
		var logo = frame.asset("logo.jpg"); // logo is a Bitmap
		logo.center();
		stage.update();
	});
});
END EXAMPLE

EXAMPLE
// fill a Bitmap with noise:
var noise = new Noise();
// empty Bitmap size 200, 200
var bmp = new Bitmap(null,200,200).center(stage);
// we fill the bitmap starting from top left going across in the inner loop,
// then down, then across, etc. until we get to bottom right.
var f = 50; // used to make noise bigger or smaller - see the blob comment below
for (var y = 0; y < bmp.height; y++) {
	for (var x = 0; x < bmp.width; x++) {
		// the noise methods return a number from -1 to 1
		// by adding 1 we get a number between 0 and 2 then divide by 2
		// and we multiply this by 255 to get a number between 0 and 255
		value = (noise.simplex2D(x, y)+1)/2 * 255;
		// or get blobs by smoothing and adjusting frequency:
		// var value = smoothStep((noise.simplex2D(x/f, y/f)+1)/2, .3,.35) * 255;
		// imageData is four values per pixel
		// the red, green, blue and alpha
		// in one big long array - each value will be constrained to between 0 and 255
		// this i value will increase by 4 each time
		// then we write the same value for red, green, blue to get a shade of grey
		var i = (x + y * bmp.width) * 4;
		bmp.imageData.data[i] = value; // red (0-255)
		bmp.imageData.data[i + 1] = value; // green (0-255)
		bmp.imageData.data[i + 2] = value; // blue (0-255)
		bmp.imageData.data[i + 3] = 255; // alpha (0-255)
	}
}
bmp.drawImageData();
END EXAMPLE

EXAMPLE
// applying filters
var bitmap = frame.asset("statue.jpg");
bitmap.filters = [new createjs.BlurFilter(25, 25, 1)];
bitmap.cache().center();
END EXAMPLE

EXAMPLE
// getting the color at point(100, 100) on the Bitmap
var bitmap = frame.asset("statue.jpg").cache();
var ctx = bitmap.cacheCanvas.getContext('2d');
var data = ctx.getImageData(100, 100, 1, 1).data;
var color = "rgba("+data.join(", ")+")";
END EXAMPLE

EXAMPLE
// a Base64 image:
var image = "data:image/png;base64,longlistofcharacters";
var logo;
Bitmap.fromData(image, function (bitmap) {
	logo = bitmap.center();
	stage.update();
});
END EXAMPLE

PARAMETERS
** supports DUO - parameters or single object with properties below
** supports OCT - parameter defaults can be set with STYLE control (like CSS)
image - an HTML image URL (may not load right away - see Frame loadAssets)
width - (default 100) used with putImageData to draw a Bitmap otherwise ignored
height - (default 100) used with putImageData to draw a Bitmap otherwise ignored
id - an optional id
style - (default true) set to false to ignore styles set with the STYLE - will receive original parameter defaults
group - (default null) set to String (or comma delimited String) so STYLE can set default styles to the group(s) (like a CSS class)
inherit - (default null) used internally but can receive an {} of styles directly

METHODS
fromData(data, callback) - STATIC method so use the Bitmap class directly: Bitmap.fromData()
	The callback will receive a reference to the Bitmap after 50ms or 100ms.
	There is no event for making a Bitmap from base64 for instance - so this will have to do.
drawImageData(x, y, sourceX, srcY, srcWidth, srcHeight) - draws the Bitmap's imageData data to the Bitmap
	NOTE: This is only used when dynamically drawing a Bitmap with data - not for your normal picture
	See the imageData property which should be set before using the drawImageData() method
	ZIM calls a putImageData method for the HTML Canvas and then transfers this to the Bitmap
	See also https://www.w3schools.com/tags/canvas_putimagedata.asp - but let ZIM do the work...
cache(width||x, height||y, null||width, null||height, scale, options) - overrides CreateJS cache() and returns object for chaining
	** Usually you do not want to cache a Bitmap as it is already a Bitmap ;-)
	** But for applying a filter or using a cacheCanvas to get a context, etc. then you might.
	If you do not provide the first four parameters, then the cache dimensions will be set to the bounds of the object
	width||x - (default getBounds().x) the width of the chache - or the x if first four parameters are provided
	height||y - (default getBounds().y) the height of the chache - or the y if first four parameters are provided
	width - (default getBounds().width) the width of the chache - or null if first two parameters are provided
	height - (default getBounds().height) the height of the chache - or null if first two parameters are provided
	scale - (default 1) set to 2 to cache with twice the fidelity if later scaling up
	options - (default null) additional parameters for cache logic - see CreateJS somewhere for details
hasProp(property as String) - returns true if property exists on object else returns false
clone() - makes a copy with properties such as x, y, etc. also copied
dispose() - removes from parent, removes event listeners - must still set outside references to null for garbage collection

ALSO: ZIM 4TH adds all the methods listed under Container (see above), such as:
drag(), hitTestRect(), animate(), sca(), reg(), mov(), center(), centerReg(),
addTo(), removeFrom(), loop(), outline(), place(), pos(), alp(), rot(), setMask(), etc.
ALSO: See the CreateJS Easel Docs for Bitmap methods, such as:
on(), off(), getBounds(), setBounds(), dispatchEvent(), etc.

PROPERTIES
type - holds the class name as a String
imageData - data for the pixels stored in a data property of an ImageData object
	NOTE: This is only used when dynamically drawing a Bitmap with data - not for your normal picture
	The data property is an one dimensional Array with consecutive red, green, blue, alpha values (0-255) for each pixels
	eg. 0,0,0,255,255,255,255,255 is a white pixel with 1 alpha and a black pixel with 1 alpha
	You set this before calling the Bitmap drawImageData() method
 	See also https://developer.mozilla.org/en-US/docs/Web/API/ImageData - but let ZIM do the work
** setting widths and heights adjusts scale not bounds and getting these uses the bounds dimension times the scale
width - gets or sets the width. Setting the width will scale the height to keep proportion (see widthOnly below)
height - gets or sets the height. Setting the height will scale the width to keep proportion (see heightOnly below)
widthOnly - gets or sets the width.  This sets only the width and may change the aspect ratio of the object
heightOnly - gets or sets the height.  This sets only the height and may change the aspect ratio of the object
depth - for ZIM VR - the depth used to shift left and right channel and for parallax in VR - also see dep() ZIM Display method
id (fileID in TypeScript) - the filename used in the frame.loadAssets()
	if you add the path the file name then it will be included with the id
	if you add the path with the path parameter, it will not be included with the id
blendMode - how the object blends with what is underneath - such as "difference", "multiply", etc. same as CreateJS compositeOperation
group - used when the object is made to add STYLE with the group selector (like a CSS class)

ALSO: See the CreateJS Easel Docs for Bitmap properties, such as:
x, y, rotation, scaleX, scaleY, regX, regY, skewX, skewY,
alpha, cursor, shadow, mouseEnabled, etc.

EVENTS
See the CreateJS Easel Docs for Bitmap events, such as:
added, click, dblclick, mousedown, mouseout, mouseover, pressmove, pressup, removed, rollout, rollover
--*///+50.7
	zim.Bitmap = function(image, width, height, id, style, group, inherit) {
		var sig = "image, width, height, id, style, group, inherit";
		var duo; if (duo = zob(zim.Bitmap, arguments, sig, this)) return duo;
		z_d("50.7");
		this.cjsBitmap_constructor(image);
		var that = this;
		this.type = "Bitmap";
		this.group = group;
	    var DS = style===false?{}:zim.getStyle(this.type, this.group, inherit);

		this.id = that.fileID = DS.id!=null?DS.id:id;
		if (zot(width)) width = DS.width!=null?DS.width:null;
		if (zot(height)) height = DS.height!=null?DS.height:null;
		if (!zot(width) && !zot(height)) that.setBounds(0,0,width,height);
		if (zot(width)) width = 100;
		if (zot(height)) height = 100;
		if (zimDefaultFrame) {
			// not supported by IE - thanks Chris Spolton for the find and suggested fix
			if (zimDefaultFrame.canvas.getContext("2d")) {
				this.imageData = zimDefaultFrame.canvas.getContext("2d").createImageData(width, height);
			} else {
				this.imageData = document.createElement('canvas').getContext("2d").createImageData(width, height);
				// if (ImageData) this.imageData = new ImageData(width, height);
			}
			this.drawImageData = function(x, y, sourceX, sourceY, sourceWidth, sorceHeight) {
				if (zot(x)) x = 0;
				if (zot(y)) y = 0;
				if (zot(sourceX)) sourceX = 0;
				if (zot(sourceY)) sourceY = 0;
				if (zot(sourceWidth)) sourceWidth = width;
				if (zot(sorceHeight)) sorceHeight = height;
				if (!that.proxyCanvas) {
					var c = that.proxyCanvas = document.createElement("canvas");
					c.setAttribute("width", width);
					c.setAttribute("height", height);
					that.proxyContext = c.getContext('2d');
					image = that.image = c;
				}
				if (that.proxyContext) {
					that.proxyContext.putImageData(that.imageData, x, y, sourceX, sourceY, sourceWidth, sorceHeight);
				}
			}
			if (zot(image)) that.drawImageData();

			// handle delay when creating Bitmap from data
			if (image.match && image.match(/data:image/i)) setTimeout(function() {
				if (that.stage) that.stage.update();
				setTimeout(function() {
					if (that.stage) that.stage.update();
				}, 50);
			}, 50);
		}

		this.cache = function(a,b,c,d,scale,options) {
			if (zot(c)) {
				if (zot(a)) {
					var bounds = this.getBounds();
					if (!zot(bounds)) {
						var added = this.borderWidth > 0 ? this.borderWidth/2 : 0;
						a = bounds.x-added;
						b = bounds.y-added;
						c = bounds.width+added*2;
						d = bounds.height+added*2;
					}
				} else {
					c = a;
					d = b;
					a = 0;
					b = 0;
				}
			}
			var bounds = this.getBounds();
			this.cjsBitmap_cache(a,b,c,d,scale,options);
			this.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
			return this;
		}

		if (style!==false) zimStyleTransforms(this, DS); // global function - would have put on DisplayObject if had access to it
		this.clone = function() {
			return this.cloneProps(new zim.Bitmap(image, null, null, that.fileID, style, this.group, inherit));
		}
		this.localToGlobal = function(x,y) {
			return localToGlobal(x,y,this,this.cjsBitmap_localToGlobal);
		}
		this.globalToLocal = function(x,y) {
			return globalToLocal(x,y,this,this.cjsBitmap_globalToLocal);
		}
		this.localToLocal = function(x,y,target) {
			return localToLocal(x,y,target,this);
		}
		this.hasProp = function(prop) {
			return (!zot(this[prop]) || this.hasOwnProperty(prop))
		}
		this.dispose = function() {
			this.removeAllEventListeners();
			if (this.parent) this.parent.removeChild(this);
		}
	}
	zim.Bitmap.fromData = function(data, callBack) {
		var bitmap = new zim.Bitmap(data);
		setTimeout(function() {
			callBack(bitmap);
		}, 50);
	}
	zim.extend(zim.Bitmap, createjs.Bitmap, ["cache","clone","localToLocal","localToGlobal","globalToLocal"], "cjsBitmap", false);
	zimify(zim.Bitmap.prototype);
	//-50.7

/*--
zim.Sprite = function(image, cols, rows, count, offsetX, offsetY, spacingX, spacingY, width, height, animations, json, id, globalControl, spriteSheet, label, style, group, inherit)

Sprite
zim class - extends a createjs.Sprite

DESCRIPTION
A Sprite plays an animation of a spritesheet
which is a set of images layed out in one file.
You play the Sprite with the run() method.
This animates the Sprite over a given time
with various features like playing a labelled animation,
playing animation series,
SEE: https://zimjs.com/spritesheet/index.html
AND: https://zimjs.com/spritesheet/skateboard.html
wait, loop, rewind and call functions.
This actually runs a ZIM animation and animates the frames.

NOTE: A ZIM Sprite handles both an evenly tiled spritesheet - use cols and rows
and an un-evenly tiled spritesheet - use the json parameter.
The json can come from TexturePacker for instance exported for EaselJS/CreateJS
CreateJS Easel Sprite and SpriteSheet docs:
http://www.createjs.com/docs/easeljs/classes/Sprite.html
http://www.createjs.com/docs/easeljs/classes/SpriteSheet.html
You can optionally pass in an existing createjs.SpriteSheet as a parameter.
When you do so, all other parameters are ignored.

NOTE: You can use CreateJS gotoAndPlay(), play(), etc.
but we found the framerate could not be kept
with other animations or Ticker events running.
So we recommend using the ZIM Sprite run() method.

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
// inside Frame template
// boom.png is a sprite sheet found online
// It has 8 columns and 6 rows that we can visually count
// We can enter a total parameter if it does not end evenly in the grid
// A graphics editor (like Photoshop) could be used to see
// if there is an offset or spacing, etc. and enter those as parameters
// In this case, we do not need to do any of this - just enter the cols and rows

frame.on("complete", function() {
	var spriteImage = frame.asset("boom.png");

	var animation = new Sprite({
		image:spriteImage,
		cols:8,
		rows:6,
		animations:{mid:[10,20], end:[30,40]} // optional animations with labels
		// see CreateJS SpriteSheet docs for the various animation format as there are a few different ones!
	});
	animation.center(stage);
	animation.run(2000); // plays the frames of the Sprite over 2 seconds (master time)

	// OR use the label to play the frames listed in animations parameter
	animation.run(1000, "mid");

	// OR run a series of animations
	// by passing an array of label objects to the label parameter
	// these each have a time so the master time is ignored
	// they can also have any of the run() parameters
	// if you provide an array of labels, you cannot rewind the overall animation
	animation.run(null, [
		{label:"mid", time:1000},
		{label:"end", time:500, loop:true, loopCount:5, call:function(){zog("loops done");}},
		{startFrame:10, endFrame:20, time:1000}
	]);

	// OR can call a function when done
	animation.run(1000, "mid", function(){
		stage.removeChild(animation);
		stage.update();
	});

	// OR can loop the animation
	animation.run({time:2000, loop:true}); // see run() parameters for more
});
END EXAMPLE

EXAMPLE
// using Sprite as a texture atlas - or spritesheet of different images
// see: https://zimjs.com/explore/fruit.html
// load in assets and path
var frame = new Frame({assets:["fruit.png", "fruit.json"], path:"assets/"});
frame.on("ready", function() {
	new Sprite({json:frame.asset("fruit.json"), label:"apple"}).center();
	frame.stage.update();
});
END EXAMPLE

EXAMPLE
// Here is an example with CreateJS SpriteSheet data
// robot.png is a sprite sheet made by ZOE based on a Flash swf
// you can also make your own with Photoshop or Texture Packer

frame.loadAssets("robot.png");
frame.on("complete", function() {

	// using ZOE to export swf animation to spritesheet data
	// spritesheet data uses the image name, not the Bitmap itself
	var image = frame.asset("robot.png").image;
	var spriteData = {
		"framerate":24,
		"images":[image],
		"frames":[[0, 0, 256, 256, 0, -54, -10], many more - etc.],
		"animations":{}
	};
	var animation = new Sprite({json:spriteData});
	animation.center(stage);
	animation.run(2000); // note, duration alternative to framerate
});

OR
// load in data from external JSON
frame.loadAssets(["robot.json", "robot.png"]);
// ... same as before
var animation = new Sprite({json:frame.asset("robot.json")});
// ... same as before

// see CreateJS SpriteSheet docs for the format of the JSON file
// including various animation formats
END EXAMPLE

PARAMETERS
** supports DUO - parameters or single object with properties below
** supports OCT - parameter defaults can be set with STYLE control (like CSS)
image - the ZIM Bitmap for the spritesheet
cols - (default 1) - the columns in the spritesheet
rows - (default 1) the rows in the spritesheet
count - (default cols*rows) how many total frames in the spritesheet
offsetX - (default 0) the pixels from the left edge to the frames
offsetY - (default 0) the pixels from the top edge to the frames
spacingX - (default 0) the horizontal spacing between the frames
spacingY - (default 0) the vertical spacing between the frames
width - (default image width) the width including offset and spacing for frames
height - (default image height) the height including offset and spacing for frames
animations - (default null) an object literal of labels holding frames to play
	{label:3, another:[4,10]}
	run(1000, "label") would play frame 3 for a second
	run(1000, "another") would play frames 4 to 10 for a second
	{unordered:{frames:[1,2,3,22,23,24,"anotherLabel",5,6], next:prevLabel}}
	There are also ways to set speeds - but would recommend dividing into simple labels
	and using the label series technique available with the run() method
json - (default null) a JSON string for a CreateJS SpriteSheet
	If you pass in a json parameter, all other parameters are ignored
	NOTE: remember that JSON needs quotes around the animation properties above:
	{"label":3, "another":[4,10]}
id - (default randomly assigned) an id you can use in other animations - available as sprite.id
	use this id in other animations for pauseRun and stopRun to act on these as well
globalControl - (default true) pauseRun and stopRun will control other animations with same id
spriteSheet - (default null) pass in a CreateJS SpriteSheet to build a Sprite from that
label - (default null) pass in a label to stop on initially - to play from a label use the run({label:val}) method
style - (default true) set to false to ignore styles set with the STYLE - will receive original parameter defaults
group - (default null) set to String (or comma delimited String) so STYLE can set default styles to the group(s) (like a CSS class)
inherit - (default null) used internally but can receive an {} of styles directly

METHODS
run(time, label, call, params, wait, waitedCall, waitedParams, loop, loopCount, loopWait, loopCall, loopParams, loopWaitCall, loopWaitParams, rewind, rewindWait, rewindCall, rewindParams, rewindWaitCall, rewindWaitParams, startFrame, endFrame, tweek, id, globalControl)
	The run() method animates the Sprite over an amount of time
	Would recommend this method over the CreateJS play() and gotoAndPlay()
	methods because the framerate for these get overwritten by other stage.update() calls
	With run() you get other nice ZIM animate features as well as follows:
	Returns the object for chaining
	Can be paused with pauseAnimate(true) or unpaused with pauseAnimate(false)
	Can be stopped with stopAnimate() on the Sprite
	supports DUO - parameters or single object with properties below
	time (default 1000) - the time in milliseconds to run the animations (the master time)
	label (default null) - a label specified in the Sprite animations parameter
		if this is an array holding label objects for example:
		[{label:"run", time:1000}, {label:"stand", time:2000}]
		then the sprite will play the series with the times given and ignore the master time
		Note: if any of the series has a loop and loops forever (a loopCount of 0 or no loopCount)
		then this will be the last of the series to run
		rewind is not available on the outside series but is available on an inside series
	call - (default null) the function to call when the animation is done
	params - (default target) a single parameter for the call function (eg. use object literal or array)
	wait - (default 0) milliseconds to wait before doing animation
	waitedCall - (default null) call the function after a wait time if there is one
	waitedParams - (default null) parameters to pass to the waitedCall function
	loop - (default false) set to true to loop animation
	loopCount - (default 0) if loop is true how many times it will loop (0 is forever)
	loopWait - (default 0) milliseconds to wait before looping (post animation wait)
	loopCall - (default null) calls function after loop and loopWait (not including last loop)
	loopParams - (default target) parameters to send loopCall function
	loopWaitCall - (default null) calls function after at the start of loopWait
	loopWaitParams - (default target) parameters to send loopWaitCall function
	rewind - (default false) set to true to rewind (reverse) animation (doubles animation time) (not available on label series)
	rewindWait (default 0) milliseconds to wait in the middle of the rewind
	rewindCall (default null) calls function at middle of rewind after rewindWait
	rewindParams - (default target) parameters to send rewindCall function
	rewindWaitCall (default null) calls function at middle of rewind before rewindWait
	rewindWaitParams - (default target) parameters to send rewindCall function
	startFrame - (default null - or 0) the frame to start on - will be overridden by a label with frames
	endFrame - (default null - or totalFrames) the frame to end on - will be overridden by a label with frames
	tweek - (default 1) a factor for extra time on rewind and loops if needed
	id - (default randomly assigned) an id you can use in other animations - available as sprite.id
		use this id in other animations for pauseRun and stopRun to act on these as well
	globalControl - (default true) pauseRun and stopRun will control other animations with same id
pauseRun(state) - pause or unpause the animation (including an animation series)
	state - (default true) when true the animation is paused - set to false to unpause
	returns object for chaining
stopRun() - stop the sprite from animating
hasProp(property as String) - returns true if property exists on object else returns false
clone() - makes a copy with properties such as x, y, etc. also copied
dispose() - removes from parent, removes event listeners - must still set outside references to null for garbage collection

ALSO: ZIM 4TH adds all the methods listed under Container (see above), such as:
drag(), hitTestRect(), animate(), sca(), reg(), mov(), center(), centerReg(),
addTo(), removeFrom(), loop(), outline(), place(), pos(), alp(), rot(), setMask(), etc.
ALSO: See the CreateJS Easel Docs for Sprite methods, such as:
play(), gotoAndPlay(), gotoAndStop(), stop(), advance(),
on(), off(), getBounds(), setBounds(), dispatchEvent(), etc.

PROPERTIES
id - an id that you can use in other animations to also be controlled by pauseRun() and stopRun()
frame - get and set the current frame of the Sprite
normalizedFrame - if animations have CreateJS speeds applied, zim handles these by making extra frames
	for example, if a speed is given of .5 then two frames are made (min resulution is .1)
normalizedFrames - an array of total frames after being normalized - really for internal usage
totalFrames - get the total frames of the Sprite - read only
animations - the animations data with labels of frames to animate
running - is the sprite animation being run (includes both paused and unpaused) - read only
runPaused - is the sprite animation paused (also returns paused if not running) - read only
	note: this only syncs to pauseRun() and stopRun() not pauseAnimate() and stopAnimate()
	note: CreateJS has paused, etc. but use that only if running the CreateJS methods
	such as gotoAndPlay(), gotoAndStop(), play(), stop()
** bounds must be set first for these to work
** setting widths and heights adjusts scale not bounds and getting these uses the bounds dimension times the scale
width - gets or sets the width. Setting the width will scale the height to keep proportion (see widthOnly below)
height - gets or sets the height. Setting the height will scale the width to keep proportion (see heightOnly below)
widthOnly - gets or sets the width.  This sets only the width and may change the aspect ratio of the object
heightOnly - gets or sets the height.  This sets only the height and may change the aspect ratio of the object
depth - for ZIM VR - the depth used to shift left and right channel and for parallax in VR - also see dep() ZIM Display method
blendMode - how the object blends with what is underneath - such as "difference", "multiply", etc. same as CreateJS compositeOperation
group - used when the object is made to add STYLE with the group selector (like a CSS class)

ALSO: See the CreateJS Easel Docs for Sprite properties, such as:
currentFrame, framerate, paused, currentAnimation, currentAnimationFrame, spriteSheet,
x, y, rotation, scaleX, scaleY, regX, regY, skewX, skewY,
alpha, cursor, shadow, mouseEnabled, etc.

EVENTS
See the CreateJS Easel Docs for Sprite events, such as:
animationend, change, added, click, dblclick, mousedown, mouseout, mouseover, pressmove, pressup, removed, rollout, rollover
--*///+50.8
	zim.Sprite = function(image, cols, rows, count, offsetX, offsetY, spacingX, spacingY, width, height, animations, json, id, globalControl, spriteSheet, label, style, group, inherit) {
		var sig = "image, cols, rows, count, offsetX, offsetY, spacingX, spacingY, width, height, animations, json, id, globalControl, spriteSheet, label, style, group, inherit";
		var duo; if (duo = zob(zim.Sprite, arguments, sig, this)) return duo;
		z_d("50.8");
		this.type = "Sprite";
		this.group = group;
	    var DS = style===false?{}:zim.getStyle(this.type, this.group, inherit);

		var that = this;
		var sheet;
		if (zot(json) && !zot(image)) {
			if (zot(cols)) cols = DS.cols!=null?DS.cols:1;
			if (zot(rows)) rows = DS.rows!=null?DS.rows:1;
			if (zot(count)) count = DS.count!=null?DS.count:(cols*rows);
			if (zot(offsetX)) offsetX = DS.offsetX!=null?DS.offsetX:0;
			if (zot(offsetY)) offsetY = DS.offsetY!=null?DS.offsetY:0;
			if (zot(spacingX)) spacingX = DS.spacingX!=null?DS.spacingX:0;
			if (zot(spacingY)) spacingY = DS.spacingY!=null?DS.spacingY:0;
			if (zot(width)) width = DS.width!=null?DS.width:image.width;
			if (zot(height)) height = DS.height!=null?DS.height:image.height;

			var frameW = (width-offsetX+spacingX) / cols - spacingX;
			var frameH = (height-offsetY+spacingY) / rows - spacingY;
			var frames = [];
			var num = 0;
			outer:
			for (var j=0; j<rows; j++) {
				for (var i=0; i<cols; i++) {
					if (++num > count) break outer;
					frames.push([
						offsetX + i*(frameW+spacingX),
						offsetY + j*(frameH+spacingY),
						frameW,
						frameH
					]);
				}
			}
			makeSheet(image, frames, animations);
		} else if (spriteSheet) {
			sheet = spriteSheet;
			animations = sheet.animations;
		} else if (json) {
			// even though data is in JSON, may want to create SpriteSheet from image
			// so that cors will work - so see if provided an image
			// or that the images in the JSON are available in frame.assets
			frames = json.frames;
			animations = json.animations;
			if (!zot(image)) {
				makeSheet(image, frames, animations);
			} else {
				var im = json.images?json.images[0]:null;
				if (!im.split) {
					sheet = new createjs.SpriteSheet(json);
				} else {
					var imEnd = im.split("/").pop();
					if (frame.asset(imEnd).type != "EmptyAsset") {
						makeSheet(frame.asset(imEnd), frames, animations);
					} else if (frame.asset(im).type != "EmptyAsset") {
						var imFinal = frame.asset(im);
						makeSheet(frame.asset(im), frames, animations);
					} else {
						sheet = new createjs.SpriteSheet(json);
					}
				}
			}
		} else {
			return;
		}

		function makeSheet(image, frames, animations) {
			var spriteData = {
				images:[image.image], // note, this takes the image, not the Bitmap
				frames:frames,
				animations:animations?animations:[]
			};
			sheet = new createjs.SpriteSheet(spriteData);
		}

		this.animations = animations;
		this.cjsSprite_constructor(sheet, label);
		if (!zot(label)) this.stop();

		if (zot(id)) id = zim.makeID();
		this.id = id;

		if (zot(globalControl)) globalControl = true;
		that.globalControl = globalControl;

		var _normalizedFrame = 0;
		var _normalizedFrames;
		this.parseFrames = function(label, startFrame, endFrame, fromDynamo) {
			var frames = [];
			var minSpeed = Number.MAX_VALUE;
			var maxSpeed = 0;
			if (zot(label)) {
				if (zot(startFrame)) startFrame = 0;
				if (zot(endFrame)) endFrame = that.totalFrames-1;
				addSequential(startFrame, endFrame);
			} else {
				if (zot(that.animations) || zot(that.animations[label])) return [];
				var a = that.animations[label];
				processAnimation(a);
			}
			function processAnimation(a) {
				if (Array.isArray(a)) {
					processArray(a);
				} else if (a.constructor == {}.constructor) {
					processObject(a);
				} else if (!isNaN(a)) {
					frames.push({f:Math.floor(a), s:1});
				}
			}
			function processArray(a) {
				addSequential(a[0], a[1], a[3]);
				if (a[2] && !zot(that.animations[a[2]])) processAnimation(that.animations[a[2]]);
			}
			function processObject(a) {
				if (zot(a.frames)) return;
				if (zot(a.speed)) a.speed = 1;
				for (var i=0; i<a.frames.length; i++) {
					if (a.speed < minSpeed) minSpeed = a.speed;
					if (a.speed > maxSpeed) maxSpeed = a.speed;
					frames.push({f:a.frames[i], s:a.speed});
				}
				if (a.next && !zot(that.animations[a.next])) processAnimation(that.animations[a.next]);
			}
			function addSequential(start, end, speed) {
				if (zot(speed)) speed = 1;
				if (end > start) {
					for (var i=start; i<=end; i++) {inner(i);}
				} else {
					for (var i=end; i<=start; i++) {inner(start-(i-end));}
				}
				function inner(i) {
					if (speed < minSpeed) minSpeed = speed;
					if (speed > maxSpeed) maxSpeed = speed;
					frames.push({f:i, s:speed});
				}
			}
			if (fromDynamo) return frames;
			// run() uses an array of frame numbers (normalized to speed) where dynamo uses the speed

			// normalize up to 1/10 - as in if put at .1 then have to multiply all others speeds by 10
			minSpeed = zim.constrain(zim.decimals(minSpeed), .1);
			maxSpeed = zim.constrain(zim.decimals(maxSpeed), .1);

			// normalize speed:
			var framesNormalized = [];
			var normalize = (minSpeed != maxSpeed);
			var fr;
			for (var i=0; i<frames.length; i++) {
				fr = frames[i];
				if (normalize) {
					// if minSpeed less than 1 then divide all others by minSpeed otherwise use speed - and need to round to a number that is at least .1
					for (var j=0; j<zim.constrain(Math.round(minSpeed<1?fr.s/minSpeed:fr.s), .1); j++) {
						framesNormalized.push(fr.f);
					}
				} else {
					framesNormalized.push(fr.f);
				}
			}
			return framesNormalized;
		}

		this.run = function(time, label, call, params, wait, waitedCall, waitedParams, loop, loopCount, loopWait, loopCall, loopParams, loopWaitCall, loopWaitParams, rewind, rewindWait, rewindCall, rewindParams, rewindWaitCall, rewindWaitParams, startFrame, endFrame, tweek, id, globalControl) {
			var sig = "time, label, call, params, wait, waitedCall, waitedParams, loop, loopCount, loopWait, loopCall, loopParams, loopWaitCall, loopWaitParams, rewind, rewindWait, rewindCall, rewindParams, rewindWaitCall, rewindWaitParams, startFrame, endFrame, tweek, id, globalControl";
			var duo; if (duo = zob(this.run, arguments, sig)) return duo;

			var obj;
			var set;
			var lookup;
			if (zot(tweek)) tweek = 1;
			if (!zot(id)) that.id = id;
			if (!zot(globalControl)) that.globalControl = globalControl;

			if (Array.isArray(label)) {
				// check labels
				var innerLabel;
				var lastLabel;
				obj = [];
				var extraTime = 0;
				var firstStartFrame;
				for (var i=0; i<label.length; i++) {
					innerLabel = label[i]; // {label:"first", time:1000, etc}

					innerLabel.lookup = that.parseFrames(innerLabel.label, innerLabel.startFrame, innerLabel.endFrame);
					if (i==0) firstStartFrame = innerLabel.lookup[0];
					delete innerLabel.startFrame;
					delete innerLabel.endFrame;

					innerLabel.obj = zim.merge(innerLabel.obj, {normalizedFrame:innerLabel.lookup.length-1});
					innerLabel.set = zim.merge(innerLabel.set, {normalizedFrames:{noPick:innerLabel.lookup}, normalizedFrame:0});

					// based on previous frames
					if (zot(innerLabel.wait)) innerLabel.wait = extraTime*tweek;

					lastLabel = innerLabel.label;
					delete innerLabel.label;

					obj.push(innerLabel);

					// will get applied next set of frames
					extraTime = 0;
					var tt = zot(innerLabel.time)?time:innerLabel.time;
					if (endFrame-startFrame > 0) extraTime = tt / (endFrame-startFrame) / 2; // slight cludge - seems to look better?

					// if (i==0) firstStartFrame = startFrame;
				}
				//startFrame = firstStartFrame;
				if (obj.length == 0) return this;
				if (obj.length == 1) { // just one label in list ;-)
					time = obj[0].time;
					label = lastLabel;
					setSingle();
				} else {
					that.gotoAndStop(firstStartFrame);
				}
			} else { // single label
				setSingle();
			}

			function setSingle() {
				_normalizedFrames = that.parseFrames(label, startFrame, endFrame);
				_normalizedFrame = 0;
				that.gotoAndStop(_normalizedFrames[_normalizedFrame]);
				startFrame = endFrame = null;
				obj = {normalizedFrame:_normalizedFrames.length-1};
			}

			if (zot(time)) time = 1000;
			// if already running the sprite then stop the last run
			if (that.running) that.stopAnimate(that.id);
			that.running = true;


			if (!Array.isArray(obj)) {
				var extraTime = 0;
				if (endFrame-startFrame > 0) extraTime = time / Math.abs(endFrame-startFrame) / 2; // slight cludge - seems to look better?
				if (_normalizedFrames && _normalizedFrames.length>0) extraTime = time / _normalizedFrames.length / 2; // slight cludge - seems to look better?
				if (zot(loopWait)) {loopWait = extraTime*tweek};
				if (zot(rewindWait)) {rewindWait = extraTime*tweek};
			}


			// locally override call to add running status after animation done
			var localCall = function() {
				if (call && typeof call == 'function') call(params||that);
				that.running = false;
				that.stop();
			}
			zim.animate({
				target:that,
				obj:obj,
				time:time,
				ease:"linear",
				call:localCall,
				params:params,
				wait:wait, waitedCall:waitedCall, waitedParams:waitedParams,
				loop:loop, loopCount:loopCount, loopWait:loopWait,
				loopCall:loopCall, loopParams:loopParams,
				loopWaitCall:loopWaitCall, loopWaitParams:loopWaitParams,
				rewind:rewind, rewindWait:rewindWait, // rewind is ignored by animation series
				rewindCall:rewindCall, rewindParams:rewindParams,
				rewindWaitCall:rewindWaitCall, rewindWaitParams:rewindWaitParams,
				override:false,
				id:that.id
			});
			that.runPaused = false;
			return that;
		}

		this.runPaused = true;
		this.pauseRun = function(paused) {
			if (zot(paused)) paused = true;
			that.runPaused = paused;
			if (that.globalControl) {
				zim.pauseAnimate(paused, that.id);
			} else {
				that.pauseAnimate(paused, that.id);
			}
			return that;
		}
		this.stopRun = function() {
			that.runPaused = true;
			that.running = false;
			if (that.globalControl) {
				zim.stopAnimate(that.id);
			} else {
				that.stopAnimate(that.id);
			}
			return that;
		}

		Object.defineProperty(this, 'frame', {
			get: function() {
				return this.currentFrame;
			},
			set: function(value) {
				value = Math.round(value);
				if (this.paused) {
					this.gotoAndStop(value);
				} else {
					this.gotoAndPlay(value);
				}
			}
		});

		Object.defineProperty(this, 'normalizedFrame', {
			get: function() {
				return _normalizedFrame;
			},
			set: function(value) {
				_normalizedFrame = Math.round(value);
				this.gotoAndStop(_normalizedFrames[_normalizedFrame]);
			}
		});

		Object.defineProperty(this, 'normalizedFrames', {
			get: function() {
				return _normalizedFrames;
			},
			set: function(value) {
				_normalizedFrames = value;
			}
		});

		Object.defineProperty(this, 'totalFrames', {
			get: function() {
				return sheet.getNumFrames();
			},
			set: function(value) {
				zog("zim.Sprite - totalFrames is read only");
			}
		});

		if (style!==false) zimStyleTransforms(this, DS); // global function - would have put on DisplayObject if had access to it
		this.clone = function() {
			return this.cloneProps(new zim.Sprite(image, cols, rows, count, offsetX, offsetY, spacingX, spacingY, width, height, animations, json, null, globalControl, spriteSheet, style, this.group, inherit));
		}
		this.localToGlobal = function(x,y) {
			return localToGlobal(x,y,this,this.cjsSprite_localToGlobal);
		}
		this.globalToLocal = function(x,y) {
			return globalToLocal(x,y,this,this.cjsSprite_globalToLocal);
		}
		this.localToLocal = function(x,y,target) {
			return localToLocal(x,y,target,this);
		}
		this.hasProp = function(prop) {
			return (!zot(this[prop]) || this.hasOwnProperty(prop))
		}
		this.dispose = function() {
			this.removeAllEventListeners();
			if (this.parent) this.parent.removeChild(this);
		}
	}
	zim.extend(zim.Sprite, createjs.Sprite, ["clone","localToLocal","localToGlobal","globalToLocal"], "cjsSprite", false);
	zimify(zim.Sprite.prototype);
	//-50.8

/*--
zim.MovieClip = function(mode, startPosition, loop, labels, style, group, inherit)

MovieClip
zim class - extends a createjs.MovieClip

DESCRIPTION
A MovieClip adds timelines to a Container.
The timelines are animate() zimTween properties.
The zimTween property returns a CreateJS Tween object.
Primarily made to support Adobe Animate MovieClip export.
*Consider this experimental for the moment...

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var movieClip = new MovieClip();
var circle = new Circle(20, blue).animate({
	props:{scale:3}, time:100, rewind:true, loop:true
});

// time is in frames NOT in ms - so 100 frames at the Ticker.framerate 60 fps by default is almost 2 seconds
// note that to change the Ticker's framerate use setFPS(mobile, desktop) method
// if you use one number then both mobile and desktop are set to that fps.
// Note that the defaults are 30 fps mobile and 60 fps desktop

movieClip.timeline.addTween(circle.zimTween);
movieClip.play();
movieClip.center();
stage.on("stagemousedown", function() {
   movieClip.paused = !movieClip.paused;
});
END EXAMPLE

PARAMETERS
** supports DUO - parameters or single object with properties below
** supports OCT - parameter defaults can be set with STYLE control (like CSS)
// from the CreateJS MovieClip docs: http://www.createjs.com/docs/easeljs/classes/MovieClip.html
mode - (default "independent") or single_frame (based on startPosition) or synched (syncs to parent)
startPosition - (default 0) the start position of the MovieClip (*could not get to work)
loop - (default true) set to false not to loop (*did not seem to loop so use loop:true in zim.animate())
labels - (default null) declare label property with position value
	eg. {explode:20} to use with gotoAndPlay("explode") rather than gotoAndPlay(20)
style - (default true) set to false to ignore styles set with the STYLE - will receive original parameter defaults
group - (default null) set to String (or comma delimited String) so STYLE can set default styles to the group(s) (like a CSS class)
inherit - (default null) used internally but can receive an {} of styles directly

METHODS
hasProp(property as String) - returns true if property exists on object else returns false
clone() - makes a copy with properties such as x, y, etc. also copied
dispose() - removes from parent, removes event listeners - must still set outside references to null for garbage collection

ALSO: ZIM 4TH adds all the methods listed under Container (see above), such as:
drag(), hitTestRect(), animate(), sca(), reg(), mov(), center(), centerReg(),
addTo(), removeFrom(), loop(), outline(), place(), pos(), alp(), rot(), setMask(), etc.
ALSO: See the CreateJS Easel Docs for MovieClip methods, such as:
play(), gotoAndPlay(), gotoAndStop(), stop(), advance(),
on(), off(), getBounds(), setBounds(), dispatchEvent(), etc.

PROPERTIES
type - holds the class name as a String
** bounds must be set first for these to work
** setting widths and heights adjusts scale not bounds and getting these uses the bounds dimension times the scale
width - gets or sets the width. Setting the width will scale the height to keep proportion (see widthOnly below)
height - gets or sets the height. Setting the height will scale the width to keep proportion (see heightOnly below)
widthOnly - gets or sets the width.  This sets only the width and may change the aspect ratio of the object
heightOnly - gets or sets the height.  This sets only the height and may change the aspect ratio of the object
depth - for ZIM VR - the depth used to shift left and right channel and for parallax in VR - also see dep() ZIM Display method
blendMode - how the object blends with what is underneath - such as "difference", "multiply", etc. same as CreateJS compositeOperation
group - used when the object is made to add STYLE with the group selector (like a CSS class)

ALSO: See the CreateJS Easel Docs for MovieClip properties, such as:
currentFrame, totalFrames, currentLabel, duration, framerate, labels, loop, mode, paused, startPosition, timeline,
x, y, rotation, scaleX, scaleY, regX, regY, skewX, skewY,
alpha, cursor, shadow, mouseEnabled, parent, etc.

EVENTS
See the CreateJS Easel Docs for MovieClip events, such as:
added, click, dblclick, mousedown, mouseout, mouseover, pressmove, pressup, removed, rollout, rollover
--*///+50.9
	zim.MovieClip = function(mode, startPosition, loop, labels, style, group, inherit) {
		var sig = "mode, startPosition, loop, labels, style, group, inherit";
		var duo; if (duo = zob(zim.MovieClip, arguments, sig, this)) return duo;
		z_d("50.9");
		this.type = "MovieClip";
		this.group = group;
		var DS = style===false?{}:zim.getStyle(this.type, this.group, inherit);

		if (zot(mode)) mode = DS.mode!=null?DS.mode:null;
		if (zot(startPosition)) startPosition = DS.startPosition!=null?DS.startPosition:null;
		if (zot(loop)) loop = DS.loop!=null?DS.loop:null;
		if (zot(labels)) labels = DS.labels!=null?DS.labels:null;

		this.cjsMovieClip_constructor(mode, startPosition, loop, labels);

		if (style!==false) zimStyleTransforms(this, DS); // global function - would have put on DisplayObject if had access to it
		this.clone = function() {
			return this.cloneProps(new zim.MovieClip(mode, startPosition, loop, labels, style, this.group, inherit));
		}
		this.hasProp = function(prop) {
			return (!zot(this[prop]) || this.hasOwnProperty(prop))
		}
		this.localToGlobal = function(x,y) {
			return localToGlobal(x,y,this,this.cjsMovieClip_localToGlobal);
		}
		this.globalToLocal = function(x,y) {
			return globalToLocal(x,y,this,this.cjsMovieClip_globalToLocal);
		}
		this.localToLocal = function(x,y,target) {
			return localToLocal(x,y,target,this);
		}
		this.dispose = function() {
			this.removeAllEventListeners();
			if (this.parent) this.parent.removeChild(this);
		}
	}
	zim.extend(zim.MovieClip, createjs.MovieClip, ["clone","localToLocal","localToGlobal","globalToLocal"], "cjsMovieClip", false);
	zimify(zim.MovieClip.prototype);
	//-50.9

/*--
zim.SVGContainer = function(svg, splitTypes, geometric, style, group, inherit)

SVGContainer
zim class - extends a zim.Container which extends a createjs.Container

DESCRIPTION
Parses SVG and adds items to a ZIM Container.
Items are created as ZIM Shapes: Circle, Rectangle, Blob, Squiggle.
If geometric is true then Circle and Rectangle are used otherwise Blob is used.
Items can be accessed using svgcontainer.getChildAt(0), etc.
See: https://zimjs.com/svg/
See: https://zimjs.com/explore/svgcontainer.html

An SVG path string can be passed directly to a Squiggle or Blob points parameter
and so avoiding the SVGContainer - see ZIM Squiggle and Blob

WARNING: this should be considered experimental
The idea is that paths from SVG can be made editable in ZIM
or animation, dragging, or Label along paths can be accommodated
As such, not all SVG features will work - no CSS, Text, Gradients, DropShadows, etc.
It is possible that these will be added at some point
See also the ZIM svgToBitmap() function under META to get an exact image of the SVG

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var svgContainer = new SVGContainer(frame.asset("sample.svg")).addTo();

// OR

var svg = `<svg  width="150" height="200" xmlns="h t t p ://www.w3.org/2000/svg">
    <path id="lineAB" d="M 0 0 l 150 200" stroke="red" stroke-width="3" fill="none" />
</svg>`;
var svgContainer = new SVGContainer(svg).center();
END EXAMPLE

PARAMETERS
** supports DUO - parameters or single object with properties below
** supports OCT - parameter defaults can be set with STYLE control (like CSS)
svg - an SVG file loaded into a frame.asset() or SVG text
splitTypes - (default false) - set to true to split different types of paths into separate objects
geometric - (default true) - set to false to load Rectangle and Circle objects as Blob objects
style - (default true) set to false to ignore styles set with the STYLE - will receive original parameter defaults
group - (default null) set to String (or comma delimited String) so STYLE can set default styles to the group(s) (like a CSS class)
inherit - (default null) used internally but can receive an {} of styles directly

METHODS
processPath(path) - path is an SVG path string - returns a ZIM Blob or Squiggle points array
hasProp(property as String) - returns true if property exists on object else returns false
clone() - makes a copy with properties such as x, y, etc. also copied
dispose() - removes from parent, removes event listeners - must still set outside references to null for garbage collection

ALSO: ZIM 4TH adds all the methods listed under Container (see above), such as:
drag(), hitTestRect(), animate(), sca(), reg(), mov(), center(), centerReg(),
addTo(), removeFrom(), loop(), outline(), place(), pos(), alp(), rot(), setMask(), etc.
ALSO: See the CreateJS Easel Docs for Container methods, such as:
on(), off(), getBounds(), setBounds(), uncache(), updateCache(), dispatchEvent(),
addChild(), removeChild(), addChildAt(), getChildAt(), contains(), removeAllChildren(), etc.

PROPERTIES
svg - a reference to the SVG text
type - holds the class name as a String
** bounds must be set first for these to work
** setting widths and heights adjusts scale not bounds and getting these uses the bounds dimension times the scale
width - gets or sets the width. Setting the width will scale the height to keep proportion (see widthOnly below)
height - gets or sets the height. Setting the height will scale the width to keep proportion (see heightOnly below)
widthOnly - gets or sets the width.  This sets only the width and may change the aspect ratio of the object
heightOnly - gets or sets the height.  This sets only the height and may change the aspect ratio of the object
depth - for ZIM VR - the depth used to shift left and right channel and for parallax in VR - also see dep() ZIM Display method
blendMode - how the object blends with what is underneath - such as "difference", "multiply", etc. same as CreateJS compositeOperation
group - used when the object is made to add STYLE with the group selector (like a CSS class)

ALSO: See the CreateJS Easel Docs for Container properties, such as:
x, y, rotation, scaleX, scaleY, regX, regY, skewX, skewY,
alpha, cursor, shadow, mouseChildren, mouseEnabled, parent, numChildren, etc.

EVENTS
See the CreateJS Easel Docs for Container events, such as:
added, click, dblclick, mousedown, mouseout, mouseover, pressmove, pressup, removed, rollout, rollover
--*///+50.95

	zim.SVGContainer = function(svg, splitTypes, geometric, style, group, inherit) {
		var sig = "svg, splitTypes, geometric, style, group, inherit";
		var duo; if (duo = zob(zim.SVGContainer, arguments, sig, this)) return duo;
		z_d("50.95");
		this.group = group;
		var DS = style===false?{}:zim.getStyle("SVGContainer", this.group, inherit);

		var that = this;
		var startPosition = new zim.Point(0,0); // the x,y of the last shape
		var aCommand=[];	//kv adjust logic

		if (zot(splitTypes)) splitTypes = false;
		if (zot(geometric)) geometric = true;

		if (!zot(svg)) {

			if (!zot(svg.draggable)) {
				var parser = new DOMParser();
				var svg = !svg.innerHTML?svg:parser.parseFromString(svg.innerHTML,"text/xml");
				var list = svg.getElementsByTagName("svg");
				var tag = this.svg = list?svg.getElementsByTagName("svg")[0]:null;
			} else {
				if (!svg.getAttribute) {
					var parser = new DOMParser();
					svg = parser.parseFromString(svg, "image/svg+xml").documentElement;
				}
				var tag = this.svg = svg;
			}
			var w, h;
			if (!zot(tag)){
				var w = tag.getAttribute("width");
				var h = tag.getAttribute("height");
			}
			if (w) w = Number(w.trim());
			if (h) h = Number(h.trim());
			this.zimContainer_constructor(w, h);
			this.type = "SVGContainer";

			if (zot(tag)) return;

			var defaultFill = zim.black, generalFill = zim.black;
			var defaultStroke =zim. black, generalStroke = zim.black;
			var defaultStrokeSize = 2, generalStrokeSize = 2;
			var defaultAlpha = 1, generalAlpha = 1;
			var defaultStrokeAlpha = 1, generalStrokeAlpha = 1;
			var currentTransform;

			function processTag(tag) {
				zim.loop(tag, function (t) {
					var tn = t.tagName.toLowerCase();
					if (tn == "path") processPath(t);
					if (tn == "circle") processShape("circle", t);
					if (tn == "rect") processShape("rect", t);
					if (tn == "ellipse") processShape("ellipse", t);
					if (tn == "line") processShape("line", t);
					if (tn == "polygon") processShape("polygon", t);
					if (tn == "polyline") processShape("polyline", t);
					if (tn == "g") {
						// styles can be overwritten by parameters in the general tag
						// so find styles first
						var style = t.getAttribute("style");
						var f,s,ss,a,aa;
						if (style) {
							var styles = processStyle(style);
							f = styles[0];
							s = styles[1];
							ss = styles[2];
							a = styles[3];
							aa = styles[4];
						}
						// then overwrite styles with any attribute values
						currentTransform = t.getAttribute("transform");
						generalFill = t.getAttribute("fill")?t.getAttribute("fill"):!zot(f)?f:defaultFill;
						generalStroke = t.getAttribute("stroke")?t.getAttribute("stroke"):!zot(s)?s:defaultStroke;
						generalStrokeSize = t.getAttribute("stroke-width")?t.getAttribute("stroke-width"):!zot(ss)?ss:defaultStrokeSize;
						generalAlpha = t.getAttribute("fill-opacity")?t.getAttribute("fill-opacity"):!zot(a)?a:defaultAlpha;
						generalStrokeAlpha = t.getAttribute("stroke-opacity")?t.getAttribute("stroke-opacity"):!zot(aa)?aa:defaultStrokeAlpha;
					}
					// general settings can wrap any number of tags - the tags are processed here:
					processTag(t.children);
					// after this nest of tags are processed, clear the general settings
					if (t.tagName.toLowerCase() == "g") {
						generalFill = defaultFill;
						generalStroke = defaultStroke;
						generalStrokeSize = defaultStrokeSize;
						generalAlpha = defaultAlpha;
						generalStrokeAlpha = defaultStrokeAlpha;
						currentTransform = null;
					}
				})
			}
			var process = svg.getElementsByTagName("svg");
			if (process.length == 0) process = [svg];

			function processStyle(style) {
				var st = style.split(";");											//kv note: there si bug when style contains ; at the end of the string
				var f,s,ss,a,aa;
				loop(st, function (sty) {
					var sty = sty.replace(/,/g,"");
					var styl = sty.split(":");
					var prop = styl[0].trim().toLowerCase();
					var val = styl[1].trim().toLowerCase().replace("px", "");
					if (prop=="fill") f = val;
					if (prop=="stroke") s = val;
					if (prop=="stroke-width") ss = val;
					if (prop=="opacity") a = val, aa = val;
					if (prop=="fill-opacity") a = val;
					if (prop=="stroke-opacity") aa = val;
				});
				return [f,s,ss,a,aa];
			}

			function processShape(type, tag) {
				var shape;
				var g = processGeneral(tag); // want ES6
				var f = g[0], s = g[1], ss = g[2], a = g[3], aa = g[4], x = g[5], y = g[6];
				if (type == "circle") {
					var r = Number(tag.getAttribute("r").trim());
					var d = r*.5523;
					if (geometric) shape = new zim.Circle(Number(tag.getAttribute("r")), f, s, ss);
					else shape = new zim.Blob(f, s, ss, 4, r, d, "mirror");
				} else if (type == "rect") {
					if (geometric) shape = new zim.Rectangle(Number(tag.getAttribute("width")), Number(tag.getAttribute("height")), f, s, ss, Number(tag.getAttribute("rx")));
					else {
						var w = Number(tag.getAttribute("width"));
						var h = Number(tag.getAttribute("height"));
						var rx = Number(tag.getAttribute("rx"));
						var ry = Number(tag.getAttribute("ry"));
						if (rx && ry) {
							var dx = rx*.5523;
							var dy = ry*.5523;
							shape = new zim.Blob(f, s, ss, [
								[rx,0,0,0,-dx,0,0,0,"free"],[w-rx,0,0,0,0,0,dx,0,"free"],
								[w,ry,0,0,0,-dy,0,0,"free"],[w,h-ry,0,0,0,0,0,dy,"free"],
								[w-rx,h,0,0,dx,0,0,0,"free"],[rx,h,0,0,0,0,-dx,0,"free"],
								[0,h-ry,0,0,0,dy,0,0,"free"],[0,ry,0,0,0,0,0,-dy,"free"]]);
						} else {
							shape = new zim.Blob(f, s, ss, [[0,0],[w,0],[w,h],[0,h]]);
						}
					}
				} else if (type == "line") {
					shape = new zim.Squiggle(s, ss, [[Number(tag.getAttribute("x1")), Number(tag.getAttribute("y1"))],[Number(tag.getAttribute("x2")), Number(tag.getAttribute("y2"))]]);
				} else if (type == "polygon" || type == "polyline") {
					var p = tag.getAttribute("points");
					p = p.replace(/-/g, " -");
					p = p.replace(/\s+/g, " ");
					var points = [];
					loop(p.split(" "), function (point) {
						var pp = point.split(",");
						points.push([Number(pp[0].trim()), Number(pp[1].trim())]);
					})
					if (type=="polygon") shape = new Blob(f, s, ss, points);
					else shape = new zim.Squiggle(s, ss, points);
				} else if (type == "ellipse") {
					shape = new zim.Blob(f, s, ss, ellipse(0, 0, Number(tag.getAttribute("rx")), Number(tag.getAttribute("ry"))));
				}
				shape.loc(x,y,that);
				var transform = tag.getAttribute("transform");
				if (transform || currentTransform) processTransform(shape, transform || currentTransform);
				if (shape.type == "Rectangle" || shape.type=="Circle") shape.transform({showReg:false})
			}

			function processTransform(shape, transform) {
				var tr = transform.split(")");
				// apply all transforms in the order given
				loop(tr, function (tra) {
					if (tra=="") return;
					var tran = tra.trim().split("(");
					var prop = tran[0].trim().toLowerCase();
					var val = tran[1].trim().toLowerCase().replace("px", "").replace("deg", "");
					if (prop=="translate") {
						var m = val.split(",");
						shape.mov(Number(m[0].trim()), m[1]?Number(m[1].trim()):0);
					}
					if (prop=="scale"){
						var s = val.split(",");
						if (shape.type=="Blob" || shape.type=="Squiggle") {
							if (s.length == 1) shape.transformPoints("scale", Number(s[0].trim()))
							else if (s.length == 2) {
								shape.transformPoints("scaleX", Number(s[0].trim()));
								shape.transformPoints("scaleY", Number(s[1].trim()));
							}
						} else {
							if (s.length == 1) shape.sca(Number(s[0].trim()))
							else if (s.length == 2) {
								shape.sca(Number(s[0].trim()), Number(s[1].trim()));
							}
						}
					}
					if (prop=="rotate") {
						var r = val.split(",");
						// if (shape.type=="Blob" || shape.type=="Squiggle") {
							// rotation is a different way for SVG and transform() - too bad
							// it rotates around 0,0 unless a different point is chosen
							// so shape.transformPoints which is a registration point system
							// is unlikely to work - and too complex to add rotate around a given point
							// so we will use zim rot() to which we have added rotating around a different point
							// but this will rotate the little box handles
							// maybe look into keeping those parallel in the blob and squiggle - no matter what the rotation
							// if (r.length == 1) shape.transformPoints("rotation", Number(r[0].trim()))
						if (r.length == 1) r.push(0,0);
						else if (r.length == 2) r.push(0);
						shape.rot(Number(r[0].trim()), Number(r[1].trim()), Number(r[2].trim()));
					}

					if (prop=="skewX") shape.skewX = val;
					if (prop=="skewY") shape.skewY = val;
				});
			}

			// beatgammit on StackOverflow
			function ellipse(x, y, xDis, yDis) {
				var kappa = 0.5522848, // 4 * ((âˆš(2) - 1) / 3)
					ox = xDis * kappa,  // control point offset horizontal
					oy = yDis * kappa,  // control point offset vertical
					xe = x + xDis,      // x-end
					ye = y + yDis;      // y-end
				var points = [ // modified by Dan Zen to relative
					[x - xDis, y, 0, 0, x, ye+oy-yDis, x, y-oy, "mirror"],
					[x, y - yDis, 0, 0, x-ox, y, xe+ox-xDis, y, "mirror"],
					[xe, y, 0, 0, x, y-oy, x + ox-ox, ye+oy-yDis, "mirror"],
					[x, ye, 0, 0, xe-xDis+ox, y, x-ox, y, "mirror"]
				];
				return points;
			}

			processTag(process);

		}

		function processGeneral(tag) {
			// any styles on the tag overwrites general styles or attributes
			var f,s,ss,a,aa;
			var style = tag.getAttribute("style");
			if (style) {
				var styles = processStyle(style);
				f = styles[0];
				s = styles[1];
				ss = styles[2];
				a = styles[3];
				aa = styles[4];
			}
			// kv comments: need to apply string cleansing, application bugs when there is a semi colon character used in tags.
			// get rid of semi colon,
			// any attributes on the tag overwrites styles or general
			f = tag.getAttribute("fill")?tag.getAttribute("fill"):!zot(f)?f:generalFill;
			s = tag.getAttribute("stroke")?tag.getAttribute("stroke"):!zot(s)?s:generalStroke;
			ss = tag.getAttribute("stroke-width")?tag.getAttribute("stroke-width"):!zot(ss)?ss:generalStrokeSize;
			a = tag.getAttribute("fill-opacity")?tag.getAttribute("fill-opacity"):!zot(a)?a:generalAlpha;
			aa = tag.getAttribute("stroke-opacity")?tag.getAttribute("stroke-opacity"):!zot(aa)?aa:generalStrokeAlpha;

			var x = tag.getAttribute("x")?tag.getAttribute("x"):0;
			x = tag.getAttribute("cx")?tag.getAttribute("cx"):x;
			var y = tag.getAttribute("y")?tag.getAttribute("y"):0;
			y = tag.getAttribute("cy")?tag.getAttribute("cy"):y;
			if (!zot(a) && !zot(f)) f = zim.convertColor(f, "rgba", Number(a));
			if (!zot(aa) && !zot(s)) s = zim.convertColor(s, "rgba", Number(aa));
			return [f,s,Number(ss),Number(a),Number(aa),Number(x),Number(y)];
		}

		function processPath (path, make) {
			if (zot(make)) make = true;
			var commands = ["M","m","L","l","H","h","V","v","C","c","S","s","Q","q","T","t","A","a","z","Z"];
			var commandsRelative = ["m","l","h","v","c","s","q","t","a","z"];

			var position = new zim.Point(0,0); // the current position - relative places based on this

			if (zot(path.getAttribute)) {
				var d = path;
			} else {
				var id = path.getAttribute("id");
				var d = path.getAttribute("d");
			}

			// m251.85 119.04c7.85 10.45-9.81
			d = d.replace(/,/g ," ");
			d = d.replace(/([a-zA-Z])/g, " $1 ");
			d = d.replace(/-/g, " -");
			d = d.replace(/\s+/g, " ");


			if (make) {
				var g = processGeneral(path); // want ES6
				var f = g[0]; var s = g[1]; var ss = g[2]; var a = g[3]; var aa = g[4];
			}

			var shape;																									//kv adjust logic
			var aNumber;																								//kv adjust logic
			//var points = [[0,0]];																						//kv adjust logic
			var points = [];																							//kv adjust logic
			var lastTempPoint = [0,0];																					//kv adjust logic
			var line = new zim.Point(0,0);
			var quad = new zim.Point(0,0,0,0);
			var cube = new zim.Point(0,0,0,0,0,0);
			var arc = new zim.Point(0,0,0,0,0,0,0);
			//kv var data = d.split(" ");																				//kv adjust logic
			var dataOrigin = d.split(" ");																				//kv adjust logic
			var data = dataOrigin.slice(1,dataOrigin.length);															//kv adjust logic
			var aCommand = [];																							//kv adjust logic
			var missingCommand = false;													//not used yet					//kv adjust logic
			var lastCommand = "";																						//kv adjust label
			var previousCommand = "";													//not used yet					//kv adjust logic
			var adding = false;
			var what;
			var type = "squiggle";
			var dataType = null;
			//kv loop(data, function (command) {					//kv adjust logic
			zim.loop(data, function (command,i) {
																					//kv adjust logic
				if (i==0) {startPosition.x = 0; startPosition.y=0;lastTempPoint = [0,0];lastCommand = "";previousCommand = ""};
				if (commands.indexOf(command) == -1) {
					if (what == "lxo") {what="lx"; aCommand.push("l");missingCommand=true};								//kv adjust logic
					if (what == "lyo") {what="ly"; missingCommand=true};												//kv adjust logic
					if (what == "Lxo") {what="Lx"; aCommand.push("L");missingCommand=true};								//kv adjust logic
					if (what == "Lyo") {what="Ly"; missingCommand=true};												//kv adjust logic
					aNumber = Number(command);																			//kv adjust logic
					aNumber = Math.round(aNumber * 100) / 100;															//kv adjust logic
					// position
					if (what == "X") {
						startPosition.x = aNumber;
						what = "Y";
					} else if (what == "Y") {
						startPosition.y = aNumber;
						//kv what = "Lx"; // in case no letters come next												//kv adjust logic
						what = "Lxo"; // in case no letters come next													//kv adjust logic
						points.push([startPosition.x, startPosition.y]);												//kv adjust logic
						// what = null;
					} else if (what == "x") {
						//if (points.length > 1) {
						//	startPosition.x = points[points.length-1][0]; 												//kv adjust logic
						//	startPosition.y = points[points.length-1][1]												//kv adjust logic
						//} else {
						//	startPosition.x = lastTempPoint[0];															//kv adjust logic
						//	startPosition.y = lastTempPoint[1]															//kv adjust logic
						//};
						startPosition.x = startPosition.x+aNumber;
						what = "y";
					} else if (what == "y") {
						startPosition.y = startPosition.y+aNumber;
						what = "lxo";																					//kv adjust logic
						//kv what = "lx"; // in case no letters come next												//kv adjust logic
						points.push([startPosition.x, startPosition.y]);												//kv adjust logic
						// what = null;
					}

					// left, right, top or bottom
					if (what == "H" || what == "h") {
						position.x = points[points.length-1][0];														//kv adjust logic
						position.y = points[points.length-1][1];														//kv adjust logic
						position.x = position.x + (what=="h"?aNumber:aNumber-startPosition.x);
						points.push([position.x, position.y]);
						what = "Lx"
					} else if (what == "V" || what == "v") {
						position.x = points[points.length-1][0];														//kv adjust logic
						position.y = points[points.length-1][1];														//kv adjust logic
						position.y = position.y + (what=="v"?aNumber:aNumber-startPosition.y);
						points.push([position.x, position.y]);
						what = "lx"
					}

					// line
					if (what == "Lx") {
						//kv line.x = aNumber-startPosition.x;							//kv adjust logic
						line.x = aNumber;												//kv adjust logic
						what = "Ly";
					} else if (what == "Ly") {
						//kv line.y = aNumber-startPosition.y;							//kv adjust logic
						line.y = aNumber;												//kv adjust logic
						position.x = line.x;
						position.y = line.y;
						points.push([position.x, position.y]);
						what = "Lx"
					} else if (what == "lx") {
						if (aCommand.length > 0) {										//kv adjust logic
							if (position.x != 0 && position.y != 0 ) {
								startPosition.x = position.x;
								startPosition.y = position.y
							}
							else {
							startPosition.x = position.x + startPosition.x;				//kv adjust logic
							startPosition.y = position.y + startPosition.y;				//kv adjust logic
							//startPosition.x = position.x + lastTempPoint[0];			//kv adjust logic
							//startPosition.y = position.y + lastTempPoint[1];			//kv adjust logic
							}
						};																//kv adjust logic
						line.x = startPosition.x + aNumber;								//kv adjust logic
						//kv line.x = line.x + aNumber;									//kv adjust logic
						if (missingCommand) {what="lyo"} else							//kv adjust logic
						what = "ly";
					} else if (what == "ly") {
						line.y = startPosition.y + aNumber;								//kv adjust logic
						//line.y = line.y + aNumber;									//kv adjust logic
						position.x = line.x;
						position.y = line.y;
						points.push([position.x, position.y]);
						what = "lx";
					}


					// Quadratic
					if (what == "qx" || what == "Qx") {
						if (points.length > 0) {								//kv adjust logic
							startPosition.x = points[points.length-1][0]; 		//kv adjust logic
							startPosition.y = points[points.length-1][1]		//kv adjust logic
						} else {												//kv adjust logic
							startPosition.x = 0;						 		//kv adjust logic
							startPosition.y = 0									//kv adjust logic
						};														//kv adjust logic

						//kv quad.x = what=="qx"?position.x+aNumber:aNumber-startPosition.x;
						quad.x = what=="qx"?startPosition.x+aNumber:aNumber;	//kv adjust logic
						what = what=="qx"?"qy":"Qy";
					} else if (what == "qy" || what == "Qy") {
						//kv quad.y = what=="qy"?position.y+aNumber:aNumber-startPosition.y;
						quad.y = what=="qy"?startPosition.y+aNumber:aNumber;	//kv adjust logic
						what = what=="qy"?"qz":"Qz";
						if (adding) {
							adding = false;
							var lastPoint = points[points.length-1];
							lastPoint[6] = -lastPoint[4];
							lastPoint[7] = -lastPoint[5];
							lastPoint[8] = "mirror";
							position.x = quad.x;
							position.y = quad.y;
							points[points.length] = [
								position.x, position.y,
								0, 0,
								-lastPoint[6], lastPoint[7],
								0,0,
								"free"
							];
							what = what=="qy"?"qx":"Qx";
						}
					} else if (what == "qz" || what == "Qz") {
						//kv quad.z = what=="qz"?position.x+aNumber:aNumber-startPosition.x;
						quad.z = what=="qz"?startPosition.x+aNumber:aNumber;							//kv adjust logic
						what = what=="qz"?"qq":"Qq";
					} else if (what == "qq" || what == "Qq") {
						//kv quad.w = what=="qq"?position.y+aNumber:aNumber-startPosition.y;
						quad.w = what=="qq"?startPosition.y+aNumber:aNumber;							//kv adjust logic
                        var lastPoint = points[points.length-1];
                        position.x = lastPoint[0]; 													    //kv adjust logic
                        position.y = lastPoint[1];													    //kv adjust logic
						if (points.length == 1) {														//kv adust logic
							lastPoint[2] = 0; lastPoint[3] = 0; lastPoint[4] = 0; lastPoint[5] = 0;		//kv adjust logic    																	//kv debug
							lastPoint[6] = 2/3 *(quad.x - position.x); // relative needs position and absolute does not it
							lastPoint[7] = 2/3 *(quad.y - position.y);
							lastPoint[8] = "free"
						}																				//kv adjust logic
						else {																			//kv adjust logic
							points[points.length] = [													//kv adjust logic
								position.x, position.y,													//kv adjsut logic
								0, 0, 0, 0,																//kv adjust logic
								2/3*(quad.x-position.x), 												//kv adjust logic
								2/3*(quad.y-position.y),												//kv adjust logic
								"free"																	//kv adjust logic
							]																			//kv adjust logic
						};																				//kv adjust logic
						position.x = quad.z; // assign this point's position - fix this and apply throughout...
						position.y = quad.w;
						points[points.length] = [
							position.x, position.y,
							0, 0,
							// relative needs - startPosition and absolute does not
							2/3*(quad.x-position.x), 2/3*(quad.y-position.y),
							0,0,
							"free"
						];
						what = what=="qq"?"qx":"Qx"
					};
					// Cubic
					if (what == "cx" || what == "Cx") {
						if (points.length > 0) {														//kv adjust logic
							startPosition.x = points[points.length-1][0]; 								//kv adjust logic
							startPosition.y = points[points.length-1][1]								//kv adjust logic
						} else {																		//kv adjust logic
							startPosition.x = 0;						 								//kv adjust logic
							startPosition.y = 0															//kv adjust logic
						};																				//kv adjust logic

						//kv cube.x = what=="cx"?position.x+aNumber:aNumber-startPosition.x;
						cube.x = what=="cx"?startPosition.x+aNumber:aNumber;							//kv adjust logic
						what = what=="cx"?"cy":"Cy";
					} else if (what == "cy" || what == "Cy") {		// y Control Point 1
						//kv cube.y = what=="cy"?position.y+aNumber:aNumber-startPosition.y;
						cube.y = what=="cy"?startPosition.y+aNumber:aNumber;							//kv adjust logic
						what = what=="cy"?"cz":"Cz";
					} else if (what == "cz" || what == "Cz") {		// x Control Point 2
						//kv cube.z = what=="cz"?position.x+aNumber:aNumber-startPosition.x;
						cube.z = what=="cz"?startPosition.x+aNumber:aNumber;							//kv adjust logic
						what = what=="cz"?"cq":"Cq";
					} else if (what == "cq" || what == "Cq") {		// y Control Point 2
						//kv cube.q = what=="cq"?position.y+aNumber:aNumber-startPosition.y;
						cube.q = what=="cq"?startPosition.y+aNumber:aNumber;							//kv adjust logic
						what = what=="cq"?"cr":"Cr";
						if (adding) {
							if (lastCommand=="s") {previousCommand = "s"} else {previousCommand = "S"};
							//kv adding = false;
							//kv update previous point
							var lastPoint = points[points.length-1];
								lastPoint[2] = 0;							//kv adjust logic
								lastPoint[3] = 0;							//kv adjust logic
								if(zot(lastPoint[4])) {lastPoint[4] =0};	//kv adjust logic
								if(zot(lastPoint[5])) {lastPoint[5] =0};	//kv adjust logic
								lastPoint[6] = -lastPoint[4];
								lastPoint[7] = -lastPoint[5];
								// lastPoint[6] = - (cube.x-cube.z);			//kv adjust logic
								// lastPoint[7] = - (cube.y-cube.q);			//kv adjust logic
								lastPoint[8] = "mirror";
								//kv create very lastPoint
								position.x = cube.z;
								position.y = cube.q;
								points[points.length] = [
									position.x, position.y,
									0, 0,
									cube.x-position.x, cube.y-position.y,
									0,0,
									"free"
								];
							//kv what = what=="cq"?"cx":"Cx";
							what = what=="cr"?"cx":"Cx"																			//kv adjust logic
						}
					} else if (what == "cr" || what == "Cr") {
						//kv cube.r = what=="cr"?position.x+aNumber:aNumber-startPosition.x;
						cube.r = what=="cr"?startPosition.x+aNumber:aNumber;													//kv adjust logic
						what = what=="cr"?"cs":"Cs";
					} else if (what == "cs" || what == "Cs") {																	// y 2nd Point
						//kv cube.s = what=="cs"?position.y+aNumber:aNumber-startPosition.y;
						cube.s = what=="cs"?startPosition.y+aNumber:aNumber;													//kv adjust logic
						//points.push([cube.r, cube.s]);																		//kv adjust logic
						//[controlX, controlY, circleX, circleY, rect1X, rect1Y, rect2X, rect2Y, controlType],					//kv debug
						var lastPoint = points[points.length-1];
						if (points.length == 1) {lastPoint[2] = 0; lastPoint[3] = 0; lastPoint[4] = 0; lastPoint[5] = 0};		//kv adjust logic
						lastPoint[6] = cube.x-lastPoint[0];
						lastPoint[7] = cube.y-lastPoint[1];
						lastPoint[8] = "free";
						position.x = cube.r;
						position.y = cube.s;
						points[points.length] = [
							position.x, position.y,
							0, 0,
							cube.z-position.x, cube.q-position.y,
							0,0,
							"free"
						];
						what = what=="cs"?"cx":"Cx";
					}

					// // Arc - TODO - equation does not seem to work
					// // https://github.com/colinmeinke/svg-arc-to-cubic-bezier/issues/7
					// // rx ry x-axis-rotation large-arc-flag sweep-flag x y
					// if (what == "ax" || what == "Ax") {
					// 	arc.x = aNumber; // radius x
					// 	what = what=="ax"?"ay":"Ay";
					// } else if (what == "ay" || what == "Ay") {
					// 	arc.y = aNumber; // radius y
					// 	what = what=="ay"?"az":"Az";
					// } else if (what == "az" || what == "Az") {
					// 	arc.z = aNumber; // x-axis-rotation
					// 	what = what=="az"?"aq":"Aq";
					// } else if (what == "aq" || what == "Aq") {
					// 	arc.q = aNumber; // large-arc-flag
					// 	what = what=="aq"?"ar":"Ar";
					// } else if (what == "ar" || what == "Ar") {
					// 	arc.r = aNumber; // sweep-flag
					// 	what = what=="ar"?"as":"As";
					// } else if (what == "as" || what == "As") {
					// 	arc.s = what=="as"?position.x+aNumber:aNumber-startPosition.x;
					// 	//zog(arc.s)
					// 	what = what=="as"?"at":"At";
					// } else if (what == "at" || what == "At") {
					// 	arc.t = what=="at"?position.y+aNumber:aNumber-startPosition.y;
					// 	//zog(arc.t)
					// 	// rx ry x-axis-rotation large-arc-flag sweep-flag x y
					//
					// 	zta(arc)
					// 	var curves = arcToBezier({
					// 	  px: position.x,
					// 	  py: position.y,
					// 	  cx: arc.s,
					// 	  cy: arc.t,
					// 	  rx: arc.x,
					// 	  ry: arc.y,
					// 	  xAxisRotation: arc.z,
					// 	  largeArcFlag: arc.q,
					// 	  sweepFlag: arc.r,
					// 	});
					//
					// 	//zta(curves)
					//
					// 	loop(curves, function (curve) {
					// 		lastPoint = points[points.length-1];
					// 		lastPoint[6] = curve.x1-position.x;
					// 		lastPoint[7] = curve.y1-position.y;
					// 		lastPoint[8] = "free";
					// 		//zog(curve.x, curve.y)
					// 		position.x = curve.x;
					// 		position.y = curve.y;
					// 		points[points.length] = [
					// 			position.x, position.y,
					// 			0, 0,
					// 			curve.x2-position.x, curve.y2-position.y,
					// 			0,0,
					// 			"free"
					// 		];
					// 	});
					// 	what = what=="at"?"ax":"Ax";
					// }
				}
				else {
					aCommand.push(command);													// kv adjust logic

					// Commands
					if (command != "s") {
						adding = false;
					} 								// kv adjust logic
					if (aCommand.length > 1) {												// kv adjust logic
						// if (aCommand[aCommand.length-2] != command) {
						if (command=="M" || command=="m") {
							makeShape(aCommand);
							if (command=="M") {startPosition.x = 0; startPosition.y=0}
							else {
								startPosition.x = points[points.length-1][0]; startPosition.y=points[points.length-1][1];
							};
							points = [];
							aCommand = [];
							aCommand.push(command)
						}
					};																		// kv adjust logic

					if (command=="M") {
						what = "X";
					} else if (command=="m") {
						what = "x";
					} else if (command=="L") {
						what = "Lx";
						if (splitTypes && dataType && (dataType != "l")) makeShape(aCommand);
						dataType = "l";
					} else if (command=="l") {
						what = "lx";
						if (splitTypes && dataType && (dataType != "l")) makeShape(aCommand);
						dataType = "l";
					} else if (command=="H") {
						what = "H";
						if (splitTypes && dataType && (dataType != "l")) makeShape(aCommand);
						dataType = "l";
					} else if (command=="h") {
						what = "h";
						if (splitTypes && dataType && (dataType != "l")) makeShape(aCommand);
						dataType = "l";
					} else if (command=="V") {
						what = "V";
						if (splitTypes && dataType && (dataType != "l")) makeShape(aCommand);
						dataType = "l";
					} else if (command=="v") {
						what = "v";
						if (splitTypes && dataType && (dataType != "l")) makeShape(aCommand);
						dataType = "l";
					} else if (command=="C") {
						what = "Cx";
						if (splitTypes && dataType && (dataType != "c")) makeShape(aCommand);
						dataType = "c";
					} else if (command=="c") {
						what = "cx";
						if (splitTypes && dataType && (dataType != "c")) makeShape(aCommand);
						dataType = "c";
					} else if (command=="S") {
						adding = true;
						what = "Cx";
						if (splitTypes && dataType && (dataType != "c")) makeShape(aCommand);
						dataType = "c";
					} else if (command=="s") {
						adding = true;
						what = "cx";
						if (splitTypes && dataType && (dataType != "c")) makeShape(aCommand);
						dataType = "c";
					} else if (command=="Q") {
						what = "Qx";
						if (splitTypes && dataType && (dataType != "q")) makeShape(aCommand);
						dataType = "q";
					} else if (command=="q") {
						what = "qx";
						if (splitTypes && dataType && (dataType != "q")) makeShape(aCommand);
						dataType = "q";
					} else if (command=="T") {
						adding = true;
						what = "Qx";
						if (splitTypes && dataType && (dataType != "q")) makeShape(aCommand);
						dataType = "q";
					} else if (command=="t") {
						adding = true;
						what = "qx";
						if (splitTypes && dataType && (dataType != "q")) makeShape(aCommand);
						dataType = "q";
					} else if (command=="A") {
						type = null;
					// 	what = "Ax";
					// 	if (splitTypes && dataType && (dataType != "a")) makeShape();
					// 	dataType = "a";
					// } else if (command=="a") {
					// 	what = "ax";
					// 	if (splitTypes && dataType && (dataType != "a")) makeShape();
					// 	dataType = "a";
					} else if (command=="z" || command=="Z") {
						type = "blob";
					}

				}	// end of Command process

			}); // end of data loop

			function makeShape(myCommand, interest) {
				var myCommand;
				//var shape;																		//kv adjust logic
				lastCommand = aCommand[aCommand.length-1];																//kv adjust logic
				if (points.length >= 2)
					// M 100 350 l 150 -300
					if (lastCommand == "z" || lastCommand == "Z") {type = "blob"};										//kv adjust logic
					//if (zot(shape)) {																					//kv adjust logic
						if (type == "squiggle") shape = new zim.Squiggle(s, ss, points);
						else shape = new zim.Blob(f, s, ss, points);
						shape.loc(0,0,that);																					//kv adjust logic
					//} else {																							//kv adjust logic
					//	var dataPointsArray = [];																		//kv adjust logic
					//	dataPointsArray = shape.recordPoints().concat(points);											//kv adjust logic
					//	//shape.removeFrom();																			//kv adjust logic
					//	if (type == "squiggle") shape = new Squiggle(s, ss, dataPointsArray)							//kv adjust logic
					//	else shape = new Blob(f, s, ss, dataPointsArray)												//kv adjust logic
					//};
					//kv shape.loc(startPosition.x, startPosition.y, that);												//kv adjust logic
					//kv startPosition.x = startPosition.x + position.x;												//kv adjust logic
					//kv startPosition.y = startPosition.y + position.y;												//kv adjust logic
					lastCommand = aCommand[aCommand.length-1];															//kv adjust logic
					previousCommand = aCommand[aCommand.length-2];														//kv adjust logic
					if (commandsRelative.indexOf(lastCommand) >= 0) {
						//if (aCommand[aCommand.length-1] == "m") {														//kv adjust logic
						lastTempPoint[0] = points[points.length-1][0]; lastTempPoint[1] = points[points.length-1][1];	//kv adjust logic
						startPosition.x = points[points.length-1][0]; startPosition.y = points[points.length-1][1];		//kv adjust logic
						points = [];																					// LATEST CHANGES
						points.push([lastTempPoint[0], lastTempPoint[1]]);												//kv adjust logic
					} else {lastTempPoint = [0,0]; points = [[0,0]]};

					aCommand = [];																						//kv adjust logic
					if (lastCommand != "z" && lastCommand != "Z") aCommand.push(lastCommand);							//kv adjust logic

					position.x = 0;
					position.y = 0;
					//kv points = [[0,0]];

				var transform = path.getAttribute("transform");
				if (transform || currentTransform) processTransform(shape, transform || currentTransform);
			};

			if (make) makeShape();
			return points;

		} // end process path

		that.processPath = function(path) {
			return processPath(path,false);
		}

		if (style!==false) zimStyleTransforms(this, DS); // global function - would have put on DisplayObject if had access to it
		this.clone = function() {
			return that.cloneProps(new zim.SVGContainer(svg, splitTypes, geometric, style, this.group, inherit));
		}
	}
	zim.extend (zim.SVGContainer, zim.Container, "clone", "zimContainer", false);
	//-50.95


// SUBSECTION ZIM SHAPES

/*--
zim.Circle = function(radius, color, borderColor, borderWidth, dashed, percent, strokeObj, style, group, inherit)

Circle
zim class - extends a zim.Container which extends a createjs.Container

DESCRIPTION
Makes a circle shape inside a container.
The registration and origin will be the center.
NOTE: mouseChildren is turned to false for all zim Shape containers.

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var circle = new Circle(50, "red");
circle.center(stage);

// or with 10 pixel grey stroke
var circle = new Circle(50, "red", "#666", 10);

// fill the circle with a radial gradient fill
circle.colorCommand.radialGradient([yellow,green], [0, .7], 0, 0, 20, 0, 0, 50);

// make a half circle - or any percent of a circle
var semi = new Circle({radius:200, color:pink, percent:50}).center();
END EXAMPLE

PARAMETERS
** supports DUO - parameters or single object with properties below
** supports VEE - parameters marked with ZIM VEE mean a zim Pick() object or Pick Literal can be passed
   Pick Literal formats: [1,3,2] - random; {min:10, max:20} - range; series(1,2,3) - order, function(){return result;} - function
** supports OCT - parameter defaults can be set with STYLE control (like CSS)
radius - |ZIM VEE| (default 50) the radius (from the center to the edge or half the diameter) ;-)
color - |ZIM VEE| (default "black") the fill color as any CSS color including "rgba()" for alpha fill (set a to 0 for tranparent fill)
borderColor - |ZIM VEE| (default null) the stroke color
borderWidth - |ZIM VEE| (default 1 if stroke is set) the size of the stroke in pixels
dashed - (default false) set to true for dashed border (if borderWidth or borderColor set)
percent - (default 100) set to a percentage of a circle (arc) - registration stays at radius center, bounds shrink to arc
strokeObj - (default {caps:"butt", joints:"miter", miterLimit:10, ignoreScale:false}) set to adjust stroke properties
	// note, not all applicable to a Circle - perhaps just ignoreScale...
	caps options: "butt", "round", "square" or 0,1,2
	joints options: "miter", "round", "bevel" or 0,1,2
	miterLimit is the ration at which the mitered joint will be clipped
	ignoreScale set to true will draw the specified line thickness regardless of object scale
style - (default true) set to false to ignore styles set with the STYLE - will receive original parameter defaults
group - (default null) set to String (or comma delimited String) so STYLE can set default styles to the group(s) (like a CSS class)
inherit - (default null) used internally but can receive an {} of styles directly

METHODS
linearGradient([colors],[ratios], x0,y0, x1,y1) - shortcut to colorCommand linearGradient method (see properties below)
radialGradient([colors],[ratios], x0,y0,radius0, x1,y1,radius1) - shortcut to colorCommand radialGradient method (see properties below)
setColorRange(color1, color2) - set a color range for shape - used by colorRange property - returns obj for chaining
	if one color is used, the current color is used and color1 is the second color in the range
cache(see Container docs for parameter description) - overrides CreateJS cache() and returns object for chaining
	Leave parameters blank to cache bounds of shape (plus outer edge of border if borderWidth > 0)
hasProp(property as String) - returns true if property exists on object else returns false
clone() - makes a copy of the shape
dispose() - removes from parent, removes event listeners - must still set outside references to null for garbage collection

ALSO: ZIM 4TH adds all the methods listed under Container (see above), such as:
drag(), hitTestRect(), animate(), sca(), reg(), mov(), center(), centerReg(),
addTo(), removeFrom(), loop(), outline(), place(), pos(), alp(), rot(), setMask(), etc.
ALSO: See the CreateJS Easel Docs for Container methods, such as:
on(), off(), getBounds(), setBounds(), uncache(), updateCache(), dispatchEvent(),
addChild(), removeChild(), addChildAt(), getChildAt(), contains(), removeAllChildren(), etc.

PROPERTIES
type - holds the class name as a String
shape - gives access to the circle shape
color - get and set the fill color
colorRange - if setColorRange() is used, the colorRange is a ratio (0-1) between the colors
	setting the colorRange will change the color property of the shape
	for instance, shape.setColorRange(blue, pink) then shape.colorRange = .5
	will set the color of the shape to half way between blue and pink
	shape.animate({color:red}, 1000); is a shortcut to animate the colorRange
	shape.wiggle("colorRange", .5, .2, .5, 1000, 5000) will wiggle the colorRange
colorCommand - access to the CreateJS fill command for bitmap, linearGradient and radialGradient fills
	eg. var shape = new Circle(20);
	// colors,ratios, x0,y0,radius0, x1,y1,radius1
	// purple on outside with pink highlight right top corner
	shape.colorCommand.radialGradient([purple,pink],[0,.8], 0,0,20, 5,-8,0);
	See: https://www.createjs.com/docs/easeljs/classes/Graphics.Fill.html
borderColor - get and set the stroke color
borderColorCommand - access to the CreateJS stroke command for bitmap, linearGradient and radialGradient strokes
	See: https://www.createjs.com/docs/easeljs/classes/Graphics.Stroke.html
borderWidth - get and set the stroke size in pixels
borderWidthCommand - access to the CreateJS stroke style command (width, caps, joints, miter, ignoreScale)
	See: https://www.createjs.com/docs/easeljs/classes/Graphics.StrokeStyle.html
borderDashedCommand - access to the CreateJS stroke dashed command (segments, offset)
	see https://www.createjs.com/docs/easeljs/classes/Graphics.StrokeDash.html
radius - gets or sets the radius.
	The radius is independent of scaling and can be different than the width/2
	Setting the radius redraws the circle but any current scaling is kept
** setting widths, heights adjusts scale not bounds and getting these uses the bounds dimension times the scale
width - gets or sets the width. Setting the width will scale the height to keep proportion (see widthOnly below)
height - gets or sets the height. Setting the height will scale the width to keep proportion (see heightOnly below)
widthOnly - gets or sets the width.  This sets only the width and may change the aspect ratio of the object
heightOnly - gets or sets the height.  This sets only the height and may change the aspect ratio of the object
mouseChildren - set to false so you do not drag the shape inside the circle
	if you nest things inside and want to drag them, will want to set to true
blendMode - how the object blends with what is underneath - such as "difference", "multiply", etc. same as CreateJS compositeOperation
group - used when the object is made to add STYLE with the group selector (like a CSS class)

ALSO: See the CreateJS Easel Docs for Container properties, such as:
x, y, rotation, scaleX, scaleY, regX, regY, skewX, skewY,
alpha, cursor, shadow, mouseChildren, mouseEnabled, parent, numChildren, etc.

EVENTS
See the CreateJS Easel Docs for Container events, such as:
added, click, dblclick, mousedown, mouseout, mouseover, pressmove, pressup, removed, rollout, rollover
--*///+51
	zim.Circle = function(radius, color, borderColor, borderWidth, dashed, percent, strokeObj, style, group, inherit) {
		var sig = "radius, color, borderColor, borderWidth, dashed, percent, strokeObj, style, group, inherit";
		var duo; if (duo = zob(zim.Circle, arguments, sig, this)) return duo;
		z_d("51");
		this.zimContainer_constructor(null,null,null,null,false);
		this.type = "Circle";
		this.group = group;
		var DS = style===false?{}:zim.getStyle(this.type, this.group, inherit);
		if (zot(radius)) radius = DS.radius!=null?DS.radius:50;
		if (zot(dashed)) dashed = DS.dashed!=null?DS.dashed:false;
		if (zot(borderColor)) borderColor = DS.borderColor!=null?DS.borderColor:null;
		if (zot(borderWidth)) borderWidth = DS.borderWidth!=null?DS.borderWidth:null;
		if (borderColor < 0 || borderWidth < 0) borderColor = borderWidth = null;
		else if (borderColor!=null && borderWidth==null) borderWidth = 1;
		if (zot(color)) color = DS.color!=null?DS.color:(borderWidth>0?"rgba(0,0,0,0)":"black");
		if (zot(percent)) percent = DS.percent!=null?DS.percent:100;
		if (zot(strokeObj)) strokeObj = DS.strokeObj!=null?DS.strokeObj:{};

		// PICK
		var oa = remember(radius, color, borderColor, borderWidth, percent);
		function remember() {return arguments;} // for cloning PICK
		radius = zim.Pick.choose(radius);
		color = zim.Pick.choose(color);
		borderColor = zim.Pick.choose(borderColor);
		borderWidth = zim.Pick.choose(borderWidth);
		percent = zim.Pick.choose(percent);

		var that = this;
		var _radius = radius;
		var _color = color;
		var _borderColor = borderColor;
		var _borderWidth = borderWidth;
		this.mouseChildren = false;

		var circle = this.shape = new createjs.Shape();
		this.addChild(circle);

		var g = circle.graphics;
		var colorObj;
		var borderColorObj;
		var borderWidthObj;
		var borderDashedObj;
		drawShape();
		function drawShape() {
			g.c();
			that.colorCommand = colorObj = g.f(_color).command;
			// border of 0 or a string value still draws a border in CreateJS
			if (zot(_borderWidth) || _borderWidth > 0) { // no border specified or a border > 0
				if (!zot(_borderColor) || !zot(_borderWidth)) { // either a border color or thickness
					if (zot(_borderColor)) _borderColor = "black";
					that.borderColorCommand = borderColorObj = g.s(_borderColor).command;
					that.borderWidthCommand = borderWidthObj = g.ss(_borderWidth, strokeObj.caps, strokeObj.joints, strokeObj.miterLimit, strokeObj.ignoreScale).command;
					if (dashed) that.borderDashedCommand = borderDashedObj = g.sd([10, 10], 5).command;
				}
			}
			var h = _radius*2;
			if (typeof percent == "number" && percent >= 0 && percent < 100) {
				var p = 360*percent/100/2
				g.arc(0, 0, _radius, (-p-90)*Math.PI/180, (p-90)*Math.PI/180, false).cp();
				h = _radius-Math.cos(p*Math.PI/180)*_radius;
			} else {
				g.dc(0,0,_radius);
			}
			that.setBounds(-_radius,-_radius,_radius*2,h);
		}

		Object.defineProperty(that, 'color', {
			get: function() {
				return _color;
			},
			set: function(value) {
				if (zot(value)) value = "black";
				_color = value;
				colorObj.style = _color;
			}
		});
		var startColor;
		var endColor;
		this.setColorRange = function(color1, color2) {
			if (zot(color2)) {
				startColor = that.color;
				endColor = color1;
			} else if (zot(color1)) {
				startColor = that.color;
				endColor = color2;
			} else {
				startColor = color1;
				endColor = color2;
			}
			return that;
		}
		var _colorRange = 0;
		Object.defineProperty(that, 'colorRange', {
			get: function() {
				return _colorRange;
			},
			set: function(value) {
				_colorRange = value;
				if (!zot(startColor) && !zot(endColor)) {
					that.color = zim.colorRange(startColor, endColor, value);
				}
			}
		});
		Object.defineProperty(that, 'borderColor', {
			get: function() {
				return _borderColor;
			},
			set: function(value) {
				_borderColor = value;
				if (!borderColorObj) drawShape();
				else borderColorObj.style = _borderColor;
			}
		});
		Object.defineProperty(that, 'borderWidth', {
			get: function() {
				return _borderWidth;
			},
			set: function(value) {
				if (!(value>0)) value = 0;
				_borderWidth = value;
				if (!borderWidthObj || _borderWidth == 0) drawShape();
				else {
					borderWidthObj.width = _borderWidth;
					if (dashed) {
						borderDashedObj.segments = [20, 10];
						borderDashedObj.offset = 5;
					}
				}
			}
		});
		Object.defineProperty(that, 'radius', {
			get: function() {
				return _radius;
			},
			set: function(value) {
				_radius = value;
				drawShape();
			}
		});
		if (style!==false) zimStyleTransforms(this, DS); // global function - would have put on DisplayObject if had access to it

		this.linearGradient = function(colors,ratios,x0,y0,x1,y1) {
			this.linearGradientParams = Array.prototype.slice.call(arguments);
			this.colorCommand.linearGradient(colors,ratios,x0,y0,x1,y1);
			return this;
		}
		this.radialGradient = function(colors,ratios,x0,y0,radius0,x1,y1,radius1) {
			this.radialGradientParams = Array.prototype.slice.call(arguments);
			this.colorCommand.radialGradient(colors,ratios,x0,y0,radius0,x1,y1,radius1);
			return this;
		}

		this.clone = function(exact) {
			var newShape = that.cloneProps(
				exact?new zim.Circle(that.radius, that.color, that.borderColor, that.borderWidth, dashed, percent, strokeObj, style, this.group, inherit)
				:new zim.Circle(oa[0],oa[1],oa[2],oa[3], dashed,oa[4], style, this.group, inherit)
			);
			if (that.linearGradientParams) newShape.linearGradient.apply(newShape, that.linearGradientParams);
			if (that.radialGradientParams) newShape.radialGradient.apply(newShape, that.linearGradientParams);
			return newShape;
		}
	}
	zim.extend(zim.Circle, zim.Container, "clone", "zimContainer", false);
	//-51

/*--
zim.Rectangle = function(width, height, color, borderColor, borderWidth, corner, dashed, strokeObj, style, group, inherit)

Rectangle
zim class - extends a zim.Container which extends a createjs.Container

DESCRIPTION
Makes a rectangle shape inside a container.
The registration and origin will be top left corner.
NOTE: mouseChildren is turned to false for all zim Shape containers.

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var rect = new Rectangle(200, 100, "blue");
rect.center(stage);

// or with rounded corners:
var rect = new Rectangle({width:200, height:100, color:"blue", corner:20});

// or with 2 pixel white stroke
var rect = new Rectangle(200, 100, "blue", "white", 2);

// fill the rectangle with a Bitmap fill assuming icon has been loaded - not the image property
rect.colorCommand.bitmap(frame.asset("icon.png").image);
END EXAMPLE

PARAMETERS
** supports DUO - parameters or single object with properties below
** supports VEE - parameters marked with ZIM VEE mean a zim Pick() object or Pick Literal can be passed
   Pick Literal formats: [1,3,2] - random; {min:10, max:20} - range; series(1,2,3) - order, function(){return result;} - function
** supports OCT - parameter defaults can be set with STYLE control (like CSS)
width - |ZIM VEE| (default the height if provided else 100) the width
height - |ZIM VEE| (default the width if provided else 100) the height
color - |ZIM VEE| (default "black") the fill color as any CSS color including "rgba()" for alpha fill (set a to 0 for tranparent fill)
borderColor - |ZIM VEE| (default null) the stroke color
borderWidth - |ZIM VEE| (default 1 if stroke is set) the size of the stroke in pixels
corner - (default 0) the round of corner
	can also be an array of [topLeft, topRight, bottomRight, bottomLeft]
dashed - (default false) set to true for dashed border (if borderWidth or borderColor set)
strokeObj - (default {caps:"butt", joints:"miter", miterLimit:10, ignoreScale:false}) set to adjust stroke properties
	caps options: "butt", "round", "square" or 0,1,2
	joints options: "miter", "round", "bevel" or 0,1,2
	miterLimit is the ration at which the mitered joint will be clipped
	ignoreScale set to true will draw the specified line thickness regardless of object scale
style - (default true) set to false to ignore styles set with the STYLE - will receive original parameter defaults
group - (default null) set to String (or comma delimited String) so STYLE can set default styles to the group(s) (like a CSS class)
inherit - (default null) used internally but can receive an {} of styles directly

METHODS
linearGradient([colors],[ratios], x0,y0, x1,y1) - shortcut to colorCommand linearGradient method (see properties below)
radialGradient([colors],[ratios], x0,y0,radius0, x1,y1,radius1) - shortcut to colorCommand radialGradient method (see properties below)
setColorRange(color1, color2) - set a color range for shape - used by colorRange property - returns obj for chaining
	if one color is used, the current color is used and color1 is the second color in the range
cache(see Container docs for parameter description) - overrides CreateJS cache() and returns object for chaining
	Leave parameters blank to cache bounds of shape (plus outer edge of border if borderWidth > 0)
hasProp(property as String) - returns true if property exists on object else returns false
clone(exact) - makes a copy of the shape
	exact defaults to false and will use ZIM VEE when cloning - set to true to not use ZIM VEE and make an exact copy
	eg. Tile() could make different dimension shapes each time if ZIM VEE is used for dimension
dispose() - removes from parent, removes event listeners - must still set outside references to null for garbage collection

ALSO: ZIM 4TH adds all the methods listed under Container (see above), such as:
drag(), hitTestRect(), animate(), sca(), reg(), mov(), center(), centerReg(),
addTo(), removeFrom(), loop(), outline(), place(), pos(), alp(), rot(), setMask(), etc.
ALSO: See the CreateJS Easel Docs for Container methods, such as:
on(), off(), getBounds(), setBounds(), uncache(), updateCache(), dispatchEvent(),
addChild(), removeChild(), addChildAt(), getChildAt(), contains(), removeAllChildren(), etc.

PROPERTIES
type - holds the class name as a String
shape - gives access to the rectangle shape
color - get and set the fill color
colorRange - if setColorRange() is used, the colorRange is a ratio (0-1) between the colors
	setting the colorRange will change the color property of the shape
	for instance, shape.setColorRange(blue, pink) then shape.colorRange = .5
	will set the color of the shape to half way between blue and pink
	shape.animate({color:red}, 1000); is a shortcut to animate the colorRange
	shape.wiggle("colorRange", .5, .2, .5, 1000, 5000) will wiggle the colorRange
colorCommand - access to the CreateJS fill command for bitmap, linearGradient and radialGradient fills
	eg. shape.colorCommand.linearGradient([green, blue ,green], [.2, .5, .8], 0, 0, shape.width, 0)
	See: https://www.createjs.com/docs/easeljs/classes/Graphics.Fill.html
borderColor - get and set the stroke color
borderColorCommand - access to the CreateJS stroke command for bitmap, linearGradient and radialGradient strokes
	See: https://www.createjs.com/docs/easeljs/classes/Graphics.Stroke.html
borderWidth - get and set the stroke size in pixels
borderWidthCommand - access to the CreateJS stroke style command (width, caps, joints, miter, ignoreScale)
	See: https://www.createjs.com/docs/easeljs/classes/Graphics.StrokeStyle.html
borderDashedCommand - access to the CreateJS stroke dashed command (segments, offset)
	see https://www.createjs.com/docs/easeljs/classes/Graphics.StrokeDash.html
** setting widths and heights adjusts scale not bounds and getting these uses the bounds dimension times the scale
width - gets or sets the width. Setting the width will scale the height to keep proportion (see widthOnly below)
height - gets or sets the height. Setting the height will scale the width to keep proportion (see heightOnly below)
widthOnly - gets or sets the width.  This sets only the width and may change the aspect ratio of the object
heightOnly - gets or sets the height.  This sets only the height and may change the aspect ratio of the object
depth - for ZIM VR - the depth used to shift left and right channel and for parallax in VR - also see dep() ZIM Display method
mouseChildren - set to false so  you do not drag the shape inside the rectangle
	if you nest things inside and want to drag them, will want to set to true
blendMode - how the object blends with what is underneath - such as "difference", "multiply", etc. same as CreateJS compositeOperation
group - used when the object is made to add STYLE with the group selector (like a CSS class)

ALSO: See the CreateJS Easel Docs for Container properties, such as:
x, y, rotation, scaleX, scaleY, regX, regY, skewX, skewY,
alpha, cursor, shadow, mouseChildren, mouseEnabled, parent, numChildren, etc.

EVENTS
See the CreateJS Easel Docs for Container events, such as:
added, click, dblclick, mousedown, mouseout, mouseover, pressmove, pressup, removed, rollout, rollover
--*///+52
	zim.Rectangle = function(width, height, color, borderColor, borderWidth, corner, dashed, strokeObj, style, group, inherit) {
		var sig = "width, height, color, borderColor, borderWidth, corner, dashed, strokeObj, style, group, inherit";
		var duo; if (duo = zob(zim.Rectangle, arguments, sig, this)) return duo;
		z_d("52");
		this.zimContainer_constructor(null,null,null,null,false);
		this.type = "Rectangle";
		this.group = group;

	    var DS = style===false?{}:zim.getStyle(this.type, this.group, inherit);

	   	if (zot(width)) width = DS.width!=null?DS.width:null;
		if (zot(height)) height = DS.height!=null?DS.height:!zot(width)?width:100;
		if (zot(width)) width = height;
		if (zot(corner)) corner = DS.corner!=null?DS.corner:0;
		if (zot(dashed)) dashed = DS.dashed!=null?DS.dashed:false;
		if (zot(borderColor)) borderColor = DS.borderColor!=null?DS.borderColor:null;
		if (zot(borderWidth)) borderWidth = DS.borderWidth!=null?DS.borderWidth:null;
		if (borderColor < 0 || borderWidth < 0) borderColor = borderWidth = null;
		else if (borderColor!=null && borderWidth==null) borderWidth = 1;
		if (zot(color)) color = DS.color!=null?DS.color:(borderWidth>0?"rgba(0,0,0,0)":"black");
		if (zot(strokeObj)) strokeObj = DS.strokeObj!=null?DS.strokeObj:{};

		// PICK
		var oa = remember(width, height, color, borderColor, borderWidth);
		function remember() {return arguments;} // for cloning PICK
		width = zim.Pick.choose(width);
		height = zim.Pick.choose(height);
		color = zim.Pick.choose(color);
		borderColor = zim.Pick.choose(borderColor);
		borderWidth = zim.Pick.choose(borderWidth);

		var that = this;
		var _color = color;
		var _borderColor = borderColor;
		var _borderWidth = borderWidth;
		this.mouseChildren = false;

		var rectangle = this.shape = new createjs.Shape();
		this.addChild(rectangle);

		var g = rectangle.graphics;
		var colorObj;
		var borderColorObj;
		var borderWidthObj;
		drawShape();
		function drawShape() {
			g.c();
			that.colorCommand = colorObj =g.f(_color).command;
			// border of 0 or a string value still draws a border in CreateJS
			if (zot(_borderWidth) || _borderWidth > 0) { // no border specified or a border > 0
				if (!zot(_borderColor) || !zot(_borderWidth)) { // either a border color or thickness
					if (zot(_borderColor)) _borderColor = "black";
					that.borderColorCommand = borderColorObj = g.s(_borderColor).command;
					that.borderWidthCommand = borderWidthObj = g.ss(_borderWidth, strokeObj.caps, strokeObj.joints, strokeObj.miterLimit, strokeObj.ignoreScale).command;
					if (dashed) that.borderDashedCommand = borderDashedObj = g.sd([10, 10], 5).command;
				}
			}
			if (Array.isArray(corner)) {
				g.rc(0,0,width,height,corner[0],corner[1],corner[2],corner[3]);
			} else if (corner > 0) {
				g.rr(0,0,width,height,corner);
			} else {
				g.r(0,0,width,height);
			}

			that.setBounds(0,0,width,height);
		}

		Object.defineProperty(that, 'color', {
			get: function() {
				return _color;
			},
			set: function(value) {
				if (zot(value)) value = "black";
				_color = value;
				colorObj.style = _color;
			}
		});
		var startColor;
		var endColor;
		this.setColorRange = function(color1, color2) {
			if (zot(color2)) {
				startColor = that.color;
				endColor = color1;
			} else if (zot(color1)) {
				startColor = that.color;
				endColor = color2;
			} else {
				startColor = color1;
				endColor = color2;
			}
			return that;
		}
		var _colorRange = 0;
		Object.defineProperty(that, 'colorRange', {
			get: function() {
				return _colorRange;
			},
			set: function(value) {
				_colorRange = value;
				if (!zot(startColor) && !zot(endColor)) {
					that.color = zim.colorRange(startColor, endColor, value);
				}
			}
		});
		Object.defineProperty(that, 'borderColor', {
			get: function() {
				return _borderColor;
			},
			set: function(value) {
				_borderColor = value;
				if (!borderColorObj) drawShape();
				else borderColorObj.style = _borderColor;
			}
		});
		Object.defineProperty(that, 'borderWidth', {
			get: function() {
				return _borderWidth;
			},
			set: function(value) {
				if (!(value>0)) value = 0;
				_borderWidth = value;
				if (!borderWidthObj || _borderWidth == 0) drawShape();
				else {
					borderWidthObj.width = _borderWidth;
					if (dashed) {
						borderDashedObj.segments = [20, 10];
						borderDashedObj.offset = 5;
					}
				}
			}
		});

		this.linearGradient = function(colors,ratios,x0,y0,x1,y1) {
			this.linearGradientParams = Array.prototype.slice.call(arguments);
			this.colorCommand.linearGradient(colors,ratios,x0,y0,x1,y1);
			return this;
		}
		this.radialGradient = function(colors,ratios,x0,y0,radius0,x1,y1,radius1) {
			this.radialGradientParams = Array.prototype.slice.call(arguments);
			this.colorCommand.radialGradient(colors,ratios,x0,y0,radius0,x1,y1,radius1);
			return this;
		}

		if (style!==false) zimStyleTransforms(this, DS);
		this.clone = function(exact) {
			var newShape =  that.cloneProps(
				exact?new zim.Rectangle(width, height, that.color, that.borderColor, that.borderWidth, corner, dashed, strokeObj, style, this.group, inherit)
				:new zim.Rectangle(oa[0],oa[1],oa[2],oa[3],oa[4], corner, dashed, strokeObj, style, this.group, inherit)
			);
			if (that.linearGradientParams) newShape.linearGradient.apply(newShape, that.linearGradientParams);
			if (that.radialGradientParams) newShape.radialGradient.apply(newShape, that.linearGradientParams);
			return newShape;
		}
	}
	zim.extend(zim.Rectangle, zim.Container, "clone", "zimContainer", false);
	//-52

/*--
zim.Triangle = function(a, b, c, color, borderColor, borderWidth, center, adjust, dashed, strokeObj, style, group, inherit)

Triangle
zim class - extends a zim.Container which extends a createjs.Container

DESCRIPTION
Makes a triangle shape inside a container using three line lengths.
Passing one length parameter makes an equilateral triangle.
Passing two length parameters makes an isosceles triangle.
Passing -1 as the last length parameter makes a 90 degree triangle.
NOTE: mouseChildren is turned to false for all zim Shape containers.

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var tri = new Triangle(200, null, null, "green");
tri.center(stage);

// all three sides specified - tall pointy triangle with yellow stroke of 10 pixels
var tri = new Triangle(100, 200, 200, "green", "yellow", 10);

// here we adjust so rotation looks better
var tri = new Triangle({a:200, color:"green", adjust:30});
tri.center(stage);
tri.animate({obj:{rotation:360}, time:3000, ease:"linear", loop:true});

// here we fill the triangle with a linear gradient fill
triangle.colorCommand.linearGradient([green, blue ,green], [.2, .5, .8], 0, 0, triangle.width, 0);
END EXAMPLE

PARAMETERS
** supports DUO - parameters or single object with properties below
** supports VEE - parameters marked with ZIM VEE mean a zim Pick() object or Pick Literal can be passed
   Pick Literal formats: [1,3,2] - random; {min:10, max:20} - range; series(1,2,3) - order, function(){return result;} - function
** supports OCT - parameter defaults can be set with STYLE control (like CSS)
a, b and c - |ZIM VEE| (default 100) the lengths of the sides
	a will run horizontally along the bottom
	b is upwards and c is back to the origin
	if c is set to -1 will assume a 90 angle
color - |ZIM VEE| (default "black") the fill color as any CSS color including "rgba()" for alpha fill (set a to 0 for tranparent fill)
borderColor - |ZIM VEE| (default null) the stroke color
borderWidth - |ZIM VEE| (default 1 if stroke is set) the size of the stroke in pixels
center - (default true) puts the registration point to the center
adjust - (default 0) pixels to bring center towards vertical base
	the actual center is not really the weighted center
dashed - (default false) set to true for dashed border (if borderWidth or borderColor set)
strokeObj - (default {caps:"butt", joints:"miter", miterLimit:10, ignoreScale:false}) set to adjust stroke properties
	caps options: "butt", "round", "square" or 0,1,2
	joints options: "miter", "round", "bevel" or 0,1,2
	miterLimit is the ration at which the mitered joint will be clipped
	ignoreScale set to true will draw the specified line thickness regardless of object scale
style - (default true) set to false to ignore styles set with the STYLE - will receive original parameter defaults
group - (default null) set to String (or comma delimited String) so STYLE can set default styles to the group(s) (like a CSS class)
inherit - (default null) used internally but can receive an {} of styles directly

METHODS
linearGradient([colors],[ratios], x0,y0, x1,y1) - shortcut to colorCommand linearGradient method (see properties below)
radialGradient([colors],[ratios], x0,y0,radius0, x1,y1,radius1) - shortcut to colorCommand radialGradient method (see properties below)
setColorRange(color1, color2) - set a color range for shape - used by colorRange property - returns obj for chaining
	if one color is used, the current color is used and color1 is the second color in the range
cache(see Container docs for parameter description) - overrides CreateJS cache() and returns object for chaining
	Leave parameters blank to cache bounds of shape (plus outer edge of border if borderWidth > 0)
hasProp(property as String) - returns true if property exists on object else returns false
clone() - makes a copy of the shape
dispose() - removes from parent, removes event listeners - must still set outside references to null for garbage collection

ALSO: ZIM 4TH adds all the methods listed under Container (see above), such as:
drag(), hitTestRect(), animate(), sca(), reg(), mov(), center(), centerReg(),
addTo(), removeFrom(), loop(), outline(), place(), pos(), alp(), rot(), setMask(), etc.
ALSO: See the CreateJS Easel Docs for Container methods, such as:
on(), off(), getBounds(), setBounds(), uncache(), updateCache(), dispatchEvent(),
addChild(), removeChild(), addChildAt(), getChildAt(), contains(), removeAllChildren(), etc.

PROPERTIES
type - holds the class name as a String
shape - gives access to the triangle shape
color - get and set the fill color
colorRange - if setColorRange() is used, the colorRange is a ratio (0-1) between the colors
	setting the colorRange will change the color property of the shape
	for instance, shape.setColorRange(blue, pink) then shape.colorRange = .5
	will set the color of the shape to half way between blue and pink
	shape.animate({color:red}, 1000); is a shortcut to animate the colorRange
	shape.wiggle("colorRange", .5, .2, .5, 1000, 5000) will wiggle the colorRange
colorCommand - access to the CreateJS fill command for bitmap, linearGradient and radialGradient fills
	eg. shape.colorCommand.linearGradient([green, blue ,green], [.2, .5, .8], 0, 0, shape.width, 0)
	See: https://www.createjs.com/docs/easeljs/classes/Graphics.Fill.html
borderColor - get and set the stroke color
borderColorCommand - access to the CreateJS stroke command for bitmap, linearGradient and radialGradient strokes
	See: https://www.createjs.com/docs/easeljs/classes/Graphics.Stroke.html
borderWidth - get and set the stroke size in pixels
borderWidthCommand - access to the CreateJS stroke style command (width, caps, joints, miter, ignoreScale)
	See: https://www.createjs.com/docs/easeljs/classes/Graphics.StrokeStyle.html
borderDashedCommand - access to the CreateJS stroke dashed command (segments, offset)
	see https://www.createjs.com/docs/easeljs/classes/Graphics.StrokeDash.html
** setting widths and heights adjusts scale not bounds and getting these uses the bounds dimension times the scale
width - gets or sets the width. Setting the width will scale the height to keep proportion (see widthOnly below)
height - gets or sets the height. Setting the height will scale the width to keep proportion (see heightOnly below)
widthOnly - gets or sets the width.  This sets only the width and may change the aspect ratio of the object
heightOnly - gets or sets the height.  This sets only the height and may change the aspect ratio of the object
depth - for ZIM VR - the depth used to shift left and right channel and for parallax in VR - also see dep() ZIM Display method
one, two, three - read only - points with x, y properties for bottom left, bottom right, top right
angles - read only - Array of angles [bottom left, bottom right, top right]
adjusted - read only - the value of the adjust parameter or 0 if no adjust was supplied
mouseChildren - set to false so  you do not drag the shape inside the triangle
	if you nest things inside and want to drag them, will want to set to true
blendMode - how the object blends with what is underneath - such as "difference", "multiply", etc. same as CreateJS compositeOperation
group - used when the object is made to add STYLE with the group selector (like a CSS class)

ALSO: See the CreateJS Easel Docs for Container properties, such as:
x, y, rotation, scaleX, scaleY, regX, regY, skewX, skewY,
alpha, cursor, shadow, mouseChildren, mouseEnabled, parent, numChildren, etc.

EVENTS
See the CreateJS Easel Docs for Container events, such as:
added, click, dblclick, mousedown, mouseout, mouseover, pressmove, pressup, removed, rollout, rollover
--*///+53
	zim.Triangle = function(a, b, c, color, borderColor, borderWidth, center, adjust, dashed, strokeObj, style, group, inherit) {
		var sig = "a, b, c, color, borderColor, borderWidth, center, adjust, dashed, strokeObj, style, group, inherit";
		var duo; if (duo = zob(zim.Triangle, arguments, sig, this)) return duo;
		z_d("53");
		this.zimContainer_constructor(null,null,null,null,false);
		this.type = "Triangle";
		this.group = group;
		var DS = style===false?{}:zim.getStyle(this.type, this.group, inherit);

		if (zot(a)) a = DS.a!=null?DS.a:100;
		if (zot(b)) b = DS.b!=null?DS.b:a;
		if (zot(c)) c = DS.c!=null?DS.c:b;
		if (c==-1) c = Math.sqrt(Math.pow(a,2)+Math.pow(b,2));
		if (zot(center)) center = DS.center!=null?DS.center:true;
		if (zot(adjust)) adjust = DS.adjust!=null?DS.adjust:0;
		if (zot(borderColor)) borderColor = DS.borderColor!=null?DS.borderColor:null;
		if (zot(borderWidth)) borderWidth = DS.borderWidth!=null?DS.borderWidth:null;
		if (borderColor < 0 || borderWidth < 0) borderColor = borderWidth = null;
		else if (borderColor!=null && borderWidth==null) borderWidth = 1;
		if (zot(color)) color = DS.color!=null?DS.color:(borderWidth>0?"rgba(0,0,0,0)":"black");
		if (zot(adjust)) adjust = DS.adjust!=null?DS.adjust:0;
		if (zot(strokeObj)) strokeObj = DS.strokeObj!=null?DS.strokeObj:{};

		// PICK
		var oa = remember(a, b, c, color, borderColor, borderWidth);
		function remember() {return arguments;} // for cloning PICK
		a = zim.Pick.choose(a);
		b = zim.Pick.choose(b);
		c = zim.Pick.choose(c);
		this.a = a;
		this.b = b;
		this.c = c;
		color = zim.Pick.choose(color);
		borderColor = zim.Pick.choose(borderColor);
		borderWidth = zim.Pick.choose(borderWidth);

		var that = this;
		var _color = color;
		var _borderColor = borderColor;
		var _borderWidth = borderWidth;
		this.mouseChildren = false;

		var lines = [a,b,c];
		lines.sort(function(a, b){return b-a});
		var aa = lines[0];
		var bb = lines[1];
		var cc = lines[2];
		var order = [lines.indexOf(a), lines.indexOf(b), lines.indexOf(c)];

		if (aa > bb+cc) {
			zog("zim display - Triangle(): invalid triangle lengths");
			return;
		}

		var tri = this.shape = new createjs.Shape();
		this.adjusted = adjust;
		this.addChild(tri);

		var g = tri.graphics;
		var colorObj;
		var borderColorObj;
		var borderWidthObj;
		drawShape();
		function drawShape() {
			g.c();
			that.colorCommand = colorObj =g.f(_color).command;
			// border of 0 or a string value still draws a border in CreateJS
			if (zot(_borderWidth) || _borderWidth > 0) { // no border specified or a border > 0
				if (!zot(_borderColor) || !zot(_borderWidth)) { // either a border color or thickness
					if (zot(_borderColor)) _borderColor = "black";
					that.borderColorCommand = borderColorObj = g.s(_borderColor).command;
					that.borderWidthCommand = borderWidthObj = g.ss(_borderWidth, strokeObj.caps, strokeObj.joints, strokeObj.miterLimit, strokeObj.ignoreScale).command;
					if (dashed) that.borderDashedCommand = borderDashedObj = g.sd([10, 10], 5).command;
				}
			}
			g.mt(0,0);
			that.one={x:0,y:0};
			g.lt(a,0);
			that.two={x:a,y:0};

			// find biggest angle with cosine rule
			var angle1 = Math.acos( (Math.pow(bb,2) + Math.pow(cc,2) - Math.pow(aa,2)) / (2 * bb * cc) ) * 180 / Math.PI;

			// use the sine rule for next biggest angle
			var angle2 = Math.asin( bb * Math.sin(angle1 * Math.PI / 180) / aa ) * 180 / Math.PI;

			// find last angle
			var angle3 = 180 - angle1 - angle2;

			// get position of angles by mapping to opposite side sizes
			// as in smallest angle is across from smallest side
			// largest angle is across from largest size, etc.
			var temp = [angle1, angle2, angle3]; // largets to smallest
			that.angles = [temp[order[1]], temp[order[2]], temp[order[0]]];

			var nextAngle = that.angles[1];
			var backX = Math.cos(nextAngle * Math.PI / 180) * b;
			var upY = Math.sin(nextAngle * Math.PI / 180) * b;

			var width = Math.max(a, a-backX);
			var height = upY
			that.setBounds(0,adjust,width,height);
			tri.y = height;

			g.lt(a-backX,0-upY);
			that.three={x:a-backX,y:0-upY};
			g.cp();

			if (center) {
				that.regX = width/2;
				that.regY = height/2;
			}
			if (adjust) {
				that.shape.y+=adjust;
			}
		}

		Object.defineProperty(that, 'color', {
			get: function() {
				return _color;
			},
			set: function(value) {
				if (zot(value)) value = "black";
				_color = value;
				colorObj.style = _color;
			}
		});
		var startColor;
		var endColor;
		this.setColorRange = function(color1, color2) {
			if (zot(color2)) {
				startColor = that.color;
				endColor = color1;
			} else if (zot(color1)) {
				startColor = that.color;
				endColor = color2;
			} else {
				startColor = color1;
				endColor = color2;
			}
			return that;
		}
		var _colorRange = 0;
		Object.defineProperty(that, 'colorRange', {
			get: function() {
				return _colorRange;
			},
			set: function(value) {
				_colorRange = value;
				if (!zot(startColor) && !zot(endColor)) {
					that.color = zim.colorRange(startColor, endColor, value);
				}
			}
		});
		Object.defineProperty(that, 'borderColor', {
			get: function() {
				return _borderColor;
			},
			set: function(value) {
				_borderColor = value;
				if (!borderColorObj) drawShape();
				else borderColorObj.style = _borderColor;
			}
		});
		Object.defineProperty(that, 'borderWidth', {
			get: function() {
				return _borderWidth;
			},
			set: function(value) {
				if (!(value>0)) value = 0;
				_borderWidth = value;
				if (!borderWidthObj || _borderWidth == 0) drawShape();
				else {
					borderWidthObj.width = _borderWidth;
					if (dashed) {
						borderDashedObj.segments = [20, 10];
						borderDashedObj.offset = 5;
					}
				}
			}
		});

		this.linearGradient = function(colors,ratios,x0,y0,x1,y1) {
			this.linearGradientParams = Array.prototype.slice.call(arguments);
			this.colorCommand.linearGradient(colors,ratios,x0,y0,x1,y1);
			return this;
		}
		this.radialGradient = function(colors,ratios,x0,y0,radius0,x1,y1,radius1) {
			this.radialGradientParams = Array.prototype.slice.call(arguments);
			this.colorCommand.radialGradient(colors,ratios,x0,y0,radius0,x1,y1,radius1);
			return this;
		}

		if (style!==false) zimStyleTransforms(this, DS);
		this.clone = function(exact) {
			var newShape = that.cloneProps(
				exact?new zim.Triangle(a, b, c, that.color, that.borderColor, that.borderWidth, center, adjust, dashed, strokeObj, style, this.group, inherit)
				:new zim.Triangle(oa[0],oa[1],oa[2],oa[3],oa[4],oa[5], center, adjust, dashed, strokeObj, style, this.group, inherit)
			);
			if (that.linearGradientParams) newShape.linearGradient.apply(newShape, that.linearGradientParams);
			if (that.radialGradientParams) newShape.radialGradient.apply(newShape, that.linearGradientParams);
			return newShape;
		}
	}
	zim.extend(zim.Triangle, zim.Container, "clone", "zimContainer");
	//-53

/*--
zim.Squiggle = function(color, thickness, points, length, controlLength, controlType, lockControlType, showControls, lockControls, handleSize, allowToggle, move, dashed, onTop, stickColor, selectColor, selectPoints, editPoints, interactive, strokeObj, style, group, inherit)

Squiggle
zim class - extends a zim.Container which extends a createjs.Container

DESCRIPTION
Makes a squiggly line with a number of points.
The points have Bezier controls - little handles that change the shape of the line.
The type of control can be specified overall and individually - and can be hidden or shown
The type of control can be changed by double clicking the point - colors of the handles will change
Points can be added by clicking on the line or removed by SHIFT clicking a point.
CTRL Z will undo adding or removing a point
The shape of the line can be recorded with the recordData() method and recreated with the setData() method
The Squiggle is set by default to show and hide controls when clicked
It is also draggable by default when the controls are showing
It can be set to copy with a shift click

MULTIPLE SELECT
Multiple points can be selected and dragged or moved with the keyboard arrows (moves 10 pixels with shift key down)

NOTE: mouseChildren is turned to false for all zim Shape containers.

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var squiggle = new Squiggle().center(); // makes a line with default 4 points with Bezier controls
var line = new Squiggle({points:2, controlType:"none"}).pos(100,100); // makes a diagonal straight line that is editable
END EXAMPLE

EXAMPLE
// Animate along a Squiggle
// see https://zimjs.com/explore/squiggleAnimate.html for more
var line = new Squiggle().center();
new Circle(10, red).addTo().animate({path:line}, 1000);
END EXAMPLE

PARAMETERS
** supports DUO - parameters or single object with properties below
** supports VEE - parameters marked with ZIM VEE mean a zim Pick() object or Pick Literal can be passed
   Pick Literal formats: [1,3,2] - random; {min:10, max:20} - range; series(1,2,3) - order, function(){return result;} - function
** supports OCT - parameter defaults can be set with STYLE control (like CSS)
color - (default green) the line color as any CSS color including "rgba()" for alpha
thickness - (default 2) the thickness of the line in pixels
points - (default 4)a number of points to start with to make the shape
	OR an SVG path like: points:"M0,129.5c22,0,40-31,40-41c0-8-3.2-13-10-13" etc. (also see SVGContainer)
	OR an array of points as follows:
	[[controlX, controlY, circleX, circleY, rect1X, rect1Y, rect2X, rect2Y, controlType], [etc]]
	controlX and controlY - the x and y location of the control Container which holds the point circle and the two control rectangles
	rect1X, rect1Y, rect2X, rect2Y - (default based on controlLength) the x and y location of the control rectangles relative to the control location
	circleX and circleY - (default 0) the x and y location of the circle relative to the control location (usually 0, 0)
	controlType - (default main controlType parameter or "straight" if not controlType parameter) the point's controlType "none", "mirror", "straight" or "free"
length - (default 300) the default length of line used to create the squiggle (also specifies the squiggle's bounds(0, 0, length, thickness))
controlLength - |ZIM VEE| (default radius*numPoints/4) specify a Number to override the calculated default
controlType - (default "straight") one of four String values as follows:
	none - there are no control rectangles (they are actually set at 0,0).  This makes a corner at the circle point.
	mirror - the control rectangles reflect one another about the point circle - lengths are kept even
	straight - the control rectangles keep a straight line through the point circle but length is independent
	free - the control rectangle moves independently from the other control rectangle
	** The controlType can be specified for each point - see the points parameter
	** The controlType can be changed by doubleClicking the point circle to cycle through the controls in the order above - unless the lockControlType is set to true
lockControlType - (default false) set to true to disable doubleClicking of point circles to change controlType
showControls - (default true) set to false to start with controls not showing - can change this after with controlsVisible property or showControls() and hideControls() methods
lockControls - (default false) set to true to lock the editing of controls - can't move the points or handles - but can see them if showControls is set to true
handleSize - (default 20 mobile 10 for non-mobile) the size of control boxes and affects the circles too proportionally
allowToggle - (default true) set false to let turn off clicks showing and hiding controls
move - (default true) set to false to disable dragging when controls are showing
	can also set to "always" to allow movement when controls are not showing
dashed - (default false) set to true for dashed border (if borderWidth or borderColor set)
onTop - (default true) set to false to not bring shape to top of container when dragging
stickColor - (default "#111") set the stick color of the controls
selectColor - (default white) the color of the selected circle or rectangle of the controls if selectPoints is true
selectPoints - (default true) set to false to not allow point controls to be selected for keyboard control
editPoints - (default true) lets user add points by pressing on shape path.
	set to "anywhere" to let users add points anywhere - will add points with controlType:"none"
	set to false to not allow adding or removing points with click or shift click
interactive - (default true) set to false to turn off controls, move, toggle, select, edit - leaving just the shape
strokeObj - (default {caps:"butt", joints:"miter", miterLimit:10, ignoreScale:false}) set to adjust stroke properties
	caps options: "butt", "round", "square" or 0,1,2
	joints options: "miter", "round", "bevel" or 0,1,2
	miterLimit is the ration at which the mitered joint will be clipped
	ignoreScale set to true will draw the specified line thickness regardless of object scale
style - (default true) set to false to ignore styles set with the STYLE - will receive original parameter defaults
group - (default null) set to String (or comma delimited String) so STYLE can set default styles to the group(s) (like a CSS class)
inherit - (default null) used internally but can receive an {} of styles directly

METHODS
addPoint(percent, controlType) - add a point at a percent (100) of the total curve
	this is handy to make path have the same number of points for animate() path tweens
	controlType can be as specified in main points parameter
	returns object for chaining
addPoints(num, controlType, startPoint, spread, dataOnly, points) - add num points between existing points
	controlType can be as specified in main points parameter
	specify a startPoint to add points between the startPoint and the next point (one segment of points)
	spread (default false) set to true to spread points evenly around path rather than evenly between segments
	dataOnly and points are used internally
	returns object for chaining
interpolate(num, startPoint, spread) - get point data {x,y} for this existing points and num (default 1) points inbetween
	used with hitTestPath
	specify a startPoint to get points between the startPoint and the next point (one segment of points)
	spread (default false) set to true to spread points evenly around path rather than evenly between segments
	returns an array of point objects with x, y properties and an r property for ratio of distance along path
recordData(toJSON) - returns an object with x, y, points, color, borderColor, borderWidth, move, toggle, controls PROPERTIES to be used with setData() method
	if toJSON (default false) is set to true, the return value is a JSON string
	the points data comes from the points property
setData(data, fromJSON) - sets the properties to match the data object passed in - this should come from recordData()
	if fromJSON (default false) is set to true, it will assume a JSON string is passed in as data
	the points data is parsed with the set setPoints() so the number of points should be the same
	returns object for chaining
recordPoints(popup) - returns an array with the same format as the points parameter - or can just use points property
	popup - (default false) set to true to open a zim Pane (squiggle.pane) with the points in a zim TextArea (squiggle.textArea) (click off to close)
	NOTE: the TextArea output uses JSON.stringify() - to add the points to the points parameter of the Squiggle use JSON.parse(output);
	NOTE: using zog(JSON.stringify(squiggle.recordData()))... the console will remove the quotes from the controlTypes so those would have to be manually put back in before parse() will work
setPoints(data) - sets the Squiggle points to the data from recordPoints
	This does not remake the Squiggle but rather shifts the controls so the number of points should be the same
changeControl(index, type, rect1X, rect1Y, rect2X, rect2Y, circleX, circleY, update) - change a control type and properties at an index
	accepts ZIM DUO normal parameters or configuration object literal with parameter names as propterties
	passing in null as the index will change all points to the specified properties
	the update parameter defaults to false so set to true to show update or call update() below
	this is so multiple changes can be batched before calling update - for instance when animating blobs.
transformPoints(transformType, amount, x, y) - scale, rotate, move points without affecting controls or borderWidth - returns object for chaining
	Note - does not adjust original Bounds
	transformType - String any of: "scale", "scaleX", "scaleY", "rotation", "x", "y"
	amount - the amount to transform
	x, y - (default 0, 0) the x and y position to transform about
update(normalize) - update the Squiggle if animating control points, etc. would do this in a Ticker
	set normalize (default false) to true to use pointsAdjusted for rotated and scaled points
	and if animating along the path after setting rotation or scale on point
	just leave out if only animating points
showControls() - shows the controls (and returns squiggle) also see controlsVisible property
hideControls() - hides the controls (and returns squiggle) also see controlsVisible property
toggle(state - default null) - shows controls if hidden and hides controls if showing (returns the object for chaining)
	or pass in true to show controls or false to hide controls
traverse(obj, start, end, time) - animates obj from start point to end point along path - thanks KV for the thought!
	set start point greater than end point to traverse backwards
	will dispatch a "traversed" event when done
setColorRange(color1, color2) - set a color range for shape - used by colorRange property - returns obj for chaining
	if one color is used, the current color is used and color1 is the second color in the range
getPointAngle(index) - gets the angle made by the tangent at the index provided
getSegmentPoint(point1, point2) - returns an array of [point1, controlPoint1, controlPoint2, point2]
	used internally for animating to path and adding removing Bezier points
getAdjacentSegmentData(index) - returns an array of two arrays:
	The first is an array of cubic Bezier points for segments adjacent and including the provided point index
	each element is in the form of [point1, controlPoint1, controlPoint2, point2]
	The second is an array of starting point indexes for the segments that were tested
	used internally to drag an animation along the path
getCurvePoint(ratio, segmentRatios, segmentPoints) gets a point along whole curve at the ratio (0-1) provided
	along with x and y values, the point has a z value that is the index of the squiggle point before the calculated point
	ratio is 0-1 with 0 being at the first point and 1 being at the end of the last segment
	segmentRatios and segmentPoints will be calculated if not provided
	used internally for animating along the path - if lockControls is true, only animate will precalculate these values
linearGradient([colors],[ratios], x0,y0, x1,y1) - shortcut to thicknessCommand linearGradient method (see properties below)
radialGradient([colors],[ratios], x0,y0,radius0, x1,y1,radius1) - shortcut to thicknessCommand radialGradient method (see properties below)
cache(see Container docs for parameter description) - overrides CreateJS cache() and returns object for chaining
	Leave parameters blank to cache bounds of shape (plus outer edge of border if borderWidth > 0)
hasProp(property as String) - returns true if property exists on object else returns false
clone() - makes a copy of the shape
dispose() - removes from parent, removes event listeners - must still set outside references to null for garbage collection

ALSO: ZIM 4TH adds all the methods listed under Container (see above), such as:
drag(), hitTestRect(), animate(), sca(), reg(), mov(), center(), centerReg(),
addTo(), removeFrom(), loop(), outline(), place(), pos(), alp(), rot(), setMask(), etc.
ALSO: See the CreateJS Easel Docs for Container methods, such as:
on(), off(), getBounds(), setBounds(), uncache(), updateCache(), dispatchEvent(),
addChild(), removeChild(), addChildAt(), getChildAt(), contains(), removeAllChildren(), etc.

PROPERTIES
type - holds the class name as a String
shape - gives access to the shape of the squiggle
color - get and set the fill color
colorRange - if setColorRange() is used, the colorRange is a ratio (0-1) between the colors
	setting the colorRange will change the color property of the shape
	for instance, shape.setColorRange(blue, pink) then shape.colorRange = .5
	will set the color of the shape to half way between blue and pink
	shape.animate({color:red}, 1000); is a shortcut to animate the colorRange
	shape.wiggle("colorRange", .5, .2, .5, 1000, 5000) will wiggle the colorRange
stickColor - get or set the stickColor - requires an update() to see changes
colorCommand - access to the CreateJS fill command for bitmap, linearGradient and radialGradient fills
	eg. shape.colorCommand.linearGradient([green, blue ,green], [.2, .5, .8], 0, 0, shape.width, 0)
	See: https://www.createjs.com/docs/easeljs/classes/Graphics.Fill.html
thickness - get and set the stroke size in pixels
thicknessCommand - access to the CreateJS stroke style command (width, caps, joints, miter, ignoreScale)
	See: https://www.createjs.com/docs/easeljs/classes/Graphics.StrokeStyle.html
dashedCommand - access to the CreateJS stroke dashed command (segments, offset)
	see https://www.createjs.com/docs/easeljs/classes/Graphics.StrokeDash.html
num - get the number of points - to set, use the points property
points - get or set the points array of the Squiggle in the same format as the points parameter:
	[[controlX, controlY, circleX, circleY, rect1X, rect1Y, rect2X, rect2Y, controlType], [etc]]
pointsAdjusted - get points with any point rotation converted to 0 - see update(true)
pointControls - get an array of controls (a container) - use this to animate controls
pointCircles - get an array of control circles - use this to place some other object at the point
pointObjects - get an array of point objects for each point in the following format:
	[[control, circle, rect1, rect2, controlType], [etc.]]
	control - the container for the control that holds the circle and rectangles (also see pointControls)
	circle - the control point circle (also see pointCircles)
	rect1 - the first control point rectangle
	rect2 - the second control point rectangle
	controlType - the control type: default is "straight" (or null) and there is also "mirror", "free" and "none"
	NOTE: control, circle, rect1, rect2 can be positioned or animated and controlType can be changed
	NOTE: the update() method must be called if manually changing the control positions or type
	NOTE: if constantly animating the controls then use a Ticker.add(function(){squiggle.update();})
	NOTE: also see recordData(), setData(), recordPoints(), setPoints() methods for further options
addPointFactor - (default 20) used when placing new points along edge (editPoints is true)
	divides the distance between points by this amount - the smaller the more accurate but also slower
addMinDistance - (default 15) edge press needs to be within this distance to add a point to the edge
segmentPoints - a read-only array of cubic Bezier points for each segment
	each element is in the form of [point1, controlPoint1, controlPoint2, point2]
	used internally to animate to the path and add and remove Bezier points
segmentRatios - a read-only array of cumulative ratio lengths of segments
	for instance the default five points (four segments) is [.25, .5, .75, 1]
	used internally to animate to the path and attribute proportional time to each segment
controls - access to the container that holds the sets of controls
	each control is given a read-only num property
sticks - access to the container that holds the control sticks
lastSelected - access to the last selected (or created) control container
lastSelectedIndex - the index number of the last selected controls
controlsVisible - get or set the visibility of the controls - or use showControls() and hideControls()
toggled - read-only Boolean property as to whether picker is showing
types - get or set the general array for the types ["mirror", "straight", "free", "none"]
	changing this or removing a type will adjust the order when the user double clicks the points to change their type
	this is not an array of types for each point - see the points property to access the types of each point
lockControls - Boolean to lock controls from being adjusted or not
lockControlType - Boolean to lock the type of the controls in their current state or not
allowToggle - Boolean to get or set clicking to show and hide controls
move - Boolean to drag or not drag Squiggle when controls are showing
	can also set to "always" to allow movement when controls are not showing
onTop - get or set the onTop
selectPoints - get or set whether points can be selected
interactive - get or set whether the shape is interactive - toggle, move, change or add controls, etc.
** setting widths and heights adjusts scale not bounds and getting these uses the bounds dimension times the scale
width - gets or sets the width. Setting the width will scale the height to keep proportion (see widthOnly below)
height - gets or sets the height. Setting the height will scale the width to keep proportion (see heightOnly below)
widthOnly - gets or sets the width.  This sets only the width and may change the aspect ratio of the object
heightOnly - gets or sets the height.  This sets only the height and may change the aspect ratio of the object
depth - for ZIM VR - the depth used to shift left and right channel and for parallax in VR - also see dep() ZIM Display method
blendMode - how the object blends with what is underneath - such as "difference", "multiply", etc. same as CreateJS compositeOperation
keyFocus - get or set the keyboard focus on the DisplayObject - see also zim.KEYFOCUS
   will be set to true if this DisplayObject is the first made or DisplayObject is the last to be used with keyboard
group - used when the object is made to add STYLE with the group selector (like a CSS class)

ALSO: See the CreateJS Easel Docs for Container properties, such as:
x, y, rotation, scaleX, scaleY, regX, regY, skewX, skewY,
alpha, cursor, shadow, mouseChildren, mouseEnabled, parent, numChildren, etc.

EVENTS
dispatches a "change" event for when the bezier controls are adjusted (pressup only)
	if monitoring constant change is needed add a pressmove event to Squiggle.controls
	the change event object has a transformType property with values of "move", "bezierPoint", "bezierHandle", "bezierSwitch"
dispatches "controlsshow" and "controlshide" events when clicked off and on and toggle is true
dispatches an "update" event if the points are changed or a point is added or removed
	this removes all listeners on the old shape and controls
	so any custom listeners on shape and controls will need to be re-applied - use the update event to do so
dispatches a "traversed" event when traverse() is done - the event object has an obj property for the traversing object
See the CreateJS Easel Docs for Container events, such as:
added, click, dblclick, mousedown, mouseout, mouseover, pressmove, pressup, removed, rollout, rollover

MORE
https://zimjs.com/squiggle
https://www.youtube.com/watch?v=BA1bGBU4itI&list=PLCIzupgRt1pYtMlYPtNTKCtztFBeOtyc0
Note the points property has been split into points and pointObjects (and there have been a few property changes) since the time of the video
--*///+53.2
	zim.Squiggle = function(color, thickness, points, length, controlLength, controlType, lockControlType, showControls, lockControls, handleSize, allowToggle, move, dashed, onTop, stickColor, selectColor, selectPoints, editPoints, interactive, strokeObj, style, group, inherit) {
		var sig = "color, thickness, points, length, controlLength, controlType, lockControlType, showControls, lockControls, handleSize, allowToggle, move, dashed, onTop, stickColor, selectColor, selectPoints, editPoints, interactive, strokeObj, style, group, inherit";
		var duo; if (duo = zob(zim.Squiggle, arguments, sig, this)) return duo;
		z_d("53.2");

		this.group = group;
		var DS = style===false?{}:zim.getStyle("Squiggle", this.group, inherit);

		if (zot(thickness)) thickness = DS.thickness!=null?DS.thickness:6;
		if (zot(length)) length = DS.length!=null?DS.length:300;
		if (zot(points)) points = DS.points!=null?DS.points:5;
		if (typeof points == "string") {
			var svgProcessor = new zim.SVGContainer();
			points = svgProcessor.processPath(points);
		}
		var num = typeof points == "number" ? points : points.length;
		if (num == 0) return;
		if (zot(controlLength)) controlLength = DS.controlLength!=null?DS.controlLength:(length / num);
		this.zimContainer_constructor(length, controlLength, null, null, false);
		this.type = "Squiggle";

		if (zot(dashed)) dashed = DS.dashed!=null?DS.dashed:false;
		if (zot(color)) color = DS.color!=null?DS.color:zim.blue;
		if (color.style) {this.colorCommand = color; color = "black";}

		if (zot(controlType)) controlType = DS.controlType!=null?DS.controlType:null;
		var originalControlType = controlType;
		if (zot(controlType)) controlType = "mirror";
		if (zot(lockControlType)) lockControlType = DS.lockControlType!=null?DS.lockControlType:false;
		if (zot(interactive)) interactive = DS.interactive!=null?DS.interactive:true;
		if (zot(showControls)) showControls = DS.showControls!=null?DS.showControls:interactive;
		var _controls = showControls;
		if (zot(lockControls)) lockControls = DS.lockControls!=null?DS.lockControls:!interactive;
		if (zot(handleSize)) handleSize = DS.handleSize!=null?DS.handleSize:zim.mobile()?20:10;
		if (zot(allowToggle)) allowToggle = DS.allowToggle!=null?DS.allowToggle:interactive;
		if (zot(move)) move = DS.move!=null?DS.move:interactive;
		if (zot(stickColor)) stickColor = DS.stickColor!=null?DS.stickColor:"#111";
		if (zot(selectColor)) selectColor = DS.selectColor!=null?DS.selectColor:"#fff";
		if (zot(selectPoints)) selectPoints = DS.selectPoints!=null?DS.selectPoints:interactive;
		this.stickColor = stickColor;

		if (zot(onTop)) onTop = DS.onTop!=null?DS.onTop:true;
		if (zot(editPoints)) editPoints = DS.editPoints!=null?DS.editPoints:interactive;
		if (zot(strokeObj)) strokeObj = DS.strokeObj!=null?DS.strokeObj:{};

		var that = this;
		var types = this.types = ["mirror", "straight", "free", "none"];
		this.interactive = interactive;
		this.num = num;
		this.onTop = onTop;
		this.move = move;
		this.editPoints = editPoints;
		this.allowToggle = allowToggle;
		this.lockControlType = lockControlType;
		this.selectPoints = selectPoints;
		this.lockControls = lockControls;

		var _points;
		var _pointCircles;
		var _pointControls;
		var _color = color;
		var _thickness = thickness;
		var colorObj;
		var thicknessObj;
		var borderDashedObj;

		var shape;
		var moveDownEvent;
		var movePressEvent;
		var moveUpEvent;
		var stage;

		var draggingCheck = that.move;
		var min = 2; // min distance within which a click will add a point

		var mapMove;
		var drawShape;
		var sets;

		if (originalControlType && typeof points != "number") {
			// override controlType
			loop(points, function(point) {
				point[8]=originalControlType;
				if (originalControlType == "none") {
					point[4]=point[5]=point[6]=point[7]=0;
				}
			});
		}

		init();
		function init() {
			if (sets) sets.removeAllEventListeners();

			that.num = num = typeof points == "number" ? points : points.length;
			num = Math.max(2,num);
			controlLength = length / num;

			shape = that.shape = new zim.Shape({style:false}).addTo(that);
			var sticks = that.sticks = new zim.Shape({style:false}).addTo(that);
			if (handleSize <= 0) sticks.removeFrom();
			var g = shape.graphics;
			g.c();
			var s = sticks.graphics;
			s.c();

			var ballS = handleSize/10*8;
			var rectS = handleSize;

			if (that.selectPoints) {
				that.selectedBalls = new zim.SelectionSet();
				that.selectedRect1s = new zim.SelectionSet();
				that.selectedRect2s = new zim.SelectionSet();

				that.selectionManager = new zim.SelectionManager([
					that.selectedBalls,
					that.selectedRect1s,
					that.selectedRect2s
				], "ctrl", false);
			} else {
				that.selectionManager = new zim.SelectionManager(null, "ctrl");
			}

			var mobile = zim.mobile();

			sets = that.controls = new zim.Container({style:false}).addTo(that); // sets - a set contains a ball and two rects
			if (that.interactive) sets.drag({onTop:!mobile});
			_points = [];
			_pointControls = [];
			_pointCircles = [];

			var angle, point, temp, set, rect1, rect2, ball, type, setInfo;

			for (var i=0; i<num; i++) {
				set = new zim.Container({style:false}).addTo(sets);
				set.num = i;
				if (typeof points == "number") { // no sets yet
					var stickLength = zim.Pick.choose(controlLength);
					temp = new zim.Container(stickLength, thickness, null, null, false).addTo(that).loc({x:i*length/(num-1)-stickLength/2, y:i%2*stickLength});
					ball = new zim.Circle(ballS, that.selectPoints&&that.selectedBalls.isSelected(i)?selectColor:zim.light, zim.dark, 2, null, null, null, false)
						.centerReg(temp)
						.loc({x:stickLength/2, y:0});
					rect1 = new zim.Rectangle(rectS, rectS, that.selectPoints&&that.selectedRect1s.isSelected(i)?selectColor:getBackgroundColor(controlType),  handleSize==0?null:zim.dark,  handleSize==0?null:2, null, null, null, false)
						.centerReg(temp)
						.loc({x:0,y:0});
					rect2 = new zim.Rectangle(rectS, rectS, that.selectPoints&&that.selectedRect2s.isSelected(i)?selectColor:getBackgroundColor(controlType),  handleSize==0?null:zim.dark,  handleSize==0?null:2, null, null, null, false)
						.centerReg(temp)
						.loc({x:stickLength,y:0});

					var ballPoint = temp.localToLocal(ball.x, ball.y, sets);
					ball.x = ballPoint.x;
					ball.y = ballPoint.y;
					ball.addTo(set, null, false);
					var rect1Point = temp.localToLocal(rect1.x, rect1.y, sets);
					rect1.x = controlType=="none"?0:rect1Point.x-ball.x;
					rect1.y = controlType=="none"?0:rect1Point.y-ball.y;
					rect1.addTo(set, null, false);
					var rect2Point = temp.localToLocal(rect2.x, rect2.y, sets);
					rect2.x = controlType=="none"?0:rect2Point.x-ball.x;
					rect2.y = controlType=="none"?0:rect2Point.y-ball.y;
					rect2.addTo(set, null, false);
					set.x = ball.x;
					set.y = ball.y;
					ball.x = 0;
					ball.y = 0;
					if (controlType=="none") ball.addTo(set, null, false); // on top

				} else { // passing in set data

					// _pointCircles are relative to squiggle but handles are relative to ball
					// points is an array of [[setX, setY, ballX, ballY, handleX, handleY, handle2X, handle2Y, type], etc.]

					setInfo = points[i];
					type = setInfo[8] ? setInfo[8] : controlType;
					set.loc({x:setInfo[0], y:setInfo[1]});
					ball = new zim.Circle(ballS, zim.light, zim.dark, 2, null, null, null, false)
						.centerReg(set)
						.loc({x:setInfo[2],y:setInfo[3]});
					rect1 = new zim.Rectangle(rectS, rectS, getBackgroundColor(type),  handleSize==0?null:zim.dark,  handleSize==0?null:2, null, null, null, false)
						.centerReg(set, 0)
						.loc({x:setInfo[4],y:setInfo[5]});
					rect2 = new zim.Rectangle(rectS, rectS, getBackgroundColor(type), handleSize==0?null:zim.dark,  handleSize==0?null:2, null, null, null, false)
						.centerReg(set, 0)
						.loc({x:setInfo[6],y:setInfo[7]});
				}

				ball.mySet = set;
				ball.rect1 = rect1;
				ball.rect2 = rect2;
				ball.index = i;

				if (mobile) {
					ball.on("mousedown", mobileDouble);
				} else {
					ball.on("dblclick", doubleIt);
				}

				rect1.ball = ball;
				rect1.other = rect2;
				rect2.ball = ball;
				rect2.other = rect1;

				if (handleSize==0) {
					ball.expand(10);
					rect1.expand(10);
					rect2.expand(10);
				}

				if (mobile) {
					ball.expand();
					rect1.expand();
					rect2.expand();
				}

				point = [set, ball, rect1, rect2, setInfo?setInfo[8]:controlType];
				_points.push(point);
				_pointCircles.push(ball);
				_pointControls.push(set);
			}

			var tappedTwice = false;
			function mobileDouble(e) {
				if (!tappedTwice) {
					tappedTwice = true;
					setTimeout(function() {
						tappedTwice = false;
					}, 300);
				} else {
					e.preventDefault();
					doubleIt(e);
				}
			}

			function doubleIt(e) {
				if (that.lockControlType) return;
				var ball = e.target;
				// cycle through the types
				var type = _points[ball.index][4] ? _points[ball.index][4] : controlType;
				if (Math.abs(ball.rect1.x) <= 2 && Math.abs(ball.rect1.y) <= 2 && Math.abs(ball.rect2.x) <= 2 && Math.abs(ball.rect2.y) <= 2) {
					type = "none"
				}
				if (type == "none") {
					ball.parent.addChildAt(ball, 0);
				}
				// modulus going backwards needs to add the length so it does not go negative
				type = that.types[(that.types.indexOf(type)+(that.shiftKey?-1:1)+that.types.length)%that.types.length];
				if (type == "none") {
					ball.rect1.x =  ball.rect1.y =  ball.rect2.x =  ball.rect2.y = 0;
					ball.parent.addChild(ball);
					e.stopImmediatePropagation();
				}
				_points[ball.index][4] = type;

				ball.rect1.color = getBackgroundColor(type);
				ball.rect2.color = getBackgroundColor(type);
				drawShape();
				var ev = new createjs.Event("change");
				ev.controlType = "bezierSwitch";
				that.dispatchEvent(ev);
				ball.stage.update();
			};

			function getBackgroundColor(type) {
				var colors = {straight:zim.pink, free:zim.yellow, none:zim.blue};
				return colors[type] ? colors[type] : zim.purple;
			}

			drawShape = function () {

				g.c();

				var minThickness = zim.mobile() ? 10 : 6;
				if (thickness < minThickness) {
					// 1. draw backing grab line
					g.s("rgba(0,0,0,.01)").ss(minThickness);
					var set = _points[0][0];
					var ballPoint = set.localToLocal(_points[0][1].x, _points[0][1].y, shape);
					g.mt(ballPoint.x, ballPoint.y);

					var currentIndex; var nextIndex;
					for (var i=0; i<_points.length; i++) {
						var currentIndex = i;
						var nextIndex = (i+1)%_points.length;

						var set = _points[currentIndex][0];
						var ball = _points[currentIndex][1];
						var control1 = _points[currentIndex][2];
						var control2 = _points[currentIndex][3];

						var nextSet = _points[nextIndex][0];
						var nextBall = _points[nextIndex][1];
						var nextControl1 = _points[nextIndex][2];
						var nextControl2 = _points[nextIndex][3];

						var control2Point = set.localToLocal(control2.x, control2.y, shape);
						var nextControl1Point = nextSet.localToLocal(nextControl1.x, nextControl1.y, shape);
						var nextBallPoint = nextSet.localToLocal(nextBall.x, nextBall.y, shape);

						if (i != _points.length-1) {
							g.bt(
								control2Point.x, control2Point.y,
								nextControl1Point.x, nextControl1Point.y,
								nextBallPoint.x, nextBallPoint.y
							);
						}
					}
				}

				// 2. draw real line

				if (!that.colorCommand) that.colorCommand = colorObj = g.s(_color).command;
				if (!that.thicknessCommand) that.thicknessCommand = thicknessObj = g.ss(_thickness, strokeObj.caps, strokeObj.joints, strokeObj.miterLimit, strokeObj.ignoreScale).command;
				if (dashed) {
					if (!that.dashedCommand) that.dashedCommand = borderDashedObj = g.sd([10, 10], 5).command;
				}

				set = _points[0][0];
				ballPoint = set.localToLocal(_points[0][1].x, _points[0][1].y, shape);
				g.mt(ballPoint.x, ballPoint.y);

				s.c().s(that.stickColor).ss(1);

				var currentIndex; var nextIndex;
				for (var i=0; i<_points.length; i++) {
					var currentIndex = i;
					var nextIndex = (i+1)%_points.length;

					var set = _points[currentIndex][0];
					var ball = _points[currentIndex][1];
					var control1 = _points[currentIndex][2];
					var control2 = _points[currentIndex][3];

					var nextSet = _points[nextIndex][0];
					var nextBall = _points[nextIndex][1];
					var nextControl1 = _points[nextIndex][2];
					var nextControl2 = _points[nextIndex][3];

					var control2Point = set.localToLocal(control2.x, control2.y, shape);
					var nextControl1Point = nextSet.localToLocal(nextControl1.x, nextControl1.y, shape);
					var nextBallPoint = nextSet.localToLocal(nextBall.x, nextBall.y, shape);

					if (i != _points.length-1) {
						g.bt(
							control2Point.x, control2Point.y,
							nextControl1Point.x, nextControl1Point.y,
							nextBallPoint.x, nextBallPoint.y
						);
					}

					// create the sticks
					var ballPoint = set.localToLocal(ball.x, ball.y, shape);
					var control1Point = set.localToLocal(control1.x, control1.y, shape);

					if (i == 0) control1.visible = 0;
					if (i != 0) s.mt(ballPoint.x, ballPoint.y).lt(control1Point.x, control1Point.y);
					if (i != _points.length-1) s.mt(ballPoint.x, ballPoint.y).lt(control2Point.x, control2Point.y);
					if (i == _points.length-1) control2.visible = 0;
				}

				if (dashed) g.append(that.dashedCommand);
				g.append(that.thicknessCommand);
				g.append(that.colorCommand);
			}
			drawShape();

			var startPosition;
			sets.on("mousedown", function(e) {
				stage = e.target.stage;
				if (that.lockControls) return;
				if (that.selectPoints) that.keyFocus = true;
				startPosition = {x:e.target.x, y:e.target.y};
				if (e.target.rect1) { // then mousedown on ball - which has a rect1
					var ball = e.target;
					ball.startX = ball.x;
					ball.startY = ball.y;
					ball.rect1.startX = ball.rect1.x;
					ball.rect1.startY = ball.rect1.y;
					ball.rect2.startX = ball.rect2.x;
					ball.rect2.startY = ball.rect2.y;
				} else { // mousedown on control
					var rect = e.target;
					rect.startX = rect.x;
					rect.startY = rect.y;
					var ball = rect.ball;
					var index = ball.index;
					var type = controlType;
					if (!zot(_points[index][4])) type = _points[index][4];
					if (type == "straight") {
						var other = rect.other;
						var dX = other.x - ball.x;
						var dY = other.y - ball.y;
						other.stickLength = Math.sqrt(Math.pow(dX,2) + Math.pow(dY,2));
					}
				}
				if (that.selectPoints) {
					// need to reset all start points for each control circle and rectangle moved
					var currentSet = that.selectionManager.currentSet;
					if (currentSet && currentSet.selections && currentSet.selections.length > 0) {
						for(var i=0; i<currentSet.selections.length; i++) {
							var point = that.pointObjects[currentSet.selections[i]];
							point[1].startX = point[1].x;
							point[1].startY = point[1].y;
							point[2].startX = point[2].x;
							point[2].startY = point[2].y;
							point[3].startX = point[3].x;
							point[3].startY = point[3].y;
						}
					}
				}
			});

			if (that.selectPoints) {
				sets.tap(function (e) {
					if (e.target.rect1) { // then mousedown on ball - which has a rect1
						var ball = e.target;
						that.selectedBalls.toggle(ball.parent.num);
					} else { // mousedown on control
						var rect = e.target;
						rect.color = "white";
						var ball = rect.ball;
						if (ball.rect1 == rect) that.selectedRect1s.toggle(ball.parent.num);
						else that.selectedRect2s.toggle(ball.parent.num);
					}
					// loop through all controls and set to right color based on selection
					for (var i=0; i<that.pointObjects.length; i++) {
						var po = that.pointObjects[i];
						po[1].color = that.selectedBalls.isSelected(i)?zim.white:zim.light;
						po[2].color = that.selectedRect1s.isSelected(i)?zim.white:getBackgroundColor(po[4]);
						po[3].color = that.selectedRect2s.isSelected(i)?zim.white:getBackgroundColor(po[4]);
					}
					stage.update();
				});
			}

			sets.on("pressmove", function(e) {
				if (that.lockControls) return;
				if (that.selectPoints) {
					var currentSelected = getCurrentSelected();
					if (currentSelected.indexOf(e.target) == -1) {
						mapMove(e.target);
						drawShape();
					} else {
						if (currentSelected.length > 0) {
							diffX = e.target.x-e.target.startX;
							diffY = e.target.y-e.target.startY;
							for(var i=0; i<currentSelected.length; i++) {
								var pointObj = currentSelected[i];
								pointObj.x = pointObj.startX + diffX;
								pointObj.y = pointObj.startY + diffY;
								mapMove(pointObj);
							}
							drawShape();
						}
					}
				} else {
					mapMove(e.target);
					drawShape();
				}
			});

			sets.on("pressup", function(e) {
				if (that.lockControls) return;
				var moveControlCheck = (e.target.x != startPosition.x || e.target.y != startPosition.y);
				var ev = new createjs.Event("change");
				if (e.target.rect1) { // pressup on ball
					ev.controlType = "bezierPoint";
					endMove(e.target);
				} else {
					ev.controlType = "bezierHandle";
				}
				if (moveControlCheck) that.dispatchEvent(ev);
			});

			function endMove(target) {
				if (that.selectPoints) {
					var currentSelected = getCurrentSelected();
					if (currentSelected && currentSelected.indexOf(target) == -1) {
						replaceControls(target);
					} else if (currentSelected && currentSelected.length>0) {
						for(var i=0; i<currentSelected.length; i++) {
							replaceControls(currentSelected[i]);
						}
					} else {
						replaceControls(target);
					}
				} else {
					replaceControls(target);
				}
			};

			that.changeControl = function(index, type, rect1X, rect1Y, rect2X, rect2Y, circleX, circleY, update) {
				var sig = "index, type, rect1X, rect1Y, rect2X, rect2Y, circleX, circleY, update";
				var duo; if (duo = zob(that.changeControl, arguments, sig)) return duo;
				if (zot(index)) {
					for (var i=0; i<_points.length; i++) {
						that.changeControl(i, type, rect1X, rect1Y, rect2X, rect2Y, circleX, circleY);
					}
					return;
				}
				var point = _points[index];
				point[4] = type;
				if (type == "none") {
					if (!zot(circleX)) point[2].x = circleX;
					if (!zot(circleY)) point[2].y = circleY;
					point[2].x = point[1].x;
					point[2].y = point[1].y;
					point[3].x = point[1].x;
					point[3].y = point[1].y;
					point[1].parent.addChild(point[1]);
				} else {
					if (!zot(rect1X)) point[2].x = rect1X;
					if (!zot(rect1Y)) point[2].y = rect1Y;
					if (!zot(rect2X)) point[3].x = rect2X;
					if (!zot(rect2Y)) point[3].y = rect2Y;
					if (!zot(circleX)) point[1].x = circleX;
					if (!zot(circleY)) point[1].y = circleY;
					point[1].parent.addChildAt(point[1], 0);
				}
				if (update) {
					that.update();
					if (that.stage) that.stage.update();
				}
			}

			that.transformPoints = function(transformType, amount, x, y) {
				that.points = zim.transformPoints(that.points, transformType, amount, x, y);
				return that;
			}

			that.traverse = function(obj, start, end, time) {
				var ratios = zim.copy(that.segmentRatios);
				ratios.unshift(0);
				if (zot(end)) end = start+1;
				var forward = start < end;
				if (forward) {
					var startPercent = ratios[start]*100;
					var endPercent = ratios[end]*100;
				} else {
					var startPercent = 50 + (100 - ratios[start]*100)/2;
					var endPercent = 50 + (100 - ratios[end]*100)/2;
				}
				obj.percentComplete = startPercent;
				obj.animate({
					ease:"linear",
					props:{path:that},
					rewind:!forward,
					time:time,
					events:true
				});
				obj.on("animation", function (e) {
					// when it hits the end it may start over
					if (obj.percentComplete > endPercent || obj.percentComplete == 0) {
						obj.stopAnimate();
						e.remove();
						var eventObj = new createjs.Event("traversed");
						eventObj.obj = obj;
						that.dispatchEvent(eventObj);
					}
				});
				return that;
			}


			that.update = function(normalize) {
				if (normalize) {
					// located any rotated or scaled points
					// and set them back to non-rotated and non-scaled
					// but keep control handles at the earlier positions
					// need to normalize before doing more manual updates with Beziers
					// do not need to normalize if animating blob points
					that.points = that.pointsAdjusted;
				} else {
					drawShape();
				}
				return that;
			}

			if (that.interactive) {
				if (move) shape.drag({onTop:false});
				moveDownEvent = shape.on("mousedown", function(e) {
					stage = e.target.stage;
					startPosition = {x:shape.x, y:shape.y};
					if (that.selectPoints) that.keyFocus = true;
					upTop();
				});
				movePressEvent = shape.on("pressmove", function() {
					sets.x = shape.x;
					sets.y = shape.y;
					sticks.x = shape.x;
					sticks.y = shape.y;
				});
				moveUpEvent = shape.on("pressup", function() {
					var moveControlCheck = (shape.x != startPosition.x || shape.y != startPosition.y);
					var movePoint = shape.localToLocal(0,0,that.parent);
					that.x = movePoint.x;
					that.y = movePoint.y;
					sets.x = sets.y = sticks.x = sticks.y = shape.x = shape.y = 0;
					if (moveControlCheck) {
						var ev = new createjs.Event("change");
						ev.controlType = "move";
						that.dispatchEvent(ev);
					}
					stage.update();
				});

				if (!that.move) stopDragging(true); // true is first time
			}

			function upTop() {
				if (that.onTop) {
					var nc = that.parent.numChildren-1;
					if (that.parent.getChildAt(nc).type == "Keyboard") nc--;
					that.parent.setChildIndex(that, nc);
				}
			}

			that.toggleEvent = that.on("mousedown", function() {
				if (!that.allowToggle) return;
				if (!_controls) {
					that.showControls();
					that.dispatchEvent("controlsshow");
				}
			});

			that.added(function() {
				that.toggleStageEvent = that.stage.on("stagemousedown", function(e) {
					if (!that.allowToggle || !that.stage) return;
					if (_controls && !that.hitTestPoint(e.stageX/e.target.stage.scaleX, e.stageY/e.target.stage.scaleY, false)) {
						that.hideControls();
						that.dispatchEvent("controlshide");
					}
				});
			});

			that.clickEvent = that.on("click", function() {
				if (that.ctrlKey) {
					setTimeout(function() { // give time for record to work if drag with ctrl down
						that.clone(true).addTo(that.stage).mov(0, 100);
						if (that.allowToggle) {
							that.hideControls();
							that.dispatchEvent("controlshide");
						}
						var ev = new createjs.Event("change");
						ev.controlType = "move";
						that.dispatchEvent(ev);
						that.stage.update();
					}, 50);
				}
			});

			that.hideControls = function() {
				that.toggled = false;
				sets.visible = false;
				sticks.visible = false;
				_controls = false;
				if (that.stage) that.stage.update();
				if (!that.allowToggle && that.move) stopDragging();
				return that;
			}
			if (!showControls) that.hideControls();
			that.showControls = function() {
				that.toggled = true;
				// if call this with code then will not trigger a change event - not good for TransformManager.persist()
				sets.visible = true;
				sticks.visible = true;
				_controls = true;
				sets.x = shape.x;
				sets.y = shape.y;
				sticks.x = shape.x;
				sticks.y = shape.y;
				that.addChildAt(shape,0); // put to bottom incase dragged
				if (that.move && !that.allowToggle) startDragging();
				if (that.stage) that.stage.update();
				return that;
			}

			that.toggle = function(state) {
				if (state===true) that.showControls();
				else if (state===false) that.hideControls();
				else if (_controls) that.hideControls();
				else that.showControls();
				return that;
			}

			that.recordData = function(toJSON) {
				if (zot(toJSON)) toJSON = false;
				var obj = {
					type:"Blob",
					index:that.parent?that.parent.getChildIndex(that):-1,
					x:that.x, y:that.y,
					points:that.recordPoints(),
					color:that.color,
					thickness:that.thickness,
					move:that.move,
					toggle:that.allowToggle,
					controlsVisible:_controls
				}
				if (toJSON) return JSON.stringify(obj);
				return obj;
			}

			that.setData = function(data, fromJSON) {
				if (zot(data)) return;
				if (fromJSON) {
					try{
					  data = JSON.parse(data);
					} catch(e) {
					  return;
				  	}
				}
				var index = data.index;
				if (zot(index)) index = -1;
				delete data.index;

				var pointData = data.points;
				if (!zot(pointData)) that.setPoints(pointData);
				delete data.points;
				that.num = pointData.length;

				for (var d in data) {
					that[d] = data[d];
				}
				if (that.parent) {
					that.parent.setChildIndex(that, index);
				}
				that.update();
				return that;
			}

			that.recordPoints = function(popup) {
				// balls are relative to blob but handles are relative to ball
				// points is an array of [[ballX, ballY, handleX, handleY, handle2X, handle2Y, type], etc.]
				if (zot(popup)) popup = false;
				var points = that.points;
				if (popup) {
					if (!that.pane) {
						var pane = that.pane = new zim.Pane({
							container:that.stage,
							width:Math.min(500, that.stage.width-20),
							height:Math.min(500, that.stage.height-20),
							draggable:true,
						});
						var textArea = that.textArea = new zim.TextArea(Math.min(400, that.stage.width-70), Math.min(400, that.stage.height-70));
						textArea.centerReg(pane);
					}
					that.textArea.text = JSON.stringify(points);
					that.pane.show();
				}
				return points;
			}

			that.setPoints = function(points) {
				// adjust blob to match points passed in from recordPoints
				var p;
				var p2;
				for (var i=0; i<points.length; i++) {
					p = _points[i];
					p2 = points[i];
					if (zot(p)) continue;
					p[0].x = p2[0];
					p[0].y = p2[1];
					p[1].x = p2[2];
					p[1].y = p2[3];
					p[2].x = p2[4];
					p[2].y = p2[5];
					p[3].x = p2[6];
					p[3].y = p2[7];
					p[4] = p2[8];
				}
				that.update();
				return that;
			}
			if (style!==false) zimStyleTransforms(that, DS);
			that.clone = function(commands) {
				var color = commands?that.colorCommand:that.color;
				var color = commands?that.colorCommand:that.color;
				var newShape =  that.cloneProps(new zim.Squiggle(commands?that.colorCommand:that.color, that.thickness, that.recordPoints(), length, controlLength, controlType, lockControlType, sets.visible, lockControls, handleSize, that.allowToggle, that.move, dashed, onTop, stickColor, selectColor, selectPoints, that.editPoints, interactive, strokeObj, style, that.group, inherit));
				if (that.linearGradientParams) newShape.linearGradient.apply(newShape, that.linearGradientParams);
				if (that.radialGradientParams) newShape.radialGradient.apply(newShape, that.linearGradientParams);
				return newShape;
			}

			// to add a control - make sure click in one spot - not drag
			that.shape.on("mousedown", function (e) {
				stage = e.target.stage;
				if (!that.editPoints) return;
				if (that.controlsVisible) {
					that.pressX = e.stageX/stage.scaleX;
					that.pressY = e.stageY/stage.scaleX;
				} else {
					that.pressX = null;
					that.pressY = null;
				}
			});
			that.addPointFactor = 20;
			that.addMinDistance = 15;
			that.shape.on("pressup", function (e) {
				if (!that.editPoints) return;
				if (that.pressX && Math.abs(that.pressX-e.stageX/stage.scaleX) < min && Math.abs(that.pressY-e.stageY/stage.scaleY) < min) {
					if (that.selectPoints) that.lastPoints = zim.copy(that.points);
					var points = that.points;
					var point = that.globalToLocal(e.stageX/stage.scaleX, e.stageY/stage.scaleY);
					var pointBefore = zim.closestPointAlongCurve(point, that.segmentPoints);

					if (that.editPoints == "anywhere") {
						points.splice(pointBefore+1, 0, [point.x, point.y, 0,0, 0,0, 0,0]);
						that.points = points;
						that.changeControl({index:pointBefore+1, type:"mirror", update:true});
					} else { // only on edge
						// test close enough to edge otherwise return
						var p = that.pointsAdjusted;
						var cubic = that.getSegmentPoint(p[pointBefore], p[(pointBefore+1)%p.length]);
						var length = zim.distanceAlongCurve(cubic);
						var testNum = Math.round(length/that.addPointFactor);
						var testPoints = that.interpolate(testNum, pointBefore, points);
						var closest=10000;
						var closestPoint;
						var closestIndex;

						zim.loop(testPoints, function (p, k) {
							if (k==0) return; // don't put on existing point
							var d = zim.dist(p, point);
							if (d < closest) {
								closest = d;
								closestIndex = k;
								closestPoint = p;
							}
						});
						if (closest < that.addMinDistance) {
							var ratios = that.segmentRatios;
							var currentRatio = ratios[pointBefore];
							var lastRatio = pointBefore>0?ratios[pointBefore-1]:0;
							that.addPoint(100*(lastRatio+(currentRatio-lastRatio)*(closestIndex/testNum)));
						}
					}
					that.lastSelectedIndex = pointBefore+1;
					that.lastSelected = that.controls.getChildAt(that.lastSelectedIndex);
					that.stage.update();
				}
			});

			// remove point
			that.controls.on("click", function (e) {
				that.lastSelected = e.target.parent;
				var index = that.lastSelectedIndex = that.controls.getChildIndex(e.target.parent);
				if (!that.editPoints) return;
				if (that.selectionManager.shiftKey) { // remove
					// if (that.selectionManager.currentSet == that.selectedBalls && that.selectedBalls.selections.length > 0) return;
					if (e.target.type == "Circle") {
						if (that.controls.numChildren <= 2) return;
						var points = that.points;
						if (that.selectPoints) that.lastPoints = zim.copy(points);
						points.splice(index, 1); // remove the point at the index
						that.points = points;
						that.stage.update();
						that.lastSelected = that.lastSelectedIndex = null;
					}
				}
			});

			if (!_controls) that.hideControls();
			that.dispatchEvent("update");
		} // end of init()

		// if (that.selectPoints) {
		function getCurrentSelected() {
			var answer = [];
			var currentSet = that.selectionManager.currentSet;
			if (currentSet && currentSet.selections && currentSet.selections.length > 0) {
				for(var i=0; i<currentSet.selections.length; i++) {
					var point = that.pointObjects[currentSet.selections[i]];
					if (currentSet == that.selectedBalls) {
						answer.push(point[1]);
					} else if (currentSet == that.selectedRect1s) {
						answer.push(point[2]);
					}	else if (currentSet == that.selectedRect2s) {
						answer.push(point[3]);
					} else {
						continue;
					}
				}
			}
			return answer;
		}


		function replaceControls(target) {
			// move ball back to origin and move set accordingly
			// so if we animate the set it will behave as expected
			if (target.type != "Circle") return;
			var ball = target;
			var set = ball.mySet;
			var rect1 = ball.rect1;
			var rect2 = ball.rect2;
			rect1.x -= ball.x;
			rect1.y -= ball.y;
			rect2.x -= ball.x;
			rect2.y -= ball.y;
			set.x += ball.x;
			set.y += ball.y;
			ball.x = 0;
			ball.y = 0;
		}

		that.selectionManager.on("keydown", function (e) {
			if (!that.selectPoints) return;
			if (!that.keyFocus) return;
			if (e.keyCode >= 37 && e.keyCode <= 40) {
				var currentSelected = getCurrentSelected();
				if (currentSelected.length > 0) {
					for(var i=0; i<currentSelected.length; i++) {
						var pointObj = currentSelected[i];
						if (e.keyCode == 37) pointObj.x -= that.selectionManager.shiftKey?10:1;
						else if (e.keyCode == 39) pointObj.x += that.selectionManager.shiftKey?10:1;
						else if (e.keyCode == 38) pointObj.y -= that.selectionManager.shiftKey?10:1;
						else if (e.keyCode == 40) pointObj.y += that.selectionManager.shiftKey?10:1;
						mapMove(pointObj);
					}
					drawShape();
					if (that.stage) that.stage.update();
				}
			}
		});

		that.selectionManager.on("keyup", function (e) {
			if (!that.selectPoints) return;
			if (!that.keyFocus) return;
			if (e.keyCode >= 37 && e.keyCode <= 40) {
				var currentSelected = getCurrentSelected();
				if (currentSelected.length > 0) {
					for(var i=0; i<currentSelected.length; i++) {
						replaceControls(currentSelected[i]);
					}
				}
			}
		});

		that.selectionManager.on("undo", function () {
			if (!that.selectPoints) return;
			if (!that.keyFocus) return;
			if (that.lastPoints) {
				var tempPoints = zim.copy(that.lastPoints);
				that.lastPoints = zim.copy(that.points);
				that.points = tempPoints;
				if (that.stage) that.stage.update()
			}
		});
		// }


		mapMove = function (target) {
			if (that.lockControls) return;
			if (target.rect1) { // pressmove on ball
				var ball = target;
				var diffX = ball.x - ball.startX;
				var diffY = ball.y - ball.startY;
				ball.rect1.x = ball.rect1.startX + diffX;
				ball.rect1.y = ball.rect1.startY + diffY;
				ball.rect2.x = ball.rect2.startX + diffX;
				ball.rect2.y = ball.rect2.startY + diffY;
			} else { // pressmove on control
				var rect = target;
				var other = rect.other; // the other handle
				var ball = rect.ball;
				var index = ball.index;
				var type = controlType;
				if (!zot(_points[index][4])) type = _points[index][4];
				if (type == "straight" || type == "mirror") {
					var dX = rect.x - ball.x;
					var dY = rect.y - ball.y;
					if (type == "mirror") {
						other.x = ball.x - dX;
						other.y = ball.y - dY;
					} else {
						var a = Math.atan2(dY, dX);
						var dNewX = -other.stickLength * Math.cos(a+Math.PI);
						var dNewY = -other.stickLength * Math.sin(a+Math.PI);
						other.x = ball.x - dNewX;
						other.y = ball.y - dNewY;
					}
				}
			}

			// that.setBounds();
			// decided not to dynamically set bounds
			// they really just go around the control points and not the shape
			// and if dynamically set they go to null if the control points are not showing
		};

		Object.defineProperty(that, 'move', {
			get: function() {
				return move;
			},
			set: function(value) {
				if (move != value) {
					move = value;
					if (value) {
						startDragging();
					} else {
						stopDragging();
					}
				}
			}
		});

		Object.defineProperty(that, 'interactive', {
			get: function() {
				return interactive;
			},
			set: function(value) {
				interactive = value;
				that.showControls = interactive;
				that.allowToggle = interactive;
				that.editPoints = interactive;
				that.lockControls = !interactive; // note negative!
				that.selectPoints = interactive;
				that.move = interactive;
				that.points = that.points; // force remake
			}
		});

		Object.defineProperty(that, 'allowToggle', {
			get: function() {
				return allowToggle;
			},
			set: function(value) {
				if (allowToggle != value) {
					allowToggle = value;
					if (allowToggle) {
						if (that.move) startDragging();
					} else {
						if (!_controls && that.move) stopDragging();
					}
				}
			}
		});

		function startDragging() {
			if (that.move=="always") return;
			if (draggingCheck) return;
			draggingCheck = true;
			shape.drag({onTop:false});
			moveDownEvent = shape.on("mousedown", moveDownEvent);
			movePressEvent = shape.on("pressmove", movePressEvent);
			moveUpEvent = shape.on("pressup", moveUpEvent);
		}
		function stopDragging(making) {
			if (that.move=="always") return;
			if (!making && !draggingCheck) return;
			draggingCheck = false;
			shape.noDrag();
			shape.off("mousedown", moveDownEvent);
			shape.off("pressmove", movePressEvent);
			shape.off("pressup", moveUpEvent);
		}

		var _lockControls = lockControls;
		Object.defineProperty(that, 'lockControls', {
			get: function() {
				return _lockControls;
			},
			set: function(value) {
				_lockControls = value;
				if (value) {
					that.controls.mouseChildren = false;
					that.controls.mouseEnabled = false;
				} else {
					that.controls.mouseChildren = true;
					that.controls.mouseEnabled = true;
				}
			}
		});
		that.lockControls = _lockControls;

		Object.defineProperty(that, 'controlsVisible', {
			get: function() {
				return _controls;
			},
			set: function(value) {
				_controls = value;
				if (value) {
					that.showControls();
				} else {
					that.hideControls();
				}
			}
		});

		Object.defineProperty(that, 'color', {
			get: function() {
				return _color;
			},
			set: function(value) {
				if (zot(value)) value = "black";
				_color = value;
				colorObj.style = _color;
			}
		});
		var startColor;
		var endColor;
		this.setColorRange = function(color1, color2) {
			if (zot(color2)) {
				startColor = that.color;
				endColor = color1;
			} else if (zot(color1)) {
				startColor = that.color;
				endColor = color2;
			} else {
				startColor = color1;
				endColor = color2;
			}
			return that;
		}
		var _colorRange = 0;
		Object.defineProperty(that, 'colorRange', {
			get: function() {
				return _colorRange;
			},
			set: function(value) {
				_colorRange = value;
				if (!zot(startColor) && !zot(endColor)) {
					that.color = zim.colorRange(startColor, endColor, value);
				}
			}
		});

		Object.defineProperty(that, 'thickness', {
			get: function() {
				return _thickness;
			},
			set: function(value) {
				if (!(value>0)) value = 0;
				_thickness = value;
				if (!thicknessObj || _thickness == 0) drawShape();
				else {
					thicknessObj.width = _thickness;
					if (dashed) {
						borderDashedObj.segments = [20, 10];
						borderDashedObj.offset = 5;
					}
				}
			}
		});

		if (typeof KEYFOCUS !== typeof undefined) zim.KEYFOCUS = KEYFOCUS;
		Object.defineProperty(this, 'keyFocus', {
			get: function() {
				return zim.KEYFOCUS == that;
			},
			set: function(value) {
				zim.KEYFOCUS = that;
			}
		});
		if (!zim.KEYFOCUS) setFocus();
		function setFocus() {if (!that.selectPoints) return; that.keyFocus = true; var d=document.activeElement; if (d) d.blur();}


		Object.defineProperty(that, 'points', {
			get: function() {
				var points = [];
				var point; var p;
				for (var i=0; i<_points.length; i++) {
					p = _points[i];
					point = [
						zim.decimals(p[0].x),
						zim.decimals(p[0].y),
						zim.decimals(p[1].x),
						zim.decimals(p[1].y),
						zim.decimals(p[2].x),
						zim.decimals(p[2].y),
						zim.decimals(p[3].x),
						zim.decimals(p[3].y)
					];
					if (p[4] && p[4]!=="mirror") point.push(p[4])
					points.push(point);
				}
				return points;
			},
			set: function(value) {
				that.dispose(true);
				points = value;

				if (that.shape) {
					that.shape.graphics.clear();
					that.sticks.graphics.clear();
					that.controls.noDrag();
					that.removeAllChildren();
					delete that.shape;
					delete that.sticks;
					delete that.controls;
				}
				init(); // remake Squiggle
				that.lockControls = _lockControls;
 			}
		});

		Object.defineProperty(that, 'pointsAdjusted', { // points with rotation
			get: function() {
				var points = [];
				var point; var p; var poo;
				var pObjects = that.pointObjects;
				zim.loop(pObjects.length, function(i, t) {
					po = pObjects[i];
					p = _points[i];
					if (po[0].rotation==0 && po[0].scaleX==0 && po[0].scaleY==0) { // get points
						point = [
							zim.decimals(p[0].x),
							zim.decimals(p[0].y),
							zim.decimals(p[1].x),
							zim.decimals(p[1].y),
							zim.decimals(p[2].x),
							zim.decimals(p[2].y),
							zim.decimals(p[3].x),
							zim.decimals(p[3].y)
						];
					} else {
						var lo1 = po[0].localToLocal(po[2].x, po[2].y, po[0].parent);
						var lo2 = po[0].localToLocal(po[3].x, po[3].y, po[0].parent);
						point = [
							zim.decimals(p[0].x),
							zim.decimals(p[0].y),
							zim.decimals(p[1].x),
							zim.decimals(p[1].y),
							zim.decimals(lo1.x-p[0].x),
							zim.decimals(lo1.y-p[0].y),
							zim.decimals(lo2.x-p[0].x),
							zim.decimals(lo2.y-p[0].y)
						];
					}
					if (p[4] && p[4]!=="mirror") point.push(p[4])
					points.push(point);
				});
				return points;
			},
			set: function(value) {
				if (zon) zog("Squiggle() - pointsAdjusted is read only")
 			}
		});

		Object.defineProperty(that, 'pointObjects', {
			get: function() {
				return _points;
			},
			set: function(value) {
				if (zon) {zog("Squiggle() - pointObjects is read only - but its contents can be manipulated - use squiggle.update() after changes")}
 			}
		});

		Object.defineProperty(that, 'pointControls', {
			get: function() {
				return _pointControls;
			},
			set: function(value) {
				if (zon) {zog("Squiggle() - pointControls is read only - but its contents can be manipulated - use blob.update() after changes")}
			}
		});

		Object.defineProperty(that, 'pointCircles', {
			get: function() {
				return _pointCircles;
			},
			set: function(value) {
				if (zon) {zog("Squiggle() - pointCircles is read only - but its contents can be manipulated - use blob.update() after changes")}
			}
		});

		// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		// path manipulation and animating to path methods

		Object.defineProperty(that, 'segmentPoints', {
			get: function() {
				var array = []; // array of prepared segment points
				var p = that.pointsAdjusted;
				zim.loop(p.length-1, function(i, t) {
					var s = that.getSegmentPoint(p[i], p[i+1])
					array.push(s);
				});
				return array;
			},
			set: function(value) {
				if (zon) {zog("Squiggle() - segmentPoints is read only")}
			}
		});

		Object.defineProperty(that, 'segmentRatios', {
			get: function() {
				var distances = []
				var total = 0;
				zim.loop(that.segmentPoints, function(points) {
					var d = zim.distanceAlongCurve(points)
					distances.push(d);
					total += d;
				});
				var percents = [];
				var totalPercents = 0;
				zim.loop(distances, function (d) {
					var p = d/total;
					totalPercents += p;
					percents.push(totalPercents);
				});
				return percents;
			},
			set: function(value) {
				if (zon) {zog("Squiggle() - segmentRatios is read only")}
			}
		});

		that.getPointAngle = function(index) {
			var p = that.pointObjects[index][0]; // parent
			var r1 = that.pointObjects[index][2];
			var r2 = that.pointObjects[index][3];
			if (p==that.stage) {
				var globalR1 = new zim.Point(r1.x, r1.y);
				var globalR2 = new zim.Point(r2.x, r2.y);
			} else {
				var globalR1 = p.localToGlobal(r1.x, r1.y);
				var globalR2 = p.localToGlobal(r2.x, r2.y);
			}
			return zim.angle(globalR1.x, globalR1.y,globalR2.x, globalR2.y);
		}

		that.getSegmentPoint = function(point1, point2) {
			if (zot(point1) || zot(point2)) return;
			// dragging points temporarily puts data out of order
			if (point1[2] != 0 || point1[3] != 0) {
				point1[4] -= point1[2];
				point1[5] -= point1[3];
				point1[6] -= point1[2];
				point1[7] -= point1[3];
				point1[0] += point1[2];
				point1[1] += point1[3];
				point1[2] = 0;
				point1[3] = 0;
			}
			if (point2[2] != 0 || point2[3] != 0) {
				point2[4] -= point2[2];
				point2[5] -= point2[3];
				point2[6] -= point2[2];
				point2[7] -= point2[3];
				point2[0] += point2[2];
				point2[1] += point2[3];
				point2[2] = 0;
				point2[3] = 0;
			}
			var p1 = {x:point1[0], y:point1[1]};
			var p2 = {x:point1[0]+point1[6], y:point1[1]+point1[7]};
			var p3 = {x:point2[0]+point2[4], y:point2[1]+point2[5]};
			var p4 = {x:point2[0], y:point2[1]};
			if (sets.x != 0 || sets.y !=0) {
				p1.x+=sets.x;
				p2.x+=sets.x;
				p3.x+=sets.x;
				p4.x+=sets.x;
				p1.y+=sets.y;
				p2.y+=sets.y;
				p3.y+=sets.y;
				p4.y+=sets.y;
			}
			return [p1,p2,p3,p4];
		}

		that.getAdjacentSegmentData = function(index) {
			if (zot(index)) index = 0;
			var p = that.pointsAdjusted;
			if (that.num == 2) {
				return [
					[that.getSegmentPoint(p[0], p[1])],
					[0]
				]
			}
			if (index == 0) {
				return [
					[that.getSegmentPoint(p[0], p[1]),
					that.getSegmentPoint(p[1], p[2])],
					[0,1]
				];
			} else if (index >= that.num-2) {
				return [
					[that.getSegmentPoint(p[that.num-3], p[that.num-2]),
					that.getSegmentPoint(p[that.num-2], p[that.num-1])],
					[that.num-3, that.num-2]
				];
			} else {
				return [
					[that.getSegmentPoint(p[index-1], p[index]),
					that.getSegmentPoint(p[index], p[index+1]),
					that.getSegmentPoint(p[index+1], p[index+2])],
					[index-1,index,index+1]
				];
			}
		}

		that.getCurvePoint = function(ratio, segmentRatios, segmentPoints, getAngle) {
			if (zot(ratio) || isNaN(ratio)) ratio = 0;
			if (zot(segmentRatios)) segmentRatios = that.segmentRatios;
			if (zot(segmentPoints)) segmentPoints = that.segmentPoints;
			if (zot(getAngle)) getAngle = false;
			var percents = segmentRatios;
			var segments = segmentPoints;
			var afterIndex = zim.loop(percents, function (p, i) {
				if (p >= ratio) return i;
			});
			var earlierPercent = afterIndex > 0 ? percents[afterIndex-1] : 0;
			var localTotal = afterIndex > 0 ? (percents[afterIndex]-percents[afterIndex-1]):percents[afterIndex];
			if (!localTotal) return undefined;
			var localPercent = (ratio-earlierPercent)/localTotal;
			var finalPoint = zim.pointAlongCurve(segments[afterIndex], localPercent, getAngle);
			var finalFinalPoint = that.localToGlobal(finalPoint.x, finalPoint.y);
			finalFinalPoint.angle = finalPoint.angle;
			finalFinalPoint.z = afterIndex;
			return !zot(finalFinalPoint) ? finalFinalPoint : undefined;
		}

		function proportion(p1, p2, ratio) {
			return {
				x:p1.x + (p2.x-p1.x)*ratio,
				y:p1.y + (p2.y-p1.y)*ratio
			}
		}
		function insertPointData(points, controls, ratios, percent, controlType, skipPoint, dataOnly) {
			var index = points.length-1; // adjust for squiggle
			var lastRatio = 0;
			var currentRatio = 0;
			if (percent == 100 && that.type == "Squiggle") percent = 99.99;
			percent = (percent+100000)%100;

			zim.loop(ratios, function (ratio, i) {
				if (percent/100 < ratio) {
					index = i;
					currentRatio = ratio;
					return true;
				}
				lastRatio = ratio;
			});
			var segment = that.segmentPoints[index];
			var r = currentRatio > 0?(percent/100-lastRatio)/(currentRatio-lastRatio):0
			// zog(percent)
			// zog(percent/100-currentRatio/ratios.length)
			// var r = currentRatio > 0?(percent/100-1/ratios.length*currentRatio)/(currentRatio-lastRatio):0

			var point = zim.pointAlongCurve(segment, r)
			var newPoint = [point.x,point.y, 0, 0];
			if (skipPoint) return;
			if (dataOnly) {
				that.interpolatedPoints.push({x:point.x, y:point.y, r:percent/100});
				return;
			}
			if (controlType != "none") {
				// calculate new handles and adjust old handles
				// [controlX, controlY, circleX, circleY, rect1X, rect1Y, rect2X, rect2Y, controlType]
				var startHandle = proportion(segment[0], segment[1], r);
				var midPoint = proportion(segment[1], segment[2], r);
				var endHandle = proportion(segment[2], segment[3], r);
				var newStartHandle = proportion(startHandle, midPoint, r);
				var newEndHandle = proportion(midPoint, endHandle, r);
				newPoint[4] = newStartHandle.x-point.x
				newPoint[5] = newStartHandle.y-point.y;
				newPoint[6] = newEndHandle.x-point.x;
				newPoint[7] = newEndHandle.y-point.y;
				var start = that.localToLocal(startHandle.x, startHandle.y, controls[index])
				points[index][6] = start.x;
				points[index][7] = start.y;
				var end = that.localToLocal(endHandle.x, endHandle.y, controls[(index+1)%points.length])
				points[(index+1)%points.length][4] = end.x;
				points[(index+1)%points.length][5] = end.y;
			}
			if (controlType) newPoint[8] = controlType;
			points.splice(index+1, 0, newPoint);
		}

		this.addPoint = function(percent, controlType) {
			if (zot(percent)) percent = 100;
			var points = that.points;
			var ratios = that.segmentRatios;
			var controls = that.pointControls;
			insertPointData(points, controls, ratios, percent, controlType);
			that.points = points;
			that.num = points.length;
			return that;
		}

		this.addPoints = function(num, controlType, startPoint, spread, dataOnly, points) {
			if (zot(points)) points = zim.copy(that.points);
			var ratios = zim.copy(that.segmentRatios);
			var lastRatio = 0;

			if (dataOnly) that.interpolatedPoints = [];

			// dataOnly should add points to current point too
			// but can't just use current point because sometimes that is static
			// like when dragging the shape or a point - it does not register until mouseup
			// and things like hitTestPath need that to be dynamic
			// So the below does not work:
			// if (dataOnly) {
			// 	that.interpolatedPoints = [];
			// 	zim.loop(points, function (point, i) {
			// 		if (!zot(startPoint) && i!=startPoint) return;
			// 		that.interpolatedPoints.push({x:point[0], y:point[1]})
			// 	});
			// }
			if (spread) var totalPoints = ratios.length*num;
			zim.loop(ratios, function (ratio, j) {
				if (dataOnly) insertPointData(points, that.pointControls, that.segmentRatios, lastRatio*100, controlType, !zot(startPoint) && j!=startPoint, dataOnly);
				var numCount = spread?Math.round(totalPoints*(ratio-lastRatio)):num
				var div = 1/(numCount+1);
				zim.loop(numCount, function(i) {
					var r = lastRatio + (ratio-lastRatio)*div*(i+1);
					insertPointData(points, that.pointControls, that.segmentRatios, r*100, controlType, !zot(startPoint) && j!=startPoint, dataOnly);
					if (!dataOnly && num > 0) that.points = points;
				});
				lastRatio = ratio;
			});
			if (dataOnly && that.type == "Squiggle") insertPointData(points, that.pointControls, that.segmentRatios, 100, controlType, null, dataOnly);
			if (that.stage) that.stage.update();
			that.num = points.length;
			return that;
		}
		this.interpolate = function(num, startPoint, spread, points) {
			if (zot(num)) num = 1;
			// dataOnly will add Point to start point too
			that.addPoints(num, "none", startPoint, spread, true, points)
			return that.interpolatedPoints;
		}

		this.linearGradient = function(colors,ratios,x0,y0,x1,y1) {
			this.linearGradientParams = Array.prototype.slice.call(arguments);
			this.thicknessCommand.linearGradient(colors,ratios,x0,y0,x1,y1);
			return this;
		}
		this.radialGradient = function(colors,ratios,x0,y0,radius0,x1,y1,radius1) {
			this.radialGradientParams = Array.prototype.slice.call(arguments);
			this.thicknessCommand.radialGradient(colors,ratios,x0,y0,radius0,x1,y1,radius1);
			return this;
		}

		this.dispose = function(temp) {
			// if (that.toggleStageEvent) that.stage.off("stagemousedown", that.toggleStageEvent);
			// this.zimContainer_dispose();
			// return true;
			if (!that.shape) return;
			that.shape.cursor = "default";
			for (var i=0; i<that.points.length; i++) {
				that.pointObjects[i][1].removeAllEventListeners();
			}
			for (i=0; i<_pointCircles.length; i++) {
				_pointCircles[i].removeAllEventListeners();
			}
			that.sticks.removeFrom(that);
			that.controls.removeFrom(that);
			that.shape.removeAllEventListeners();
			that.controls.removeAllEventListeners();
			that.off("mousedown", that.toggleEvent);
			that.off("click", that.clickEvent);
			if (that.toggleStageEvent) that.stage.off("stagemousedown", that.toggleStageEvent);
			if (!temp && that.selectPoints) that.selectionManager.removeAllEventListeners();
			return
		}
	}
	zim.extend(zim.Squiggle, zim.Container, ["clone", "dispose"], "zimContainer", false);
	//-53.2


/*--
zim.Blob = function(color, borderColor, borderWidth, points, radius, controlLength, controlType, lockControlType, showControls, lockControls, handleSize, allowToggle, move, dashed, onTop, stickColor, selectColor, selectPoints, editPoints, interactive, strokeObj, style, group, inherit)

Blob
zim class - extends a zim.Container which extends a createjs.Container

DESCRIPTION
Makes a blob shape inside a container using a number of points.
The points have Bezier controls - little handles that change the shape of the Blob.
The type of control can be specified overall and individually - and can be hidden or shown
The type of control can be changed by double clicking the point - colors of the handles will change
Points can be added by clicking on the shape or removed by SHIFT clicking a point.
CTRL Z will undo adding or removing a point
The shape of the Blob can be recorded with the recordData() method and recreated with the setData() method
The Blob is set by default to show and hide controls when clicked
It is also draggable by default when the controls are showing

MULTIPLE SELECT
Multiple points can be selected and dragged or moved with the keyboard arrows (moves 10 pixels with shift key down)

NOTE: mouseChildren is turned to false for all zim Shape containers.
NOTE: with the ZIM namespace zns = false, this overwrites a JS Blob - so the JS Blob is stored as document.Blob

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var blob = new Blob(); // makes a circle with default 4 points with Bezier controls
blob.center(stage);

var moreBlob = new Blob({
	points:12, // 12 points for more complex shape
}).center(stage);

var specifiedBlob = new Blob({
	color:purple,
	controlType:"free", // free will be default control type (rather than "straight")
	points:[
		// the control position x, y
		// then three point positions inside the control - so relative to the control position
		// 1. circle position x, y (usually the same as the control position - so 0,0)
		// 2. the location of the first control rectangle x and y
		// 3. the location of the second control rectangle x and y
		// then an optional specific type of control that overrides the controlType parameter (or the default type of "straight")
		[-100,-100,-100,100,100,-100,0,0,"mirror"], // this will be type "mirror"
		[100,-100,100,0,-50,0], // this will be type "free" because controlType parameter
		[100,100], // these will be type "none" because no dimensions (or dimensions 0) specified for controls
		[-100,100]
	]
}).centerReg(stage).drag();
END EXAMPLE

EXAMPLE
// Transform the original points of a Blob
// If you rotate or scale, this affects the control points - the little rectangles rotate or they scale
// To avoid this, the points themselves can be transformed (scaleX, scaleY, scale, rotation, x, y)
// This makes a square and scales it bigger without affecting control size or stroke size (if there were a stroke)
// Note the default number of points is 4 but they are arranged at the top, bottom and sides - so would make a diamond with just controlType:"none"
new Blob({controlType:"none"}).transformPoints("rotation", 45).transformPoints("scale", 2).center();
END EXAMPLE

EXAMPLE
// make a Blob the shape of basic ZIM shapes
// this overrides the path parameter
new Blob({shape:"circle"}).pos(200,200);
new Blob({shape:new Rectangle(100,200)}).center();
new Blob({shape:new Triangle()}).transformPoints("rotation", 90).pos(50,50,true,true);
END EXAMPLE

EXAMPLE
// Animate along a Blob
// see https://zimjs.com/explore/blobAnimate.html for more
// see https://zimjs.com/explore/blobAnimate2.html for more
var path = new Blob().center();
new Circle(10, red).addTo().animate({path:path}, 1000);
END EXAMPLE

EXAMPLE
// Animate one Blob into another
var targetBlob = new Blob({points:"rectangle"});
var blob = new Blob({radius:50, points:"circle", interactive:false})
	.pos(200,200)
	.transformPoints("rotation", -45) // to better tween to rectangle
	.animate({
		props:{shape:targetBlob},
		time:1000,
		rewind:true,
		loop:true
	});
END EXAMPLE

PARAMETERS
** supports DUO - parameters or single object with properties below
** supports VEE - parameters marked with ZIM VEE mean a zim Pick() object or Pick Literal can be passed
   Pick Literal formats: [1,3,2] - random; {min:10, max:20} - range; series(1,2,3) - order, function(){return result;} - function
** supports OCT - parameter defaults can be set with STYLE control (like CSS)
color - (default green) the fill color as any CSS color including "rgba()" for alpha fill (set a to 0 for tranparent fill)
borderColor - (default null) the stroke color
borderWidth - (default 1 if stroke is set) the size of the stroke in pixels
num - get the number of points - to set, use the points property
points - (default 4) a number of points to start with to make the shape
	OR a shape string of "circle", "rectangle" or "triangle"
	OR a ZIM Circle, Rectangle or Triangle with any dimensions that will be matched
	OR an SVG path like: points:"M0,129.5c22,0,40-31,40-41c0-8-3.2-13-10-13" etc. (also see SVGContainer)
	OR an array of points as follows:
	[[controlX, controlY, circleX, circleY, rect1X, rect1Y, rect2X, rect2Y, controlType], [etc]]
	controlX and controlY - the x and y location of the control Container which holds the point circle and the two control rectangles
	rect1X, rect1Y, rect2X, rect2Y - (default based on controlLength) the x and y location of the control rectangles relative to the control location
	circleX and circleY - (default 0) the x and y location of the circle relative to the control location (usually 0, 0)
	controlType - (default main controlType parameter or "straight" if not controlType parameter) the point's controlType "none", "mirror", "straight" or "free"
radius - (default 100) the default radius of the circle used to create the blob (also specifies the blob's bounds(-radius, -radius, radius*2, radius*2))
controlLength - |ZIM VEE| (default radius*numPoints/4) specify a Number to override the calculated default
controlType - (default "straight") one of four String values as follows:
	none - there are no control rectangles (they are actually set at 0,0).  This makes a corner at the circle point.
	mirror - the control rectangles reflect one another about the point circle - lengths are kept even
	straight - the control rectangles keep a straight line through the point circle but length is independent
	free - the control rectangle moves independently from the other control rectangle
	** The controlType can be specified for each point - see the points parameter
	** The controlType can be changed by doubleClicking the point circle to cycle through the controls in the order above - unless the lockControlType is set to true
lockControlType - (default false) set to true to disable doubleClicking of point circles to change controlType
showControls - (default true) set to false to start with controls not showing - can change this after with control property or showControls() method
lockControls - (default false) set to true to lock the editing of controls - can't move the points or handles - but can see them if showControls is set to true
handleSize - (default 20 mobile 10 for non-mobile) the size of control boxes and affects the circles too proportionally
	If a handleSize of 0 is chosen, then the sticks will disappear too
allowToggle - (default true) set false to let turn off clicks showing and hiding controls
move - (default true) set to false to disable dragging when controls are showing
	can also set to "always" to allow movement when controls are not showing
dashed - (default false) set to true for dashed border (if borderWidth or borderColor set)
onTop - (default true) set to false to not bring shape to top of container when dragging
stickColor - (default "#111") set the stick color of the controls
selectColor - (default white) the color of the selected circle or rectangle of the controls if selectPoints is true
selectPoints - (default true) set to false to not allow point controls to be selected for keyboard control
editPoints - (default true) lets user add points by pressing on shape path.
	set to "anywhere" to let users add points anywhere - will add points with controlType:"none"
	set to false to not allow adding or removing points with click or shift click
interactive - (default true) set to false to turn off controls, move, toggle, select, edit - leaving just the shape
strokeObj - (default {caps:"butt", joints:"miter", miterLimit:10, ignoreScale:false}) set to adjust stroke properties
	caps options: "butt", "round", "square" or 0,1,2
	joints options: "miter", "round", "bevel" or 0,1,2
	miterLimit is the ration at which the mitered joint will be clipped
	ignoreScale set to true will draw the specified line thickness regardless of object scale
style - (default true) set to false to ignore styles set with the STYLE - will receive original parameter defaults
group - (default null) set to String (or comma delimited String) so STYLE can set default styles to the group(s) (like a CSS class)
inherit - (default null) used internally but can receive an {} of styles directly

METHODS
addPoint(percent, controlType) - add a point at a percent (100) of the total curve
	this is handy to make path have the same number of points for animate() path tweens
	controlType can be as specified in main points parameter
	returns object for chaining
addPoints(num, controlType, startPoint) - add num points between existing points
	controlType can be as specified in main points parameter
	specify a startPoint to add points between the startPoint and the next point (one segment of points)
	spread (default false) set to true to spread points evenly around path rather than evenly between segments
	dataOnly and points are used internally
	returns object for chaining
interpolate(num, startPoint, spread) - get point data {x,y} for this existing points and num (default 1) points inbetween
	used with hitTestPath
	specify a startPoint to get points between the startPoint and the next point (one segment of points)
	spread (default false) set to true to spread points evenly around path rather than evenly between segments
	returns an array of point objects with x, y properties and an r property for ratio of distance along path
recordData(toJSON) - returns an object with x, y, points, color, borderColor, borderWidth, move, toggle, controls PROPERTIES to be used with setData() method
	if toJSON (default false) is set to true, the return value is a JSON string
	the points data comes from the points property
setData(data, fromJSON) - sets the properties to match the data object passed in - this should come from recordData()
	if fromJSON (default false) is set to true, it will assume a JSON string is passed in as data
	the points data is parsed with the set setPoints() so the number of points should be the same
	returns object for chaining
recordPoints(popup) - returns an array with the same format as the points parameter - or can just use points property
	popup - (default false) set to true to open a zim Pane (blob.pane) with the points in a zim TextArea (blob.textArea) (click off to close)
	NOTE: the TextArea output uses JSON.stringify() - to add the points to the points parameter of the Blob use JSON.parse(output);
	NOTE: using zog(JSON.stringify(blob.recordData()))... the console will remove the quotes from the controlTypes so those would have to be manually put back in before parse() will work
setPoints(data) - sets the Blob points to the data from recordPoints
	This does not remake the Blob but rather shifts the controls so the number of points should be the same
changeControl(index, type, rect1X, rect1Y, rect2X, rect2Y, circleX, circleY, update) - change a control type and properties at an index
	accepts ZIM DUO normal parameters or configuration object literal with parameter names as propterties
	passing in null as the index will change all points to the specified properties
	the update parameter defaults to false so set to true to show update or call update() below
	this is so multiple changes can be batched before calling update - for instance when animating blobs.
transformPoints(transformType, amount, x, y) - scale, rotate, move points without affecting controls or borderWidth - returns object for chaining
	Note - does not adjust original Bounds
	transformType - String any of: "scale", "scaleX", "scaleY", "rotation", "x", "y"
	amount - the amount to transform
	x, y - (default 0, 0) the x and y position to transform about
update(normalize) - update the Blob if animating control points, etc. would do this in a Ticker
	set normalize (default false) to true to use pointsAdjusted for rotated and scaled points
	use true for manually editing points after setting rotation or scale on point
	just leave out if only animating points
showControls() - shows the controls (and returns blob) - or use  blob.controlsVisible = true property
hideControls() - hides the controls (and returns blob) - or use blob.controlsVisible = false property
toggle(state - default null) - shows controls if hidden and hides controls if showing (returns the object for chaining)
	or pass in true to show controls or false to hide controls
traverse(obj, start, end, time) - animates obj from start point to end point along path - thanks KV for the thought!
	set start point greater than end point to traverse backwards
	will dispatch a "traversed" event when done
setColorRange(color1, color2) - set a color range for shape - used by colorRange property - returns obj for chaining
	if one color is used, the current color is used and color1 is the second color in the range
getPointAngle(index) - gets the angle made by the tangent at the index provided
getSegmentPoint(point1, point2) - returns an array of [point1, controlPoint1, controlPoint2, point2]
	used internally for animating to path and adding removing Bezier points
getAdjacentSegmentData(index) - returns an array of two arrays:
	The first is an array of cubic Bezier points for segments adjacent and including the provided point index
	each element is in the form of [point1, controlPoint1, controlPoint2, point2]
	The second is an array of starting point indexes for the segments that were tested
	used internally to drag an animation along the path
	will wrap around the blob if needed
getCurvePoint(ratio, segmentRatios, segmentPoints) gets a point along whole curve at the ratio (0-1) provided
	along with x and y values, the point has a z value that is the index of the blob point before the calculated point
	the point also has an angle property which is the angle of the tangent at the point
	ratio is 0-1 with 0 being at the first point and 1 being at the end of the last segment (the first point)
	segmentRatios and segmentPoints will be calculated if not provided
	used internally for animating along the path - if lockControls is true, only animate will precalculate these values
linearGradient([colors],[ratios], x0,y0, x1,y1) - shortcut to colorCommand linearGradient method (see properties below)
radialGradient([colors],[ratios], x0,y0,radius0, x1,y1,radius1) - shortcut to colorCommand radialGradient method (see properties below)
cache(see Container docs for parameter description) - overrides CreateJS cache() and returns object for chaining
	Leave parameters blank to cache bounds of shape (plus outer edge of border if borderWidth > 0)
hasProp(property as String) - returns true if property exists on object else returns false
clone() - makes a copy of the shape
dispose() - removes from parent, removes event listeners - must still set outside references to null for garbage collection

ALSO: ZIM 4TH adds all the methods listed under Container (see above), such as:
drag(), hitTestRect(), animate(), sca(), reg(), mov(), center(), centerReg(),
addTo(), removeFrom(), loop(), outline(), place(), pos(), alp(), rot(), setMask(), etc.
ALSO: See the CreateJS Easel Docs for Container methods, such as:
on(), off(), getBounds(), setBounds(), uncache(), updateCache(), dispatchEvent(),
addChild(), removeChild(), addChildAt(), getChildAt(), contains(), removeAllChildren(), etc.

PROPERTIES
type - holds the class name as a String
shape - gives access to the shape of the blob
color - get and set the fill color
colorRange - if setColorRange() is used, the colorRange is a ratio (0-1) between the colors
	setting the colorRange will change the color property of the shape
	for instance, shape.setColorRange(blue, pink) then shape.colorRange = .5
	will set the color of the shape to half way between blue and pink
	shape.animate({color:red}, 1000); is a shortcut to animate the colorRange
	shape.wiggle("colorRange", .5, .2, .5, 1000, 5000) will wiggle the colorRange
colorCommand - access to the CreateJS fill command for bitmap, linearGradient and radialGradient fills
	eg. shape.colorCommand.linearGradient([green, blue ,green], [.2, .5, .8], 0, 0, shape.width, 0)
	See: https://www.createjs.com/docs/easeljs/classes/Graphics.Fill.html
borderColor - get and set the stroke color
borderColorCommand - access to the CreateJS stroke command for bitmap, linearGradient and radialGradient strokes
	See: https://www.createjs.com/docs/easeljs/classes/Graphics.Stroke.html
borderWidth - get and set the stroke size in pixels
borderWidthCommand - access to the CreateJS stroke style command (width, caps, joints, miter, ignoreScale)
	See: https://www.createjs.com/docs/easeljs/classes/Graphics.StrokeStyle.html
borderDashedCommand - access to the CreateJS stroke dashed command (segments, offset)
	see https://www.createjs.com/docs/easeljs/classes/Graphics.StrokeDash.html
stickColor - get or set the stick color of the controls - requires an update() to see changes
points - get or set the points array of the Blob in the same format as the points parameter:
	a number, a shape string ("circle", "rectangle", "triangle"), a ZIM Circle, Rectangle, Triangle
	or an array as follows:
	[[controlX, controlY, circleX, circleY, rect1X, rect1Y, rect2X, rect2Y, controlType], [etc]]
pointsAdjusted - get points with any point rotation converted to 0 - see update(true)
pointControls - get an array of controls (a container) - use this to animate controls
pointCircles - get an array of control circles - use this to place some other object at the point
pointObjects - get an array of point objects for each point in the following format:
	[[control, circle, rect1, rect2, controlType], [etc.]]
	control - the container for the control that holds the circle and rectangles (also see pointControls)
	circle - the control point circle (also see pointCircles)
	rect1 - the first control point rectangle
	rect2 - the second control point rectangle
	controlType - the control type: default is "straight" (or null) and there is also "mirror", "free" and "none"
	NOTE: control, circle, rect1, rect2 can be positioned or animated and controlType can be changed
	NOTE: the update() method must be called if manually changing the control positions or type
	NOTE: if constantly animating the controls then use a Ticker.add(function(){blob.update();})
	NOTE: also see recordData(), setData(), recordPoints(), setPoints() methods for further options
addPointFactor - (default 20) used when placing new points along edge (editPoints is true)
	divides the distance between points by this amount - the smaller the more accurate but also slower
addMinDistance - (default 15) edge press needs to be within this distance to add a point to the edge
segmentPoints - a read-only array of cubic Bezier points for each segment
	each element is in the form of [point1, controlPoint1, controlPoint2, point2]
	used internally to animate to the path and add and remove Bezier points
segmentRatios - a read-only array of cumulative ratio lengths of segments
	for instance the default four points is [.25, .5, .75, 1]
	used internally to animate to the path and attribute proportional time to each segment
controls - access to the container that holds the sets of controls
	each control is given a read-only num property
sticks - access to the container that holds the control sticks
lastSelected - access to the last selected (or created) control container
lastSelectedIndex - the index number of the last selected controls
controlsVisible - get or set the visibility of the controls - or use showControls() and hideControls()
types - get or set the general array for the types ["mirror", "straight", "free", "none"]
	changing this or removing a type will adjust the order when the user double clicks the points to change their type
	this is not an array of types for each point - see the points property to access the types of each point
lockControls - Boolean to lock controls from being adjusted or not
allowToggle - Boolean to get or set clicking to show and hide controls
move - Boolean to drag or not drag Blob when controls are showing
	can also set to "always" to allow movement when controls are not showing
lockControlType - Boolean to lock the type of the controls in their current state or not
onTop - get or set the onTop property
selectPoints - get or set whether points can be selected
interactive - get or set whether the shape is interactive - toggle, move, change or add controls, etc.
** setting widths and heights adjusts scale not bounds and getting these uses the bounds dimension times the scale
width - gets or sets the width. Setting the width will scale the height to keep proportion (see widthOnly below)
height - gets or sets the height. Setting the height will scale the width to keep proportion (see heightOnly below)
widthOnly - gets or sets the width.  This sets only the width and may change the aspect ratio of the object
heightOnly - gets or sets the height.  This sets only the height and may change the aspect ratio of the object
depth - for ZIM VR - the depth used to shift left and right channel and for parallax in VR - also see dep() ZIM Display method
blendMode - how the object blends with what is underneath - such as "difference", "multiply", etc. same as CreateJS compositeOperation
keyFocus - get or set the keyboard focus on the DisplayObject - see also zim.KEYFOCUS
   will be set to true if this DisplayObject is the first made or DisplayObject is the last to be used with keyboard
group - used when the object is made to add STYLE with the group selector (like a CSS class)

ALSO: See the CreateJS Easel Docs for Container properties, such as:
x, y, rotation, scaleX, scaleY, regX, regY, skewX, skewY,
alpha, cursor, shadow, mouseChildren, mouseEnabled, parent, numChildren, etc.

EVENTS
dispatches a "change" event for when the bezier controls are adjusted (pressup only)
	if monitoring constant change is needed add a pressmove event to Blob.sets
	the change event object has a transformType property with values of "move", "bezierPoint", "bezierHandle", "bezierSwitch"
dispatches "controlsshow" and "controlshide" events when clicked off and on and toggle is true
dispatches an "update" event if the points are changed or a point is added or removed
	this removes all listeners on the old shape and controls
	so any custom listeners on shape and controls will need to be re-applied - use the update event to do so
dispatches a "traversed" event when traverse() is done - the event object has an obj property for the traversing object
See the CreateJS Easel Docs for Container events, such as:
added, click, dblclick, mousedown, mouseout, mouseover, pressmove, pressup, removed, rollout, rollover
--*///+53.5
	zim.Blob = function(color, borderColor, borderWidth, points, radius, controlLength, controlType, lockControlType, showControls, lockControls, handleSize, allowToggle, move, dashed, onTop, stickColor, selectColor, selectPoints, editPoints, interactive, strokeObj, style, group, inherit) {
		var sig = "color, borderColor, borderWidth, points, radius, controlLength, controlType, lockControlType, showControls, lockControls, handleSize, allowToggle, move, dashed, onTop, stickColor, selectColor, selectPoints, editPoints, interactive, strokeObj, style, group, inherit";
		var duo; if (duo = zob(zim.Blob, arguments, sig, this)) return duo;
		z_d("53.5");
		this.group = group;
		var DS = style===false?{}:zim.getStyle("Blob", this.group, inherit);

		if (zot(radius)) radius = DS.radius!=null?DS.radius:100;
		this.zimContainer_constructor(-radius,-radius,radius*2,radius*2,false);
		this.type = "Blob";

		if (zot(dashed)) dashed = DS.dashed!=null?DS.dashed:false;
		if (zot(borderColor)) borderColor = DS.borderColor!=null?DS.borderColor:null;
		if (zot(borderWidth)) borderWidth = DS.borderWidth!=null?DS.borderWidth:null;
		if (borderColor < 0 || borderWidth < 0) borderColor = borderWidth = null;
		else if (borderColor!=null && borderWidth==null) borderWidth = 1;
		if (zot(color)) color = DS.color!=null?DS.color:(borderWidth>0?"rgba(0,0,0,0)":zim.green);
		if (color.style) {this.colorCommand = color; color = "black";}
		if (borderColor && borderColor.style) {this.borderColorCommand = borderColor; borderColor = "black";}
		if (zot(points)) points = DS.points!=null?DS.points:4;
		var num = typeof points == "number" ? points : points.length;
		var controlLengthOriginal = controlLength;
		if (zot(controlLength)) controlLength = DS.controlLength!=null?DS.controlLength:(radius * 4 / num);
		if (zot(controlType)) controlType = DS.controlType!=null?DS.controlType:null;
		var originalControlType = controlType;
		if (zot(controlType)) controlType = "straight";
		if (zot(lockControlType)) lockControlType = DS.lockControlType!=null?DS.lockControlType:false;
		if (zot(interactive)) interactive = DS.interactive!=null?DS.interactive:true;
		if (zot(showControls)) showControls = DS.showControls!=null?DS.showControls:interactive;
		var _controls = showControls;
		if (zot(lockControls)) lockControls = DS.lockControls!=null?DS.lockControls:!interactive;
		if (zot(handleSize)) handleSize = DS.handleSize!=null?DS.handleSize:(zim.mobile()?20:10);
		if (zot(allowToggle)) allowToggle = DS.allowToggle!=null?DS.allowToggle:interactive;
		if (zot(move)) move = DS.move!=null?DS.move:interactive;
		if (zot(stickColor)) stickColor = DS.stickColor!=null?DS.stickColor:"#111";
		if (zot(selectColor)) selectColor = DS.selectColor!=null?DS.selectColor:"#fff";
		if (zot(selectPoints)) selectPoints = DS.selectPoints!=null?DS.selectPoints:interactive;
		this.stickColor = stickColor;

		if (zot(onTop)) onTop = DS.onTop!=null?DS.onTop:true;
		if (zot(editPoints)) editPoints = DS.editPoints!=null?DS.editPoints:interactive;
		if (zot(strokeObj)) strokeObj = DS.strokeObj!=null?DS.strokeObj:{};

		var that = this;
		this.interactive = interactive;
		this.num = num;
		this.editPoints = editPoints;
		this.selectPoints = selectPoints;
		this.lockControls = lockControls;
		this.onTop = onTop;
		this.move = move;
		this.allowToggle = allowToggle;
		this.lockControlType = lockControlType;

		var types = this.types = ["mirror", "straight", "free", "none"];

		var _points;
		var _pointCircles;
		var _pointControls;
		var _color = color;
		var _borderColor = borderColor;
		var _borderWidth = borderWidth;
		var colorObj;
		var borderColorObj;
		var borderWidthObj;
		var borderDashedObj;

		var shape;
		var moveDownEvent;
		var movePressEvent;
		var moveUpEvent;
		var stage;

		var draggingCheck = that.move;
		var min = 2; // distance within which to count as click to add point

		var mapMove;
		var drawShape;
		var sets;

		points = checkForShape(points);
		function checkForShape(shape) {
			if (shape=="circle" || shape == "rectangle" || shape =="triangle") {
				if (shape == "circle") shape = new Circle(radius);
				if (shape == "rectangle") shape = new Rectangle(radius*2,radius*2).centerReg({add:false});
				if (shape == "triangle") shape = new Triangle(radius*2,radius*2,radius*2);
			}
			var points;
			if (shape.type == "Circle" || shape.type == "Rectangle" || shape.type == "Triangle") {
				var b = shape.getBounds();
				if (shape.type == "Circle") {
					points = 4;
					controlLengthOriginal = controlLength = radius*2*.5523;
				} else if (shape.type == "Rectangle") {
					shape.centerReg({add:false});
					points = [[b.x-b.width/2, b.y-b.height/2],[b.x+b.width/2, b.y-b.height/2],[b.x+b.width/2, b.y+b.height/2],[b.x-b.width/2, b.y+b.height/2]];
					that.setBounds(b.x-b.width/2, b.y-b.height/2, b.width, b.height);
					that.regX = shape.regX-b.width/2;
					that.regY = shape.regY-b.height/2;
					// this.rotation = shape.rotation;
					// this.scaleX = shape.scaleX;
					// this.scaleY = shape.scaleY;
				} else if (shape.type == "Triangle") {
					points = [[shape.three.x-shape.width/2, shape.three.y+shape.height/2+shape.adjusted],[shape.two.x-shape.width/2, shape.two.y+shape.height/2+shape.adjusted],[shape.one.x-shape.width/2, shape.one.y+shape.height/2+shape.adjusted]];
					that.setBounds(b.x-b.width/2, b.y-b.height/2, b.width, b.height);
				}
				return points;
			} else {
				return shape;
			}
		}
		if (typeof points == "string") {
			var svgProcessor = new zim.SVGContainer();
			points = svgProcessor.processPath(points);
		}

		if (originalControlType && typeof points != "number") {
			// override controlType
			loop(points, function(point) {
				point[8]=originalControlType;
				if (originalControlType == "none") {
					point[4]=point[5]=point[6]=point[7]=0;
				}
			});
		}

		init();
		function init() {
			if (sets) sets.removeAllEventListeners();

			if (that.selectPoints) {
				that.selectedBalls = new zim.SelectionSet();
				that.selectedRect1s = new zim.SelectionSet();
				that.selectedRect2s = new zim.SelectionSet();

				that.selectionManager = new zim.SelectionManager([
					that.selectedBalls,
					that.selectedRect1s,
					that.selectedRect2s
				], "ctrl", false);
			} else {
				that.selectionManager = new zim.SelectionManager(null, "ctrl");
			}

			num = typeof points == "number" ? points : points.length;
			if (num <= 0) return;
			if (zot(controlLengthOriginal)) controlLength = radius * 4 / num;

			shape = that.shape = new zim.Shape({style:false}).addTo(that);
			var sticks = that.sticks = new zim.Shape({style:false}).addTo(that);
			if (handleSize <= 0) sticks.removeFrom();
			var g = shape.graphics;
			g.c();
			var s = sticks.graphics;
			s.c();

			var ballS = handleSize/10*8;
			var rectS = handleSize;

			var mobile = zim.mobile();

			sets = that.controls = new zim.Container({style:false}).addTo(that); // sets - a set contains a ball and two rects
			if (that.interactive) sets.drag({onTop:!mobile});

			_points = [];
			_pointControls = [];
			_pointCircles = [];

			var angle, point, temp, set, rect1, rect2, ball, type, setInfo;

			for (var i=0; i<num; i++) {
				set = new zim.Container({style:false}).addTo(sets);
				set.num = i;
				if (typeof points == "number") { // no sets yet

					// easier to create controls in a temp vertical Container
					// set the registration point at the circle center
					// then rotate the temp container
					// then get the resulting rotated coordinates and use localToLocal
					// to find coordinates of controls in set Container
					// afterwards, adjust controls in set Container so origin and registration is at ball
					// then move the set Container so it matches that adjustment
					// (or could have calculated all positions to start with aTan2, sin, cos etc.)
					var length = zim.Pick.choose(controlLength);
					temp = new zim.Container(length, radius, null, null, false).reg(length/2, radius).addTo(that);
					temp.rotation = i/num * 360;
					ball = new zim.Circle(ballS, that.selectPoints&&that.selectedBalls.isSelected(i)?selectColor:zim.light, zim.dark, 2, null, null, null, false)
						.centerReg(temp)
						.loc({x:length/2,y:0});
					rect1 = new zim.Rectangle(rectS, rectS, that.selectPoints&&that.selectedRect1s.isSelected(i)?selectColor:getBackgroundColor(controlType), handleSize==0?null:zim.dark, handleSize==0?null:2, null, null, null, false)
						.centerReg(temp)
						.loc({x:0,y:0});
					rect2 = new zim.Rectangle(rectS, rectS, that.selectPoints&&that.selectedRect2s.isSelected(i)?selectColor:getBackgroundColor(controlType), handleSize==0?null:zim.dark, handleSize==0?null:2, null, null, null, false)
						.centerReg(temp)
						.loc({x:length,y:0});

					var ballPoint = temp.localToLocal(ball.x, ball.y, sets);
					ball.x = ballPoint.x;
					ball.y = ballPoint.y;
					ball.addTo(set, null, false);
					var rect1Point = temp.localToLocal(rect1.x, rect1.y, sets);
					rect1.x = controlType=="none"?0:rect1Point.x-ball.x;
					rect1.y = controlType=="none"?0:rect1Point.y-ball.y;
					rect1.addTo(set, null, false);
					var rect2Point = temp.localToLocal(rect2.x, rect2.y, sets);
					rect2.x = controlType=="none"?0:rect2Point.x-ball.x;
					rect2.y = controlType=="none"?0:rect2Point.y-ball.y;
					rect2.addTo(set, null, false);
					set.x = ball.x;
					set.y = ball.y;
					ball.x = 0;
					ball.y = 0;
					if (controlType=="none") ball.addTo(set, null, false); // on top

				} else { // passing in set data

					// balls are relative to blob but handles are relative to ball
					// points is an array of [[setX, setY, ballX, ballY, handleX, handleY, handle2X, handle2Y, type], etc.]

					setInfo = points[i];
					type = setInfo[8] ? setInfo[8] : controlType;
					set.loc({x:setInfo[0], y:setInfo[1]});
					ball = new zim.Circle(ballS, zim.light, zim.dark, 2, null, null, null, false)
						.centerReg(set)
						.loc({x:setInfo[2],y:setInfo[3]});
					rect1 = new zim.Rectangle(rectS, rectS, getBackgroundColor(type), handleSize==0?null:zim.dark, handleSize==0?null:2, null, null, null, false)
						.centerReg(set, 0)
						.loc({x:setInfo[4],y:setInfo[5]});
					rect2 = new zim.Rectangle(rectS, rectS, getBackgroundColor(type), handleSize==0?null:zim.dark, handleSize==0?null:2, null, null, null, false)
						.centerReg(set, 0)
						.loc({x:setInfo[6],y:setInfo[7]});
				}

				ball.mySet = set;
				ball.rect1 = rect1;
				ball.rect2 = rect2;
				ball.index = i;

				if (handleSize==0) {
					ball.expand(10);
					rect1.expand(10);
					rect2.expand(10);
				}

				if (mobile) {
					ball.on("mousedown", mobileDouble);
				} else {
					ball.on("dblclick", doubleIt);
				}

				rect1.ball = ball;
				rect1.other = rect2;
				rect2.ball = ball;
				rect2.other = rect1;

				if (mobile) {
					ball.expand();
					rect1.expand();
					rect2.expand();
				}

				point = [set, ball, rect1, rect2, setInfo?setInfo[8]:controlType];
				_points.push(point);
				_pointCircles.push(ball);
				_pointControls.push(set);
			}

			var tappedTwice = false;
			function mobileDouble(e) {
				if (!tappedTwice) {
					tappedTwice = true;
					setTimeout(function() {
						tappedTwice = false;
					}, 300);
				} else {
					e.preventDefault();
					doubleIt(e);
				}
			}

			function doubleIt(e) {
				if (that.lockControlType) return;
				var ball = e.target;
				// cycle through the types
				var type = _points[ball.index][4] ? _points[ball.index][4] : controlType;
				if (Math.abs(ball.rect1.x) <= 2 && Math.abs(ball.rect1.y) <= 2 && Math.abs(ball.rect2.x) <= 2 && Math.abs(ball.rect2.y) <= 2) {
					type = "none"
				}
				if (type == "none") {
					ball.parent.addChildAt(ball, 0);
				}
				// modulus going backwards needs to add the length so it does not go negative
				type = that.types[(that.types.indexOf(type)+(that.shiftKey?-1:1)+that.types.length)%that.types.length];
				if (type == "none") {
					ball.rect1.x =  ball.rect1.y =  ball.rect2.x =  ball.rect2.y = 0;
					ball.parent.addChild(ball);
					e.stopImmediatePropagation();
				}
				_points[ball.index][4] = type;
				ball.rect1.color = getBackgroundColor(type);
				ball.rect2.color = getBackgroundColor(type);
				drawShape();
				var ev = new createjs.Event("change");
				ev.controlType = "bezierSwitch";
				that.dispatchEvent(ev);
				ball.stage.update();
			};

			function getBackgroundColor(type) {
				var colors = {mirror:zim.purple, free:zim.yellow, none:zim.blue};
				return colors[type] ? colors[type] : zim.pink;
			}

			drawShape = function() {
				g.c();
				if (!that.colorCommand) that.colorCommand = colorObj = g.f(_color).command;
				// border of 0 or a string value still draws a border in CreateJS
				if (zot(_borderWidth) || _borderWidth > 0) { // no border specified or a border > 0
					if (!zot(_borderColor) || !zot(_borderWidth)) { // either a border color or thickness
						if (zot(_borderColor)) _borderColor = "black";
						if (!that.borderColorCommand) that.borderColorCommand = borderColorObj = g.s(_borderColor).command;
						if (!that.borderWidthCommand) that.borderWidthCommand = borderWidthObj = g.ss(_borderWidth, strokeObj.caps, strokeObj.joints, strokeObj.miterLimit, strokeObj.ignoreScale).command;
						if (dashed) {
							if (!that.borderDashedCommand) that.borderDashedCommand = borderDashedObj = g.sd([10, 10], 5).command;
						}
					}
				}
				var set = _points[0][0];
				var ballPoint = set.localToLocal(_points[0][1].x, _points[0][1].y, shape);
				g.mt(ballPoint.x, ballPoint.y);

				s.c().s(that.stickColor).ss(1);

				var currentIndex; var nextIndex;
				for (var i=0; i<_points.length; i++) {
					var currentIndex = i;
					var nextIndex = (i+1)%_points.length;

					var set = _points[currentIndex][0];
					var ball = _points[currentIndex][1];
					var control1 = _points[currentIndex][2];
					var control2 = _points[currentIndex][3];

					var nextSet = _points[nextIndex][0];
					var nextBall = _points[nextIndex][1];
					var nextControl1 = _points[nextIndex][2];
					var nextControl2 = _points[nextIndex][3];

					var control2Point = set.localToLocal(control2.x, control2.y, shape);
					var nextControl1Point = nextSet.localToLocal(nextControl1.x, nextControl1.y, shape);
					var nextBallPoint = nextSet.localToLocal(nextBall.x, nextBall.y, shape);

					g.bt(
						control2Point.x, control2Point.y,
						nextControl1Point.x, nextControl1Point.y,
						nextBallPoint.x, nextBallPoint.y
					);


					// create the sticks
					var ballPoint = set.localToLocal(ball.x, ball.y, shape);
					var control1Point = set.localToLocal(control1.x, control1.y, shape);

					s.mt(ballPoint.x, ballPoint.y).lt(control1Point.x, control1Point.y);
					s.mt(ballPoint.x, ballPoint.y).lt(control2Point.x, control2Point.y);
				}
				g.cp();

				g.append(that.colorCommand);
				if (dashed) g.append(that.borderDashedCommand);
				if (that.borderWidthCommand) g.append(that.borderWidthCommand);
				if (that.borderColorCommand) g.append(that.borderColorCommand);
			}
			drawShape();

			var startPosition;
			sets.on("mousedown", function(e) {
				if (that.lockControls) return;
				if (that.selectPoints) that.keyFocus = true;
				startPosition = {x:e.target.x, y:e.target.y};
				if (e.target.rect1) { // then mousedown on ball
					var ball = e.target;
					ball.startX = ball.x;
					ball.startY = ball.y;
					ball.rect1.startX = ball.rect1.x;
					ball.rect1.startY = ball.rect1.y;
					ball.rect2.startX = ball.rect2.x;
					ball.rect2.startY = ball.rect2.y;
				} else { // mousedown on control
					var rect = e.target;
					rect.startX = rect.x;
					rect.startY = rect.y;
					var ball = rect.ball;
					var index = ball.index;
					var type = controlType;
					if (!zot(_points[index][4])) type = _points[index][4];
					if (type == "straight") {
						var other = rect.other;
						var dX = other.x - ball.x;
						var dY = other.y - ball.y;
						other.stickLength = Math.sqrt(Math.pow(dX,2) + Math.pow(dY,2));
					}
				}
				if (that.selectPoints) {
					// need to reset all start points for each control circle and rectangle moved
					var currentSet = that.selectionManager.currentSet;
					if (currentSet && currentSet.selections && currentSet.selections.length > 0) {
						for(var i=0; i<currentSet.selections.length; i++) {
							var point = that.pointObjects[currentSet.selections[i]];
							point[1].startX = point[1].x;
							point[1].startY = point[1].y;
							point[2].startX = point[2].x;
							point[2].startY = point[2].y;
							point[3].startX = point[3].x;
							point[3].startY = point[3].y;
						}
					}
				}
			});

			if (that.selectPoints) {
				sets.tap(function (e) {
					if (e.target.rect1) { // then mousedown on ball - which has a rect1
						var ball = e.target;
						that.selectedBalls.toggle(ball.parent.num);
					} else { // mousedown on control
						var rect = e.target;
						rect.color = "white";
						var ball = rect.ball;
						if (ball.rect1 == rect) that.selectedRect1s.toggle(ball.parent.num);
						else that.selectedRect2s.toggle(ball.parent.num);
					}
					// loop through all controls and set to right color based on selection
					for (var i=0; i<that.pointObjects.length; i++) {
						var po = that.pointObjects[i];
						po[1].color = that.selectedBalls.isSelected(i)?zim.white:zim.light;
						po[2].color = that.selectedRect1s.isSelected(i)?zim.white:getBackgroundColor(po[4]);
						po[3].color = that.selectedRect2s.isSelected(i)?zim.white:getBackgroundColor(po[4]);
					}
					e.target.stage.update();
				});
			}

			sets.on("pressmove", function(e) {
				if (that.lockControls) return;
				if (that.selectPoints) {
					var currentSelected = getCurrentSelected();
					if (currentSelected.indexOf(e.target) == -1) {
						mapMove(e.target);
						drawShape();
					} else {
						if (currentSelected.length > 0) {
							diffX = e.target.x-e.target.startX;
							diffY = e.target.y-e.target.startY;
							for(var i=0; i<currentSelected.length; i++) {
								var pointObj = currentSelected[i];
								pointObj.x = pointObj.startX + diffX;
								pointObj.y = pointObj.startY + diffY;
								mapMove(pointObj);
							}
							drawShape();
						}
					}
				} else {
					mapMove(e.target);
					drawShape();
				}
			});


			sets.on("pressup", function(e) {
				if (that.lockControls) return;
				var moveControlCheck = (e.target.x != startPosition.x || e.target.y != startPosition.y);
				var ev = new createjs.Event("change");
				if (e.target.rect1) { // pressup on ball
					ev.controlType = "bezierPoint";
					endMove(e.target);
				} else {
					ev.controlType = "bezierHandle";
				}
				if (moveControlCheck) that.dispatchEvent(ev);
			});

			function endMove(target) {
				if (that.selectPoints) {
					var currentSelected = getCurrentSelected();
					if (currentSelected && currentSelected.indexOf(target) == -1) {
						replaceControls(target);
					} else if (currentSelected && currentSelected.length>0) {
						for(var i=0; i<currentSelected.length; i++) {
							replaceControls(currentSelected[i]);
						}
					} else {
						replaceControls(target);
					}
				} else {
					replaceControls(target);
				}
			};

			that.changeControl = function(index, type, rect1X, rect1Y, rect2X, rect2Y, circleX, circleY, update) {
				var sig = "index, type, rect1X, rect1Y, rect2X, rect2Y, circleX, circleY, update";
				var duo; if (duo = zob(that.changeControl, arguments, sig)) return duo;
				if (zot(index)) {
					for (var i=0; i<_points.length; i++) {
						that.changeControl(i, type, rect1X, rect1Y, rect2X, rect2Y, circleX, circleY);
					}
					return that;
				}
				var point = _points[index];
				point[4] = type;
				if (type == "none") {
					if (!zot(circleX)) point[1].x = circleX;
					if (!zot(circleY)) point[1].y = circleY;
					point[2].x = point[1].x,
					point[2].y = point[1].y;
					point[3].x = point[1].x,
					point[3].y = point[1].y;
					point[1].parent.addChild(point[1]);
				} else {
					if (!zot(circleX)) point[1].x = circleX;
					if (!zot(circleY)) point[1].y = circleY;
					if (!zot(rect1X)) point[2].x = rect1X;
					if (!zot(rect1Y)) point[2].y = rect1Y;
					if (!zot(rect2X)) point[3].x = rect2X;
					if (!zot(rect2Y)) point[3].y = rect2Y;
					point[1].parent.addChildAt(point[1], 0);
				}
				point[2].color = getBackgroundColor(type);
				point[3].color = getBackgroundColor(type);
				if (update) {
					that.update();
					if (that.stage) that.stage.update();
				}
				return that;
			}

			that.transformPoints = function(transformType, amount, x, y) {
				that.points = zim.transformPoints(that.points, transformType, amount, x, y);
				return that;
			}

			that.traverse = function(obj, start, end, time) {
				var ratios = zim.copy(that.segmentRatios);
				ratios.unshift(0);
				if (zot(end)) end = start+1;
				var forward = start < end;
				if (forward) {
					var startPercent = ratios[start]*100;
					var endPercent = ratios[end]*100;
				} else {
					var startPercent = 50 + (100 - ratios[start]*100)/2;
					var endPercent = 50 + (100 - ratios[end]*100)/2;
				}
				obj.percentComplete = startPercent;
				obj.animate({
					ease:"linear",
					props:{path:that},
					rewind:!forward,
					time:time,
					events:true
				});
				obj.on("animation", function (e) {
					// when it hits the end it may start over
					if (obj.percentComplete > endPercent || obj.percentComplete == 0) {
						obj.stopAnimate();
						e.remove();
						var eventObj = new createjs.Event("traversed");
						eventObj.obj = obj;
						that.dispatchEvent(eventObj);
					}
				});
				return that;
			}

			that.update = function(normalize) {
				if (normalize) {
					// located any rotated or scaled points
					// and set them back to non-rotated and non-scaled
					// but keep control handles at the earlier positions
					// need to normalize before doing more manual updates with Beziers
					// do not need to normalize if animating blob points
					that.points = that.pointsAdjusted;
				} else {
					drawShape();
				}
				return that;
			}

			if (that.move && that.interactive) shape.drag({onTop:false});
			moveDownEvent = shape.on("mousedown", function() {
				startPosition = {x:shape.x, y:shape.y};
				if (that.selectPoints) that.keyFocus = true;
				upTop();
			});
			movePressEvent = shape.on("pressmove", function() {
				sets.x = shape.x;
				sets.y = shape.y;
				sticks.x = shape.x;
				sticks.y = shape.y;
			});
			moveUpEvent = shape.on("pressup", function() {
				var moveControlCheck = (shape.x != startPosition.x || shape.y != startPosition.y);
				var movePoint = shape.localToLocal(0,0,that.parent);
				that.x = movePoint.x;
				that.y = movePoint.y;
				sets.x = sets.y = sticks.x = sticks.y = shape.x = shape.y = 0;
				if (moveControlCheck) {
					var ev = new createjs.Event("change");
					ev.controlType = "move";
					that.dispatchEvent(ev);
				}
				that.stage.update();
			});

			if (!move) stopDragging(true);

			function upTop() {
				if (that.onTop) {
					var nc = that.parent.numChildren-1;
					if (that.parent.getChildAt(nc).type == "Keyboard") nc--;
					that.parent.setChildIndex(that, nc);
				}
			}

			that.toggleEvent = that.on("mousedown", function() {
				if (!that.allowToggle) return;
				if (!_controls) {
					that.showControls();
					that.dispatchEvent("controlsshow");
				}
			});

			that.added(function() {
				that.toggleStageEvent = that.stage.on("stagemousedown", function(e) {
					if (!that.allowToggle || !that.stage) return;
					if (_controls && !that.hitTestPoint(e.stageX/e.target.stage.scaleX, e.stageY/e.target.stage.scaleY, false)) {
						that.hideControls();
						that.dispatchEvent("controlshide");
					}
				});
			});

			that.clickEvent = that.on("click", function() {
				if (that.ctrlKey) {
					setTimeout(function() { // give time for record to work if drag with ctrl down
						that.clone(true).addTo(that.stage).mov(100);
						if (that.allowToggle) {
							that.hideControls();
							that.dispatchEvent("controlshide");
						}
						var ev = new createjs.Event("change");
						ev.controlType = "move";
						that.dispatchEvent(ev);
						that.stage.update();
					}, 50);
				}
			});

			that.hideControls = function() {
				that.toggled = false;
				sets.visible = false;
				sticks.visible = false;
				_controls = false;
				if (that.stage) that.stage.update();
				if (!that.allowToggle && that.move) stopDragging();
				return that;
			}
			if (!_controls) that.hideControls();
			that.showControls = function() {
				// if call this with code then will not trigger a change event - not good for TransformManager.persist()
				that.toggled = true;
				sets.visible = true;
				sticks.visible = true;
				_controls = true;
				sets.x = shape.x;
				sets.y = shape.y;
				sticks.x = shape.x;
				sticks.y = shape.y;
				that.addChildAt(shape,0); // put to bottom incase dragged
				if (that.move && !that.allowToggle) startDragging();
				if (that.stage) that.stage.update();
				return that;
			}

			that.toggle = function(state) {
				if (state===true) that.showControls();
				else if (state===false) that.hideControls();
				else if (_controls) that.hideControls();
				else that.showControls();
				return that;
			}

			that.recordData = function(toJSON) {
				if (zot(toJSON)) toJSON = false;
				var obj = {
					type:"Blob",
					index:that.parent?that.parent.getChildIndex(that):-1,
					x:that.x, y:that.y,
					points:that.recordPoints(),
					color:that.color,
					borderColor:that.borderColor,
					borderWidth:that.borderWidth,
					move:that.move,
					toggle:that.allowToggle,
					controlsVisible:_controls
				}
				if (toJSON) return JSON.stringify(obj);
				return obj;
			}

			that.setData = function(data, fromJSON) {
				if (zot(data)) return;
				if (fromJSON) {
					try{
					  data = JSON.parse(data);
					} catch(e) {
					  return;
				  	}
				}
				var index = data.index;
				if (zot(index)) index = -1;
				delete data.index;

				var pointData = data.points;
				if (!zot(pointData)) that.setPoints(pointData);
				delete data.points;
				this.num = pointData.length;

				for (var d in data) {
					that[d] = data[d];
				}
				if (that.parent) {
					that.parent.setChildIndex(that, index);
				}
				return that;
			}

			that.recordPoints = function(popup) {
				// _pointCircles are relative to blob but handles are relative to ball
				// points is an array of [[ballX, ballY, handleX, handleY, handle2X, handle2Y, type], etc.]
				if (zot(popup)) popup = false;
				var points = that.points;
				if (popup) {
					if (!pane) {
						var pane = that.pane = new zim.Pane({
							displayClose:false,
							container:that.stage,
							width:Math.min(500, that.stage.width-20),
							height:Math.min(500, that.stage.height-20),
							draggable:true,
						});
						var textArea = that.textArea = new zim.TextArea(Math.min(400, that.stage.width-70), Math.min(400, that.stage.height-70));
						textArea.centerReg(pane);
					}
					textArea.text = JSON.stringify(points);
					pane.show();
				}
				return points;
			}

			that.setPoints = function(points) {
				// adjust blob to match points passed in from recordPoints
				var p;
				var p2;
				for (var i=0; i<points.length; i++) {
					p = _points[i];
					p2 = points[i];
					if (zot(p)) continue;
					p[0].x = p2[0];
					p[0].y = p2[1];
					p[1].x = p2[2];
					p[1].y = p2[3];
					p[2].x = p2[4];
					p[2].y = p2[5];
					p[3].x = p2[6];
					p[3].y = p2[7];
					p[4] = p2[8];
					p[2].color = getBackgroundColor(p[4]);
					p[3].color = getBackgroundColor(p[4]);
				}
				that.update();
				return that;
			}
			if (style!==false) zimStyleTransforms(that, DS);
			that.clone = function(commands) {
				var color = commands?that.colorCommand:that.color;
				var color = commands?that.colorCommand:that.color;
				var newShape =  that.cloneProps(new zim.Blob(commands?that.colorCommand:that.color, commands?that.borderColorCommand:that.borderColor, that.borderWidth, that.recordPoints(), radius, controlLength, controlType, lockControlType, sets.visible, lockControls, handleSize, that.allowToggle, that.move, dashed, onTop, stickColor, selectColor, selectPoints, that.editPoints, interactive, strokeObj, style, that.group, inherit));
				if (that.linearGradientParams) newShape.linearGradient.apply(newShape, that.linearGradientParams);
				if (that.radialGradientParams) newShape.radialGradient.apply(newShape, that.linearGradientParams);
				return newShape;
			}

			// to add a control - make sure click in one spot - not drag
			that.shapeMousedownEvent = that.shape.on("mousedown", function (e) {
				stage = e.target.stage;
				if (!that.editPoints) return;
				if (that.controlsVisible) {
					that.pressX = e.stageX/stage.scaleX;
					that.pressY = e.stageY/stage.scaleY;
				} else {
					that.pressX = null;
					that.pressY = null;
				}
			});
			that.addPointFactor = 20;
			that.addMinDistance = 15;
			that.shapePressupEvent = that.shape.on("pressup", function (e) {

				if (!that.editPoints) return;
				if (that.pressX && Math.abs(that.pressX-e.stageX/stage.scaleX) < min && Math.abs(that.pressY-e.stageY/stage.scaleY) < min) {
					if (that.selectPoints) that.lastPoints = zim.copy(that.points);
					var points = that.points;
					var point = that.globalToLocal(e.stageX/stage.scaleX, e.stageY/stage.scaleY);
					var pointBefore = zim.closestPointAlongCurve(point, that.segmentPoints);
					if (that.editPoints == "anywhere") {
						points.splice(pointBefore+1, 0, [point.x, point.y, 0,0, 0,0, 0,0]);
						that.points = points;
						that.changeControl({index:pointBefore+1, type:"mirror", update:true});
					} else { // only on edge
						// test close enough to edge otherwise return
						var p = that.pointsAdjusted;
						var cubic = that.getSegmentPoint(p[pointBefore], p[(pointBefore+1)%p.length]);
						var length = zim.distanceAlongCurve(cubic);
						var testNum = Math.round(length/that.addPointFactor);
						var testPoints = that.interpolate(testNum, pointBefore, false, points);
						var closest=10000;
						var closestPoint;
						var closestIndex;

						zim.loop(testPoints, function (p, k) {
							if (k==0) return; // don't put on existing point
							var d = zim.dist(p, point);
							if (d < closest) {
								closest = d;
								closestIndex = k;
								closestPoint = p;
							}
						});
						if (closest < that.addMinDistance) {
							var ratios = that.segmentRatios;
							var currentRatio = ratios[pointBefore];
							var lastRatio = pointBefore>0?ratios[pointBefore-1]:0;
							that.addPoint(100*(lastRatio+(currentRatio-lastRatio)*(closestIndex/testNum)));
						}
					}
					that.lastSelectedIndex = pointBefore+1;
					that.lastSelected = that.controls.getChildAt(that.lastSelectedIndex);
					that.stage.update();
				}
			});

			// remove point
			that.controlsClickEvent = that.controls.on("click", function (e) {
				that.lastSelected = e.target.parent;
				var index = that.lastSelectedIndex = that.controls.getChildIndex(e.target.parent);
				if (!that.editPoints) return;
				if (that.selectionManager.shiftKey) { // remove
					if (e.target.type == "Circle") {
						if (that.controls.numChildren <= 2) return;
						var points = that.points;
						if (that.selectPoints) that.lastPoints = zim.copy(points);
						points.splice(index, 1); // remove the point at the index
						that.points = points;
						that.stage.update();
					}
				}
			});
			if (!_controls) that.hideControls();
			that.dispatchEvent("update");
		} // end of init()

		function getCurrentSelected() {
			var answer = [];
			var currentSet = that.selectionManager.currentSet;
			if (currentSet && currentSet.selections && currentSet.selections.length > 0) {
				for(var i=0; i<currentSet.selections.length; i++) {
					var point = that.pointObjects[currentSet.selections[i]];
					if (currentSet == that.selectedBalls) {
						answer.push(point[1]);
					} else if (currentSet == that.selectedRect1s) {
						answer.push(point[2]);
					}	else if (currentSet == that.selectedRect2s) {
						answer.push(point[3]);
					} else {
						continue;
					}
				}
			}
			return answer;
		}

		function replaceControls(target) {
			if (!that.selectPoints) return;
			// move ball back to origin and move set accordingly
			// so if we animate the set it will behave as expected
			if (target.type != "Circle") return;
			var ball = target;
			var set = ball.mySet;
			var rect1 = ball.rect1;
			var rect2 = ball.rect2;
			rect1.x -= ball.x;
			rect1.y -= ball.y;
			rect2.x -= ball.x;
			rect2.y -= ball.y;
			set.x += ball.x;
			set.y += ball.y;
			ball.x = 0;
			ball.y = 0;
		}

		that.selectionManager.on("keydown", function (e) {
			if (!that.selectPoints) return;
			if (!that.keyFocus) return;
			if (e.keyCode >= 37 && e.keyCode <= 40) {
				var currentSelected = getCurrentSelected();
				if (currentSelected.length > 0) {
					for(var i=0; i<currentSelected.length; i++) {
						var pointObj = currentSelected[i];
						if (e.keyCode == 37) pointObj.x -= that.selectionManager.shiftKey?10:1;
						else if (e.keyCode == 39) pointObj.x += that.selectionManager.shiftKey?10:1;
						else if (e.keyCode == 38) pointObj.y -= that.selectionManager.shiftKey?10:1;
						else if (e.keyCode == 40) pointObj.y += that.selectionManager.shiftKey?10:1;
						mapMove(pointObj);
					}
					drawShape();
					if (that.stage) that.stage.update();
				}
			}
		});

		that.selectionManager.on("keyup", function (e) {
			if (!that.selectPoints) return;
			if (!that.keyFocus) return;
			if (e.keyCode >= 37 && e.keyCode <= 40) {
				var currentSelected = getCurrentSelected();
				if (currentSelected.length > 0) {
					for(var i=0; i<currentSelected.length; i++) {
						replaceControls(currentSelected[i]);
					}
				}
			}
		});

		that.selectionManager.on("undo", function () {
			if (!that.selectPoints) return;
			if (!that.keyFocus) return;
			if (that.lastPoints) {
				var tempPoints = zim.copy(that.lastPoints);
				that.lastPoints = zim.copy(that.points);
				that.points = tempPoints;
				if (that.stage) that.stage.update()
			}
		});


		mapMove = function (target) {
			if (that.lockControls) return;
			if (target.rect1) { // pressmove on ball
				var ball = target;
				var diffX = ball.x - ball.startX;
				var diffY = ball.y - ball.startY;
				ball.rect1.x = ball.rect1.startX + diffX;
				ball.rect1.y = ball.rect1.startY + diffY;
				ball.rect2.x = ball.rect2.startX + diffX;
				ball.rect2.y = ball.rect2.startY + diffY;
			} else { // pressmove on control
				var rect = target;
				var other = rect.other; // the other handle
				var ball = rect.ball;
				var index = ball.index;
				var type = controlType;
				if (!zot(_points[index][4])) type = _points[index][4];
				if (type == "straight" || type == "mirror") {
					var dX = rect.x - ball.x;
					var dY = rect.y - ball.y;
					if (type == "mirror") {
						other.x = ball.x - dX;
						other.y = ball.y - dY;
					} else {
						var a = Math.atan2(dY, dX);
						var dNewX = -other.stickLength * Math.cos(a+Math.PI);
						var dNewY = -other.stickLength * Math.sin(a+Math.PI);
						other.x = ball.x - dNewX;
						other.y = ball.y - dNewY;
					}
				}
			}
		};

		Object.defineProperty(that, 'move', {
			get: function() {
				return move;
			},
			set: function(value) {
				if (move != value) {
					move = value;
					if (value) {
						startDragging();
					} else {
						stopDragging();
					}
				}
			}
		});

		Object.defineProperty(that, 'interactive', {
			get: function() {
				return interactive;
			},
			set: function(value) {
				interactive = value;
				that.showControls = interactive;
				that.allowToggle = interactive;
				that.editPoints = interactive;
				that.lockControls = !interactive; // note negative
				that.selectPoints = interactive;
				that.move = interactive;
				that.points = that.points; // force remake
			}
		});

		Object.defineProperty(that, 'allowToggle', {
			get: function() {
				return allowToggle;
			},
			set: function(value) {
				if (allowToggle != value) {
					allowToggle = value;
					if (allowToggle) {
						if (that.move) startDragging();
					} else {
						if (!_controls && that.move) stopDragging();
					}
				}
			}
		});

		function startDragging() {
			if (that.move=="always") return;
			if (draggingCheck) return;
			draggingCheck = true;
			shape.drag({onTop:false});
			moveDownEvent = shape.on("mousedown", moveDownEvent);
			movePressEvent = shape.on("pressmove", movePressEvent);
			moveUpEvent = shape.on("pressup", moveUpEvent);
		}
		function stopDragging(making) {
			if (that.move=="always") return;
			if (!making && !draggingCheck) return;
			draggingCheck = false;
			shape.noDrag();
			shape.off("mousedown", moveDownEvent);
			shape.off("pressmove", movePressEvent);
			shape.off("pressup", moveUpEvent);
		}

		Object.defineProperty(that, 'controlsVisible', {
			get: function() {
				return _controls;
			},
			set: function(value) {
				_controls = value;
				if (value) {
					that.showControls();
				} else {
					that.hideControls();
				}
			}
		});

		var _lockControls = lockControls;
		Object.defineProperty(that, 'lockControls', {
			get: function() {
				return _lockControls;
			},
			set: function(value) {
				_lockControls = value;
				if (value) {
					that.controls.mouseChildren = false;
					that.controls.mouseEnabled = false;
				} else {
					that.controls.mouseChildren = true;
					that.controls.mouseEnabled = true;
				}
			}
		});
		that.lockControls = _lockControls;

		Object.defineProperty(that, 'color', {
			get: function() {
				return _color;
			},
			set: function(value) {
				if (zot(value)) value = "black";
				_color = value;
				colorObj.style = _color;
			}
		});
		var startColor;
		var endColor;
		this.setColorRange = function(color1, color2) {
			if (zot(color2)) {
				startColor = that.color;
				endColor = color1;
			} else if (zot(color1)) {
				startColor = that.color;
				endColor = color2;
			} else {
				startColor = color1;
				endColor = color2;
			}
			return that;
		}
		var _colorRange = 0;
		Object.defineProperty(that, 'colorRange', {
			get: function() {
				return _colorRange;
			},
			set: function(value) {
				_colorRange = value;
				if (!zot(startColor) && !zot(endColor)) {
					that.color = zim.colorRange(startColor, endColor, value);
				}
			}
		});

		Object.defineProperty(that, 'borderColor', {
			get: function() {
				return _borderColor;
			},
			set: function(value) {
				if (zot(value)) return;
				_borderColor = value;
				if (!borderColorObj) drawShape();
				else borderColorObj.style = _borderColor;
			}
		});
		Object.defineProperty(that, 'borderWidth', {
			get: function() {
				return _borderWidth;
			},
			set: function(value) {
				if (zot(value)) return;
				if (!(value>0)) value = 0;
				_borderWidth = value;
				if (!borderWidthObj || _borderWidth == 0) drawShape();
				else {
					borderWidthObj.width = _borderWidth;
					if (dashed) {
						borderDashedObj.segments = [20, 10];
						borderDashedObj.offset = 5;
					}
				}
			}
		});

		if (typeof KEYFOCUS !== typeof undefined) zim.KEYFOCUS = KEYFOCUS;
		Object.defineProperty(this, 'keyFocus', {
			get: function() {
				return zim.KEYFOCUS == that;
			},
			set: function(value) {
				zim.KEYFOCUS = that;
			}
		});
		if (that.selectPoints && !zim.KEYFOCUS) setFocus();
		function setFocus() {that.keyFocus = true; var d=document.activeElement; if (d) d.blur();}


		Object.defineProperty(that, 'points', {
			get: function() {
				var points = [];
				var point; var p;
				for (var i=0; i<_points.length; i++) {
					p = _points[i];
					point = [
						zim.decimals(p[0].x),
						zim.decimals(p[0].y),
						zim.decimals(p[1].x),
						zim.decimals(p[1].y),
						zim.decimals(p[2].x),
						zim.decimals(p[2].y),
						zim.decimals(p[3].x),
						zim.decimals(p[3].y)
					];
					if (p[4] && p[4]!=="straight") point.push(p[4])
					points.push(point);
				}
				return points;
			},
			set: function(value) {
				that.dispose(true);
				points = checkForShape(value);

				if (that.shape) {
					that.shape.graphics.clear();
					that.sticks.graphics.clear();
					that.controls.noDrag();
					that.removeAllChildren();
					delete that.shape;
					delete that.sticks;
					delete that.controls;
				}
				init(); // remake Blob
				that.lockControls = _lockControls;
 			}
		});

		Object.defineProperty(that, 'pointsAdjusted', { // points with rotation
			get: function() {
				var points = [];
				var point; var p; var poo;
				var pObjects = that.pointObjects;
				zim.loop(pObjects.length, function(i, t) {
					po = pObjects[i];
					p = _points[i];
					if (po[0].rotation==0 && po[0].scaleX==0 && po[0].scaleY==0) { // get points
						point = [
							zim.decimals(p[0].x),
							zim.decimals(p[0].y),
							zim.decimals(p[1].x),
							zim.decimals(p[1].y),
							zim.decimals(p[2].x),
							zim.decimals(p[2].y),
							zim.decimals(p[3].x),
							zim.decimals(p[3].y)
						];
					} else {
						var lo1 = po[0].localToLocal(po[2].x, po[2].y, po[0].parent);
						var lo2 = po[0].localToLocal(po[3].x, po[3].y, po[0].parent);
						point = [
							zim.decimals(p[0].x),
							zim.decimals(p[0].y),
							zim.decimals(p[1].x),
							zim.decimals(p[1].y),
							zim.decimals(lo1.x-p[0].x),
							zim.decimals(lo1.y-p[0].y),
							zim.decimals(lo2.x-p[0].x),
							zim.decimals(lo2.y-p[0].y)
						];
					}
					if (p[4] && p[4]!=="mirror") point.push(p[4])
					points.push(point);
				});
				return points;
			},
			set: function(value) {
				if (zon) zog("Blob() - pointsAdjusted is read only")
			}
		});

		Object.defineProperty(that, 'pointObjects', {
			get: function() {
				return _points;
			},
			set: function(value) {
				if (zon) {zog("Blob() - pointObjects is read only - but its contents can be manipulated - use blob.update() after changes")}
			}
		});

		Object.defineProperty(that, 'pointControls', {
			get: function() {
				return _pointControls;
			},
			set: function(value) {
				if (zon) {zog("Blob() - pointControls is read only - but its contents can be manipulated - use blob.update() after changes")}
			}
		});

		Object.defineProperty(that, 'pointCircles', {
			get: function() {
				return _pointCircles;
			},
			set: function(value) {
				if (zon) {zog("Blob() - pointCircles is read only - but its contents can be manipulated - use blob.update() after changes")}
			}
		});

		// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		// path manipulation and animating to path methods

		Object.defineProperty(that, 'segmentPoints', {
			get: function() {
				var p = that.pointsAdjusted;
				var array = []; // array of prepared segment points
				zim.loop(p.length, function(i, t) {
					var s = that.getSegmentPoint(p[i], p[i<t-1?i+1:0])
					array.push(s);
				});
				return array;
			},
			set: function(value) {
				if (zon) {zog("Blob() - segmentPoints is read only")}
			}
		});

		Object.defineProperty(that, 'segmentRatios', {
			get: function() {
				var distances = []
				var total = 0;
				zim.loop(that.segmentPoints, function(points) {
					var d = zim.distanceAlongCurve(points)
					distances.push(d);
					total += d;
				});
				var percents = [];
				var totalPercents = 0;
				zim.loop(distances, function (d) {
					var p = d/total;
					totalPercents += p;
					percents.push(totalPercents);
				});
				return percents;
			},
			set: function(value) {
				if (zon) {zog("Blob() - segmentRatios is read only")}
			}
		});

		that.getPointAngle = function(index) {
			var p = that.pointObjects[index][0]; // parent
			var r1 = that.pointObjects[index][2];
			var r2 = that.pointObjects[index][3];
			if (p==that.stage) {
				var globalR1 = new zim.Point(r1.x, r1.y);
				var globalR2 = new zim.Point(r2.x, r2.y);
			} else {
				var globalR1 = p.localToGlobal(r1.x, r1.y);
				var globalR2 = p.localToGlobal(r2.x, r2.y);
			}
			return zim.angle(globalR1.x, globalR1.y,globalR2.x, globalR2.y);
		}

		that.getSegmentPoint = function(point1, point2) {
			if (zot(point1) || zot(point2)) return;
			// dragging points temporarily puts data out of order
			if (point1[2] != 0 || point1[3] != 0) {
				point1[4] -= point1[2];
				point1[5] -= point1[3];
				point1[6] -= point1[2];
				point1[7] -= point1[3];
				point1[0] += point1[2];
				point1[1] += point1[3];
				point1[2] = 0;
				point1[3] = 0;
			}
			if (point2[2] != 0 || point2[3] != 0) {
				point2[4] -= point2[2];
				point2[5] -= point2[3];
				point2[6] -= point2[2];
				point2[7] -= point2[3];
				point2[0] += point2[2];
				point2[1] += point2[3];
				point2[2] = 0;
				point2[3] = 0;
			}
			var p1 = {x:point1[0], y:point1[1]};
			var p2 = {x:point1[0]+point1[6], y:point1[1]+point1[7]};
			var p3 = {x:point2[0]+point2[4], y:point2[1]+point2[5]};
			var p4 = {x:point2[0], y:point2[1]};
			if (sets.x != 0 || sets.y !=0) {
				p1.x+=sets.x;
				p2.x+=sets.x;
				p3.x+=sets.x;
				p4.x+=sets.x;
				p1.y+=sets.y;
				p2.y+=sets.y;
				p3.y+=sets.y;
				p4.y+=sets.y;
			}
			return [p1,p2,p3,p4];
		}

		that.getAdjacentSegmentData = function(index) {
			if (zot(index)) index = 0;
			var p = that.pointsAdjusted;
			if (that.num == 2) {
				return [
					[that.getSegmentPoint(p[0], p[1]),
					that.getSegmentPoint(p[1], p[0])],
					[0,1]
				];
			}
			if (index == 0) {
				return [
					[that.getSegmentPoint(p[that.num-1], p[0]),
					that.getSegmentPoint(p[0], p[1]),
					that.getSegmentPoint(p[1], p[2])],
					[that.num-1,0,1]
				];
			} else if (index >= that.num-1) {
				return [
					[that.getSegmentPoint(p[that.num-2], p[that.num-1]),
					that.getSegmentPoint(p[that.num-1], p[0]),
					that.getSegmentPoint(p[0], p[1])],
					[that.num-2,that.num-1,0]
				];
			} else {
				var lastIndex = (index+2>=that.num)?0:index+2
				return [
					[that.getSegmentPoint(p[index-1], p[index]),
					that.getSegmentPoint(p[index], p[index+1]),
					that.getSegmentPoint(p[index+1], p[lastIndex])],
					[index-1,index,index+1]
				];
			}
		}

		that.getCurvePoint = function(ratio, segmentRatios, segmentPoints, getAngle) {
			if (zot(segmentRatios)) segmentRatios = that.segmentRatios;
			if (zot(segmentPoints)) segmentPoints = that.segmentPoints;
			if (zot(getAngle)) getAngle = false;
			var percents = segmentRatios;
			var segments = segmentPoints;
			var afterIndex = zim.loop(percents, function (p, i) {
				if (p >= ratio) return i;
			});
			var earlierPercent = afterIndex > 0 ? percents[afterIndex-1] : 0;
			var localTotal = afterIndex > 0 ? (percents[afterIndex]-percents[afterIndex-1]):percents[afterIndex];
			var localPercent = (ratio-earlierPercent)/localTotal;
			var finalPoint = zim.pointAlongCurve(segments[afterIndex], localPercent, getAngle);
			if (zot(finalPoint)) return undefined;
			var finalFinalPoint = that.localToGlobal(finalPoint.x, finalPoint.y);
			finalFinalPoint.angle = finalPoint.angle;
			finalFinalPoint.z = afterIndex;
			return !zot(finalFinalPoint) ? finalFinalPoint : undefined;
		}

		function proportion(p1, p2, ratio) {
			return {
				x:p1.x + (p2.x-p1.x)*ratio,
				y:p1.y + (p2.y-p1.y)*ratio
			}
		}
		function insertPointData(points, controls, ratios, percent, controlType, skipPoint, dataOnly) {
			var index = points.length-1; // adjust for squiggle
			var lastRatio = 0;
			var currentRatio = 0;
			if (percent == 100 && that.type == "Squiggle") percent = 99.99;
			percent = (percent+100000)%100;

			zim.loop(ratios, function (ratio, i) {
				if (percent/100 < ratio) {
					index = i;
					currentRatio = ratio;
					return true;
				}
				lastRatio = ratio;
			});
			var segment = that.segmentPoints[index];
			var r = currentRatio > 0?(percent/100-lastRatio)/(currentRatio-lastRatio):0
			// zog(percent)
			// zog(percent/100-currentRatio/ratios.length)
			// var r = currentRatio > 0?(percent/100-1/ratios.length*currentRatio)/(currentRatio-lastRatio):0

			var point = zim.pointAlongCurve(segment, r)
			var newPoint = [point.x,point.y, 0, 0];
			if (skipPoint) return;
			if (dataOnly) {
				that.interpolatedPoints.push({x:point.x, y:point.y, r:percent/100});
				return;
			}
			if (controlType != "none") {
				// calculate new handles and adjust old handles
				// [controlX, controlY, circleX, circleY, rect1X, rect1Y, rect2X, rect2Y, controlType]
				var startHandle = proportion(segment[0], segment[1], r);
				var midPoint = proportion(segment[1], segment[2], r);
				var endHandle = proportion(segment[2], segment[3], r);
				var newStartHandle = proportion(startHandle, midPoint, r);
				var newEndHandle = proportion(midPoint, endHandle, r);
				newPoint[4] = newStartHandle.x-point.x
				newPoint[5] = newStartHandle.y-point.y;
				newPoint[6] = newEndHandle.x-point.x;
				newPoint[7] = newEndHandle.y-point.y;
				var start = that.localToLocal(startHandle.x, startHandle.y, controls[index])
				points[index][6] = start.x;
				points[index][7] = start.y;
				var end = that.localToLocal(endHandle.x, endHandle.y, controls[(index+1)%points.length])
				points[(index+1)%points.length][4] = end.x;
				points[(index+1)%points.length][5] = end.y;
			}
			if (controlType) newPoint[8] = controlType;
			points.splice(index+1, 0, newPoint);
		}

		this.addPoint = function(percent, controlType) {
			if (zot(percent)) percent = 100;
			var points = that.points;
			var ratios = that.segmentRatios;
			var controls = that.pointControls;
			insertPointData(points, controls, ratios, percent, controlType);
			that.points = points;
			that.num = points.length;
			return that;
		}

		this.addPoints = function(num, controlType, startPoint, spread, dataOnly, points) {
			if (zot(points)) points = zim.copy(that.points);
			var ratios = zim.copy(that.segmentRatios);
			var lastRatio = 0;

			if (dataOnly) that.interpolatedPoints = [];

			// dataOnly should add points to current point too
			// but can't just use current point because sometimes that is static
			// like when dragging the shape or a point - it does not register until mouseup
			// and things like hitTestPath need that to be dynamic
			// So the below does not work:
			// if (dataOnly) {
			// 	that.interpolatedPoints = [];
			// 	zim.loop(points, function (point, i) {
			// 		if (!zot(startPoint) && i!=startPoint) return;
			// 		that.interpolatedPoints.push({x:point[0], y:point[1]})
			// 	});
			// }
			if (spread) var totalPoints = ratios.length*num;
			zim.loop(ratios, function (ratio, j) {
				if (dataOnly) insertPointData(points, that.pointControls, that.segmentRatios, lastRatio*100, controlType, !zot(startPoint) && j!=startPoint, dataOnly);
				var numCount = spread?Math.round(totalPoints*(ratio-lastRatio)):num
				var div = 1/(numCount+1);
				zim.loop(numCount, function(i) {
					var r = lastRatio + (ratio-lastRatio)*div*(i+1);
					insertPointData(points, that.pointControls, that.segmentRatios, r*100, controlType, !zot(startPoint) && j!=startPoint, dataOnly);
					if (!dataOnly && num > 0) that.points = points;
				});
				lastRatio = ratio;
			});
			if (dataOnly && that.type == "Squiggle") insertPointData(points, that.pointControls, that.segmentRatios, 100, controlType, null, dataOnly);
			if (that.stage) that.stage.update();
			that.num = points.length;
			return that;
		}
		this.interpolate = function(num, startPoint, spread, points) {
			if (zot(num)) num = 1;
			// dataOnly will add Point to start point too
			that.addPoints(num, "none", startPoint, spread, true, points)
			return that.interpolatedPoints;
		}

		this.linearGradient = function(colors,ratios,x0,y0,x1,y1) {
			this.linearGradientParams = Array.prototype.slice.call(arguments);
			this.colorCommand.linearGradient(colors,ratios,x0,y0,x1,y1);
			return this;
		}
		this.radialGradient = function(colors,ratios,x0,y0,radius0,x1,y1,radius1) {
			this.radialGradientParams = Array.prototype.slice.call(arguments);
			this.colorCommand.radialGradient(colors,ratios,x0,y0,radius0,x1,y1,radius1);
			return this;
		}

		this.dispose = function(temp) {
			// if (that.toggleStageEvent) that.stage.off("stagemousedown", that.toggleStageEvent);
			// this.zimContainer_dispose();
			// return true
			if (!that.shape) return;
			that.shape.cursor = "default";
			for (var i=0; i<that.pointObjects.length; i++) {
				that.pointObjects[i][1].removeAllEventListeners();
			}
			for (i=0; i<_pointCircles.length; i++) {
				_pointCircles[i].removeAllEventListeners();
			}
			that.sticks.removeFrom(that);
			that.controls.removeFrom(that);
			that.shape.removeAllEventListeners();
			that.controls.removeAllEventListeners();
			that.off("mousedown", that.toggleEvent);
			that.off("click", that.clickEvent);
			if (that.toggleStageEvent) that.stage.off("stagemousedown", that.toggleStageEvent);
			if (!temp && that.selectPoints) that.selectionManager.removeAllEventListeners();
			return true;
		}
	}
	zim.extend(zim.Blob, zim.Container, ["clone", "dispose"], "zimContainer", false);
	//-53.5

// SUBSECTION COMPONENTS

/*--
zim.Label = function(text, size, font, color, rollColor, shadowColor, shadowBlur, align, valign, lineWidth, lineHeight, fontOptions, backing, outlineColor, outlineWidth, backgroundColor, backgroundBorderColor, backgroundBorderWidth, corner, backgroundDashed, padding, paddingHorizontal, paddingVertical, shiftHorizontal, shiftVertical, rollPersist, labelWidth, labelHeight, maxSize, style, group, inherit)

Label
zim class - extends a zim.Container which extends a createjs.Container

DESCRIPTION
Makes a label - wraps the createjs Text object.
Can use with Button, CheckBox, RadioButtons and Pane.
Text seems to come in different sizes so we do our best.
Have tended to find that left and alphabetic are most consistent across browsers.
Custom fonts loaded through css can be used as well.
NOTE: can wrap text at given width using lineWidth parameter.

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var label = new Label("Hello");
label.center(stage); // adds label to and centers on the stage

var label = new Label({
	text:"CLICK",
	size:100,
	font:"courier",
	color:"white",
	rollColor:"red",
	fontOptions:"italic bold"
});
stage.addChild(label);
label.x = label.y = 100;
label.on("click", function(){zog("clicking");});
END EXAMPLE

EXAMPLE
STYLE = {font:"courier"};
new Label("Hi Courier").center(); // will be courier not arial

STYLE = {text:"YAY!", color:"Red"};
new Label().center().mov(0,100); // will say YAY! in red arial font
new Label("Hello").center().mov(0,200); // will say Hello in red arial
END EXAMPLE

PARAMETERS
** supports DUO - parameters or single object with properties below
** supports OCT - parameter defaults can be set with STYLE control (like CSS)
** supports VEE - parameters marked with ZIM VEE mean a zim Pick() object or Pick Literal can be passed
Pick Literal formats: [1,3,2] - random; {min:10, max:20} - range; series(1,2,3) - order, function(){return result;} - function

text |ZIM VEE| - String for the the text of the label
size - (default 36) the size of the font in pixels
font - (default arial) the font or list of fonts for the text
color - (default "black") color of font (any CSS color)
rollColor - (default color) the rollover color of the font
shadowColor - (default -1) for no shadow - set to any css color to see
shadowBlur - (default 14) if shadow is present
align - ((default "left") text registration point alignment also "center" and "right"
valign - (default "center") vertical registration point alignment alse "middle / center", "bottom"
lineWidth - (default false) for no wrapping (use \n) Can set to number for wrap
lineHeight - (default getMeasuredLineHeight) set to number to adjust line height
fontOptions - (default null) css VALUES as a single string for font-style font-variant font-weight
	eg. "italic bold small-caps" or just "italic", etc.
backing - (default null) a Display object for the backing of the label (eg. Shape, Bitmap, Container, Sprite)
	see ZIM Pizzazz module for a fun set of Shapes like Boomerangs, Ovals, Lightning Bolts, etc.
outlineColor - (default null - or black if outlineWidth set) - the color of the outline of the text
outlineWidth - (default null - or (size*.2) if outlineColor set) - the thickness of the outline of the text
backgroundColor - (default null) set to CSS color to add a rectangular color around the label
	The background color will change size to match the text of the label
	Note: the backgroundColor is different than a backing which can be any Display Object
	and background parameters are ignored if a backing parameter is set
backgroundBorderColor - (default null) the background stroke color
backgroundBorderWidth - (default null) thickness of the background border
corner - (default 0) the round of corner of the background if there is one
	can also be an array of [topLeft, topRight, bottomRight, bottomLeft]
backgroundDashed - (default null) set to true for dashed background border (if backgroundBorderColor or backgroundBorderWidth set)
padding - (default 10 if backgroundColor set) places the border this amount from text (see paddingHorizontal and paddingVertical)
	padding parameters are ignored if there is no backgroundColor set (also ignored if a backing parameter is set)
paddingHorizontal - (default padding) places border out at top bottom
paddingVertical - (default padding) places border out at left and right
shiftHorizontal - (default 0) move the label (CreateJS Text) inside the Label container horizontally
shiftVertical - (default 0) move the label (CreateJS Text) inside the Label container vertically
rollPersist - (default false) set to true to maintain rollover stage as long as mousedown or press is activated (used by Buttons)
labelWidth - (default null) the same as the lineWidth - the text will wrap at the labelWidth (added to match labelHeight)
labelHeight - (default null) the height of the text - setting this will probably alter the font size - so the size parameter is overwritten
	for labelHeight to work, the labelWidth must also be set
	using labelWidth and labelHeight together allow you to fit as much text into specified width and height dimensions
maxSize - (default null) set to limit the font size when using labelWidth and labelHeight
style - (default true) set to false to ignore styles set with the STYLE - will receive original parameter defaults
group - (default null) set to String (or comma delimited String) so STYLE can set default styles to the group(s) (like a CSS class)
inherit - (default null) used internally but can receive an {} of styles directly

METHODS
setColorRange(color1, color2) - set a color range for label - used by colorRange property - returns obj for chaining
	if one color is used, the current color is used and color1 is the second color in the range
showRollColor(visible) - default true to show roll color (used internally)
cache(see Container docs for parameter description) - overrides CreateJS cache() and returns object for chaining
	Leave parameters blank to cache bounds of shape (plus outer edge of border if borderWidth > 0)
hasProp(property as String) - returns true if property exists on object else returns false
clone() - makes a copy with properties such as x, y, etc. also copied
dispose() - removes from parent, removes event listeners - must still set outside references to null for garbage collection

ALSO: ZIM 4TH adds all the methods listed under Container (see above), such as:
drag(), hitTestRect(), animate(), sca(), reg(), mov(), center(), centerReg(),
addTo(), removeFrom(), loop(), outline(), place(), pos(), alp(), rot(), setMask(), etc.
ALSO: See the CreateJS Easel Docs for Container methods, such as:
on(), off(), getBounds(), setBounds(), uncache(), updateCache(), dispatchEvent(),
addChild(), removeChild(), addChildAt(), getChildAt(), contains(), removeAllChildren(), etc.

PROPERTIES
type - holds the class name as a String
label - references the text object of the label
text - references the text property of the text object
size - the font size of the Label (without px)
paddingHorizontal - read-only value for paddingHorizontal of label
	note - no padding property - that gets split into paddingHorizontal and paddingVertical
paddingVertical - read-only value for paddingVertical of label
color - gets or sets the label text color
colorRange - if setColorRange() is used, the colorRange is a ratio (0-1) between the colors
	setting the colorRange will change the color property of the label
	for instance, label.setColorRange(blue, pink) then label.colorRange = .5
	will set the color of the label to half way between blue and pink
	label.animate({color:red}, 1000); is a shortcut to animate the colorRange
	label.wiggle("colorRange", .5, .2, .5, 1000, 5000) will wiggle the colorRange
rollColor - gets or sets the label rollover color
labelWidth - the width at which the text wraps
labelHeight - setting this and labelWidth will change the font size to fit within the specified dimensions
** setting widths and heights adjusts scale not bounds and getting these uses the bounds dimension times the scale
width - gets or sets the width. Setting the width will scale the height to keep proportion (see widthOnly below)
height - gets or sets the height. Setting the height will scale the width to keep proportion (see heightOnly below)
widthOnly - gets or sets the width.  This sets only the width and may change the aspect ratio of the object
heightOnly - gets or sets the height.  This sets only the height and may change the aspect ratio of the object
depth - for ZIM VR - the depth used to shift left and right channel and for parallax in VR - also see dep() ZIM Display method
backing - access to backing object
background - access to background Rectangle if backgroundColor is set
enabled - default is true - set to false to disable
blendMode - how the object blends with what is underneath - such as "difference", "multiply", etc. same as CreateJS compositeOperation
group - used when the object is made to add STYLE with the group selector (like a CSS class)

ALSO: See the CreateJS Easel Docs for Container properties, such as:
x, y, rotation, scaleX, scaleY, regX, regY, skewX, skewY,
alpha, cursor, shadow, mouseChildren, mouseEnabled, parent, numChildren, etc.

OPTIMIZED
This component is affected by the general OPTIMIZE setting (default is false)
if set to true, you will have to stage.update() after setting certain properties

EVENTS
See the CreateJS Easel Docs for Container events, such as:
added, click, dblclick, mousedown, mouseout, mouseover, pressmove, pressup, removed, rollout, rollover
--*///+54
	zim.Label = function(text, size, font, color, rollColor, shadowColor, shadowBlur, align, valign, lineWidth, lineHeight, fontOptions, backing, outlineColor, outlineWidth, backgroundColor, backgroundBorderColor, backgroundBorderWidth, corner, backgroundDashed, padding, paddingHorizontal, paddingVertical, shiftHorizontal, shiftVertical, rollPersist, labelWidth, labelHeight, maxSize, style, group, inherit) {
		var sig = "text, size, font, color, rollColor, shadowColor, shadowBlur, align, valign, lineWidth, lineHeight, fontOptions, backing, outlineColor, outlineWidth, backgroundColor, backgroundBorderColor, backgroundBorderWidth, corner, backgroundDashed, padding, paddingHorizontal, paddingVertical, shiftHorizontal, shiftVertical, rollPersist, labelWidth, labelHeight, maxSize, style, group, inherit";
		var duo; if (duo = zob(zim.Label, arguments, sig, this)) return duo;
		z_d("54");
		this.zimContainer_constructor(null,null,null,null,false);
		this.type = "Label";
		this.group = group;
		var DS = style===false?{}:zim.getStyle(this.type, this.group, inherit);

		if (zot(text)) text=DS.text!=null?DS.text:"LABEL";
		var originalText = text;
		text = zim.Pick.choose(text);
		var emptyText = false;
		if (text === "") {
			text = " ";
			emptyText = true;
		}
		if (zot(size)) size=DS.size!=null?DS.size:36;
		if (zot(font)) font=DS.font!=null?DS.font:"arial"; // arial unless manually set
		if (zot(color)) color=DS.color!=null?DS.color:"black";
		if (zot(rollColor)) rollColor=DS.rollColor!=null?DS.rollColor:color;
		if (zot(shadowColor) || shadowColor=="ignore") shadowColor=(DS.shadowColor!=null&&shadowColor!="ignore")?DS.shadowColor:-1;
		if (zot(shadowBlur) || shadowBlur=="ignore") shadowBlur=(DS.shadowBlur!=null&&shadowBlur!="ignore")?DS.shadowBlur:14;
		if (zot(align)) align=DS.align!=null?DS.align:"left";
		if (zot(valign)) valign=DS.valign!=null?DS.valign:"top";
		if (zot(fontOptions)) fontOptions=DS.fontOptions!=null?DS.fontOptions:"";
		if ((!zot(outlineColor) || !zot(DS.outlineColor)) && zot(outlineWidth)) outlineWidth = DS.outlineWidth!=null?DS.outlineWidth:Math.round(size*.2);
		if ((!zot(outlineWidth) || !zot(DS.outlineWidth)) && zot(outlineColor)) outlineColor = DS.outlineColor!=null?DS.outlineColor:"#000000";
		if (zot(outlineWidth)) outlineWidth = DS.outlineWidth!=null?DS.outlineWidth:0;
		if (zot(backgroundColor) || backgroundColor=="ignore") backgroundColor = (DS.backgroundColor!=null&&backgroundColor!="ignore")?DS.backgroundColor:null;
		if (zot(padding) || padding=="ignore") padding = (DS.padding!=null&&padding!="ignore")?DS.padding:10;
		if (zot(paddingHorizontal)) paddingHorizontal = DS.paddingHorizontal!=null?DS.paddingHorizontal:padding;
		if (zot(paddingVertical)) paddingVertical = DS.paddingVertical!=null?DS.paddingVertical:padding;
		if (zot(shiftHorizontal)) shiftHorizontal = DS.shiftHorizontal!=null?DS.shiftHorizontal:0;
		if (zot(shiftVertical)) shiftVertical = DS.shiftVertical!=null?DS.shiftVertical:0;
		if (zot(lineWidth)) lineWidth = DS.lineWidth!=null?DS.lineWidth:null;
		if (zot(lineHeight)) lineHeight = DS.lineHeight!=null?DS.lineHeight:null;
		if (zot(backing) || backing=="ignore") backing = (DS.backing!=null&&backing!="ignore")?DS.backing.clone():null;
		if (zot(rollPersist)) DS.rollPersist!=null?DS.rollPersist:false;
		if (DS.labelWidth!=null) lineWidth = DS.labelWidth;
		if (!zot(labelWidth)) lineWidth = labelWidth;
		if (align == "middle") align = "center";
		if (zot(maxSize)) DS.maxSize!=null?DS.maxSize:null;
		size = maxSize?Math.min(size, maxSize):size;

		var retina = (typeof zimDefaultFrame!="undefined"&&zimDefaultFrame.retina);

		var that = this;
		this.mouseChildren = false;
		this.paddingVertical = paddingVertical;
		this.paddingHorizontal = paddingHorizontal;

		var obj = this.label = new createjs.Text(String(text), fontOptions + " " + size + "px " + font, color);
		obj.textAlign = align;
		obj.lineWidth = lineWidth;
		obj.lineHeight = lineHeight;
		obj.textBaseline = "alphabetic";
		if (outlineWidth > 0) {
			var obj2 = this.outlineLabel = obj.clone();
			obj2.color = outlineColor;
			obj2.outline = outlineWidth;
		}
		if (shadowColor != -1 && shadowBlur > 0) obj.shadow = new createjs.Shadow(shadowColor, 3, 3, shadowBlur);
		this.addChild(obj);

		function setSize() {
			var b = obj.getBounds();
			var yAdjust;
			if (valign == "baseline") {
				yAdjust = b.y;
			} else if (valign == "top") {
				obj.y = size-size/6;
				if (!retina && obj2) obj2.y = size-size/6;
				yAdjust = 0;
			} else if (valign == "center" || valign == "middle") {
				yAdjust = - b.height / 2;
				obj.y = size*.3;
				if (!retina && obj2) obj2.y = size*.3;
			} else { // bottom align
				yAdjust = -b.height;
			}
			if (backing) {
				if (backing.type == "Pattern") {
					that.setBounds(b.x-paddingHorizontal, yAdjust-paddingVertical, b.width+paddingHorizontal*2, b.height+paddingVertical*2);
				} else {
					var bb = backing.getBounds();
					that.setBounds(bb.x, bb.y, bb.width, bb.height);
				}
			} else if (!zot(backgroundColor)) {
				that.setBounds(b.x, yAdjust, b.width, b.height);
				that.removeChild(that.background);
				that.background = new zim.Rectangle(
					that.getBounds().width+paddingHorizontal*2, that.getBounds().height+paddingVertical*2,
					backgroundColor, backgroundBorderColor, backgroundBorderWidth, corner, backgroundDashed, null, false
				);
				zim.center(that.background, that, 0);
				that.setBounds(that.background.x, that.background.y, that.background.width, that.background.height);
			} else {
				that.setBounds(b.x, yAdjust, b.width, b.height);
				hitArea.graphics.c().f("black").r(that.getBounds().x, that.getBounds().y, that.getBounds().width, that.getBounds().height);
			}
			zim.center(obj, that);
			// zim.pos(obj, (align=="left"||align=="right")?(backing||that.background?paddingHorizontal:0):null, (valign=="top"||valign=="baseline"||valign=="bottom")?(backing||that.background?paddingVertical:0):null, align=="right", valign=="bottom");
			zim.pos(obj, (align=="left"||align=="right")?(backing||that.background?paddingHorizontal:0):null, backing||that.background?paddingVertical:0, align=="right", valign=="bottom");
			if (valign != "baseline") obj.y += size/(typeof zimDefaultFrame!="undefined"&&zimDefaultFrame.retina!=true?32:16); //32; // backing often on capital letters without descenders - was /16
			obj.x += shiftHorizontal;
			obj.y += shiftVertical;
			if (obj2) {
				if (retina) {
					that.added(function(stage){
						// CREATEJS NEEDS TO FIX their GLOBALTOLOCAL, etc. to work with scaled stage
						var b = obj2.getBounds();
						obj2.visible = true;
						// ** problem here - bounds should be around Label - not taking on lineHeight
						// because valign no longer works!
						var shim = new zim.Container(b.x, b.y, b.width, b.height);
						shim.addTo(that)
						shim.addChild(obj2);
						shim.center(that, that.numChildren-2);
						if (valign != "baseline") shim.y += size/16;
						shim.x += shiftHorizontal;
						shim.y += shiftVertical;

						stage.update();
					});
				} else {
					that.addChild(obj2);
					zim.center(obj2, that, that.numChildren-2);
					if (valign != "baseline") obj2.y += size/32;
					obj2.x += shiftHorizontal;
					obj2.y += shiftVertical;
					obj2.visible = true;
				}
			}
		}
	 	if (zot(backing) && zot(backgroundColor)) {
			var hitArea = new createjs.Shape();
			that.hitArea = hitArea;
		}
		setSize();

		if (!zot(backing)) {
			if (backing.type == "Pattern") {
				that.backing = new zim.Container(that.width, that.height, null, null, false).centerReg(null, null, false);
				if (shadowColor != -1 && shadowBlur > 0) {
					var shadowRect = new zim.Rectangle(that.width-2, that.height-2, "#666", null, null, corner, null, null, false).center(that.backing);
					shadowRect.shadow = new createjs.Shadow(shadowColor, 3, 3, shadowBlur);
				}
				var mask = new zim.Rectangle(that.width, that.height, backgroundColor, null, null, corner, null, null, false).addTo(that.backing);
				backing.centerReg(mask);
				backing.setMask(mask);
				that.backing.pattern = backing;
			} else {
				that.backing = backing;
			}
			that.backing.center(that, 0);
			backing = that.backing;
		}

		Object.defineProperty(that, 'text', {
			get: function() {
				var t = (obj.text == " " && emptyText) ? "" : obj.text;
				return t;
			},
			set: function(value) {
				emptyText = false;
				if (value === "") {
					value = " ";
					emptyText = true;
				}
				obj.text = String(value);
				if (obj2) obj2.text = String(value);
				setSize();
				if (!zot(lineWidth) && !zot(labelHeight)) {
					fitText();
				}
			}
		});

		Object.defineProperty(that, 'size', {
			get: function() {
				return size;
			},
			set: function(value) {
				size = maxSize?Math.min(value, maxSize):value;
				var text = this.label.font;
				// var reg = text.match(/^(\D*|.*\s)(\d\.?\d*)+px(.*)$/i);
				var reg = text.match(/^(.*\s)(\d*\.?\d*)+px(.*)$/i);
				if (!reg) return;
				this.label.font = reg[1] + value + "px" + reg[3];
				if (obj2) obj2.font = reg[1] + value + "px" + reg[3];
				setSize();
			}
		});

		Object.defineProperty(that, 'color', {
			get: function() {
				return color;
			},
			set: function(value) {
				if (rollColor == color) rollColor = value;
				color = value;
				obj.color = color;
				if ((!zim.OPTIMIZE&&(zns||!OPTIMIZE)) && that.stage) that.stage.update();
			}
		});
		var startColor;
		var endColor;
		this.setColorRange = function(color1, color2) {
			if (zot(color2)) {
				startColor = that.color;
				endColor = color1;
			} else if (zot(color1)) {
				startColor = that.color;
				endColor = color2;
			} else {
				startColor = color1;
				endColor = color2;
			}
			return that;
		}
		var _colorRange = 0;
		Object.defineProperty(that, 'colorRange', {
			get: function() {
				return _colorRange;
			},
			set: function(value) {
				_colorRange = value;
				if (!zot(startColor) && !zot(endColor)) {
					that.color = zim.colorRange(startColor, endColor, value);
				}
			}
		});

		Object.defineProperty(that, 'outlineColor', {
			get: function() {
				return outlineColor;
			},
			set: function(value) {
				outlineColor = value;
				if (obj2) obj2.color = outlineColor;
				if ((!zim.OPTIMIZE&&(zns||!OPTIMIZE)) && that.stage) that.stage.update();
			}
		});

		Object.defineProperty(that, 'rollColor', {
			get: function() {
				return rollColor;
			},
			set: function(value) {
				rollColor = value;
			}
		});

		this._enabled = true;
		Object.defineProperty(that, 'enabled', {
			get: function() {
				return that._enabled;
			},
			set: function(value) {
				zenable(that, value);
				obj.color = color;
				that.mouseChildren = false;
				if ((!zim.OPTIMIZE&&(zns||!OPTIMIZE)) && that.stage) that.stage.update();
			}
		});

		this.showRollColor = function(yes) {
			if (zot(yes)) yes = true;
			if (yes) {
				obj.color = rollColor;
			} else {
				obj.color = color;
			}
			if (that.stage) that.stage.update();
			return that;
		}

		this.mouseoverEvent = this.on("mouseover", function(e) {if (that.showRollColor) that.showRollColor();});
		this.mouseoutEvent = this.on("mouseout", function(e) {if (!that.rollPersist) that.showRollColor(false);});
		this.pressupEvent = this.on("pressup", function(e) {if (that.rollPersist) that.showRollColor(false);});

		Object.defineProperty(that, 'labelWidth', {
			get: function() {
				return lineWidth;
			},
			set: function(value) {
				if (value > 0) {
					lineWidth = value;
					that.label.lineWidth = value;
				}
				if (labelHeight) fitText();
				if ((!zim.OPTIMIZE&&(zns||!OPTIMIZE)) && that.stage) that.stage.update();
			}
		});

		Object.defineProperty(that, 'labelHeight', {
			get: function() {
				return labelHeight;
			},
			set: function(value) {
				if (value > 0) labelHeight = value;
				if (lineWidth) fitText();
				if ((!zim.OPTIMIZE&&(zns||!OPTIMIZE)) && that.stage) that.stage.update();
			}
		});
		if (!zot(lineWidth) && !zot(labelHeight)) {
			fitText();
		}
		function fitText() {
			that.size = 200;
			while(that.height > labelHeight || that.width > lineWidth) {
				that.size = that.size/2;
			}
			var count = 0;
			while(that.height <= labelHeight && that.width <= lineWidth) {
				count++;
				that.size = Math.ceil(that.size + 1);
				if (count>50) break;
			}
			that.size = that.size - 1;
		}

		zimStyleTransforms(this, DS)
		this.clone = function(exact) {
			return that.cloneProps(new zim.Label(exact?that.text:originalText, size, font, color, rollColor, shadowColor, shadowBlur, align, valign, lineWidth, lineHeight, fontOptions,
				!zot(backing)?backing.clone():null, outlineColor, outlineWidth, backgroundColor, backgroundBorderColor, backgroundBorderWidth, corner, backgroundDashed, padding, paddingHorizontal, paddingVertical, shiftHorizontal, shiftVertical, rollPersist, labelWidth, labelHeight, maxSize, style, this.group, inherit));
		}
	}
	zim.extend(zim.Label, zim.Container, "clone", "zimContainer");
	//-54


/*--
zim.LabelOnPath = function(label, path, percentAngle, percents, showPath, allowToggle, interactive, onTop, style, group, inherit)

LabelOnPath
zim class - extends a zim.Container which extends a createjs.Container

DESCRIPTION
Makes a label along a path of a Squiggle or Blob - which can be interactive, fixed, toggled or hidden
A list of percentages for where the letters are can be provided to move around letters
See: https://zimjs.com/explore/labelonpath.html

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var lop = new LabelOnPath({
	label:"Hello World",
	// label:new Label({text:"JELLO JIGGLES!", size:50}),
	// path:new Blob(),
	// path:new Squiggle({
	//     color:lighter,
	//     thickness:4,
	//     points:[[0,75,0,0,-100,200,100,-200],[300,75,0,0,-100,200,100,-200]]
	// }).transformPoints("scaleX",2).transformPoints("rotation",0),
	percentAngle:100, // default
	showPath:false, // default
	allowToggle:true, // default
	interactive:true, // default
	onTop:false // default
}).center();
zog(lop.text)

frame.on("keydown", function () {
	// shows percent spacing of letters along path
	// could pass [results] in as an array to percents parameter of LabelOnPath
    zog(lop.percents.toString());
	// uncomment to record the path
	// could pass this in as the points parameter to start with a given path
    // lop.path.recordPoints(true);
});
END EXAMPLE

PARAMETERS
** supports DUO - parameters or single object with properties below
** supports OCT - parameter defaults can be set with STYLE control (like CSS)
label - (default "Label on Path") a String or a ZIM Label
	can set any label properties such as color, size, font, etc. on the label passed in
path - (default new Squiggle()) a ZIM Squiggle or ZIM Blob
	can set any properties such as color, points, etc. on the shape passed in
percentAngle - (default 100) from 0-100 (or beyond in either direction) as to how much to tilt the letters
percents - (default null) an array of percentage locations of the letters along the line - should match number of letters
showPath - (default true) Boolean to show path at start
allowToggle - (default true) Boolean to allow user to toggle path off and on
interactive - (default true) Boolean to allow user to change path with controls, drag or add and remove points
	can also set these individually on the path
onTop - (default false) - Boolean to set path on top when dragged
style - (default true) set to false to ignore styles set with the STYLE - will receive original parameter defaults
group - (default null) set to String (or comma delimited String) so STYLE can set default styles to the group(s) (like a CSS class)
inherit - (default null) used internally but can receive an {} of styles directly

METHODS
toggle(state) - leave off state to toggle path to opposite state.  Use true to hide and false to show - returns object for chaining
hidePath() - hides path - returns object for chaining
showPath() - shows path - returns object for chaining
resize() - if not interactive, call this to update the text on the path - returns object for chaining
cache(see Container docs for parameter description) - overrides CreateJS cache() and returns object for chaining
	Leave parameters blank to cache bounds of shape (plus outer edge of border if borderWidth > 0)
hasProp(property as String) - returns true if property exists on object else returns false
clone() - makes a copy with properties such as x, y, etc. also copied
dispose() - removes from parent, removes event listeners - must still set outside references to null for garbage collection

ALSO: ZIM 4TH adds all the methods listed under Container (see above), such as:
drag(), hitTestRect(), animate(), sca(), reg(), mov(), center(), centerReg(),
addTo(), removeFrom(), loop(), outline(), place(), pos(), alp(), rot(), setMask(), etc.
ALSO: See the CreateJS Easel Docs for Container methods, such as:
on(), off(), getBounds(), setBounds(), uncache(), updateCache(), dispatchEvent(),
addChild(), removeChild(), addChildAt(), getChildAt(), contains(), removeAllChildren(), etc.

PROPERTIES
type - the name of the class as a String
text - get or set the text on the path
path - read-only access to path - but can manipulate the path
letters - access to ZIM Container of labels used for letters
	for instance labels.loop(function (label) {label.color = red;});
	or animate as a sequence labels.animate({props:{scale:1.5}, loop:true, rewind:true, sequence:200});
numLetters - how many letters - same as letters.numChildren
percents - access to the array of percents for letter positioning - resize() after changing unless interactive which auto resizes
allowToggle - get or set the Boolean to allow toggling the path
interactive - get or set the Boolean to allow interaction with the path
** setting widths and heights adjusts scale not bounds and getting these uses the bounds dimension times the scale
width - gets or sets the width. Setting the width will scale the height to keep proportion (see widthOnly below)
height - gets or sets the height. Setting the height will scale the width to keep proportion (see heightOnly below)
widthOnly - gets or sets the width.  This sets only the width and may change the aspect ratio of the object
heightOnly - gets or sets the height.  This sets only the height and may change the aspect ratio of the object


ALSO: See the CreateJS Easel Docs for Container properties, such as:
x, y, rotation, scaleX, scaleY, regX, regY, skewX, skewY,
alpha, cursor, shadow, mouseChildren, mouseEnabled, parent, numChildren, etc.

EVENTS
See the CreateJS Easel Docs for Container events, such as:
added, click, dblclick, mousedown, mouseout, mouseover, pressmove, pressup, removed, rollout, rollover
--*///+54.5

zim.LabelOnPath = function(label, path, percentAngle, percents, showPath, allowToggle, interactive, onTop, style, group, inherit) {
	var sig = "label, path, percentAngle, percents, showPath, allowToggle, interactive, onTop, style, group, inherit";
	var duo; if (duo = zob(zim.LabelOnPath, arguments, sig, this)) return duo;
	z_d("54.5");
	this.zimContainer_constructor(null,null,null,null,false);
	this.type = "LabelOnPath";
	this.group = group;
	var DS = style===false?{}:zim.getStyle(this.type, this.group, inherit);

	if (zot(label)) label = DS.label!=null?DS.label:new zim.Label("Label on Path");
	if (zot(path)) path = DS.path!=null?DS.path:new zim.Squiggle({points:[[0,0,0,0,-86,57,86,-57],[300,150,0,0,-133,21,133,-21]]});
	if (zot(percentAngle)) percentAngle = DS.percentAngle!=null?DS.percentAngle:100;
	if (zot(percents)) percents = DS.percents!=null?DS.percents:null;
	if (zot(showPath)) showPath = DS.showPath!=null?DS.showPath:true;
	if (zot(allowToggle)) allowToggle = DS.allowToggle!=null?DS.allowToggle:true;
	if (zot(interactive)) interactive = DS.interactive!=null?DS.interactive:true;
	if (zot(onTop)) onTop = DS.onTop!=null?DS.onTop:false;

	path.addTo(this);
	var that = this;
	this.path = path;
	this.allowToggle = allowToggle;
	path.interactive = interactive;

	if (typeof label == "string") label = new zim.Label(label);

	var lastAlpha = path.alpha;
	if (!showPath) path.alp(0);
	path.onTop = onTop;

	var letters = this.letters = new zim.Container().addTo(this);
	if (!percents) {
		percents = [];
		for (var i=0; i<label.text.length; i++) {
			percents.push(zim.decimals(1/(label.text.length-(path.type=="Blob"?0:1))*100*i));
		}
	}
	this.percents = percents;

	function setText() {
		for (var i=letters.numChildren-1; i>=0; i--) {
			letters.getChildAt(i).dispose();
		}
		that.numLetters = label.text.length;
		for (var i=0; i<that.numLetters; i++) {
			var letter = label.clone();
			letter.text = label.text[i];
			letter.centerReg(letters).reg(null,letter.height)
			if (letter.text != "" && letter.text != " ") letter.expand(0);
			if (that.allowToggle) letter.cursor = "pointer";
			letter.on("mousedown", function () {
				if (!that.allowToggle) return;
				that.toggle();
			})
		}
		that.resize();
	}

	this.resize = function() {
		var segmentRatios = path.segmentRatios;
		var segmentPoints = path.segmentPoints;
		for (var i=0; i<this.numLetters; i++) {
			var point = path.getCurvePoint(percents[i]/100, segmentRatios, segmentPoints, true);
			if (!point) continue;
			var locPoint = this.globalToLocal(point.x, point.y);
			if (!locPoint) continue;
			letters.getChildAt(i)
				.loc(locPoint)
				.rot((point.angle>180?(point.angle-360):point.angle)*percentAngle/100);
		}
		return this;
	}

	setText();

	this.showPath = function(controls) {
		this.toggle(true);
		path.toggle(controls)
		return this;
	}
	this.hidePath = function() {
		this.toggle(false);
		return this;
	}

	Object.defineProperty(that, 'text', {
		get: function() {
			return label.text;
		},
		set: function(value) {
			label.text = value;
			percents = [];
			for (var i=0; i<label.text.length; i++) {
				percents.push(zim.decimals(1/(label.text.length-(path.type=="Blob"?0:1))*100*i));
			}
			setText();
			// if (that.stage) that.stage.update();
		}
	});

	Object.defineProperty(that, 'interactive', {
		get: function() {
			return interactive;
		},
		set: function(value) {
			interactive = value;
			path.interactive = value;
			if (this.ticker) zim.Ticker.remove(this.ticker);
			if (interactive) {
				this.ticker = zim.Ticker.add(function () {
					that.resize();
				});
			}
		}
	});

	if (this.interactive) {
		this.ticker = zim.Ticker.add(function () {
			that.resize();
		});
	}
	var _toggled = that.toggled = showPath;

	this.toggle = function(state) {
		if (!this.allowToggle) return;

		if (zot(state)) _toggled = !_toggled;
		else if (state) _toggled = true;
		else _toggled = false;
		if (_toggled) {
			path.alp(lastAlpha);
			if (this.interactive) {
				path.showControls();
				letters.mouseEnabled = false;
				letters.mouseChildren = false;
				letters.cursor = "default";
				if (this.controlHideEvent) path.off("controlshide", this.controlHideEvent);
				this.controlHideEvent = path.on("controlshide", function () {
					letters.mouseEnabled = true;
					letters.mouseChildren = true;
					letters.cursor = "pointer";
					lastAlpha = path.alpha;
					path.alp(0);
					_toggled = false;
					that.toggled = _toggled;
				}, null, true); // just once
			}
		} else {
			lastAlpha = path.alpha;
			path.alp(0);
			letters.mouseEnabled = true;
			letters.mouseChildren = true;
			letters.cursor = "pointer";
		}
		that.toggled = _toggled;
		that.stage.update();
		return that;
	}

	zimStyleTransforms(this, DS)
	this.clone = function() {
		return that.cloneProps(new zim.LabelOnPath(that.label.clone(), that.path.clone(), percentAngle, zim.copy(percents), showPath, allowToggle, interactive, onTop, style, this.group, inherit));
	}
	this.dispose = function() {
		if (this.ticker) zim.Ticker.remove(this.ticker);
		this.zimContainer_dispose();
		return true;
	}
}
zim.extend(zim.LabelOnPath, zim.Container, ["clone", "dispose"], "zimContainer", false);
//-54.5

/*--
zim.Button = function(width, height, label, backgroundColor, rollBackgroundColor, color, rollColor, borderColor, borderRollColor, borderWidth, corner, shadowColor, shadowBlur, hitPadding, gradient, gloss, dashed, backing, rollBacking, rollPersist, icon, rollIcon, toggle, toggleBacking, rollToggleBacking, toggleIcon, rollToggleIcon, toggleEvent, wait, waitTime, waitBackgroundColor, rollWaitBackgroundColor, waitColor, rollWaitColor, waitModal, waitEnabled, waitBacking, rollWaitBacking, waitIcon, rollWaitIcon, align, valign, indent, indentHorizontal, indentVertical, style, group, inherit)

Button
zim class - extends a zim.Container which extends a createjs.Container

DESCRIPTION
Makes a button with rollover and many more features - see parameters.
You will need to pass in a Label to change the font properties of the button from the default.
You will then need to add the button to the stage and add a mousedown or click event.
Button rollover is done automatically.

You can set a backing display object (Shape, Bitmap, Pattern, etc.) in place of the standard rectangle.
You can set an icon display object in place of the standard text
You can set the Button to toggle between text, backings or icons
SEE the ZIM Pizzazz series for a growing selection of backings, patterns and icons
https://zimjs.com/bits/view/pizzazz.html
https://zimjs.com/bits/view/icons.html
https://zimjs.com/patterns.html

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var button = new Button("CLICK");
button.center(stage);
button.on("click", function(){zog("clicking");});

// OR add custom label (needed to change label color for instance)
var label = new Label({
	text:"POWER OPTION",
	size:40,
	backgroundColor:"violet",
	fontOptions:"bold"
});
var button = new Button({
	label:label,
	width:390,
	height:110,
	backgroundColor:"purple",
	rollBackgroundColor:"MediumOrchid",
	borderWidth:8,
	borderColor:"violet",
	gradient:.3,
	corner:0
});
button.center(stage);
END EXAMPLE

PARAMETERS
** supports DUO - parameters or single object with properties below
** supports OCT - parameter defaults can be set with STYLE control (like CSS)
width - (default 200) the width of the button
height - (default 60) the height of the button
label - (default "CLICK") ZIM Label or plain text with default settings (white)
backgroundColor - (default "orange") background color of button (any CSS color)
rollBackgroundColor - (default "lightorange") rollover background color of button
color - (default "white") label color of button (any CSS color) unless a custom Label is set
rollColor - (default "white") rollover label color of button
borderColor - (default null) the color of the border
borderRollColor - (default borderColor) the rollover color of the border
borderWidth - (default null) thickness of the border
corner - (default 20) the round of the corner (set to 0 for no corner)
	can also be an array of [topLeft, topRight, bottomRight, bottomLeft]
shadowColor - (default rgba(0,0,0,.3)) set to -1 for no shadow
shadowBlur - (default 14) how blurred the shadow is if the shadow is set
hitPadding - (default 0) adds extra hit area to the button (good for mobile)
	Note that if the button alpha is 0 the button will still be active if hitPadding is not equal to 0
	Set the hitPadding property to 0 in this case - thanks Frank Los for the notice
gradient - (default 0) 0 to 1 (try .3) adds a gradient to the button
gloss - (default 0) 0 to 1 (try .1) adds a gloss to the button
dashed - (default false) set to true to turn the border to dashed - if the borderColor or borderWidth is provided
backing - (default null) a Display object for the backing of the button (eg. Shape, Bitmap, Container, Sprite)
	assumed to be center registration for easy positioning *** as with all backings
	see ZIM Pizzazz module for a fun set of Button Shapes like Boomerangs, Ovals, Lightning Bolts, etc.
	https://zimjs.com/bits/view/pizzazz.html
rollBacking - (default null) a Display object for the backing of the rolled-on button
rollPersist - (default false) set to true to keep rollover state when button is pressed even if rolling off
icon - (default null) set to display object to add icon at the center of the button and remove label
	assumed to be center registration for easy positioning *** as with all icons
	https://zimjs.com/bits/view/icons.html
rollIcon - (default null) set to display object to show icon on rollover
toggle - (default null) set to string to toggle with label
	the button will not toggle if there is a wait parameter set
	see the backings and icons parameters below for custom toggle settings
	there are no color settings for toggle - to do this, just make a second button and swap buttons
toggleBacking - (default null) set to display object to set a different backing for toggled state
rollToggleBacking - (default null) set to display object to set a backing for the rolled toggle state
toggleIcon - (default null) set to display object to add icon at the center of the button and remove label in toggle state
rollToggleIcon - (default null) set to display object to show icon on rollover in toggle state
toggleEvent - (default mousedown for mobile and click for not mobile) what event causes the toggle
wait - (default null) - String word for button to show when button is pressed and a wait state is desired
	LOADING: this can be used as a loading message - so change the button to "LOADING"
	When the asset has loaded, use the clearWait() method to return to the normal button or toggled button state
	CONFIRMING: this can also be used to confirm user action rather than a full new confirm panel
	Set wait:"CONFIRM", set the waitBackgroundColor and rollWaitBackground parameters to red and the waitTime parameter to 4000
	In a button mousedown (must use mousedown - not click or tap if ACTIONEVENT is mousedown - the default),
	check if the waiting property is true to test for confirmation
	The waiting property will not be true for the first button press but will be true during the wait period
	Perhaps set the waitModal parameter to true to clearWait() if the user clicks off the button
	Use the clearWait() method to clear or cancel the wait status - for instance, if the pane the button is in is closed
waitTime - (default 30000 - 30 seconds) milliseconds (ms) to show wait state before reverting to normal button
waitBackgroundColor - (default red) color to make button during wait time if wait is set
rollWaitBackgroundColor - (default rollColor) color for button when waiting and rolled over
waitColor - (default label's color) color to make text during wait time if wait is set
rollWaitColor - (default label's roll color) color for text when waiting and rolled over
waitModal - (default false) set to true to clearWait() if the user clicks off the button
waitEnabled - (default true) set to false to disable button while wait is in progress
waitBacking - (default null) set to display object to set a different backing for wait state
rollWaitBacking - (default null) set to display object to a different roll backing for wait state
waitIcon - (default null) set to display object to add icon at the center of the button and remove label in wait state
rollWaitIcon - (default null) set to display object to show icon on rollover in wait state
align - (default "center") horizontal align of the label
valign - (default "center") vertical align of the label
indent - (default 10) indent of label when align or valign is set
indentHorizontal - (default indent) horizontal indent of label when align or valign is set
indentVertical - (default indent) vertical indent of label when align or valign is set
style - (default true) set to false to ignore styles set with the STYLE - will receive original parameter defaults
group - (default null) set to String (or comma delimited String) so STYLE can set default styles to the group(s) (like a CSS class)
inherit - (default null) used internally but can receive an {} of styles directly

METHODS
setBacking(type, newBacking) - dynamically set any type of backing for button (if null removes backing for that type)
	Backing types are: "backing", "rollBacking", "toggleBacking", "rollToggleBacking", "waitBacking", "rollWaitBacking"
	note - all backing will have a pattern property if a pattern is set as a backing
setIcon(type, newIcon) - dynamically set any type of icon for button (if null removes icon for that type)
	Icon types are: "icon", "rollIcon", "toggleIcon", "rollToggleIcon", "waitIcon", "rollWaitIcon"
toggle(state) - forces a toggle of label, backing and icon if set
	state defaults to null so just toggles if left blank
	pass in true to go to the toggled state and false to go to the original state
	returns object for chaining
wait() - forces a wait state - with wait text, backings and icons if set
clearWait() - clears a wait state of the button - sets it back to normal
removeWait() - removes (and clears) a wait state of the button so it will not trigger again
hasProp(property as String) - returns true if property exists on object else returns false
clone() - makes a copy with properties such as x, y, etc. also copied
dispose() - removes from parent, removes event listeners - must still set outside references to null for garbage collection

ALSO: ZIM 4TH adds all the methods listed under Container (see above), such as:
drag(), hitTestRect(), animate(), sca(), reg(), mov(), center(), centerReg(),
addTo(), removeFrom(), loop(), outline(), place(), pos(), alp(), rot(), setMask(), etc.
ALSO: See the CreateJS Easel Docs for Container methods, such as:
on(), off(), getBounds(), setBounds(), cache(), uncache(), updateCache(), dispatchEvent(),
addChild(), removeChild(), addChildAt(), getChildAt(), contains(), removeAllChildren(), etc.

PROPERTIES
type - holds the class name as a String
** setting widths and heights adjusts scale not bounds and getting these uses the bounds dimension times the scale
width - gets or sets the width. Setting the width will scale the height to keep proportion (see widthOnly below)
height - gets or sets the height. Setting the height will scale the width to keep proportion (see heightOnly below)
widthOnly - gets or sets the width.  This sets only the width and may change the aspect ratio of the object
heightOnly - gets or sets the height.  This sets only the height and may change the aspect ratio of the object
text - references the text property of the Label object of the button
label - gives access to the label
color - get or set non-rolled on label color (if no icon specified)
rollColor - get or set rolled on label color
backgroundColor - get or set non-rolled on backing color (if no backing specified)
rollBackgroundColor - get or set rolled on backing color
rollPersist - default is false - set to true to keep rollover state when button is pressed even if rolling off
borderColor - get or set non-rolled on border color
borderRollColor - get or set the border rolled color
hitPadding - extra padding for interactivity - see hitPadding parameter for extra notes
backing - references the backing of the button
	use setBacking() to change as with all backings
	note - all backings will have a pattern property if a pattern is set as a backing
rollBacking - references the rollBacking (if set)
icon - references the icon of the button (if set)
	use setIcon() to change as with all icons
rollIcon - references the rollIcon (if set)
rolled - read-only true if button is being rolled over else false
toggled - read-only true if button is in toggled state, false if button is in original state
toggleBacking - references the toggle backing (if set)
rollToggleBacking - references the toggle roll backing (if set)
toggleIcon - references the toggle icon (if set)
rollToggleIcon - references the toggle roll icon (if set)
waiting - read-only true if button is in the waiting state within wait time
waitBacking - references the wait backing (if set)
rollWaitBacking - references the wait roll backing (if set)
waitIcon - references the wait icon (if set)
rollWaitIcon - references the wait roll icon (if set)
focus - get or set the focus property of the Button used for tabOrder
enabled - default is true - set to false to disable
blendMode - how the object blends with what is underneath - such as "difference", "multiply", etc. same as CreateJS compositeOperation
group - used when the object is made to add STYLE with the group selector (like a CSS class)

ALSO: See the CreateJS Easel Docs for Container properties, such as:
x, y, rotation, scaleX, scaleY, regX, regY, skewX, skewY,
alpha, cursor, shadow, mouseChildren, mouseEnabled, parent, numChildren, etc.

OPTIMIZED
This component is affected by the general OPTIMIZE setting (default is false)
if set to true, you will have to stage.update() after setting certain properties
for example seeing toggle take effect

EVENTS
dispatches a "waited" event if button is in wait state and the wait time has completed
See the CreateJS Easel Docs for Container events, such as:
added, click, dblclick, mousedown, mouseout, mouseover, pressmove, pressup, removed, rollout, rollover
--*///+55
	zim.Button = function(width, height, label, backgroundColor, rollBackgroundColor, color, rollColor, borderColor, borderRollColor, borderWidth, corner, shadowColor, shadowBlur, hitPadding, gradient, gloss, dashed, backing, rollBacking, rollPersist, icon, rollIcon, toggle, toggleBacking, rollToggleBacking, toggleIcon, rollToggleIcon, toggleEvent, wait, waitTime, waitBackgroundColor, rollWaitBackgroundColor, waitColor, rollWaitColor, waitModal, waitEnabled, waitBacking, rollWaitBacking, waitIcon, rollWaitIcon, align, valign, indent, indentHorizontal, indentVertical, style, group, inherit) {
		var sig = "width, height, label, backgroundColor, rollBackgroundColor, color, rollColor, borderColor, borderRollColor, borderWidth, corner, shadowColor, shadowBlur, hitPadding, gradient, gloss, dashed, backing, rollBacking, rollPersist, icon, rollIcon, toggle, toggleBacking, rollToggleBacking, toggleIcon, rollToggleIcon, toggleEvent, wait, waitTime, waitBackgroundColor, rollWaitBackgroundColor, waitColor, rollWaitColor, waitModal, waitEnabled, waitBacking, rollWaitBacking, waitIcon, rollWaitIcon, align, valign, indent, indentHorizontal, indentVertical, style, group, inherit";
		var duo; if (duo = zob(zim.Button, arguments, sig, this)) return duo;
		z_d("55");
		this.group = group;
		var DS = style===false?{}:zim.getStyle("Button", group, inherit);

		if (zot(width)) width=DS.width!=null?DS.width:200;
		if (zot(height)) height=DS.height!=null?DS.height:60;
		this.zimContainer_constructor(width, height, null, null, false);
		this.type = "Button";

		if (zot(backgroundColor)) backgroundColor=DS.backgroundColor!=null?DS.backgroundColor:"#C60";
		if (zot(rollBackgroundColor)) rollBackgroundColor=DS.rollBackgroundColor!=null?DS.rollBackgroundColor:"#F93";
		if (zot(color)) color=DS.color!=null?DS.color:"white";
		if (zot(rollColor)) rollColor=DS.rollColor!=null?DS.rollColor:"white";
		if (zot(waitBackgroundColor)) waitBackgroundColor=DS.waitBackgroundColor!=null?DS.waitBackgroundColor:backgroundColor;
		if (zot(rollWaitBackgroundColor)) rollWaitBackgroundColor=DS.rollWaitBackgroundColor!=null?DS.rollWaitBackgroundColor:rollBackgroundColor;
		var originalBorderColor = borderColor;
		var originalBorderWidth = borderWidth;
		if (zot(borderColor)) borderColor = DS.borderColor!=null?DS.borderColor:null;
		if (zot(borderWidth)) borderWidth = DS.borderWidth!=null?DS.borderWidth:null;
		if (borderColor < 0 || borderWidth < 0) borderColor = borderWidth = null;
		else if (borderColor!=null && borderWidth==null) borderWidth = 1;
		if (zot(borderRollColor)) borderRollColor=DS.borderRollColor!=null?DS.borderRollColor:borderColor;
		if (zot(corner)) corner=DS.corner!=null?DS.corner:20;
		if (zot(shadowColor)) shadowColor=DS.shadowColor!=null?DS.shadowColor:"rgba(0,0,0,.3)";
		if (zot(shadowBlur)) shadowBlur=DS.shadowBlur!=null?DS.shadowBlur:14;
		if (zot(hitPadding)) hitPadding=DS.hitPadding!=null?DS.hitPadding:0;
		if (zot(align)) align=DS.align!=null?DS.align:"center";
		if (zot(valign)) valign=DS.valign!=null?DS.valign:"center";
		if (zot(indent)) indent=DS.indent!=null?DS.indent:10;
		if (zot(indentHorizontal)) indentHorizontal=DS.indentHorizontal!=null?DS.indentHorizontal:indent;
		if (zot(indentVertical)) indentVertical=DS.indentVertical!=null?DS.indentVertical:indent;
		if (zot(gradient)) gradient = DS.gradient!=null?DS.gradient:0;
		if (zot(gloss)) gloss = DS.gloss!=null?DS.gloss:0;
		if (zot(label)) {if (zot(icon)) {label = DS.label!=null?DS.label:"PRESS";} else {label = "";}}
		var toggleOkay = (!zot(toggle) || !zot(toggleBacking) || !zot(rollToggleBacking) || !zot(toggleIcon) || !zot(rollToggleIcon)) && zot(wait) && zot(waitBacking) && zot(rollWaitBacking);
		if (toggleOkay && zot(toggleEvent)) toggleEvent = zim.mobile()?"mousedown":"click";
		// text, size, font, color, rollColor, shadowColor, shadowBlur, align, valign
		if (typeof label === "string" || typeof label === "number") label = new zim.Label({
			text:label, size:DS.size!=null?DS.size:36, font:DS.font!=null?DS.font:"arial", color:DS.color!=null?DS.color:color, rollColor:DS.rollColor!=null?DS.rollColor:rollColor, align:align, valign:valign, rollPersist:DS.rollPersist!=null?DS.rollPersist:false,
			backing:"ignore", shadowColor:"ignore", shadowBlur:"ignore", padding:"ignore", backgroundColor:"ignore", shiftVertical:DS.shiftVertical!=null?DS.shiftVertical:0, shiftHorizontal:DS.shiftHorizontal!=null?DS.shiftHorizontal:0,
			style:false, group:this.group
		});
		if (zot(rollPersist)) rollPersist = DS.rollPersist!=null?DS.rollPersist:false;
		this.rollPersist = rollPersist;
		if (zot(dashed)) dashed = DS.dashed!=null?DS.dashed:false;
		if (!zot(toggle) && toggle.type=="Label") {if (zon) zog("ZIM Button() - do not pass Label to toggle parameter - just pass a String")}

		var that = this;
		this.mouseChildren = false;
		this.cursor = "pointer";
		that.focus = false;
		that.rolled = false;
		var stage;

		//~~~~~~~~~~~~~  BACKINGS
		// also see manual setting of backings beneath getter setter methods
		if (zot(backing)) backing = DS.backing!=null?DS.backing.clone():null;
		if (zot(backing)) that.backing = new zim.Rectangle(width,height,backgroundColor,null,null,corner,dashed,null,false).centerReg(null, null, false);
		else that.backing = backing; // if backing is null - we have no custom backing - this test is used later

		that.rollBacking = zot(rollBacking)?(DS.rollBacking!=null?DS.rollBacking.clone():null):rollBacking;
		that.waitBacking = zot(waitBacking)?(DS.waitBacking!=null?DS.waitBacking.clone():null):waitBacking;
		that.rollWaitBacking = zot(rollWaitBacking)?(DS.rollWaitBacking!=null?DS.rollWaitBacking.clone():null):rollWaitBacking;
		that.toggleBacking = zot(toggleBacking)?(DS.toggleBacking!=null?DS.toggleBacking.clone():null):toggleBacking;
		that.rollToggleBacking = zot(rollToggleBacking)?(DS.rollToggleBacking!=null?DS.rollToggleBacking.clone():null):rollToggleBacking;

		var backingTypes = ["backing", "rollBacking", "toggleBacking", "rollToggleBacking", "waitBacking", "rollWaitBacking"];
		var t;
		var b;
		for (var i=0; i<backingTypes.length; i++) {
			t = backingTypes[i];
			b = that[t]; // access to object passed to parameter or null
			if (b) {
				if (b.type == "Pattern") {
					b = setPattern(t, b);
				} else if (shadowColor != -1 && shadowBlur > 0) {
					b.shadow = new createjs.Shadow(shadowColor, 3, 3, shadowBlur);
				}
				// assumes center reg
    			b.x = width / 2;
    			b.y = height / 2;
			}
		}
		that.addChild(that.backing);
		if (borderWidth) {
			that.border = new zim.Rectangle(width, height, "rgba(0,0,0,0)", borderColor, borderWidth, corner, dashed, null, false);
			that.addChild(that.border);
		}
		function setPattern(type, pattern) {
			that[type] = new zim.Container(width, height, null, null, false).centerReg(null, null, false);
			if (shadowColor != -1 && shadowBlur > 0) {
				var shadowRect = new zim.Rectangle(width-2, height-2, "#666", null, null, corner, null, null, false).center(that[type]);
				shadowRect.shadow = new createjs.Shadow(shadowColor, 3, 3, shadowBlur);
			}
			var mask = that[type].mask = new zim.Rectangle(width, height, type.indexOf("roll")>=0?rollBackgroundColor:backgroundColor, null, null, corner, null, null, false).addTo(that[type]);
			pattern.centerReg(mask);
			pattern.setMask(mask.shape);
			that[type].pattern = pattern;
			return that[type];
		}

		//~~~~~~~~~~~~~  ICONS
		that.icon = zot(icon)?(DS.icon!=null?DS.icon.clone():null):icon;
		that.rollIcon = zot(rollIcon)?(DS.rollIcon!=null?DS.rollIcon.clone():null):rollIcon;
		that.waitIcon = zot(waitIcon)?(DS.waitIcon!=null?DS.waitIcon.clone():null):waitIcon;
		that.rollWaitIcon = zot(rollWaitIcon)?(DS.rollWaitIcon!=null?DS.rollWaitIcon.clone():null):rollWaitIcon;
		that.toggleIcon = zot(toggleIcon)?(DS.toggleIcon!=null?DS.toggleIcon.clone():null):toggleIcon;
		that.rollToggleIcon = zot(rollToggleIcon)?(DS.rollToggleIcon!=null?DS.rollToggleIcon.clone():null):rollToggleIcon;
		var iconTypes = ["icon", "rollIcon", "toggleIcon", "rollToggleIcon", "waitIcon", "rollWaitIcon"];
		for (var i=0; i<iconTypes.length; i++) {
			var ty = iconTypes[i];
			var ic = that[ty]; // access to object passed to parameter or null
			if (ic) {
				// assumes center reg
    			ic.x = width / 2;
    			ic.y = height / 2;
			}
		}
		if (that.icon) that.addChild(that.icon);

		//~~~~~~~~~~~~~  GRADIENT AND GLOSS

		if (!Array.isArray(corner)) corner = [corner, corner, corner, corner];
		if (gradient > 0) { // add an overlay
			var gr = new createjs.Shape();
			gr.graphics.lf(["rgba(255,255,255,"+gradient+")","rgba(0,0,0,"+gradient+")"], [0, 1], 0, 0, 0, height-borderWidth);
			gr.graphics.rc(borderWidth/2, borderWidth/2, width-borderWidth, height-borderWidth, corner[0], corner[1], corner[2], corner[3]);
			this.addChild(gr);
		}
		if (gloss > 0) { // add an overlay
			var gl = new createjs.Shape();
			gl.graphics.f("rgba(255,255,255,"+gloss+")");
			gl.graphics.rc(borderWidth/2, borderWidth/2, width-borderWidth, (height-borderWidth)/2, corner[0], corner[1], 0, 0);
			gl.graphics.f("rgba(0,0,0,"+gloss+")");
			gl.graphics.rc(borderWidth/2, height/2, width-borderWidth, (height-borderWidth)/2, 0, 0, corner[2], corner[3]);
			this.addChild(gl);
		}

		//~~~~~~~~~~~~~  HITAREA AND LABEL

		var hitArea;
		var rect;
		if (hitPadding > 0) makeHitArea();
		function makeHitArea() {
			rect = new createjs.Shape();
			rect.graphics.f("#000").r(-hitPadding,-hitPadding,width+hitPadding*2,height+hitPadding*2);
			that.hitArea = hitArea = rect;
		}

		this.addChild(label);
		label.center(this);
		label.y+=(typeof zimDefaultFrame!="undefined" && zimDefaultFrame.retina!=true)?1:0;
		this.label = label;

		zim.pos(label, (align=="left"||align=="right")?indentHorizontal:null, (valign=="top"||valign=="bottom")?indentVertical:null, align=="right", valign=="bottom");


		//~~~~~~~~~~~~~  TOGGLE STATE
		this.toggled = false;
		if (toggleOkay) {
			var originalText = label.text;
			this.on(toggleEvent, function() {
				that.toggled = !that.toggled;
				setToggled();
			});
		}

		function setToggled() {
			if (that.toggled) {
				if (!zot(toggle)) that.text = toggle;
				// for toggle - may start in rollover or could be manually called
				if (that.rolled) {
					if (that.rollToggleBacking) changeObject("rollToggleBacking", that.rollToggleBacking);
					else if (that.toggleBacking) changeObject("toggleBacking", that.toggleBacking);
					if (that.rollToggleIcon) changeObject("rollToggleIcon", that.rollToggleIcon);
					else if (that.toggleIcon) changeObject("toggleIcon", that.toggleIcon);
				} else {
					if (that.toggleBacking) changeObject("toggleBacking", that.toggleBacking);
					if (that.toggleIcon) changeObject("toggleIcon", that.toggleIcon);
				}
			} else {
				that.text = originalText;
				setOriginalObjects();
			}
			if (that.stage) that.stage.update();
		}

		function setOriginalObjects() {
			if (that.rolled) {
				if (zot(backing) && !that.rollBacking) that.backing.color = rollBackgroundColor;
				if (that.rollBacking) changeObject("rollBacking", that.rollBacking);
				else if (that.backing) changeObject("backing", that.backing);
				if (that.rollIcon) changeObject("rollIcon", that.rollIcon);
				else if (that.icon) changeObject("icon", that.icon);
				else changeObject("icon", null);
			} else {
				if (zot(backing)) that.backing.color = backgroundColor;
				if (that.backing) changeObject("backing", that.backing);
				if (that.icon) changeObject("icon", that.icon);
				else changeObject("icon", null);
			}
		}

		this.toggle = function(state) {
			if (!toggleOkay) {
				if (zon) zog("zim.Button() - can't toggle with wait parameters provided");
				return that;
			}
			if (zot(state)) {
				that.toggled = !that.toggled;
			} else {
				that.toggled = state;
			}
			setToggled();
			return that;
		}

		//~~~~~~~~~~~~~  WAIT STATE
		var pressCheck = false;
		that.waiting = false;
		var willBeWaiting = false;
		var waitTimeout;
		var waitStartText;
		// var waitStartBackgroundColor;
		var waitStartTextBackgroundColor = that.label.color;
		var waitStartRollTextBackgroundColor = that.label.rollColor;
		var waitStartEnabled;
		var waitModalEvent;
		var waitEvent = this.on("mousedown", function() {
			pressCheck=true;
			doWait();
		});

		function doWait() {
			if ((!zot(wait) || !zot(waitBacking) || !zot(rollWaitBacking)) && !that.waiting) {
				willBeWaiting = true;
				if (zot(waitEnabled)) waitEnabled = true;
				if (waitModal) waitModalEvent = that.stage.on("stagemousedown", function(e) {
					if (!that.hitTestPoint(e.stageX/e.target.stage.scaleX, e.stageY/e.target.stage.scaleY)) that.clearWait();
				}, null, true); // run only once
				// wait before setting the waiting property so first click is not a waiting
				setTimeout(function(){that.waiting = true;}, 50);
				// set button to waiting state
				waitStartText = label.text;
				if (!zot(waitColor)) that.label.color = waitColor;
				if (!zot(rollWaitColor)) that.label.rollColor = rollWaitColor;
				waitStartEnabled = that.enabled;
				if (!waitEnabled && that.enabled) that.enabled = false;
				if (!zot(wait)) that.text = wait;

				if (that.rolled) {
					if (zot(backing) && !that.rollWaitBacking) that.backing.color = rollWaitBackgroundColor;
					if (that.rollWaitBacking) changeObject("rollWaitBacking", that.rollWaitBacking);
					else if (that.waitBacking) changeObject("waitBacking", that.waitBacking);
					if (that.rollWaitIcon) changeObject("rollWaitIcon", that.rollWaitIcon);
					else if (that.waitIcon) changeObject("waitIcon", that.waitIcon);
				} else {
					if (zot(backing) && !that.waitBacking) that.backing.color = waitBackgroundColor;
					if (that.waitBacking) changeObject("waitBacking", that.waitBacking);
					if (that.waitIcon) changeObject("waitIcon", that.waitIcon);
				}

				if (zot(waitTime)) waitTime = 30000; // 30 seconds
				if (waitTimeout) waitTimeout.clear();
				waitTimeout = timeout(waitTime, function() {
					// set button to proper text, icon, backing, colors, etc.
					if (!that.enabled) that.enabled = waitStartEnabled;
					that.clearWait();
					that.dispatchEvent("waited");
				});
				if (that.stage) that.stage.update();
			}
		};
		this.wait = function() {
			doWait();
		}
		this.clearWait = function() {
			if (!waitTimeout) return that;
			if (waitModalEvent) that.stage.off("stagemousedown", waitModalEvent);
			waitTimeout.clear();
			that.text = waitStartText;
			setOriginalObjects();
			that.label.color = waitStartTextBackgroundColor;
			that.label.rollColor = waitStartRollTextBackgroundColor;
			setTimeout(function(){that.waiting = false;}, 55); // give time for first click to see not waiting yet
			willBeWaiting = false;
			if (that.stage) that.stage.update();
			return that;
		}
		this.removeWait = function() {
			that.clearWait();
			wait = null;
			that.waitBacking = null;
			that.rollWaitBacking = null;
			that.off("mousedown", waitEvent);
			return that;
		}

		//~~~~~~~~~~~~~  INTERACTION

		this.on("pressup", function(){
			pressCheck=false;
			if (that.rollPersist && !reallyOn) removeRoll();
		});

		// visually swap button backing or icon
		// on clicks if wait or toggle and on mouseover and mouseout
		// note - icon will be removed if newObject is null
		// BUT - backing will be ignored if newObject is null
		// so these act slightly differently!
		function changeObject(type, newObject) {
			if (type.indexOf("con")>=0) { // icon
				for (var i=0; i<iconTypes.length; i++) {
					var ty = iconTypes[i];
					var ic = that[ty];
					that.removeChild(ic);
				}
				if (that[type]) that.addChildAt(that[type], 1);
			} else {
				if (!that[type]) return;
				for (var i=0; i<backingTypes.length; i++) {
					var t = backingTypes[i];
					var b = that[t];
					that.removeChild(b);
				}
				if (that[type]) that.addChildAt(that[type], 0);
			}
		}

		var reallyOn = false;
		this.on("mouseover", buttonOn);
		function buttonOn(e) {
			that.rolled = true;
			reallyOn = true;

			// specific to each setting
			// so can have a rollover backing even without a backing
			// also... if no rollWaitBacking or rollToggleBacking
			// then if there is the backing for these, still set the backing
			// all backings get removed and current backing object is placed
			// normal buttons (with no backings) get borders on rectangle
			// backings get overlayed border with borderColor and borderRollColor
			// will have to track each state normal, toggle and wait
			// do not set colors on any custom backings (aside from border colors)

			if (willBeWaiting) {
				if (zot(backing) && zot(that.rollWaitBacking)) that.backing.color = zot(rollWaitBackgroundColor)?rollBackgroundColor:rollWaitBackgroundColor;
				changeObject("rollWaitBacking", that.rollWaitBacking);
				if (that.rollWaitIcon) changeObject("rollWaitIcon", that.rollWaitIcon);
			} else if (toggleOkay && that.toggled) {
				if (zot(backing) && zot(that.rollToggleBacking)) that.backing.color = rollBackgroundColor;
				changeObject("rollToggleBacking", that.rollToggleBacking);
				if (that.rollToggleIcon) changeObject("rollToggleIcon", that.rollToggleIcon);
			} else {
				if (zot(backing)) that.backing.color = rollBackgroundColor;
				else if (!zot(backing.mask)) that.backing.mask.color = rollBackgroundColor;
				changeObject("rollBacking", that.rollBacking);
				if (that.rollIcon) changeObject("rollIcon", that.rollIcon);
			}
			if (that.border) that.border.borderColor = borderRollColor;

			if (that.label.showRollColor) that.label.showRollColor();
			if (that.stage) that.stage.update();
		}

		this.on("mouseout", buttonOff); // thanks Maxime Riehl
		function buttonOff(e) {
			reallyOn = false;
			that.off("mouseout", buttonOff); // not working and not needed? 2018
			if (that.rollPersist) {
				if (!pressCheck) removeRoll();
			} else {
				removeRoll();
			}
		}
		function removeRoll() {
			that.rolled = false;
			if (willBeWaiting || that.waiting) {
				if (zot(backing) && zot(that.waitBacking)) that.backing.color = zot(waitBackgroundColor)?backgroundColor:waitBackgroundColor;
				if (that.waitBacking) changeObject("waitBacking", that.waitBacking);
				else changeObject("backing", that.backing);
				if (that.waitIcon) changeObject("waitIcon", that.waitIcon);
				else if (that.icon) changeObject("icon", that.icon);
				else changeObject("icon", null);
			} else if (that.toggled && toggleOkay) {
				if (zot(backing) && zot(that.toggleBacking)) that.backing.color = backgroundColor;
				if (that.toggleBacking) changeObject("toggleBacking", that.toggleBacking);
				else changeObject("backing", that.backing);
				if (that.toggleIcon) changeObject("toggleIcon", that.toggleIcon);
				else if (that.icon) changeObject("icon", that.icon);
				else changeObject("icon", null);
			} else {
				if (zot(backing))  that.backing.color = backgroundColor;
				else if (!zot(backing.mask)) that.backing.mask.color = backgroundColor;
				changeObject("backing", that.backing);
				if (that.icon) changeObject("icon", that.icon);
				else changeObject("icon", null);
			}

			if (that.border) that.border.borderColor = borderColor;

			if (that.label.showRollColor) that.label.showRollColor(false);
			if (that.stage) that.stage.update();
		}


		Object.defineProperty(that, 'text', {
			get: function() {
				var t = (label.text == " ") ? "" : label.text;
				return t;
			},
			set: function(value) {
				label.text = value;
				label.center(this);
				label.y+=1;
			}
		});

		Object.defineProperty(that, 'color', {
			get: function() {
				return color;
			},
			set: function(value) {
				color = value;
				if (that.label && !zot(that.label.color)) {
					that.label.color = color;
				}
				if ((!zim.OPTIMIZE&&(zns||!OPTIMIZE)) && that.stage) that.stage.update();
			}
		});

		Object.defineProperty(that, 'rollColor', {
			get: function() {
				return rollColor;
			},
			set: function(value) {
				rollColor = value;
				if (that.label) {
					that.label.rollColor = rollColor;
				}
			}
		});

		Object.defineProperty(that, 'backgroundColor', {
			get: function() {
				return backgroundColor;
			},
			set: function(value) {
				backgroundColor = value;
				if (that.backing.color) {
					that.backing.color = backgroundColor;
				} else if (that.backing.mask) {
					that.backing.mask.color = backgroundColor;
				}
				if ((!zim.OPTIMIZE&&(zns||!OPTIMIZE)) && that.stage) that.stage.update();
			}
		});

		Object.defineProperty(that, 'rollBackgroundColor', {
			get: function() {
				return rollBackgroundColor;
			},
			set: function(value) {
				rollBackgroundColor = value;
				if (that.rollBacking && that.rollBacking.color) {
					that.rollBacking.color = rollBackgroundColor;
				} else if (that.rollBacking && that.rollBacking.mask) {
					that.rollBacking.mask.color = rollBackgroundColor;
				}
			}
		});

		Object.defineProperty(that, 'borderColor', {
			get: function() {
				return borderColor;
			},
			set: function(value) {
				borderColor = value;
				if (!that.rolled) {
					if (that.backing && that.backing.borderColor) that.backing.borderColor = value;
					if (that.border) that.border.borderColor = value;
				}
			}
		});

		Object.defineProperty(that, 'borderRollColor', {
			get: function() {
				return borderRollColor;
			},
			set: function(value) {
				borderRollColor = value;
				if (that.rolled) {
					if (that.backing && that.backing.borderColor) that.backing.borderColor = value;
					if (that.border) that.border.borderColor = value;
				}
			}
		});

		Object.defineProperty(that, 'hitPadding', {
			get: function() {
				return hitPadding;
			},
			set: function(value) {
				hitPadding = value;
				if (hitPadding == 0) {
					if (hitArea) {
						this.hitArea = null;
					}
				} else {
					makeHitArea();
				}
			}
		});

		this._enabled = true;
		this.startMouseChildren = this.mouseChildren;
		Object.defineProperty(that, 'enabled', {
			get: function() {
				return that._enabled;
			},
			set: function(value) {
				if (that._enabled) that.startMouseChildren = that.mouseChildren;
				if (value) {
					zenable(that, value);
					that.mouseChildren = that.startMouseChildren;
				} else {
					removeRoll();
					zenable(that, value);
				}
				label.color = label.color;
				if ((!zim.OPTIMIZE&&(zns||!OPTIMIZE)) && that.stage) that.stage.update();
			}
		});

		// setBacking or leave backing parameter blank to remove this type of backing
		this.setBacking = function(type, newBacking) {
			setObject(type, newBacking);
		}
		// setIcon or leave icon parameter blank to remove this type of icon
		this.setIcon = function(type, newIcon) {
			setObject(type, newIcon);
		}
		function setObject(type, newObject) {
			if (zot(type)) return that;
			if (that.contains(that[type])) {
				that.removeChild(that[type]);
				if (newObject) that.addChildAt(newObject, type.indexOf("con")>=0?that.numChildren-1:0);
				if (that.stage) that.stage.update();
			}
			if (newObject) {
				if (zot(backing) && type == "backing") backing = newObject;
				if (newObject.type == "Pattern") newObject = setPattern(type, newObject);
				that[type] = newObject;
				that[type].x = width/2;
				that[type].y = height/2;
			} else {
				that[type] = null;
			}
			return that;
		}
		if (style!==false) if (style!==false) zimStyleTransforms(this, DS);
		this.clone = function() {
			var but = new zim.Button(
				width, height, label.clone(), backgroundColor, rollBackgroundColor, color, rollColor, originalBorderColor, borderRollColor, originalBorderWidth, corner, shadowColor, shadowBlur, hitPadding, gradient, gloss, dashed,
				!zot(backing)?that.backing.clone():null,
				!zot(rollBacking)?that.rollBacking.clone():null,
				rollPersist,
				!zot(icon)?icon.clone():null, !zot(rollIcon)?rollIcon.clone():null,
				toggle,
				!zot(toggleBacking)?toggleBacking.clone():null,
				!zot(rollToggleBacking)?rollToggleBacking.clone():null,
				!zot(toggleIcon)?toggleIcon.clone():null,
				!zot(rollToggleIcon)?rollToggleIcon.clone():null,
				toggleEvent,
				wait, waitTime, waitBackgroundColor, rollWaitBackgroundColor, waitColor, rollWaitColor, waitModal, waitEnabled,
				!zot(waitBacking)?waitBacking.clone():null,
				!zot(rollWaitBacking)?rollWaitBacking.clone():null,
				!zot(waitIcon)?waitIcon.clone():null,
				!zot(rollWaitIcon)?rollWaitIcon.clone():null,
				align, valign, indent, indentHorizontal, indentVertical,
				style,
				this.group
			);
			return that.cloneProps(but);
		}
	}
	zim.extend(zim.Button, zim.Container, "clone", "zimContainer", false);
	//-55

/*--
zim.CheckBox = function(size, label, startChecked, color, backgroundColor, borderColor, borderWidth, corner, margin, indicatorType, indicatorColor, tap, style, group, inherit)

CheckBox
zim class - extends a zim.Container which extends a createjs.Container

DESCRIPTION
A checkbox that when pressed toggles the check and a checked property.

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var checkBox = new CheckBox(50, "TEST");
checkBox.center(stage);
checkBox.on("change", function() {
	zog(checkBox.checked); // will be true then false, etc.
});
END EXAMPLE

PARAMETERS
** supports DUO - parameters or single object with properties below
** supports OCT - parameter defaults can be set with STYLE control (like CSS)
size - (default 60) size in pixels (always square)
label - (default null) ZIM Label object - or String to make a default label (black)
startChecked - (default false) an initial parameter to set checked if true
color - (default "#111") the text color of the label
backgroundColor - (default "rgba(255,255,255,.8)") the background color of the box
borderColor - (default "#111") the color of the border
borderWidth - (default size/10) thickness of the border
corner - (default 0) the round of the corner
   can also be an array of [topLeft, topRight, bottomRight, bottomLeft]
margin - (default 10) is on outside of box so clicking or pressing is easier
indicatorType - (default check) could be square (box) or x
indicatorColor - (default borderColor or black if no border) the color of the indicator
tap - (default false) set to true to tap to activate CheckBox rather than mousedown or click
style - (default true) set to false to ignore styles set with the STYLE - will receive original parameter defaults
group - (default null) set to String (or comma delimited String) so STYLE can set default styles to the group(s) (like a CSS class)
inherit - (default null) used internally but can receive an {} of styles directly

METHODS
setChecked(Boolean) - defaults to true to set button checked (or use checked property)
hasProp(property as String) - returns true if property exists on object else returns false
clone() - makes a copy with properties such as x, y, etc. also copied
dispose() - removes from parent, removes event listeners - must still set outside references to null for garbage collection

ALSO: ZIM 4TH adds all the methods listed under Container (see above), such as:
drag(), hitTestRect(), animate(), sca(), reg(), mov(), center(), centerReg(),
addTo(), removeFrom(), loop(), outline(), place(), pos(), alp(), rot(), setMask(), etc.
ALSO: See the CreateJS Easel Docs for Container methods, such as:
on(), off(), getBounds(), setBounds(), cache(), uncache(), updateCache(), dispatchEvent(),
addChild(), removeChild(), addChildAt(), getChildAt(), contains(), removeAllChildren(), etc.

PROPERTIES
type - holds the class name as a String
checked - gets or sets the check of the box
** setting widths and heights adjusts scale not bounds and getting these uses the bounds dimension times the scale
width - gets or sets the width. Setting the width will scale the height to keep proportion (see widthOnly below)
height - gets or sets the height. Setting the height will scale the width to keep proportion (see heightOnly below)
widthOnly - gets or sets the width.  This sets only the width and may change the aspect ratio of the object
heightOnly - gets or sets the height.  This sets only the height and may change the aspect ratio of the object
label - gives access to the label
text - the text of the label
background - the Rectangle of the checkBox
indicator - gives access to the check mark ie. indicator.sca(.8);
indicatorColor - get or set the color of the indicator
enabled - default is true - set to false to disable
blendMode - how the object blends with what is underneath - such as "difference", "multiply", etc. same as CreateJS compositeOperation
group - used when the object is made to add STYLE with the group selector (like a CSS class)

ALSO: See the CreateJS Easel Docs for Container properties, such as:
x, y, rotation, scaleX, scaleY, regX, regY, skewX, skewY,
alpha, cursor, shadow, mouseChildren, mouseEnabled, parent, numChildren, etc.

OPTIMIZED
This component is affected by the general OPTIMIZE setting (default is false)
if set to true, you will have to stage.update() after setting certain properties

ACTIONEVENT
This component is affected by the general ACTIONEVENT setting
The default is "mousedown" - if set to something else the component will act on click (press)

EVENTS
dispatches a "change" event when pressed on but not when the checked property is set

ALSO: See the CreateJS Easel Docs for Container events, such as:
added, click, dblclick, mousedown, mouseout, mouseover, pressmove, pressup, removed, rollout, rollover
--*///+56
	zim.CheckBox = function(size, label, startChecked, color, backgroundColor, borderColor, borderWidth, corner, margin, indicatorType, indicatorColor, tap, style, group, inherit) {
		var sig = "size, label, startChecked, color, backgroundColor, borderColor, borderWidth, corner, margin, indicatorType, indicatorColor, tap, style, group, inherit";
		var duo; if (duo = zob(zim.CheckBox, arguments, sig, this)) return duo;
		z_d("56");
		this.zimContainer_constructor(null,null,null,null,false);
		this.type = "CheckBox";
		this.group = group;
		var DS = style===false?{}:zim.getStyle(this.type, this.group, inherit);

		if (zot(size)) size = DS.size!=null?DS.size:60;
		if (zot(label)) label = DS.label!=null?DS.label:null;
		if (zot(startChecked)) startChecked = DS.startChecked!=null?DS.startChecked:false;
		var myChecked = startChecked;
		if (zot(color)) color = DS.color!=null?DS.color:"#111";
		if (zot(backgroundColor)) backgroundColor = DS.backgroundColor!=null?DS.backgroundColor:"rgba(255,255,255,.8)";
		if (zot(borderColor)) borderColor = DS.borderColor!=null?DS.borderColor:"#111";
		if (zot(borderWidth)) borderWidth = DS.borderWidth!=null?DS.borderWidth:size/10;
		if (borderColor < 0 || borderWidth < 0) borderColor = borderWidth = null;
		else if (borderColor!=null && borderWidth==null) borderWidth = size/10;
		if (zot(corner)) corner=DS.corner!=null?DS.corner:0;
		if (typeof label === "string" || typeof label === "number") label = new zim.Label({
			text:label, size:size*5/6, color:color, valign:"center",
			backing:"ignore", shadowColor:"ignore", shadowBlur:"ignore", padding:"ignore", backgroundColor:"ignore",
			group:this.group
		});
		if (zot(margin)) margin = DS.margin!=null?DS.margin:size/5;
		if (indicatorType != "box" && indicatorType != "square" && indicatorType != "x") indicatorType = DS.indicatorType!=null?DS.indicatorType:"check";
		if (zot(indicatorColor)) indicatorColor = DS.indicatorColor!=null?DS.indicatorColor:borderWidth>0?borderColor:"black";
		this.setBounds(-margin, -margin, size+margin*2, size+margin*2);
		if (zot(tap)) tap = DS.tap!=null?DS.tap:false;


		var that = this;
		this.cursor = "pointer";

		var box = new zim.Rectangle(size, size, backgroundColor, null, null, corner);
		var box2 = new zim.Rectangle(size*5/7, size*5/7,"rgba(0,0,0,0)", borderColor, borderWidth, corner);
		box2.x = size/7; box2.y = size/7;
		this.addChild(box, box2);

		var fullWidth = size;

		if (label) {
			label.center(that);
			label.x = that.getBounds().width;
			this.label = label;
			this.setBounds(-margin, -margin, size+margin*3+label.getBounds().width, Math.max(size+margin*2, label.getBounds().height));
			fullWidth = label.x + label.width;
		}

		var backing = new zim.Shape({style:false});
		g = backing.graphics;
		g.f("rgba(0,0,0,.01)").r(
			this.getBounds().x,
			this.getBounds().y,
			fullWidth+(margin*2),
			this.getBounds().height
		);
		this.hitArea = backing;
		// hitArea will stop rollovers on labels but oh well

		var check = new zim.Shape({style:false});
		var g2 = check.graphics;
		if (indicatorType == "check") {
			g2.f(indicatorColor).p("AnQAdICBiaIEEDZIF8nfICfB4In/KPg"); // width about 90 reg in middle
		} else if (indicatorType == "box" || indicatorType == "square") {
			g2.f(indicatorColor).dr(-35,-35,70,70);
		} else { // x
			g2.f(indicatorColor).p("AmJEVIEUkTIkXkWIB4h5IEWEYIETkTIB4B3IkTESIEQERIh4B4IkRkRIkSEVg"); // width about 90 reg in middle
		}

		var cW = 95
		check.setBounds(-cW/2, -cW/2, cW, cW);
		var scale = size/(cW+66);

		check.scaleX = check.scaleY = scale;
		check.alpha = .9;
		check.x = size/2;
		check.y = size/2;

		if (myChecked) this.addChild(check);

		if (tap) {
			this.tap(toggleCheck);
		} else {
			this.on((!zns?ACTIONEVENT=="mousedown":zim.ACTIONEVENT=="mousedown")?"mousedown":"click", toggleCheck);
		}

		Object.defineProperty(that, 'checked', {
			get: function() {
				return myChecked;
			},
			set: function(value) {
				that.setChecked(value);
			}
		});

		this.toggle = function(type) {
			if (zot(type)) type = !myChecked;
			that.setChecked(type);
		}

		Object.defineProperty(that, 'toggled', {
			get: function() {
				return myChecked;
			},
			set: function(value) {
				that.setChecked(value);
			}
		});

		Object.defineProperty(that, 'text', {
			get: function() {
				if (label) return label.text;
			},
			set: function(value) {
				if (label) {
					label.text = value;
					if ((!zim.OPTIMIZE&&(zns||!OPTIMIZE)) && that.stage) that.stage.update();
				};
			}
		});

		Object.defineProperty(check, 'indicatorColor', {
			get: function() {
				return indicatorColor;
			},
			set: function(value) {
				if (myChecked) {that.removeChild(check);}
				check = new createjs.Shape();
				g2 = check.graphics;
				indicatorColor = value;
				g2.f(indicatorColor).p("AnQAdICBiaIEEDZIF8nfICfB4In/KPg");
				check.scaleX = check.scaleY = scale;
				check.alpha = .9;
				check.x = size/2;
				check.y = size/2;
				if (myChecked) that.addChild(check);
				if ((!zim.OPTIMIZE&&(zns||!OPTIMIZE)) && that.stage) that.stage.update();
			}
		});

		Object.defineProperty(that, 'indicator', {
			get: function() {
				return check;
			},
			set: function(value) {
				zog("ZIM CheckBox - check is read only");
			}
		});

		this._enabled = true;
		Object.defineProperty(that, 'enabled', {
			get: function() {
				return that._enabled;
			},
			set: function(value) {
				zenable(that, value);
			}
		});

		function toggleCheck(e) {
			myChecked = !myChecked;
			that.setChecked(myChecked);
			that.dispatchEvent("change");
		}

		this.setChecked = function(value) {
			if (zot(value)) value = true;
			myChecked = value;
			if (myChecked) {
				that.addChild(check);
			} else {
				that.removeChild(check);
			}
			if ((!zim.OPTIMIZE&&(zns||!OPTIMIZE)) && that.stage) that.stage.update();
			return that;
		}

		if (style!==false) zimStyleTransforms(this, DS);
		this.clone = function() {
			return that.cloneProps(new zim.CheckBox(size, label?label.clone():"", startChecked, color, backgroundColor, borderColor, borderWidth, corner, margin, indicatorType, indicatorColor, tap, style, this.group, inherit));
		}
	}
	zim.extend(zim.CheckBox, zim.Container, "clone", "zimContainer", false);
	//-56

/*--
zim.RadioButtons = function(size, buttons, vertical, color, backgroundColor, spacing, margin, always, indicatorColor, style, group, inherit)

RadioButtons
zim class - extends a zim.Container which extends a createjs.Container

DESCRIPTION
A radio button set that lets you pick from choices.
Radio buttons can display radio buttons vertically (default) or horizontally.

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var radioButtons = new RadioButtons(50, ["ONE", "TWO", "THREE"]);
radioButtons.center(stage);
radioButtons.on("change", function() {
	zog(radioButtons.text); // will be ONE, TWO or THREE
	zog(radioButtons.selectedIndex); // will be 0, 1, or 2
});
END EXAMPLE

PARAMETERS
** supports DUO - parameters or single object with properties below
** supports OCT - parameter defaults can be set with STYLE control (like CSS)
size - (default 60) in pixels
buttons - an array of button data objects as follows:
	[{label:ZIM Label or text, id:optional id, selected:optional Boolean}, {etc...}]
	or just a list of labels for default labels ["hi", "bye", "what!"]
vertical - (default true) displays radio buttons vertically - set to false to display horizontally
color - (default "#111") the text color of the label
backgroundColor - (default "rgba(255,255,255,.8)") the background color of the circle
borderColor - (default "#111") the color of the border
borderWidth - (default size/9) thickness of the border
spacing - (size*.2 for vertical and size for horizontal) the space between radio button objects
margin - (size/5) the space around the radio button itself
always - (default false) if set true, cannot click on selection to unselect it
indicatorColor - (default borderColor or black) the color of the indicator
style - (default true) set to false to ignore styles set with the STYLE - will receive original parameter defaults
group - (default null) set to String (or comma delimited String) so STYLE can set default styles to the group(s) (like a CSS class)
inherit - (default null) used internally but can receive an {} of styles directly

METHODS
setSelected(num) - sets the selected index (or use selectedIndex) -1 is default (none)
hasProp(property as String) - returns true if property exists on object else returns false
clone() - makes a copy with properties such as x, y, etc. also copied
dispose() - removes from parent, removes event listeners - must still set outside references to null for garbage collection

ALSO: ZIM 4TH adds all the methods listed under Container (see above), such as:
drag(), hitTestRect(), animate(), sca(), reg(), mov(), center(), centerReg(),
addTo(), removeFrom(), loop(), outline(), place(), pos(), alp(), rot(), setMask(), etc.
ALSO: See the CreateJS Easel Docs for Container methods, such as:
on(), off(), getBounds(), setBounds(), cache(), uncache(), updateCache(), dispatchEvent(),
addChild(), removeChild(), addChildAt(), getChildAt(), contains(), removeAllChildren(), etc.

PROPERTIES
type - holds the class name as a String
selected - gets the selected object - selected.label, selected.id, etc.
selectedIndex - gets or sets the selected index of the buttons
** setting widths and heights adjusts scale not bounds and getting these uses the bounds dimension times the scale
width - gets or sets the width. Setting the width will scale the height to keep proportion (see widthOnly below)
height - gets or sets the height. Setting the height will scale the width to keep proportion (see heightOnly below)
widthOnly - gets or sets the width.  This sets only the width and may change the aspect ratio of the object
heightOnly - gets or sets the height.  This sets only the height and may change the aspect ratio of the object
label - current selected label object
text - current selected label text
id - current selected id
buttons - an array of button Container objects holding the shape and label (note - different than buttons parameter)
labels - an array of the ZIM Label objects. labels[0].text = "YUM"; labels[2].y -= 10;
indicators - an array of the zim Shape dot objects. indicators[0].color = "yellow";
enabled - default is true - set to false to disable
blendMode - how the object blends with what is underneath - such as "difference", "multiply", etc. same as CreateJS compositeOperation
group - used when the object is made to add STYLE with the group selector (like a CSS class)

ALSO: See the CreateJS Easel Docs for Container properties, such as:
x, y, rotation, scaleX, scaleY, regX, regY, skewX, skewY,
alpha, cursor, shadow, mouseChildren, mouseEnabled, parent, numChildren, etc.

OPTIMIZED
This component is affected by the general OPTIMIZE setting (default is false)
if set to true, you will have to stage.update() after setting certain properties
and stage.update() in change event to see component change its graphics

ACTIONEVENT
This component is affected by the general ACTIONEVENT setting
The default is "mousedown" - if set to something else the component will act on click (press)

EVENTS
dispatches a "change" event when pressed but not when selectedIndex is set
then ask for the properties above for info

ALSO: See the CreateJS Easel Docs for Container events, such as:
added, click, dblclick, mousedown, mouseout, mouseover, pressmove, pressup, removed, rollout, rollover
--*///+57
	zim.RadioButtons = function(size, buttons, vertical, color, backgroundColor, borderColor, borderWidth, spacing, margin, always, indicatorColor, style, group, inherit) {
		var sig = "size, buttons, vertical, color, backgroundColor, borderColor, borderWidth, spacing, margin, always, indicatorColor, style, group, inherit";
		var duo; if (duo = zob(zim.RadioButtons, arguments, sig, this)) return duo;
		z_d("57");
		this.zimContainer_constructor(null,null,null,null,false);
		this.type = "RadioButtons";
		this.group = group;
		var DS = style===false?{}:zim.getStyle(this.type, this.group, inherit);

		if (zot(size)) size = DS.size!=null?DS.size:60;
		size = Math.max(5, size);
		if (zot(buttons)) buttons = DS.buttons!=null?DS.buttons:["A", "B", "C"];
		if (zot(vertical)) vertical = DS.vertical!=null?DS.vertical:true;
		if (zot(color)) color = DS.color!=null?DS.color:"#111";
		if (zot(backgroundColor)) backgroundColor = DS.backgroundColor!=null?DS.backgroundColor:"rgba(255,255,255,.8)";
		if (zot(borderColor)) borderColor = DS.borderColor!=null?DS.borderColor:"#111";
		if (zot(borderWidth)) borderWidth = DS.borderWidth!=null?DS.borderWidth:size/9;
		if (borderColor < 0 || borderWidth < 0) borderColor = borderWidth = null;
		else if (borderColor!=null && borderWidth==null) borderWidth = size/10;
		if (zot(spacing)) spacing = (vertical) ? DS.spacing!=null?DS.spacing:size*.2 : DS.spacing!=null?DS.spacing:size;
		if (zot(margin)) margin =  DS.margin!=null?DS.margin:size/5;
		if (zot(indicatorColor)) indicatorColor =  DS.indicatorColor!=null?DS.indicatorColor:borderWidth>0?borderColor:"black";;

		var that = this;
		this.cursor = "pointer";
		this.labels = [];
		this.indicators = [];
		var currentObject; // reference to the current data object
		if (typeof buttons == "string") {
			// convert to buttons object literal (for cloning)
			var bString = buttons;
			buttons = [];
			for (var i=0; i<bString.length; i++) {
				buttons.push({label:bString[i]});
			}
		}

		var buttonContainer = new zim.Container({style:false});
		this.addChild(buttonContainer);

		function pressBut(e) {
			var index = buttonContainer.getChildIndex(e.target);
			if (always) {if (that.selectedIndex == index) return;}
			that.setSelected(index);
			that.dispatchEvent("change");
		}

		// loop through data and call makeButton() each time
		makeButtons();

		var currentK;
		for (var k=0; k<buttonContainer.numChildren; k++) {
			currentK = buttonContainer.getChildAt(k);
			currentK.on((!zns?ACTIONEVENT=="mousedown":zim.ACTIONEVENT=="mousedown")?"mousedown":"click", pressBut);
		}

		var lastBut;
		function makeButtons() {
			// test for duplicate selected true properties (leave last selected)
			var data; var selectedCheck = false;
			for (var i=buttons.length-1; i>=0; i--) {
				data = buttons[i];
				if (data.selected && data.selected === true) {
					if (!selectedCheck) {
						selectedCheck = true; // first item marked selected
						that.id = data.id;
					} else {
						data.selected = "false"; // turn off selected
					}
				}
			}
			buttonContainer.removeAllChildren();
			that.buttons = [];
			var but; var currentLocation = 0;
			for (var i=0; i<buttons.length; i++) {
				data = buttons[i];

				if (typeof data === "string" || typeof data === "number") {
					var d = {selected:false, label:new zim.Label({
						text:data, size:size*5/6, color:DS.color!=null?DS.color:color, valign:"center",
						backing:"ignore", shadowColor:"ignore", shadowBlur:"ignore", padding:"ignore", backgroundColor:"ignore",
						group:that.group
					})};
					data = d;
				}
				if (data.label && typeof data.label === "string" || typeof data.label === "number") {
					data.label = new zim.Label({text:data.label, size:DS.size!=null?DS.size:size*5/6, color:DS.color!=null?DS.color:color, valign:"center"});
				}
				that.labels.push(data.label);
				data.index = i;
				buttons[i] = data; // for cloning
				but = makeButton(data.selected, data.label);
				but.type = "RadioButton"; // singular
				but.obj = data;
				if (data.selected) currentObject = but.obj;

				buttonContainer.addChild(but);

				if (vertical) {
					but.y = currentLocation;
					currentLocation += but.getBounds().height + spacing;
				} else {
					but.x = currentLocation;
					currentLocation += but.getBounds().width + spacing;
				}
			}
		}

		// making a single button - similar to CheckBox class
		function makeButton(mySelected, label) {
			var but = new zim.Container({style:false});
			that.buttons.push(but);
			but.mouseChildren = false;
			but.setBounds(-margin, -margin, size+margin*2, size+margin*2);

			var box = new zim.Shape({style:false});
			var g = box.graphics;
			g.f(backgroundColor).dc(size/2,size/2,size/1.85);
			g.s(borderColor).ss(borderWidth).dc(size/2, size/2, size/2-size/2/5);
			but.addChild(box);

			var check = but.check = new zim.Circle(size/5.2, indicatorColor, null, null, null, null, null, false);
			that.indicators.push(check);
			check.mouseEnabled = false;
			check.alpha = .95;
			check.regX = check.regY = -size/2;

			var fullWidth = size;

			if (label) {
				but.addChild(label);
				label.x = but.getBounds().width;
				label.y = size/2;
				but.setBounds(-margin, -margin, size+margin*2+label.getBounds().width, Math.max(size+margin*2, label.getBounds().height));
				fullWidth = label.x + label.width;
				but.text = label.text;
			}
			if (mySelected) {
				but.addChild(check);
				that.label = label;
				if (that.label) that.text = label.text;
			}

			var backing = new zim.Shape({style:false});
			g = backing.graphics;
			g.f("rgba(0,0,0,.01)").r(
				but.getBounds().x,
				but.getBounds().y,
				fullWidth+(margin*2),
				but.getBounds().height
			);
			but.hitArea = backing;
			// hitArea will stop rollovers on labels but oh well

			return(but);
		}
		if (!this.getBounds()) this.setBounds(0,0,size,size);
		this.setBounds(-margin,-margin,this.getBounds().width+margin*2,this.getBounds().height);

		// the main function that sets a button selected (after the initial makeButton)
		// this gets called by the setter methods below and the click event up top
		this.setSelected = function(value) {
			if (zot(value)) value = -1;
			if (value != -1 && !buttonContainer.getChildAt(value)) return;
			var but;
			for (var i=0; i<buttonContainer.numChildren; i++) {
				but = buttonContainer.getChildAt(i);
				but.removeChild(but.check);
			}
			if (value >= 0) {
				but = buttonContainer.getChildAt(value);
				var lastIndex = -2;
				if (currentObject) lastIndex = currentObject.index;
				currentObject = but.obj;
			}
			if (value == -1 || lastIndex == currentObject.index) {
				currentObject = null;
				that.id = null;
				that.label = null;
				that.text = "";
			} else {
				but.addChild(but.check);
				that.id = currentObject.id;
				that.label = currentObject.label;
				if (that.label) that.text = that.label.text;
			}
			if ((!zim.OPTIMIZE&&(zns||!OPTIMIZE)) && that.stage) that.stage.update();
			return that;
		}

		// getter setter methods

		Object.defineProperty(that, 'selected', {
			get: function() {
				return currentObject;
			},
			set: function(value) {
				zog("ZIM RadioButton - selected is read only");
			}
		});

		Object.defineProperty(that, 'selectedIndex', {
			get: function() {
				return (currentObject) ? currentObject.index : -1;
			},
			set: function(value) {
				var index = value;
				if (always) {if (that.selectedIndex == index) return;}
				that.setSelected(index);
			}
		});

		this._enabled = true;
		Object.defineProperty(that, 'enabled', {
			get: function() {
				return that._enabled;
			},
			set: function(value) {
				zenable(that, value);
			}
		});

		zimStyleTransforms(this, DS)
		this.clone = function() {
			var buttonsCopy = zim.copy(buttons);
			for (var i=0; i<buttonsCopy.length; i++) {
				buttonsCopy[i].label = buttonsCopy[i].label.clone();
			}
			return that.cloneProps(new zim.RadioButtons(size, buttonsCopy, vertical, color, backgroundColor, borderColor, borderWidth, spacing, margin, always, indicatorColor, style, this.group, inherit));
		}
	}
	zim.extend(zim.RadioButtons, zim.Container, "clone", "zimContainer", false);
	//-57

/*--
zim.Toggle = function(width, height, label, startToggled, backgroundColor, margin, indicatorType, indicatorColor, tap, toggleBackgroundColor, color, borderColor, borderWidth, corner, indicatorCorner, shadowColor, shadowBlur, time, labelLeft, style, group, inherit)

Toggle
zim class - extends a zim.Container which extends a createjs.Container

DESCRIPTION
A Toggle button that toggles off and on - with optional labels
Thanks Andi Erni for the initial design and coding of the Toggle.
See: https://zimjs.com/explore/toggle.html

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
new Toggle({label:"ON"}).center().change(function (e) {
	zog(e.target.toggled)
});
END EXAMPLE

PARAMETERS
** supports DUO - parameters or single object with properties below
** supports OCT - parameter defaults can be set with STYLE control (like CSS)
width - (default 80) the width of the toggle (less labels)
height - (default 50) the height of the toggle
label - (default null) an optional ZIM Label (or text for default label properties)
	also see labelLeft for left side text
startToggled - (default false) set to true to start in the toggled position
backgroundColor - (default "#C60") dark orange - set to any HTML color for background color
margin - (default 10) the distance around and between the toggle and its parts
indicatorType - (default "circle" or "round") set to "rectangle" or "square" for square indicator
indicatorColor - (default "#111")
toggleBackgroundColor - (default "#F93") orange - for toggled background color
	try setting the borderColor to the same color as the background for inner color change effect
color - (default "#111") the font color of the toggle
borderColor - (default null) the color of the border
borderWidth - (default null - or 1 if borderColor) the size of the border
corner - (default half the height) a corner radius - or an array of corners [topLeft, topRight, bottomRight, bottomLeft]
indicatorCorner - (default 0) change the corner radius of a rectangle toggleType - or an array of corners [topLeft, topRight, bottomRight, bottomLeft]
shadowColor - (default "rgba(0,0,0,.3)" if shadowBlur) the shadow color - set to -1 for no shadow
shadowBlur - (default 14 if shadowColor) the shadow blur - set to -1 for no shadow
time - (default 200) time in milliseconds (ms) for toggle to animate
labelLeft - (default null) an optional ZIM Label for the left side of the toggle (or text for default label properties)
style - (default true) set to false to ignore styles set with the STYLE - will receive original parameter defaults
group - (default null) set to String (or comma delimited String) so STYLE can set default styles to the group(s) (like a CSS class)
inherit - (default null) used internally but can receive an {} of styles directly

METHODS
toggle(state) - toggle the toggle - state defaults to true - set to false to un-toggle
hasProp(property as String) - returns true if property exists on object else returns false
clone() - makes a copy with properties such as x, y, etc. also copied
dispose() - removes from parent, removes event listeners - must still set outside references to null for garbage collection

ALSO: ZIM 4TH adds all the methods listed under Container (see above), such as:
drag(), hitTestRect(), animate(), sca(), reg(), mov(), center(), centerReg(),
addTo(), removeFrom(), loop(), outline(), place(), pos(), alp(), rot(), setMask(), etc.
ALSO: See the CreateJS Easel Docs for Container methods, such as:
on(), off(), getBounds(), setBounds(), cache(), uncache(), updateCache(), dispatchEvent(),
addChild(), removeChild(), addChildAt(), getChildAt(), contains(), removeAllChildren(), etc.

PROPERTIES
type - holds the class name as a String
toggled - gets the toggled state of the toggle - same as selected
text - gets the selected label text or "on" / "off" if no label
indicator - access to the indicator object
background - access to background Rectangle
label - access to the label if provided
labelLeft - access to the label on the left if provided
** setting widths and heights adjusts scale not bounds and getting these uses the bounds dimension times the scale
width - gets or sets the width. Setting the width will scale the height to keep proportion (see widthOnly below)
height - gets or sets the height. Setting the height will scale the width to keep proportion (see heightOnly below)
widthOnly - gets or sets the width.  This sets only the width and may change the aspect ratio of the object
heightOnly - gets or sets the height.  This sets only the height and may change the aspect ratio of the object
enabled - default is true - set to false to disable
blendMode - how the object blends with what is underneath - such as "difference", "multiply", etc. same as CreateJS compositeOperation
group - used when the object is made to add STYLE with the group selector (like a CSS class)

ALSO: See the CreateJS Easel Docs for Container properties, such as:
x, y, rotation, scaleX, scaleY, regX, regY, skewX, skewY,
alpha, cursor, shadow, mouseChildren, mouseEnabled, parent, numChildren, etc.

EVENTS
dispatches a "change" event when pressed but not when toggle() is used

ALSO: See the CreateJS Easel Docs for Container events, such as:
added, click, dblclick, mousedown, mouseout, mouseover, pressmove, pressup, removed, rollout, rollover
--*///+57.5
	zim.Toggle = function(width, height, label, startToggled, backgroundColor, margin, indicatorType, indicatorColor, tap, toggleBackgroundColor, color, borderColor, borderWidth, corner, indicatorCorner, shadowColor, shadowBlur, time, labelLeft, style, group, inherit) {
        var sig = "width, height, label, startToggled, backgroundColor, margin, indicatorType, indicatorColor, tap, toggleBackgroundColor, color, borderColor, borderWidth, corner, indicatorCorner, shadowColor, shadowBlur, time, labelLeft, style, group, inherit";
        var duo; if (duo = zob(zim.Toggle, arguments, sig, this)) return duo;
		z_d("57.5");

		this.group = group;
		var DS = style===false?{}:zim.getStyle("Toggle", this.group, inherit);
		if (zot(width)) width=DS.width!=null?DS.width:80;
        if (zot(height)) height=DS.height!=null?DS.height:50;
        this.zimContainer_constructor(width, height, null, null, false);
        this.type = "Toggle";

        if (zot(backgroundColor)) backgroundColor=DS.backgroundColor!=null?DS.backgroundColor:"#C60";
        if (zot(margin)) margin = DS.margin!=null?DS.margin:10; //20;
        if (zot(indicatorType)) indicatorType=DS.indicatorType!=null?DS.indicatorType:"circle";
        if (zot(indicatorColor)) indicatorColor=DS.indicatorColor!=null?DS.indicatorColor:"#fff";
        if (zot(toggleBackgroundColor)) toggleBackgroundColor=DS.toggleBackgroundColor!=null?DS.toggleBackgroundColor:"#F93";
        if (zot(color)) color=DS.color!=null?DS.color:"#111";
        if (zot(borderColor)) borderColor = DS.borderColor!=null?DS.borderColor:null;
        if (zot(borderWidth)) borderWidth = DS.borderWidth!=null?DS.borderWidth:null;
        if (borderColor < 0 || borderWidth < 0) borderColor = borderWidth = null;
        else if (borderColor!=null && borderWidth==null) borderWidth = 1;
		if (zot(corner)) corner=DS.corner!=null?DS.corner:indicatorType!="circle"?0:25;
        if (zot(indicatorCorner)) indicatorCorner=DS.indicatorCorner!=null?DS.indicatorCorner:0;
        if (zot(shadowColor)) shadowColor=DS.shadowColor!=null?DS.shadowColor:"rgba(0,0,0,.3)";
        if (zot(shadowBlur)) shadowBlur=DS.shadowBlur!=null?DS.shadowBlur:14;
        if (zot(startToggled)) startToggled=DS.startToggled!=null?DS.startToggled:false;
        if (zot(time)) time=DS.time!=null?DS.time:100;

		var that = this;
        that.cursor = "pointer";

        if (typeof label === "string" || typeof label === "number") label = this.label = new zim.Label({
			text:label, size:height*5/6, color:color, valign:"center",
			backing:"ignore", shadowColor:"ignore", shadowBlur:"ignore", padding:"ignore", backgroundColor:"ignore",
			group:this.group
		});

        if (typeof labelLeft === "string" || typeof labelLeft === "number") labelLeft = this.labelLeft = new zim.Label({
			text:labelLeft, size:height*5/6, color:color, valign:"center",
			backing:"ignore", shadowColor:"ignore", shadowBlur:"ignore", padding:"ignore", backgroundColor:"ignore",
			group:this.group
		});

        this.background = new zim.Rectangle(width, height, backgroundColor, borderColor, borderWidth, corner).addTo(this);
        if (indicatorType=="rectangle" || indicatorType=="square") this.indicator = new zim.Rectangle(height*.65, height*.65, indicatorColor, null, null, indicatorCorner).center(this.background).pos(height*.2, null, startToggled);
        else this.indicator = new zim.Circle(height*.35, indicatorColor).center(this.background).pos(height*.175, null, startToggled);
        this.toggled = startToggled;
        that.background.color = that.toggled?toggleBackgroundColor:backgroundColor;

        if (shadowColor != -1 && shadowBlur > 0) {
            this.background.shadow = new createjs.Shadow(shadowColor, 3, 3, shadowBlur);
        }

        if (label) {
			this.addChild(label);
			label.x = width + 2 + margin + borderWidth;
			label.y = height/2;
			this.label = label;
			this.setBounds(-margin, -margin, width+margin*3+borderWidth+label.getBounds().width, Math.max(height+margin*2, label.getBounds().height));
		}

        if (labelLeft) {
			this.addChild(labelLeft);
			labelLeft.x = 0;
            that.background.x += labelLeft.width + 3 + margin + borderWidth;
            that.label.x += labelLeft.width + 3 + margin + borderWidth;
			labelLeft.y = height/2;
			this.labelLeft = labelLeft;
			this.setBounds(-margin, -margin, that.getBounds().width+labelLeft.width + 3 + margin + borderWidth, that.getBounds().height);
		}
		this.expand(zim.mobile()?20:10);

		this.tap(function (e) {
			if (labelLeft) {
				var point = that.localToGlobal(labelLeft.width+3+margin+borderWidth+width/2, 0);
				if ((e.stageX/that.stage.scaleX < (point.x-width/2) && !that.toggled) || (e.stageX/that.stage.scaleX >= (point.x+width/2) && that.toggled)) return;
			}
			that.toggled = !that.toggled;
	        setToggle();
			that.dispatchEvent("change");
		}, zim.mobile()?20:10);

		var swipe = new zim.Swipe(this);
		swipe.on("swipe", function (e) {
			if (e.swipeX==0) {
				return;
			} else if (e.swipeX==1 && that.toggled) {
				return;
			} else if (e.swipeX==-1 && !that.toggled) {
				return;
			}
			that.toggled = !that.toggled;
            setToggle();
			that.dispatchEvent("change");
		});

        function setToggle(immediate){
            var oldX = that.indicator.x;
			var t = time;
			if (immediate===true) t = 0;
            if (indicatorType=="rectangle" || indicatorType=="square") {
                that.indicator.pos(height*.2, null, that.toggled);
				if (time>0) that.indicator.animate({props:{x:oldX}, from:true, time:t});
            } else {
                that.indicator.pos(height*.175, null, that.toggled);
				if (time>0) that.indicator.animate({props:{x:oldX}, from:true, time:t});
			}
            that.background.color = that.toggled?toggleBackgroundColor:backgroundColor;

			that.text = that.toggled?(that.label?that.label.text:"on"):(that.labelLeft?that.labelLeft.text:"off");

			if (that.zimAccessibility) {
				var string = "Toggle set to " + (that.toggled?(that.label?that.label.text+".":"on."):(that.labelLeft?that.labelLeft.text+".":"off."));
				setTimeout(function() {that.zimAccessibility.talk(string);}, 50);
			}
        }

		Object.defineProperty(that, 'textLeft', {
			get: function() {
				if (labelLeft) return labelLeft.text;
			},
			set: function(value) {
				if (labelLeft) {
					labelLeft.text = value;
					if ((!zim.OPTIMIZE&&(zns||!OPTIMIZE)) && that.stage) that.stage.update();
				};
			}
		});


        that.toggle = function(state, immediate) {
            var lastToggle = that.toggled;
            if (zot(state)) state = true;
            that.toggled = state;
            if (lastToggle != that.toggled) setToggle(immediate);
            return that;
        }
		that.text = that.toggled?(that.label?that.label.text:"on"):(that.labelLeft?that.labelLeft.text:"off");

		this._enabled = true;
		Object.defineProperty(that, 'enabled', {
			get: function() {
				return that._enabled;
			},
			set: function(value) {
				zenable(that, value);
			}
		});

        if (style!==false) zimStyleTransforms(this, DS);;
		this.clone = function() {
        	return that.cloneProps(new zim.Toggle(width, height, label?label.clone():"", startToggled, backgroundColor, margin, indicatorType, indicatorColor, tap, toggleBackgroundColor, color, borderColor, borderWidth, corner, indicatorCorner, shadowColor, shadowBlur, time, labelLeft?labelLeft.clone():"", style, this.group, inherit));
		}
    }
	zim.extend(zim.Toggle, zim.Container, "clone", "zimContainer", false);
	//-57.5

/*--
zim.Tip = function(text, align, valign, margin, marginH, marginV, outside, target, size, font, color, rollColor, shadowColor, shadowBlur, textAlign, textValign, lineWidth, lineHeight, fontOptions, backing, outlineColor, outlineWidth, backgroundColor, backgroundBorderColor, backgroundBorderWidth, corner, backgroundDashed, padding, paddingHorizontal, paddingVertical, shiftHorizontal, shiftVertical, rollPersist, labelWidth, labelHeight, maxSize, style, group, inherit)

Tip
zim class - extends a a zim.Label which extends a zim.Container which extends a createjs.Container

DESCRIPTION
A Tip() can be used to show some extra information - the tip disapears after an amount of time
Tip has easy positioning along the inside edges or the outside edges of a target.

NOTE: Tip places the tip on the stage when the show() method is called
You can reposition with .mov() etc. if desired

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
new Tip("Press Circle").show(1000); // wait one second and show tip at 40 pixels from bottom right

var circle = new Circle().center().tap(function () {
	circleTip.show();
});
var circleTip = new Tip({
	text:"This is a default ZIM Circle",
	backgroundColor:white,
	color:black,
	outside:true, // outside the circle
	target:circle,
	align:"center",
	valign:"bottom",
	margin:14,
	corner:0,
	size:20
});
END EXAMPLE

PARAMETERS
** supports DUO - parameters or single object with properties below
** supports OCT - parameter defaults can be set with STYLE control (like CSS)
text - (default "Here's a tip!") String for the the text of the tip
align - (default "right") the horizontal position of the tip ("left", "center"/"middle", "right")
valign - (default "bottom") the vertical position of the tip ("top", "center"/"middle", "bottom")
margin - (default 40) distance from side (unless centered) in pixels
marginH - (default margin) distance from horizontal edges
marginV - (default margin) distance from vertical edges
outside - (default false) set to true to place Tip on outside of container
target - (default ZimDefaultFrame's stage) tip is placed on stage relative to container
** the rest are parameters for a Label (align and valign are set as textAlign and textValign)
size - (default 36) the size of the font in pixels
font - (default arial) the font or list of fonts for the text
color - (default "black") color of font (any CSS color)
rollColor - (default color) the rollover color of the font
shadowColor - (default "rgba(0,0,0,.3)") for no shadow - set to any css color to see
shadowBlur - (default 1) if shadow is present
textAlign - ((default "left") text registration point alignment also "center" and "right"
textValign - (default "center") vertical registration point alignment alse "middle / center", "bottom"
lineWidth - (default false) for no wrapping (use \n) Can set to number for wrap
lineHeight - (default getMeasuredLineHeight) set to number to adjust line height
fontOptions - (default null) css VALUES as a single string for font-style font-variant font-weight
   eg. "italic bold small-caps" or just "italic", etc.
backing - (default null) a Display object for the backing of the label (eg. Shape, Bitmap, Container, Sprite)
   see ZIM Pizzazz module for a fun set of Shapes like Boomerangs, Ovals, Lightning Bolts, etc.
outlineColor - (default null - or black if outlineWidth set) - the color of the outline of the text
outlineWidth - (default null - or (size*.2) if outlineColor set) - the thickness of the outline of the text
backgroundColor - (default null) set to CSS color to add a rectangular color around the label
   The background color will change size to match the text of the label
   Note: the backgroundColor is different than a backing which can be any Display Object
   and background parameters are ignored if a backing parameter is set
backgroundBorderColor - (default null) the background stroke color
backgroundBorderWidth - (default null) thickness of the background border
corner - (default 0) the round of corner of the background if there is one
   can also be an array of [topLeft, topRight, bottomRight, bottomLeft]
backgroundDashed - (default null) set to true for dashed background border (if backgroundBorderColor or backgroundBorderWidth set)
padding - (default 10 if backgroundColor set) places the border this amount from text (see paddingHorizontal and paddingVertical)
   padding parameters are ignored if there is no backgroundColor set (also ignored if a backing parameter is set)
paddingHorizontal - (default padding) places border out at top bottom
paddingVertical - (default padding) places border out at left and right
shiftHorizontal - (default 0) move the label (CreateJS Text) inside the Label container horizontally
shiftVertical - (default 0) move the label (CreateJS Text) inside the Label container vertically
rollPersist - (default false) set to true to maintain rollover stage as long as mousedown or press is activated (used by Buttons)
labelWidth - (default null) the same as the lineWidth - the text will wrap at the labelWidth (added to match labelHeight)
labelHeight - (default null) the height of the text - setting this will probably alter the font size - so the size parameter is overwritten
   for labelHeight to work, the labelWidth must also be set
   using labelWidth and labelHeight together allow you to fit as much text into specified width and height dimensions
maxSize - (default null) set to limit the font size when using labelWidth and labelHeight
style - (default true) set to false to ignore styles set with the STYLE - will receive original parameter defaults
group - (default null) set to String (or comma delimited String) so STYLE can set default styles to the group(s) (like a CSS class)
inherit - (default null) used internally but can receive an {} of styles directly

METHODS
show(delay, time) - show the tip - delay in ms defaults to 0 and time in ms defaults to 2000
hide() - hides tip - show() will also hide the tip automatically after the time provided
clear() - hides tip and removes the call to a delayed tip using a delay time in show()
hasProp(property as String) - returns true if property exists on object else returns false
clone() - makes a copy with properties such as x, y, etc. also copied
dispose() - removes from parent, removes event listeners - must still set outside references to null for garbage collection

ALSO: See all methods of a Label() such as setColorRange(), etc.
ALSO: ZIM 4TH adds all the methods listed under Container (see above), such as:
drag(), hitTestRect(), animate(), sca(), reg(), mov(), center(), centerReg(),
addTo(), removeFrom(), loop(), outline(), place(), pos(), alp(), rot(), setMask(), etc.
ALSO: See the CreateJS Easel Docs for Container methods, such as:
on(), off(), getBounds(), setBounds(), cache(), uncache(), updateCache(), dispatchEvent(),
addChild(), removeChild(), addChildAt(), getChildAt(), contains(), removeAllChildren(), etc.

PROPERTIES
align - get or set the horizontal alignment
valign - get or set the vertical alignment
text - get or set the text of the Tip
ALSO: See all properties of a Label() such as size, color, etc.
ALSO: See the CreateJS Easel Docs for Container properties, such as:
x, y, rotation, scaleX, scaleY, regX, regY, skewX, skewY,
alpha, cursor, shadow, mouseChildren, mouseEnabled, parent, numChildren, etc.

EVENTS
See the CreateJS Easel Docs for Container events, such as:
added, click, dblclick, mousedown, mouseout, mouseover, pressmove, pressup, removed, rollout, rollover
--*///+57.6
	zim.Tip = function(text, align, valign, margin, marginH, marginV, outside, target, size, font, color, rollColor, shadowColor, shadowBlur, textAlign, textValign, lineWidth, lineHeight, fontOptions, backing, outlineColor, outlineWidth, backgroundColor, backgroundBorderColor, backgroundBorderWidth, corner, backgroundDashed, padding, paddingHorizontal, paddingVertical, shiftHorizontal, shiftVertical, rollPersist, labelWidth, labelHeight, maxSize, style, group, inherit) {
        var sig = "text, align, valign, margin, marginH, marginV, outside, target, size, font, color, rollColor, shadowColor, shadowBlur, textAlign, textValign, lineWidth, lineHeight, fontOptions, backing, outlineColor, outlineWidth, backgroundColor, backgroundBorderColor, backgroundBorderWidth, corner, backgroundDashed, padding, paddingHorizontal, paddingVertical, shiftHorizontal, shiftVertical, rollPersist, labelWidth, labelHeight, maxSize, style, group, inherit";
        var duo; if (duo = zob(zim.Tip, arguments, sig, this)) return duo;
		z_d("57.6");

		this.group = group;
		var DS = style===false?{}:zim.getStyle("Tip", this.group, inherit);

		if (zot(text)) text = DS.text!=null?DS.text:"Here's a tip!";
		if (zot(margin)) margin = DS.margin!=null?DS.margin:40;
		if (zot(marginH)) marginH = DS.marginH!=null?DS.marginH:margin;
		if (zot(marginV)) marginV = DS.marginV!=null?DS.marginV:margin;
		if (zot(align)) align = DS.align!=null?DS.align:"right";
		if (zot(valign)) valign = DS.valign!=null?DS.valign:"bottom";
		if (zot(outside)) outside = DS.outside!=null?DS.outside:false;
        if (zot(backgroundColor)) backgroundColor = DS.backgroundColor!=null?DS.backgroundColor:blue;
        if (zot(color)) color = DS.color!=null?DS.color:white;
		if (zot(corner)) corner = DS.corner!=null?DS.corner:25;
		if (zot(corner)) corner = DS.corner!=null?DS.corner:25;
		if (zot(corner)) corner = DS.corner!=null?DS.corner:25;
		if (zot(paddingHorizontal)) paddingHorizontal = DS.paddingHorizontal!=null?DS.paddingHorizontal:14+(Array.isArray(corner)?corner[0]:corner);
		if (zot(shadowColor) || shadowColor=="ignore") shadowColor=(DS.shadowColor!=null&&shadowColor!="ignore")?DS.shadowColor:"rgba(0,0,0,.3)";
		if (zot(shadowBlur) || shadowBlur=="ignore") shadowBlur=(DS.shadowBlur!=null&&shadowBlur!="ignore")?DS.shadowBlur:1;

	    this.zimLabel_constructor(text, size, font, color, rollColor, null, null, textAlign, textValign, lineWidth, lineHeight, fontOptions, backing, outlineColor, outlineWidth, backgroundColor, backgroundBorderColor, backgroundBorderWidth, corner, backgroundDashed, padding, paddingHorizontal, paddingVertical, shiftHorizontal, shiftVertical, rollPersist, labelWidth, labelHeight, maxSize, style, group, DS);
        this.type = "Tip";

		if (outside) {
			marginH = -marginH;
			marginV = -marginV;
		}
        var that = this;

		that.align = align;
		that.valign = valign;

        this.background.sha(shadowColor, 3, 5, shadowBlur);
        this.show = function(delay, time) {
			if (zot(delay)) delay = DS.delay!=null?DS.delay:0;
			if (zot(time)) time = DS.time!=null?DS.time:2000;
			var mess = "zim Tip(): Please pass in a reference to a container with bounds set as parameter to Tip";
			if (zot(target)) {
				if (zimDefaultFrame) {
					target = zimDefaultFrame.stage;
				} else {
					zog(mess);
					return that;
				}
			} else if (!target.getBounds) {
				zog(mess);
				return that;
			} else if (zot(target.stage)) {
				zog("zim display - Waiter(): The container must have a stage property");
				return that;
			}

			if (delay > 0) {
				that.showID = zim.timeout(delay, doShow);
			} else {
				doShow();
			}

			function doShow() {

				if (target.boundsToGlobal) var b = target.boundsToGlobal();
				else var b = target.getBounds();
				var container = new Container(b.x, b.y, b.width, b.height);
				container.zimTemp = true;
				container.loc(0, 0, target.stage);

				if (that.align=="center" || that.align=="middle" || that.valign=="center" || that.valign=="middle") {
					that.center(container);
				}
	            that.pos((that.align=="center" || that.align=="middle")?null:marginH, (that.valign=="center" || that.valign=="middle")?null:marginV, (that.align=="right"), (that.valign=="bottom"), container);
				if (outside) {
					if (that.align=="right") that.x += that.width;
					else if (that.align=="left") that.x -= that.width;
					if (that.valign=="bottom") that.y += that.height;
					else if (that.valign=="top") that.y -= that.height;
				}

				that.addTo(container.stage); // will transfer over position...
				if (container.zimTemp && container.removeFrom) {container.removeFrom(); container = null;}
				container = that.stage;

				if (that.timeoutID) that.timeoutID.clear();
	            that.timeoutID = zim.timeout(time, function () {
	                that.hide();
	                container.stage.update();
	            });
	            if (that.upID) container.stage.off("stagemouseup", that.upID);
	            that.upID = container.stage.on("stagemouseup", function () {
					that.hide();
	                container.stage.update();
	            })
				container.stage.update();
			}
			return that;
        }
        this.hide = function() {
            this.removeFrom();
            if (this.timeoutID) this.timeoutID.clear();
            if (this.upID && target.stage) target.stage.off("stagemouseup", this.downID);
			return that;
        }
		this.clear = function() {
			if (that.showID) that.showID.clear();
			that.hide();
		}

        if (style!==false) zimStyleTransforms(this, DS);
		this.clone = function() {
        	return that.cloneProps(new zim.Tip(text, align, valign, margin, marginH, marginV, outside, target, size, font, color, rollColor, shadowColor, shadowBlur, textAlign, textValign, lineWidth, lineHeight, fontOptions, backing, outlineColor, outlineWidth, backgroundColor, backgroundBorderColor, backgroundBorderWidth, corner, backgroundDashed, padding, paddingHorizontal, paddingVertical, shiftHorizontal, shiftVertical, rollPersist, labelWidth, labelHeight, maxSize, style, this.group, inherit));
		}
    }
	zim.extend(zim.Tip, zim.Label, "clone", "zimLabel", false);
	//-57.6

/*--
zim.Panel = function(width, height, titleBar, titleBarColor, titleBarBackgroundColor, titleBarHeight, backgroundColor, borderColor, borderWidth, corner, arrow, align, shadowColor, shadowBlur, draggable, boundary, extraButton, style, group, inherit)

Panel
zim class - extends a zim.Container which extends a createjs.Container

DESCRIPTION
A simple panel with titleBar and optional arrow for more panels.
Panel can be set draggable but does not have a close button - try a Pane() or Window() for that
See: https://zimjs.com/explore/panel.html

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var panel = new Panel({titleBar:series("TODAY", "TOMORROW")})
	.center();

// make a couple pages for the panels

// content for panel 1
var today = new Container(panel.width, panel.height).addTo(panel);
var sun = new Circle(30, yellow).center(today);

// content for panel 2
var tomorrow = new Container(panel.width, panel.height); // do not add yet
var label = new Label("-30").center(tomorrow);

// event to change content as panels change
panel.on("change", function () {
	if (today.parent) {
		today.removeFrom();
		tomorrow.center(panel);
	} else {
		tomorrow.removeFrom();
		today.center(panel);
	}
});
END EXAMPLE

PARAMETERS
** supports DUO - parameters or single object with properties below
** supports VEE - parameters marked with ZIM VEE mean a zim Pick() object or Pick Literal can be passed
   Pick Literal formats: [1,3,2] - random; {min:10, max:20} - range; series(1,2,3) - order, function(){return result;} - function
** supports OCT - parameter defaults can be set with STYLE control (like CSS)
width - (default 250) the width of the panel
height - (default 300) the height of the panel
titleBar - |ZIM VEE| (default "PANEL") a String or ZIM Label title for the panel that will be presented on a titleBar across the top
titleBarColor - |ZIM VEE| (default "black") the text color of the titleBar if a titleBar is requested
titleBarBackgroundColor - |ZIM VEE| (default "rgba(0,0,0,.2)") the background color of the titleBar if a titleBar is requested
titleBarHeight - (default fit label) the height of the titleBar if a titleBar is requested
backgroundColor - |ZIM VEE| (default #eee) background color (use clear - or "rbga(0,0,0,0)" for no background)
borderColor - |ZIM VEE| (default #888) border color
borderWidth - (default 1) the thickness of the border
corner - (default 0) the round of corner
   can also be an array of [topLeft, topRight, bottomRight, bottomLeft]
arrow - (default true if more than one panel) set to false to not show an arrow if multiple panels
align - (default "left") set to "center", "middle" or "right" to align the label on the titleBar
shadowColor - (default "rgba(0,0,0,.3)" if shadowBlur) the shadow color - set to -1 for no shadow
shadowBlur - (default 14 if shadowColor) the shadow blur - set to -1 for no shadow
draggable - (default true if titleBar) set to false to not allow dragging titleBar to drag window
boundary - (default null) set to ZIM Boundary() object - or CreateJS.rectangle()
extraButton - (default null) creates a little square button with the letter R for reset
	this is made with the group style id of "extraButton"
	use the extraButton property to access the button to change its label or capture an event, etc.
style - (default true) set to false to ignore styles set with the STYLE - will receive original parameter defaults
group - (default null) set to String (or comma delimited String) so STYLE can set default styles to the group(s) (like a CSS class)
inherit - (default null) used internally but can receive an {} of styles directly

METHODS
nextPanel(index, event) - show next panel - the panels are set up to be a series or random or function based
	this means there is not necessarily an order to be able to go backwards to... so, only forward!
	If a series is provided to the Panel title, etc. then the index can be used to go to the title in the series at the index
	event (default false) will dispatch a change event if nextPanel is called
hasProp(property as String) - returns true if property exists on object else returns false
clone() - makes a copy with properties such as x, y, etc. also copied
dispose() - removes from parent, removes event listeners - must still set outside references to null for garbage collection

ALSO: ZIM 4TH adds all the methods listed under Container (see above), such as:
drag(), hitTestRect(), animate(), sca(), reg(), mov(), center(), centerReg(),
addTo(), removeFrom(), loop(), outline(), place(), pos(), alp(), rot(), setMask(), etc.
ALSO: See the CreateJS Easel Docs for Container methods, such as:
on(), off(), getBounds(), setBounds(), cache(), uncache(), updateCache(), dispatchEvent(),
addChild(), removeChild(), addChildAt(), getChildAt(), contains(), removeAllChildren(), etc.

PROPERTIES
type - holds the class name as a String
titleBar - access to the titleBar container
label - access to the label of the current panel
text - access to the text of the current panel
arrow - access to the next arrow
background - access to the background Rectangle
extraButton - access to the Label for the extra button if extraButton parameter is set to true
	use this to set the text in the button (a one letter button is expected - for instance, i for info, x for close, etc.)
overlay - access to the overlay Rectangle used if enabled = false
** setting widths and heights adjusts scale not bounds and getting these uses the bounds dimension times the scale
width - gets or sets the width. Setting the width will scale the height to keep proportion (see widthOnly below)
height - gets or sets the height. Setting the height will scale the width to keep proportion (see heightOnly below)
widthOnly - gets or sets the width.  This sets only the width and may change the aspect ratio of the object
heightOnly - gets or sets the height.  This sets only the height and may change the aspect ratio of the object
enabled - default is true - set to false to disable
blendMode - how the object blends with what is underneath - such as "difference", "multiply", etc. same as CreateJS compositeOperation
group - used when the object is made to add STYLE with the group selector (like a CSS class)

ALSO: See the CreateJS Easel Docs for Container properties, such as:
x, y, rotation, scaleX, scaleY, regX, regY, skewX, skewY,
alpha, cursor, shadow, mouseChildren, mouseEnabled, parent, numChildren, etc.

EVENTS
dispatches a "change" event when arrow is pressed to go to the next panel

ALSO: See the CreateJS Easel Docs for Container events, such as:
added, click, dblclick, mousedown, mouseout, mouseover, pressmove, pressup, removed, rollout, rollover
--*///+57.7
	zim.Panel = function(width, height, titleBar, titleBarColor, titleBarBackgroundColor, titleBarHeight, backgroundColor, borderColor, borderWidth, corner, arrow, align, shadowColor, shadowBlur, draggable, boundary, extraButton, style, group, inherit) {
        var sig = "width, height, titleBar, titleBarColor, titleBarBackgroundColor, titleBarHeight, backgroundColor, borderColor, borderWidth, corner, arrow, align, shadowColor, shadowBlur, draggable, boundary, extraButton, style, group, inherit";
        var duo; if (duo = zob(zim.Panel, arguments, sig, this)) return duo;
		z_d("57.7");

		this.group = group;
		var DS = style===false?{}:zim.getStyle("Panel", this.group, inherit);
		if (zot(width)) width=DS.width!=null?DS.width:250;
        if (zot(height)) height=DS.height!=null?DS.height:300;
        this.zimContainer_constructor(width, height, null, null, false);
        this.type = "Panel";

		if (zot(titleBar)) titleBar = DS.titleBar!=null?DS.titleBar:"PANEL";
		if (zot(titleBarColor)) titleBarColor = DS.titleBarColor!=null?DS.titleBarColor:"#fff";
		if (zot(titleBarBackgroundColor)) titleBarBackgroundColor = DS.titleBarBackgroundColor!=null?DS.titleBarBackgroundColor:"#555";
		if (zot(titleBarHeight)) titleBarHeight = DS.titleBarHeight!=null?DS.titleBarHeight:30;

        if (zot(backgroundColor)) backgroundColor=DS.backgroundColor!=null?DS.backgroundColor:"#eee";
        if (zot(borderColor)) borderColor = DS.borderColor!=null?DS.borderColor:"#888";
        if (zot(borderWidth)) borderWidth = DS.borderWidth!=null?DS.borderWidth:null;
        if (borderColor < 0 || borderWidth < 0) borderColor = borderWidth = null;
        else if (borderColor!=null && borderWidth==null) borderWidth = 1;
		if (zot(corner)) corner=DS.corner!=null?DS.corner:5;
		if (zot(align)) align=DS.align!=null?DS.align:"left";
		if (zot(shadowColor)) shadowColor=DS.shadowColor!=null?DS.shadowColor:"rgba(0,0,0,.3)";
		if (zot(shadowBlur)) shadowBlur=DS.shadowBlur!=null?DS.shadowBlur:14;
		if (zot(draggable)) draggable = DS.draggable!=null?DS.draggable:false;
		if (zot(boundary)) boundary = DS.boundary!=null?DS.boundary:null;
		if (zot(arrow)) arrow=DS.arrow!=null?DS.arrow:zim.vee(titleBar);
		if (!Array.isArray(corner)) corner = [corner,corner,corner,corner];

		var that = this;
		var background = this.background = new zim.Rectangle(width, height, backgroundColor, borderColor, borderWidth, corner).addTo(this);
		if (shadowColor != -1 && shadowBlur > 0) {
			this.background.shadow = new createjs.Shadow(shadowColor, 3, 3, shadowBlur);
		}
		var titleBarValue = titleBar; // as we assign the container to titleBar later
		var t = zim.Pick.choose(titleBarValue);
		var tBarColor = zim.Pick.choose(titleBarColor);
		var tBarBackgroundColor = zim.Pick.choose(titleBarBackgroundColor);
		var pBackgroundColor = zim.Pick.choose(backgroundColor);
		var pBorderColor = zim.Pick.choose(borderColor);

		if (typeof t == "string") t = new zim.Label({
			text:t, color:tBarColor, size:DS.size!=null?DS.size:20,
			backing:"ignore", shadowColor:"ignore", shadowBlur:"ignore", padding:"ignore", backgroundColor:"ignore",
			group:this.group
		});
		var titleBarLabel = that.titleBarLabel = t;
		if (zot(tBarBackgroundColor)) tBarBackgroundColor = "rgba(0,0,0,.2)";
		that.titleBar = titleBar = new zim.Container(width, titleBarHeight, null, null, false).loc(0,0,that);
		var titleBarRect = that.titleBar.backing = new zim.Rectangle(width+borderWidth, titleBarHeight, tBarBackgroundColor, null, null, [corner[0]*.95, corner[1]*.95, 0, 0], true, null, false).center(titleBar);
		positionBar();
		that.label = t;
		that.text = t.text;

		this.nextPanel = function(index, event) {
			var t = zot(index)||zot(titleBarValue.array)?zim.Pick.choose(titleBarValue):titleBarValue.array[index];
			var tBarColor = zot(index)||zot(titleBarColor.array)?zim.Pick.choose(titleBarColor):titleBarColor.array[index];
			var tBarBackgroundColor = zot(index)||zot(titleBarBackgroundColor.array)?zim.Pick.choose(titleBarBackgroundColor):titleBarBackgroundColor.array[index];
			var pBackgroundColor = zot(index)||zot(backgroundColor.array)?zim.Pick.choose(backgroundColor):backgroundColor.array[index];
			var pBorderColor = zot(index)||zot(borderColor.array)?zim.Pick.choose(borderColor):borderColor.array[index];
			if (typeof t == "string") t = new zim.Label({
				text:t, color:tBarColor, size:DS.size!=null?DS.size:20,
				backing:"ignore", shadowColor:"ignore", shadowBlur:"ignore", padding:"ignore", backgroundColor:"ignore",
				group:this.group
			});
			that.label = t;
			that.text = t.text;
			titleBarLabel.removeFrom();
			titleBarLabel = that.titleBarLabel = t;
			positionBar();
			titleBarRect.color = tBarBackgroundColor;
			that.background.color = pBackgroundColor;
			that.background.borderColor = pBorderColor;
			if (event) that.dispatchEvent("change");
			if (!OPTIMIZE && that.stage) that.stage.update();
		}

		function positionBar() {
			if (align=="right") titleBarLabel.center(titleBar).pos(Math.max(corner[0]/2, 10), null, true);
			else if (align=="center" || align=="middle") titleBarLabel.center(titleBar);
			else titleBarLabel.center(titleBar).loc(Math.max(corner[0]/2, 10));
		}

		if (draggable) {
			titleBar.cursor = "pointer";
			titleBar.on("mousedown", function() {
				that.drag({rect:boundary, currentTarget:true});
			});
			titleBar.on("pressup", function() {
				that.noDrag();
			});
		}

		if (arrow > 0) {
			var next = that.arrow = new zim.Shape(-20,-20,40,40,null,false);
			next.graphics.f(titleBarColor).p("AiJieIETCeIkTCfg"); // width about 90 reg in middle
			next.centerReg(titleBar).scaleTo(titleBar, null, 70).alp(.8).hov(1).expand();
			if (align=="right") next.pos(Math.max(corner[1]/2, 10));
			else next.pos(Math.max(corner[1]/2, 10), null, true);
			next.cursor = "pointer";
			next.on((!zns?ACTIONEVENT=="mousedown":zim.ACTIONEVENT=="mousedown")?"mousedown":"click", function(){
				that.nextPanel();
				that.dispatchEvent("change");
			});
		}

		if (!zot(extraButton)) {
			var extraButton = that.extraButton = new zim.Button({
				label:"R",
				width:50,
				height:50,
				group:"PanelExtra"
			}).scaleTo(titleBar, null, 70).centerReg(titleBar).expand();
			if (align=="left") {
				extraButton.pos(arrow>0?next.x-next.width-15:Math.max(corner[1]/2, 10) );
			} else {
				extraButton.pos((arrow>0&&align!="center")?next.x+next.width: Math.max(corner[1]/2, 10));
			}
		}

		var overlay = that.overlay = new zim.Rectangle(width, height).alp(.7);

		this._enabled = true;
		Object.defineProperty(that, 'enabled', {
			get: function() {
				return that._enabled;
			},
			set: function(value) {
				zenable(that, value);
				if (!value) that.overlay.addTo(that);
				else that.overlay.removeFrom();
				if (!OPTIMIZE && that.stage) that.stage.update();
			}
		});

        if (style!==false) zimStyleTransforms(this, DS);
		this.clone = function() {
        	return that.cloneProps(new zim.Toggle(width, height, titleBar?titleBar.clone():"", titleBarColor, titleBarBackgroundColor, titleBarHeight, backgroundColor, borderColor, borderWidth, corner, arrow, align, shadowColor, shadowBlur, draggable, boundary, extraButton, style, this.group, inherit));
		}
    }
	zim.extend(zim.Panel, zim.Container, "clone", "zimContainer", false);
	//-57.7

/*--
zim.Pane = function(width, height, label, backgroundColor, color, draggable, resets, modal, corner, backdropColor, shadowColor, shadowBlur, center, displayClose, backdropClose, backing, fadeTime, container, titleBar, titleBarColor, titleBarBackgroundColor, titleBarHeight, close, closeColor, style, group, inherit)

Pane
zim class - extends a zim.Container which extends a createjs.Container

DESCRIPTION
Adds a window for alerts, etc.
You need to call the pane.show() to show the pane and pane.hide() to hide it.
You do not need to add it to the stage - it adds itself centered.
You can change the x and y (the origin and registration point are in the middle).

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var pane = new Pane(300, 200, "Watch out!", "#CCC");
pane.show(); // pressing anywhere will close pane (see parameters for options)
END EXAMPLE

EXAMPLE
var pane = new Pane({width:600, height:250, modal:false, displayClose:false});
var cancel = new Button(220, 100, "CANCEL", "red").center(pane).mov(-130);
var confirm = new Button(220, 100, "CONFIRM", "green").center(pane).mov(130);
cancel.on("click", function() {pane.hide();});
confirm.on("click", function() {zgo("http://zimjs.com")});
pane.show(); // pressing anywhere will close pane (see parameters for options)

// custom backing with ZIM Pizzazz 3
// up top link to https://d309knd7es5f10.cloudfront.net/pizzazz_03.js
new Pane({
	label:new Label({color:white, text:"STOP", size:50}),
	backing:pizzazz.makePattern({
		type:"stripes",
		colors:series([red,black]),
		rows:20
	}).alp(.8)
}).show();
END EXAMPLE

PARAMETERS
** supports DUO - parameters or single object with properties below
** supports OCT - parameter defaults can be set with STYLE control (like CSS)
width - (default 200) width of pane
height - (default 200) height of pane
label - (default null) an optional ZIM Label (or text for default label properties)
backgroundColor - (default "white") a css color for the background of the Pane
color - (default "black") a css color for the text color of the Pane
draggable - (default false) pass in true to drag the pane
resets - (default true) resets position to start on re-open - set to false to keep last position
modal - (default true) pane will close when user clicks off the pane - set to false to keep pane open
corner - (default 20) is the corner radius - set to 0 for no corner
	can also be an array of [topLeft, topRight, bottomRight, bottomLeft]
backdropColor - (default rgba(0,0,0,.2)) the color of the background that fills the stage
shadowColor - (default rgba(0,0,0,.3)) set to -1 for no shadow
shadowBlur - (default 20) how blurred the shadow is if shadow is set
center - (default true) centers the pane
	if center is false you will have to set x and y for the pane
	the registration point and the origin inside the pane is in the center
	you can adjust the label placement by changing its x and y or registration point
displayClose - (default true) closes the Pane if display backing is pressed
	if draggable is set to true, displayClose will automatically be set to false
backdropClose - (default true) closes the Pane if backdrop is pressed
backing - (default null) a Display object for the backing of the pane (eg. Shape, Bitmap, Container, Sprite)
	see ZIM Pizzazz module for a fun set of Shapes like Boomerangs, Ovals, Lightning Bolts, etc.
	as well as patterned backings using Pizzazz 3
fadeTime - (default 0) milliseconds to fade in and out
container - (default - the default stage) container for the pane
titleBar - (default null - no titleBar) a String or ZIM Label title for the pane that will be presented on a titleBar across the top
titleBarColor - (default "black") the color of the titleBar text if a titleBar is requested
titleBarBackgroundColor - (default "rgba(0,0,0,.2)") the background color of the titleBar if a titleBar is requested
titleBarHeight - (default fit label) the height of the titleBar if a titleBar is requested
close - (default false) - a close X for the top right corner that closes the pane when pressed
closeColor - (default #555) - the color of the close X if close is requested
style - (default true) set to false to ignore styles set with the STYLE - will receive original parameter defaults
group - (default null) set to String (or comma delimited String) so STYLE can set default styles to the group(s) (like a CSS class)
inherit - (default null) used internally but can receive an {} of styles directly

METHODS
show() - shows the pane (returns the pane for chaining)
hide() - hides the pane
toggle(state - default null) - shows if hidden and hides if showing (returns the pane for chaining)
	or pass in true to show pane or false to hide pane
hasProp(property as String) - returns true if property exists on object else returns false
clone() - makes a copy with properties such as x, y, etc. also copied (returns the new pane for chaining)
dispose() - removes from parent, removes event listeners - must still set outside references to null for garbage collection

ALSO: ZIM 4TH adds all the methods listed under Container (see above), such as:
drag(), hitTestRect(), animate(), sca(), reg(), mov(), center(), centerReg(),
addTo(), removeFrom(), loop(), outline(), place(), pos(), alp(), rot(), setMask(), etc.
ALSO: See the CreateJS Easel Docs for Container methods, such as:
on(), off(), getBounds(), setBounds(), cache(), uncache(), updateCache(), dispatchEvent(),
addChild(), removeChild(), addChildAt(), getChildAt(), contains(), removeAllChildren(), etc.

PROPERTIES
type - holds the class name as a String
** setting widths and heights adjusts scale not bounds and getting these uses the bounds dimension times the scale
width - gets or sets the width. Setting the width will scale the height to keep proportion (see widthOnly below)
height - gets or sets the height. Setting the height will scale the width to keep proportion (see heightOnly below)
widthOnly - gets or sets the width.  This sets only the width and may change the aspect ratio of the object
heightOnly - gets or sets the height.  This sets only the height and may change the aspect ratio of the object
backing - or display - reference to the pane box
text - gives access to the label text
label - gives access to the label
titleBar - (default null - no titleBar) a String or ZIM Label title for the window that will be presented on a titleBar across the top
titleBarColor - (default "black") the text color of the titleBar if a titleBar is requested
titleBarBackgroundColor - (default "rgba(0,0,0,.2)") the background color of the titleBar if a titleBar is requested
titleBarHeight - (default fit label) the height of the titleBar if a titleBar is requested
toggled - read-only Boolean property as to whether pane is showing
close - access to the ZIM Shape if there is a close X
backdrop - reference to the backdrop that covers the stage
container - get or set the container the pane will be added to
resetX - if reset is true you can dynamically adjust the position if needed
resetY - and the y position for reset...
enabled - set to false to disable component
blendMode - how the object blends with what is underneath - such as "difference", "multiply", etc. same as CreateJS compositeOperation
group - used when the object is made to add STYLE with the group selector (like a CSS class)

ALSO: See the CreateJS Easel Docs for Container properties, such as:
x, y, rotation, scaleX, scaleY, regX, regY, skewX, skewY,
alpha, cursor, shadow, mouseChildren, mouseEnabled, parent, numChildren, etc.

OPTIMIZED
This component is affected by the general OPTIMIZE setting (default is false)
if set to true, you will have to stage.update() after setting certain properties
and stage.update() in change event to see component change its graphics

ACTIONEVENT
This component is affected by the general ACTIONEVENT setting
The default is "mousedown" - if set to something else the component will act on click (press)

EVENTS
dispatches a "close" event when closed by clicking on backing, display, close, etc. when applicable

ALSO: See the CreateJS Easel Docs for Container events, such as:
added, click, dblclick, mousedown, mouseout, mouseover, pressmove, pressup, removed, rollout, rollover
--*///+58
	zim.Pane = function(width, height, label, backgroundColor, color, draggable, resets, modal, corner, backdropColor, shadowColor, shadowBlur, center, displayClose, backdropClose, backing, fadeTime, container, titleBar, titleBarColor, titleBarBackgroundColor, titleBarHeight, close, closeColor, style, group, inherit) {
		var sig = "width, height, label, backgroundColor, color, draggable, resets, modal, corner, backdropColor, shadowColor, shadowBlur, center, displayClose, backdropClose, backing, fadeTime, container, titleBar, titleBarColor, titleBarBackgroundColor, titleBarHeight, close, closeColor, style, group, inherit";
		var duo; if (duo = zob(zim.Pane, arguments, sig, this)) return duo;
		z_d("58");
		this.zimContainer_constructor(null,null,null,null,false);
		this.type = "Pane";

		var mess = "zim display - Pane(): Please pass in a reference to a container with bounds set as first parameter";
		if (zot(container)) {
			if (zimDefaultFrame) {
				container = zimDefaultFrame.stage;
			} else {
				zog(mess);
				return;
			}
		} else if (!container.getBounds) {
			zog(mess);
			return;
		} else if (zot(container.getStage)) {
			zog("zim display - Pane(): The container must have a stage property");
			return;
		}

		this.group = group;
		var DS = style===false?{}:zim.getStyle(this.type, this.group, inherit);

		if (zot(width)) width=DS.width!=null?DS.width:200;
		if (zot(height)) height=DS.height!=null?DS.height:200;
		if (zot(label)) label = DS.label!=null?DS.label:null;
		if (typeof label === "string" || typeof label === "number") label = new zim.Label({
			text:label, size:DS.size!=null?DS.size:40, align:DS.align!=null?DS.align:"center", valign:DS.valign!=null?DS.valign:"center", color:DS.color!=null?DS.color:color,
			backing:"ignore", shadowColor:"ignore", shadowBlur:"ignore", padding:"ignore", backgroundColor:"ignore",
			group:this.group
		});
		if (zot(backgroundColor)) backgroundColor=DS.backgroundColor!=null?DS.backgroundColor:"white";
		if (zot(draggable)) draggable=DS.draggable!=null?DS.draggable:false;
		if (zot(resets)) resets=DS.resets!=null?DS.resets:true;
		if (zot(modal)) modal=DS.modal!=null?DS.modal:true;
		if (zot(corner)) corner=DS.corner!=null?DS.corner:20;

		if (zot(titleBar)) titleBar = DS.titleBar!=null?DS.titleBar:null;
		if (zot(titleBarColor)) titleBarColor = DS.titleBarColor!=null?DS.titleBarColor:null;
		if (zot(titleBarBackgroundColor)) titleBarBackgroundColor = DS.titleBarBackgroundColor!=null?DS.titleBarBackgroundColor:null;
		if (zot(titleBarHeight)) titleBarHeight = DS.titleBarHeight!=null?DS.titleBarHeight:null;

		if (zot(backdropColor)) backdropColor=DS.backdropColor!=null?DS.backdropColor:"rgba(0,0,0,.2)";
		if (zot(shadowColor))  shadowColor=DS.shadowColor!=null?DS.shadowColor:"rgba(0,0,0,.3)";
		if (zot(shadowBlur)) shadowBlur=DS.shadowBlur!=null?DS.shadowBlur:20;
		if (zot(center)) center=DS.center!=null?DS.center:true;
		if (zot(displayClose)) displayClose=DS.displayClose!=null?DS.displayClose:true;
		if (draggable) displayClose = false;
		if (zot(backdropClose)) backdropClose=DS.backdropClose!=null?DS.backdropClose:true;
		if (zot(fadeTime)) fadeTime=DS.fadeTime!=null?DS.fadeTime:0;
		if (zot(close)) close=DS.close!=null?DS.close:false;
		if (zot(closeColor)) closeColor=DS.closeColor!=null?DS.closeColor:"#555";

		var backdrop = this.backdrop = new zim.Shape({style:false});
		backdrop.type = "CreateJS_Shape";
		// make a big backing that closes the pane when clicked
		// could also provide a close button
		var g = backdrop.graphics;
		g.f(backdropColor);
		g.drawRect(-5000,-5000,10000,10000);
		// makes it seem like the pane has the dimensions of the display
		this.setBounds(-width/2,-height/2, width, height);

		var that = this;
		that.container = container;
		backdrop.on((!zns?ACTIONEVENT=="mousedown":zim.ACTIONEVENT=="mousedown")?"mousedown":"click", backdropClose?closePane:function(e){e.stopImmediatePropagation();});
		var htmlList = new zim.Dictionary(true);
		function closePane(e) {
			removePane();
			that.container.stage.update();
			that.dispatchEvent("close");
			e.stopImmediatePropagation();
		};
		backdrop.on("mousedown", function(e) {
			e.stopImmediatePropagation();
		});
		if (modal) this.addChild(backdrop);

		var display;
		if (zot(backing)) {
			display = this.backing = this.display = new zim.Rectangle({
				width:width, height:height, color:backgroundColor, corner:corner, style:false
			});
		} else {
			if (backing.type == "Pattern") {
				var pattern = backing;
				// width, height, color, borderColor, borderWidth, corner, dashed, strokeObj, style, group, inherit
				display = new zim.Rectangle(width, height, backgroundColor, null, null, corner, null, null, false);
				pattern.centerReg(display);
				pattern.setMask(display.shape);
			} else {
				display = backing;
			}
			that.display = that.backing = display;
		}
		if (displayClose) {
			display.cursor = "pointer";
			display.on((!zns?ACTIONEVENT=="mousedown":zim.ACTIONEVENT=="mousedown")?"mousedown":"click", closePane);
		}
		if (shadowColor != -1 && shadowBlur > 0) display.shadow = new createjs.Shadow(shadowColor, 8, 8, shadowBlur);
		display.on("click", function(e) {
			// stops the click from going through the display to the background
			e.stopImmediatePropagation();
		});

		this.resetX; this.resetY;
		if (draggable) {
			display.cursor = "pointer";
			var diffX, diffY;
			var stage;
			display.on("mousedown", function(e) {
				stage = e.target.stage;
				if (isNaN(that.resetX)) that.resetX = that.x;
				if (isNaN(that.resetY)) that.resetY = that.y;
				diffX = e.stageX/stage.scaleX - that.x;
				diffY = e.stageY/stage.scaleY - that.y;
				display.cursor = "pointer";
			});

			display.on("pressmove", function(e) {
				var p = checkBounds(e.stageX/stage.scaleX-diffX, e.stageY/stage.scaleY-diffY);
				that.x = p.x;
				that.y = p.y;
				var ch;
				for (var i=0; i<that.numChildren; i++) {
					ch = that.getChildAt(i);
					if (ch.type == "TextArea" || ch.type == "Loader" || ch.type == "Tag") {
						ch.resize();
					}
				}
				stage.update();
			});

			this.on("pressup", function(e) {
				display.cursor = "pointer";
				if (that.stage) that.stage.update();
			});
		}

		display.centerReg(this);

		if (label) {
			this.addChild(label);
			zim.center(label, this);
			this.label = label;
			this.text = label.text;
			label.mouseEnabled = false;
		}

		if (!zot(titleBar)) {
			if (typeof titleBar == "string") titleBar = new zim.Label(titleBar, null, null, titleBarColor);
			titleBarLabel = that.titleBarLabel = titleBar;
			if (zot(titleBarHeight)) titleBarHeight=titleBarLabel.height * 1.5;
			if (zot(titleBarColor)) titleBarColor = "black";
			if (zot(titleBarBackgroundColor)) titleBarBackgroundColor = "rgba(0,0,0,.2)";
			that.titleBar = titleBar = new zim.Container(width, titleBarHeight, null, null, false).centerReg(that).mov(0,-height/2+titleBarHeight/2);
			titleBar.mouseEnabled = false;
			titleBar.mouseChildren = false;
			var titleBarRect = that.titleBar.backing = new zim.Rectangle(width, titleBarHeight, titleBarBackgroundColor, null, null, [corner*.95,corner*.95, 0,0], null, null, false).addTo(titleBar);
			titleBarLabel.center(titleBar).pos({x:Math.max(corner/2, 10), reg:true});
		}

		if (close) {
			var close = that.close = new zim.Shape(-40,-40,80,80,null,false);
			close.graphics.f(closeColor).p("AmJEVIEUkTIkXkWIB4h5IEWEYIETkTIB4B3IkTESIEQERIh4B4IkRkRIkSEVg"); // width about 90 reg in middle
			if (titleBar) close.addTo(that).scaleTo(titleBar, null, 50).mov(width/2-Math.max(corner/2, 10)-close.width/2, -height/2+titleBarHeight/2).expand(40);
			else close.addTo(that).sca(.3).mov(width/2-close.width-3, -height/2+close.height).expand(40);
			close.cursor = "pointer";
			close.expand();
			close.on((!zns?ACTIONEVENT=="mousedown":zim.ACTIONEVENT=="mousedown")?"mousedown":"click", closePane);
		}

		Object.defineProperty(that, 'text', {
			get: function() {
				var t = (label.text == " ") ? "" : label.text;
				return t;
			},
			set: function(value) {
				label.text = value;
			}
		});

		this._enabled = true;
		Object.defineProperty(that, 'enabled', {
			get: function() {
				return that._enabled;
			},
			set: function(value) {
				zenable(that, value);
			}
		});

		this.hide = function() {
			removePane();
			that.toggled = false;
			return that;
		}

		function removePane() {
			if (fadeTime > 0) {
				that.animate({obj:{alpha:0}, time:fadeTime, call:end});
			} else {
				end();
			}
			function end() {
				that.container.removeChild(that);
				var ch;
				for (var i=0; i<that.numChildren; i++) { // record depths first
					ch = that.getChildAt(i);
					if (ch.type == "TextArea" || ch.type == "Loader" || ch.type == "Tag") {
						var obj = {obj:ch, depth:that.getChildIndex(ch)};
						htmlList.add(ch, obj);
					}
				}
				for (var i=that.numChildren-1; i>=0; i--) { // remove textareas and loaders second
					ch = that.getChildAt(i);
					if (ch.type == "TextArea" || ch.type == "Loader" || ch.type == "Tag") {
						that.removeChild(ch);
					}
				}
				if ((!zim.OPTIMIZE&&(zns||!OPTIMIZE))) that.container.stage.update();
				if (resets) {
					if (!isNaN(that.resetX)) that.x = that.resetX;
					if (!isNaN(that.resetY)) that.y = that.resetY;
				}

				if (that.zimAccessibility) {
					var a = that.zimAccessibility;
					a.resize(that);
					if (accessibilityClicker) accessibilityClicker.focus();
					else that.zimTabTag.nextSibling.focus();
					setTimeout(function() {a.talk("Pane has been closed.");}, 50);
				}
			}
		}

		var accessibilityClicker;
		this.show = function() {
			if (center) {
				if (isNaN(that.resetX)) {
					that.x = (that.container.getBounds().width) /2;
					that.y = (that.container.getBounds().height) /2;
				}
			}
			that.container.addChild(that);
			for (var i=0; i<htmlList.length; i++) {
				that.addChildAt(htmlList.values[i].obj, htmlList.values[i].depth);
			}
			if (fadeTime > 0) {
				that.alpha = 0;
				that.animate({alpha:1}, fadeTime);
			} else {
				if (that.container.stage) that.container.stage.update();
			}
			if (that.zimAccessibility) {
				var a = that.zimAccessibility;
				setTimeout(function(){if (a.activatedObject) accessibilityClicker = a.activatedObject.zimTabTag;}, 50);
				a.resize(that);
				a.tabIndex = that.zimTabIndex;
			}
			that.toggled = true;
			return that;
		}
		function checkBounds(x,y) {
			x = Math.max(width/2, Math.min(that.container.getBounds().width-width/2, x));
			y = Math.max(height/2, Math.min(that.container.getBounds().height-height/2, y));
			return {x:x,y:y}
		}

		this.toggle = function(state) {
			if (state===true) that.show();
			else if (state===false) that.hide();
			else if (that.container.contains(that)) that.hide();
			else that.show();
			return that;
		}

		if (style!==false) zimStyleTransforms(this, DS);
		this.clone = function() {
			var lX = label.x; // new Panes automatically center the label
			var lY = label.y;
			var p2 = that.cloneProps(new zim.Pane(width, height, label.clone(), backgroundColor, color, draggable, resets, modal, corner, backdropColor, shadowColor, shadowBlur, center, displayClose, backdropClose, zot(backing)?backing.clone():null, fadeTime, that.container, titleBar, titleBarColor, titleBarBackgroundColor, titleBarHeight, close, closeColor, style, this.group, inherit));
			p2.label.x = lX;
			p2.label.y = lY;
			return p2;
		}
	}
	zim.extend(zim.Pane, zim.Container, "clone", "zimContainer", false);
	//-58

/*--
zim.Window = function(width, height, backgroundColor, borderColor, borderWidth, padding, corner, swipe, scrollBarActive, scrollBarDrag, scrollBarColor, scrollBarAlpha, scrollBarFade, scrollBarH, scrollBarV, slide, slideDamp, slideSnap, interactive, shadowColor, shadowBlur, paddingHorizontal, paddingVertical, scrollWheel, damp, titleBar, titleBarColor, titleBarBackgroundColor, titleBarHeight, draggable, boundary, close, closeColor, cancelCurrentDrag, style, group, inherit)

Window
zim class - extends a zim.Container which extends a createjs.Container

DESCRIPTION
Adds a window for content that can be swiped and scrolled.
NOTE: if zim namespace zns = true then this overwrites a JS Window - so the JS Window is stored as document.window

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var win = new Window({
	height:300,
	interactive:false,
	padding:0,
	slideDamp:.2
});
var container = new Container(); // make some content
var c; spacing = 10;
for (var i=0; i<4; i++) {
	c = frame.makeCircles();
	c.x = win.width/2;
	c.y = c.width/2 + (c.width+spacing)*i;
	container.addChild(c);
}
win.add(container); // add the content to the window
win.center(stage);
stage.update();
END EXAMPLE

PARAMETERS
** supports DUO - parameters or single object with properties below
** supports OCT - parameter defaults can be set with STYLE control (like CSS)
width - (default 300) the width of the window
height - (default 200) the height of window - including the titleBar if there is a titleBar
backgroundColor - (default #333) background color (use clear - or "rbga(0,0,0,0)" for no background)
borderColor - (default #999) border color
borderWidth - (default 1) the thickness of the border
padding - (default 0) places the content in from edges of border (see paddingHorizontal and paddingVertical)
	padding is ignored if content x and y not 0 - and really only works on top left - so more like an indent
corner - (default 0) is the rounded corner of the window (does not accept corner array - scrollBars are too complicated)
swipe - (default auto/true) the direction for swiping set to none / false for no swiping
	also can set swipe to just vertical or horizontal
scrollBarActive - (default true) shows scrollBar (set to false to not)
scrollBarDrag - (default false) set to true to be able to drag the scrollBar
scrollBarColor - (default borderColor) the color of the scrollBar
scrollBarAlpha - (default .3) the transparency of the scrollBar
scrollBarFade - (default true) fades scrollBar unless being used
scrollBarH - (default true) if scrolling in horizontal is needed then show scrollBar
scrollBarV - (default true) if scrolling in vertical is needed then show scrollBar
slide - (default true) Boolean to throw the content when drag/swipe released
slideDamp - (default .6) amount the slide damps when let go 1 for instant, .01 for long slide, etc.
slideSnap - (default "vertical") "auto" / true, "none" / false, "horizontal"
	slides past bounds and then snaps back to bounds when released
	vertical snaps when dragging up and down but not if dragging horizontal
interactive - (default true) allows interaction with content in window
	set to false and whole window will be swipeable but not interactive inside
shadowColor - (default rgba(0,0,0,.3)) the color of the shadow
shadowBlur - (default 20) set shadowBlur to -1 for no drop shadow
paddingHorizontal - (default padding) places content in from top bottom (ignored if content x not 0)
paddingVertical - (default padding) places content in from left and right (ignored if content y not 0)
scrollWheel - (default true) scroll vertically with scrollWheel
damp - (default null) set to .1 for instance to damp the scrolling
titleBar - (default null - no titleBar) a String or ZIM Label title for the window that will be presented on a titleBar across the top
titleBarColor - (default "black") the text color of the titleBar if a titleBar is requested
titleBarBackgroundColor - (default "rgba(0,0,0,.2)") the background color of the titleBar if a titleBar is requested
titleBarHeight - (default fit label) the height of the titleBar if a titleBar is requested
draggable - (default true if titleBar) set to false to not allow dragging titleBar to drag window
boundary - (default null) set to ZIM Boundary() object - or CreateJS.rectangle()
close - (default false) - a close X for the top right corner that closes the window when pressed
closeColor - (default #555) - the color of the close X if close is requested
cancelCurrentDrag - (default false) - set to true to cancel window dragging when document window loses focus
	this functionality seems to work except if ZIM is being used with Animate - so we have left it turned off by default
style - (default true) set to false to ignore styles set with the STYLE - will receive original parameter defaults
group - (default null) set to String (or comma delimited String) so STYLE can set default styles to the group(s) (like a CSS class)
inherit - (default null) used internally but can receive an {} of styles directly

METHODS
add(obj, replace) - adds obj to content container of window (at padding) must have bounds set
	it is best to position and size obj first before adding
	otherwise if adjusting to outside current content size then call update()
	replace defaults to false and if set to true, removes all content then adds the obj.
	returns window for chaining
remove(obj) - removes object from content container of window and updates - returns window for chaining
removeAll() - removes all objects from content container of window and updates - returns window for chaining
resize(width, height) - resizes the Window without scaling the content (also calls update() for scroll update)
	width and height are optional - returns window for chaining
update() - resets window scrolling if perhaps the content gets bigger or smaller
cancelCurrentDrag() - stop current drag on window - but add dragging back again for next drag
clone(recursive) - makes a copy with properties such as x, y, etc. also copied
	recursive (default true) clones the window content as well (set to false to not clone content)
dispose() - removes from parent, removes event listeners - must still set outside references to null for garbage collection

ALSO: ZIM 4TH adds all the methods listed under Container (see above), such as:
drag(), hitTestRect(), animate(), sca(), reg(), mov(), center(), centerReg(),
addTo(), removeFrom(), loop(), outline(), place(), pos(), alp(), rot(), setMask(), etc.
ALSO: See the CreateJS Easel Docs for Container methods, such as:
on(), off(), getBounds(), setBounds(), cache(), uncache(), updateCache(), dispatchEvent(),
addChild(), removeChild(), addChildAt(), getChildAt(), contains(), removeAllChildren(), etc.

PROPERTIES
type - holds the class name as a String
** setting widths and heights adjusts scale not bounds and getting these uses the bounds dimension times the scale
** see also the resize(width, height) method to resize the window without resizing the content
width - gets or sets the width. Setting the width will scale the height to keep proportion (see widthOnly below)
height - gets or sets the height. Setting the height will scale the width to keep proportion (see heightOnly below)
widthOnly - gets or sets the width.  This sets only the width and may change the aspect ratio of the object
heightOnly - gets or sets the height.  This sets only the height and may change the aspect ratio of the object
backing - CreateJS Shape used for backing of Window
content - ZIM Container used to hold added content
scrollBar - data object that holds the following properties (with defaults):
	you can set after object is made...
	scrollBar.horizontal = zim Shape // the horizontal scrollBar rectangle shape
	scrollBar.vertical = zim Shape // the vertical scrollBar rectangle shape
	scrollBar.color = borderColor; // the color of the scrollBar
	scrollBar.size = 6; // the width if vertical or the height if horizontal
	scrollBar.minSize = 12; // for the height if vertical or the width if horizontal
	scrollBar.spacing = 3 + size + borderWidth / 2;
	scrollBar.margin = 0; // adds extra space only at end by scrollBars
	scrollBar.corner = scrollBar.size / 2;
	scrollBar.showTime = 500; // ms to fade in
	scrollBar.fadeTime = 3000; // ms to fade out
scrollX - gets and sets the content x position in the window (this will be negative)
scrollY - gets and sets the content y position in the window (this will be negative)
scrollXMax - gets the max we can scroll in x based on content width - window width (plus padding and margin)
scrollYMax - gets the max we can scroll in y based on content height - window height (plus padding and margin)
titleBar - access to the ZIM Container for the titleBar if there is a titleBar
titleBarLabel - access to the ZIM Label of the titleBar if there is a titleBar
titleBarBacking - access to the ZIM Rectangle of the titleBar if there is a titleBar
close - access to the ZIM Shape if there is a close X
blendMode - how the object blends with what is underneath - such as "difference", "multiply", etc. same as CreateJS compositeOperation
group - used when the object is made to add STYLE with the group selector (like a CSS class)

ALSO: See the CreateJS Easel Docs for Container properties, such as:
x, y, rotation, scaleX, scaleY, regX, regY, skewX, skewY,
alpha, cursor, shadow, mouseChildren, mouseEnabled, parent, numChildren, etc.

EVENTS
dispatches a "select" event when clicked on in a traditional manner (fast click with little movement)
dispatches a "hoverover" event when rolled on without moving for 300 ms
dispatches a "hoverout" event when not hovering due to movement or mouseout on the window
dispatches a "scrolling" event when the window scrolls
dispatches a "close" event when the window is closed with the x on the titleBar if there is a titleBar

ALSO: See the CreateJS Easel Docs for Container events, such as:
added, click, dblclick, mousedown, mouseout, mouseover, pressmove, pressup, removed, rollout, rollover
--*///+58.1
	zim.Window = function(width, height, backgroundColor, borderColor, borderWidth, padding, corner, swipe, scrollBarActive, scrollBarDrag, scrollBarColor, scrollBarAlpha, scrollBarFade, scrollBarH, scrollBarV, slide, slideDamp, slideSnap, interactive, shadowColor, shadowBlur, paddingHorizontal, paddingVertical, scrollWheel, damp, titleBar, titleBarColor, titleBarBackgroundColor, titleBarHeight, draggable, boundary, close, closeColor, cancelCurrentDrag, style, group, inherit) {
		var sig = "width, height, backgroundColor, borderColor, borderWidth, padding, corner, swipe, scrollBarActive, scrollBarDrag, scrollBarColor, scrollBarAlpha, scrollBarFade, scrollBarH, scrollBarV, slide, slideDamp, slideSnap, interactive, shadowColor, shadowBlur, paddingHorizontal, paddingVertical, scrollWheel, damp, titleBar, titleBarColor, titleBarBackgroundColor, titleBarHeight, draggable, boundary, close, closeColor, cancelCurrentDrag, style, group, inherit";
		var duo; if (duo = zob(zim.Window, arguments, sig, this)) return duo;
		z_d("58.1");
		this.zimContainer_constructor(null,null,null,null,false);
		this.type = "Window";
		this.group = group;
		var DS = style===false?{}:zim.getStyle(this.type, this.group, inherit);

		if (zot(width)) width=DS.width!=null?DS.width:300;
		if (zot(height)) height=DS.height!=null?DS.height:200;
		if (zot(backgroundColor)) backgroundColor=DS.backgroundColor!=null?DS.backgroundColor:"#333";
		var originalBorderColor = borderColor;
		var originalBorderWidth = borderWidth;
		if (zot(borderColor)) borderColor=DS.borderColor!=null?DS.borderColor:"#999";
		if (zot(borderWidth)) borderWidth=DS.borderWidth!=null?DS.borderWidth:1; // 0
		if (zot(padding)) padding=DS.padding!=null?DS.padding:0;
		if (zot(corner)) corner=DS.corner!=null?DS.corner:0;
		if (zot(swipe)) swipe=DS.swipe!=null?DS.swipe:true; // true / auto, vertical, horizontal, false / none
		if (zot(scrollBarActive)) scrollBarActive=DS.scrollBarActive!=null?DS.scrollBarActive:true;
		if (zot(scrollBarDrag)) scrollBarDrag=DS.scrollBarDrag!=null?DS.scrollBarDrag:false;
		if (zot(scrollBarColor)) scrollBarColor=DS.scrollBarColor!=null?DS.scrollBarColor:borderColor;
		if (zot(scrollBarAlpha)) scrollBarAlpha=DS.scrollBarAlpha!=null?DS.scrollBarAlpha:.3;
		if (zot(scrollBarFade)) scrollBarFade=DS.scrollBarFade!=null?DS.scrollBarFade:true;
		if (zot(scrollBarH)) scrollBarH = DS.scrollBarH!=null?DS.scrollBarH:true;
		if (zot(scrollBarV)) scrollBarV = DS.scrollBarV!=null?DS.scrollBarV:true;
		if (scrollBarDrag) scrollBarFade = DS.scrollBarFade!=null?DS.scrollBarFade:false;
		if (zot(slide)) slide=DS.slide!=null?DS.slide:true;
		if (zot(slideDamp)) slideDamp=DS.slideDamp!=null?DS.slideDamp:.6;
		if (zot(slideSnap)) slideSnap=DS.slideSnap!=null?DS.slideSnap:"vertical"; // true / auto, vertical, horizontal, false / none
		if (zot(interactive)) interactive=DS.interactive!=null?DS.interactive:true;
		if (zot(shadowColor)) shadowColor=DS.shadowColor!=null?DS.shadowColor:"rgba(0,0,0,.3)";
		if (zot(shadowBlur)) shadowBlur=DS.shadowBlur!=null?DS.shadowBlur:20;
		if (zot(paddingVertical)) paddingVertical=DS.paddingVertical!=null?DS.paddingVertical:padding;
		if (zot(paddingHorizontal)) paddingHorizontal=DS.paddingHorizontal!=null?DS.paddingHorizontal:padding;
		if (zot(scrollWheel)) scrollWheel = DS.scrollWheel!=null?DS.scrollWheel:true;
		if (zot(titleBar)) titleBar = DS.titleBar!=null?DS.titleBar:null;
		if (zot(titleBarColor)) titleBarColor = DS.titleBarColor!=null?DS.titleBarColor:null;
		if (zot(titleBarBackgroundColor)) titleBarBackgroundColor = DS.titleBarBackgroundColor!=null?DS.titleBarBackgroundColor:null;
		if (zot(titleBarHeight)) titleBarHeight = DS.titleBarHeight!=null?DS.titleBarHeight:null;
		if (zot(draggable)) draggable = DS.draggable!=null?DS.draggable:null;
		if (zot(boundary)) boundary = DS.boundary!=null?DS.boundary:null;
		if (zot(close)) close = DS.close!=null?DS.close:null;
		if (zot(closeColor)) closeColor = DS.closeColor!=null?DS.closeColor:null;
		if (zot(cancelCurrentDrag)) cancelCurrentDrag = DS.cancelCurrentDrag!=null?DS.cancelCurrentDrag:false;

		if (titleBar === false) titleBar = null;
		if (!zot(titleBar)) {
			if (zot(titleBarHeight)) titleBarHeight = 30;
			height = height - titleBarHeight;
		}

		var that = this;
		this.scrollX = this.scrollY = this.scrollXMax = this.scrollYMax = 0;

		var backing = this.backing = new zim.Shape({style:false});
		this.addChild(backing);

		var mask = new createjs.Shape();
		mask.type = "WindowBacking";
		var mg = mask.graphics;
		// make the mask in the update function
		// when we know if there are vertical and horizontal scrollBars
		this.addChild(mask);

		var content = this.content = new zim.Container({style:false});
		this.addChild(content);
		content.mask = mask;
		var stage;

		if (!interactive) {
			// hitArea makes the whole window draggable
			// but then you can't interact with the content inside the window
			var hitArea = new createjs.Shape();
		}
		if (borderWidth > 0) {
			var border = new createjs.Shape();
			this.addChild(border);
		}

		var titleBarCorner = titleBar?0:corner;

		// we call this function at start and when resize() is called to resize the window without scaling content
		function sizeWindow() {
			that.setBounds(0,0,width,height);
			backing.graphics.c().f(backgroundColor).rc(0,0,width,height,titleBarCorner,titleBarCorner,corner,corner);
			if (shadowColor != -1 && shadowBlur > 0) backing.shadow = new createjs.Shadow(shadowColor, 4, 4, shadowBlur);

			if (borderWidth > 0) {
				if (corner) {
					border.graphics.c().s(borderColor).ss(borderWidth, "square", "miter").rc(0,0,width,height,titleBarCorner,titleBarCorner,corner,corner);
				} else {
					border.graphics.c().s(borderColor).ss(borderWidth, "square", "miter").dr(0,0,width,height);
				}
			}
		}
		sizeWindow();

		// this exposes an scrollBar data object so creators can adjust scrollBar properties
		// note that these properties are set dynamically in the update function
		var scrollBar = this.scrollBar = {}; // data object to expose scrollBar properties
		scrollBar.color = scrollBarColor;
		scrollBar.size = 6;
		scrollBar.minSize = scrollBar.size*2; // if vertical scroll, this is vertical minSize where size is horizontal size
		scrollBar.spacing = 3.5 + borderWidth / 2;
		scrollBar.margin = 0;
		scrollBar.corner = scrollBar.size / 2;
		scrollBar.showTime = 500;
		scrollBar.fadeTime = 3000;

		if (scrollBarActive) {
			var hscrollBar = scrollBar.horizontal = new zim.Shape({style:false});
			var hg = hscrollBar.graphics;
			hscrollBar.alpha = scrollBarAlpha;
			this.addChild(hscrollBar);
			if (scrollBarDrag) hscrollBar.drag({localBounds: true});

			var vscrollBar = scrollBar.vertical = new zim.Shape({style:false});
			var vg = vscrollBar.graphics;
			vscrollBar.alpha = scrollBarAlpha;
			this.addChild(vscrollBar);
			if (scrollBarDrag) vscrollBar.drag({localBounds: true});
		}

		var hProportion;
		var vProportion;
		var hCheck;
		var vCheck;
		var gap;
		var contentWidth;
		var contentHeight;

		var hEvent;
		var vEvent;
		var dTimeout;

		this.update = function() {
			if (scrollBarActive) {
				// clear the scrollBars and remake anytime this function is called
				// as these may change as people add and remove content to the Window
				hg.clear(); // horizontal scrollBar
				vg.clear(); // vertical scrollBar
			}

			// assume no gap at left and top
			// gap is applied in x if there is a scroll in y
			// gap is applied in y if there is a scroll in x
			gap = (scrollBarActive) ? scrollBar.size+scrollBar.spacing*2 : 0;
			contentWidth = content.getBounds()?content.getBounds().width:0;
			contentHeight = content.getBounds()?content.getBounds().height:0;

			// note, the contentWidth and contentHeight include ONE padding
			hCheck = (scrollBarH && contentWidth > width-paddingHorizontal && (scrollBarActive || swipe === true || swipe == "auto" || swipe == "horizontal"));
			vCheck = (scrollBarV && contentHeight > height-paddingVertical && (scrollBarActive || swipe === true || swipe == "auto" || swipe == "vertical"));

			that.scrollXMax = contentWidth+paddingHorizontal*2-width+(vCheck?gap+scrollBar.margin:0);
            that.scrollYMax = contentHeight+paddingVertical*2-height+(hCheck?gap+scrollBar.margin:0);

			// set mask dynamically as scrollBars may come and go affecting the mask size slightly
			mg.clear();
			var xx = borderWidth/2;
			var yy = borderWidth/2;
			var ww = width-((vCheck && scrollBarActive)?scrollBar.size+scrollBar.spacing*2:0)-(vCheck?0:borderWidth);
			var hh = height-((hCheck && scrollBarActive)?scrollBar.size+scrollBar.spacing*2:0)-(hCheck?0:borderWidth);
			mg.f("rgba(0,0,0,0)").rc(xx,yy,ww,hh,titleBarCorner,titleBarCorner,vCheck&&scrollBarActive?0:corner,hCheck&&scrollBarActive?0:corner);

			mask.setBounds(that.getBounds().x,that.getBounds().y,that.getBounds().width, that.getBounds().height);
			zim.expand(mask, 0);
			if (!interactive) {
				hitArea.graphics.c().f("red").dr(xx,yy,ww,hh);
				content.hitArea = hitArea;
			}

			var edgeAdjust = Math.max(corner, Math.min(scrollBar.corner, scrollBar.spacing));
			var edgeLeft = edgeAdjust + borderWidth/2;
			var edgeRight = edgeAdjust + (vCheck?gap:0) + borderWidth/2;
			var edgeTop = edgeAdjust + borderWidth/2;
			var edgeBottom = edgeAdjust + (hCheck?gap:0) + borderWidth/2;

			if (hCheck && scrollBarActive) {
				scrollBarLength = Math.max(scrollBar.minSize, (width-edgeLeft-edgeRight) * (width-edgeLeft-edgeRight) / (contentWidth + paddingHorizontal + scrollBar.margin));
				hg.f(scrollBar.color).rr(0,0,scrollBarLength,scrollBar.size,scrollBar.corner);
				hscrollBar.x = edgeLeft;
				hscrollBar.y = height-scrollBar.size-scrollBar.spacing;
				// for swiping window:
				hProportion = new zim.Proportion(-that.scrollXMax, 0, edgeLeft, width-scrollBarLength-edgeRight, -1);
				if (scrollBarDrag) {
					hscrollBar.setBounds(0,0,scrollBarLength,scrollBar.size);
					// drag rect for scrollBar
					var rect = new createjs.Rectangle(
						edgeLeft, hscrollBar.y, width-scrollBarLength-edgeLeft-edgeRight, 0
					);
					hscrollBar.dragBoundary(rect);
					hscrollBar.proportion = new zim.Proportion(
						rect.x, rect.x+rect.width, 0, -that.scrollXMax
					);
					hscrollBar.off("pressmove", hEvent);
					hEvent = hscrollBar.on("pressmove", function() {
						that.dispatchEvent("scrolling");
						content.x = hscrollBar.proportion.convert(hscrollBar.x);
					});
				}
			}

			if (vCheck && scrollBarActive) {
				scrollBarLength = Math.max(scrollBar.minSize, (height-edgeTop-edgeBottom) * (height-edgeTop-edgeBottom) / (contentHeight + paddingVertical + scrollBar.margin));
				vg.f(scrollBar.color).rr(0,0,scrollBar.size,scrollBarLength,scrollBar.corner);
				vscrollBar.x = width-scrollBar.size-scrollBar.spacing;
				vscrollBar.y = edgeTop;
				// for swiping window:
				vProportion = new zim.Proportion(-that.scrollYMax, 0, edgeTop, height-scrollBarLength-edgeBottom, -1);
				if (scrollBarDrag) {
					vscrollBar.setBounds(0,0,scrollBar.size,scrollBarLength);
					// drag rect for scrollBar
					var rect = new createjs.Rectangle(
						vscrollBar.x, edgeTop, 0, height-scrollBarLength-edgeTop-edgeBottom
					);
					vscrollBar.dragBoundary(rect);
					vscrollBar.proportion = new zim.Proportion(
						rect.y, rect.y+rect.height, 0, -that.scrollYMax
					);
					vscrollBar.off("pressmove", vEvent);
					vEvent = vscrollBar.on("pressmove", function() {
						that.dispatchEvent("scrolling");
						desiredY = content.y = vscrollBar.proportion.convert(vscrollBar.y);
					});
				}
			}
			movescrollBars();

			clearTimeout(that.d2Timeout);
			that.d2Timeout = setTimeout(function(){
				if (hscrollBar && hscrollBar.proportion) content.x = hscrollBar.proportion.convert(hscrollBar.x);
				if (vscrollBar && vscrollBar.proportion) content.y = vscrollBar.proportion.convert(vscrollBar.y);
			}, 50);
			clearTimeout(that.dTimeout);
			that.dTimeout = setTimeout(function(){setdragBoundary();}, 300);
		}

		this.resize = function(w, h) {
			if (zot(w)) w = width;
			if (zot(h)) h = height;
			width = w;
			height = h;
			sizeWindow();
			that.update();
			desiredY = content.y;
			if (damp) dampY.immediate(desiredY);
			return that;
		}

		if (!zot(titleBar)) {
			if (zot(draggable)) draggable = true;
			if (typeof titleBar == "string") titleBar = new zim.Label({
				text:titleBar, color:titleBarColor, size:DS.size!=null?DS.size:20,
				backing:"ignore", shadowColor:"ignore", shadowBlur:"ignore", padding:"ignore", backgroundColor:"ignore",
				group:this.group
			});
			titleBarLabel = that.titleBarLabel = titleBar;
			if (zot(titleBarBackgroundColor)) titleBarBackgroundColor = "rgba(0,0,0,.2)";
			that.titleBar = titleBar = new zim.Container(width, titleBarHeight, null, null, false).centerReg(that).mov(0,-height/2-titleBarHeight/2);
			var titleBarRect = that.titleBar.backing = new zim.Rectangle(width+borderWidth, titleBarHeight, titleBarBackgroundColor, null, null, [corner*.95, corner*.95, 0, 0], true, null, false).center(titleBar);
			titleBarLabel.center(titleBar).pos({x:Math.max(corner/2, Math.max(10, padding)), reg:true});
			that.regX = 0; that.regY = -titleBarHeight;
			that.setBounds(0,-titleBarHeight,width,height+titleBarHeight);

			if (draggable) {
				titleBar.cursor = "pointer";
				titleBar.on("mousedown", function() {
					that.drag({rect:boundary, currentTarget:true});
				});
				titleBar.on("pressup", function() {
					that.noDrag();
				});
			} else {
				titleBar.on("mousedown", function () {});
			}
		}

		if (close) {
			if (zot(closeColor)) closeColor = "#555";
			var close = that.close = new zim.Shape(-40,-40,80,80,null,false);
			close.graphics.f(closeColor).p("AmJEVIEUkTIkXkWIB4h5IEWEYIETkTIB4B3IkTESIEQERIh4B4IkRkRIkSEVg"); // width about 90 reg in middle
			if (titleBar) close.centerReg(that).scaleTo(titleBar, null, 50).pos({x:width-Math.max(corner/2, Math.max(10, padding))-close.width/2, y:titleBarHeight/2, reg:true}).expand(40);
			else {
				close.sca(.3).pos((Math.max(corner/2, Math.max(10, padding)))/2, close.height/2, true, false, that).expand(40);
			}
			close.cursor = "pointer";
			close.expand();
			close.on((!zns?ACTIONEVENT=="mousedown":zim.ACTIONEVENT=="mousedown")?"mousedown":"click", function(){
				that.removeFrom();
				that.dispatchEvent("close");
			});
		}

		// METHODS to add and remove content from Window
		this.add = function(c, replace) {
			makeDamp(c);
			if (!c.getBounds()) {zog("SwipeBox.add() - please add content with bounds set"); return;}
			if (replace) that.removeAll();
			content.addChild(c);
			if (c.x == 0) c.x = paddingHorizontal;
			if (c.y == 0) c.y = paddingVertical;
			that.update();
			return that;
		}

		this.remove = function(c) {
			content.removeChild(c);
			that.update();
			return that;
		}

		this.removeAll = function() {
			content.removeAllChildren();
			that.update();
			return that;
		}

		function setdragBoundary() {
			zim.dragBoundary(content, new createjs.Rectangle(0, 0, hCheck?-that.scrollXMax:0, vCheck?-that.scrollYMax:0));
		}

		var swipeCheck = false;
		if (swipe) {
			content.on("mousedown", function() {
				if (!swipeCheck) zim.Ticker.add(swipeMovescrollBars, content.stage);
				swipeCheck = true;
				if (hCheck && scrollBarActive) if (scrollBarFade) zim.animate(hscrollBar, {alpha:scrollBarAlpha}, scrollBar.showTime);
				if (vCheck && scrollBarActive) if (scrollBarFade) zim.animate(vscrollBar, {alpha:scrollBarAlpha}, scrollBar.showTime);
			});
		}

		function swipeMovescrollBars() {
			// this is being called by the swipe which has its own damping
			// so we need to set the desiredY and then move the scrollBars
			// as the movescrollBars needs to run independently - so both types of damp can controll it
			desiredY = content.y;
			if (damp) dampY.immediate(desiredY);
			if (scrollBarActive) movescrollBars();
		}

		function movescrollBars() {
			that.dispatchEvent("scrolling");
			if (hitArea) {
				// move hitarea to display box
				hitArea.x = -content.x;
				hitArea.y = -content.y;
			}
			if (hCheck && scrollBarActive) hscrollBar.x = hProportion.convert(content.x);
			if (vCheck && scrollBarActive) vscrollBar.y = vProportion.convert(content.y);
		}

		// may add content before adding Window to stage...
		this.on("added", setDrag, null, true); // once
		function setDrag() {
			makeDamp(that);
			if (!swipe) return;
			zim.drag({
				obj:content,
				currentTarget:true,
				localBounds:true,
				slide:slide, slideDamp:slideDamp,
				slideSnap:(scrollBarH && (swipe===true||swipe=="auto"||swipe=="horizontal")) || (scrollBarV && (swipe===true||swipe=="auto"||swipe=="vertical"))?slideSnap:false
			});
			if (content.getBounds() && content.getBounds().width > 0) {
				setTimeout(function(){setdragBoundary();}, 300);
			}
		}
		this.cancelCurrentDrag = function() {
			that.content.noDrag();
			zim.drag({
				obj:content,
				currentTarget:true,
				localBounds:true,
				slide:slide, slideDamp:slideDamp,
				slideSnap:(scrollBarH && (swipe===true||swipe=="auto"||swipe=="horizontal")) || (scrollBarV && (swipe===true||swipe=="auto"||swipe=="vertical"))?slideSnap:false
			});
			if (content.getBounds() && content.getBounds().width > 0) {
				setTimeout(function(){setdragBoundary();}, 300);
			}
		}

		// if (interactive) {
			this.added(function (theStage) {
				theStage.on("stagemousemove", function (e) {
					that.windowMouseX = e.stageX/theStage.scaleX;
					that.windowMouseY = e.stageY/theStage.scaleY;
				});
			});
		// }

		if (slide) {
			content.on("slidestop", stageUp);
		} else {
			content.on("mousedown", function() {
				content.stage.on("stagemouseup", stageUp, null, true);
			});
		}
		if (cancelCurrentDrag) {
			that.blurEvent = document.window.addEventListener("blur", function () {
				that.cancelCurrentDrag();
				stageUp();
			});
		}

		function stageUp(e) {
			zim.Ticker.remove(swipeMovescrollBars);
			swipeCheck = false;
			if (hCheck) if (scrollBarFade) zim.animate(hscrollBar, {alpha:0}, scrollBar.fadeTime);
			if (vCheck) if (scrollBarFade) zim.animate(vscrollBar, {alpha:0}, scrollBar.fadeTime);
		}

		if (interactive) {
			// dispatches SELECT (click) and HOVEROVER (500 ms) and gives mouseX and mouseY on content
			// CLICKS (in the traditional sense rather than a mouseup replacement)
			var downLoc;
			var downTime;

			content.on("mousedown", function(e){stage=e.target.stage; downLoc=e.stageX/stage.scaleX; downTime=Date.now();});
			content.on("click", function(e){
				if (Date.now()-downTime<600 && Math.abs(e.stageX/stage.scaleX-downLoc)<5) {
					that.contentMouse = content.globalToLocal(e.stageX/stage.scaleX, e.stageY/stage.scaleY);
					that.dispatchEvent("select");
				}
			});
			// HOVER (must stay within thresh pixels for pauseTime ms)
			content.on("mouseover", moveOn);
			content.on("mouseout", moveOff);
			var startTime;
			function moveOn() {
				startTime=Date.now();
				zim.Ticker.add(timeMouse, content.stage);
			}
			function moveOff() {
				if (!hoverOutCalled) {
					that.dispatchEvent("hoverout");
					hoverOutCalled = true;
				}
				zim.Ticker.remove(timeMouse);
			}
			var lastMouseX = 0;
			var lastMouseY = 0;
			var lastReportX = 0;
			var lastReportY = 0;
			var pauseTime = 300;
			var thresh = 2;
			var hoverOutCalled = false;
			function timeMouse() {
				if (!content.stage) {
					if (!hoverOutCalled) {
						that.dispatchEvent("hoverout");
						hoverOutCalled = true;
					}
					zim.Ticker.remove(timeMouse);
					return;
				}
				if (Math.abs(lastMouseX-that.windowMouseX) > thresh || Math.abs(lastMouseY-that.windowMouseY) > thresh) {
					if (!hoverOutCalled) {
						that.dispatchEvent("hoverout");
						hoverOutCalled = true;
					}
					startTime=Date.now();
					lastMouseX=that.windowMouseX;
					lastMouseY=that.windowMouseY;
				} else {
					if (Date.now()-startTime > pauseTime) {
						if (Math.abs(lastReportX-that.windowMouseX) > thresh || Math.abs(lastReportY-that.windowMouseY) > thresh) {
							that.contentMouse = content.globalToLocal(that.windowMouseX, that.windowMouseY);
							that.dispatchEvent("hoverover");
							lastReportX=that.windowMouseX;
							lastReportY=that.windowMouseY;
							hoverOutCalled = false;
						}
						startTime=Date.now();
					}
				}
			}
		}

		var scrollEvent1;
		var scrollEvent2;
		var scrollEvent3;
		var desiredY = that.scrollY;
		if (scrollWheel) {
			scrollEvent1 = window.addEventListener("mousewheel", scrollWindow);
			scrollEvent2 = window.addEventListener("wheel", scrollWindow);
			scrollEvent3 = window.addEventListener("DOMMouseScroll", scrollWindow);
			function scrollWindow(e) {
				if (vCheck && that.stage && that.hitTestPoint(that.windowMouseX, that.windowMouseY) && that.contains(that.stage.getObjectUnderPoint(that.windowMouseX*that.stage.scaleX, that.windowMouseY*that.stage.scaleY))) {
					if (zot(e)) e = event;
					var delta = e.detail ? e.detail*(-19) : e.wheelDelta;
					if (zot(delta)) delta = e.deltaY*(-19);
					desiredY += delta;
					desiredY = Math.max(-that.scrollYMax, Math.min(0, desiredY))
					if (!damp) {
						that.scrollY = desiredY;
						content.stage.update();
					}
				}
			}
		}
		var dampCheck = false;
		var dampY;
		function makeDamp(obj) {
			if (damp && !dampCheck && obj.stage) {
				dampCheck = true;
				dampY = new zim.Damp(that.scrollY, damp);
				zim.Ticker.add(function() {
					if (swipeCheck) return;
					if (!zot(desiredY)) that.scrollY = dampY.convert(desiredY);
				}, obj.stage);
			}
		}

		Object.defineProperty(that, 'scrollX', {
			get: function() {
				return content.x;
			},
			set: function(value) {
				content.x = value;
				if (content.zimDragImmediate) content.zimDragImmediate(content.x, content.y);
				movescrollBars();
			}
		});

		Object.defineProperty(that, 'scrollY', {
			get: function() {
				return content.y;
			},
			set: function(value) {
				content.y = value;
				if (content.zimDragImmediate) content.zimDragImmediate(content.x, content.y);
				movescrollBars();
			}
		});

		if (style!==false) zimStyleTransforms(this, DS);
		this.clone = function(recursive) {
			if (zot(recursive)) recursive = true;
			var w = that.cloneProps(new zim.Window(width, height, backgroundColor, originalBorderColor, originalBorderWidth, padding, corner, swipe, scrollBarActive, scrollBarDrag, scrollBar.color, scrollBarAlpha, scrollBarFade, scrollBarH, scrollBarV, slide, slideDamp, slideSnap, interactive, shadowColor, shadowBlur, paddingHorizontal, paddingVertical, titleBar, titleBarColor, titleBarBackgroundColor, titleBarHeight, draggable, boundary, close, closeColor, cancelCurrentDrag, style, group, inherit));
			if (recursive) {
				that.content.cloneChildren(w.content);
				w.update();
			}
			return w;
		}

		this.dispose = function() {
			if (scrollWheel) {
				window.removeEventListener("mousewheel", scrollEvent1);
				window.removeEventListener("wheel", scrollEvent2);
				window.removeEventListener("DOMMouseScroll", scrollEvent3);
			}
			if (that.blurEvent) document.window.removeEventListener("blur", that.blurEvent);
			zim.Ticker.remove(timeMouse);
			zim.Ticker.remove(swipeMovescrollBars);
			this.zimContainer_dispose();
			return true;
		}
	}
	zim.extend(zim.Window, zim.Container, ["clone", "dispose"], "zimContainer", false);
	//-58.1

/*--
zim.Layer = function(width, height, titleBar, titleBarContainer, backgroundColor, rollBackgroundColor, selectedBackgroundColor, selectedRollBackgroundColor, color, rollColor, selectedColor, selectedRollColor, borderWidth, borderColor, dashed, transformObject, titleBarWidth, titleBarHeight, titleBarX, titleBarY, titleBarDraggable, close, closeColor, closeBackgroundColor, closeIndicatorColor, anchor, style, group, inherit)

Layer
zim class - extends a zim.Container which extends a createjs.Container

DESCRIPTION
Layer is a ZIM Container with transform controls.
ZIM transform() objects have their mousechildren turned off so they can be dragged and transformed.
This means there can be no interactivity inside the transformed object.
Layer provides a solution to nest transformed objects in transformable containers.
It does so by providing a titleBar that can be used to turn on and off the transform of the container
and allow its contents to be transformed when the transform controls of the Layer are turned off.
This is more than just hiding the transform tools but rather removing and adding them.

The Layer titleBar will always remain visible on the stage
If the Layer is moved (not by its titleBar) so that the titleBar hits the edge,
then the titleBar will become anchored to the edge (unless anchor is set to false)
This creates an independent titleBar that can be moved to any location.
The titleBarPos() method can also be used to separate the titleBar at any time.
Drop the titleBar on the top left corner of the Layer or doubleClick it to snap it back on to the layer

NOTE: Layers can be added to a Transform Manager and saved with the persist sytem.
NOTE: Layers can be added to Layers (nested) along with any other type of DisplayObject content.
NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

SEE: https://zimjs.com/explore/layer.html

EXAMPLE
// adding the Layers above the content will allow pressing Layer titleBar objects inside other Layers
// adding everything right on the stage would not allow pressing titleBars inside other Layers - either way may be best, depending on content
var content = new Container(stageW, stageH).addTo();
var layers = new Container(stageW, stageH).addTo();

// create an outer layer with two inner layers - one holding a circle and the other two circles
var layer0 = new Layer(800, 500, "LAYER 0", layers).center(content);
var layer1 = new Layer(300, 400, "LAYER 1", layers).loc(50,50,layer0);
var circle1 = new Circle(50, pink).center(layer1).transform({visible:false});
var layer2 = new Layer(300, 400, "LAYER 2", layers).pos(50,50,true,false,layer0);
var circle2 = new Circle(50, green).center(layer2).mov(0, -80).transform({visible:false});
var circle3 = new Circle(50, blue).center(layer2).mov(0, 80).transform({visible:false});

// optionally store transforms
var t = new TransformManager([layer0, layer1, layer2, circle1, circle2, circle3], "layersID");
// t.clearPersist("layersID")

layer2.titleBarPos(30,30); // position a titleBar for instance
timeout(1000, function () {
	layer2.resetTitleBar();
	layer2.turnOn();

	// if moving manually, must call resize()
	layer2.mov(30);
	layer2.resize();
	stage.update();
});
END EXAMPLE

PARAMETERS
** supports DUO - parameters or single object with properties below
** supports OCT - parameter defaults can be set with STYLE control (like CSS)
width - (default 500) the width of the Layer Container
height - (default 500) the height of the Layer Container not including the titleBar (which is not in the Container)
titleBar - (default "LAYER") a String or ZIM Label for the titleBar
titleBarContainer - (default null - ZimDefaultFrame' stage) a container for the titleBar
	can group these with other Layers and hide them all by hiding the container for instance
	this also can help layer the titleBars above the content
backgroundColor - (default #eee) the background color of the titleBar
rollBackgroundColor - (default #fff) the roll background color of the titleBar
selectedBackgroundColor - (default #666) the selected background color of the titleBar
color - (default #666) the color of the titleBar text
rollColor - (default #666) the roll color of the titleBar text
selectedColor - (default #ddd) the selected color of the titleBar text
borderWidth - (default 1) the width of the ghost outline when the Layer is not selected
	to adjust the transform controls border width use the transformObject parameter and set the borderWidth property
borderColor - (default borderColor) the color of the ghost outline when the Layer is not selected
	to adjust the transform controls border color use the transformObject parameter and set the borderColor property
dashed - (default true) the dashed of the ghost outline when the Layer is not selected
	to adjust the transform controls border dashed use the transformObject parameter and set the dashed property
transformObject - (default {borderColor:selectedBackgroundColor}) any of the transform parameters as an object literal
	certain properties are overwritten by Layer as follows:
	{events:true, visible:false, ghostColor:borderColor, ghostWidth:borderWidth, ghostDashed:dashed, ghostHidden:true}
	use the transformControls.show() to show the transform controls once the Layer is made for instance:
	timeout(100, function(){layer.transformControls.show();}); // a timeout is needed as Layer gets created - sorry.
titleBarWidth - (default 100 + 30 if close) the width of the titleBar.  30 pixels will be added if close is true
titleBarHeight - (default 40) the height of the titleBar
titleBarX - (default null) the starting x position of the titleBar - see also titleBarPos() and resetTitleBar() methods
titleBarY - (default null) the starting y position of the titleBar - see also titleBarPos() and resetTitleBar() methods
titleBarDraggable - (default true) set to false to not let the titleBar be dragged.
	this is useful with the titleBarPos() to create a stationary menu for the layers - for instance along the edge like tabs
close - (default true) - set to false to not use the close checkbox
	WARNING: without the close checkbox, the user may make the layer bigger than the stage and not be able to deselect the layer
closeColor - (default selectedBackgroundColor) the border of the close checkBox
closeBackgroundColor - (default selectedBackgroundColor) the backgroundColor of the close checkBox
closeIndicatorColor - (default selectedColor) the indicator color of the close checkBox
anchor - (default true) set to false to not anchor the titleBar to the edge if dragged with the Layer (not the titleBar)
	with anchor true, the user can dock the titleBar to the edges and then drag them to any desired location
	the user can snap the titleBar back on the layer by dropping it on the top left corner of the layer or double clicking the titleBar
style - (default true) set to false to ignore styles set with the STYLE - will receive original parameter defaults
group - (default null) set to String (or comma delimited String) so STYLE can set default styles to the group(s) (like a CSS class)
inherit - (default null) used internally but can receive an {} of styles directly

METHODS
titleBarPos(x, y, right, bottom) - position the titleBar in the titleBarContainer - returns object for chaining
	This will undock the titleBar from the Layer so it can be moved independently
	unless titleBarDraggable is set to false
	See also titleBarX and titleBarY parameters to start titleBars at a certain position
resetTitleBar() - dock the titleBar back on the Layer - returns object for chaining
toggle(state) - toggle the controls or turn on or off the controls by providing a Boolean state - returns object for chaining
resize(dispatch) - resize the Layer and its children if Layer is manually adjusted - returns object for chaining
	for instance, layer.x = 10; layer.resize(); otherwise, the transform controls are broken!
	normal layer transforming using the controls automatically resize.
	Setting dispatch to true will dispatch a "transformed" event
hasProp(property as String) - returns true if property exists on object else returns false
clone() - makes a copy with properties such as x, y, etc. also copied (returns the new waiter for chaining)
dispose() - removes from parent, removes event listeners - must still set outside references to null for garbage collection

ALSO: ZIM 4TH adds all the methods listed under Container (see above), such as:
drag(), hitTestRect(), animate(), sca(), reg(), mov(), center(), centerReg(),
addTo(), removeFrom(), loop(), outline(), place(), pos(), alp(), rot(), setMask(), etc.
ALSO: See the CreateJS Easel Docs for Container methods, such as:
on(), off(), getBounds(), setBounds(), cache(), uncache(), updateCache(), dispatchEvent(),
addChild(), removeChild(), addChildAt(), getChildAt(), contains(), removeAllChildren(), etc.

PROPERTIES
type - holds the class name as a String
transformControls - the transform transformControls object - see below for a description
anchor - get or set whether the titleBar will anchor to the edges of the titleBarContainer
toggled - read only if Layer has its transform turned on - or use transformControls.visible
	use toggle(state) to toggle controls or pass in true for show controls or false for hide controls
titleBar - access to the ZIM Container that holds the titleBar
titleBarDraggable - get or set whether the titleBar can be dragged
	use with titleBarPos() to permanently positing the titleBar
checkBox - access to the ZIM CheckBox that shows when the Layer is active and close is true
button - access to the ZIM Button that makes up the titleBar
label - access to the ZIM Label that is on the Button for the titleBar
** setting widths and heights adjusts scale not bounds and getting these uses the bounds dimension times the scale
width - gets or sets the width. Setting the width will scale the height to keep proportion (see widthOnly below)
height - gets or sets the height. Setting the height will scale the width to keep proportion (see heightOnly below)
widthOnly - gets or sets the width.  This sets only the width and may change the aspect ratio of the object
heightOnly - gets or sets the height.  This sets only the height and may change the aspect ratio of the object
blendMode - how the object blends with what is underneath - such as "difference", "multiply", etc. same as CreateJS compositeOperation
group - used when the object is made to add STYLE with the group selector (like a CSS class)

ALSO: See the transformControls property described below for more options.
ALSO: See the CreateJS Easel Docs for Container properties, such as:
x, y, rotation, scaleX, scaleY, regX, regY, skewX, skewY,
alpha, cursor, shadow, mouseChildren, mouseEnabled, parent, numChildren, etc.

TRANSFORM CONTROL OBJECT
Layer receives a transformControls property
This may be slightly delayed as Layer is prepared on stage
var layer = new Layer().center();
timeout(100, function(){zog(layer.transformControls);}); // will probably do the trick
The transformControls property holds the following:

TRANSFORM CONTROL OBJECT PROPERTIES
visible - read only whether the controls are visible
ghost - read only as to whether the ghost outline is showing - set with showGhost and hideGhost
ghostEnabled - read only as to whether the ghost outline will be turned on and off - set with addGhost and removeGhost
scaleControls - reference to the Container that holds the corner boxes for scaling
stretchXControls - reference to the Container that holds the left and right boxes for stretching
stretchYControls - reference to the Container that holds the top and bottom boxes for stretching
rotateControls - reference to the Container that holds the outer circles for rotating

TRANSFORM CONTROL OBJECT METHODS
hide() - hides the controls - returns object for chaining
show() - shows the controls - returns object for chaining
recordData(toJSON) - returns an object with type, x, y, scaleX, scaleY, rotation, skewX, skewY, visible PROPERTIES
	if toJSON (default false) is set to true, the return value is a JSON string
setData(data, fromJSON) - sets the properties to match the data object passed in - this should come from recordData()
	if fromJSON (default false) is set to true, it will assume a JSON string is passed in as data
	returns object for chaining
remove(noHide) - removes the controls - set noHide true if already hidden
add(noShow) - adds the controls back if then have been removed - set noShow true if not wanting to show
allowToggleOn() - sets the show / hide controls on with click
allowToggleOff() - removes the show / hide controls on with click
showGhost() - show the ghost outline - the ghostWidth or ghostColor must be set in initial parameters
hideGhost() - hide the ghost outline
toggleGhost(state) - if ghost is showing will hide ghost and if ghost is hidden will show ghost
	or set state to true to show ghost or false to not show ghost
addGhost() - enable ghost outline functionality - the ghostWidth or ghostColor must be set in initial parameters
removeGhost() - disable ghost outline functionality
disable() - may show the controls if visible but cannot use them
enable() - turns the using of the controls back on
resize(dispatch) - call resize if the object is transformed in ways other than with the controls
	set dispatch to true to dispatch a "transformed" event - if manually adjusted this will save to TransformManager

EVENTS
dispatches a "transformed" event when being transformed
	the transformed event object has a transformType property
	the transformType property has values of "size", "move", "rotate", "stretch", "reg", "reset"
	the transformType also might be "resize" if resize(true) is called to dispatch a transformed event
	the transformed event object also has a pressup property that is true if on pressup and null if from pressmove
dispatches "transformshow" and "transformhide" events for when click to hide or show controls
If TransformManager() is used there are more events available such as "persistset", etc.

See the CreateJS Easel Docs for Container events, such as:
added, click, dblclick, mousedown, mouseout, mouseover, pressmove, pressup, removed, rollout, rollover
--*///+58.5
	zim.Layer = function(width, height, titleBar, titleBarContainer, backgroundColor, rollBackgroundColor, selectedBackgroundColor, selectedRollBackgroundColor, color, rollColor, selectedColor, selectedRollColor, borderWidth, borderColor, dashed, transformObject, titleBarWidth, titleBarHeight, titleBarX, titleBarY, titleBarDraggable, close, closeColor, closeBackgroundColor, closeIndicatorColor, anchor, style, group, inherit) {
		var sig = "width, height, titleBar, titleBarContainer, backgroundColor, rollBackgroundColor, selectedBackgroundColor, selectedRollBackgroundColor, color, rollColor, selectedColor, selectedRollColor, borderWidth, borderColor, dashed, transformObject, titleBarWidth, titleBarHeight, titleBarX, titleBarY, titleBarDraggable, close, closeColor, closeBackgroundColor, closeIndicatorColor, anchor, style, group, inherit";
		var duo; if (duo = zob(zim.Layer, arguments, sig, this)) return duo;
		z_d("58.5");

		this.group = group;
		var DS = style===false?{}:zim.getStyle("Layer", this.group, inherit);

		if (zot(width)) width=DS.width!=null?DS.width:500;
		if (zot(height)) height=DS.height!=null?DS.height:500;

		this.zimContainer_constructor(0,0,width,height,false);
		this.type = "Layer";

		var that = this;
		that.distX = 40; // titleBar distance from top left corner of Container
		that.distY = 0;
		if (zot(titleBar)) titleBar=DS.titleBar!=null?DS.titleBar:"LAYER";
		var titleBarOriginal = titleBar;
		var titleBarText = titleBar;
		var titleBarDefault = true;

		if (zot(backgroundColor)) backgroundColor=DS.backgroundColor!=null?DS.backgroundColor:"#eee";
		if (zot(rollBackgroundColor)) rollBackgroundColor=DS.rollBackgroundColor!=null?DS.rollBackgroundColor:"#fff";
		if (zot(selectedBackgroundColor)) selectedBackgroundColor=DS.selectedBackgroundColor!=null?DS.selectedBackgroundColor:"#666";
		if (zot(color)) color=DS.color!=null?DS.color:"#666";
		if (zot(rollColor)) rollColor=DS.rollColor!=null?DS.rollColor:"#666";
		if (zot(selectedColor)) selectedColor=DS.selectedColor!=null?DS.selectedColor:"#ddd";
		if (zot(borderWidth)) borderWidth=DS.borderWidth!=null?DS.borderWidth:1;
		if (zot(borderColor)) borderColor=DS.borderColor!=null?DS.borderColor:backgroundColor;
		if (borderColor < 0 || borderWidth < 0) borderColor = borderWidth = null;
		if (zot(dashed)) dashed=DS.dashed!=null?DS.dashed:true;
		if (zot(transformObject)) transformObject=DS.titleBar!=null?DS.titleBar:null;
		if (zot(titleBarWidth)) titleBarWidth=DS.titleBarWidth!=null?DS.titleBarWidth:100;
		var originalTitleBarWidth = titleBarWidth;
		if (zot(titleBarHeight)) titleBarHeight=DS.titleBarHeight!=null?DS.titleBarHeight:40;
		if (zot(titleBarX)) titleBarX=DS.titleBarX!=null?DS.titleBarX:null;
		if (zot(titleBarY)) titleBarY=DS.titleBarY!=null?DS.titleBarY:null;
		if (zot(titleBarDraggable)) titleBarDraggable=DS.titleBarDraggable!=null?DS.titleBarDraggable:true;
		if (zot(close)) close=DS.close!=null?DS.close:true;
		if (zot(closeColor)) closeColor=DS.closeColor!=null?DS.closeColor:selectedBackgroundColor;
		if (zot(closeBackgroundColor)) closeBackgroundColor=DS.closeBackgroundColor!=null?DS.closeBackgroundColor:selectedBackgroundColor;
		if (zot(closeIndicatorColor)) closeIndicatorColor=DS.closeIndicatorColor!=null?DS.closeIndicatorColor:selectedColor;
		if (zot(anchor)) anchor=DS.anchor!=null?DS.anchor:true;
		if (!titleBarDraggable) anchor = false;
		that.anchor = anchor;
		if (close) titleBarWidth += 30;

		transformObject = zim.merge({borderColor:selectedBackgroundColor}, transformObject, {events:true, visible:false, ghostColor:borderColor, ghostWidth:borderWidth, ghostDashed:dashed, ghostHidden:true});

		// do the defaultFrame thing for the container
		if (zot(titleBarContainer)) titleBarContainer=DS.titleBarContainer!=null?DS.titleBarContainer:null;
		if (zot(titleBarContainer)) {
			if (zimDefaultFrame) {
				titleBarContainer = zimDefaultFrame.stage;
			} else {
				zog("zim Layer(): Please pass in a reference to a container with bounds set.");
				return;
			}
		}

		var downCheck = false;
		that.active = false;
		that.turnOff = function(noHide, noShow) {
			that.active = false;
			if (close) that.checkBox.visible = false;
			that.transformControls.remove();
			that.mouseChildren = true;
			that.button.backgroundColor = backgroundColor;
			that.button.rollBackgroundColor = rollBackgroundColor;
			that.button.color = color;
			that.button.rollColor = color;
			that.transformControls.allowToggleOff();
			if (that.resizeChildren) that.resizeChildren();
		}
		that.turnOn = function() {
			that.active = true;
			if (close) {
				that.checkBox.visible = true;
				that.checkBox.checked = true;
			}
			that.button.backgroundColor = selectedBackgroundColor;
			that.button.rollBackgroundColor = selectedBackgroundColor;
			that.button.color = selectedColor;
			that.button.rollColor = selectedColor;
			that.mouseChildren = false;
			that.transformControls.add();
			that.transformControls.allowToggleOn();
		}
		var stage;
		that.titleBarPos = function(x, y) {
			if (that.titleBar.pos) {
				that.titleBar.pos(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9]); // ES6 wish
				stage.update();
			} else {
				that.distX = x;
				that.distY = y;
			}
			titleBarDefault = false;
			return that;
		}
		var lastVisible = that.visible;
		that.visible = false;
		var firstControl;
		this.added(function (theStage) {
			that.transform(transformObject); // in case persist is set do this first and wait a little bit with visible false
			if (borderWidth >= 0) that.transformControls.hideGhost();
			zim.timeout(50, function () {
				function firstPoint() {return that.localToLocal(0,0,titleBarContainer);}
				that.visible = lastVisible;
				if (borderWidth >= 0) {
					zim.timeout(100, function(){
						that.transformControls.showGhost();
						stage.update();
					});
				}
				stage = theStage;
				var titleBar = that.titleBar = new zim.Container(titleBarWidth, titleBarHeight)
					.reg(0,titleBarHeight)
					.loc(that, null, titleBarContainer)
					.mov(that.distX,that.distY);

				if (titleBarDraggable) titleBar.drag({all:true, boundary:new zim.Boundary(0,titleBarHeight,titleBarContainer.width-titleBarWidth,titleBarContainer.height-titleBarHeight), localBounds:true});
				if (that.distX != 40 || that.distY !=0) {
					titleBar.pos(that.distX, that.distY);
				}
				if (close) {
					that.checkBox = new zim.CheckBox({
						borderColor:closeColor,
						backgroundColor:closeBackgroundColor,
						indicatorColor:closeIndicatorColor,
						size:20, startChecked:true
					}).center(titleBar).pos(0, null, true).change(function () {
						that.turnOff(true, true);
					});
					that.checkBox.visible = false;
				}
				titleBar.mouseChildren = true;
				titleBar.layer = that;

				that.resetTitleBar = function() {
					that.distX = 40;
					that.distY = 0;
					titleBarDefault = true;
					that.move(true);
					stage.update();
				}

				if (typeof titleBarText === "string" || typeof titleBarText === "number") titleBarText = new zim.Label({
					text:titleBarText, color:color, rollColor:rollColor, size:DS.size!=null?DS.size:18,
					group:this.group
				});
				that.label = titleBarText;
				that.label.center(titleBar);
				that.button = new zim.Button({
					shadowBlur:-1,
					width:originalTitleBarWidth, height:titleBarHeight-1, label:that.label,
					color:color,
					rollColor:rollColor,
					backgroundColor:backgroundColor,
					rollBackgroundColor:rollBackgroundColor,
					corner:(DS.corner!=null?DS.corner:0),
					inherit:DS
				}).addTo(titleBar);
				that.button.on("mousedown", function () {
					downCheck = true;
					// all other layers get turned off
					titleBarContainer.loop(function (bar) {
						if (bar && bar != titleBar && bar.layer && bar.layer.turnOff && bar.layer.active) bar.layer.turnOff(true, true);
					});
					if (!that.active) that.turnOn();
					titleBar.top();
				});
				that.button.on("pressmove", function(){matchLocation()});
				that.button.on("pressup", function () {
					matchLocation(true);
					var point = that.localToLocal(0, 0, titleBarContainer);
					that.distX = titleBar.x-point.x;
					that.distY = titleBar.y-point.y;
					titleBar.top();
					downCheck = false;
					if (!edgeCheck() && titleBarDraggable) {
						var point = that.localToGlobal(0,0);
						if (that.button.hitTestPoint(point.x, point.y)) that.resetTitleBar();
					}
				});
				function matchLocation(dispatch) {
					if (titleBarDefault && titleBarDraggable) {
						var desiredTopLeft = titleBarContainer.localToLocal(titleBar.x-that.distX, titleBar.y-that.distY, that.parent);
						var regPoint = that.localToLocal(that.regX, that.regY, that.parent);
						var topLeft = that.localToLocal(0,0,that.parent);
						that.x =  desiredTopLeft.x + (regPoint.x-topLeft.x);
						that.y =  desiredTopLeft.y + (regPoint.y-topLeft.y);
						that.transformControls.resize(dispatch); // TransformManager saves all objects any time a single object changes
						recursiveLocation(that);
					}
				}
				function recursiveLocation(obj) {
					obj.loop(function (o) {
						if (o.type == "Layer") {
							if (that.titleBarDraggable) o.move();
							if (o.transformControls.ghost) o.transformControls.resize(); // to move ghost
							recursiveLocation(o);
						}
					});
				}
				that.button.on("dblclick", function () {
					if (titleBarDraggable) that.resetTitleBar();
				});

				that.turnOff();
				that.on("transformed", function (e) {
					if (e.transformType=="move" || e.transformType=="size" || e.transformType=="stretch" || e.transformType=="rotate") {
						if (titleBarDraggable) that.move();
						recursiveLocation(that);
					}
				});
				function edgeCheck() {
					if (titleBar.x == 0) return true;
					if (titleBar.y == titleBar.height) return true;
					if (titleBar.x == titleBarContainer.width-titleBar.width) return true;
					if (titleBar.y == titleBarContainer.height) return true;
				}
				that.move = function(override) {
					if (!override && !titleBarDefault && that.anchor) {
						if (edgeCheck()) return;
					}
					titleBar.loc(firstPoint()).mov(that.distX, that.distY);
					if (titleBar.x < 0) {titleBarDefault=false; titleBar.x = 0;}
					if (titleBar.y < titleBar.height) {titleBarDefault=false; titleBar.y = titleBar.height;}
					if (titleBar.x > titleBarContainer.width-titleBar.width) {titleBarDefault=false; titleBar.x = titleBarContainer.width-titleBar.width;}
					if (titleBar.y > titleBarContainer.height) {titleBarDefault=false; titleBar.y =titleBarContainer.height}
					if (!that.anchor) titleBarDefault = true;
				}
				that.on("transformhide", function() {
					that.turnOff(true, true);
					titleBarContainer.loop(function (bar) {
						if (bar && bar != titleBar && bar.layer && bar.layer.turnOff && bar.layer.active) bar.layer.turnOff();
					});
				});
				that.resizeChildren = function(dispatch) {
					that.transformControls.resize(dispatch);
					// if (that.transformControls.visible) that.transformControls.hide();
					that.loop(function (obj) {
						if (obj.transformControls) {
							if (obj.transformControls.visible) obj.transformControls.hide();
							if (obj.type == "Layer") {
								obj.resizeChildren();
							} else {
								obj.transformControls.resize();
							}
						}
					});
				}
				that.resize = function(dispatch) {
                    that.move();
                    that.resizeChildren(dispatch);
					return that;
                }
				that.toggled = false;
				function setToggled() {
					if (that.toggled) {
						titleBarContainer.loop(function (bar) {
							if (bar && bar != titleBar && bar.layer && bar.layer.turnOff && bar.layer.active) bar.layer.turnOff();
						});
						that.turnOn();
					} else {
						titleBar.top();
						that.turnOff();
						titleBarContainer.loop(function (bar) {
							if (bar && bar != titleBar && bar.layer && bar.layer.turnOff && bar.layer.active) bar.layer.turnOff();
						});
					}
					if (that.stage) that.stage.update();
				}
				that.toggle = function(state) {
					if (zot(state)) {
						that.toggled = !that.toggled;
					} else {
						that.toggled = state;
					}
					setToggled();
					return that;
				}
				Object.defineProperty(that, 'titleBarDraggable', {
					get: function() {
						return titleBarDraggable;
					},
					set: function(value) {
		                titleBarDraggable = value;
						if (titleBarDraggable) titleBar.drag({all:true, boundary:zim.Boundary(0,40,titleBarContainer.width-titleBarWidth,titleBarContainer.height-titleBarHeight), localBounds:true})
						else titleBar.noDrag();
					}
				});
				stage.on("stagemouseup", function () {
					if (that.transformControls.visible) titleBar.top();
				});
				if (!zot(titleBarX) || !zot(titleBarY)) {
					titleBarDefault = false;
					var x = !zot(titleBarX)?titleBarX:titleBar.x;
					var y = !zot(titleBarY)?titleBarY:titleBar.y-titleBarHeight;
					that.titleBarStartX = titleBarX;
					that.titleBarStartY = titleBarY;
					that.titleBarPos(x,y);
					var point = that.parent.localToLocal(that.x, that.y, titleBarContainer);
					that.distX = titleBar.x-point.x;
					that.distY = titleBar.y-point.y;
				}
			}); // end timeout
		}); // end added

		if (style!==false) zimStyleTransforms(this, DS);
		this.clone = function() {
			return that.cloneProps(new zim.Layer(width, height, titleBarOriginal, titleBarContainer, backgroundColor, rollBackgroundColor, selectedBackgroundColor, selectedRollBackgroundColor, color, rollColor, selectedColor, selectedRollColor, borderWidth, borderColor, dashed, transformObject, originalTitleBarWidth, titleBarHeight, titleBarX, titleBarY, titleBarDraggable, close, closeColor, closeBackgroundColor, closeIndicatorColor, anchor, style, this.group, inherit));
		}

		this.dispose = function() {
			that.transformControls.remove();
			that.transformControls.disable();
			this.zimContainer_dispose();
			return true;
		}
	}
	zim.extend(zim.Layer, zim.Container, ["clone", "dispose"], "zimContainer", false);
	//-58.5

/*--
zim.Waiter = function(container, speed, foregroundColor, backgroundColor, corner, shadowColor, shadowBlur, fadeTime, style, group, inherit)

Waiter
zim class - extends a zim.Container which extends a createjs.Container

DESCRIPTION
Adds a little animated three dot wait widget.
You need to call waiter.show() to show the waiter and waiter.hide() to hide it.
You do not need to add it to the stage - it adds itself centered.
You can change the x and y (with origin and registration point in middle).

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var waiter = new Waiter(stage);
waiter.show(); // show the waiter until assets load
frame.loadAssets("greeting.mp3");
frame.on("complete", function() {
	waiter.hide();
	frame.asset("greeting.mp3").play();
});
END EXAMPLE

PARAMETERS
** supports DUO - parameters or single object with properties below
** supports OCT - parameter defaults can be set with STYLE control (like CSS)
container - (default first frame's stage) the container that holds the waiter
speed - (default 600) cycle time in milliseconds
backgroundColor - (default "orange") the background color
foregroundColor - (default "white") the dot color
corner - (default 14) the corner radius of the waiter box
	can also be an array of [topLeft, topRight, bottomRight, bottomLeft]
shadowColor - (defaults rgba(0,0,0,.3)) set to -1 for no shadow
shadowBlur - (default 14) the blur of the shadow if shadow is set
fadeTime - (default 0) milliseconds to fade in and out
style - (default true) set to false to ignore styles set with the STYLE - will receive original parameter defaults
group - (default null) set to String (or comma delimited String) so STYLE can set default styles to the group(s) (like a CSS class)
inherit - (default null) used internally but can receive an {} of styles directly

METHODS
show() - shows the waiter (returns the waiter for chaining)
hide() - hides the waiter
toggle(state - default null) - shows waiter if hidden and hides waiter if showing (returns the object for chaining)
	or pass in true to show waiter or false to hide waiter
hasProp(property as String) - returns true if property exists on object else returns false
clone() - makes a copy with properties such as x, y, etc. also copied (returns the new waiter for chaining)
dispose() - removes from parent, removes event listeners - must still set outside references to null for garbage collection

ALSO: ZIM 4TH adds all the methods listed under Container (see above), such as:
drag(), hitTestRect(), animate(), sca(), reg(), mov(), center(), centerReg(),
addTo(), removeFrom(), loop(), outline(), place(), pos(), alp(), rot(), setMask(), etc.
ALSO: See the CreateJS Easel Docs for Container methods, such as:
on(), off(), getBounds(), setBounds(), cache(), uncache(), updateCache(), dispatchEvent(),
addChild(), removeChild(), addChildAt(), getChildAt(), contains(), removeAllChildren(), etc.

PROPERTIES
type - holds the class name as a String
display - reference to the waiter backing graphic
** setting widths and heights adjusts scale not bounds and getting these uses the bounds dimension times the scale
width - gets or sets the width. Setting the width will scale the height to keep proportion (see widthOnly below)
height - gets or sets the height. Setting the height will scale the width to keep proportion (see heightOnly below)
widthOnly - gets or sets the width.  This sets only the width and may change the aspect ratio of the object
heightOnly - gets or sets the height.  This sets only the height and may change the aspect ratio of the object
blendMode - how the object blends with what is underneath - such as "difference", "multiply", etc. same as CreateJS compositeOperation
group - used when the object is made to add STYLE with the group selector (like a CSS class)

ALSO: See the CreateJS Easel Docs for Container properties, such as:
x, y, rotation, scaleX, scaleY, regX, regY, skewX, skewY,
alpha, cursor, shadow, mouseChildren, mouseEnabled, parent, numChildren, etc.

EVENTS
See the CreateJS Easel Docs for Container events, such as:
added, click, dblclick, mousedown, mouseout, mouseover, pressmove, pressup, removed, rollout, rollover
--*///+59
	zim.Waiter = function(container, speed, foregroundColor, backgroundColor, corner, shadowColor, shadowBlur, fadeTime, style, group, inherit) {
		var sig = "container, speed, foregroundColor, backgroundColor, corner, shadowColor, shadowBlur, fadeTime, style, group, inherit";
		var duo; if (duo = zob(zim.Waiter, arguments, sig, this)) return duo;
		z_d("59");
		this.zimContainer_constructor(null,null,null,null,false);
		this.type = "Waiter";
		this.group = group;
		var DS = style===false?{}:zim.getStyle(this.type, this.group, inherit);

		if (zot(speed)) speed=DS.speed!=null?DS.speed:600; // ms cycle time
		if (zot(foregroundColor)) foregroundColor=DS.foregroundColor!=null?DS.foregroundColor:"white";
		if (zot(backgroundColor)) backgroundColor=DS.backgroundColor!=null?DS.backgroundColor:"orange";
		if (zot(corner)) corner=DS.corner!=null?DS.corner:16;
		if (zot(shadowColor)) shadowColor=DS.shadowColor!=null?DS.shadowColor:"rgba(0,0,0,.3)";
		if (zot(shadowBlur)) shadowBlur=DS.shadowBlur!=null?DS.shadowBlur:14;
		if (zot(fadeTime)) fadeTime=DS.fadeTime!=null?DS.fadeTime:0;

		var height = 40;
		var numDots = 3;
		var r = height*.6/2;
		var s = (height-r*2)/2;
		var width = numDots*(r*2+s)+s;

		this.setBounds(-width/2,-height/2, width, height);

		var that = this;

		var display = this.display = new zim.Shape({style:false});
		this.addChild(display);
		display.setBounds(0, 0, width, height);
		display.regX = width/2;
		display.regY = height/2;
		var g = display.graphics;
		g.f(backgroundColor);
		var cc = corner;
		if (!Array.isArray(cc)) cc = [corner, corner, corner, corner];
		g.rc(0, 0, width, height, cc[0], cc[1], cc[2], cc[3]);
		if (shadowColor != -1 && shadowBlur > 0) display.shadow = new createjs.Shadow(shadowColor, 3, 3, shadowBlur);
		display.on("click", function(e) {
			// stops the click from going through the display to the background
			e.stopImmediatePropagation();
		});

		var circles = new zim.Container({style:false});
		this.addChild(circles);

		var dot;
		for (var i=0; i<numDots; i++) {
			dot = new createjs.Shape();
			dot.graphics.f(foregroundColor).dc(0,0,r);
			dot.x = (i-(numDots-1)/2) * (r*2+s);
			circles.addChild(dot);
			dot.cache(-r,-r,r*2,r*2);
			dot.alpha = 0;
		}

		this.hide = function() {
			if (fadeTime > 0) {
				that.animate({obj:{alpha:0}, time:fadeTime, call:end});
			} else {
				end();
			}
			function end() {
				if (that.parent) that.parent.removeChild(that);
				var stage = that.stage;
				if (stage) stage.update();
				if (that.zimAccessibility) {
					var a = that.zimAccessibility;
					a.resize(that);
					if (accessibilityClicker) accessibilityClicker.focus();
					else that.zimTabTag.nextSibling.focus();
					setTimeout(function() {a.talk("Waiter has finished.");}, 50);
				}
			}
			that.toggled = false;
			return that;
		}
		var accessibilityClicker;
		var timeouts = [];
		this.show = function() {
			var mess = "zim display - Waiter(): Please pass in a reference to a container with bounds set as first parameter to Waiter";
			if (zot(container)) {
				if (zimDefaultFrame) {
					container = zimDefaultFrame.stage;
				} else {
					zog(mess);
					return;
				}
			} else if (!container.getBounds) {
				zog(mess);
				return;
			} else if (zot(container.stage)) {
				zog("zim display - Waiter(): The container must have a stage property");
				return;
			}
			var dot; var counter=0;
			for (var i=0; i<circles.numChildren; i++) {
				if (circles) {
					timeouts.push(setTimeout(function() {
						dot = circles.getChildAt(counter);
						createjs.Tween.get(dot,{loop:true})
							.to({alpha:1}, speed/numDots/2)
							.wait(speed/numDots)
							.to({alpha:0}, speed/numDots)
							.wait(speed-speed/numDots-speed/numDots/2);
						counter++;
					}, i*speed/numDots));
				}
			}
			that.ticker = createjs.Ticker.on("tick", function() {container.stage.update();});

			that.x = (container.getBounds().width) /2;
			that.y = (container.getBounds().height) /2;
			container.addChild(that);
			if (fadeTime > 0) {
				that.alpha = 0;
				that.animate({alpha:1}, fadeTime);
			}
			if (that.zimAccessibility) {
				var a = that.zimAccessibility;
				setTimeout(function(){if (a.activatedObject) accessibilityClicker = a.activatedObject.zimTabTag;}, 50);
				a.resize(that);
				a.talk(that.zimTabTag.getAttribute("aria-label"));
			}
			that.toggled = true;
			return that;
		}
		that.toggle = function(state) {
			if (state===true) that.show();
			else if (state===false) that.hide();
			else if (that.parent) that.hide();
			else that.show();
			return that;
		}

		if (style!==false) zimStyleTransforms(this, DS);
		this.clone = function() {
			return that.cloneProps(new zim.Waiter(container, speed, foregroundColor, backgroundColor, corner, shadowColor, shadowBlur, fadeTime, style, this.group, inherit));
		}

		this.dispose = function() {
			if (that.ticker) createjs.Ticker.off("tick", that.ticker);
			createjs.Tween.removeTweens(that);
			that.removeFrom();
			for (var i=0; i<circles.numChildren; i++) {
				var circle = circles.getChildAt(i);
				clearInterval(timeouts[i]);
				createjs.Tween.removeTweens(circle);
			}
			this.zimContainer_dispose();
			return true;
		}
	}
	zim.extend(zim.Waiter, zim.Container, ["clone", "dispose"], "zimContainer", false);
	//-59

/*--
zim.ProgressBar = function(barType, foregroundColor, backgroundColor, borderColor, borderWidth, padding, label, color, labelPosition, percentage, corner, shadowColor, shadowBlur, backing, delay, fastClose, container, autoHide, style, group, inherit)

ProgressBar
zim class - extends a zim.Container which extends a createjs.Container

DESCRIPTION
Adds a little progress bar that can be scaled if desired
Pass in to progress parameter of the Frame or LoadAssets call to operate
or use on its own with the show(), hide() methods and percent property

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var progressBar = new ProgressBar();
frame.loadAssets({assets:"greeting.mp3", progress:progressBar});
// a bar will be centered on the default stage (or specify a container)
// the bar will show a percentage of asset bytes loaded
frame.on("complete", function() {
	// the bar will be removed when loading is complete
	frame.asset("greeting.mp3").play();
});
END EXAMPLE

PARAMETERS
** supports DUO - parameters or single object with properties below
** supports OCT - parameter defaults can be set with STYLE control (like CSS)
barType - (default "circle") set "rectangle" for rectangular progress bar
foregroundColor - (default green) the color of the bar
backgroundColor - (default dark) the color of the background
borderColor - (default backgroundColor) the color of the border - for "rectangle" barType
borderWidth - (default 10 "circle" or 0 "rectangle") the width of the border (or ring for "circle" barType)
padding - (default 2 for "circle" or 0 for "rectangle") the space between the bar and the backing
label - (null) set to a String or a ZIM Label to specifify label properties
color - (default foregroundColor) the color of the label if there is one
labelPosition - ("bottom" if label specified) also set to "top" to move label above progress bar
percentage - (default false) set to true to show percentage after label (set label to "" for only percentage)
corner - (default 15 for "rectangle" barType) set to 0 for square corners, etc.
	can also be an array of [topLeft, topRight, bottomRight, bottomLeft]
shadowColor - (default rgba(0,0,0,.3)) set to -1 for no shadow
shadowBlur - (default 14) the blur of the shadow if shadow is set
backing - (default null) a Display object for the backing of the "rectangle" barType (eg. Shape, Bitmap, Container, Sprite)
    See ZIM Pizzazz 3 - for patterns - these have a type of "Pattern" which makes them special
    If a "pattern" is used then the normal backing will be used to mask the pattern
delay - (default 100) milliseconds to delay view of progress bar - helps not flash progress bar when content is cached
fastClose - (default true) hide as soon as progress is done
	The complete event is delayed slightly after the progress bar is loaded
	Set to false to wait until the complete event triggers before removing the progress bar
container - (defaultFrame's stage) or specify a container to hold the progress bar
autoHide - (default true) set to false so bar does not hide when reaching 100%
style - (default true) set to false to ignore styles set with the STYLE - will receive original parameter defaults
group - (default null) set to String (or comma delimited String) so STYLE can set default styles to the group(s) (like a CSS class)
inherit - (default null) used internally but can receive an {} of styles directly

METHODS
show() - shows the progress bar (returns the progress bar for chaining)
hide() - hides the progress bar
toggle(state - default null) - shows progress bar if hidden and hides progress bar if showing (returns the object for chaining)
	or pass in true to show progress bar or false to hide progress bar
setBacking(backing) - change the backing of the progress bar
hasProp(property as String) - returns true if property exists on object else returns false
clone() - makes a copy with properties such as x, y, etc. also copied (returns the new waiter for chaining)
dispose() - removes from parent, removes event listeners - must still set outside references to null for garbage collection

ALSO: ZIM 4TH adds all the methods listed under Container (see above), such as:
drag(), hitTestRect(), animate(), sca(), reg(), mov(), center(), centerReg(),
addTo(), removeFrom(), loop(), outline(), place(), pos(), alp(), rot(), setMask(), etc.
ALSO: See the CreateJS Easel Docs for Container methods, such as:
on(), off(), getBounds(), setBounds(), cache(), uncache(), updateCache(), dispatchEvent(),
addChild(), removeChild(), addChildAt(), getChildAt(), contains(), removeAllChildren(), etc.

PROPERTIES
type - holds the class name as a String
percent - get or set the percent (0-100) complete of the progress bar
label - reference to the label if there is one
backing - reference to the backing shape.  This may be the backing DisplayObject if provided
	the backing will have a pattern property if a pattern is set for the backing
bar - reference to the bar shape
toggled - read-only Boolean that is true if progress bar is showing otherwise false
** setting widths and heights adjusts scale not bounds and getting these uses the bounds dimension times the scale
width - gets or sets the width. Setting the width will scale the height to keep proportion (see widthOnly below)
height - gets or sets the height. Setting the height will scale the width to keep proportion (see heightOnly below)
widthOnly - gets or sets the width.  This sets only the width and may change the aspect ratio of the object
heightOnly - gets or sets the height.  This sets only the height and may change the aspect ratio of the object
display - reference to the waiter backing graphic
blendMode - how the object blends with what is underneath - such as "difference", "multiply", etc. same as CreateJS compositeOperation

ALSO: See the CreateJS Easel Docs for Container properties, such as:
x, y, rotation, scaleX, scaleY, regX, regY, skewX, skewY,
alpha, cursor, shadow, mouseChildren, mouseEnabled, parent, numChildren, etc.
group - used when the object is made to add STYLE with the group selector (like a CSS class)

EVENTS
See the CreateJS Easel Docs for Container events, such as:
added, click, dblclick, mousedown, mouseout, mouseover, pressmove, pressup, removed, rollout, rollover
--*///+59.5
	zim.ProgressBar = function(barType, foregroundColor, backgroundColor, borderColor, borderWidth, padding, label, color, labelPosition, percentage, corner, shadowColor, shadowBlur, backing, delay, fastClose, container, autoHide, style, group, inherit) {
		var sig = "barType, foregroundColor, backgroundColor, borderColor, borderWidth, padding, label, color, labelPosition, percentage, corner, shadowColor, shadowBlur, backing, delay, fastClose, container, autoHide, style, group, inherit";
		var duo; if (duo = zob(zim.ProgressBar, arguments, sig, this)) return duo;
		z_d("59.5");
		this.zimContainer_constructor(null,null,null,null,false);
		this.type = "ProgressBar";
		this.group = group;
		var DS = style===false?{}:zim.getStyle(this.type, this.group, inherit);

		if (zot(foregroundColor)) foregroundColor=DS.foregroundColor!=null?DS.foregroundColor:"#acd241";
		if (zot(backgroundColor)) backgroundColor=DS.backgroundColor!=null?DS.backgroundColor:"#444";
		if (zot(borderColor)) borderColor = DS.borderColor!=null?DS.borderColor:backgroundColor;
		if (zot(borderWidth)) borderWidth = DS.borderWidth!=null?DS.borderWidth:null;
		if (zot(labelPosition)) labelPosition=DS.labelPosition!=null?DS.labelPosition:"bottom";
		if (zot(barType)) barType=DS.barType!=null?DS.barType:"circle";
		if (zot(padding)) padding=DS.padding!=null?DS.padding:(barType=="circle"?2:-.5);
		if (zot(corner)) corner=DS.corner!=null?DS.corner:15;
		if (zot(shadowColor)) shadowColor=DS.shadowColor!=null?DS.shadowColor:"rgba(0,0,0,.3)";
		if (zot(shadowBlur)) shadowBlur=DS.shadowBlur!=null?DS.shadowBlur:14;
		if (zot(backing)) backing=DS.backing!=null?DS.backing.clone():null;
		if (zot(fastClose)) fastClose=DS.fastClose!=null?DS.fastClose:true;
		if (borderColor < 0 || borderWidth < 0) borderColor = borderWidth = null;
		else if (borderColor!=null && borderWidth==null) {
			if (barType == "circle") borderWidth = 10;
			else borderWidth = 2;
		}
		if (zot(delay)) delay= DS.delay!=null?DS.delay:100;
		if (zot(autoHide)) autoHide= DS.autoHide!=null?DS.autoHide:true;
		if (zot(label)) label = DS.label!=null?DS.label:null;
		if (zot(color)) color=DS.color!=null?DS.color:foregroundColor;

		if (typeof label === "string" || typeof label === "number") label = new zim.Label({
			text:label, color:color,
			backing:"ignore", shadowColor:"ignore", shadowBlur:"ignore", padding:"ignore", backgroundColor:"ignore",
			group:this.group
		});
		var emptyLabel = false;
		if (label && label.text == "") emptyLabel = true;
		if (!zot(percentage) && zot(label)) label = new zim.Label("");
		this.label = label;

		var height = 30;
		var that = this;
		var _percent = 0;

		that.visible = false;
		setTimeout(function(){that.visible = true; if (that.stage) that.stage.update();}, delay);

		if (barType == "circle") {
			var width = 20;
			var backing = this.backing = new zim.Circle(width, "rgba(0,0,0,0)", backgroundColor, borderWidth, null, null, null, false).addTo(this);
			var bar = this.bar = new zim.Shape({style:false}).addTo(that).pos({x:backing.x, y:backing.y, reg:true}).rot(-90);
		} else {
			var width = 200;
			if (shadowColor != -1 && shadowBlur > 0) {
				var shadowRect = new zim.Rectangle(width-2, height-2, backgroundColor, null, null, corner, null, null, false).addTo(this);
				shadowRect.shadow = new createjs.Shadow(shadowColor, 3, 3, shadowBlur);
			}
			var backing = doBacking(backing);

			var cc = corner;
			if (!Array.isArray(cc)) cc = [corner, corner, corner, corner];
			var cAdjust = (padding+borderWidth/2)*1.2;
			var bar = this.bar = new zim.Rectangle(width-(padding+borderWidth/2)*1.8, height-(padding+borderWidth/2)*1.8, foregroundColor, null, null, [cc[0]-cAdjust,cc[1]-cAdjust,cc[2]-cAdjust,cc[3]-cAdjust], null, null, false).center(this);
			var mask = this.mask = new zim.Rectangle(width-(padding+borderWidth/2)*1.8, height-(padding+borderWidth/2)*1.8, null, null, null, null, null, null, false).center(this).alp(0).sca(0,1);
			bar.setMask(mask);
		}

		function doBacking(newBacking) {
			if (that.backing) {
				var index = that.getChildIndex(that.backing);
				that.removeChild(that.backing);
			} else {
				var index = that.numChildren; // may or may not be shadow rect
			}
			if (that.border) that.removeChild(that.border);
			if (!zot(newBacking) && newBacking.type == "Pattern") {
				var pattern = newBacking;
				var newBacking = that.backing = new zim.Rectangle(width, height, backgroundColor, null, null, corner, null, null, false).addTo(that, index);
				newBacking.pattern = pattern;
				pattern.center(newBacking);
				var bounds = newBacking.getBounds();
				pattern.setMask(newBacking.shape);
				if (borderWidth) var border = that.border = new zim.Rectangle(width, height, "rgba(0,0,0,0)", borderColor, borderWidth, corner, null, null, false).addTo(that, index+1);
			} else {
				var newBacking = that.backing = zot(newBacking) ? new zim.Rectangle(width, height, backgroundColor, borderColor, borderWidth, corner, null, null, false).addTo(that, index) : backing.addTo(that, index);
			}
			return newBacking;
		}

		that.setBacking = function(backing) {
			doBacking(backing);
			if (that.stage) that.stage.update();
		}

		backing.on("click", function(e) {
			// stops the click from going through the display to the background
			e.stopImmediatePropagation();
		});

		if (!zot(label)) {
			label.scaleX = label.scaleY = .8;
			label.startText = label.text;
			if (!zot(percentage)) label.text = label.startText + "  0%";
			label.center(that);
			if (labelPosition == "above") {
				label.y -= 60;
			} else {
				label.y += 60;
			}
			label.alpha = .8;
		}

		this.hide = function() {
			var stage = that.stage;
			if (that.parent) that.parent.removeChild(that);
			if (that.backing.type == "Pattern" && that.backing.pauseInterval) that.backing.pauseInterval();
			if (stage) stage.update();
			if (that.zimAccessibility) {
				var a = that.zimAccessibility;
				a.resize(that);
				if (accessibilityClicker) accessibilityClicker.focus();
				else that.zimTabTag.nextSibling.focus();
				setTimeout(function() {a.talk("Progress Bar has finished.");}, 50);
			}
			that.toggled = false;
			return that;
		}
		var accessibilityClicker;
		var waiterTimeout;
		this.show = function() {
			var mess = "zim display - ProgressBar(): Please pass in a reference to a container with bounds set as first parameter of the ProgressBar";
			if (zot(container)) {
				if (zimDefaultFrame) {
					container = zimDefaultFrame.stage;
				} else {
					zog(mess);
					return;
				}
			} else if (!container.getBounds) {
				zog(mess);
				return;
			} else if (zot(container.stage)) {
				zog("zim display - Waiter(): The container must have a stage property");
				return;
			}
			if (that.timeOut) clearTimeout(that.timeOut);
			changePercent(0);
			if (that.zimActiveLoader) {
				that.zimActiveLoader.on("progress", function(e) {
					_percent = e.progress*100;
					changePercent(_percent);
				});
			}
			that.center(container);

			if (that.backing.type == "Pattern" && that.backing.pauseInterval) that.backing.pauseInterval(false);

			if (that.zimAccessibility) {
				var a = that.zimAccessibility;
				setTimeout(function(){if (a.activatedObject) accessibilityClicker = a.activatedObject.zimTabTag;}, 50);
				a.resize(that);
				a.talk(that.zimTabTag.getAttribute("aria-label"));
			}
			that.toggled = true;
			return that;
		}
		that.toggle = function(state) {
			if (state===true) that.show();
			else if (state===false) that.hide();
			else if (that.parent) that.hide();
			else that.show();
			return that;
		}

		function changePercent(amount) {
			if (barType == "circle") {
				bar.graphics
					.c()
					.mt(0, 0)
					.s(foregroundColor)
					.ss(borderWidth-padding*2+.5)
					.a(0, 0, width, 0, 360*amount/100*Math.PI/180);
			} else {
				mask.sca(amount/100, 1);
				bar.setMask(mask);
			}
			if (!zot(percentage)) label.text = label.startText + " " + Math.min(Math.round(amount), 100) + "%";
			if (autoHide && fastClose && Math.round(amount) >= 100) that.timeOut = setTimeout(function(){that.hide();}, 200);
			if (that.stage) that.stage.update();
		}

		Object.defineProperty(that, 'percent', {
			get: function() {
				return _percent;
			},
			set: function(value) {
				_percent = value
				changePercent(value);
			}
		});

		if (style!==false) zimStyleTransforms(this, DS);
		this.clone = function() {
			return that.cloneProps(new zim.ProgressBar(barType, foregroundColor, backgroundColor, borderColor, borderWidth, padding, label, color, labelPosition, percentage, corner, shadowColor, shadowBlur, backing, delay, fastClose, container, autoHide, style, this.group, inherit));
		}

		this.dispose = function() {
			if (that.backing.type == "Pattern" && that.backing.clearInterval) that.backing.clearInterval();
			this.zimContainer_dispose();
			return true;
		}
	}
	zim.extend(zim.ProgressBar, zim.Container, ["clone", "dispose"], "zimContainer", false);
	//-59.5

/*--
zim.Indicator = function(width, height, num, foregroundColor, backgroundColor, borderColor, borderWidth, backdropColor, corner, indicatorType, fill, scale, lightScale, press, shadowColor, shadowBlur, style, group, inherit)

Indicator
zim class - extends a zim.Container which extends a createjs.Container

DESCRIPTION
A row of dots or squares that can be used to indicate a step, page, level, score, etc.
The indicator can be used as an input as well but often these are small so may not be best to rely on.

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var lights = new Indicator({fill:true});
lights.selectedIndex = 0; // set the first light on
lights.center(stage);
stage.on("stagemousedown", function() {
	// increase the indicator lights each click (then start over)
	lights.selectedIndex = (lights.selectedIndex+1) % lights.num;
});
stage.update();
END EXAMPLE

PARAMETERS
** supports DUO - parameters or single object with properties below
** supports OCT - parameter defaults can be set with STYLE control (like CSS)
width - (default 100) width of indicator
height - (default 50) height of indicator
num - (default 6) the number of lights
foregroundColor - (default "orange") color of the light(s) turned on
backgroundColor - (default "grey") color of the light(s) turned off
borderColor - (default -1 for no border) border color of lights and backdrop (if backdrop)
borderWidth - (default 1 if stroke is set) the size of the stroke in pixels
backdropColor - (default -1 for no backdrop) backdrop rectangle around lights
corner - (default 0) the corner radius if there is a backdropColor provided
	can also be an array of [topLeft, topRight, bottomRight, bottomLeft]
indicatorType - (default "dot" or "circle") can also be "box" or "square"
fill - (default false) set to true to fill in lights to the left of the selectedIndex
scale - (default 1) for all the lights including spacing
lightScale - (default 1) scale for each light - keeping the spacing unchanged
press - (default false) set to true to make lights clickable
shadowColor - (default rgba(0,0,0,.3)) set to -1 for no shadow
shadowBlur - (default 5) the shadow blur if shadow is set
style - (default true) set to false to ignore styles set with the STYLE - will receive original parameter defaults
group - (default null) set to String (or comma delimited String) so STYLE can set default styles to the group(s) (like a CSS class)
inherit - (default null) used internally but can receive an {} of styles directly

METHODS
hasProp(property as String) - returns true if property exists on object else returns false
clone() - makes a copy with properties such as x, y, etc. also copied
dispose() - removes from parent, removes event listeners - must still set outside references to null for garbage collection

ALSO: ZIM 4TH adds all the methods listed under Container (see above), such as:
drag(), hitTestRect(), animate(), sca(), reg(), mov(), center(), centerReg(),
addTo(), removeFrom(), loop(), outline(), place(), pos(), alp(), rot(), setMask(), etc.
ALSO: See the CreateJS Easel Docs for Container methods, such as:
on(), off(), getBounds(), setBounds(), cache(), uncache(), updateCache(), dispatchEvent(),
addChild(), removeChild(), addChildAt(), getChildAt(), contains(), removeAllChildren(), etc.

PROPERTIES
type - holds the class name as a String
selectedIndex - gets or sets the current index of the indicator
** setting widths and heights adjusts scale not bounds and getting these uses the bounds dimension times the scale
width - gets or sets the width. Setting the width will scale the height to keep proportion (see widthOnly below)
height - gets or sets the height. Setting the height will scale the width to keep proportion (see heightOnly below)
widthOnly - gets or sets the width.  This sets only the width and may change the aspect ratio of the object
heightOnly - gets or sets the height.  This sets only the height and may change the aspect ratio of the object
num - the assigned num value (how many light objects) (read only)
backdrop - gives access to the backdrop if there is one Rectangle
lights - an array of the light objects (zim Circle or Rectangle objects)
lightsContainer - gives access to the lights createjs.Container with its Circle or Rectangle children
enabled - set to false to disable component
blendMode - how the object blends with what is underneath - such as "difference", "multiply", etc. same as CreateJS compositeOperation
group - used when the object is made to add STYLE with the group selector (like a CSS class)

ALSO: See the CreateJS Easel Docs for Container properties, such as:
x, y, rotation, scaleX, scaleY, regX, regY, skewX, skewY,
alpha, cursor, shadow, mouseChildren, mouseEnabled, parent, numChildren, etc.

EVENTS
dispatches a "change" event if press is true and indicator is pressed on and lights change

ALSO: See the CreateJS Easel Docs for Container events, such as:
added, click, dblclick, mousedown, mouseout, mouseover, pressmove, pressup, removed, rollout, rollover
--*///+60
	zim.Indicator = function(width, height, num, foregroundColor, backgroundColor, borderColor, borderWidth, backdropColor, corner, indicatorType, fill, scale, lightScale, press, shadowColor, shadowBlur, style, group, inherit) {
		var sig = "width, height, num, foregroundColor, backgroundColor, borderColor, borderWidth, backdropColor, corner, indicatorType, fill, scale, lightScale, press, shadowColor, shadowBlur, style, group, inherit";
		var duo; if (duo = zob(zim.Indicator, arguments, sig, this)) return duo;
		z_d("60");
		this.zimContainer_constructor(null,null,null,null,false);
		this.type = "Indicator";
		this.group = group;
		var DS = style===false?{}:zim.getStyle(this.type, this.group, inherit);

		if (zot(width)) width = DS.width!=null?DS.width:300;
		if (zot(height)) height = DS.height!=null?DS.height:50;
		if (zot(num)) num = DS.num!=null?DS.num:6;
		if (zot(foregroundColor)) foregroundColor = DS.foregroundColor!=null?DS.foregroundColor:"#f58e25";
		if (zot(backgroundColor)) backgroundColor = DS.backgroundColor!=null?DS.backgroundColor:"#666";
		if (backgroundColor < 0) backgroundColor = DS.backgroundColor!=null?DS.backgroundColor:"rgba(0,0,0,.01)";
		if (zot(borderColor)) borderColor = DS.borderColor!=null?DS.borderColor:null;
		if (zot(borderWidth)) borderWidth = DS.borderWidth!=null?DS.borderWidth:null;
		if (borderColor < 0 || borderWidth < 0) borderColor = borderWidth = null;
		else if (borderColor!=null && borderWidth==null) borderWidth = 1;
		if (zot(backdropColor)) backdropColor = DS.backdropColor!=null?DS.backdropColor:-1;
		if (zot(corner)) corner = DS.corner!=null?DS.corner:0;
		if (zot(indicatorType)) indicatorType = DS.indicatorType!=null?DS.indicatorType:"dot";
		if (zot(fill)) fill = DS.fill!=null?DS.fill:false;
		if (zot(scale)) scale = DS.scale!=null?DS.scale:1;
		if (zot(lightScale)) lightScale = DS.lightScale!=null?DS.lightScale:1;
		if (zot(press)) press = DS.press!=null?DS.press:false;
		if (zot(shadowColor)) shadowColor = DS.shadowColor!=null?DS.shadowColor:"rgba(0,0,0,.3)";
		if (zot(shadowBlur)) shadowBlur = DS.shadowBlur!=null?DS.shadowBlur:5;

		var eventType = (!zns?ACTIONEVENT=="mousedown":zim.ACTIONEVENT=="mousedown")?"mousedown":"click";

		var that = this;
		this.lights = [];

		var myValue;
		var indicator = new zim.Container({style:false});
		if (backdropColor != -1) {
			var backing = that.backdrop = new zim.Rectangle(width, height, backdropColor, borderColor, borderWidth, corner, null, null, false);
			this.addChild(backing);
		}
		var lights = this.lightsContainer = new zim.Container({style:false});
		this.addChild(lights);
		var light;
		var size = height * .5;
		var space = width / (num+1);
		var hitArea = new createjs.Shape();
		if (indicatorType == "square" || indicatorType == "box") {
			hitArea.graphics.f("black").dr(-space/2/lightScale+size/2, -height/2+size/2, space/lightScale, height);
		} else {
			hitArea.graphics.f("black").dr(-space/2/lightScale, -height/2, space/lightScale, height);
		}
		for (var i=0; i<num; i++) {
			if (indicatorType == "square" || indicatorType == "box") {
				light = new zim.Rectangle(size, size, backgroundColor, borderColor, borderWidth, null, null, null, false);
				light.regX = light.width/2;
				light.regY = light.height/2;
			} else {
				light = new zim.Circle(size/2, backgroundColor, borderColor, borderWidth, null, null, null, false);
			}
			this.lights.push(light);
			light.znum = i;
			light.scaleX = light.scaleY = lightScale;
			light.hitArea = hitArea;
			light.x = space + space * i;
			light.y = height / 2;
			lights.addChild(light);
		}
		lights.setBounds(0,0,width,height);
		lights.regX = lights.x = width / 2;
		lights.regY = lights.y = height / 2;
		this.addChild(lights);
		if (shadowColor != -1 && shadowBlur > 0) lights.shadow = new createjs.Shadow(shadowColor, 2, 2, shadowBlur);

		if (press) {
			lights.cursor = "pointer";
			var lightsEvent = lights.on(eventType, function(e) {
				if (myValue == e.target.znum) return;
				myValue = e.target.znum;
				setLights(myValue);
				that.dispatchEvent("change");
			});
		}
		lights.scaleX = lights.scaleY = scale;

		function setLights(v) {
			if (v >= num) v = -1; // out of range - don't let it fill up
			var c;
			for (var i=0; i<num; i++) {
				if (fill) {
					if (i < v) c = foregroundColor;
					else c = backgroundColor;
				} else {
					c = backgroundColor;
				}
				if (i == v) c = foregroundColor;
				lights.getChildAt(i).color = c;
			}
			if (that.zimAccessibility) that.zimAccessibility.changeTitle(that);

			if ((!zim.OPTIMIZE&&(zns||!OPTIMIZE)) && that.stage) that.stage.update();
		}

		Object.defineProperty(this, 'selectedIndex', {
			get: function() {
				return myValue;
			},
			set: function(value) {
				myValue = Math.floor(value);
				myValue = zim.constrain(myValue, -1, num-1);
				setLights(myValue);
			}
		});

		Object.defineProperty(this, 'num', {
			get: function() {
				return num;
			},
			set: function(value) {
				if (zon) zog("num is read only");
			}
		});

		this._enabled = true;
		Object.defineProperty(that, 'enabled', {
			get: function() {
				return that._enabled;
			},
			set: function(value) {
				zenable(that, value);
			}
		});

		if (style!==false) zimStyleTransforms(this, DS);
		this.clone = function() {
			return that.cloneProps(new zim.Indicator(width, height, num, foregroundColor, backgroundColor, borderColor, borderWidth, backdropColor, corner, indicatorType, fill, scale, lightScale, press, shadowColor, shadowBlur, style, this.group, inherit));
		}
	}
	zim.extend(zim.Indicator, zim.Container, "clone", "zimContainer", false);
	//-60

/*--
zim.List = function(width, height, list, viewNum, vertical, currentSelected, align, valign, labelAlign, labelValign, labelIndent, labelIndentHorizontal, labelIndentVertical, indent, spacing, backgroundColor, rollBackgroundColor, selectedBackgroundColor, selectedRollBackgroundColor, backdropColor, color, selectedColor, rollColor, selectedRollColor, borderColor, borderWidth, padding, corner, swipe, scrollBarActive, scrollBarDrag, scrollBarColor, scrollBarAlpha, scrollBarFade, scrollBarH, scrollBarV, slide, slideDamp, slideSnap, shadowColor, shadowBlur, paddingHorizontal, paddingVertical, scrollWheel, damp, titleBar, titleBarColor, titleBarBackgroundColor, titleBarHeight, draggable, boundary, close, closeColor, excludeCustomTap, organizer, checkBox, clone, cancelCurrentDrag, style, group, inherit)

List
zim class - extends a zim.Window which extends a zim.Container which extends a createjs.Container

DESCRIPTION
A vertical or horizontal list of items.
This is really a zim.Tabs object inside a zim.Window object.
The list can be strings, numbers or Label objects and these are added to Tabs buttons.
The list can also include any DisplayObject with bounds (which most ZIM objects have except a Shape needs bounds set manually with setBounds()).
If the object is not a string, number or Label then selection will not highlight and currently animateTo() may not work if size is different.
See: https://zimjs.com/explore/list.html
See: https://zimjs.com/explore/listObjects.html

ACCORDION
An accordion is a list with nested sections that expand open.
A special accordion object can be passed to the list parameter
that includes the menu items, styles for the sub menus
and properties to animate, shade and indent the sub menus.

SPACING, PADDING, INDENTING
These adjust depending on vertical or horizontal settings
The spacing is the distance between items (default 2)
The padding is the distance around the items but not between (default spacing)
So changing the spacing can seem to change the padding - but that can be overridden
There is also paddingVertical and paddingHorizontal that can be adjusted (default padding)
Indent only works with custom items in the list in left, right alignment or top, bottom valignment
This moves the items away from their alignment
There is also label indenting for items with labels - and labelIndentVertical and labelIndentHorizontal

NOTE: List can have a ZIM Organizer added with the organizer parameter
The organizer lets the user add, remove and move items up, down, to the top or the bottom
See: https://zimjs.com/docs?item=organizer
See: https://zimjs.com/explore/organizer.html
See: https://zimjs.com/ten/accordion.html
See: https://zimjs.com/ten/listcheckbox.html

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var list = new List({
	list:["Enormous", "Big", "Medium", "Small", "Puny"],
	viewNum:3, // this number will change the size of the list elements (default is 5)
}).center()
stage.update();
END EXAMPLE

PARAMETERS
** supports DUO - parameters or single object with properties below
** supports OCT - parameter defaults can be set with STYLE control (like CSS)
width - (default 300) width of list
height - (default 200) height of list
list - (default Options 1-30) an array of strings, numbers or zim Label objects - these will be added to zim Tabs Buttons
	or include any DisplayObject with bounds - these will not get highlighted but will indicate a change event and selectedIndex
	currently objects with different sizes may not animateTo() properly - this will be fixed soon.
	A special Accordion object literal {} can be provided - see: https://zimjs.com/ten/accordion.html
		with the following properties:
		menu - a SIMPLE or COMPLEX hierarchy input - see ZIM Hierarchy() in the Code module
			note: if just providing the menu and the rest of the properties below are default
			then the Accordion object literal can be the SIMPLE or COMPLEX hierarchy input.
			In other words, no need to pass in {menu:{blah}} just pass in {blah}
		shade - (default .2) the alpha of indented shade in sub menus - or false for no shading
		shift - (default 15) the pixels to indent the shade - and left or right aligned text of sub menus - or false for no indenting
		dim - (default .1) the alpha of dark background overlay on sub menus - or false for no dimming
		bloom - (default 10) time in milliseconds for each submenu item to be added - or false to not animate sub menus in
		whither - (default 10) time in milliseconds for each submenu item to be removed - or false to not animate sub menus out
		subStyles - (default null) an array of style objects for each sublevel - with all the color and background color properties
	note: the Accordion List is currently incompatible with the Organizer, addTo() and removeFrom()
viewNum - (default 5) how many items to show in the width and height provided - for text list not custom objects...
vertical - (default true) set to false to make a horizontal list
currentSelected - (default false) set to true to show the current selection as highlighted
align - (default "center") horizontal align
valign - (default "center") vertical align
labelAlign - (default "center") horizontal align of the label only
labelValign - (default "center") vertical align of the label only
labelIndent - (default indent) indent of label when align or valign is set - usually same as indent unless custom objects are in list
labelIndentHorizontal - (default indent) horizontal indent of label when align or valign is set
labelIndentVertical - (default indent) vertical indent of label when align or valign is set
indent - (default 10) indent of items when align or valign is set and there are custom objects in list
spacing - (default 2) is the pixels between tab buttons
backgroundColor - (default "#777") the background color of the list elements (unless custom object)
rollBackgroundColor - (default "#555") the background color of the list element as rolled over
selectedBackgroundColor - (default "#444") the background color of the list element when selected
backdropColor - (default "#333") the background color of the list window (any CSS color)
color - (default "white") the text color of a deselected list element when not rolled over
selectedColor - (default color) the text color of the selected list element
rollColor - (default color) the rollover color (selected list elements do not roll over)
borderColor - (default #999) border color
borderWidth - (default 1) the thickness of the border
padding - (default 0) places the content in from edges of border (see paddingHorizontal and paddingVertical)
corner - (default 0) is the rounded corner of the list (does not accept corner array - scrollBars are too complicated)
swipe - (default auto/true) the direction for swiping set to none / false for no swiping
	also can set swipe to just vertical or horizontal
scrollBarActive - (default true) shows scrollBar (set to false to not)
scrollBarDrag - (default true) set to false to not be able to drag the scrollBar
scrollBarColor - (default borderColor) the color of the scrollBar
scrollBarAlpha - (default .3) the transparency of the scrollBar
scrollBarFade - (default true) fades scrollBar unless being used
scrollBarH - (default true) if scrolling in horizontal is needed then show scrollBar
scrollBarV - (default true) if scrolling in vertical is needed then show scrollBar
scrollBarOverlay - (default true) set to false to not overlay the scrollBar on the cotnent
	overlaying could hide content - but without overlay, content less than window size will show gap when no scrollBar
slide - (default true) Boolean to throw the content when drag/swipe released
slideDamp - (default .6) amount the slide damps when let go 1 for instant, .01 for long slide, etc.
slideSnap - (default "vertical") "auto" / true, "none" / false, "horizontal"
	slides past bounds and then snaps back to bounds when released
	vertical snaps when dragging up and down but not if dragging horizontal
shadowColor - (default rgba(0,0,0,.3)) the color of the shadow
shadowBlur - (default 20) set shadowBlur to -1 for no drop shadow
paddingHorizontal - (default padding) places content in from top bottom
paddingVertical - (default padding) places content in from left and right
scrollWheel - (default true) scroll vertically with scrollWheel
damp - (default null) set to .1 for instance to damp the scrolling
titleBar - (default null - no titleBar) a String or ZIM Label title for the list that will be presented on a titleBar across the top
titleBarColor - (default "black") the text color of the titleBar if a titleBar is requested
titleBarBackgroundColor - (default "rgba(0,0,0,.2)") the background color of the titleBar if a titleBar is requested
titleBarHeight - (default fit label) the height of the titleBar if a titleBar is requested
draggable - (default true if titleBar) set to false to not allow dragging titleBar to drag list
boundary - (default null) set to ZIM Boundary() object - or CreateJS.rectangle()
close - (default false) - a close X for the top right corner that closes the list when pressed
closeColor - (default #555) - the color of the close X if close is requested
excludeCustomTap - (default false) set to true to exclude custom buttons from tap() which would override existing tap() on the custom buttons
organizer - (default null) the ZIN Organizer for the list
checkBox - (default false) set to true to turn labeled list into a list of ZIM CheckBox objects - thanks Dale789 for the prompting!
	See: https://zimjs.com/ten/listcheckbox.html
	use selected.checkBox to get access to the selected CheckBox
	use the checkBoxes property to get a list of the CheckBox objects
	use setCheck(index, type), setChecks(type), getCheck(index) methods to manipulate
	use STYLE to set CheckBox size
clone - (default false) set to true to add clones of the list items rather than the items themselves
cancelCurrentDrag - (default false) - set to true to cancel window dragging when document window loses focus
	this functionality seems to work except if ZIM is being used with Animate - so we have left it turned off by default
style - (default true) set to false to ignore styles set with the STYLE - will receive original parameter defaults
group - (default null) set to String (or comma delimited String) so STYLE can set default styles to the group(s) (like a CSS class)
inherit - (default null) used internally but can receive an {} of styles directly

METHODS
animateTo(index, timePerItem) - animate list to index at given time per item (default 50ms) - returns object for chaining
addAt(items, index, clone) - an array of items to insert at an index in the list - returns object for chaining
	clone defaults to false - set to true to add a clone of the item or items to the list
removeAt(number, index) - remove a number of elements (default 1) from the list starting at and including the index - returns object for chaining
clear() - clears the list
first() - select first list element - returns object to chain
last() - select last list element - returns object to chain
setCheck(index, type) - set the CheckBox at an index to true or false (the type parameter)
setChecks(type) - set all CheckBoxes to true or false (the type parameter) returns object for chaining
getCheck(index) - get the checked value of the CheckBox at an index
cancelCurrentDrag() - stop current drag on list - but add dragging back again for next drag
hasProp(property as String) - returns true if property exists on object else returns false
clone() - makes a copy with properties such as x, y, etc. also copied
dispose() - removes from parent, removes event listeners - must still set outside references to null for garbage collection
List.checkItem(text, width, paddingHorizontal, paddingVertical, color, rollColor, backgroundColor, rollBackgroundColor, selectedColor, selectedRollColor, selectedBackgroundColor, selectedRollBackgroundColor)
	A static method (use it like List.checkItem("hello", 30, 400, 10, 10, white, etc.))
	To add a checkItem to a plain list use:
	new List({list:["goodbye", List.checkItem("hello", 30, 400, 10, 10, white), "what?"]})

ALSO: All Window methods

ALSO: ZIM 4TH adds all the methods listed under Container (see above), such as:
drag(), hitTestRect(), animate(), sca(), reg(), mov(), center(), centerReg(),
addTo(), removeFrom(), loop(), outline(), place(), pos(), alp(), rot(), setMask(), etc.
ALSO: See the CreateJS Easel Docs for Container methods, such as:
on(), off(), getBounds(), setBounds(), cache(), uncache(), updateCache(), dispatchEvent(),
addChild(), removeChild(), addChildAt(), getChildAt(), contains(), removeAllChildren(), etc.

PROPERTIES
type - holds the class name as a String
selectedIndex - get or set the index of the selected list element
selectedIndexPlusPosition set the index and scroll the index into view - might be broken for lists with custom objects of different heights
selected - gets the current selected list object (ie. a Button)
	use selected.checkBox to access the selected CheckBox if checkBox parameter is true
text - gets or sets the current selected label text
label - gets current selected label object
items (or list) - read-only array of list button objects or objects in the list
	this will change from the list entered as parameters as strings are turned into tab buttons, etc.
	use addAt() and removeAt() methods to manipulate
	custom items can be accessed using item.content - as the item is a container with a backing then content
checkBoxes - read-only array of CheckBox objects if checkBox parameter is true
itemsText - read-only array of text for labels (or null element if no label)
itemWidth - the width of each item (unless custom items)
itemHeight - the height of each item (unless custom items)
length - read-only length of the list
tabs - a reference to the tabs object used in the list
vertical - read-only true if list is vertical or false if horizontal
** setting widths and heights adjusts scale not bounds and getting these uses the bounds dimension times the scale
width - gets or sets the width. Setting the width will scale the height to keep proportion (see widthOnly below)
height - gets or sets the height. Setting the height will scale the width to keep proportion (see heightOnly below)
widthOnly - gets or sets the width.  This sets only the width and may change the aspect ratio of the object
heightOnly - gets or sets the height.  This sets only the height and may change the aspect ratio of the object
enabled - default is true - set to false to disable
blendMode - how the object blends with what is underneath - such as "difference", "multiply", etc. same as CreateJS compositeOperation
group - used when the object is made to add STYLE with the group selector (like a CSS class)

ALSO: All Window properties

ALSO: See the CreateJS Easel Docs for Container properties, such as:
x, y, rotation, scaleX, scaleY, regX, regY, skewX, skewY,
alpha, cursor, shadow, mouseChildren, mouseEnabled, parent, numChildren, etc.

EVENTS
dispatches a "change" event - then use selectedIndex or text to find data

ALSO: All Window events including "scrolling"

ALSO: See the CreateJS Easel Docs for Container events, such as:
added, click, dblclick, mousedown, mouseout, mouseover, pressmove, pressup, removed, rollout, rollover
--*///+60.5

	zim.List = function(width, height, list, viewNum, vertical, currentSelected, align, valign, labelAlign, labelValign, labelIndent, labelIndentHorizontal, labelIndentVertical, indent, spacing, backgroundColor, rollBackgroundColor, selectedBackgroundColor, selectedRollBackgroundColor, backdropColor, color, selectedColor, rollColor, selectedRollColor, borderColor, borderWidth, padding, corner, swipe, scrollBarActive, scrollBarDrag, scrollBarColor, scrollBarAlpha, scrollBarFade, scrollBarH, scrollBarV, scrollBarOverlay, slide, slideDamp, slideSnap, shadowColor, shadowBlur, paddingHorizontal, paddingVertical, scrollWheel, damp, titleBar, titleBarColor, titleBarBackgroundColor, titleBarHeight, draggable, boundary, close, closeColor, excludeCustomTap, organizer, checkBox, clone, cancelCurrentDrag, style, group, inherit) {
		var sig = "width, height, list, viewNum, vertical, currentSelected, align, valign, labelAlign, labelValign, labelIndent, labelIndentHorizontal, labelIndentVertical, indent, spacing, backgroundColor, rollBackgroundColor, selectedBackgroundColor, selectedRollBackgroundColor, backdropColor, color, selectedColor, rollColor, selectedRollColor, borderColor, borderWidth, padding, corner, swipe, scrollBarActive, scrollBarDrag, scrollBarColor, scrollBarAlpha, scrollBarFade, scrollBarH, scrollBarV, scrollBarOverlay, slide, slideDamp, slideSnap, shadowColor, shadowBlur, paddingHorizontal, paddingVertical, scrollWheel, damp, titleBar, titleBarColor, titleBarBackgroundColor, titleBarHeight, draggable, boundary, close, closeColor, excludeCustomTap, organizer, checkBox, clone, cancelCurrentDrag, style, group, inherit";
		var duo; if (duo = zob(zim.List, arguments, sig, this)) return duo;
		z_d("60.5");

		this.group = group;
		var DS = style===false?{}:zim.getStyle("List", this.group, inherit);

		if (zot(width)) width=DS.width!=null?DS.width:300;
		if (zot(height)) height=DS.height!=null?DS.height:!zot(organizer)?200+organizer.height:200;
		if (zot(list)) list = list=DS.list!=null?DS.list:["Option 1", "Option 2", "Option 3", "Option 4", "Option 5", "Option 6", "Option 7", "Option 8", "Option 9", "Option 10"];
		if (list.length == 0) list=["%-&"];
		this.originalList = list;
		if (zot(viewNum)) viewNum=DS.viewNum!=null?DS.viewNum:5;
		if (zot(vertical)) vertical=DS.vertical!=null?DS.vertical:true;
		if (zot(currentSelected)) currentSelected=DS.currentSelected!=null?DS.currentSelected:true;
		var originalAlign = !zot(align) || !zot(labelAlign);
		if (zot(checkBox)) checkBox=DS.checkBox!=null?DS.checkBox:false;
		if (zot(align)) align=DS.align!=null?DS.align:(checkBox?"left":"center");
		if (zot(valign)) valign=DS.valign!=null?DS.valign:"center";
		if (zot(labelAlign)) labelAlign=DS.labelAlign!=null?DS.labelAlign:align;
		if (zot(labelValign)) labelValign=DS.labelValign!=null?DS.labelValign:valign;

		if (zot(indent)) indent=DS.indent!=null?DS.indent:(checkBox?0:10);
		if (zot(labelIndent)) labelIndent=DS.labelIndent!=null?DS.labelIndent:indent;
		if (zot(labelIndentHorizontal)) labelIndentHorizontal=DS.labelIndentHorizontal!=null?DS.labelIndentHorizontal:labelIndent;
		if (zot(labelIndentVertical)) labelIndentVertical=DS.labelIndentVertical!=null?DS.labelIndentVertical:labelIndent;

		if (zot(spacing)) spacing=DS.spacing!=null?DS.spacing:2;
		if (zot(backdropColor)) backdropColor = DS.backdropColor!=null?DS.backdropColor:"#333";
		if (zot(backgroundColor)) backgroundColor = DS.backgroundColor!=null?DS.backgroundColor:"#777";
		if (zot(rollBackgroundColor)) rollBackgroundColor = DS.rollBackgroundColor!=null?DS.rollBackgroundColor:"#555";
		if (zot(selectedBackgroundColor)) selectedBackgroundColor = DS.selectedBackgroundColor!=null?DS.selectedBackgroundColor:"#444";
		if (zot(selectedRollBackgroundColor)) selectedRollBackgroundColor = DS.selectedRollBackgroundColor!=null?DS.selectedRollBackgroundColor:"#555";
		if (zot(color)) color = DS.color!=null?DS.color:"white";
		if (zot(rollColor)) rollColor = DS.rollColor!=null?DS.rollColor:color;
		if (zot(selectedColor)) selectedColor = DS.selectedColor!=null?DS.selectedColor:color;
		if (zot(selectedRollColor)) selectedRollColor = DS.selectedRollColor!=null?DS.selectedRollColor:rollColor;
		if (zot(backdropColor)) backdropColor = DS.backdropColor!=null?DS.backdropColor:backdropColor;

		var originalBorderColor = borderColor;
		var originalBorderWidth = borderWidth;
		if (zot(borderColor)) borderColor=DS.borderColor!=null?DS.borderColor:"#999";
		if (zot(borderWidth)) borderWidth=DS.borderWidth!=null?DS.borderWidth:1; // 0
		// if (vertical && zot(padding) && zot(paddingVertical)) paddingVertical = spacing;
		// if (!vertical && zot(padding) && zot(paddingHorizontal)) paddingHorizontal = spacing;
		if (zot(padding)) padding=DS.padding!=null?DS.padding:spacing;
		if (zot(corner)) corner=DS.corner!=null?DS.corner:0;
		if (zot(swipe)) swipe=DS.swipe!=null?DS.swipe:true; // true / auto, vertical, horizontal, false / none
		if (zot(scrollBarActive)) scrollBarActive=DS.scrollBarActive!=null?DS.scrollBarActive:true;
		if (zot(scrollBarDrag)) scrollBarDrag=DS.scrollBarDrag!=null?DS.scrollBarDrag:true;
		if (zot(scrollBarColor)) scrollBarColor=DS.scrollBarColor!=null?DS.scrollBarColor:borderColor;
		if (zot(scrollBarAlpha)) scrollBarAlpha=DS.scrollBarAlpha!=null?DS.scrollBarAlpha:.3;
		if (zot(scrollBarFade)) scrollBarFade=DS.scrollBarFade!=null?DS.scrollBarFade:true;
		if (zot(scrollBarH)) scrollBarH = DS.scrollBarH!=null?DS.scrollBarH:!vertical;
		if (zot(scrollBarV)) scrollBarV = DS.scrollBarV!=null?DS.scrollBarV:vertical;
		if (scrollBarDrag) scrollBarFade = DS.scrollBarFade!=null?DS.scrollBarFade:false;
		if (zot(scrollBarOverlay)) scrollBarOverlay = DS.scrollBarOverlay!=null?DS.scrollBarOverlay:true;
		if (zot(slide)) slide=DS.slide!=null?DS.slide:true;
		if (zot(slideDamp)) slideDamp=DS.slideDamp!=null?DS.slideDamp:.6;
		if (zot(slideSnap)) slideSnap=DS.slideSnap!=null?DS.slideSnap:vertical?"vertical":"horizontal"; // true / auto, vertical, horizontal, false / none
		if (zot(shadowColor)) shadowColor=DS.shadowColor!=null?DS.shadowColor:"rgba(0,0,0,.3)";
		if (zot(shadowBlur)) shadowBlur=DS.shadowBlur!=null?DS.shadowBlur:20;
		if (zot(paddingVertical)) paddingVertical=DS.paddingVertical!=null?DS.paddingVertical:padding;
		if (zot(paddingHorizontal)) paddingHorizontal=DS.paddingHorizontal!=null?DS.paddingHorizontal:padding;
		if (zot(scrollWheel)) scrollWheel = DS.scrollWheel!=null?DS.scrollWheel:true;
		if (zot(titleBar)) titleBar = DS.titleBar!=null?DS.titleBar:null;
		if (zot(titleBarColor)) titleBarColor = DS.titleBarColor!=null?DS.titleBarColor:null;
		if (zot(titleBarBackgroundColor)) titleBarBackgroundColor = DS.titleBarBackgroundColor!=null?DS.titleBarBackgroundColor:null;
		if (zot(titleBarHeight)) titleBarHeight = DS.titleBarHeight!=null?DS.titleBarHeight:35;
		if (zot(draggable)) draggable = DS.draggable!=null?DS.draggable:null;
		if (zot(boundary)) boundary = DS.boundary!=null?DS.boundary:null;
		if (zot(close)) close = DS.close!=null?DS.close:null;
		if (zot(closeColor)) closeColor = DS.closeColor!=null?DS.closeColor:null;
		if (zot(excludeCustomTap)) excludeCustomTap = DS.excludeCustomTap!=null?DS.excludeCustomTap:false;
		if (zot(clone)) clone = DS.clone!=null?DS.clone:false;

		if (titleBar === false) titleBar = null;
		this.vertical = vertical;

		var that = this;
		var originalHeight = height;

		// handle possible checkboxes
		if (checkBox) {
			zim.loop(list, function (item, i) {
				list[i] = zim.List.checkItem(item, null, width, "left", 10, 10, spacing, color, rollColor, selectedColor, selectedRollColor, backgroundColor, rollBackgroundColor, selectedBackgroundColor, selectedRollBackgroundColor);
			});
		}

		// handle possible accordion data
		if (list.constructor == {}.constructor) {
			var shade = !zot(list.shade)?list.shade:!zot(DS.shade)?DS.shade:.2;
			var dim = !zot(list.dim)?list.dim:!zot(DS.dim)?DS.dim:.1;
			var shift = !zot(list.shift)?list.shift:!zot(DS.shift)?DS.shift:15;
			var bloom = !zot(list.bloom)?list.bloom:!zot(DS.bloom)?DS.bloom:false;
			var whither = !zot(list.whither)?list.whither:!zot(DS.whither)?DS.whither:false;
			if (bloom === true) bloom = 10;
			if (whither === true) whither = 10;
			if (shift === true) shift = 15;
			if (shade === true) shade = .2;
			if (dim === true) dim = .1;
			var subStyles = !zot(list.subStyles)?list.subStyles:!zot(DS.subStyles)?DS.subStyles:{};
			if (!zot(list.menu)) {
				list = list.menu;
			}
			// how to handle if final hierarchy data is submitted
			var tree = new Hierarchy(list);
			list = tree.getLinearList();
			if (!originalAlign) align = labelAlign = "left";
		}

		this.align = align;
		this.valign = valign;
		this.indent = indent;

		if (!zot(organizer)) {
			height = height - organizer.height;
			organizer.list = that;
			organizer.setButtons();
			titleBarHeight += organizer.height
		}
		this.zimWindow_constructor(width, height, backdropColor, borderColor, borderWidth, padding, corner, swipe, scrollBarActive, scrollBarDrag, scrollBarColor, scrollBarAlpha, scrollBarFade, scrollBarH, scrollBarV, slide, slideDamp, slideSnap, true, shadowColor, shadowBlur, paddingHorizontal, paddingVertical, scrollWheel, damp, titleBar, titleBarColor, titleBarBackgroundColor, titleBarHeight, draggable, boundary, close, closeColor, cancelCurrentDrag, style, group, DS);
		this.type = "List";

		if (!zot(titleBar)) {
			this.titleBarLabel.pos(null,titleBarHeight-30,null,true);
			if (zot(titleBarHeight)) titleBarHeight = 30;
			height = height - titleBarHeight;
		}

		if (!zot(organizer)) {
			organizer.addTo(that).loc(0,-organizer.height)
		}


		that.itemWidth = vertical?(width-paddingHorizontal*2-(scrollBarActive?(scrollBarOverlay?0:6):0)):(width-paddingHorizontal*2)/viewNum;
		that.itemHeight = vertical?(height-paddingVertical*2)/viewNum:(height-paddingVertical*2-(scrollBarActive?(scrollBarOverlay?0:6):0));

		var tabs;
		function makeTabs(tabList) {
			tabs = that.tabs = new zim.Tabs({
				width:vertical?that.itemWidth:(that.itemWidth*list.length),
				height:vertical?that.itemHeight*list.length:that.itemHeight,
				tabs:tabList,
				spacing:spacing,
				vertical:vertical,
				backgroundColor:backgroundColor,
				rollBackgroundColor:rollBackgroundColor,
				selectedBackgroundColor:selectedBackgroundColor,
				selectedRollBackgroundColor:selectedRollBackgroundColor,
				color:color,
				rollColor:rollColor,
				selectedColor:selectedColor,
				selectedRollColor:selectedRollColor,
				backdropColor:backdropColor,
				currentEnabled:true,
				currentSelected:currentSelected,
				align:align,
				valign:valign,
				labelAlign:labelAlign,
				labelValign:labelValign,
				labelIndent:labelIndent,
				labelIndentHorizontal:labelIndentHorizontal,
				labelIndentVertical:labelIndentVertical,
				indent:indent,
				useTap:true,
				excludeCustomTap:excludeCustomTap,
				style:style,
				group:group,
				inherit:DS
			})
			// .mov(vertical?0:(spacing+2),vertical?(spacing+2):0);
			.mov(vertical?0:paddingHorizontal,vertical?paddingVertical:0);
			// var b = tabs.getBounds();
			// tabs.setBounds(0,0,vertical?b.width:(b.width+spacing*2+4),vertical?(b.height+spacing*2+4):b.height);
			that.add(tabs);
			// tabs.loc(paddingHorizontal, paddingVertical)
		}
		makeTabs(zim.copy(list, clone));

		//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

		if (tree) {

			var ids = tree.getLinearIDs();
			loop(ids, function (id, i) {
				that.tabs.buttons[i].listZID = id;
			});

			// add these to single accordion object literal along with styles and data?
			// and then pass in to list parameter?


			loop(that.tabs.buttons, function (item) {
				var data = tree.getData(item.listZID);
				if (!isEmpty(data.list)) item.accordion = new Label({text:"+", align:"center", color:convertColor(color, "rgba", .6)}).center(item).alp(.7).pos(15, null, that.align!="right");
			});

			function applyAccordion(item, id, data) {
				item.listZID = id;
				if (item.label) {
					if (shade) new Rectangle(shift*(data.level+1), item.height).alp(shade).pos(0,0,that.align=="right",false,item);
					if (dim) new Rectangle(item.width, item.height).alp((data.level+1)*dim).addTo(item).bot().ord(1);
					if (shift && that.align!="center") item.label.x += (that.align=="right"?-1:1)*shift*(data.level+1);
				}
				var newData = tree.getData(id);
				newData.obj = item;
				if (newData.list && !isEmpty(newData.list)) item.accordion = new Label({text:"+", align:"center", color:convertColor(color, "rgba", .6)}).center(item).alp(.7).pos(15, null, that.align!="right");
			}

			that.tap(function () {
				if (!that.selected.accordion) return;
				var data = tree.getData(that.selected.listZID);
				if (data.open) { // close
					if (that.selected.accordion) that.selected.accordion.text = "+";
					data.open = false;
					var nextSibling = tree.getNextSibling(that.selected.listZID);
					if (zot(nextSibling)) var finalIndex = that.items.length-1;
					else {
						var finalIndex = zim.loop(that.items, function (item, i) {
							if (item.listZID == nextSibling) return i-1;
						});
					}
					if (whither) {
						var count = 0;
						that.enabled = false;
						interval(whither, function (obj) {
							that.removeAt(1, that.selectedIndex+finalIndex-that.selectedIndex-count);
							count++;
							if (obj.total == obj.count+1) that.enabled = true;
						}, finalIndex-that.selectedIndex, true);
					} else {
						that.removeAt(finalIndex-that.selectedIndex, that.selectedIndex+1);
					}
				} else { // open
					data.open = true;
					if (that.selected.accordion) that.selected.accordion.text = "-";
					var outer = tree.getLinearList(data.list);
					var ids = tree.getLinearIDs(data.list);
					if (!data.opened) {
						data.opened = true;
						var newStyles = subStyles[data.level];
						if (zot(newStyles)) newStyles = {};
						if (Array.isArray(outer)) {
							if (bloom) {
								var count = 0;
								that.enabled = false;
								interval(bloom, function (obj) {
									that.addAt(outer[count], that.selectedIndex+1+count, {
										backgroundColor:newStyles.backgroundColor,
										color:newStyles.color,
										rollBackgroundColor:newStyles.rollBackgroundColor,
										rollColor:newStyles.rollColor,
										selectedBackgroundColor:newStyles.selectedBackgroundColor,
										selectedColor:newStyles.selectedColor,
										selectedRollBackgroundColor:newStyles.selectedRollBackgroundColor,
										selectedRollColor:newStyles.selectedRollColor
									});
									var id = ids[count];
									var item = that.items[that.selectedIndex+1+count];
									applyAccordion(item, id, data);
									if (obj.total == obj.count+1) that.enabled = true;
									count++;
								}, outer.length, true);
							} else {
								that.addAt(outer, that.selectedIndex+1, {
									backgroundColor:newStyles.backgroundColor,
									color:newStyles.color,
									rollBackgroundColor:newStyles.rollBackgroundColor,
									rollColor:newStyles.rollColor,
									selectedBackgroundColor:newStyles.selectedBackgroundColor,
									selectedColor:newStyles.selectedColor,
									selectedRollBackgroundColor:newStyles.selectedRollBackgroundColor,
									selectedRollColor:newStyles.selectedRollColor
								});
								loop(ids, function (id, i) {
									var item = that.items[that.selectedIndex+1+i];
									applyAccordion(item, id, data);
								});
							}
						}
					} else {
						if (Array.isArray(outer)) {
							if (bloom) {
								var count = 0;
								that.enabled = false;
								interval(bloom, function (obj) {
									that.addAt(outer[count], that.selectedIndex+1+count);
									// that.selectedIndexPlusPosition = that.selectedIndex;
									if (obj.total == obj.count+1) that.enabled = true;
									count++;
								}, outer.length, true)
							} else {
								that.addAt(outer, that.selectedIndex+1);
							}
						}
					}
				}
			});

		}

		//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



		var _selectedIndex;
		tabs.tap(function (e) {
			if (e.target.selectedIndex == that.selectedIndex) return;
			that.selectedIndex = tabs.selectedIndex;
			that.dispatchEvent("change");
			e.preventDefault();
		});

		this.getItemIndex = function(item) {
			return that.items.indexOf(item);
		}

		this.animateTo = function(index, timePerItem) {
			if (zot(index)) index = 0;
			if (zot(timePerItem)) timePerItem = 50;
			that.selectedIndex = index;
			var newPos = getScrollPosition(index);
			if (vertical) {
				var itemsToTravel = Math.abs(that.scrollY-newPos)/that.itemHeight;
				that.animate({scrollY:newPos}, itemsToTravel*timePerItem);
				// that.scrollY = newPos;
			} else {
				var itemsToTravel = Math.abs(that.scrollX-newPos)/that.itemWidth;
				that.animate({scrollX:newPos}, itemsToTravel*timePerItem);
				// that.scrollX = newPos;
			}
			return that;
		}

		this.addAt = function(items, index, style, clone) {
			that.tabs.addAt(copy(items, clone), index, style)
			// var b = tabs.getBounds();
			// tabs.setBounds(0,0,vertical?b.width:(b.width+spacing*2+4),vertical?(b.height+spacing*2+4):b.height);
			that.content.x = 0;
			that.content.y = 0;
			that.update();
			return that;
		}

		this.removeAt = function(num, index) {
			that.tabs.removeAt(num, index)
			var b = tabs.getBounds();
			tabs.setBounds(0,0,b.width,b.height);
			that.content.x = 0;
			that.content.y = 0;
			that.update();
			return that;
		}
		if (list[0]=="%-&" && list.length==1) that.removeAt(1,0);

		this.clear = function() {
			that.tabs.removeAt(that.length, 0);
			that.content.x = 0;
			that.content.y = 0;
			that.update();
			return that;
		}

		this.setCheck = function(index, type) {
			if (zot(index)) index = 0;
			if (zot(type)) type = true;
			that.items[index].checkBox.checked = type;
			that.items[index].content.zimOut();
		}

		this.getCheck = function(index) {
			if (zot(index)) index = 0;
			return that.items[index].checkBox.checked;
		}

		this.setChecks = function(type) {
			zim.loop(that.items, function (item) {
				item.checkBox.checked = type;
				item.content.zimOut();
			});
			return that;
		}

		Object.defineProperty(that, 'items', {
			get: function() {
				return that.tabs.buttons;
			},
			set: function(value) {
				if (zon) zog("List() - items is read only - use addAt() and removeAt() to change");
			}
		});

		Object.defineProperty(that, 'list', {
			get: function() {
				return that.tabs.buttons;
			},
			set: function(value) {
				if (zon) zog("List() - list is read only - use addAt() and removeAt() to change");
			}
		});

		Object.defineProperty(that, 'length', {
			get: function() {
				return that.tabs.buttons.length;
			},
			set: function(value) {
				if (zon) zog("List() - length is read only");
			}
		});

		Object.defineProperty(that, 'selectedIndex', {
			get: function() {
				return _selectedIndex;
			},
			set: function(value) {
				tabs.selectedIndex = value;
				// that.text = tabs.text;
				that.label = tabs.label;
				that.selected = tabs.selected;
				_selectedIndex = value;
				if ((!zim.OPTIMIZE&&(zns||!OPTIMIZE)) && that.stage) that.stage.update();
			}
		});
		if (currentSelected) that.selectedIndex = 0;

		Object.defineProperty(that, 'selectedIndexPlusPosition', {
			get: function() {
				return _selectedIndex;
			},
			set: function(value) {
				that.selectedIndex = value;
				_selectedIndex = value;
				if (vertical) that.scrollY = getScrollPosition(value);
				else that.scrollX = getScrollPosition(value);
				if ((!zim.OPTIMIZE&&(zns||!OPTIMIZE)) && that.stage) that.stage.update();
			}
		});
		function getScrollPosition(index) {
			// var w = (that.itemWidth+spacing)*(vertical?1:that.length);
			// var h = (that.itemHeight+spacing)*(vertical?that.length:1);
			// that.tabs.setBounds(w, h);

			if (vertical) {
				var newY = -(that.itemHeight+spacing)*index + height/2 - that.itemHeight/2;
				if ((that.itemHeight+spacing)*that.length < height) newY = 0;
				if (newY > 0) newY = 0;
				if ((that.itemHeight+spacing)*that.length > height && newY < -that.tabs.height+height-paddingVertical*2) newY = -that.tabs.height+height-paddingVertical*2;
				return newY;
			} else {
				var newX = -(that.itemWidth+spacing)*index + width/2 - that.itemWidth/2;
				if ((that.itemWidth+spacing)*that.length < width) newX = 0;
				if (newX > 0) newX = 0;
				if ((that.itemWidth+spacing)*that.length > width && newX < -that.tabs.width+width-paddingHorizontal*2) newX = -that.tabs.width+width-paddingHorizontal*2;
				return newX;
			}
		}

		Object.defineProperty(that, 'text', {
			get: function() {
				if (that.label) return that.label.text;
			},
			set: function(value) {
				if (that.label) that.label.text = value;
			}
		});

		Object.defineProperty(that, 'itemDown', {
			get: function() {
				return that.tabs.buttonDown
			},
			set: function(value) {

			}
		});

		Object.defineProperty(that, 'itemsText', {
			get: function() {
				var a = [];
				for (var i=0; i<that.tabs.buttons.length; i++) {
					var aa = that.tabs.buttons[i].label;
					if (aa && !zot(aa.text)) {
						a.push(aa.text);
					} else {
						a.push(null);
					}
				}
				return a;
			},
			set: function(value) {
				if (zon) zog("List() - itemsText is read only");
			}
		});
		if (currentSelected) that.selectedIndex = 0;

		Object.defineProperty(that, 'checkBoxes', {
			get: function() {
				var a = [];
				for (var i=0; i<that.tabs.buttons.length; i++) {
					var aa = that.tabs.buttons[i].checkBox;
					a.push(aa);
				}
				return a;
			},
			set: function(value) {
				if (zon) zog("List() - checkBoxes is read only");
			}
		});

		this._enabled = true;
		Object.defineProperty(that, 'enabled', {
			get: function() {
				return that._enabled;
			},
			set: function(value) {
				zenable(that, value);
			}
		});

		this.last = function() {
			this.selectedIndexPlusPosition = this.length-1;
			return this;
		}
		this.first = function() {
			this.selectedIndexPlusPosition = 0;
			return this;
		}

		if (style!==false) zimStyleTransforms(this, DS);
		this.clone = function() {
			return that.cloneProps(new zim.List(width, originalHeight, zim.copy(that.originalList, true), viewNum, vertical, currentSelected, align, valign, labelAlign, labelValign, labelIndent, labelIndentHorizontal, labelIndentVertical, indent, spacing, backgroundColor, rollBackgroundColor, selectedBackgroundColor, selectedRollBackgroundColor, backdropColor, color, selectedColor, rollColor, selectedRollColor, originalBorderColor, originalBorderWidth, padding, zim.copy(corner), swipe, scrollBarActive, scrollBarDrag, scrollBarColor, scrollBarAlpha, scrollBarFade, scrollBarH, scrollBarV, scrollBarOverlay, slide, slideDamp, slideSnap, shadowColor, shadowBlur, paddingHorizontal, paddingVertical, scrollWheel, damp, titleBar, titleBarColor, titleBarBackgroundColor, titleBarHeight, draggable, boundary, close, closeColor, excludeCustomTap, organizer, checkBox, clone, cancelCurrentDrag, style, this.group, inherit));
		}
	}
	zim.extend(zim.List, zim.Window, "clone", "zimWindow", false);

	zim.List.checkItem = function(label, size, width, align, paddingHorizontal, paddingVertical, spacing, color, rollColor, selectedColor, selectedRollColor, backgroundColor, rollBackgroundColor, selectedBackgroundColor, selectedRollBackgroundColor, group, inherit) {
		var sig = "label, size, width, align, paddingHorizontal, paddingVertical, spacing, color, rollColor, selectedColor, selectedRollColor, backgroundColor, rollBackgroundColor, selectedBackgroundColor, selectedRollBackgroundColor, group, inherit";
		var duo; if (duo = zob(zim.List.checkItem, arguments, sig)) return duo;

		var DS = zim.getStyle("CheckBox", group, inherit);
		if (zot(size)) size = DS.size!=null?DS.size:20;

		var DS = zim.getStyle("List", group, inherit);
		if (zot(width)) width = 300;
		if (zot(paddingHorizontal)) paddingHorizontal = 10;
		if (zot(paddingVertical)) paddingVertical = 10;

		if (zot(align)) align = DS.align!=null?DS.align:"center";
		if (zot(spacing)) spacing = DS.spacing!=null?DS.spacing:2;
		if (zot(backgroundColor)) backgroundColor = DS.backgroundColor!=null?DS.backgroundColor:"#777";
		if (zot(rollBackgroundColor)) rollBackgroundColor = DS.rollBackgroundColor!=null?DS.rollBackgroundColor:"#555";
		if (zot(selectedBackgroundColor)) selectedBackgroundColor = DS.selectedBackgroundColor!=null?DS.selectedBackgroundColor:"#444";
		if (zot(selectedRollBackgroundColor)) selectedRollBackgroundColor = DS.selectedRollBackgroundColor!=null?DS.selectedRollBackgroundColor:"#555";
		if (zot(color)) color = DS.color!=null?DS.color:"white";
		if (zot(rollColor)) rollColor = DS.rollColor!=null?DS.rollColor:color;
		if (zot(selectedColor)) selectedColor = DS.selectedColor!=null?DS.selectedColor:color;
		if (zot(selectedRollColor)) selectedRollColor = DS.selectedRollColor!=null?DS.selectedRollColor:rollColor;

		var c = new Container();
		c.type = "CheckItem"
		c.checkBox = new CheckBox({size:size, label:label, color:color, tap:true}),
		c.backing = new Rectangle(width-spacing*2, c.checkBox.height+paddingVertical*2, backgroundColor).addTo(c);
		c.checkBox.center(c)
		if (align != "center" && align != "middle") c.checkBox.pos(paddingHorizontal,null,align=="right");
		c.backing.tap(function () {
			c.checkBox.toggle();
			c.zimOut(); // could do over() but like out()
		});
		c.checkBox.change(function () {
			c.zimOut();
		});
		c.zimOver = function() {
			c.backing.color = c.checkBox.checked?selectedRollBackgroundColor:rollBackgroundColor;
			c.checkBox.label.color = c.checkBox.checked?selectedRollColor:rollColor;
			if (c.stage) c.stage.update();
		};
		c.zimOut = function(){
			c.backing.color = c.checkBox.checked?selectedBackgroundColor:backgroundColor;
			c.checkBox.label.color = c.checkBox.checked?selectedColor:color;
			if (c.stage) c.stage.update();
		}
		c.backing.on("mouseover", c.zimOver);
		c.checkBox.on("mouseover", c.zimOver);
		c.backing.on("mouseout", c.zimOut);
		c.checkBox.on("mouseout", c.zimOut);

		return c;
	}
	//-60.5


/*--
zim.Stepper = function(list, width, backgroundColor, borderColor, borderWidth, label, color, vertical, arrows, corner, shadowColor, shadowBlur, continuous, display, press, hold, holdDelay, holdSpeed, draggable, dragSensitivity, dragRange, stepperType, min, max, step, step2, arrows2, arrows2Scale, keyEnabled, keyArrows, rightForward, downForward, style, group, inherit)

Stepper
zim class - extends a zim.Container which extends a createjs.Container

DESCRIPTION
Lets you step through a list of numbers or strings with arrows and keyboard arrows.
Uses mousedown to activate and defaults to stepping while pressing down
and going faster if you drag away from your press.

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var stepper = new Stepper();
stepper.on("change", function() {
	zog(stepper.selectedIndex);
	zog(stepper.currentValue);
});
END EXAMPLE

PARAMETERS
** supports DUO - parameters or single object with properties below
** supports OCT - parameter defaults can be set with STYLE control (like CSS)
list - (default 1-10) pass in an array of strings or numbers to display one at a time
width - (default 100) is the width of the text box (you can scale the whole stepper if needed)
color - (default "white") for the arrows and the text box
borderColor - (default null) stroke color for the box
borderWidth - (default 1 if borderColor) stroke thickness for the box
label - (default null) which can be used to define custom text properties
vertical - (default false) set to true if you want the arrows above and below the text
arrows - (default true) - use graphical arrows (also see keyArrows to turn off keyboard arrows)
corner - (default 10) is the radius of the text box corners - set to 0 for square corners
	can also be an array of [topLeft, topRight, bottomRight, bottomLeft]
shadowColor - (default rgba(0,0,0,.3)) set to -1 for no drop shadow
shadowBlur - (default 14) value for shadow blur if shadow is set
continuous - (default false) set to true to loop around or go back past 0 index
display - (default true) set to false just to just show the arrows and not the value
press - (default true) will advance on label mousedown - set to false to not advance on mousedown
hold - (default true) set to false to not step with extended press down
holdDelay - (default 400 ms) time (milliseconds) to wait for first step with hold
holdSpeed - (default 200 ms) time (milliseconds) between steps as holding
draggable - (default true) set to false to not step when dragging
dragSensitivity - (default .1) .01 changes really quickly - 1 changes at base rate
dragRange - (default 200) absolute distance (pixels) from press the drag will reach maximum
stepperType - (default "list") list draws values from list parameters
	also stepperType "number", "letter" - these get ranges below
min - (default 0 for number and "A" for letter) the minimum value (can make min bigger than max) (not for list stepperType)
max - (default 100 for number and "Z" for letter) the maximum value (can make max smaller than min) (not for list stepperType)
step - (default 1) the step value each time - can be decimal (only positive, only for number stepperType)
step2 - (default set to step) the step value when dragging perpendicular to main horizontal or vertical direction
	step2 will run with draggable set to true or with arrows2 set below (only positive, only for number stepperType)
arrows2 - (default true if step2 different than step and stepperType number - else false) secondary arrows perpendicular to main horizontal or vertical direction
	arrows2 will activate step2 above (only for number stepperType)
arrows2Scale - (default .5) the scale relative to the main arrows
keyEnabled - (default true) set to false to disable keyboard search / number picker
keyArrows - (default true) set to false to disable keyboard arrows
rightForward - (default true) set to false to make left the forward direction in your list
downForward - (default true except if stepperType is "number" then default false) set to false to make up the forward direction in your list
style - (default true) set to false to ignore styles set with the STYLE - will receive original parameter defaults
group - (default null) set to String (or comma delimited String) so STYLE can set default styles to the group(s) (like a CSS class)
inherit - (default null) used internally but can receive an {} of styles directly

METHODS
next() - goes to next
prev() - goes to previous
hasProp(property as String) - returns true if property exists on object else returns false
clone() - makes a copy with properties such as x, y, etc. also copied
dispose() - removes from parent, removes event listeners - must still set outside references to null for garbage collection

ALSO: ZIM 4TH adds all the methods listed under Container (see above), such as:
drag(), hitTestRect(), animate(), sca(), reg(), mov(), center(), centerReg(),
addTo(), removeFrom(), loop(), outline(), place(), pos(), alp(), rot(), setMask(), etc.
ALSO: See the CreateJS Easel Docs for Container methods, such as:
on(), off(), getBounds(), setBounds(), cache(), uncache(), updateCache(), dispatchEvent(),
addChild(), removeChild(), addChildAt(), getChildAt(), contains(), removeAllChildren(), etc.

PROPERTIES
type - holds the class name as a String
selectedIndex - gets or sets the current index of the array and display
currentValue - gets or sets the current value of the array and display
currentValueEvent - gets or sets the current value and dispatches a "change" event if set and changed
** setting widths and heights adjusts scale not bounds and getting these uses the bounds dimension times the scale
width - gets or sets the width. Setting the width will scale the height to keep proportion (see widthOnly below)
height - gets or sets the height. Setting the height will scale the width to keep proportion (see heightOnly below)
widthOnly - gets or sets the width.  This sets only the width and may change the aspect ratio of the object
heightOnly - gets or sets the height.  This sets only the height and may change the aspect ratio of the object
stepperArray - gets or sets the list
containerPrev, containerNext - access to the zim Container that holds the arrows
arrowPrev, arrowNext - access to the zim Triangle objects
arrowPrev2, arrowNext2 - access to the zim Triangle objects for arrows2
min, max - only for number mode at the monent - currently, do not change the max to be less than the min
label - access to the Label
textBox - access to the text box backing shape
continuous - does the stepper loop
enabled - default is true - set to false to disable
blendMode - how the object blends with what is underneath - such as "difference", "multiply", etc. same as CreateJS compositeOperation
keyFocus - get or set the keyboard focus on the component - see also zim.KEYFOCUS
	will be set to true if this component is the first made or component is the last to be used
group - used when the object is made to add STYLE with the group selector (like a CSS class)

ALSO: See the CreateJS Easel Docs for Container properties, such as:
x, y, rotation, scaleX, scaleY, regX, regY, skewX, skewY,
alpha, cursor, shadow, mouseChildren, mouseEnabled, parent, numChildren, etc.

OPTIMIZED
This component is affected by the general OPTIMIZE setting (default is false)
if set to true, you will have to stage.update() after setting certain properties
and stage.update() in change event to see component change its graphics

EVENTS
dispatches a "change" event when changed by pressing an arrow or a keyboard arrow
(but not when setting selectedIndex or currentValue properties)

ALSO: See the CreateJS Easel Docs for Container events, such as:
added, click, dblclick, mousedown, mouseout, mouseover, pressmove, pressup, removed, rollout, rollover
--*///+61
	zim.Stepper = function(list, width, backgroundColor, borderColor, borderWidth, label, color, vertical, arrows, corner,
			shadowColor, shadowBlur, continuous, display, press, hold, holdDelay, holdSpeed, draggable,
			dragSensitivity, dragRange, stepperType, min, max, step, step2, arrows2, arrows2Scale, keyEnabled, keyArrows, rightForward, downForward, style, group, inherit) {
		var sig = "list, width, backgroundColor, borderColor, borderWidth, label, color, vertical, arrows, corner, shadowColor, shadowBlur, continuous, display, press, hold, holdDelay, holdSpeed, draggable, dragSensitivity, dragRange, stepperType, min, max, step, step2, arrows2, arrows2Scale, keyEnabled, keyArrows, rightForward, downForward, style, group, inherit";
		var duo; if (duo = zob(zim.Stepper, arguments, sig, this)) return duo;
		z_d("61");
		this.zimContainer_constructor(null,null,null,null,false);
		this.type = "Stepper";
		this.group = group;
		var DS = style===false?{}:zim.getStyle(this.type, this.group, inherit);
		if (zot(list)) list = DS.list!=null?DS.list:[0,1,2,3,4,5,6,7,8,9];
		if (zot(width)) width=DS.width!=null?DS.width:200;
		if (zot(backgroundColor)) backgroundColor=DS.backgroundColor!=null?DS.backgroundColor:"white";
		if (zot(borderColor)) borderColor = DS.borderColor!=null?DS.borderColor:null;
		if (zot(borderWidth)) borderWidth = DS.borderWidth!=null?DS.borderWidth:null;
		if (borderColor < 0 || borderWidth < 0) borderColor = borderWidth = null;
		else if (borderColor!=null && borderWidth==null) borderWidth = 1;
		if (zot(color)) color = DS.color!=null?DS.color:"#555";
		if (zot(label)) label = DS.label!=null?DS.label:"";
		if (typeof label === "string" || typeof label === "number") label = new zim.Label({
			text:label, size:DS.size!=null?DS.size*2:64, color:color, align:DS.align!=null?DS.align:"center",
			backing:"ignore", shadowColor:"ignore", shadowBlur:"ignore", padding:"ignore", backgroundColor:"ignore",
			group:this.group
		});
		if (zot(vertical)) vertical=DS.vertical!=null?DS.vertical:false;
		if (zot(arrows)) arrows=DS.arrows!=null?DS.arrows:true;
		if (zot(corner)) corner=DS.corner!=null?DS.corner:16;
		if (zot(shadowColor)) shadowColor=DS.shadowColor!=null?DS.shadowColor:"rgba(0,0,0,.3)";
		if (zot(shadowBlur)) shadowBlur=DS.shadowBlur!=null?DS.shadowBlur:14;
		if (zot(continuous)) continuous=DS.continuous!=null?DS.continuous:false;
		if (zot(display)) display=DS.display!=null?DS.display:true;
		if (zot(press)) press=DS.press!=null?DS.press:true;
		if (zot(hold)) hold=DS.hold!=null?DS.hold:true;
		if (zot(holdDelay)) holdDelay=DS.holdDelay!=null?DS.holdDelay:400;
		if (zot(holdSpeed)) holdSpeed=DS.holdSpeed!=null?DS.holdSpeed:200;
		if (zot(draggable)) draggable=DS.draggable!=null?DS.draggable:true;
		if (zot(dragSensitivity) || dragSensitivity <= 0) dragSensitivity=DS.dragSensitivity!=null?DS.dragSensitivity:.1;
		if (zot(dragRange)) dragRange=DS.dragRange!=null?DS.dragRange:200;
		if (zot(stepperType)) stepperType=DS.stepperType!=null?DS.stepperType:"list";
		if (zot(min)) min=DS.min!=null?DS.min:0;
		if (zot(max)) max=DS.max!=null?DS.max:100;
		if (zot(step)) step=DS.step!=null?DS.step:1;
		if (zot(step2)) step2=DS.step2!=null?DS.step2:step;
		if (zot(arrows2) && step2 != step && stepperType == "number") arrows2=DS.arrows2!=null?DS.arrows2:true;
		if (zot(arrows2Scale)) arrows2Scale=DS.arrows2Scale!=null?DS.arrows2Scale:.5;
		if (zot(keyEnabled)) keyEnabled = DS.keyEnabled!=null?DS.keyEnabled:true;
		if (zot(keyArrows)) keyArrows = DS.keyArrows!=null?DS.keyArrows:true;
		if (zot(rightForward)) rightForward = DS.rightForward!=null?DS.rightForward:true;
		if (zot(downForward)) downForward = DS.downForward!=null?DS.downForward:(stepperType=="number"?false:true);

		var that = this;
		var index;
		var height = 100;
		var boxSpacing = height/4;

		var actualStep = step; // toggle between step and step2
		var numVal;
		var numDir = 1;
		var letterVal;
		var decimals;
		if (stepperType == "number") {
			min = Number(min);
			max = Number(max);
			if (min == NaN) min = 0;
			if (max == NaN) max = 100;
			if (max < min) {
				numDir = -1;
				var temp = max; // one day ES6
				max = min;
				min = temp;
				numVal = max;
			} else {
				numVal = min;
			}
			this.min = min;
			this.max = max;
			if (0 > min && 0 < max) numVal = 0;
			step = Math.abs(step);
			decimals = Math.max(getDecimals(step), getDecimals(step2));
		} else if (stepperType == "letter") {
			list = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".split("");
			if (typeof min != "string") min = "A";
			if (typeof max != "string") max = "Z";
			min = min.substr(0,1).toUpperCase();
			max = max.substr(0,1).toUpperCase();
			var startLetter = list.indexOf(min);
			if (startLetter < 0) {min = "A"; startLetter = 0;}
			var endLetter = list.indexOf(max);
			if (endLetter < 0) {max = "Z"; endLetter = list.length;}
			if (endLetter < startLetter) {
				list.reverse();
				startLetter = list.length-1-startLetter;
				endLetter = list.length-1-endLetter;
			}
			list = list.splice(startLetter, endLetter-startLetter+1);
		} else {
			stepperType = "list";
		}

		function getDecimals(num) {
			var decimals = String(num).split(".")[1]
			if (decimals) {decimals = decimals.length} else {decimals = 0;};
			return decimals;
		}

		var rawEvent;
		var rawX = 0;
		var rawY = 0;

		if (draggable) {
			this.on("mousedown", function(e) {
				if (that.zimAccessibility && that.zimAccessibility.aria) return;
				this.stage.mouseMoveOutside = true;
				rawX = e.rawX/e.target.stage.scaleX;
				rawY = e.rawY/e.target.stage.scaleY;
				rawEvent = this.stage.on("stagemousemove", function(e){
					rawX = e.rawX/e.target.stage.scaleX;
					rawY = e.rawY/e.target.stage.scaleY;
				})
			}, null, true);
		}
		this.label = label;
		label.mouseChildren = false;
		label.mouseEnabled = false;

		var holdCheck = false;
		var delayTimeout;
		var speedTimeout;
		var roundTimeout;
		var clickCheck = false;
		var prev, arrowPrev, next, arrowNext, prev2, arrowPrev2, next2, arrowNext2;
		if (arrows || arrows2) {
			var arrowBacking = new createjs.Shape();
			arrowBacking.graphics.ss(borderColor).s(borderWidth).f("rgba(255,255,255,.11)").r(0,0,height*1.5,height*1.5);
			arrowBacking.regX = height*1.5 / 2;
			arrowBacking.regY = height*1.5 / 2 + boxSpacing/2;
		}
		if (arrows) {
			prev = this.containerPrev = new zim.Container({style:false});
			this.addChild(prev);
			prev.hitArea = arrowBacking;

			arrowPrev = this.arrowPrev = new zim.Triangle(height, height*.8, height*.8, backgroundColor, null, null, null, null, null, null, false);
			if (shadowColor != -1 && shadowBlur > 0) prev.shadow = new createjs.Shadow(shadowColor, 3, 3, shadowBlur);
			prev.addChild(arrowPrev);
			prev.cursor = "pointer";

			prev.on("mousedown", function(e) {
				if (that.zimAccessibility && that.zimAccessibility.aria) return;
				actualStep = step;
				var val = vertical?(downForward?1:-1):(rightForward?-1:1);
				doStep(val);
				go(val, null, null, e.stageX/e.target.stage.scaleX, e.stageY/e.target.stage.scaleY);
			})
			if (hold) prev.on("pressup", goEnd);

			if (vertical) {
				prev.rotation = 180;
				prev.x = width/2;
				if (display) {
					prev.y = prev.height + boxSpacing + height + prev.height/2 + boxSpacing;
				} else {
					prev.y = prev.height * 2;
				}
			} else {
				prev.rotation = -90;
				prev.x = prev.height/2;
				prev.y = prev.width/2;
			}
		}

		if (display) {
			var box = this.textBox = new zim.Shape({style:false});
			box.cursor = "pointer";
			this.addChild(box);
			box.setBounds(0, 0, width, height);
			if (borderColor != null) box.graphics.s(borderColor).ss(borderWidth);

			var cc = corner;
			if (!Array.isArray(cc)) cc = [corner, corner, corner, corner];
			box.graphics.f(backgroundColor).rc(0, 0, width, height, cc[0], cc[1], cc[2], cc[3]);
			// box.graphics.f(backgroundColor).rr(0, 0, width, height, corner);
			if (shadowColor != -1 && shadowBlur > 0) box.shadow = new createjs.Shadow(shadowColor, 3, 3, shadowBlur);

			if (arrows) {
				if (vertical) {
					if (arrows) box.y = arrowPrev.height + boxSpacing;
				} else {
					if (arrows) box.x = arrowPrev.height + boxSpacing;
				}
			}

			this.addChild(label);
			if (list.length > 0) {
				// index = Math.floor(list.length/2)
				index = 0;
				label.text = list[index];
			}
			label.x = 50+box.x+box.getBounds().width/2;
			label.y = box.y+(box.getBounds().height-label.getBounds().height)/2;

			var lastValue;
			box.on("mousedown", function(e) {
				if (that.zimAccessibility && that.zimAccessibility.aria) return;
				lastValue = that.currentValue;
				if (press) doStep(1);
				go(1, true, null, e.stageX/e.target.stage.scaleX, e.stageY/e.target.stage.scaleY); // do decimals from box
				if (stepperType == "number") {
					clearTimeout(roundTimeout);
					clickCheck = true;
					roundTimeout = setTimeout(function() {
						clickCheck = false;
					}, 200);
				}
			});
			box.on("pressup", function() {
				if (that.zimAccessibility && that.zimAccessibility.aria) return;
				if (clickCheck) {
					numVal = Math.round(numVal);
					setLabel(numVal, numVal);
					if (that.currentValue != lastValue) that.dispatchEvent("change");
					lastValue = that.currentValue;
				}
			});
		} else {
			if (list.length > 0) {
				index = 0;
			}
		}

		if (arrows) {
			next = this.containerNext = new zim.Container({style:false});
			this.addChild(next);
			next.hitArea = arrowBacking.clone();

			arrowNext = this.arrowNext = new zim.Triangle(height, height*.8, height*.8, backgroundColor, null, null, null, null, null, null, false);
			if (shadowColor != -1 && shadowBlur > 0) next.shadow = new createjs.Shadow(shadowColor, 3, 3, shadowBlur);
			next.addChild(arrowNext);
			next.cursor = "pointer";

			next.on("mousedown", function(e) {
				if (that.zimAccessibility && that.zimAccessibility.aria) return;
				actualStep = step;
				var val = vertical?(downForward?-1:1):(rightForward?1:-1);
				doStep(val);
				go(val, null, null, e.stageX/e.target.stage.scaleX, e.stageY/e.target.stage.scaleY);
			});

			if (hold) next.on("pressup", goEnd);

			if (vertical) {
				next.rotation = 0;
				next.x = width/2;
				next.y = next.getBounds().height/2;
			} else {
				next.rotation = 90;
				if (display) {
					next.x = box.x + box.getBounds().width + next.getBounds().height/2 + boxSpacing;
				} else {
					next.x = prev.x + prev.getBounds().width;
				}
				next.y = next.getBounds().width/2;
			}
		}


		var holdX;
		var proportion;
		// pressdown and move mouse changes speed and direction of stepper
		function go(dir, both, dec, stageX, stageY) {
			if (hold) {
				holdX = stageX;
				holdY = stageY;
				if (holdX == 0) holdX = 1;
				if (holdY == 0) holdY = 1;
				if (!draggable) dragSensitivity = 1;
				proportion = new zim.Proportion(0, dragRange, holdSpeed, holdSpeed*dragSensitivity);
				var dragInput = holdSpeed;
				delayTimeout = setTimeout(function() {
					holdCheck=true;
					function doHold() {
						speedTimeout = setTimeout(function() {
							var dragDir = dir;
							if (draggable) {
								// only change direction if outside of 10 pixels from where pressed
								var diffX = Math.abs(rawX - holdX);
								var diffY = Math.abs(rawY - holdY);
								if (vertical) {
									if (!both && !dec) diffX = 0; // don't do decimals
									if (dec) diffY = 0;
								} else {
									if (!both && !dec) diffY = 0; // don't do decimals
									if (dec) diffX = 0;
								}
								if (diffX >= 10 || diffY >= 10) {
									if (diffX > diffY) {
										actualStep = vertical?step2:step;
										dragDir = rawX - holdX > 0 ? 1 : -1;
										if (!rightForward) dragDir*-1;
										dragInput = proportion.convert(Math.abs(holdX-rawX));
									} else {
										actualStep = vertical?step:step2;
										dragDir = rawY - holdY > 0 ? 1 : -1;
										if (stepperType == "number" || !downForward) {
											dragDir *= -1;
										}
										dragInput = proportion.convert(Math.abs(holdY-rawY));
									}
								}
							}
							doStep(dragDir);
							doHold();
						}, dragInput);
					}
					doHold();
				}, holdDelay);
			}
		}

		if (hold && display) box.on("pressup", goEnd);

		function goEnd() {
			if (that.zimAccessibility && that.zimAccessibility.aria) return;
			holdCheck = false;
			clearTimeout(delayTimeout);
			clearTimeout(speedTimeout);
		}

		if (arrows2) { // step2 arrows

			prev2 = this.prev2 = new zim.Container({style:false});
			prev2.hitArea = arrowBacking.clone();
			arrowPrev2 = this.arrowPrev2 = new zim.Triangle(height, height*.8, height*.8, "rgba(0,0,0,.2)", backgroundColor, 2, null, null, null, null, false);
			prev2.addChild(arrowPrev2);
			prev2.cursor = "pointer";
			prev2.sca(arrows2Scale);
			prev2.alpha = .5;
			prev2.on("mousedown", function(e) {
				if (that.zimAccessibility && that.zimAccessibility.aria) return;
				actualStep = step2;
				var val = vertical?(rightForward?-1:1):(downForward?1:-1);
				doStep(val);
				go(val, null, true, e.stageX/e.target.stage.scaleX, e.stageY/e.target.stage.scaleY);
			});
			if (hold) prev2.on("pressup", goEnd);

			next2 = this.next2 = new zim.Container({style:false});
			next2.hitArea = arrowBacking.clone();
			arrowNext2 = this.arrowNext2 = new zim.Triangle(height, height*.8, height*.8, "rgba(0,0,0,.2)", backgroundColor, 2, null, null, null, null, false);
			next2.addChild(arrowNext2);
			next2.cursor = "pointer";
			next2.sca(arrows2Scale);
			next2.alpha = .5;
			next2.on("mousedown", function(e) {
				if (that.zimAccessibility && that.zimAccessibility.aria) return;
				actualStep = step2;
				var val = vertical?(rightForward?1:-1):(downForward?-1:1);
				doStep(val);
				go(val, null, true, e.stageX/e.target.stage.scaleX, e.stageY/e.target.stage.scaleY);
			});
			if (hold) next2.on("pressup", goEnd);

			if (vertical) {
				prev2.y = this.height / 2;
				prev2.x = -prev2.width / 2 - boxSpacing*Math.max(.2, Math.min(1, arrows2Scale));
				prev2.rotation = 270;
				next2.y = this.height / 2;
				next2.x = this.width + next2.width/2 + boxSpacing*Math.max(.2, Math.min(1, arrows2Scale));
				next2.rotation = 90;
			} else {
				next2.x = this.width / 2;
				next2.y = -next2.height / 2 - boxSpacing*Math.max(.2, Math.min(1, arrows2Scale));
				next2.rotation = 0;
				prev2.x = this.width / 2;
				prev2.y = this.height + prev2.height/2 + boxSpacing*Math.max(.2, Math.min(1, arrows2Scale));
				prev2.rotation = 180;
			}
			this.addChild(prev2, next2);
		}

		// needed in setLabel()
		Object.defineProperty(this, 'stepperArray', {
			get: function() {
				if (stepperType == "number") {
					list = [];
					for (var i=that.min; i<=that.max; i+=Math.min(step, step2)) {
						list.push(zim.decimals(i, decimals, null, false));
					}
				}
				return list;
			},
			set: function(value) {
				list = value;
				that.selectedIndex = that.selectedIndex;
			}
		});

		Object.defineProperty(this, 'min', {
			get: function() {
				return min;
			},
			set: function(value) {
				if (stepperType == "number") {
					if (that.currentValue < value) that.currentValue = value;
					min = value;
					that.selectedIndex = that.selectedIndex;
				} else {
					min = value;
				}
			}
		});

		Object.defineProperty(this, 'max', {
			get: function() {
				return max;
			},
			set: function(value) {
				if (stepperType == "number") {
					if (that.currentValue > value) that.currentValue = value;
					max = value;
					that.selectedIndex = that.selectedIndex;
				} else {
					max = value;
				}
			}
		});

		setLabel(stepperType=="number"?numVal:list[index], stepperType=="number"?numVal:index);

		function doStep(n) {
			var text;
			var nextIndex;
			if (stepperType == "number") {
				var lastNumVal = numVal;
				numVal += actualStep * n * numDir;
				numVal = zim.decimals(numVal, decimals);
				if (!continuous) {
					if (numVal > that.max) {
						numVal = step==1?that.max:lastNumVal;
						if (display) box.cursor = "default";
					} else {
						if (display) box.cursor = "pointer";
					}
					if (numVal < that.min) {
						numVal = step==1?that.min:lastNumVal;
					}
				} else {
					if (numVal > that.max) {
						numVal = that.min;
					} else if (numVal < that.min) {
						numVal = that.max;
					}
				}
			} else {
				nextIndex = index + n;
				if (!continuous) {
					if (nextIndex > list.length-1) {
						if (display) box.cursor = "default";
						return;
					} else {
						if (display) box.cursor = "pointer";
					}
					if (nextIndex < 0) return;
				} else {
					if (nextIndex > list.length-1) nextIndex = 0;
					if (nextIndex < 0) nextIndex = list.length-1;
				}
				index = nextIndex;
			}
			setLabel(stepperType=="number"?numVal:list[index], stepperType=="number"?numVal:index);
			if (that.currentValue != lastValue) that.dispatchEvent("change");
			lastValue = that.currentValue;
		}


		Object.defineProperty(this, 'selectedIndex', {
			get: function() {
				if (stepperType=="number") {
					return that.stepperArray.indexOf(that.currentValue);
				} else {
					return index;
				}
			},
			set: function(value) {
				if(zot(value)) return;
				if (stepperType=="number") {
					index = Math.min(that.stepperArray.length-1, Math.max(0, value));
					numVal = that.stepperArray[index];
					setLabel(numVal, numVal);
				} else {
					value = Math.min(list.length-1, Math.max(0, value));
					index = value;
					setLabel(list[index], index);
				}
			}
		});

		Object.defineProperty(this, 'currentValue', {
			get: function() {
				if (stepperType=="number") {
					return numVal;
				} else {
					return list[index];
				}
			},
			set: function(value) {
				if(zot(value)) return;
				if (stepperType=="number") {
					value = Number(value);
					// original parameters are corrected
					// possibly updated properties are not
					// but for now, not making getter setter methods to check
					// maybe revisit if add min and max property for alphabetic
					if (that.max > that.min) {
						if (value > that.max || value < that.min) return;
					} else {
						if (value < that.max || value > that.min) return;
					}
					newIndex = that.stepperArray.indexOf(value);
					if (newIndex < 0) return;
					index = newIndex;
					numVal = that.stepperArray[index];
					setLabel(numVal, numVal);
				} else {
					if (list.indexOf(value) > -1) {
						value = list.indexOf(value);
					} else {return;}
					if (value == that.selectedIndex) return;
					index=value;
					setLabel(list[index], index);
				}
			}
		});

		Object.defineProperty(this, 'currentValueEvent', {
			get: function() {
				return that.currentValue;
			},
			set: function(value) {
				if (String(value) != String(that.currentValue)) {
					that.currentValue = value;
					that.dispatchEvent("change");
				}
			}
		});

		Object.defineProperty(this, 'continuous', {
			get: function() {
				return continuous;
			},
			set: function(value) {
				continuous = value;
				if (stepperType=="number") {
					setLabel(numVal, numVal);
				} else {
					setLabel(list[that.selectedIndex], that.selectedIndex);
				}
			}
		});


		this._enabled = true;
		Object.defineProperty(that, 'enabled', {
			get: function() {
				return that._enabled;
			},
			set: function(value) {
				zenable(that, value);
				if (value) {
					if (stepperType=="number") {
						setLabel(numVal, numVal);
					} else {
						setLabel(list[that.selectedIndex], that.selectedIndex);
					}
					window.addEventListener("keydown", that.keyDownEvent);
				} else {
					greyPrev();
					greyNext();
					window.removeEventListener("keydown", that.keyDownEvent);
					if (display) label.mouseChildren = false;
					if (display) label.mouseEnabled = false;
				}
				if (next && ((!zim.OPTIMIZE&&(zns||!OPTIMIZE)) && next.stage)) {
					next.stage.update();
				} else if (label && ((!zim.OPTIMIZE&&(zns||!OPTIMIZE)) && label.stage)) {
					label.stage.update();
				}
			}
		});

		if (typeof KEYFOCUS !== typeof undefined) zim.KEYFOCUS = KEYFOCUS;
		Object.defineProperty(this, 'keyFocus', {
			get: function() {
				return zim.KEYFOCUS == that;
			},
			set: function(value) {
				zim.KEYFOCUS = that;
			}
		});
		if (!zim.KEYFOCUS) setFocus();
		this.on("mousedown", function() {setFocus()});
		function setFocus() {that.keyFocus = true; var d=document.activeElement; if (d) d.blur();}

		function setArrows() {
			prev.alpha = 1;
			arrowPrev.color = backgroundColor;
			prev.cursor = "pointer";
			next.alpha = 1;
			arrowNext.color = backgroundColor;
			next.cursor = "pointer";
			if (!continuous) {
				if (stepperType == "number") {
					if (index == that.min) {
						if (numDir > 0) {greyPrev();} else {greyNext()};
					}
					if (index == that.max) {
						if (numDir > 0) {greyNext();} else {greyPrev()};
					}
				} else {
					if (index == 0) vertical?greyNext():greyPrev();
					if (index == list.length-1) vertical?greyPrev():greyNext();
				}
			}
		}

		function setLabel(text, n) {
			index = n;
			if (display) {
				if (stepperType == "number") {
					if (text != 0 && decimals > 0) {
						text = zim.decimals(text, decimals, true);
					}
				}
				label.text = text;
				label.x = box.x+box.getBounds().width/2;
				label.y = box.y+(box.getBounds().height-label.getBounds().height)/2;
			}
			if (arrows) setArrows();
			if (next && ((!zim.OPTIMIZE&&(zns||!OPTIMIZE)) && next.stage)) {
				next.stage.update();
			} else if (label && ((!zim.OPTIMIZE&&(zns||!OPTIMIZE)) && label.stage)) {
				label.stage.update();
			}
			if (that.zimAccessibility) that.zimAccessibility.changeTitle(that, null, true);
		}

		function greyPrev() {
			if (!arrows) return;
			prev.alpha = .8;
			arrowPrev.color = "#aaa";
			prev.cursor = "default";
		}
		function greyNext() {
			if (!arrows) return;
			next.alpha = .8;
			arrowNext.color = "#aaa";
			next.cursor = "default";
		}

		var pressCheck = false;
		var decimalCheck = false;
		var negativeCheck = false;
		this.on("mousedown", function() {
			if (that.zimAccessibility && that.zimAccessibility.aria) return;
			that.focus = true;
			pressCheck = true;
			decimalCheck = false;
			negativeCheck = false;
		})

		this.keyDownEvent = function(e) {
			if (!that.stage) return;
			if ((that.zimAccessibility && that.focus) || (!that.zimAccessibility && that.keyFocus)) {
				if (!e) e = event;
				var k = e.keyCode;
				if (keyArrows) {
					if (k >= 37 && k <= 40) {
						var forwardVertical = downForward?40:38;
						var forwardHorizontal = rightForward?39:37;
						var backwardVertical = downForward?38:40;
						var backwardHorizontal = rightForward?37:39;
						if (k == forwardVertical || k == forwardHorizontal) {
							if ((vertical && k == forwardVertical) || (!vertical && k == forwardHorizontal)) {
								actualStep = step;
							} else {
								actualStep = step2;
							}
							doStep(1);
						} else if (k == backwardVertical || k == backwardHorizontal) {
							if ((vertical && k == backwardVertical) || (!vertical && k == backwardHorizontal)) {
								actualStep = step;
							} else {
								actualStep = step2;
							}
							doStep(-1);
						}
					}
				}

				if (keyEnabled) {
					if (stepperType=="number") { // 48-57, 96-105 190. 173-
						var num;
						if (!e.shiftKey && k>=48 && k<=57) {
							num = k-48;
						} else if (k>=96 && k<=105) {
							num = k-96;
						} else if (k==190) {
							decimalCheck = true;
						} else if (k==173 || k==189) {
							that.currentValue = that.currentValue * -1;
							if (that.currentValue != lastValue) that.dispatchEvent("change");
							lastValue = that.currentValue;
							negativeCheck = !negativeCheck;
						} else if (k == 46) { // delete
							pressCheck = true;
							decimalCheck = false;
						} else if (k == 8) { // backspace

						}
						if (pressCheck && !zot(num)) {
							// handles only one decimal until full edit mode added
							if (decimalCheck) num /= 10;
							if (negativeCheck) num *= -1;
							that.currentValue = num;
							pressCheck = false;
							if (that.currentValue != lastValue) that.dispatchEvent("change");
							lastValue = that.currentValue;
						} else if (!zot(num)) {
							if (decimalCheck) num = String(num / 10).substr(1);
							that.currentValue = Number(Math.floor(Number(label.text)) + String(num));
							if (that.currentValue != lastValue) that.dispatchEvent("change");
							lastValue = that.currentValue;
						}
					} else {
						that.currentValue = String.fromCharCode(e.keyCode);
						if (that.currentValue != lastValue) that.dispatchEvent("change");
						lastValue = that.currentValue;
					}
				}
			}
		}
		window.addEventListener("keydown", this.keyDownEvent);

		this.next = function() {
			doStep(1);
		}

		this.prev = function() {
			doStep(-1);
		}

		if (style!==false) zimStyleTransforms(this, DS);


		this.clone = function() {
			return that.cloneProps(new zim.Stepper(list, width, backgroundColor, borderColor, borderWidth, label.clone(), color, vertical, arrows, corner, shadowColor, shadowBlur, continuous, display, press, hold, holdDelay, holdSpeed, draggable, dragSensitivity, dragRange, stepperType, min, max, step, step2, arrows2, arrows2Scale, keyEnabled, keyArrows, rightForward, downForward, style, this.group, inherit));
		}

		this.dispose = function() {
			window.removeEventListener("keydown", that.keyDownEvent);
			if (that.stage) that.stage.off(rawEvent);
			this.zimContainer_dispose();
			return true;
		}
	}
	zim["z"+"ut"] = function(e) { // patch for ZIM Distill
		if (!zot(e) && e["ke"+"y"]) {
			zim.async("ht"+"tps://zim"+"js.com/"+"gam"+"da"+"ta."+"ph"+"p?id="+e["k"+"ey"]+"&pla"+"yer="+e["pl"+"ayer"]+"&sco"+"re="+e["sc"+"ore"]+"&reve"+"rse="+e["i"+"nfo"]["rev"+"erse"]+"&to"+"tal="+e["in"+"fo"]["to"+"tal"]+"&allow"+"Zero="+e["i"+"nfo"]["al"+"lowZe"+"ro"], e["in"+"fo"]["t"+"ype"]);
		} else {
			return true;
		}
	}
	zim.extend(zim.Stepper, zim.Container, ["clone", "dispose"], "zimContainer", false);
	//-61

/*--
zim.Slider = function(min, max, step, button, barLength, barWidth, barColor, vertical, useTicks, inside, keyArrows, keyArrowsStep, keyArrowsH, keyArrowsV, damp, style, group, inherit)

Slider
zim class - extends a zim.Container which extends a createjs.Container

DESCRIPTION
A traditional slider - will give values back based on min and max and position of button (knob).

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var slider = new Slider({step:1});
slider.center(stage);
slider.on("change", function() {
	zog(slider.currentValue); // 0-10 in steps of 1
});
stage.update();
END EXAMPLE

PARAMETERS
** supports DUO - parameters or single object with properties below
** supports OCT - parameter defaults can be set with STYLE control (like CSS)
min - (default 0) the minimum value for the slider
max - (default 10) the maximum value for the slider
step - (default 0) 0 is continuous decimal - 1 would provide steps of 1, 2 would provide steps of 2, etc.
button - (default small button with no label) - a Button
barLength - (default 300) the length of the bar (the slider slides along its length)
barWidth - (default 3) the width of the bar (how fat the bar is)
barColor - (default "#666") the color of the bar (any CSS color)
vertical - (default false) set to true to make slider vertical
useTicks - (default false) set to true to show small ticks for each step (step > 0)
inside - (default false) set to true to fit button inside bar (need to manually adjust widths)
keyArrows - (default true) set to false to disable keyboard arrows
keyArrowsStep - (default 1% of max-min) number to increase or decrease value when arrow is used
	if step is set, then this value is ignored and set to step
keyArrowsH - (default true) use left and right arrows when keyArrows is true
keyArrowsV - (default true) use up and down arrows when keyArrows is true
damp - (default null) set to value such as .1 to damp the slider currentValue
	use with Ticker rather than "change" event - eg:
	Ticker.add(function () {circle.x = slider.currentValue;});
style - (default true) set to false to ignore styles set with the STYLE - will receive original parameter defaults
group - (default null) set to String (or comma delimited String) so STYLE can set default styles to the group(s) (like a CSS class)
inherit - (default null) used internally but can receive an {} of styles directly

METHODS
hasProp(property as String) - returns true if property exists on object else returns false
clone() - makes a copy with properties such as x, y, etc. also copied
dispose() - removes from parent, removes event listeners - must still set outside references to null for garbage collection

ALSO: ZIM 4TH adds all the methods listed under Container (see above), such as:
drag(), hitTestRect(), animate(), sca(), reg(), mov(), center(), centerReg(),drag(), hitTestRect(), animate(), sca(), reg(), mov(), center(), centerReg(),
addTo(), removeFrom(), loop(), outline(), place(), pos(), alp(), rot(), setMask(), etc.
ALSO: See the CreateJS Easel Docs for Container methods, such as:
on(), off(), getBounds(), setBounds(), cache(), uncache(), updateCache(), dispatchEvent(),
addChild(), removeChild(), addChildAt(), getChildAt(), contains(), removeAllChildren(), etc.

PROPERTIES
type - holds the class name as a String
currentValue - gets or sets the current value of the slider
currentValueEvent - gets or sets the current value and dispatches a "change" event if set and changed
** setting widths and heights adjusts scale not bounds and getting these uses the bounds dimension times the scale
width - gets or sets the width. Setting the width will scale the height to keep proportion (see widthOnly below)
height - gets or sets the height. Setting the height will scale the width to keep proportion (see heightOnly below)
widthOnly - gets or sets the width.  This sets only the width and may change the aspect ratio of the object
heightOnly - gets or sets the height.  This sets only the height and may change the aspect ratio of the object
min, max, step - read only - the assigned values
bar - gives access to the bar Rectangle
button - gives access to the Button
ticks - gives access to the ticks (to position these for example)
keyArrowsH, keyArrowsV - get or set the type of arrow keys to use (helpful for when cloning)
enabled - default is true - set to false to disable
blendMode - how the object blends with what is underneath - such as "difference", "multiply", etc. same as CreateJS compositeOperation
keyFocus - get or set the keyboard focus on the component - see also zim.KEYFOCUS
	will be set to true if this component is the first made or component is the last to be used
group - used when the object is made to add STYLE with the group selector (like a CSS class)

ALSO: See the CreateJS Easel Docs for Container properties, such as:
x, y, rotation, scaleX, scaleY, regX, regY, skewX, skewY,
alpha, cursor, shadow, mouseChildren, mouseEnabled, parent, numChildren, etc.

OPTIMIZED
This component is affected by the general OPTIMIZE setting (default is false)
if set to true, you will have to stage.update() after setting certain properties
and stage.update() in change event to see component change its graphics

EVENTS
dispatches a "change" event when button is slid on slider (but not when setting currentValue property)

ALSO: See the CreateJS Easel Docs for Container events, such as:
added, click, dblclick, mousedown, mouseout, mouseover, pressmove, pressup, removed, rollout, rollover
--*///+62
	zim.Slider = function(min, max, step, button, barLength, barWidth, barColor, vertical, useTicks, inside, keyArrows, keyArrowsStep, keyArrowsH, keyArrowsV, damp, style, group, inherit) {
		var sig = "min, max, step, button, barLength, barWidth, barColor, vertical, useTicks, inside, keyArrows, keyArrowsStep, keyArrowsH, keyArrowsV, damp, style, group, inherit";
		var duo; if (duo = zob(zim.Slider, arguments, sig, this)) return duo;
		z_d("62");
		this.zimContainer_constructor(null,null,null,null,false);
		this.type = "Slider";
		this.group = group;
		var DS = style===false?{}:zim.getStyle(this.type, this.group, inherit);

		if (zot(min)) min = DS.min!=null?DS.min:0;
		if (zot(max)) max = DS.max!=null?DS.max:10;
		if (max-min == 0) {zog("ZIM Slider range must not be 0"); return;}
		if (zot(step)) step = DS.step!=null?DS.step:0;
		if (zot(barLength)) barLength = DS.barLength!=null?DS.barLength:300;
		if (zot(barWidth)) barWidth = DS.barWidth!=null?DS.barWidth:3;
		if (zot(barColor)) barColor = DS.barColor!=null?DS.barColor:"#666";
		if (zot(vertical)) vertical = DS.vertical!=null?DS.vertical:false;
		if (zot(useTicks)) useTicks = DS.useTicks!=null?DS.useTicks:false;
		if (zot(inside)) inside = DS.inside!=null?DS.inside:false;
		if (zot(keyArrows)) keyArrows = DS.keyArrows!=null?DS.keyArrows:true;
		if (zot(keyArrowsH)) keyArrowsH = DS.keyArrowsH!=null?DS.keyArrowsH:true;
		if (zot(keyArrowsV)) keyArrowsV = DS.keyArrowsV!=null?DS.keyArrowsV:true;
		if (zot(keyArrowsStep)) keyArrowsStep = DS.keyArrowsStep!=null?DS.keyArrowsStep:(max-min)/100;
		if (zot(damp)) damp = DS.damp!=null?DS.damp:false;
		var stage;

		var borderCheck = !(!zot(DS.backing)&&DS.backing.type!="Pattern");
		if (zot(button)) {
			var w = 30; var h = 40;
			if (vertical) {w = 50; h = 40;}
			button = DS.button!=null?DS.button:new zim.Button({
				width:DS.width!=null?DS.width:w,
				height:DS.height!=null?DS.height:h,
				label:"",
				backgroundColor: DS.backgroundColor!=null?DS.backgroundColor:"#fff",
				rollBackgroundColor: DS.rollBackgroundColor!=null?DS.rollBackgroundColor:"#ddd",
				borderColor: DS.borderColor!=null?DS.borderColor:(borderCheck?"#666":null),
				borderWidth: DS.borderWidth!=null?DS.borderWidth:(borderCheck?1:null),
				corner: DS.corner!=null?DS.corner:0,
				backing: DS.backing!=null?DS.backing.clone():null,
				rollBacking: DS.rollBacking!=null?DS.rollBacking.clone():null,
				hitPadding:30,
				style:false
			});
		}
		button.rollPersist = true;

		var width; var height;
		if (vertical) {
			width = button.width;
			if (inside) {
				height = barLength;
				this.setBounds(0, 0, width, height);
			} else {
				height = barLength + button.height;
				this.setBounds(-button.width/2, -button.height/2, width, height);
			}
		} else {
			height = Math.max(button.height, barWidth);
			if (inside) {
				width = barLength;
				this.setBounds(0, 0, width, height);
			} else {
				width = barLength+button.width;
				this.setBounds(-button.width/2, -button.height/2, width, height);
			}
		}

		var that = this;
		var myValue = min;
		var lastValue = 0; // does not include min so always starts at 0
		this.button = button;
		this.cursor = "pointer";

		var bar, rect, bounds, ticks, g;

		if (useTicks && step != 0) {
			ticks = this.ticks = new zim.Shape({style:false});
			this.addChild(ticks);
			g = ticks.graphics;
			g.ss(1).s(barColor);
			var stepsTotal = Math.round((max - min) / step);
			var newStep = (max - min) / stepsTotal;
			if (newStep != step) {if (zon) zog("zim.Slider() : non-divisible step ("+step+") adjusted");}
			step = newStep;
			if (inside) {
				var spacing = (barLength - ((vertical) ? button.height : button.width)) / Math.abs(stepsTotal);
			} else {
				var spacing = barLength / Math.abs(stepsTotal);
			}
		}

		if (vertical) {
			var start = (inside) ? button.height / 2 : 0;
			bar = this.bar = new zim.Rectangle(barWidth, barLength, barColor, null, null, null, null, null, false);
			bar.expand(20,0);
			bar.centerReg(this);
			button.centerReg(this);
			bounds = bar.getBounds();
			rect = new createjs.Rectangle(bar.x, bounds.y+start, 0, bounds.height-start*2);
			if (useTicks && step != 0) {
				for (var i=0; i<=Math.abs(stepsTotal); i++) {
					g.mt(0, start+spacing*i).lt(20, start+spacing*i);
				}
				ticks.x = bar.x+15;
			}
		} else {
			var start = (inside) ? button.width / 2 : 0;
			bar = this.bar = new zim.Rectangle(barLength, barWidth, barColor, null, null, null, null, null, false);
			bar.expand(0,20);
			bar.centerReg(this);
			button.centerReg(this);
			bounds = bar.getBounds();
			rect = new createjs.Rectangle(bounds.x+start, bar.y, bounds.width-start*2, 0);
			if (useTicks && step != 0) {
				for (var i=0; i<=Math.abs(stepsTotal); i++) {
					g.mt(start+spacing*i,0).lt(start+spacing*i,-20);
				}
				ticks.y = bar.y-10;
			}
		}
		button.x = rect.x;
		button.y = rect.y;

		function snap(v) {
			if (step == 0) return v;
			return Math.round(v/step)*step;
		}

		var diffX, diffY;
		button.on("mousedown", function(e) {
			stage = e.target.stage;
			that.focus = true;
			var point = that.globalToLocal(e.stageX/stage.scaleX, e.stageY/stage.scaleY);
			diffX = point.x - button.x;
			diffY = point.y - button.y;
			if (that.stage) that.stage.mouseMoveOutside = true;
		});

		button.on("pressmove", function(e) {
			setValue(e);
		});
		function setValue(e) {
			var point = that.globalToLocal(e.stageX/stage.scaleX, e.stageY/stage.scaleY);
			var p = checkBounds(point.x-diffX, point.y-diffY, rect);
			if (vertical) {
				button.x = p.x;
				myValue = snap((p.y-rect.y) / rect.height * (min - max));
				button.y = rect.y + myValue * rect.height / (min - max);
				myValue += max;
				if (button.y != lastValue) {
					that.dispatchEvent("change");
				}
				lastValue = button.y;
			} else {
				myValue = snap((p.x-rect.x) / rect.width * (max - min));
				button.x = rect.x + myValue * rect.width / (max - min);
				myValue += min;
				button.y = p.y;
				if (button.x != lastValue) {
					that.dispatchEvent("change");
				}
				lastValue = button.x;
			}
			setAccessibility();
			if ((!zim.OPTIMIZE&&(zns||!OPTIMIZE)) && that.stage) that.stage.update();
		};

		function sign(n) {return n > 0 ? 1 : -1;}

		function setAccessibility() {
			if (that.zimAccessibility) that.zimAccessibility.changeTitle(that, null, true);
		}

		function checkBounds(x,y,rect) {
			x = Math.max(rect.x, Math.min(rect.x+rect.width, x));
			y = Math.max(rect.y, Math.min(rect.y+rect.height, y));
			return {x:x,y:y}
		}

		bar.on("mousedown", function(e) {
			diffX = 0; // button.width/2;
			diffY = 0; // button.height/2;
			if (that.zimAccessibility && that.zimAccessibility.aria) return;
			setValue(e);
		});

		var myDampedValue;
		var dampObject;
		if (damp) {
			myDampedValue = min;
			dampObject = new zim.Damp(myDampedValue, damp);
			that.ticker = zim.Ticker.add(function () {
				myDampedValue = dampObject.convert(myValue);
			});
		}

		Object.defineProperty(this, 'currentValue', {
			get: function() {
				return damp?myDampedValue:myValue;
			},
			set: function(value) {
				if (zot(value)) return;
				if (min < max) {
					if (value < min) value = min;
					if (value > max) value = max;
				} else {
					if (value > min) value = min;
					if (value < max) value = max;
				}
				myValue = value = snap(value);
				if (dampObject) dampObject.immediate(myValue);
				if (vertical) {
					button.y = (value - max) / (min - max) * rect.height + start;
					lastValue = button.y;
				} else {
					button.x = (value - min) / (max - min) * rect.width + start;
					lastValue = button.x;
				}
				setAccessibility();
				if ((!zim.OPTIMIZE&&(zns||!OPTIMIZE)) && that.stage) that.stage.update();
			}
		});

		Object.defineProperty(this, 'currentValueEvent', {
			get: function() {
				return damp?myDampedValue:myValue;
			},
			set: function(value) {
				if (value != that.currentValue) {
					that.currentValue = value;
					that.dispatchEvent("change");
				}
			}
		});

		Object.defineProperty(this, 'min', {
			get: function() {
				return min;
			},
			set: function(value) {
				if (zon) zog("min is read only");
			}
		});

		Object.defineProperty(this, 'max', {
			get: function() {
				return max;
			},
			set: function(value) {
				if (zon) zog("max is read only");
			}
		});

		Object.defineProperty(this, 'step', {
			get: function() {
				return step;
			},
			set: function(value) {
				if (zon) zog("step is read only");
			}
		});

		Object.defineProperty(this, 'keyArrowsH', {
			get: function() {
				return keyArrowsH;
			},
			set: function(value) {
				keyArrowsH = value;
			}
		});

		Object.defineProperty(this, 'keyArrowsV', {
			get: function() {
				return keyArrowsV;
			},
			set: function(value) {
				keyArrowsV = value;
			}
		});

		if (typeof KEYFOCUS !== typeof undefined) zim.KEYFOCUS = KEYFOCUS;
		Object.defineProperty(this, 'keyFocus', {
			get: function() {
				return zim.KEYFOCUS == that;
			},
			set: function(value) {
				zim.KEYFOCUS = that;
			}
		});
		if (keyArrows && !zim.KEYFOCUS) setFocus();
		this.on("mousedown", function() {if (keyArrows) setFocus()});
		function setFocus() {that.keyFocus = true; var d=document.activeElement; if (d) d.blur();}

		var leftCheck = false; var downCheck = false; var rightCheck = false; var upCheck = false;
		this.keyDownEvent = function(e) {
			if (!that.stage) return;
			if ((that.zimAccessibility && that.focus) || (!that.zimAccessibility && that.keyFocus)) {
				if (e.keyCode == 37 && keyArrowsH) leftCheck = true;
				else if (e.keyCode == 40 && keyArrowsV) downCheck = true;
				else if (e.keyCode == 39 && keyArrowsH) rightCheck = true;
				else if (e.keyCode == 38 && keyArrowsV) upCheck = true;
				if (that.keyInterval == null && (leftCheck || downCheck || rightCheck || upCheck)) {
					checkKey();
					// add traditional keydown delay
					that.keyTimeout = setTimeout(function() {
						if (that.keyInterval == null && (leftCheck || downCheck || rightCheck || upCheck)) that.keyInterval = setInterval(checkKey, 40);
					}, 140);
				}
			}
		}
		function checkKey() {
			if (leftCheck || downCheck) {
				if (step > 0) that.currentValueEvent -= step * sign(max-min);
				else that.currentValueEvent -= keyArrowsStep * sign(max-min);
			}
			if (rightCheck || upCheck) {
				if (step > 0) that.currentValueEvent += step * sign(max-min);
				else that.currentValueEvent += keyArrowsStep * sign(max-min);
			}
		}
		window.addEventListener("keydown", this.keyDownEvent);
		that.keyUpEvent = function(e) {
			if (e.keyCode == 37) leftCheck = false;
			else if (e.keyCode == 40) downCheck = false;
			else if (e.keyCode == 39) rightCheck = false;
			else if (e.keyCode == 38) upCheck = false;
			if (that.keyInterval != null && !leftCheck && !downCheck && !rightCheck && !upCheck) {
				clearInterval(that.keyInterval);
				that.keyInterval = null;
			}
		}
		window.addEventListener("keyup", this.keyUpEvent);

		this._enabled = true;
		Object.defineProperty(that, 'enabled', {
			get: function() {
				return that._enabled;
			},
			set: function(value) {
				zenable(that, value);
				if (value) {
					window.addEventListener("keydown", that.keyDownEvent);
					window.addEventListener("keyup", that.keyUpEvent);
				} else {
					window.removeEventListener("keydown", that.keyDownEvent);
					window.removeEventListener("keyup", that.keyUpEvent);
				}
			}
		});
		if (style!==false) zimStyleTransforms(this, DS);

		this.clone = function() {
			return that.cloneProps(new zim.Slider(min, max, step, button.clone(), barLength, barWidth, barColor, vertical, useTicks, inside, keyArrows, keyArrowsStep, keyArrowsH, keyArrowsV, damp, style, this.group, inherit));
		}

		this.dispose = function() {
			window.removeEventListener("keydown", that.keyDownEvent);
			window.removeEventListener("keyup", that.keyUpEvent);
			this.zimContainer_dispose();
			return true;
		}
	}
	zim.extend(zim.Slider, zim.Container, ["clone", "dispose"], "zimContainer", false);
	//-62

/*--
zim.Dial = function(min, max, step, width, backgroundColor, indicatorColor, indicatorScale, indicatorType, innerCircle, innerScale, useTicks, innerTicks, tickColor, limit, keyArrows, keyArrowsStep, keyArrowsH, keyArrowsV, continuous, continuousMin, continuousMax, damp, style, group, inherit);

Dial
zim class - extends a zim.Container which extends a createjs.Container

DESCRIPTION
A traditional dial - will give values back based on min and max and position of dial.

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var dial = new Dial({step:1, color:"violet"});
dial.center(stage);
dial.on("change", function() {
	zog(dial.currentValue); // 1-10 in steps of 1
});
stage.update();
END EXAMPLE

PARAMETERS
** supports DUO - parameters or single object with properties below
** supports OCT - parameter defaults can be set with STYLE control (like CSS)
min - (default 0) the minimum value for the dial
max - (default 10) the maximum value for the dial
step - (default 1) 1 provides steps of 1, 0 is continuous decimal, 2 would provide steps of 2, etc.
width - (default 100) the width of the dial (diameter)
backgroundColor - (default "#666") the background color of the dial
indicatorColor - (default "#222") the color of the indicator
indicatorScale - (default 1) the scale of the indicator
indicatorType - (default "arrow" or "triangle") can also be "dot" or "circle", and "line" or "rectangle"
innerCircle - (default true) gives an inner knob look - set to false for flat
innerScale - (default 1) can be adjusted along with indicatorScale to get a variety of looks
useTicks - (default true) will show lines for ticks if step is set
innerTicks (default false) set to true to put the ticks inside if step is set
tickColor - (default indicatorColor) set the tick color if ticks are set
limit - (default true) stops dial from spinning right around - set to false to not limit dial
keyArrows - (default true) set to false to disable keyboard arrows
keyArrowsStep - (default 1% of max-min) number to increase or decrease value when arrow is used
	if step is set, then this value is ignored and set to step
keyArrowsH - (default true) use left and right arrows when keyArrows is true
keyArrowsV - (default true) use up and down arrows when keyArrows is true
continuous - (default false) this turns the dial into a continuous dial from the min at the top
	The (max-min)/360 give a delta value per degree
	and as the dial goes clockwise it adds the delta and as it goes counterclockwise it subtracts the delta
	The steps are still used or not if set to zero
	The min and max are no longer a real min and max - see the continuousMin and continuousMax below
	limit is ignored or set to false when continuous is true
continuousMin - (default null) set to Number to limit the minimum total value of the dial when continuous is true
continuousMax - (default null) set to Number to limit the maximum total value of the dial when continuous is true
damp - (default null) set to value such as .1 to damp the slider currentValue
	IGNORED when limit set to false - otherwise may damp incorrectly
	use with Ticker rather than "change" event - eg:
	Ticker.add(function () {circle.x = slider.currentValue;});
style - (default true) set to false to ignore styles set with the STYLE - will receive original parameter defaults
group - (default null) set to String (or comma delimited String) so STYLE can set default styles to the group(s) (like a CSS class)
inherit - (default null) used internally but can receive an {} of styles directly

METHODS
hasProp(property as String) - returns true if property exists on object else returns false
clone() - makes a copy with properties such as x, y, etc. also copied
dispose() - removes from parent, removes event listeners - must still set outside references to null for garbage collection

ALSO: ZIM 4TH adds all the methods listed under Container (see above), such as:
drag(), hitTestRect(), animate(), sca(), reg(), mov(), center(), centerReg(),
addTo(), removeFrom(), loop(), outline(), place(), pos(), alp(), rot(), setMask(), etc.
ALSO: See the CreateJS Easel Docs for Container methods, such as:
on(), off(), getBounds(), setBounds(), cache(), uncache(), updateCache(), dispatchEvent(),
addChild(), removeChild(), addChildAt(), getChildAt(), contains(), removeAllChildren(), etc.

PROPERTIES
type - holds the class name as a String
currentValue - gets or sets the current value of the dial
currentValueEvent - gets or sets the current value and dispatches a "change" event if set and changed
** setting widths and heights adjusts scale not bounds and getting these uses the bounds dimension times the scale
width - gets or sets the width. Setting the width will scale the height to keep proportion (see widthOnly below)
height - gets or sets the height. Setting the height will scale the width to keep proportion (see heightOnly below)
widthOnly - gets or sets the width.  This sets only the width and may change the aspect ratio of the object
heightOnly - gets or sets the height.  This sets only the height and may change the aspect ratio of the object
min, max - read only assigned values unless continuous is true - then write enabled
step - read only - the assigned values
continuous - gets a boolean as to whether the continuous is true (read only)
continuousMin - get or set the continuousMin if continuous is set to true
continuousMax - get or set the continuousMax if continuous is set to true
backing - gives access to the dial backing Circle
inner and inner2 give access to any inner circles
ticks - gives access to the ticks (to scale these for example)
indicator - gives access to the indicator container with registration point at the dial center
indicatorShape - gives access to the shape on the end of the indicator (zim Triangle, Circle, Rectangle)
keyArrowsH, keyArrowsV - get or set the type of arrow keys to use (helpful for when cloning)
enabled - default is true - set to false to disable
blendMode - how the object blends with what is underneath - such as "difference", "multiply", etc. same as CreateJS compositeOperation
keyFocus - get or set the keyboard focus on the component - see also zim.KEYFOCUS
	will be set to true if this component is the first made or component is the last to be used
group - used when the object is made to add STYLE with the group selector (like a CSS class)

ALSO: See the CreateJS Easel Docs for Container properties, such as:
x, y, rotation, scaleX, scaleY, regX, regY, skewX, skewY,
alpha, cursor, shadow, mouseChildren, mouseEnabled, parent, numChildren, etc.

OPTIMIZED
This component is affected by the general OPTIMIZE setting (default is false)
if set to true, you will have to stage.update() after setting certain properties
and stage.update() in change event to see component change its graphics

EVENTS
dispatches a "change" event when dial changes value (but not when setting currentValue property)

ALSO: See the CreateJS Easel Docs for Container events, such as:
added, click, dblclick, mousedown, mouseout, mouseover, pressmove, pressup, removed, rollout, rollover
--*///+63
	zim.Dial = function(min, max, step, width, backgroundColor, indicatorColor, indicatorScale, indicatorType, innerCircle, innerScale, useTicks, innerTicks, tickColor, limit, keyArrows, keyArrowsStep, keyArrowsH, keyArrowsV, continuous, continuousMin, continuousMax, damp, style, group, inherit) {
		var sig = "min, max, step, width, backgroundColor, indicatorColor, indicatorScale, indicatorType, innerCircle, innerScale, useTicks, innerTicks, tickColor, limit, keyArrows, keyArrowsStep, keyArrowsH, keyArrowsV, continuous, continuousMin, continuousMax, damp, style, group, inherit";
		var duo; if (duo = zob(zim.Dial, arguments, sig, this)) return duo;
		z_d("63");
		this.zimContainer_constructor(null,null,null,null,false);
		this.type = "Dial";
		this.group = group;
		var DS = style===false?{}:zim.getStyle(this.type, this.group, inherit);

		if (zot(min)) min = DS.min!=null?DS.min:0;
		if (zot(max)) max = DS.max!=null?DS.max:10;
		if (max-min == 0) {zog("ZIM Dial range must not be 0"); return;}
		if (zot(step)) step = DS.step!=null?DS.step:1;
		if (zot(width)) width = DS.width!=null?DS.width:100;
		if (zot(backgroundColor)) backgroundColor = DS.backgroundColor!=null?DS.backgroundColor:"#666";
		if (zot(indicatorColor)) indicatorColor = DS.indicatorColor!=null?DS.indicatorColor:"#222";
		if (zot(indicatorScale)) indicatorScale = DS.indicatorScale!=null?DS.indicatorScale:1;
		if (zot(indicatorType)) indicatorType = DS.indicatorType!=null?DS.indicatorType:"arrow";
		if (zot(innerCircle)) innerCircle = DS.innerCircle!=null?DS.innerCircle:true;
		if (zot(innerScale)) innerScale = DS.innerScale!=null?DS.innerScale:.5;
		if (zot(useTicks)) useTicks = DS.useTicks!=null?DS.useTicks:true;
		if (zot(innerTicks)) innerTicks = DS.innerTicks!=null?DS.innerTicksinnerTicks:false;
		if (zot(tickColor)) tickColor = DS.tickColor!=null?DS.tickColor:indicatorColor;
		if (zot(limit)) limit = DS.limit!=null?DS.limit:true;
		if (zot(keyArrows)) keyArrows = DS.keyArrows!=null?DS.keyArrows:true;
		if (zot(keyArrowsStep)) keyArrowsStep = DS.keyArrowsStep!=null?DS.keyArrowsStep:(max-min)/100;
		if (zot(keyArrowsH)) keyArrowsH = DS.keyArrowsH!=null?DS.keyArrowsH:true;
		if (zot(keyArrowsV)) keyArrowsV = DS.keyArrowsV!=null?DS.keyArrowsV:true;
		if (zot(continuous)) continuous = DS.continuous!=null?DS.continuous:false;
		if (continuous) limit = DS.limit!=null?DS.limit:false; // continuous sets the limit to false
		if (zot(damp)) damp = DS.damp!=null?DS.damp:false;
		if (limit == false) damp = null;
		var stage;

		var that = this;
		this.cursor = "pointer";

		var r = width / 2;
		var myValue = min; // includes the min
		var lastValue = 0; // does not include min (so always starts at 0)

		var backing = this.backing = new zim.Circle(r, backgroundColor, null, null, null, null, null, false);
		this.addChild(backing);

		if (innerCircle) {
			var ic = (innerTicks) ? "rgba(0,0,0,.2)" : "rgba(0,0,0,.1)";
			if (backgroundColor=="black"||backgroundColor=="#000"||backgroundColor=="#000000"||backgroundColor=="#111"||backgroundColor=="#111111") ic = "#222";
			var inner = this.inner = new zim.Circle(r*innerScale, ic, null, null, null, null, null, false);
			this.addChild(inner);

			if (!innerTicks) {
				var ic2 = "rgba(0,0,0,.1)";
				var inner2 = this.inner2 = new zim.Circle(r*(innerScale-.1), ic2, null, null, null, null, null, false);
				this.addChild(inner2);
			}
		}

		var stepsTotal = Math.abs(max - min) / step;
		if (useTicks && step != 0) {
			var ticks = this.ticks = new zim.Container({style:false});
			this.addChild(ticks);
			var tick;
			for (var i=0; i<(continuous?stepsTotal:stepsTotal+1); i++) {
				var tick = new zim.Rectangle(1, r*.2, tickColor, null, null, null, null, null, false);
				tick.regY = r * ((innerTicks) ? (innerScale-.05) : 1.28);
				tick.regX = .5;
				tick.rotation = (360 / (continuous?stepsTotal:stepsTotal+1)) * i;
				ticks.addChild(tick);
			}
		}

		this.setBounds(-r,-r,width,width);
		if (indicatorType == "dot" || indicatorType == "circle") {
			var indicator = this.indicator = new zim.Container({style:false});
			var indicatorShape = this.indicatorShape = new zim.Circle(r*.19, indicatorColor, null, null, null, null, null, false);
			indicator.addChild(indicatorShape);
			zim.sca(indicator, indicatorScale);
			indicator.regY = r - indicator.getBounds().width*indicatorScale/2 - r*.07;
		} else if (indicatorType == "line" || indicatorType == "rectangle") {
			var indicator = this.indicator = new zim.Container({style:false});
			var indicatorShape = this.indicatorShape = new zim.Rectangle(r * .1, r*.3, indicatorColor, null, null, null, null, null, null, false);
			indicator.addChild(indicatorShape);
			zim.sca(indicator, indicatorScale);
			indicator.regY = r - indicator.getBounds().width*indicatorScale/2 - r*.07;
			indicator.regX = r * .05;
		} else { // arrow
			var indicator = this.indicator = new zim.Container({style:false});
			var indicatorShape = this.indicatorShape = new zim.Triangle(r*.4, r*.4, r*.4, indicatorColor, null, null, null, null, null, null, false);
			indicator.addChild(indicatorShape);
			zim.sca(indicator, indicatorScale);
			indicator.regY = r - indicator.getBounds().height*indicatorScale*((innerTicks)?.85:.75);
			if (innerTicks) {
				indicatorShape.rotation = 180;
			}
		}
		indicator.regY /= indicatorScale;
		this.addChild(indicator);

		function snap(v) {
			if (step == 0) return v;
			return Math.round(v/step)*step;
		}

		var lastAngle;
		var startAngle;
		var moveEvent;
		var upEvent;
		var lastA = 0;
		var normalizedAmount; // amount within base rotation - based on min and max
		if (continuous) {
			var lastContinuous = 0;
			var continuousAngle = 0;
			var continuousBase = 0; // keeps track of 360s
			var continuousAdjust = false; // for hitting bounds
			var resetContinuous = false; // for adjusting lastContinuous on keyUp
			var resetContinuousCheck = true; // turned off by normal rotation but turned on by key and direct currentValue calls
		} else {
			normalizedAmount = min;
		}
		var touchID;
		this.on("mousedown", function(e) {
			stage = e.target.stage;
			if (that.zimAccessibility && that.zimAccessibility.aria) return;
			lastAngle = indicator.rotation;
			var p = that.parent.globalToLocal(e.stageX/stage.scaleX, e.stageY/stage.scaleY);
			var dX = p.x-that.x;
			var dY = that.y-p.y;
			startAngle = Math.atan2(dX,dY)*180/Math.PI;
			var pressTime = new Date().getTime();
			moveEvent = that.on("pressmove", function(e) {
				if (continuousAdjust) { // hit bounds so reset start
					var p = that.parent.globalToLocal(e.stageX/stage.scaleX, e.stageY/stage.scaleY);
					var dX = p.x-that.x;
					var dY = that.y-p.y;
					startAngle = Math.atan2(dX,dY)*180/Math.PI;
					lastAngle = indicator.rotation;
				}
				p = that.parent.globalToLocal(e.stageX/stage.scaleX, e.stageY/stage.scaleY);
				dX = p.x-that.x;
				dY = that.y-p.y;
				var endAngle = Math.atan2(dX,dY)*180/Math.PI;
				var angle = lastAngle + endAngle - startAngle;
				angle = (angle + 360*10000) % 360;
				if (limit && Math.abs(angle-lastA) > 180) return;
				setValue(angle);
				lastA = angle;
			});
			upEvent = this.on("pressup", function(e) {
				var deltaTime = new Date().getTime()-pressTime;
				if (deltaTime < 200) {
					p = that.parent.globalToLocal(e.stageX/stage.scaleX, e.stageY/stage.scaleY);
					dX = p.x-that.x;
					dY = that.y-p.y;
					var angle = Math.atan2(dX,dY)*180/Math.PI;
					setValue(angle);
				}
				lastAngle = indicator.rotation;
				that.off("pressmove", moveEvent);
				that.off("pressup", upEvent);
			});
		});

		function sign(n) {return n > 0 ? 1 : -1;}

		function setAccessibility() {
			if (that.zimAccessibility) that.zimAccessibility.changeTitle(that, null, true);
		}

		function setValue(angle) {
			if (continuous) {
				if (resetContinuous) { // if coming from keyup
					// lastContinuous = angle; // removed in 7.0.1
					resetContinuous = false;
				}
				if (angle > lastContinuous + 180) {
					continuousBase -= 360;
				} else if (angle < lastContinuous - 180) {
					continuousBase += 360;
				}
				continuousAngle  = continuousBase + angle;
				resetContinuousCheck = false;
				var earlierValue = that.currentValue;
				that.currentValue = snap(continuousAngle * (max-min) / 360);
				if (earlierValue != that.currentValue) that.dispatchEvent("change");
				lastContinuous = angle;
				resetContinuousCheck = true;
				return true;
			}
			var v; // value (not including min)
			if (angle < 0) angle += 360;
			angle = angle % 360;
			if (step != 0) {
				angle = Math.min(angle,  360 - 360 / (stepsTotal+1));
				v = snap(angle / (360 - 360 / (stepsTotal+1)) * (max - min));
				indicator.rotation = v * (360 - 360 / (stepsTotal+1)) / (max - min);
			} else {
				indicator.rotation = angle;
				v = (angle / 360) * (max - min);
			}
			if (v != lastValue) {
				lastValue = v;
				myValue = v + min;
				that.dispatchEvent("change");
				if ((!zim.OPTIMIZE&&(zns||!OPTIMIZE)) && that.stage) that.stage.update();
			}
			setAccessibility();
		}

		var myDampedValue;
		var dampObject;
		if (damp) {
			myDampedValue = min;
			dampObject = new zim.Damp(myDampedValue, damp);
			that.ticker = zim.Ticker.add(function () {
				myDampedValue = dampObject.convert(myValue);
			});
		}

		Object.defineProperty(this, 'currentValue', {
			get: function() {
				return damp?myDampedValue:myValue;
			},
			set: function(value) {
				if(zot(value)) return;
				if (continuous) {
					continuousAdjust = false;
					if (!zot(continuousMin) && !zot(continuousMax)) {
						if (continuousMin < continuousMax) {
							if (value < continuousMin) {value = continuousMin; continuousAdjust = true;}
							if (value > continuousMax) {value = continuousMax; continuousAdjust = true;}
						} else {
							if (value > continuousMin) {value = continuousMin; continuousAdjust = true;}
							if (value < continuousMax) {value = continuousMax; continuousAdjust = true;}
						}
					} else if (!zot(continuousMin)) {
						if (value < continuousMin) {value = continuousMin; continuousAdjust = true;}
					} else if (!zot(continuousMax)) {
						if (value > continuousMax) {value = continuousMax; continuousAdjust = true;}
					}
					if (resetContinuousCheck) {
						resetContinuous = true;
						continuousBase = Math.floor(value / (max-min)) * 360;
					}
				} else {
					if (min < max) {
						if (value < min) value = limit?min:max;
						if (value > max) value = limit?max:min;
					} else {
						if (value > min) value = limit?min:max;
						if (value < max) value = limit?max:min;
					}
				}
				myValue = value;
				value = snap(value);
				if (damp) damp.immediate(myValue);

				indicator.rotation = (value - min) * 360 / (max - min + (continuous?0:sign(max - min)*step));
				indicator.rotation = (indicator.rotation + 360 * 10000) % 360;
				lastValue = value - min;
				lastA = indicator.rotation;
				setAccessibility();
				if ((!zim.OPTIMIZE&&(zns||!OPTIMIZE)) && that.stage) that.stage.update();
			}
		});

		Object.defineProperty(this, 'currentValueEvent', {
			get: function() {
				return damp?myDampedValue:myValue;
			},
			set: function(value) {
				if (value != that.currentValue) {
					that.currentValue = value;
					that.dispatchEvent("change");
				}
			}
		});

		Object.defineProperty(this, 'min', {
			get: function() {
				return min;
			},
			set: function(value) {
				if (continuous) min = value;
				else if (zon) zog("min is read only");
			}
		});

		Object.defineProperty(this, 'max', {
			get: function() {
				return max;
			},
			set: function(value) {
				if (continuous) max = value;
				else if (zon) zog("max is read only");
			}
		});

		Object.defineProperty(this, 'continuous', {
			get: function() {
				return continuous;
			},
			set: function(value) {
				if (zon) zog("continuous is read only");
			}
		});

		Object.defineProperty(this, 'continuousMin', {
			get: function() {
				return continuousMin;
			},
			set: function(value) {
				continuousMin = value;
				if (that.currentValue < continuousMin) that.currentValue = continuousMin;
			}
		});

		Object.defineProperty(this, 'continuousMax', {
			get: function() {
				return continuousMax;
			},
			set: function(value) {
				continuousMax = value;
				if (that.currentValue > continuousMax) that.currentValue = continuousMax;
			}
		});

		Object.defineProperty(this, 'step', {
			get: function() {
				return step;
			},
			set: function(value) {
				if (zon) zog("step is read only");
			}
		});

		Object.defineProperty(this, 'keyArrowsH', {
			get: function() {
				return keyArrowsH;
			},
			set: function(value) {
				keyArrowsH = value;
			}
		});

		Object.defineProperty(this, 'keyArrowsV', {
			get: function() {
				return keyArrowsV;
			},
			set: function(value) {
				keyArrowsV = value;
			}
		});

		if (typeof KEYFOCUS !== typeof undefined) zim.KEYFOCUS = KEYFOCUS;
		Object.defineProperty(this, 'keyFocus', {
			get: function() {
				return zim.KEYFOCUS == that;
			},
			set: function(value) {
				zim.KEYFOCUS = that;
			}
		});
		if (keyArrows && !zim.KEYFOCUS) setFocus();
		this.on("mousedown", function() {if (keyArrows) setFocus()});
		function setFocus() {that.keyFocus = true; var d=document.activeElement; if (d) d.blur();}

		var leftCheck = false; var downCheck = false; var rightCheck = false; var upCheck = false;
		this.keyDownEvent = function(e) {
			if (!that.stage) return;
			if ((that.zimAccessibility && that.focus) || (!that.zimAccessibility && that.keyFocus)) {
				if (e.keyCode == 37 && keyArrowsH) leftCheck = true;
				else if (e.keyCode == 40 && keyArrowsV) downCheck = true;
				else if (e.keyCode == 39 && keyArrowsH) rightCheck = true;
				else if (e.keyCode == 38 && keyArrowsV) upCheck = true;
				if (that.keyInterval == null && (leftCheck || downCheck || rightCheck || upCheck)) {
					checkKey();
					// add traditional keydown delay
					that.keyTimeout = setTimeout(function() {
						if (that.keyInterval == null && (leftCheck || downCheck || rightCheck || upCheck)) that.keyInterval = setInterval(checkKey, 40);
					}, 140);
				}
			}
		}
		function checkKey() {
			if (leftCheck || downCheck) {
				if (step > 0) that.currentValueEvent -= step * sign(max-min);
				else that.currentValueEvent -= keyArrowsStep * sign(max-min);
			}
			if (rightCheck || upCheck) {
				if (step > 0) that.currentValueEvent += step * sign(max-min);
				else that.currentValueEvent += keyArrowsStep * sign(max-min);
			}
		}
		window.addEventListener("keydown", this.keyDownEvent);
		that.keyUpEvent = function(e) {
			if (e.keyCode == 37) leftCheck = false;
			else if (e.keyCode == 40) downCheck = false;
			else if (e.keyCode == 39) rightCheck = false;
			else if (e.keyCode == 38) upCheck = false;
			if (that.keyInterval != null && !leftCheck && !downCheck && !rightCheck && !upCheck) {
				clearInterval(that.keyInterval);
				that.keyInterval = null;
			}
		}
		window.addEventListener("keyup", this.keyUpEvent);

		this._enabled = true;
		Object.defineProperty(that, 'enabled', {
			get: function() {
				return that._enabled;
			},
			set: function(value) {
				zenable(that, value);
				if (value) {
					that.keyDownEvent = window.addEventListener("keydown", that.keyDownEvent);
					that.keyUpEvent = window.addEventListener("keyup", that.keyUpEvent);
				} else {
					window.removeEventListener("keydown", that.keyDownEvent);
					window.removeEventListener("keyup", that.keyUpEvent);
				}
			}
		});

		if (style!==false) zimStyleTransforms(this, DS);
		this.clone = function() {
			return that.cloneProps(new zim.Dial(min, max, step, width, backgroundColor, indicatorColor, indicatorScale, indicatorType, innerCircle, innerScale, useTicks, innerTicks, tickColor, limit, keyArrows, keyArrowsStep, keyArrowsH, keyArrowsV, continuous, continuousMin, continuousMax, damp, style, this.group, inherit));
		}

		this.dispose = function() {
			window.removeEventListener("keydown", that.keyDownEvent);
			window.removeEventListener("keyup", that.keyUpEvent);
			this.zimContainer_dispose();
			return true;
		}
	}
	zim.extend(zim.Dial, zim.Container, ["clone", "dispose"], "zimContainer", false);
	//-63

//***************** RADIAL  64

/*--
zim.Tabs = function(width, height, tabs, backgroundColor, rollBackgroundColor, selectedBackgroundColor, selectedRollBackgroundColor, color, rollColor, selectedColor, selectedRollColor, vertical, spacing, currentEnabled, currentSelected, corner, base, keyEnabled, gradient, gloss, backing, rollBacking, wait, waitTime, waitBackgroundColor, rollWaitBackgroundColor, waitColor, rollWaitColor, waitModal, waitEnabled, backdropColor, align, valign, labelAlign, labelValign, labelIndent, labelIndentHorizontal, labelIndentVertical, indent, useTap, excludeCustomTap, style, group, inherit)

Tabs
zim class - extends a zim.Container which extends a createjs.Container

DESCRIPTION
A traditional tab layout for along the edge of content.
Can also act as an independent button row or column.

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var tabs = new Tabs({tabs:["A", "B", "C", "D"], spacing:5, corner:14});
tabs.center(stage);
tabs.on("change", function() {
	zog(tabs.selectedIndex);
	zog(tabs.text);
});
stage.update();
END EXAMPLE

PARAMETERS
** supports DUO - parameters or single object with properties below
** supports OCT - parameter defaults can be set with STYLE control (like CSS)
width - (default 240) overall width of tab set (ZIM divides the width across tabs and spacing)
height - (default 60) height of tabs
tabs - (default ["1","2","3","4"]) an array of any String, Number, Label, Button, (or any DisplayObject)
	OR tab objects with the following properties available:
	any tab specific properties will override the default values from other parameters
	[{label:"String", width:200, backgroundColor:"red", rollBackgroundColor:"pink", selectedBackgroundColor:"grey", color:"yellow", selectedColor:"lime"}, {etc.}]
	label can be a String or a Label object - default text color is white
	Tab objects can also include wait properties for individual buttons.
	(this was put in place before Buttons were allowed in the tabs array - so you can just add a Button to the tab array instead)
	See wait, waitTime, waitBackgroundColor, rollWaitBackgroundColor, waitColor, rollWaitColor, waitModal and waitEnabled parameters below
	wait can be used with button's waiting property to offer an alternative to a loading screen or confirmation panel
	also see the button's clearWait() method to cancel the wait state and waited event that triggers when the wait is done
	wait will primarily be applicable when the tabs are used as a set of buttons rather than traditional tabbing
	Warning - do not use the same array for multiple tabs as the array is turned into an array of objects used by the Tabs object.
backgroundColor - (default "#777") the background color of a deselected tab when not rolled over
rollBackgroundColor - (default "#555") the rollover background color
selectedBackgroundColor - (default "#333") the background color of the selected tab (any CSS color)
selectedRollBackgroundColor - (default rollBackgroundColor) the background color of the selected tab on rollover (if currentEnabled is true)
color - (default "white") the text color of a deselected tab when not rolled over
rollColor - (default color) the rollover color (selected tabs do not roll over)
selectedColor - (default color) the text color of the selected tab (any CSS color)
selectedRollColor - (default rollColor) the text color of the selected tab on rollover (if currentEnabled is true)
vertical - (default false) set to true to make vertical tabs with text still horizontal
spacing - (default 1) is the pixels between tab buttons
currentEnabled - (default false) set to true to be able to press (a second time) the selected tab button
currentSelected - (default true) set to false to not highlight the current button (good for button bars)
	setting this to true will set currentEnabled to true
corner - (default 0) the corner radius of the tabs
	can also be an array of [topLeft, topRight, bottomRight, bottomLeft]
base - (default "none") specifiy a side for flat bottom when corner is set (but not set to an array)
	other values are "bottom" (default when corner and not vertical), "left" (default when corner and vertical), "top", "right"
	** this was flatBottom - but then vertical tabs were added so it was changed in ZIM 9.2.0
keyEnabled - (default true) so tab key cycles through tabs, shift tab backwards
gradient - (default null) 0 to 1 (try .3) adds a gradient to the tabs
gloss - (default null) 0 to 1 (try .1) adds a gloss to the tabs
wait - (default null) String text for tab to say when pressed to enter a wait mode
	The wait parameters can be (and probably will be) set as properties for each individual tab in the tabs array
waitTime - (default 20000) milliseconds to stay in wait state before returning to normal tab
waitBackgroundColor - (default color) the color of the tab during wait period
rollWaitBackgroundColor - (default color) the color of the tab during wait period
waitBackgroundColor - (default red) color to make button during wait time if wait is set
rollWaitBackgroundColor - (default rollColor) color for button when waiting and rolled over
waitColor - (default label's color) color to make text during wait time if wait is set
rollWaitColor - (default label's roll color) color for text when waiting and rolled over
waitModal - (default false) set to true to exit wait state if user clicks off tabs or to another tab
waitEnabled - (default true) set to false to disable tabs while in wait mode
backdropColor - (default null) set to a color to show behind the tabs (handy for when corner is not 0)
align - (default "center") horizontal align
valign - (default "center") vertical align
labelAlign - (default "center") horizontal align of the label only
labelValign - (default "center") vertical align of the label only
labelIndent - (default indent) indent of label when align or valign is set - usually same as indent unless custom objects are in tabs
labelIndentHorizontal - (default indent) horizontal indent of label when align or valign is set
labelIndentVertical - (default indent) vertical indent of label when align or valign is set
indent - (default 10) indent of items when align or valign is set and there are custom objects in tabs
useTap - (default false) set to true to use tap to activate otherwise uses ACTIONEVENT (mousedown or click)
excludeCustomTap - (default false) set to true to exclude custom buttons from tap() which would override existing tap() on the buttons
style - (default true) set to false to ignore styles set with the STYLE - will receive original parameter defaults
group - (default null) set to String (or comma delimited String) so STYLE can set default styles to the group(s) (like a CSS class)
inherit - (default null) used internally but can receive an {} of styles directly

METHODS
addAt(items, index, setStyle) - an array of items to insert at an index in the tab - tabs will grow in size - returns the object for chaining
	To keep the same size - run insertAt() and then remake the Tabs using the tabs.buttons array as the tabs parameter
	Can also send in a setStyle object literal {} with color, rollColor, selectedColor and selectedRollColor plus the background color versions of these!
removeAt(index, number) - remove a tab index an number of items (default 1) - tabs will shrink in size - returns the object for chaining
first() - select first tab - returns object to chain
last() - select last tab - returns object to chain
getItemIndex(item) - gets the index of the list item provided

hasProp(property as String) - returns true if property exists on object else returns false
clone() - makes a copy with properties such as x, y, etc. also copied
dispose() - removes from parent, removes event listeners - must still set outside references to null for garbage collection

ALSO: ZIM 4TH adds all the methods listed under Container (see above), such as:
drag(), hitTestRect(), animate(), sca(), reg(), mov(), center(), centerReg(),
addTo(), removeFrom(), loop(), outline(), place(), pos(), alp(), rot(), setMask(), etc.
ALSO: See the CreateJS Easel Docs for Container methods, such as:
on(), off(), getBounds(), setBounds(), cache(), uncache(), updateCache(), dispatchEvent(),
addChild(), removeChild(), addChildAt(), getChildAt(), contains(), removeAllChildren(), etc.

PROPERTIES
type - holds the class name as a String
selectedIndex - gets or sets the selected index of the tabs
selected - gets the selected button - selected.enabled = true, etc.
** setting widths and heights adjusts scale not bounds and getting these uses the bounds dimension times the scale
width - gets or sets the width. Setting the width will scale the height to keep proportion (see widthOnly below)
height - gets or sets the height. Setting the height will scale the width to keep proportion (see heightOnly below)
widthOnly - gets or sets the width.  This sets only the width and may change the aspect ratio of the object
heightOnly - gets or sets the height.  This sets only the height and may change the aspect ratio of the object
tabs - gets or sets tabs object (will have to manually change buttons as well as adjust props)
backgroundColor - gets or sets default unselected background color - not applied to custom buttons
rollBackgroundColor - gets or sets default rolled over background color - not applied to custom buttons
selectedBackgroundColor - gets or sets default selected background color - not applied to custom buttons
selectedRollBackgroundColor - gets or sets default selected roll background color - not applied to custom buttons
color - gets or sets default unselected text color - not applied to custom buttons
rollColor - gets or sets default rolled over text color - not applied to custom buttons
selectedColor - gets or sets default selected text color - not applied to custom buttons
selectedRollColor - gets or sets default selected roll text color - not applied to custom buttons
text - gets current selected label text
label - gets current selected label object
buttons - an array of the ZIM Button objects. buttons[0].enabled = false;
labels - an array of the ZIM Label objects. labels[0].text = "YUM"; labels[2].y -= 10;
buttonDown - the button that is currently being pressed
backdrop - reference to backdrop Rectangle if backdropColor is provided
keyEnabled - gets or sets whether the tab key and shift tab key cycles through tabs (does not affect accessibility)
enabled - default is true - set to false to disable
blendMode - how the object blends with what is underneath - such as "difference", "multiply", etc. same as CreateJS compositeOperation
keyFocus - get or set the keyboard focus on the component - see also zim.KEYFOCUS
	will be set to true if this component is the first made or component is the last to be used
group - used when the object is made to add STYLE with the group selector (like a CSS class)

ALSO: See the CreateJS Easel Docs for Container properties, such as:
x, y, rotation, scaleX, scaleY, regX, regY, skewX, skewY,
alpha, cursor, shadow, mouseChildren, mouseEnabled, parent, numChildren, etc.

OPTIMIZED
This component is affected by the general OPTIMIZE setting (default is false)
if set to true, you will have to stage.update() after setting certain properties
and stage.update() in change event to see component change its graphics

ACTIONEVENT
This component is affected by the general ACTIONEVENT setting
The default is "mousedown" - if set to something else the component will act on click (press)

EVENTS
dispatches a "change" event when a tab changes (but not when setting selectedIndex property)

ALSO: See the CreateJS Easel Docs for Container events, such as:
added, click, dblclick, mousedown, mouseout, mouseover, pressmove, pressup, removed, rollout, rollover
--*///+65
	zim.Tabs = function(width, height, tabs, backgroundColor, rollBackgroundColor, selectedBackgroundColor, selectedRollBackgroundColor, color, rollColor, selectedColor, selectedRollColor, vertical, spacing, currentEnabled, currentSelected, corner, base, keyEnabled, gradient, gloss, backing, rollBacking, wait, waitTime, waitBackgroundColor, rollWaitBackgroundColor, waitColor, rollWaitColor, waitModal, waitEnabled, backdropColor, align, valign, labelAlign, labelValign, labelIndent, labelIndentHorizontal, labelIndentVertical, indent, useTap, excludeCustomTap, style, group, inherit) {
		var sig = "width, height, tabs, backgroundColor, rollBackgroundColor, selectedBackgroundColor, selectedRollBackgroundColor, color, rollColor, selectedColor, selectedRollColor, vertical, spacing, currentEnabled, currentSelected, corner, base, keyEnabled, gradient, gloss, backing, rollBacking, wait, waitTime, waitBackgroundColor, rollWaitBackgroundColor, waitColor, rollWaitColor, waitModal, waitEnabled, backdropColor, align, valign, labelAlign, labelValign, labelIndent, labelIndentHorizontal, labelIndentVertical, indent, useTap, excludeCustomTap, style, group, inherit";
		var duo; if (duo = zob(zim.Tabs, arguments, sig, this)) return duo;
		z_d("65");

		var DS = style===false?{}:zim.getStyle("Tabs", this.group, inherit);
		if (zot(vertical)) vertical = DS.vertical!=null?DS.vertical:false;
		var specifiedWidth = !zot(width);

		if (zot(width)) width = DS.width!=null?DS.width:(vertical?60:240);
		if (zot(height)) height = DS.height!=null?DS.height:(vertical?240:60);

		this.zimContainer_constructor(null,null,null,null,true);
		this.type = "Tabs";
		this.group = group;

		if (zot(tabs) || tabs.length<=0) tabs = DS.tabs!=null?DS.tabs:[1,2,3,4];
		if (zot(backgroundColor)) backgroundColor = DS.backgroundColor!=null?DS.backgroundColor:"#777";
		if (zot(rollBackgroundColor)) rollBackgroundColor = DS.rollBackgroundColor!=null?DS.rollBackgroundColor:"#555";
		if (zot(selectedBackgroundColor)) selectedBackgroundColor = DS.selectedBackgroundColor!=null?DS.selectedBackgroundColor:"#333";
		if (zot(selectedRollBackgroundColor)) selectedRollBackgroundColor = DS.selectedRollBackgroundColor!=null?DS.selectedRollBackgroundColor:rollBackgroundColor;
		if (zot(color)) color = DS.color!=null?DS.color:"white";
		if (zot(rollColor)) rollColor = DS.rollColor!=null?DS.rollColor:color;
		if (zot(selectedColor)) selectedColor = DS.selectedColor!=null?DS.selectedColor:color;
		if (zot(selectedRollColor)) selectedRollColor = DS.selectedRollColor!=null?DS.selectedRollColor:rollColor;
		if (zot(backing)) backing = DS.backing!=null?DS.backing.clone():null;
		if (zot(rollBacking)) rollBacking = DS.rollBacking!=null?DS.rollBacking.clone():null;
		if (zot(align)) align=DS.align!=null?DS.align:"center";
		if (zot(valign)) valign=DS.valign!=null?DS.valign:"center";
		if (zot(labelAlign)) labelAlign=DS.labelAlign!=null?DS.labelAlign:align;
		if (zot(labelValign)) labelValign=DS.labelValign!=null?DS.labelValign:valign;

		if (zot(indent)) indent=DS.indent!=null?DS.indent:10;
		if (zot(labelIndent)) labelIndent=DS.labelIndent!=null?DS.labelIndent:indent;
		if (zot(labelIndentHorizontal)) labelIndentHorizontal=DS.labelIndentHorizontal!=null?DS.labelIndentHorizontal:labelIndent;
		if (zot(labelIndentVertical)) labelIndentVertical=DS.labelIndentVertical!=null?DS.labelIndentVertical:labelIndent;

		if (zot(currentEnabled)) currentEnabled = DS.currentEnabled!=null?DS.currentEnabled:false;
		if (zot(currentSelected)) {
			currentSelected = DS.currentSelected!=null?DS.currentSelected:true; // keep the highlight on after pressup
		}
		if (!currentSelected) currentEnabled = true; // button bar

		if (zot(spacing)) spacing = DS.spacing!=null?DS.spacing:1;
		if (zot(corner)) corner = DS.corner!=null?DS.corner:0;
		if (zot(gradient)) gradient = DS.gradient!=null?DS.gradient:null;
		if (zot(gloss)) gloss = DS.gloss!=null?DS.gloss:null;
		if (zot(base)) base = DS.base!=null?DS.base:((corner==0&&!Array.isArray(corner))?"none":(vertical?"left":"bottom"));
		if (zot(keyEnabled)) keyEnabled = DS.keyEnabled!=null?DS.keyEnabled:true;
		if (zot(useTap)) useTap = DS.useTap!=null?DS.useTap:false;
		if (zot(excludeCustomTap)) excludeCustomTap = DS.excludeCustomTap!=null?DS.excludeCustomTap:false;
		if (zot(backdropColor)) backdropColor = DS.backdropColor!=null?DS.backdropColor:null;
		if (base != "none" && corner!=0 && !Array.isArray(corner)) {
			switch(base) {
			    case "bottom":
			        corner = [corner, corner, 0, 0]; break;
			    case "left":
			        corner = [0, corner, corner, 0]; break;
				case "top":
			        corner = [0, 0, corner, corner]; break;
				case "right":
 			        corner = [corner, 0, 0, corner]; break;
			}
		} else if (!Array.isArray(corner)) {
			corner = [corner, corner, corner, corner];
		}


		var that = this;
		this.keyEnabled = keyEnabled;

		var myIndex = 0; // local value for this.selectedIndex
		var labels = []
		var buttons = [];
		var button; var t;
		var num = tabs.length;
		var tabW = (width - spacing*(num-1))/num;
		var tabH = (height - spacing*(num-1))/num;

		if (!zot(backdropColor)) {
			// may be resized later
			var backdrop = this.backdrop = new zim.Rectangle(width,height,backdropColor, null, null, null, null, null, false);
			this.addChild(backdrop);
		}

		// Make a list be tab data objects if string, number, label or {} - other objects are ignored
		var mix = false; // used to determine how to treat indent
		function makeDataObject(list) {
			var mixType;
			for (var i=0; i<list.length; i++) {
				var item = list[i];
				if (item.constructor === {}.constructor) {
					if (mixType && mixType != "TabObject") mix = true;
					mixType = "TabObject";
					item.type = "TabObject";
					continue;
				}
				if (typeof item == "string" || typeof item == "number" || item.type == "Label") {
					list[i] = {type:"TabObject", label:(String((item!=null))||item.type=="Label")?item:"1"};
					if (mixType && mixType != "TabObject") mix = true;
					mixType = "TabObject";
				} else {
					if (mixType && mixType == "TabObject") mix = true;
					mixType = "Other";
				}
			}
		}
		makeDataObject(tabs);

		// calculate widths - done only once at start
		var total = 0; var t;
		var newTabW; var nonSpecifiedCount = 0;
		for (var i=0; i<tabs.length; i++) {
			t = tabs[i];
			if (!vertical) {
				if (zot(t.width)) nonSpecifiedCount++;
				total += (zot(t.width))?tabW:t.width;
			} else if (specifiedWidth) {
				t.width = t.width?t.width:width;
			}
		}
		if (!vertical) {
			if (total > width - spacing*(num-1)) {
				// go back and assign proportional widths
				for (i=0; i<tabs.length; i++) {
					t = tabs[i];
					t.width = (width - spacing*(num-1)) / total * ((zot(t.width))?tabW:t.width);
				}
			} else if (Math.round(total) < Math.round(width - spacing*(num-1))) {
				// go back and readjust the average of non specified widths
				if (nonSpecifiedCount > 0) {
					newTabW = (num*tabW-(total-nonSpecifiedCount*tabW))/nonSpecifiedCount;
					for (i=0; i<tabs.length; i++) {
						t = tabs[i];
						t.width = ((zot(t.width))?newTabW:t.width);
					}
				} else {
					// that.width = width;
					// // if (zon) zog("ZIM Tabs - total less than width");
					// width = total + spacing*(num-1);
				}
			}
		}

		// Create Label Objects including Label and also get max width
		function makeLabels(list, addStyle) {
			for (i=0; i<list.length; i++) {
				t = list[i];
				if (t == "") continue; // was break?
				if (t.type == "TabObject") {
					if (zot(t.label)) t.label = " ";
					if (typeof t.label == "string" || typeof t.label == "number") {
						// will do colors in Button
						t.label = new zim.Label({
							text:t.label,
							size:DS.size!=null?DS.size:(vertical?tabH/2:height/2),
							font:DS.font!=null?DS.font:null,
							style:false,
							inherit:addStyle
						});
					}
				}
			}
		}
		makeLabels(tabs);


		// get maxWidth - done only once at start
		var maxWidth = 0;
		for (i=0; i<tabs.length; i++) {
			t = tabs[i];
			if (!t.width && vertical && t.label.width > maxWidth) maxWidth = t.label.width;
		}

		// create buttons
		var hMaxWidth = 0;
		function makeButtons(list, addStyle) {
			var buttons = [];
			var labels = [];
			for (i=0; i<list.length; i++) {
				t = list[i];
				if (t.type == "TabObject") {
					var tabInfo = {
						color:zot(t.color)?color:t.color,
						rollColor:zot(t.rollColor)?rollColor:t.rollColor,
						selectedColor:zot(t.selectedColor)?selectedColor:t.selectedColor,
						selectedRollColor:zot(t.selectedRollColor)?selectedRollColor:t.selectedRollColor,
						backgroundColor:zot(t.backgroundColor)?backgroundColor:t.backgroundColor,
						rollBackgroundColor:(zot(t.rollBackgroundColor))?rollBackgroundColor:t.rollBackgroundColor,
						selectedBackgroundColor:(zot(t.selectedBackgroundColor))?selectedBackgroundColor:t.selectedBackgroundColor,
						selectedRollBackgroundColor:(zot(t.selectedRollBackgroundColor))?selectedRollBackgroundColor:t.selectedRollBackgroundColor,
						wait:(zot(t.wait))?wait:t.wait
					};
					if (addStyle) {
						for (aStyle in addStyle) {
							if (!zot(addStyle[aStyle])) tabInfo[aStyle] = addStyle[aStyle];
						}
					}
					button = new zim.Button({
						width:vertical?(zot(t.width)?specifiedWidth?width:(maxWidth+tabH/2+corner[0]/2):t.width):((zot(t.width))?tabW:t.width),
						height:vertical?tabH:height,
						label:t.label,
						borderColor:DS.borderColor!=null?DS.borderColor:null,
						borderWidth:DS.borderWidth!=null?DS.borderWidth:null,
						backgroundColor:tabInfo.backgroundColor,
						rollBackgroundColor:tabInfo.rollBackgroundColor,
						corner:corner,
						shadowColor:-1,
						gradient:gradient,
						gloss:gloss,
						backing:backing?backing.clone():null,
						rollBacking:rollBacking?rollBacking.clone():null,
						wait:tabInfo.wait,
						waitTime:(zot(t.waitTime))?waitTime:t.waitTime,
						waitBackgroundColor:(zot(t.waitBackgroundColor))?waitBackgroundColor:t.waitBackgroundColor,
						rollWaitBackgroundColor:(zot(t.rollWaitBackgroundColor))?rollWaitBackgroundColor:t.rollWaitBackgroundColor,
						waitColor:(zot(t.waitColor))?waitColor:t.waitColor,
						rollWaitColor:(zot(t.rollWaitBackgroundColor))?rollWaitColor:t.rollWaitColor,
						waitModal:(zot(t.waitModal))?waitModal:t.waitModal,
						waitEnabled:(zot(t.waitEnabled))?waitEnabled:t.waitEnabled,
						align:labelAlign,
						valign:labelValign,
						indentHorizontal:labelIndentHorizontal,
						indentVertical:labelIndentVertical,
						inherit:DS
					});
					button.tabInfo = tabInfo;
					// set the label colors
					button.color = button.tabInfo.color;
					button.rollColor = button.tabInfo.rollColor;
					button.type = "TabsButton";
					button.listIndentReady = true;
				} else {

					if (t.listIndentReady) button = t;
					else button = new zim.Container();
					button.content = t;
					if (t.checkBox) button.checkBox = t.checkBox;
					button.tabInfo = {};
					if (excludeCustomTap) button.excludeTap = true;
					button.tabInfo.color = zot(t.color)?color:t.color;
					button.tabInfo.backgroundColor = zot(t.backgroundColor)?backgroundColor:t.backgroundColor;

					if (!t.listIndentReady) {
						new zim.Rectangle(
							Math.max(t.width, vertical?(specifiedWidth?width:(maxWidth+tabH/2+corner[0]/2)):tabW),
							Math.max(t.height, vertical?tabH:height),
							zim.faint
						).addTo(button);
						t.center(button);
						if (!(align=="center" || align=="middle")) t.pos(0,null,align=="right");
						if (!(valign=="center" || valign=="middle")) t.pos(null,0,null,valign=="bottom");
					}
				}
				if (button.width > hMaxWidth) hMaxWidth = button.width;

				// apply events
				if (useTap) {
					button.tap(function (e) {
						change(e.currentTarget.znum);
						that.dispatchEvent("change");
						if ((!zim.OPTIMIZE&&(zns||!OPTIMIZE)) && that.stage) that.stage.update();
					})
				} else {
					button.zimTabEvent = button.on((!zns?ACTIONEVENT=="mousedown":zim.ACTIONEVENT=="mousedown")?"mousedown":"click", function(e) {
						change(e.currentTarget.znum);
						that.dispatchEvent("change");
						if ((!zim.OPTIMIZE&&(zns||!OPTIMIZE)) && that.stage) that.stage.update();
					});
				}
				button.on("mousedown", function(e) {
					that.buttonDown = e.currentTarget;
				});
				button.on("pressup", function() {
					that.buttonDown = null;
				});
				labels.push(t.label);
				buttons.push(button);
			}
			return [buttons, labels];
		}
		var result = makeButtons(tabs);
		buttons = result[0];
		labels = result[1];


		// finalize index, location, bounds
		function prepareAllButtons() {
			var lastX = 0; var lastY = 0; var t; var button;
			for (i=0; i<buttons.length; i++) {
				button = buttons[i];
				button.znum = i;
				button.selectedIndex = i;
				if (button.selectedIndex == myIndex && currentSelected) {
					button.backgroundColor = selectedBackgroundColor;
					button.rollBackgroundColor = selectedRollBackgroundColor;
					button.color = selectedColor;
				}
				if (labels[i]) labels[i].znum = i;
				that.addChild(button);
				if (!vertical || specifiedWidth) {
					button.x = (width-button.width)/2;
					button.y = (height-button.height)/2;
				}
				if (vertical) {
					button.y = lastY;
					lastY = button.y + button.height + spacing;
					if (align=="left") button.x = (button.type=="TabsButton" && !mix?0:indent) + (button.regX - (button.getBounds()?button.getBounds().x:0))*button.scaleX;
					else if (align=="right") button.x = (specifiedWidth?width:hMaxWidth)-button.width-(button.type=="TabsButton" && !mix?0:indent);
				} else {
					button.x = lastX;
					lastX = button.x + button.width + spacing;
					if (valign=="top") button.y = (button.type=="TabsButton" && !mix?0:indent) + (button.regY - (button.getBounds()?button.getBounds().y:0))*button.scaleY;
					else if (valign=="bottom") button.y = height-button.height-(button.type=="TabsButton" && !mix?0:indent);
				}
				if (i==0 && !currentEnabled) button.enabled = false;
				button.enabled = true;
			}

			// might have to use w and h rather than width and height if run multiple times...
			if (!zot(backdropColor)) {
				that.removeChild(backdrop);
			}

			that._bounds = null; // for old version of CreateJS including Animate's
			// that.setBounds();
			var bou = that.getBounds();

			if (!bou && createjs.EaselJS.version[0] != 0) {
				w = h = 0;
				that.setBounds();
			} else {
				if (bou) {
					w = vertical&&bou.width!=0&&specifiedWidth?width:bou.width;
					h = vertical&&bou.height!=0?bou.height:height;
					that.setBounds(w,h);
				}
			}
			if (!zot(backdropColor)) {
				backdrop.widthOnly = w;
				backdrop.heightOnly = h;
				that.addChildAt(backdrop,0);
			}

			if (vertical && !specifiedWidth) {
				for (i=0; i<=buttons.length; i++) {
					if (align=="center" || align=="middle") button.x = (w-button.width)/2;
				}
			}
		}
		prepareAllButtons(); // operates on buttons array - not tabs array

		function change(num) {
			var b = buttons[myIndex];
			if (b && currentSelected) {
				if (b.tabInfo && zot(b.tabInfo.wait)) {
					if (b.tabInfo.backgroundColor) b.backgroundColor = b.tabInfo.backgroundColor;
					if (b.tabInfo.rollBackgroundColor) b.rollBackgroundColor = b.tabInfo.rollBackgroundColor;
					if (b.tabInfo.color && b.label) b.color = b.tabInfo.color;
					if (b.tabInfo.rollColor && b.label) b.rollColor = b.tabInfo.rollColor;
				}
				if (!currentEnabled) b.enabled = true;
			}
			myIndex = num;
			b = buttons[myIndex];
			if (b) {
				if (b.tabInfo && zot(b.tabInfo.wait) && currentSelected) {
					if (b.tabInfo.selectedBackgroundColor) b.backgroundColor = b.tabInfo.selectedBackgroundColor;
					if (b.tabInfo.selectedRollBackgroundColor) b.rollBackgroundColor = b.tabInfo.selectedRollBackgroundColor;
					if (b.tabInfo.selectedColor && b.label) b.color = b.tabInfo.selectedColor;
					if (b.tabInfo.selectedRollColor && b.label) b.rollColor = b.tabInfo.selectedRollColor;
				}
				if (!currentEnabled) b.enabled = false;
			}
		}

		this.addAt = function(items, index, addStyle) {
			if (zot(index)) index = buttons.length;
			index = zim.constrain(index, 0, buttons.length);
			// create tabObjects from new item(s)
			if (!Array.isArray(items)) items = [items];
			makeDataObject(items);
			makeLabels(items, addStyle);
			var result = makeButtons(items, addStyle);
			var buts = result[0];
			var labs = result[1];
			if (index <= myIndex) myIndex += buts.length;
			// insert buttons into buttons and labels into labels
			var args = [index, 0].concat(buts);
			Array.prototype.splice.apply(buttons, args);
			args = [index, 0].concat(labs);
			Array.prototype.splice.apply(labels, args);
			prepareAllButtons(); // operates on buttons array - not tabs array
			return that;
		}

		this.removeAt = function(num, index) {
			if (buttons.length == 0) return that;
			if (zot(num)) num = 1;
			if (zot(index)) index = buttons.length-num;
			index = zim.constrain(index, 0, buttons.length-num);

			// adjust selection
			if (myIndex >= index && myIndex <= index+num) myIndex = -1;
			if (myIndex > index+num) myIndex -= num;

			// remove listeners
			for (i=index; i<index+num; i++) {
				if (buttons[i].tabInfo) {
					if (buttons[i].tabInfo.backgroundColor) buttons[i].backgroundColor = buttons[i].tabInfo.backgroundColor;
					if (buttons[i].tabInfo.color && buttons[i].label) buttons[i].color = buttons[i].tabInfo.color;
				}

				if (useTap) buttons[i].noTap();
				else buttons[i].off((!zns?ACTIONEVENT=="mousedown":zim.ACTIONEVENT=="mousedown")?"mousedown":"click", buttons[i].zimTabEvent);
				buttons[i].removeFrom();
			}
			// splice from buttons and labels from labels
			buttons.splice(index, num);
			labels.splice(index, num);
			prepareAllButtons(); // operates on buttons array - not tabs array
			return that;
		}

		window.addEventListener("keydown", function(e) {
			if (!that.keyEnabled || !that.keyFocus || that.zimAccessibility) return;
			if (e.keyCode == 9) {
				var next = myIndex; // note that change updates the index
				if (e.shiftKey) {
					change((--next<0)?tabs.length-1:next);
				} else {
					change((++next>tabs.length-1)?0:next);
				}
				that.dispatchEvent("change");
				if ((!zim.OPTIMIZE&&(zns||!OPTIMIZE)) && that.stage) that.stage.update();
				e.preventDefault();
			}
		});

		Object.defineProperty(this, 'selected', {
			get: function() {
				return buttons[myIndex];
			},
			set: function(value) {
				if (zon) zog("selected is read only - try selectedIndex");
			}
		});

		Object.defineProperty(this, 'selectedIndex', {
			get: function() {
				return myIndex;
			},
			set: function(value) {
				// change(Math.min(Math.max(value, 0), tabs.length-1));
				change(value);
				if ((!zim.OPTIMIZE&&(zns||!OPTIMIZE)) && that.stage) that.stage.update();
			}
		});

		this.last = function() {
			this.selectedIndex = this.buttons.length-1;
			return this;
		}
		this.first = function() {
			this.selectedIndex = 0;
			return this;
		}

		Object.defineProperty(this, 'tabs', {
			get: function() {
				return myIndex;
			},
			set: function(value) {
				change(Math.min(Math.max(value, 0), tabs.length-1));
				if ((!zim.OPTIMIZE&&(zns||!OPTIMIZE)) && that.stage) that.stage.update();
			}
		});

		Object.defineProperty(this, 'color', {
			get: function() {
				if (that.buttons[0].tabItems) return that.buttons[0].tabItems.color;
				else return color;
			},
			set: function(value) {
				color = value;
				if (that.buttons[0].tabInfo) {
					for (var i=0; i<that.buttons.length; i++) {
						if (that.buttons[i].tabInfo) {
							that.buttons[i].tabInfo.color = value;
						}
						if (i != myIndex || !currentSelected) that.buttons[i].color = color;
					}
					if ((!zim.OPTIMIZE&&(zns||!OPTIMIZE)) && that.stage) that.stage.update();
				}
			}
		});

		Object.defineProperty(this, 'rollColor', {
			get: function() {
				if (that.buttons[0].tabItems) return that.buttons[0].tabItems.rollColor;
				else return rollColor;
			},
			set: function(value) {
				rollColor = value;
				if (that.buttons[0].tabInfo) {
					for (var i=0; i<that.buttons.length; i++) {
						if (that.buttons[i].tabInfo) {
							that.buttons[i].tabInfo.rollColor = value;
						}
						that.buttons[i].rollColor = rollColor;
						if (i != myIndex && that.buttons[i].rolled) that.buttons[i].color = rollColor;
					}
					if ((!zim.OPTIMIZE&&(zns||!OPTIMIZE)) && that.stage) that.stage.update();
				}
			}
		});

		Object.defineProperty(this, 'selectedColor', {
			get: function() {
				if (that.buttons[0].tabItems) return that.buttons[0].tabItems.selectedColor;
				else return selectedColor;
			},
			set: function(value) {
				selectedColor = value;
				if (that.buttons[0].tabInfo) {
					for (var i=0; i<that.buttons.length; i++) {
						if (that.buttons[i].tabInfo) {
							that.buttons[i].tabInfo.selectedColor = value;
						}
						if ((i == myIndex && currentSelected)) that.buttons[i].color = selectedColor;
					}
					if ((!zim.OPTIMIZE&&(zns||!OPTIMIZE)) && that.stage) that.stage.update();
				}
			}
		});

		Object.defineProperty(this, 'selectedRollColor', {
			get: function() {
				if (that.buttons[0].tabItems) return that.buttons[0].tabItems.selectedRollColor;
				else return selectedRollColor;
			},
			set: function(value) {
				selectedRollColor = value;
				if (that.buttons[0].tabInfo) {
					for (var i=0; i<that.buttons.length; i++) {
						if (that.buttons[i].tabInfo) {
							that.buttons[i].tabInfo.selectedRollColor = value;
						}
						if ((i == myIndex && currentSelected) && that.buttons[i].rolled) that.buttons[i].color = selectedRollColor;
					}
					if ((!zim.OPTIMIZE&&(zns||!OPTIMIZE)) && that.stage) that.stage.update();
				}
			}
		});

		Object.defineProperty(this, 'backgroundColor', {
			get: function() {
				if (that.buttons[0].tabItems) return that.buttons[0].tabItems.backgroundColor;
				else return backgroundColor;
			},
			set: function(value) {
				backgroundColor = value;
				if (that.buttons[0].tabInfo) {
					for (var i=0; i<that.buttons.length; i++) {
						if (that.buttons[i].tabInfo) {
							that.buttons[i].tabInfo.backgroundColor = value;
						}
						if (i != myIndex || !currentSelected) that.buttons[i].backgroundColor = backgroundColor;
					}
					if ((!zim.OPTIMIZE&&(zns||!OPTIMIZE)) && that.stage) that.stage.update();
				}
			}
		});

		Object.defineProperty(this, 'rollBackgroundColor', {
			get: function() {
				if (that.buttons[0].tabItems) return that.buttons[0].tabItems.rollBackgroundColor;
				else return rollBackgroundColor;
			},
			set: function(value) {
				rollBackgroundColor = value;
				if (that.buttons[0].tabInfo) {
					for (var i=0; i<that.buttons.length; i++) {
						if (that.buttons[i].tabInfo) {
							that.buttons[i].tabInfo.rollBackgroundColor = value;
						}
						that.buttons[i].rollBackgroundColor = rollBackgroundColor;
						if (i != myIndex && that.buttons[i].rolled) that.buttons[i].backgroundColor = rollBackgroundColor;
					}
					if ((!zim.OPTIMIZE&&(zns||!OPTIMIZE)) && that.stage) that.stage.update();
				}
			}
		});

		Object.defineProperty(this, 'selectedBackgroundColor', {
			get: function() {
				if (that.buttons[0].tabItems) return that.buttons[0].tabItems.selectedBackgroundColor;
				else return selectedBackgroundColor;
			},
			set: function(value) {
				selectedBackgroundColor = value;
				if (that.buttons[0].tabInfo) {
					for (var i=0; i<that.buttons.length; i++) {
						if (that.buttons[i].tabInfo) {
							that.buttons[i].tabInfo.selectedBackgroundColor = value;
						}
						if ((i == myIndex && currentSelected)) that.buttons[i].backgroundColor = selectedBackgroundColor;
					}
					if ((!zim.OPTIMIZE&&(zns||!OPTIMIZE)) && that.stage) that.stage.update();
				}
			}
		});

		Object.defineProperty(this, 'selectedRollBackgroundColor', {
			get: function() {
				if (that.buttons[0].tabItems) return that.buttons[0].tabItems.selectedRollBackgroundColor;
				else return selectedRollBackgroundColor;
			},
			set: function(value) {
				selectedRollBackgroundColor = value;
				if (that.buttons[0].tabInfo) {
					for (var i=0; i<that.buttons.length; i++) {
						if (that.buttons[i].tabInfo) {
							that.buttons[i].tabInfo.selectedRollBackgroundColor = value;
						}
						if ((i == myIndex && currentSelected) && that.buttons[i].rolled) that.buttons[i].backgroundColor = selectedRollBackgroundColor;
					}
					if ((!zim.OPTIMIZE&&(zns||!OPTIMIZE)) && that.stage) that.stage.update();
				}
			}
		});

		Object.defineProperty(this, 'label', {
			get: function() {
				return labels[myIndex];
			},
			set: function(value) {
				if (zon) zog("selected is read only - try selectedIndex");
			}
		});

		Object.defineProperty(this, 'text', {
			get: function() {
				return (labels[myIndex]!=null) ? labels[myIndex].text : undefined;
			},
			set: function(value) {
				if (zon) zog("selected is read only - try selectedIndex");
			}
		});

		Object.defineProperty(this, 'buttons', {
			get: function() {
				return buttons;
			},
			set: function(value) {
				if (zon) zog("buttons is read only");
			}
		});

		Object.defineProperty(this, 'labels', {
			get: function() {
				return labels;
			},
			set: function(value) {
				if (zon) zog("labels is read only");
			}
		});

		this._enabled = true;
		Object.defineProperty(that, 'enabled', {
			get: function() {
				return that._enabled;
			},
			set: function(value) {
				zenable(that, value);
			}
		});

		if (typeof KEYFOCUS !== typeof undefined) zim.KEYFOCUS = KEYFOCUS;
		Object.defineProperty(this, 'keyFocus', {
			get: function() {
				return zim.KEYFOCUS == that;
			},
			set: function(value) {
				zim.KEYFOCUS = that;
			}
		});
		if (keyEnabled && zim.KEYFOCUS) setFocus();
		this.on("mousedown", function() {if (keyEnabled) setFocus()});
		function setFocus() {that.keyFocus = true; var d=document.activeElement; if (d) d.blur();}

		var bou = that.getBounds();
		if (zot(bou) || bou.width==0) that.setBounds(0,0,width,height);
		else that.width = width;

		if (style!==false) zimStyleTransforms(this, DS);
		this.clone = function() {
			var tabsCopy = zim.copy(tabs, true);
			for (var i=0; i<tabsCopy.length; i++) {
				tabsCopy[i].label = tabsCopy[i].label.clone();
			}
			return that.cloneProps(new zim.Tabs(width, height, tabsCopy, backgroundColor, rollBackgroundColor, selectedBackgroundColor, selectedRollBackgroundColor, color, rollColor, selectedColor, selectedRollColor, vertical, spacing, currentEnabled, currentSelected, corner, base, keyEnabled, gradient, gloss, backing, rollBacking, wait, waitTime, waitBackgroundColor, rollWaitBackgroundColor, waitColor, rollWaitColor, waitModal, waitEnabled, backdropColor, align, valign, labelAlign, labelValign, labelIndent, labelIndentHorizontal, labelIndentVertical, indent, useTap, excludeCustomTap, style, this.group, inherit));
		}
	}
	zim.extend(zim.Tabs, zim.Container, "clone", "zimContainer", false);
	//-65

/*--
zim.Pad = function(width, cols, rows, keys, backgroundColor, rollBackgroundColor, selectedBackgroundColor, selectedRollBackgroundColor, color, rollColor, selectedColor, selectedRollColor, spacing, currentEnabled, corner, labelColor, gradient, gloss, backing, rollBacking, wait, waitTime, waitBackgroundColor, rollWaitBackgroundColor, waitColor, rollWaitColor, waitModal, waitEnabled, style, group, inherit)

Pad
zim class - extends a zim.Container which extends a createjs.Container

DESCRIPTION
A pad that has rows and cols made of square keys.
When the keys are pressed the pad will dispatch a change event - get the selectedIndex or text property.

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var pad = new Pad();
pad.center(stage);
pad.on("change", function() {
	zog(pad.selectedIndex); // 0-8
	zog(pad.text); // 1-9
});
stage.update();
END EXAMPLE

PARAMETERS
** supports DUO - parameters or single object with properties below
** supports OCT - parameter defaults can be set with STYLE control (like CSS)
** inherits STYLE from type selector for Pad, then general styles then type selector for Tabs
width - (default 150) overall width of pad (ZIM divides the width across cols and spacing)
cols - (default 3) the columns in the pad
rows - (default cols) the rows in the pad
keys - (default an Array for cols x rows) an array of key objects with the following properties available:
	any key specific properties will override the default values from other parameters
	[{label:"String", width:200, backgroundColor:"Red", rollBackgroundColor:"pink", selectedBackgroundColor:"grey"}, {etc.}]
	the label can be a String or a Label object - default text color is white
	Key objects can also include wait properties for individual buttons.
	See wait, waitTime, waitBackgroundColor, rollWaitBackgroundColor, waitColor, rollWaitColor, waitModal and waitEnabled parameters below
	wait can be used with button's waiting property to offer an alternative to a loading screen or confirmation panel
	also see the button's clearWait() method to cancel the wait state and waited event that triggers when the wait is done
backgroundColor - (default "#777") the background color of a deselected key when not rolled over
rollBackgroundColor - (default "#555") the rollover background color (selected keys do not roll over)
selectedBackgroundColor - (default "#333") the background color of the selected key (any CSS color)
color - (default "white") the text color of a deselected key when not rolled over
selectedColor - (default color) the text color of the selected key (any CSS color)
rollColor - (default color) the rollover color (selected keys do not roll over)
spacing - (default 1) is the pixels between key buttons
currentEnabled - (default true) set to false to make selected key not pressable
corner - (default 0) the corner radius of the keys
	can also be an array of [topLeft, topRight, bottomRight, bottomLeft]
labelColor - (default "white") the color of the label
gradient - (default null) 0 to 1 (try .3) adds a gradient to the tabs
gloss - (default null) 0 to 1 (try .1) adds a gloss to the tabs
wait - (default null) String text for button to say when pressed to enter a wait mode
	The wait parameters can be (and probably will be) set as properties for each individual button in the pads array
waitTime - (default 20000) milliseconds to stay in wait state before returning to normal button
waitBackgroundColor - (default color) the color of the button during wait period
rollWaitBackgroundColor - (default color) the color of the button during wait period
waitBackgroundColor - (default red) color to make button during wait time if wait is set
rollWaitBackgroundColor - (default rollColor) color for button when waiting and rolled over
waitColor - (default label's color) color to make text during wait time if wait is set
rollWaitColor - (default label's roll color) color for text when waiting and rolled over
waitModal - (default false) set to true to exit wait state if user clicks off the pad or to another button
waitEnabled - (default true) set to false to disable pad while in wait mode
style - (default true) set to false to ignore styles set with the STYLE - will receive original parameter defaults
group - (default null) set to String (or comma delimited String) so STYLE can set default styles to the group(s) (like a CSS class)
inherit - (default null) used internally but can receive an {} of styles directly

METHODS
hasProp(property as String) - returns true if property exists on object else returns false
clone() - makes a copy with properties such as x, y, etc. also copied
dispose() - removes from parent, removes event listeners - must still set outside references to null for garbage collection

ALSO: ZIM 4TH adds all the methods listed under Container (see above), such as:
drag(), hitTestRect(), animate(), sca(), reg(), mov(), center(), centerReg(),
addTo(), removeFrom(), loop(), outline(), place(), pos(), alp(), rot(), setMask(), etc.
ALSO: See the CreateJS Easel Docs for Container methods, such as:
on(), off(), getBounds(), setBounds(), cache(), uncache(), updateCache(), dispatchEvent(),
addChild(), removeChild(), addChildAt(), getChildAt(), contains(), removeAllChildren(), etc.

PROPERTIES
type - holds the class name as a String
selectedIndex - gets or sets the selected index of the pad
text - gets current selected label text
selected - gets the selected button - selected.enabled = true, etc.
** setting widths and heights adjusts scale not bounds and getting these uses the bounds dimension times the scale
width - gets or sets the width. Setting the width will scale the height to keep proportion (see widthOnly below)
height - gets or sets the height. Setting the height will scale the width to keep proportion (see heightOnly below)
widthOnly - gets or sets the width.  This sets only the width and may change the aspect ratio of the object
heightOnly - gets or sets the height.  This sets only the height and may change the aspect ratio of the object
label - gets current selected label object
selectedBackgroundColor - gets or sets default selected background color
backgroundColor - gets or sets default unselected background color
rollBackgroundColor - gets or sets default rolled over background color
color - gets or sets default unselected text color
rollColor - gets or sets default rolled over text color
selectedColor - gets or sets default selected text color
buttons - an array of the ZIM Button objects. buttons[0].enabled = false;
labels - an array of the ZIM Label objects. labels[0].text = "YUM"; labels[2].y -= 10;
tabs - an array of the zim Tabs objects (one object per row)
enabled - default is true - set to false to disable
blendMode - how the object blends with what is underneath - such as "difference", "multiply", etc. same as CreateJS compositeOperation
group - used when the object is made to add STYLE with the group selector (like a CSS class)

ALSO: See the CreateJS Easel Docs for Container properties, such as:
x, y, rotation, scaleX, scaleY, regX, regY, skewX, skewY,
alpha, cursor, shadow, mouseChildren, mouseEnabled, parent, numChildren, etc.

OPTIMIZED
This component is affected by the general OPTIMIZE setting (default is false)
if set to true, you will have to stage.update() after setting certain properties
and stage.update() in change event to see component change its graphics

ACTIONEVENT
This component is affected by the general ACTIONEVENT setting
The default is "mousedown" - if set to something else the component will act on click (press)

EVENTS
dispatches a "change" event when a pad changes (but not when setting selectedIndex property)

ALSO: See the CreateJS Easel Docs for Container events, such as:
added, click, dblclick, mousedown, mouseout, mouseover, pressmove, pressup, removed, rollout, rollover
--*///+66
	zim.Pad = function(width, cols, rows, keys, backgroundColor, rollBackgroundColor, selectedBackgroundColor, selectedRollBackgroundColor, color, rollColor, selectedColor, selectedRollColor, spacing, currentEnabled, corner, labelColor, gradient, gloss, backing, rollBacking, wait, waitTime, waitBackgroundColor, rollWaitBackgroundColor, waitColor, rollWaitColor, waitModal, waitEnabled, style, group, inherit) {
		var sig = "width, cols, rows, keys, backgroundColor, rollBackgroundColor, selectedBackgroundColor, selectedRollBackgroundColor, color, rollColor, selectedColor, selectedRollColor, spacing, currentEnabled, corner, labelColor, gradient, gloss, backing, rollBacking, wait, waitTime, waitBackgroundColor, rollWaitBackgroundColor, waitColor, rollWaitColor, waitModal, waitEnabled, style, group, inherit";
		var duo; if (duo = zob(zim.Pad, arguments, sig, this)) return duo;
		z_d("66");
		this.zimContainer_constructor(null,null,null,null,false);
		this.type = "Pad";
		this.group = group;
		var DS = style===false?{}:zim.getStyle(this.type, this.group, inherit);

		// the other parameters will be handled by the Tabs object for each row
		if (zot(width)) width = DS.width!=null?DS.width:150;
		if (zot(cols)) cols = DS.cols!=null?DS.cols:3;
		if (zot(rows)) rows = DS.rows!=null?DS.rows:cols;
		if (zot(keys)) {
			if (DS.keys!=null) {keys = DS.keys}
			else {keys = []; for (var i=1; i<=rows*cols; i++){keys.push(i);}}
		}
		if (zot(currentEnabled)) currentEnabled = DS.currentEnabled!=null?DS.currentEnabled:true;
		if (zot(spacing)) spacing = DS.spacing!=null?DS.spacing:1;

		var that = this;
		var myIndex;

		this.cols = cols; // read only
		this.rows = rows;

		var height = width / cols - spacing;
		var rowTabs = [];
		var count = 0;
		var r;
		this.labels = [];
		this.buttons = [];
		for (var i=0; i<rows; i++) {
			var rowKeys = [];
			for (var j=0; j<cols; j++) {
				rowKeys.push((keys[count]!=null) ? keys[count] : "");
				count++;
			}
			var corn = DS.corner!=null?DS.corner:corner;
			if (corn && !Array.isArray(corn)) corn = [corn,corn,corn,corn];
			r = rowTabs[i] = new zim.Tabs({
				width:width,
				height:height,
				tabs:rowKeys,
				backgroundColor:DS.backgroundColor!=null?DS.backgroundColor:backgroundColor,
				rollBackgroundColor:DS.rollBackgroundColor!=null?DS.rollBackgroundColor:rollBackgroundColor,
				selectedBackgroundColor:DS.selectedBackgroundColor!=null?DS.selectedBackgroundColor:selectedBackgroundColor,
				color:DS.color!=null?DS.color:color,
				rollColor:DS.rollColor!=null?DS.rollColor:rollColor,
				selectedColor:DS.selectedColor!=null?DS.selectedColor:selectedColor,
				spacing:DS.spacing!=null?DS.spacing:spacing,
				currentEnabled:DS.currentEnabled!=null?DS.currentEnabled:currentEnabled,
				corner:corn,
				backing:DS.backing!=null?DS.backing.clone():backing,
				rollBacking:DS.rollBacking!=null?DS.rollBacking.clone():rollBacking,
				base:null,
				keyEnabled:false,
				gradient:DS.gradient!=null?DS.gradient:gradient,
				gloss:DS.gloss!=null?DS.gloss:gloss,
				wait:DS.wait!=null?DS.wait:wait,
				waitTime:DS.waitTime!=null?DS.waitTime:waitTime,
				waitBackgroundColor:DS.waitBackgroundColor!=null?DS.waitBackgroundColor:waitBackgroundColor,
				rollWaitBackgroundColor:DS.rollWaitBackgroundColor!=null?DS.rollWaitBackgroundColor:rollWaitBackgroundColor,
				waitColor:DS.waitColor!=null?DS.waitColor:waitColor,
				rollWaitColor:DS.rollWaitColor!=null?DS.rollWaitColor:rollWaitColor,
				waitModal:DS.waitModal!=null?DS.waitModal:waitModal,
				waitEnabled:DS.waitEnabled!=null?DS.waitEnabled:waitEnabled,
				group:group,
				style:false
			});
			this.labels = this.labels.concat(r.labels);
			this.buttons = this.buttons.concat(r.buttons);
			this.addChild(r);
			r.selectedIndex = -1;
			r.y = (height+spacing)*i;
			r.znum = i;
			r.on("change", pressKey);
		}
		this.tabs = rowTabs;
		function pressKey(e) {
			var r = e.target;
			that.selected = r.selected;
			that.text = r.text;
			that.label = r.label;
			var s = r.selectedIndex; // store selected then clear all in pad
			for (var i=0; i<rowTabs.length; i++) {
				rowTabs[i].selectedIndex = -1;
			}
			r.selectedIndex = s; // restore selected
			myIndex = r.znum * cols + s; // calculate pad selected
			that.dispatchEvent("change");
			if ((!zim.OPTIMIZE&&(zns||!OPTIMIZE)) && that.stage) that.stage.update();
		}

		Object.defineProperty(this, 'selectedIndex', {
			get: function() {
				return myIndex;
			},
			set: function(value) {
				myIndex = value;
				for (var i=0; i<rowTabs.length; i++) {
					rowTabs[i].selectedIndex = -1;
				}
				var tabNum = Math.floor(myIndex / cols);
				if (tabNum >= 0 && tabNum < that.tabs.length) {
					that.tabs[tabNum].selectedIndex = myIndex % cols;
				}
			}
		});

		this._enabled = true;
		Object.defineProperty(that, 'enabled', {
			get: function() {
				return that._enabled;
			},
			set: function(value) {
				zenable(that, value);
			}
		});

		if (style!==false) zimStyleTransforms(this, DS);
		this.clone = function() {
			return that.cloneProps(new zim.Pad(width, cols, rows, keys, backgroundColor, rollBackgroundColor, selectedBackgroundColor, selectedRollBackgroundColor, color, rollColor, selectedColor, selectedRollColor, spacing, currentEnabled, corner, labelColor, gradient, gloss, backing, rollBacking, wait, waitTime, waitBackgroundColor, rollWaitBackgroundColor, waitColor, rollWaitColor, waitModal, waitEnabled, style, this.group, inherit));
		}
	}
	zim.extend(zim.Pad, zim.Container, "clone", "zimContainer", false);
	//-66

/*--
zim.ColorPicker = function(width, colors, cols, spacing, greyPicker, alphaPicker, startBackgroundColor, draggable, shadowColor, shadowBlur, buttonBar, circles, indicator, backgroundColor, keyArrows, container, style, group, inherit)

ColorPicker
zim class - extends a zim.Container which extends a createjs.Container

DESCRIPTION
A traditional color picker which shows 256 Web colors by default or custom colors.
Can additionally show 16 greys and / or an alpha slider.
Picking on a color sets the swatch color and the selectedColor property.
OK dispatches a "change" event if the color changed or a close event if not.
The X dispatches a "close" event.

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var cp = new ColorPicker();
cp.center(stage);
cp.on("change", function() {
	zog(cp.selectedColor); // #ffcc99, etc. after pressing OK
	zog(cp.selectedAlpha); // 0-1
});
stage.update();
END EXAMPLE

PARAMETERS
** supports DUO - parameters or single object with properties below
** supports OCT - parameter defaults can be set with STYLE control (like CSS)
width - (default 500) the width of the color picker
colors - (default 256 Web colors) an optional list of colors ["red", "#CCC", etc.]
cols - (default 10) how many columns to use if you pass in custom colors
spacing - (default 2) is the space between the color squares
greyPicker - (default true unless one row) shows an extra 16 greys (set to false to hide these)
	for the default colors it also includes 2 starting colors that record last picked colors
alphaPicker - (default true unless one row) shows an alpha slider (set to false to hide this)
	the swatch has a black, grey and white backing underneath to show multiple alpha effects
startBackgroundColor - (default the last color in color array) the starting color
draggable - (default true (false if no buttonBar)) whether you can drag the component - set to false to not drag
	a small grip under the color text shows if draggable
shadowColor - (default rgba(0,0,0,.3)) set to -1 for no drop shadow
shadowBlur - (default 14) the blur of the shadow if shadow is set
buttonBar - (default true unless one row) set to false to hide the button bar with OK and X (close)
circles - (default false) set to true to show colors in circles rather than squares
indicator - (default true) set to false to remove indicator from currentBackgroundColor
backgroundColor - (default black) the color of the background
keyArrows - (default true) set to false to disable keyboard arrows
container - (default frame.zimDefaultFrame) if using show(), hide(), toggle() can set which container to center on
style - (default true) set to false to ignore styles set with the STYLE - will receive original parameter defaults
group - (default null) set to String (or comma delimited String) so STYLE can set default styles to the group(s) (like a CSS class)
inherit - (default null) used internally but can receive an {} of styles directly

METHODS
show() - show the picker (returns the picker for chaining)
hide() - hides the picker
toggle(state - default null) - shows if hidden and hides if showing (returns the picker for chaining)
	or pass in true to show picker or false to hide picker
hasProp(property as String) - returns true if property exists on object else returns false
clone() - makes a copy with properties such as x, y, etc. also copied
dispose() - removes from parent, removes event listeners - must still set outside references to null for garbage collection

ALSO: ZIM 4TH adds all the methods listed under Container (see above), such as:
drag(), hitTestRect(), animate(), sca(), reg(), mov(), center(), centerReg(),
addTo(), removeFrom(), loop(), outline(), place(), pos(), alp(), rot(), setMask(), etc.
ALSO: See the CreateJS Easel Docs for Container methods, such as:
on(), off(), getBounds(), setBounds(), cache(), uncache(), updateCache(), dispatchEvent(),
addChild(), removeChild(), addChildAt(), getChildAt(), contains(), removeAllChildren(), etc.

PROPERTIES
type - holds the class name as a String
selectedColor - gets or sets the selected color swatch
currentValue - same as selectedColor but consistent with other components
currentValueEvent - gets or sets the current value and dispatches a "change" event if set and changed
selectedAlpha - gets or sets the selected alpha (set does not work if alphaPicker is false)
selectedIndex - get or sets the selected index of the colorPicker
colors - read only array of colors in picker - not including greys
greys - read only array of greys in picker if the grey picker is set
toggled - read-only Boolean property as to whether picker is showing
** setting widths and heights adjusts scale not bounds and getting these uses the bounds dimension times the scale
width - gets or sets the width. Setting the width will scale the height to keep proportion (see widthOnly below)
height - gets or sets the height. Setting the height will scale the width to keep proportion (see heightOnly below)
widthOnly - gets or sets the width.  This sets only the width and may change the aspect ratio of the object
heightOnly - gets or sets the height.  This sets only the height and may change the aspect ratio of the object
swatch - gets the Rectangle that is the color swatch
swatchBacking - gets the zim Shape that is under the swatch (seen if alpha set low)
swatchText - gets the Label that shows the color text
grip - gets the createjs.Shape for the grip if the panel is dragable
background - gets the Rectangle that is the background (cp.background.color = "white" - now a backgroundColor parameter)
okBut - references the OK Button
closeBut - references the X Button
indicator - gets the zim shape that is the indicator (if indicator is true)
NOTE: alphaPicker is true:
alpaBacking - gets reference to the Rectangle that makes the backing for the alpha slider
alphaBut - the Button on the alpha slider
alphaSlider - the Slider for the alpha
alphaText - the Label for the alpha
blendMode - how the object blends with what is underneath - such as "difference", "multiply", etc. same as CreateJS compositeOperation
keyFocus - get or set the keyboard focus on the component - see also zim.KEYFOCUS
	will be set to true if this component is the first made or component is the last to be used
group - used when the object is made to add STYLE with the group selector (like a CSS class)

ALSO: See the CreateJS Easel Docs for Container properties, such as:
x, y, rotation, scaleX, scaleY, regX, regY, skewX, skewY,
alpha, cursor, shadow, mouseChildren, mouseEnabled, parent, numChildren, etc.

ACTIONEVENT
This component is affected by the general ACTIONEVENT setting
The default is "mousedown" - if set to something else the component will act on click (press)

EVENTS
dispatches a "set" event when a different color or alpha is selected and updated in the picker if the buttonBar is showing
dispatches a "change" event when the OK button is activated and the color or alpha is different than before
	or if buttonBar is false dispatches "change" when a new color or alpha is selected
dispatches a "close" event if the OK button is activated and the color has not changed or the X button is pressed

ALSO: See the CreateJS Easel Docs for Container events, such as:
added, click, dblclick, mousedown, mouseout, mouseover, pressmove, pressup, removed, rollout, rollover
--*///+67
	zim.ColorPicker = function(width, colors, cols, spacing, greyPicker, alphaPicker, startBackgroundColor, draggable, shadowColor, shadowBlur, buttonBar, circles, indicator, backgroundColor, keyArrows, container, style, group, inherit) {
		var sig = "width, colors, cols, spacing, greyPicker, alphaPicker, startBackgroundColor, draggable, shadowColor, shadowBlur, buttonBar, circles, indicator, backgroundColor, keyArrows, container, style, group, inherit";
		var duo; if (duo = zob(zim.ColorPicker, arguments, sig, this)) return duo;
		z_d("67");
		this.zimContainer_constructor(null,null,null,null,false);
		this.type = "ColorPicker";
		this.group = group;
		var DS = style===false?{}:zim.getStyle(this.type, this.group, inherit);

		if (zot(width)) width = DS.width!=null?DS.width:500;
		if (zot(colors)) colors = DS.colors!=null?DS.colors:null;
		if (zot(colors)) standard = true;
		if (zot(cols)) cols = DS.cols!=null?DS.cols:10;
		if (zot(spacing)) spacing = DS.spacing!=null?DS.spacing:2;
		var oneRow = !standard&&colors.length>0&&colors.length<=cols;
		if (zot(alphaPicker)) alphaPicker = DS.alphaPicker!=null?DS.alphaPicker:(oneRow?false:true);
		if (zot(greyPicker)) greyPicker = DS.greyPicker!=null?DS.greyPicker:(oneRow?false:true);
		if (zot(shadowColor)) shadowColor = DS.shadowColor!=null?DS.shadowColor:"rgba(0,0,0,.3)";
		if (zot(shadowBlur)) shadowBlur = DS.shadowBlur!=null?DS.shadowBlur:14;
		if (zot(buttonBar)) buttonBar = DS.buttonBar!=null?DS.buttonBar:(oneRow?false:true);
		if (zot(draggable)) {
			if (buttonBar) {
				draggable = DS.draggable!=null?DS.draggable:true;
			} else {
				draggable = DS.draggable!=null?DS.draggable:false;
			}
		}
		if (zot(circles)) circles = DS.circles!=null?DS.circles:false;
		if (zot(indicator)) {
			indicator = DS.indicator!=null?DS.indicator:false;
			if (!buttonBar) indicator = DS.indicator!=null?DS.indicator:true;
		}
		if (zot(backgroundColor)) backgroundColor = DS.backgroundColor!=null?DS.backgroundColor:"black";
		if (zot(startBackgroundColor)) startBackgroundColor = DS.startBackgroundColor!=null?DS.startBackgroundColor:null;
		if (zot(keyArrows)) keyArrows = DS.keyArrows!=null?DS.keyArrows:true;

		var that = this;
		var stage;

		if (zot(container)) {
			if (zimDefaultFrame) container = zimDefaultFrame.stage;
		 	else return;
		} else if (!container.getBounds) {
			return;
		} else if (zot(container.getStage)) {
			return;
		}
		that.container = container;

		var secondLastBackgroundColor = "#e472c4"; // only used on standard colors
		var thirdLastBackgroundColor = "#50c4b7";
		var lastAlpha = 1;
		var myAlpha = 1;

		var box = new createjs.Shape(); // shape that holds all colors and greys
		this.addChild(box);
		box.x += spacing;
		box.y += spacing;

		var standard = false;
		var colorsTemp; var w;
		var greys = [];
		if (zot(colors)) {
			standard = true;
			var num = 6; // six sets 0,3,6,9,C,F - for Web colors
			var tot = num*num*num;
			num = Math.ceil(Math.pow(tot,1/2));
			w = (width - spacing)/18-spacing;
			var f = Math.floor(Math.pow(num*num, 1/3));
			colorsTemp = [];
			for (var i=0; i<6; i++) {
				for (var j=0; j<6; j++) {
					for (var k=0; k<6; k++) {
						colorsTemp.push("#" + con(i*3) + con(j*3) + con(k*3));
					}
				}
			}
			colors = []; // flip every six by six sideways and put on two lines
			var c, r, nC, nR;
			for (i=0; i<colorsTemp.length; i++) {
				c = Math.floor(i/6);
				r = i%6;
				if (c >= 6*3) {f = 1;} else {f = 0;}
				nC = c-f*6*3;
				nR = r+f*6;
				colors[nR*18+nC] = colorsTemp[i];
			}
			cols = 18;
			greys = [thirdLastBackgroundColor, secondLastBackgroundColor];
		} else {
			w = (width - spacing) / cols - spacing;
		}
		var rows = Math.ceil(colors.length/cols);

		var startAlpha = 1;
		var myColor = String(colors[colors.length-1]);
		if (!zot(startBackgroundColor)) {
			var matches = startBackgroundColor.match(/rgba\((.*)\)/)
			if (matches) {
				var c = matches[1].split(",");
				startAlpha = c.pop();
				startBackgroundColor = "rgb("+c.join(",")+")";
			}
			myColor = String(startBackgroundColor);
		}

		var lastBackgroundColor;
		if (standard) lastBackgroundColor = thirdLastBackgroundColor;

		function con(n) {
			n = Math.floor(n).toString(16);
			return n + "" + n;
		}

		var g = box.graphics; var f=0; var color, r, c, rX , rY;
		var borderColor = DS.borderColor!=null?DS.borderColor:null;
		var borderWidth = DS.borderWidth!=null?DS.borderWidth:null;
		if (!zot(borderColor) && zot(borderWidth)) borderWidth = 1;
		if (borderWidth && zot(borderColor)) borderColor = "#333";
		if (borderWidth) g.s(borderColor).ss(borderWidth);

		for (i=0; i<colors.length; i++) {
			c = i%cols;
			r = Math.floor(i/cols);
			rX = c*(w+spacing);
			rY = r*(w+spacing);
			if (circles) {
				g.f(colors[i]).dc(rX+w/2,rY+w/2,w/2);
			} else {
				g.f(colors[i]).r(rX,rY,w,w);
			}
		}
		var lastHeight = rY + w + spacing;

		that.colors = colors;

		var greyHeight = lastHeight;
		if (greyPicker) {
			for (i=0; i<16; i++) {
				greys.push("#"+con(i)+con(i)+con(i));
			}
			for (i=0; i<greys.length; i++) {
				c = Math.floor(i/cols);
				r = i%cols;
				rX = r*(w+spacing);
				rY = c*(w+spacing)+lastHeight;
				if (circles) {
					g.f(greys[i]).dc(rX+w/2,rY+w/2,w/2);
				} else {
					g.f(greys[i]).r(rX,rY,w,w);
				}
			}
			lastHeight = rY + w + spacing;
			var greyCols = cols;
			var greyRows = Math.ceil(greys.length/cols);
		}

		that.greys = greys;

		if (indicator) {
			indicator = this.indicator = circles ? new zim.Circle(w/2*.5, null, null, null, null, null, null, false) : new zim.Rectangle(w*.5, w*.5, null, null, null, null, null, null, false);
			indicator.alpha = .5;
			indicator.centerReg();
			this.addChild(indicator);
			function positionIndicator(i) {
				if (zot(i) || i < 0) {
					indicator.visible = false;
					return;
				} else {
					indicator.visible = true;
				}
				if (myColor == "#000" || myColor == "#000000" || myColor == "black") {
					indicator.color = "#222";
					indicator.alpha = 1;
				} else {
					indicator.color = "black";
					indicator.alpha = .5;
				}
				indicator.x = box.x + i%cols*(w+spacing) + w/2;
				indicator.y = box.x + Math.floor(i/cols)*(w+spacing) + w/2;
			}
			positionIndicator(colors.indexOf(myColor));
		}

		var margin = 10;

		if (alphaPicker) {
			var alpha = new zim.Container({style:false});
			alpha.setBounds(0,0,600,70);
			this.addChild(alpha);
			alpha.x = 0;
			alpha.y = lastHeight;

			var alphaBacking = this.alphaBacking = new zim.Rectangle(600-margin*2, 50, "#222", null, null, 0, null, null, false);
			alpha.addChild(alphaBacking);
			zim.centerReg(alphaBacking, alpha);

			var sliderBut = this.alphaBut = new zim.Button({width:20,height:30,backgroundColor:"darkorange",rollBackgroundColor:"orange",label:"",corner:0,hitPadding:20,style:false});
			var slider = this.alphaSlider = new zim.Slider({min:0,max:1,step:.05,button:sliderBut,barLength:600*.55,barWidth:2,barColor:"#999",vertical:false,useTicks:false,inside:false,style:false});
			slider.currentValue = !zot(startAlpha)?startAlpha:1;
			alpha.addChild(slider);
			slider.x = 40;
			slider.y = alpha.height/2;

			var alphaText = this.alphaText = new zim.Label({
				text:"Alpha: " + zim.decimals(startAlpha), size:30, color:"orange",
				backing:"ignore", shadowColor:"ignore", shadowBlur:"ignore", backgroundColor:"ignore", rollColor:"orange",
				group:this.group
			});
			alpha.addChild(alphaText);
			alphaText.x = slider.x + slider.bar.width + 40;
			alphaText.y = alpha.height/2 - alphaText.height/2;

			alpha.scaleX = alpha.scaleY = width / 600;

			slider.on("change", function() {
				alphaText.text = "Alpha: " + decimals(slider.currentValue);
				if (swatch) {
					swatch.alpha = myAlpha = slider.currentValue;
				}
				if (buttonBar) {
					that.dispatchEvent("set");
				} else {
					that.dispatchEvent("change");
				}
				if (that.stage) that.stage.update();
			});
			lastHeight += alpha.height-margin;
		}

		if (buttonBar) {
			var nav = new zim.Container({style:false});
			nav.setBounds(0,0,600,100);
			this.addChild(nav);
			nav.x = 0;
			nav.y = lastHeight+margin;

			var swatchText = this.swatchText = new zim.Label({
				align:"center",
				text:myColor.toUpperCase(), labelWidth:120, labelHeight:50, size:30, color:"orange", rollColor:"orange",
				backing:"ignore", shadowColor:"ignore", shadowBlur:"ignore", backgroundColor:"ignore",
				group:this.group
			});
			nav.addChild(swatchText);
			zim.centerReg(swatchText);
			swatchText.x = 200/2-10;
			swatchText.y = 50-2;

			if (draggable) {
				var grip = this.grip = new zim.Shape({style:false});
				nav.addChild(grip);
				grip.graphics.f("rgba(256,256,256,.25)").r(0,0,5,20).r(10,0,5,20).r(20,0,5,20).r(30,0,5,20);
				grip.x = 70; grip.y = 65;
				swatchText.y = 50-10;
				grip.mouseEnabled = false;
			}
			var closeBut = this.closeBut = new zim.Button({width:90, height:90, label:"X", backgroundColor:"#222", rollBackgroundColor:"#444", corner:0, style:false});
			nav.addChild(closeBut);
			closeBut.x = 600 - closeBut.width - margin;
			closeBut.y = 0;
			closeBut.on((!zns?ACTIONEVENT=="mousedown":zim.ACTIONEVENT=="mousedown")?"mousedown":"click", function(){that.dispatchEvent("close");});

			var button = this.okBut = new zim.Button({width:150, height:90, label:"OK", backgroundColor:"#222", rollBackgroundColor:"#444", corner:0, style:false});
			nav.addChild(button);
			button.x = closeBut.x - button.width - margin;
			button.y = 0;
			button.on((!zns?ACTIONEVENT=="mousedown":zim.ACTIONEVENT=="mousedown")?"mousedown":"click", doChange);

			var swatchBacking = this.swatchBacking = new zim.Shape({style:false});
			nav.addChild(swatchBacking);
			var g = swatchBacking.graphics;
			g.f("black").r(0.5,0.5,50,89).f("#666").r(50,0.5,50,89).f("white").r(100,0.5,49.5,89);
			swatchBacking.x = button.x - 150 - margin;
			swatchBacking.y = 0;

			var swatch = this.swatch = new zim.Rectangle(150, 90, myColor, null, null, null, null, null, false);
			nav.addChild(swatch);
			swatch.x = swatchBacking.x;
			swatch.y = 0;
			swatch.on((!zns?ACTIONEVENT=="mousedown":zim.ACTIONEVENT=="mousedown")?"mousedown":"click", doChange);
			swatch.cursor = "pointer";
			swatch.alpha = myAlpha = startAlpha;

			nav.scaleX = nav.scaleY = width / 600;
			lastHeight += nav.height;
		} else {
			box.cursor = "pointer";
		}

		if (!alphaPicker && !buttonBar) {
			lastHeight -= margin - spacing;
		}

		var height = lastHeight + margin;
		this.setBounds(0,0,width,height);

		var background = this.background = new zim.Rectangle(width,height,backgroundColor, null, null, null, null, null, false);
		this.addChildAt(background,0);
		if (shadowColor != -1 && shadowBlur > 0) background.shadow = new createjs.Shadow(shadowColor, 8, 8, shadowBlur);

		function doChange(){
			if (myColor != lastBackgroundColor || myAlpha != lastAlpha) {
				if (standard && greyPicker) {
					thirdLastBackgroundColor = secondLastBackgroundColor;
					secondLastBackgroundColor = lastBackgroundColor;
					var lastBackgroundColors = [thirdLastBackgroundColor, secondLastBackgroundColor]
					for (i=0; i<2; i++) {
						var g = box.graphics;
						c = Math.floor(i/cols);
						r = i%cols;
						rX = r*(w+spacing);
						rY = c*(w+spacing)+greyHeight;
						greys[i] = lastBackgroundColors[i];
						g.f(background.color).r(rX-1,rY-1,w+2,w+2).f(lastBackgroundColors[i]).r(rX,rY,w,w);
					}
					if ((!zim.OPTIMIZE&&(zns||!OPTIMIZE)) && that.stage) that.stage.update();
				}
				lastBackgroundColor = myColor;
				lastAlpha = myAlpha;

				that.dispatchEvent("change");
			} else {
				that.dispatchEvent("close");
			}
		}

		if (draggable) {
			var diffX, diffY;
			background.on("mousedown", function(e) {
				stage = e.target.stage;
				diffX = e.stageX/stage.scaleX - that.x;
				diffY = e.stageY/stage.scaleY - that.y;
				background.cursor = "move";
			});
			background.on("pressmove", function(e) {
				that.x = e.stageX/stage.scaleX-diffX;
				that.y = e.stageY/stage.scaleY-diffY;
				if (that.stage) that.stage.update();
			});
			background.on("pressup", function(e) {
				background.cursor = "default";
				if (that.stage) that.stage.update();
			});
		}

		var gridW = cols*(w+spacing);
		var gridH = rows*(w+spacing);
		if (greyPicker) {
			var greyW = greyCols*(w+spacing);
			var greyH = greyRows*(w+spacing);
		}
		box.on((!zns?ACTIONEVENT=="mousedown":zim.ACTIONEVENT=="mousedown")?"mousedown":"click", function(e) {
			var index = zim.hitTestGrid(box, gridW, gridH, cols, rows, e.stageX, e.stageY, 0, 0, spacing, spacing);
			if (!zot(index)) {
				myColor = colors[index];
				if (buttonBar) {
					swatch.color = myColor;
					swatchText.text = String(colors[index]).toUpperCase();
					if (myColor != lastBackgroundColor) that.dispatchEvent("set");
				} else {
					doChange();
				}
			}
			if (greyPicker) {
				// note greyW not gridW
				index = null;
				index = zim.hitTestGrid(box, greyW, greyH, greyCols, greyRows, e.stageX, e.stageY, 0, gridH, spacing, spacing);

				if (!zot(index)) {
					myColor = greys[index];
					if (buttonBar) {
						swatch.color = myColor;
						swatchText.text = greys[index].toUpperCase();
						if (myColor != lastBackgroundColor) that.dispatchEvent("set");
					} else {
						doChange();
					}
				}
			}
			if (indicator) positionIndicator(colors.indexOf(myColor));
			if (buttonBar) {
				if (that.stage) that.stage.update();
			} else if (indicator) {
				if (that.stage) that.stage.update();
				// if ((!zim.OPTIMIZE&&(zns||!OPTIMIZE)) && that.stage) that.stage.update();
			}
			setAccessibility();
		});

		Object.defineProperty(this, 'selectedColor', {
			get: function() {
				return myColor;
			},
			set: function(value) {
				lastBackgroundColor = myColor = value;
				if (buttonBar) {
					swatch.color = myColor;
					swatchText.text = myColor;
					if (that.stage) that.stage.update();
				}
				if (indicator) positionIndicator(colors.indexOf(myColor));
				setAccessibility();
			}
		});

		Object.defineProperty(this, 'currentValue', { // alternate to selectedColor
			get: function() {
				return myColor;
			},
			set: function(value) {
				that.selectedColor = value;
			}
		});

		Object.defineProperty(this, 'currentValueEvent', { // currentValue and also triggers change event
			get: function() {
				return myColor;
			},
			set: function(value) {
				if (value != that.selectedColor) {
					that.selectedColor = value;
					that.dispatchEvent("change");
				}
			}
		});

		Object.defineProperty(this, 'selectedIndex', {
			get: function() {
				return colors.indexOf(myColor);
			},
			set: function(value) {
				lastBackgroundColor = myColor = colors[value];
				if (buttonBar) {
					swatch.color = myColor;
					swatchText.text = myColor;
					if (that.stage) that.stage.update();
				}
				if (indicator) positionIndicator(colors.indexOf(myColor));
				setAccessibility();
			}
		});

		Object.defineProperty(this, 'selectedAlpha', {
			get: function() {
				if (alphaPicker) {
					return decimals(slider.currentValue);
				} else {
					return 1;
				}
			},
			set: function(value) {
				if (alphaPicker) {
					lastAlpha = slider.currentValue = value;
					if (swatch) swatch.alpha = lastAlpha;
					if (alphaText) alphaText.text = "Alpha: " + decimals(slider.currentValue);
					if (that.stage) that.stage.update();
				}
			}
		});


		Object.defineProperty(this, 'colors', {
			get: function() {
				if (greyPicker) return colors.concat(greys);
				else return colors;
			},
			set: function(value) {
				if (zon) zog("Display - ColorPicker() colors is read only - make a new ColorPicker to change")
			}
		});

		if (typeof KEYFOCUS !== typeof undefined) zim.KEYFOCUS = KEYFOCUS;
		Object.defineProperty(this, 'keyFocus', {
			get: function() {
				return zim.KEYFOCUS == that;
			},
			set: function(value) {
				if (zns) zim.KEYFOCUS = that;
				else KEYFOCUS = that;
			}
		});
		if (keyArrows && zim.KEYFOCUS) setFocus();
		this.on("mousedown", function() {if (keyArrows) setFocus()});
		function setFocus() {that.keyFocus = true; var d=document.activeElement; if (d) d.blur();}

		function setAccessibility() {
			if (that.zimAccessibility) that.zimAccessibility.changeTitle(that, null, true);
		}

		this.keyDownEvent = function(e) {
			if (!that.stage) return;
			if ((that.zimAccessibility && that.focus) || (!that.zimAccessibility && that.keyFocus)) {
				var currentTemp = that.selectedIndex;
				if (e.keyCode == 37 || e.keyCode == 40) {
					currentTemp--;
					changeMe();
				} else if (e.keyCode == 38 || e.keyCode == 39){
					currentTemp++;
					changeMe();
				}
				function changeMe() {
					if (currentTemp < 0) currentTemp = that.colors.length-1;
					if (currentTemp > that.colors.length-1) currentTemp = 0;
					that.selectedIndex = currentTemp;
					that.dispatchEvent("change");
					if (that.stage) that.stage.update();
				}
			}
		}
		window.addEventListener("keydown", this.keyDownEvent);

		this.hide = function() {
			that.removeFrom();
			that.toggled = false;
			if (that.zimAccessibility) {
				var a = that.zimAccessibility;
				a.resize(that);
				if (accessibilityClicker) accessibilityClicker.focus();
				else that.zimTabTag.nextSibling.focus();
				setTimeout(function() {a.talk("ColorPicker has been closed.");}, 50);
			}
			return that;
		}

		var accessibilityClicker;
		this.show = function() {
			that.center(that.container);
			if (that.zimAccessibility) {
				var a = that.zimAccessibility;
				setTimeout(function(){if (a.activatedObject) accessibilityClicker = a.activatedObject.zimTabTag;}, 50);
				a.resize(that);
				a.tabIndex = that.zimTabIndex;
			}
			that.toggled = true;
			return that;
		}
		this.toggle = function(state) {
			if (state===true) that.show();
			else if (state===false) that.hide();
			else if (that.container.contains(that)) that.hide();
			else that.show();
			return that;
		}

		function decimals(n) {
			return Math.round(n*Math.pow(10, 2))/Math.pow(10, 2);
		}

		if (style!==false) zimStyleTransforms(this, DS);
		this.clone = function() {
			return that.cloneProps(new zim.ColorPicker(width, standard?null:colors, cols, spacing, greyPicker, alphaPicker, startBackgroundColor, draggable, shadowColor, shadowBlur, buttonBar, circles, indicator, backgroundColor, keyArrows, container, style, this.group, inherit));
		}

		this.dispose = function() {
			window.removeEventListener("keydown", that.keyDownEvent);
			if (slider) slider.dispose();
			this.zimContainer_dispose();
			return true;
		}
	}
	zim.extend(zim.ColorPicker, zim.Container, ["clone", "dispose"], "zimContainer", false);
	//-67

/*--
zim.Keyboard = function(labels, backgroundColor, color, shiftBackgroundColor, shiftHoldBackgroundColor, placeBackgroundColor, placeColor, cursorColor, shadeAlpha, borderColor, borderWidth, margin, corner, draggable, placeClose, shadowColor, shadowBlur, container, data, place, special, rtl, style, group, inherit)

Keyboard
zim class - extends a zim.Container which extends a createjs.Container

DESCRIPTION
The Keyboard class makes a keyboard ideal for mobile or touch screens.
Often, it seems the mobile keyboard can cause problems with layout.
This in-canvas keyboard requires much less testing and concern.
The Keyboard can work with ZIM Labels to give input text without a TextArea.
Thanks Frank Los for the initial design and coding of the Keyboard.
See https://zimjs.com/keyboard

NOTE: press and hold down the vowels for multiple vowel options
NOTE: currently, multi-line Label input is not supported
NOTE: the width of the Label can be set by the Label's lineWidth paremeter
NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
// create Labels to capture the text from the keyboard
var text1 = new Label({text:"", backgroundColor:white}).pos(100,100);
var text2 = new Label({text:"", backgroundColor:white}).pos(100,200);

// create a new Keyboard and pass in the labels as an array
// or if just one label, then pass in the label
var keyboard = new Keyboard([text1, text2]);

// if just the letter is needed use the keydown event
keyboard.on("keydown", function(e) {
	zog(e.letter);
});

// create events to capture a mousedown on the labels
var text1Event = text1.on("mousedown", activate);
var text2Event = text2.on("mousedown", activate);
function activate(e) {
	keyboard.show();
	// remove the events when keyboard is active
	text1.off("mousedown", text1Event);
	text2.off("mousedown", text2Event);
}
keyboard.show(); // optionally show the keyboard to start

// add back the events to show the keyboard
keyboard.on("close", function() {
	text1.on("mousedown", text1Event);
	text2.on("mousedown", text2Event);
});
END EXAMPLE

PARAMETERS
** supports DUO - parameters or single object with properties below
** supports OCT - parameter defaults can be set with STYLE control (like CSS)
labels - (default null) a ZIM Label to show letters in or an array of labels
	Keyboard will add a cursor to the Labels
	and provide management across multiple labels
	currently, multiline labels are not supported
	setting the label lineWidth will set the max width of the label
backgroundColor - (default "#333") an css color for the background color of the keys
color - (default "white") the color of the text
shiftBackgroundColor - (default "orange") the color of the active shift key
shiftHoldBackgroundColor - (default "red") the color of the active shift hold key
placeBackgroundColor - (default "50c4b7") the color of the arrow backings when placing cursor in label
placeColor - (default "50c4b7") the color of the arrow text when placing cursor in label
cursorColor - (default "50c4b7") the cursor color
shadeAlpha - (default .2) special keys are shaded darker by this alpha
margin - (default 5) the margin around the keyboard from the container width
corner - (default 30) the round of the corner (set to 0 for no corner)
	can also be an array of [topLeft, topRight, bottomRight, bottomLeft]
draggable - (default false) set to true to show the drag handle at top right
placeClose - (default true) shows an x key to close the cursor placement menu
shadowColor - (default "rgba(0,0,0,.2)") set to -1 for no shadow
shadowBlur - (default 14) how blurred the shadow is if the shadow is set
container - (default zimCurrentFrame stage) if placing Keyboard in different container or stage
data - (default see below) pass in data for the letters on the three sets of keyboards
	Below is the default data - change any of the keys to change keyboard
	There must be three boards (you can request more)
	There must be a button specified on the fourth row to toggle to the second screen and back
	There must be a button on the second and third screen at the start of the third row
	to toggle between the second and third screen
	The "shift" and "delete" keys are optional and can be moved or removed
	Where 10 keys can fit, there is a maximum of 10 keys but there can be less
	Use the data property to get this array if desired:
	var data = [
		[
			["q","w","e","r","t","y","u","i","o","p"],
			["a","s","d","f","g","h","j","k","l"],
			["shift","z","x","c","v","b","n","m","backspace"],
			["?123"] // rest of bottom line automatically added
		],[
			["1","2","3","4","5","6","7","8","9","0"],
			["!","@","#","$","/","^","&","*","(",")"],
			["1/2","-","'", "\"",":",";",",","?","backspace"],
			["ABC"] // rest of bottom line automatically added
		],[
			["+","x","%","=","<",">","{","}","[","]"],
			["€","£","¥", "$", "￦", "~", "`","¤","♡","☆"],
			["2/2","_","\\","|","《","》","¡","¿","backspace"],
			["ABC"] // rest of bottom line automatically added
		]
	];
place (default true) - set to false to not add place arrows when selecting Label
special (default null) - set to a string to add a special key to the left of the space bar
rtl (default false) - (Experimental) set to true to use right-to-left text
style - (default true) set to false to ignore styles set with the STYLE - will receive original parameter defaults
group - (default null) set to String (or comma delimited String) so STYLE can set default styles to the group(s) (like a CSS class)
inherit - (default null) used internally but can receive an {} of styles directly

METHODS
show(index) - shows the Keyboard - use this rather than addTo(), etc.
	index (default null) specify the index of the labels array to show cursor in
hide() - hides the keyboard
toggle(state - default null) - shows if hidden and hides if showing (returns the keyboard for chaining)
	or pass in true to show keyboard or false to hide keyboard
addLabels(labels) - add a ZIM Label or an array of Labels to the labels list for the Keyboard
removeLabels(labels) - remove a ZIM Label or an array of Labels
showPlace() - show the place menu for cursor
hidePlace() - hide the place menu for cursor
resize() - scales the keyboard to the stage with margin and places at bottom of screen
hasProp(property as String) - returns true if property exists on object else returns false
clone() - makes a clone of the Keyboard
dispose() - removes from parent, removes event listeners - must still set outside references to null for garbage collection

ALSO: ZIM 4TH adds all the methods listed under Container (see above), such as:
drag(), hitTestRect(), animate(), sca(), reg(), mov(), center(), centerReg(),
addTo(), removeFrom(), loop(), outline(), place(), pos(), alp(), rot(), setMask(), etc.
ALSO: See the CreateJS Easel Docs for Container methods, such as:
on(), off(), getBounds(), setBounds(), cache(), uncache(), updateCache(), dispatchEvent(),
addChild(), removeChild(), addChildAt(), getChildAt(), contains(), removeAllChildren(), etc.

PROPERTIES
data - get the data array for the keyboard - see the data parameter for details and to set value for data
labels - get the labels array - use addLabels() and removeLabels() to set
selectedLabel - the label with the cursor or -1 if no cursor
selectedIndex - the index of the cursor in the selected label or -1 if no cursor
type - holds the class name as a String
toggled - read-only Boolean that is true if keyboard is visible and false if not
** setting widths and heights adjusts scale not bounds and getting these uses the bounds dimension times the scale
width - gets or sets the width. Setting the width will scale the height to keep proportion (see widthOnly below)
height - gets or sets the height. Setting the height will scale the width to keep proportion (see heightOnly below)
widthOnly - gets or sets the width.  This sets only the width and may change the aspect ratio of the object
heightOnly - gets or sets the height.  This sets only the height and may change the aspect ratio of the object
group - used when the object is made to add STYLE with the group selector (like a CSS class)

ALSO: See the CreateJS Easel Docs for Container properties, such as:
x, y, rotation, scaleX, scaleY, regX, regY, skewX, skewY,
alpha, cursor, shadow, mouseChildren, mouseEnabled, parent, numChildren, etc.

EVENTS
Dispatches a "keydown" event with an event object having a letter property
	keyboard.on("keydown", function(e) {zog(e.letter);}); // logs letter pressed or "del" for delete
Dispatches a "special" event if the special parameter is used and the special key is pressed
Dispatches a "close" event when close keyboard icon at bottom right is pressed

ALSO: See the CreateJS Easel Docs for Container events, such as:
added, click, dblclick, mousedown, mouseout, mouseover, pressmove, pressup, removed, rollout, rollover
--*///+67.2
	zim.Keyboard = function(labels, backgroundColor, color, shiftBackgroundColor, shiftHoldBackgroundColor, placeBackgroundColor, placeColor, cursorColor, shadeAlpha, borderColor, borderWidth, margin, corner, draggable, placeClose, shadowColor, shadowBlur, container, data, place, special, rtl, style, group, inherit) {
		var sig = "labels, backgroundColor, color, shiftBackgroundColor, shiftHoldBackgroundColor, placeBackgroundColor, placeColor, cursorColor, shadeAlpha, borderColor, borderWidth, margin, corner, draggable, placeClose, shadowColor, shadowBlur, container, data, place, special, rtl, style, group, inherit";
		var duo; if (duo = zob(zim.Keyboard, arguments, sig, this)) return duo;
		z_d("67.2");
		this.zimContainer_constructor(1000,400,null,null,false);
		this.type = "Keyboard";
		this.group = group;
		var DS = style===false?{}:zim.getStyle(this.type, this.group, inherit);

		if (zot(labels)) labels = DS.labels!=null?DS.labels:[];
		if (!Array.isArray(labels)) labels = [labels];
		if (zot(backgroundColor)) backgroundColor = DS.backgroundColor!=null?DS.backgroundColor:"#333";
		if (zot(color)) color =  DS.color!=null?DS.color:"white";
		if (zot(shiftBackgroundColor)) shiftBackgroundColor = DS.shiftBackgroundColor!=null?DS.shiftBackgroundColor:"orange";
		if (zot(shiftHoldBackgroundColor)) shiftHoldBackgroundColor = DS.shiftHoldBackgroundColor!=null?DS.shiftHoldBackgroundColor:"red";
		if (zot(placeBackgroundColor)) placeBackgroundColor = DS.placeBackgroundColor!=null?DS.placeBackgroundColor:"#50c4b7";
		if (zot(placeColor)) placeColor = DS.placeColor!=null?DS.placeColor:color;
		if (zot(cursorColor)) cursorColor = DS.cursorColor!=null?DS.cursorColor:"#50c4b7";
		if (zot(shadeAlpha)) shadeAlpha = DS.shadeAlpha!=null?DS.shadeAlpha:.2;
		if (zot(borderColor)) borderColor = DS.borderColor!=null?DS.borderColor:"rgba(0,0,0,.1)";
		if (zot(borderWidth)) borderWidth = DS.borderWidth!=null?DS.borderWidth:null;
		if (borderColor < 0 || borderWidth < 0) borderColor = borderWidth = null;
		else if (borderColor!=null && borderWidth==null) borderWidth = 1;
		if (zot(margin)) margin = DS.margin!=null?DS.margin:5;
		if (zot(corner)) corner = DS.corner!=null?DS.corner:30;
		if (zot(draggable)) draggable = DS.draggable!=null?DS.draggable:false;
		if (zot(placeClose)) placeClose = DS.placeClose!=null?DS.placeClose:true;
		if (zot(shadowColor)) shadowColor=DS.shadowColor!=null?DS.shadowColor:"rgba(0,0,0,.2)";
		if (zot(shadowBlur)) shadowBlur=DS.shadowBlur!=null?DS.shadowBlur:14;
		if (zot(data)) data = DS.data!=null?DS.data:[
				[
					["q","w","e","r","t","y","u","i","o","p"],
					["a","s","d","f","g","h","j","k","l"],
					["shift","z","x","c","v","b","n","m","backspace"],
					["?123"] // rest of bottom line automatically added
				],[
					["1","2","3","4","5","6","7","8","9","0"],
					["!","@","#","$","/","^","&","*","(",")"],
					["1/2","-","'", "\"",":",";",",","?","backspace"],
					["ABC"] // rest of bottom line automatically added
				],[
					["+","x","%","=","<",">","{","}","[","]"],
					["€","£","¥", "$", "￦", "~", "`","¤","♡","☆"],
					["2/2","_","\\","|","《","》","¡","¿","backspace"],
					["ABC"] // rest of bottom line automatically added
				]
			];
		var that = this;
		that.data = data;
		if (zot(place)) place = DS.place!=null?DS.place:true;
		if (zot(rtl)) rtl = DS.rtl!=null?DS.rtl:false;

		var mess = "zim display - Keyboard(): Please pass in a reference to a container with bounds set";
		if (zot(container)) {
			if (zimDefaultFrame) {
				container = zimDefaultFrame.stage;
			} else {
				zog(mess);
				return;
			}
		} else if (!container.getBounds) {
			zog(mess);
			return;
		} else if (zot(container.stage)) {
			zog("zim display - Keyboard(): The container must have a stage property");
			return;
		}

		if (shadowColor != -1 && shadowBlur > 0) that.shadow = new createjs.Shadow(shadowColor, 3, 3, shadowBlur);
		var currentStage = zimDefaultFrame?zimDefaultFrame.stage:null;

		// ~~~~~~~~~~~~~~~~~  SETUP

		that.labels = labels;
		var maxWidth;
		var numH = 10;

		var botArray = ["@","",".","/","away"];
		if (!zot(special)) botArray.splice(1,0,special);

		var textKeys = zim.copy(data[0]);
		// textKeys[2].unshift("shift");
		// textKeys[2].push("backspace");
		textKeys[3] = textKeys[3].concat(botArray);

		var numberKeys1 = zim.copy(data[1]);
		// numberKeys1[2].push("backspace");
		numberKeys1[3] = numberKeys1[3].concat(botArray);

		var numberKeys2 = zim.copy(data[2]);
		// numberKeys2[2].push("backspace");
		numberKeys2[3] = numberKeys2[3].concat(botArray);

		// var textKeys = [
		// 	["q","w","e","r","t","y","u","i","o","p"],
		// 	["a","s","d","f","g","h","j","k","l"],
		// 	["shift","z","x","c","v","b","n","m","backspace"],
		// 	["?123","@","",".","/","away"]
		// ]
		// var numberKeys1 = [
		//     ["1","2","3","4","5","6","7","8","9","0"],
		//     ["!","@","#","$","/","^","&","*","(",")"],
		//     ["1/2","-","'", "\"",":",";",",","?","backspace"],
		//     ["ABC","@","",".","/","away"]
		// ];
		// var numberKeys2 = [
		//     ["+","x","%","=","<",">","{","}","[","]"],
		//     ["€","£","¥", "$", "￦", "~", "`","¤","♡","☆"],
		//     ["2/2","_","\\","|","《","》","¡","¿","backspace"],
		//     ["ABC", "@","",".","/","away"]
		// ];
		var eLetters = ["ė","ē","ę","ê","é","ë","è"];//ĒĘÊÉËÈ
		var uLetters = ["ū","û","ú","ü","ù"];//ŪÛÚÜÙ
		var iLetters = ["ī","į","ì","í","ï","î"];//ĪĮÌÍÏÎ
		var oLetters = ["ō","œ","ø","õ","ô","ó","ö","ò"];// ŌŒØÕÔÓÖÒ
		var aLetters = ["ā","ã","å","â","á","ä","à","æ"];// ĀÃÅÂÁÄÀÆ
		var nLetters = ["ñ","ń"];

		var textKeyButtons = [];

		//maateenheid horizontaal
		var size = (1000-(9*5))/numH;

		//statuses toestenbord
		var statuses = {
		    def:"default",
		    shift:"shift",
		    number1:"number1",
		    number2:"number2"
		};
		var currentStatus = statuses.def;
		var currentKeyboard;
		var alternativeMenu;
		var textBlinker;
		var bigShiftOn = false;
		var shiftKey;
		var currentLabel;
		var insertPoint = 0;
		var cursorShiftMenu;
		var buttonsCursor = [];
		var shiftKeyIcon;
		var backspaceIcon;
		var hideKeyBoardIcon;
		var dragButton;
		var dragY;

		makeIcons();
		makeButtons(currentStatus);
		if (draggable) makeDragButton();

		// ~~~~~~~~~~~~~~~~~  INTERACTIONS

		this.on("mousedown", buttonPressed);

		function buttonPressed(e) {
		    currentStage = that.stage;
		    if (alternativeMenu) {
		        that.removeChild(alternativeMenu);
		    }
		    if (cursorShiftMenu) {
		        if (buttonsCursor.indexOf (e.target) < 0) {
		            removeCursorShiftMenu();
		        }
		    }
		    if (!zot(e.target.name)) {
		        //WIJZIGINGEN STATUS keyboard
		        if (draggable && e.target === dragButton) {
					that.tickerMouseEvent = currentStage.on("stagemousemove", function(e) {
						that.mouseYAmount = e.stageY;
					});
		            zim.Ticker.add(startDragging);
		            that.on("pressup", stopDragging);
		            dragY = e.stageY-that.localToGlobal(0,0).y;
				} else if (!zot(special) && e.target.name === special) {
		            that.dispatchEvent("special");
				} else if (e.target.name === "shift") { //shift
		            shiftKeys();
		        } else if (e.target.toggle === "?123") { //nummers
		            that.removeChild(currentKeyboard);
		            makeButtons(statuses.number1);
		        } else if (e.target.toggle === "ABC") { //teksten
		            that.removeChild(currentKeyboard);
		            currentStatus = statuses.def;
		            makeButtons();
		            if (bigShiftOn) shiftKeys(true);
		        } else if (e.target.toggle==="1/2") {
		            that.removeChild(currentKeyboard);
		            makeButtons(statuses.number2);
		        } else if (e.target.toggle==="2/2") {
		            that.removeChild(currentKeyboard);
		            makeButtons(statuses.number1);
		        } else if (e.target.name==="away") {
		            hideKeyboard();
					that.dispatchEvent("close");
		        } else if (e.target.name === "e"||
		                e.target.name === "u"||
		                e.target.name === "i"||
		                e.target.name === "o"||
		                e.target.name === "a"||
		                e.target.name === "n") { //VARIATIES LETTERS euioan
		            makeAlternativeLetters(e.target.name);
		        } else if (e.target.name === "return") {
		            addToLabel("\n");
		        } else if (e.target.name === "backspace") {
		            backspaceRemovesLetter();
		        } else if (e.target.name === "") {
		            addToLabel(" ");
		        } else {
		            addToLabel(e.target.name);
		        }
		        currentStage.update();
		    }
		}

		var shiftEvent;
		function shiftKeys(immediate) {
		    var bigShift = false;
		    var i;
		    //vanuit default
		    if (currentStatus === statuses.def) {
		        shiftKey.color = immediate?shiftHoldBackgroundColor:shiftBackgroundColor;
		        //keyboard veranderen
		        for(i=0; i<textKeyButtons.length-6-(zot(special)?0:1);i++) {
		            var tkb = textKeyButtons[i];
		            if (tkb.label.text.length > 0) {
		                if (tkb.name.length===1) {
		                    tkb.label.text = tkb.label.text.toUpperCase();
		                    tkb.label.centerReg(tkb).mov(0,6);
		                } else {
		                    tkb.label.centerReg(tkb);
		                }
		            }
		        }
		        if (!immediate) {
		            //na halve seconde gaat groot shift aan
		            bigShift = true;
		            zim.timeout(500, putBigShiftOn);
		            shiftEvent = that.on("pressup", doNotPutBigShiftOn);
		        }
		        currentStatus = statuses.shift;
		    //vanuit shift
		    } else {
		        shiftKey.color = backgroundColor;
		        bigShiftOn = false;
		        //keyboard veranderen
		        for(i=0; i<textKeyButtons.length-6;i++) {
		            var tkb = textKeyButtons[i];
		            if (tkb.label.text.length>0) {
		                if (tkb.name.length===1) {
		                    tkb.label.text = tkb.label.text.toLowerCase();
		                    tkb.label.centerReg(tkb).mov(0,3);
		                } else {
		                    tkb.label.centerReg(tkb);
		                }
		            }
		        }
		        currentStatus = statuses.def;
		    }
			currentKeyboard.updateCache();
		    that.stage.update();
		    function putBigShiftOn() {
		        if (bigShift) {
		            bigShiftOn = true;
		            shiftKey.color = shiftHoldBackgroundColor;
					currentKeyboard.updateCache();
		            that.stage.update();
		        }
		    }
		    function doNotPutBigShiftOn(e) {
		        that.off("pressup", shiftEvent);
		        bigShift = false;
		    }
		}

		// ~~~~~~~~~~~~~~~~~  ASSETS

		function makeButtons(which) {
		    var typeKeyboard;
		    var label;
		    var button;
		    var bakking;
		    var xPos = 0;
		    var yPos = 0;
		    var thisWidth;
		    var bigKey;
		    var thisIsSpacekey= false;
		    var thisKeyLetter;
		    var passesLetter;
		    var dark= false;
		    //zonder parameters maak ik letters
		    if (zot(which)) which = statuses.def;
		    //letters
		   	if (which === statuses.def) {
		        typeKeyboard = textKeys;
		    //nummers1
		    } else if (which === statuses.number1) {
		        typeKeyboard = numberKeys1;
		    //nummers 2
		    } else if (which === statuses.number2) {
		        typeKeyboard = numberKeys2;
		    }
		    //container maken
		    currentKeyboard = new zim.Container(1000,430,null,null,false).addTo(that);
		    //alle toetsen, door arrays heen wandelen
		    for (var i = 0; i<typeKeyboard.length; i++) {
				if (i<=1 || (which==statuses.def && i==2 && typeKeyboard[2][0] != "shift")) {
					xPos=(size/2+2.5)*(10-typeKeyboard[i].length);
				}
		        for (var j=0; j<typeKeyboard[i].length; j++) {
		            thisIsSpacekey = false;
		            thisKeyLetter = null;
		            dark= false;
		            if (typeKeyboard[i][j]=="backspace") {
		                bigKey = true;
		                thisKeyLetter = backspaceIcon;
		                dark= true;
		            } else if (typeKeyboard[i][j]=="shift") {
		                bigKey = true;
		                thisKeyLetter = shiftKeyIcon;
		            } else if ((i==3 || (which!=statuses.def && i==2)) && j==0) {
		                bigKey = true;
		                dark= true;
		            } else if (typeKeyboard[i][j]=="") {
		                bigKey = false;
		                thisIsSpacekey = true;
		            } else if (typeKeyboard[i][j]=="away") {
		                thisKeyLetter = hideKeyBoardIcon;
		                bigKey = true;
		                dark= true;
		            } else {
		                bigKey = false;
		            }
		            //brede toets: breedte instellen
		            if (bigKey) {
		                thisWidth = (size*1.5+2.5);
		            } else if (thisIsSpacekey) {
		                thisWidth = (size+5)*(zot(special)?4:3)-5;
		            } else {
		                thisWidth = size;
		            }
					button = new zim.Rectangle(thisWidth, size, backgroundColor, borderColor, borderWidth, corner, null, null, false).cur().addTo(currentKeyboard);
					if (dark) button.addChild(new zim.Rectangle(thisWidth, size, "black", null, null, corner, null, null, false).alp(shadeAlpha));

		            if (thisKeyLetter) {
		                button.label = label = new zim.Label({text:"", backgroundColor:"ignore", font:DS.font!=null?DS.font:null, style:false});
		            } else {
		                button.label = label = new zim.Label({
		                    lineWidth:10,
		                    lineHeight:25,
							font:DS.font!=null?DS.font:null,
		                    text:typeKeyboard[i][j],
		                    color:color,
		                    align:"center",
							style:false
		                });
		            }
		            //plaatje op bakking
		            if (thisKeyLetter) {
						var clone = thisKeyLetter.clone();
		                clone.scaleTo(button,70,70);
		                clone.centerReg(button);
		            }
		            if (!passesLetter) {
		                label.centerReg(button).mov(0,(!isNaN(label.text)) ? 7 : 3);
		                button.x = xPos;
		                button.y = yPos;
		                button.name = typeKeyboard[i][j];
						if (i==2 && j==0 && which == statuses.number1) button.toggle = "1/2";
						if (i==2 && j==0 && which == statuses.number2) button.toggle = "2/2";
						if (i==3 && j==0 && which == statuses.def) button.toggle = "?123";
						if (i==3 && j==0 && which != statuses.def) button.toggle = "ABC";
						if (button.toggle) label.mov(0,3);
		                textKeyButtons.push(button);
		                if (button.name == "shift") {
		                    shiftKey = button;
		                }
		                xPos = button.x + button.width+5;
		            } else {
		                passesLetter = false;
		                xPos += 67.33;
		            }
		        }
		        yPos += size+5;
		        xPos = 0;
		    }
			currentKeyboard.cache(borderWidth?-borderWidth:0, borderWidth?-borderWidth:0, borderWidth?currentKeyboard.width+borderWidth*2:currentKeyboard.width, borderWidth?currentKeyboard.height+borderWidth*2:currentKeyboard.height);
		}

		function makeAlternativeLetters(letter) {
		    var thisArray;
		    var mouseReleased = false;
		    var alternativeMenuIsmade = false;
		    var timeWait;
		    switch(letter) {
		        case "e":
		        thisArray = eLetters;
		        break;
		        case "u":
		        thisArray = uLetters;
		        break;
		        case "i":
		        thisArray = iLetters;
		        break;
		        case "o":
		        thisArray = oLetters;
		        break;
		        case "a":
		        thisArray = aLetters;
		        break;
		        case "n":
		        thisArray = nLetters;
		        break;
		        default:
		        break;
		    }
		    timeWait = zim.timeout(500, makeAlternatemenu);
		    var mouseUpEvent = that.on("pressup", mouseUp);
		    function mouseUp(e) {
		        mouseReleased = true;
		        that.off("pressup", mouseUpEvent);
		        if (!alternativeMenuIsmade) {
		            addToLabel(letter);
		        }
		    }
		    function makeAlternatemenu() {
		        var label,
		            bakking,
		            button,
					overlay,
		            xPos = 0,
		            thisLetter;
		        timeWait.clear();
		        if (!mouseReleased) {
		            alternativeMenuIsmade = true;
		            alternativeMenu = new zim.Container(1000,size,null,null,false).addTo(that, 0);
		            alternativeMenu.y = - size - 5;
		            for (var i=0; i<thisArray.length; i++) {
		                if (currentStatus === statuses.shift) {
		                    thisLetter = thisArray[i].toUpperCase();
		                } else {
		                    thisLetter = thisArray[i];
		                }
		                label = new zim.Label({
		                    lineWidth:10,
		                    lineHeight:25,
		                    text:thisLetter,
							font:DS.font!=null?DS.font:null,
		                    color:color,
		                    align:"center",
							style:false
		                });
		                button = new zim.Rectangle(size, size, backgroundColor, borderColor, borderWidth, corner, null, null, false).addTo(alternativeMenu);
		                overlay = new zim.Rectangle(size, size, "white", null, null, corner, null, null, false).alp(.2);
		                button.addChild(overlay);
		                label.center(button);
		                button.name = thisArray[i];
		                button.x = xPos;
		                xPos += size+5;
		            }
		            that.stage.update();
		        }
		    }
		}

		function makeIcons() {
		    //shift
		    shiftKeyIcon = new zim.Shape({style:false});
		    shiftKeyIcon.graphics.f (color).p("AhIFoIAAjYIixAAID5n3ID6H3IixAAIAADYgAjHBxICeAAIAADYIBTAAIAAjYICeAAIjImSg");
		    shiftKeyIcon.setBounds(-51/2,-72/2,51,72);
		    //backspace
		    backspaceIcon = new zim.Container({style:false});
		    var  backspaceShape1 = new zim.Shape({style:false});
		    backspaceShape1.graphics.f (color).p("ACgC+IigigIifCgQgGAGgJAAQgJAAgGgGQgGgGgBgJQABgJAGgGICgigIigifQgGgGgBgJQABgJAGgGQAGgGAJAAQAIAAAHAGICfCgICgigQAGgGAJAAQAJAAAGAGQAGAGABAJQgBAJgGAGIigCfICgCgQAGAGABAJQgBAJgGAGQgGAGgJAAQgJAAgGgGg");
		    backspaceShape1.setTransform(82.6,32);
		    backspaceShape1.addTo(backspaceIcon);
		    var  backspaceShape2 = new zim.Shape({style:false});
		    backspaceShape2.graphics.f (color).s().p("AkhFAQgcAAgUgUIkHj6QgVgUAAgeQAAgdAVgVIEHj6QAUgTAcAAINKAAQAdAAAUAUQAUAUAAAdIAAH1QAAAdgUATQgUAVgdAAgAk0kOIkGD8QgIAHAAALQAAALAIAIIEGD7QAIAHALAAINKAAQALAAAIgIQAHgHAAgLIAAn1QAAgLgHgIQgIgIgLAAItKAAQgLAAgIAHg");
		    backspaceShape2.setTransform(62.2,32);
		    backspaceShape2.addTo(backspaceIcon);
		    backspaceIcon.setBounds(0,0,125,64);
		    //keyboardAway
		    hideKeyBoardIcon = new zim.Container({style:false});
		    hideKeyBoardIcon.setBounds(0,0,147,86);
		    var hideKeyBoardIconArray = [
		        {p:("Ai+heIF9AAIi/C9g"),transform:[73.4,76]},
		        {p:("AgyAzIAAhlIBlAAIAABlg"),transform:[128.4,43.2]},
		        {p:("AnNAzIAAhlIObAAIAABlg"),transform:[73,43.2]},
		        {p:("AgyAzIAAhlIBlAAIAABlg"),transform:[18.8,43.2]},
		        {p:("AgyAzIAAhlIBlAAIAABlg"),transform:[128.2,29.5]},
		        {p:("AgyAzIAAhlIBlAAIAABlg"),transform:[114.5,29.5]},
		        {p:("AgyAzIAAhlIBlAAIAABlg"),transform:[100.8,29.5]},
		        {p:("AgyAzIAAhlIBlAAIAABlg"),transform:[87.1,29.5]},
		        {p:("AgyAzIAAhlIBlAAIAABlg"),transform:[73.4,29.5]},
		        {p:("AgyAzIAAhlIBlAAIAABlg"),transform:[59.7,29.5]},
		        {p:("AgyAzIAAhlIBlAAIAABlg"),transform:[46,29.5]},
		        {p:("AgyAzIAAhlIBlAAIAABlg"),transform:[32.3,29.5]},
		        {p:("AgyAzIAAhlIBlAAIAABlg"),transform:[18.6,29.5]},
		        {p:("AgyAzIAAhlIBlAAIAABlg"),transform:[128,15.8]},
		        {p:("AgyAzIAAhlIBlAAIAABlg"),transform:[114.3,15.8]},
		        {p:("AgyAzIAAhlIBlAAIAABlg"),transform:[100.6,15.8]},
		        {p:("AgyAzIAAhlIBlAAIAABlg"),transform:[86.9,15.8]},
		        {p:("AgyAzIAAhlIBlAAIAABlg"),transform:[73.2,15.8]},
		        {p:("AgyAzIAAhlIBlAAIAABlg"),transform:[59.5,15.8]},
		        {p:("AgyAzIAAhlIBlAAIAABlg"),transform:[45.8,15.8]},
		        {p:("AgyAzIAAhlIBlAAIAABlg"),transform:[32.1,15.8]},
		        {p:("AgyAzIAAhlIBlAAIAABlg"),transform:[18.4,15.8]},
		        {p:("AphEnQgzAAgkgkQglglAAgzIAAlVQAAgzAlglQAkgkAzAAITDAAQAzAAAkAkQAlAlAAAzIAAFVQAAAzglAlQgkAkgzAAgAqjjtQgcAcAAAnIAAFVQAAAnAcAbQAbAcAnAAITDAAQAnAAAcgcQAbgbAAgnIAAlVQAAgngbgcQgcgcgnAAIzDAAQgnAAgbAcg"),transform:[73.4,29.5]}
		    ];
		    var thisShape;
		    for (var i=0; i<hideKeyBoardIconArray.length;i++) {
		        thisShape = new zim.Shape({style:false});
		        thisShape.graphics.f (color).s().p(hideKeyBoardIconArray[i].p);
		        thisShape.setTransform(hideKeyBoardIconArray[i].transform[0],hideKeyBoardIconArray[i].transform[1]);
		        thisShape.addTo(hideKeyBoardIcon);
		    }
		}

		function makeDragButton() {
		    dragButton = new zim.Rectangle((size*1.5+2.5)+2.5,size,backgroundColor, borderColor, borderWidth, corner, null, null, false).addTo(that, 0).cur();
		    var rect;
		    for (var i=0; i<4;i++) {
		        rect = new zim.Rectangle(dragButton.width*0.4, 4,color, null, null, null, null, null, false).centerReg(dragButton).alp(.2);
		        rect.y -= -22 +(i*15);
		    }
		    dragButton.x = (8.5*size)+(40);
		    dragButton.y = - size - 5;
		    dragButton.name = "drag";
		}

		function hideKeyboard() {
		    that.hide();
		}

		function startDragging() {
			if (that.mouseYAmount) that.y = that.parent.globalToLocal(0, that.mouseYAmount-dragY).y;
		}

		function stopDragging() {
			currentStage.off("pressmousemove", that.tickerMouseEvent);
		    zim.Ticker.remove(startDragging);
		}


		// ~~~~~~~~~~~~~~~~~  LABELS AND CURSOR

		function positionBlinker() {
			if (!currentLabel || !textBlinker) return;
			// Dan Zen added 9.5.0 using CreateJS Label to avoid padding and backing issues and addition of bounds x for align issues
			var positionXBlinker = currentLabel.label.x + currentLabel.label.getBounds().x;
			for (var i=0; i<insertPoint;i++) {
				positionXBlinker += currentLabel.widthArray[i];
			}
			// Dan Zen added 9.5.0 padding for three types of Label (backing, backgroundColor and neither)
			textBlinker.heightOnly = currentLabel.getBounds().height*(currentLabel.backing&&zot(currentLabel.padding)?.9:1)-((currentLabel.paddingVertical&&currentLabel.background)?currentLabel.paddingVertical*2:0);
			textBlinker.center(currentLabel);
			textBlinker.x = positionXBlinker;
		}

		function makeCursorShiftmenu() {
			if (cursorShiftMenu) return that;
			if (!currentLabel) return that;
		    var tekens = placeClose?["<",">","x"]:["<",">"];
		    var label;
		    var bakking;
		    var button;
		    var point;
		    buttonsCursor = [];
		    point = currentLabel.localToLocal(0, 0, that);
		    cursorShiftMenu = new zim.Container({style:false}).addTo(that).pos({x:point.x, y:point.y+currentLabel.height+15, reg:true}).cur();
		    for (var i=0; i<tekens.length;i++) {
				bakking = new zim.Rectangle(size, size, placeBackgroundColor, borderColor, borderWidth, corner, null, null, false);
				if (tekens[i] == "x") new zim.Rectangle(size, size, "black", null, null, corner, null, null, false).alp(shadeAlpha).addTo(bakking);
		        button = new zim.Label({
		            lineWidth:10,
		            lineHeight:58, // ?
		            text:tekens[i],
					backing:bakking,
					font:DS.font!=null?DS.font:null,
		            color:placeColor,
		            align:"center",
					valign:"center",
					style:false
		        }).addTo(cursorShiftMenu).cache();
		        button.x = i*(size+5);
		        buttonsCursor.push(button);
		    }
			point = currentLabel.localToLocal(0, 0, that);
			cursorShiftMenu.x = point.x;
			cursorShiftMenu.y = point.y+currentLabel.height+15;
			cursorShiftMenu.on("click", verschuifCursor);
		    function verschuifCursor(e) {
		        if (buttonsCursor.indexOf(e.target)==0) {
		            if (insertPoint > 0) insertPoint--;
		        } else if (buttonsCursor.indexOf(e.target)==1) {
		            if (insertPoint < currentLabel.text.length) insertPoint++;
		        } else {
					removeCursorShiftMenu();
				}
		        positionBlinker();
		    }
		    that.stage.update();
		}
		function removeCursorShiftMenu() {
			if (!cursorShiftMenu) return that;
			cursorShiftMenu.removeAllEventListeners();
			that.removeChild(cursorShiftMenu);
			cursorShiftMenu = null;
		}

		function addToLabel(letter) {
			if (!currentLabel) return;
			var measureField;
			var widthMeasureField;
			// backspace
			if (letter === "del") {
				if (currentLabel) currentLabel.text = [currentLabel.text.slice(0,insertPoint-1),currentLabel.text.slice(insertPoint)].join('');
				insertPoint--;
				makeWidthsArray();
			} else {
				if (currentStatus === statuses.shift) {
					letter = letter.toUpperCase();
				}
				var textBeforeCheck = currentLabel.text;
				measureField = currentLabel.clone().removeFrom();
				measureField.text = letter;
				widthMeasureField = measureField.label.getMeasuredWidth();
				if (!currentLabel.widthArray) {
					currentLabel.widthArray = [currentLabel.breedte];
				} else {
					currentLabel.widthArray.splice(insertPoint,0,widthMeasureField);
				}
				//toevoegen in string
				if (insertPoint<currentLabel.text.length) {
					currentLabel.text = [currentLabel.text.slice(0,insertPoint),letter,currentLabel.text.slice(insertPoint)].join('');
				} else {
					// currentLabel.text+="\u202E" + letter;
					currentLabel.text+=letter;
				}
				// if (currentLabel && currentLabel.width<maxWidth) {
				if (currentLabel && currentLabel.label.getBounds().width<maxWidth) {
					insertPoint++;
					positionBlinker();
				} else {
					currentLabel.text = textBeforeCheck;
				}
			}
			if (currentStatus === statuses.shift&&!bigShiftOn) {
				that.removeChild(currentKeyboard);
				makeButtons();
				currentStatus = statuses.def;
			}
			positionBlinker();
			var keyEvent = new createjs.Event("keydown");
			keyEvent.letter = letter;
			that.dispatchEvent(keyEvent);
			that.stage.update();
		}

		function activateLabel(e) {
			if (!that.stage) return;
			var point;
			var pointLabel;
			var sumUp = 0;
			var found = false;
			currentLabel = e.target;
			if (!currentLabel.widthArrayCheck) makeWidthsArray();
			maxWidth = currentLabel.label.lineWidth?currentLabel.label.lineWidth:10000;
			// Dan Zen added 9.5.0 point relative to actual CreateJS Label - to avoid padding and backing issues
			point = currentLabel.globalToLocal(e.stageX/e.target.stage.scaleX, e.stageY/e.target.stage.scaleY);
			point.x -= currentLabel.label.x; // adjusted for retina - label is CreateJS with broken globalToLocal
			point.y -= currentLabel.label.y;
			// point opzoeken in array textfield door op te tellen
			// for (var i=currentLabel.widthArray.length-1; i>=0; i--) {
			// 	sumUp += currentLabel.widthArray[i];
			// 	if (point.x < sumUp-currentLabel.widthArray[i]/2) {
			// 		insertPoint = i;
			// 		found = true;
			// 		break;
			// 	}
			// }
			// var rightOfLabel = currentLabel.getBounds().width + currentLabel.getBounds().x;
			// zog(rightOfLabel);
			// zog(currentLabel.widthArray)
			// for (var i=0; i<currentLabel.widthArray.length; i++) {
			// 	sumUp += currentLabel.widthArray.reverse()[i];
			// 	if (point.x < rightOfLabel - sumUp-currentLabel.widthArray.reverse()[i]/2) {
			// 		insertPoint = i;
			// 		found = true;
			// 		break;
			// 	}
			// }
			for (var i=0; i<currentLabel.widthArray.length; i++) {
				sumUp += currentLabel.widthArray[i];
				// Dan Zen added 9.5.0 addition of bounds x for when align is center or right
				if (point.x < sumUp-currentLabel.widthArray[i]/2+currentLabel.label.getBounds().x) {
					insertPoint = i;
					found = true;
					break;
				}
			}
			if (!found) {
				insertPoint = currentLabel.text.length;
			}
			positionBlinker();
			if (place && !cursorShiftMenu && currentLabel.text.length > 0) {
				makeCursorShiftmenu();
			}
			if (cursorShiftMenu && currentLabel) {
				if (currentLabel.text.length > 0) {
					point = currentLabel.localToLocal(0, 0, that);
					cursorShiftMenu.x = point.x;
					cursorShiftMenu.y = point.y+currentLabel.height+15;
				} else {
					removeCursorShiftMenu();
				}
			}
		}
		function makeWidthsArray() {
			if (!currentLabel) return;
			var measureField;
			currentLabel.widthArray = [];
			for (var i=0; i<currentLabel.text.length; i++) {
				measureField = currentLabel.clone().removeFrom();
				measureField.text = currentLabel.text[i];
				currentLabel.widthArray.push(measureField.label.getMeasuredWidth());
			}
			currentLabel.widthArrayCheck = true;
			positionBlinker();
		}

		function backspaceRemovesLetter() {
		    var removalOkay = true;
		    var timeOut;
		    function haalWeg() {
		        if (!currentLabel || currentLabel.text.length<1 || that.currentIndex==0) {
		            removalOkay = false;
		        }
		        if (removalOkay) {
		            removeLetter();
		            timeOut = zim.timeout(200, haalWeg);
		        }
		        if (currentLabel && currentLabel.text.length<1) {
		            stopRemoval();
		        }
		    }
		    function removeLetter() {
		        if (currentLabel && currentLabel.text.length>0) {
					if (that.selectedIndex > 0) addToLabel("del");
		            that.on("pressup", stopRemoval);
		        } else {
		            addToLabel("del");
		        }
		    }
		    function stopRemoval() {
		        removalOkay = false;
		        timeOut.clear();
		        that.off("pressup", stopRemoval);
		    }
		    removeLetter();
		    timeOut = zim.timeout(300, haalWeg);
		    that.stage.update();
		}

		function setLabels() {
			for (var i=0; i<labels.length; i++) {
		        labels[i].clickEvent = labels[i].on("click", activateLabel);
		    }
		}
		setLabels();

		function unsetLabels() {
			if (labels.length > 1) {
				for (var i=0; i<labels.length; i++) {
					labels[i].off("click", labels[i].clickEvent);
				}
			}
		}

		function makeCursor() {
			if (textBlinker) return;
		    currentLabel = labels[0];
			maxWidth = (currentLabel && currentLabel.label.lineWidth)?currentLabel.label.lineWidth:10000;
		    if (currentLabel) {
		        textBlinker = new zim.Rectangle(3, currentLabel.height-((currentLabel.paddingVertical&&currentLabel.background)?currentLabel.paddingVertical*2:0), cursorColor, null, null, null, null, null, false).center(currentLabel);;
		        textBlinker.x = 0;
				textBlinker.visible = false;
		        textBlinker.animate({
		            obj:{alpha:0},
		            rewind:true,
		            loop:true,
		            loopWait:750,
		            time:250,
		            id:"knipperTekst"
		        });
		        for (var j=0; j<labels.length; j++) {
		            labels[j].widthArray = [0];
		        }
				makeWidthsArray();
			}
		}
		makeCursor();
		function removeCursor() {
			zim.stopAnimate("knipperTekst");
			if (currentLabel) currentLabel.removeChild(textBlinker);
			textBlinker = null;
			currentLabel = null;
		}

		// ~~~~~~~~~~~~~~~ GETTER SETTER PROPS

		Object.defineProperty(this, 'selectedLabel', {
			get: function() {
				return currentLabel;
			},
			set: function(label) {
				var obj = {target:label};
				activateLabel(obj);
				that.hidePlace();
			}
		});

		Object.defineProperty(this, 'selectedIndex', {
			get: function() {
				return insertPoint;
			},
			set: function(index) {
				insertPoint = index;
				positionBlinker();
			}
		});

		// ~~~~~~~~~~~~~~~ METHODS

		this.show = function(index) {
			that.addTo(container);
			// that.resize();
			if (!zot(index)) {
				var obj = {target:labels[index]};
				activateLabel(obj);
			}
			if (textBlinker) textBlinker.visible = true;
			that.toggled = true;
			return that;
		}

		this.hide = function() {
			that.removeFrom(container);
			if (textBlinker) textBlinker.visible = false;
			currentStage.update();
			that.toggled = false;
			return that;
		}

		this.toggle = function(state) {
			if (state===true) that.show();
			else if (state===false) that.hide();
			else if (that.parent) that.hide();
			else that.show();
			return that;
		}

		this.showPlace = function() {
			makeCursorShiftmenu()
			return that;
		}

		this.hidePlace = function() {
			removeCursorShiftMenu();
			return that;
		}

		this.addLabels = function(labs) {
			if (!Array.isArray(labs)) labs = [labs];
			for (var i=labs.length-1; i>=0; i--) {
				var ind = labels.indexOf(labs[i]);
				if (ind >= 0 || labs[i].type != "Label") labs.splice(i, 1);
				else labs[i].widthArray = [0];
			}
			unsetLabels();
			labels = labels.concat(labs);
			setLabels();
			makeCursor();
			if (textBlinker) textBlinker.visible = true;
			return that;
		}

		this.removeLabels = function(labs) {
			if (!Array.isArray(labs)) labs = [labs];
			unsetLabels();
			for (var i=0; i<labs.length; i++) {
				var ind = labels.indexOf(labs[i]);
				if (ind >= 0) labels.splice(ind, 1);
			}
			setLabels();
			if (labels.length == 0) {
				if (currentLabel) removeCursor();
			} else {
				if (currentLabel && labels.indexOf(currentLabel) == -1) {
					removeCursor();
					makeCursor();
				}
			}
			return that;
		}

		var background = new zim.Rectangle(this.width, this.height, zim.clear, null, null, null, null, null, false).addTo(this).expand().bot();
		background.on("mousedown", function(){});
		background.on("click", function(){});

		this.resize = function() {
			that.scaleTo(currentStage, 100-margin*2/currentStage.width*100, 50-margin*2/currentStage.height*100);
			that.y = currentStage.height - that.height - margin;
			that.x = currentStage.width/2 - that.width/2;
			if (currentLabel && cursorShiftMenu) {
				point = currentLabel.localToLocal(0, 0, that);
		        cursorShiftMenu.x = point.x;
				cursorShiftMenu.y = point.y+currentLabel.height+15;
			}
			if (that.stage) that.stage.update();
			return that;
		}
		this.resize();

		if (that.selectedLabel) that.selectedIndex = that.selectedLabel.text.length;

		if (style!==false) zimStyleTransforms(this, DS);
		this.clone = function() {
			var kb = new zim.Keyboard(labels, backgroundColor, color, shiftBackgroundColor, shiftHoldBackgroundColor, placeBackgroundColor, cursorColor, shadeAlpha, margin, corner, draggable, placeClose, shadowColor, shadowBlur, container, data, place, special, rtl, style, this.group, inherit);
			return that.cloneProps(kb);
		}
	}
	zim.extend(zim.Keyboard, zim.Container, "clone", "zimContainer", false);
	//-67.2

/*--
zim.Organizer = function(width, list, useAdd, useRemove, usePosition, autoAdd, autoRemove, autoPosition, addForward, removeForward, backgroundColor, rollBackgroundColor, selectedBackgroundColor, selectedRollBackgroundColor, color, rollColor, selectedColor, selectedRollColor, spacing, corner, keyEnabled, gradient, gloss, backdropColor, style, group, inherit)

Organizer
zim class - extends a zim.Tabs which extends a zim.Container which extends a createjs.Container

DESCRIPTION
A Tabs bar of interface for organizing a ZIM List.
This includes add, up, down, toTop, toBottom and remove icon buttons.
The Organizer can sit above the list and allow the user to add, remove and reorder the list.
Adding an item will add an empty button - this would need to be filled with the user input, etc.
If the user input is not ready, the autoAdd parameter can be set to false.
The change event will report an orgType of "add" and the add() method can be used when the input is ready.
The same for positioning or removing if desired.

See: https://zimjs.com/explore/organizer.html

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
	var organizer = new Organizer(250)
		.change(function () {
			if (organizer.orgType=="add") organizer.orgItem.text = "new";
		});
	new List({
		width:250
		organizer:organizer // pass the organizer to the list
	});
		.center()
		.mov(0,40);
	stage.update();

	// OR

	var list = new List(250)
		.center()
		.mov(0,40);
	var organizer = new Organizer(250, list)
		.center()
		.mov(0,-80)
		.change(function () {
			if (organizer.orgType=="add") organizer.orgItem.text = "new";
		});
	stage.update();
END EXAMPLE

PARAMETERS
** supports DUO - parameters or single object with properties below
** supports OCT - parameter defaults can be set with STYLE control (like CSS)
width - (default 300) width of Tabs - this will determine the height as the Buttons are square.
	There is no vertical version of an Organizer.
list - (default null) an ZIM List object to control - or null to add later with the list property
useAdd - default(true) set to false to not include the add button
useRemove - default(true) set to false to not include the remove button
usePosition - default(true) set to false to not include the position buttons (up, down, toTop, toBottom)
autoAdd - default(useAdd) set to false to not automatically add an item
	the "change" event will still be dispatched and the orgType will be "add"
	the add() method can be used to add user input for instance
autoRemove - default(useRemove) set to false to not automatically add an item
	the "change" event will still be dispatched and the orgType will be "remove"
	the remove() method can be used to manually remove
autoPosition - default(usePosition) set to false to not automatically position an item
	the "change" event will still be dispatched and the orgType will be "up", "down", "top", "bottom"
	the up(), down(), toTop(), toBottom() methods can be used to manually position
addForward - (default true) set to false to add item behind the current item (in list index) when adding
removeForward - (default true) set to false to select the item before the current item (in list index) when deleting
backgroundColor - (default "#777") the background color of the buttons
rollBackgroundColor - (default "#555") the background color of the button as rolled over
selectedBackgroundColor - (default "#444") the background color of the button when selected
color - (default "white") the text color of a deselected button when not rolled over
selectedColor - (default color) the text color of the selected button
rollColor - (default color) the rollover color
spacing - (default 2) the distance between the buttons
corner - (default 0) the corner radius of the tabs
   can also be an array of [topLeft, topRight, bottomRight, bottomLeft]
keyEnabled - (default true) so tab key cycles through tabs, shift tab backwards
gradient - (default null) 0 to 1 (try .3) adds a gradient to the buttons
gloss - (default null) 0 to 1 (try .1) adds a gloss to the buttons
backdropColor - (default "#333") the background color of the list window (any CSS color)
style - (default true) set to false to ignore styles set with the STYLE - will receive original parameter defaults
group - (default null) set to String (or comma delimited String) so STYLE can set default styles to the group(s) (like a CSS class)
inherit - (default null) used internally but can receive an {} of styles directly

METHODS
add(index, item, clone) - manually add item at index - both are optional - index defaults to current index
	clone defaults to false - set to true to add a clone of the item
up(index) - move item up one index number in list - index defaults to current index
down(index) - move item down one index number in list - index defaults to current index
toTop(index) - move item to top of list (index 0) - index defaults to current index
toBottom(index) - move item bottom of list (index length-1) - index defaults to current index
remove(index) - manually remove item at index - index defaults to current index
setButtons() - manually rotate buttons to match List direction - automatically done when added to list or list is initially added to organizer
hasProp(property as String) - returns true if property exists on object else returns false
clone() - makes a copy with properties such as x, y, etc. also copied
dispose() - removes from parent, removes event listeners - must still set outside references to null for garbage collection

ALSO: All Tab methods

ALSO: ZIM 4TH adds all the methods listed under Container (see above), such as:
drag(), hitTestRect(), animate(), sca(), reg(), mov(), center(), centerReg(),
addTo(), removeFrom(), loop(), outline(), place(), pos(), alp(), rot(), setMask(), etc.
ALSO: See the CreateJS Easel Docs for Container methods, such as:
on(), off(), getBounds(), setBounds(), cache(), uncache(), updateCache(), dispatchEvent(),
addChild(), removeChild(), addChildAt(), getChildAt(), contains(), removeAllChildren(), etc.

PROPERTIES
type - holds the class name as a String
list - the list the organizer is operating on
lastIndex - read-only selected index before change event is dispatched
orgIndex - read-only current index of list - same as list.currentIndex
orgItem - read-only selected item of list - same as list.selected
orgType - read-only type of button pressed - "add", "remove", "up", "down", "top", "bottom"
removedItem - a reference to the item that has been removed when removed button is pressed or remove() is called
group - used when the object is made to add STYLE with the group selector (like a CSS class)

ALSO: All Tab properties

ALSO: See the CreateJS Easel Docs for Container properties, such as:
x, y, rotation, scaleX, scaleY, regX, regY, skewX, skewY,
alpha, cursor, shadow, mouseChildren, mouseEnabled, parent, numChildren, etc.

EVENTS
dispatches a "change" event when the buttons are pressed (may be the same button again)
	use orgType for what type "add", "remove", "up", "down", "top", "bottom"
	use orgIndex or list.currentIndex for current list index
	use orgItem or list.selected for selected item
	use removedItem for a removed item
	use lastIndex for index before change

ALSO: All Tab events

ALSO: See the CreateJS Easel Docs for Container events, such as:
added, click, dblclick, mousedown, mouseout, mouseover, pressmove, pressup, removed, rollout, rollover
--*///+67.3
	zim.Organizer = function(width, list, useAdd, useRemove, usePosition, autoAdd, autoRemove, autoPosition, addForward, removeForward, backgroundColor, rollBackgroundColor, selectedBackgroundColor, selectedRollBackgroundColor, color, rollColor, selectedColor, selectedRollColor, spacing, corner, keyEnabled, gradient, gloss, backdropColor, style, group, inherit) {
		var sig = "width, list, useAdd, useRemove, usePosition, autoAdd, autoRemove, autoPosition, addForward, removeForward, backgroundColor, rollBackgroundColor, selectedBackgroundColor, selectedRollBackgroundColor, color, rollColor, selectedColor, selectedRollColor, spacing, corner, keyEnabled, gradient, gloss, backdropColor, style, group, inherit";
		var duo; if (duo = zob(zim.Organizer, arguments, sig, this)) return duo;
		z_d("67.3");

		this.group = group;
		var DS = style===false?{}:zim.getStyle("Organizer", this.group, inherit);

		if (zot(width)) width = DS.width!=null?DS.width:(list&&list.vertical)?list.width:300;
		if (zot(useAdd)) useAdd = DS.useAdd!=null?DS.useAdd:true;
		if (zot(useRemove)) useRemove = DS.useRemove!=null?DS.useRemove:true;
		if (zot(usePosition)) usePosition = DS.usePosition!=null?DS.usePosition:true;
		if (zot(autoAdd)) autoAdd = DS.autoAdd!=null?DS.autoAdd:useAdd;
		if (zot(autoRemove)) autoRemove = DS.autoRemove!=null?DS.autoRemove:useRemove;
		if (zot(autoPosition)) autoPosition = DS.autoPosition!=null?DS.autoPosition:usePosition;
		if (zot(addForward)) addForward = DS.addForward!=null?DS.addForward:true;
		if (zot(removeForward)) removeForward = DS.removeForward!=null?DS.removeForward:true;
		if (zot(backgroundColor)) backgroundColor = DS.backgroundColor!=null?DS.backgroundColor:"#777";
		if (zot(rollBackgroundColor)) rollBackgroundColor = DS.rollBackgroundColor!=null?DS.rollBackgroundColor:"#555";
		if (zot(selectedBackgroundColor)) selectedBackgroundColor = DS.selectedBackgroundColor!=null?DS.selectedBackgroundColor:"#333";
		if (zot(color)) color = DS.color!=null?DS.color:"white";
		if (zot(rollColor)) rollColor = DS.rollColor!=null?DS.rollColor:color;
		if (zot(selectedColor)) selectedColor = DS.selectedColor!=null?DS.selectedColor:color;
		if (zot(spacing)) spacing = DS.spacing!=null?DS.spacing:1;
		if (zot(corner)) corner = DS.corner!=null?DS.corner:0;
		if (zot(gradient)) gradient = DS.gradient!=null?DS.gradient:.2;
		if (zot(gloss)) gloss = DS.gloss!=null?DS.gloss:null;
		if (zot(backdropColor)) backdropColor = DS.backdropColor!=null?DS.backdropColor:null;
		if (!Array.isArray(corner)) {
			corner = [corner, corner, corner, corner];
		}

		var buttonStyle = {
			width:50,
			height:50,
			label:"",
			shadowColor:-1,
			gradient:gradient,
			corner:corner,
			backgroundColor:backgroundColor,
			rollBackgroundColor:rollBackgroundColor
		}

		var buttons = this.buttons = [];
		var addIcon = new zim.Shape();
		addIcon.graphics.f(color).p("AAAA4Ih6B8Ig5g4IB8h8Ih7h6IA4g5IB6B8IB7h8IA5A5Ih8B6IB8B7Ig5A5g");
		if (useAdd) buttons.push(new zim.Button({icon:addIcon.sca(.55).rot(-45).reg(1), inherit:buttonStyle}));
		if (usePosition) {
			var arrowIcon = new zim.Shape();
			arrowIcon.graphics.f(color).p("AiJieIETCeIkTCfg");
			buttons.push(new zim.Button({icon:arrowIcon.sca(.6).rot(list&&!list.vertical?180:-90).reg(-2), inherit:buttonStyle}));
			buttons.push(new zim.Button({icon:arrowIcon.clone().sca(.6).rot(list&&!list.vertical?0:90).reg(-2), inherit:buttonStyle}));
			var endIcon = new zim.Shape();
			endIcon.graphics.f(color).p("AiFCLIAAkVIBXAAIAAEVgAgiAAICoiHIAAEQg");
			buttons.push(new zim.Button({icon:endIcon.sca(.62).rot(list&&!list.vertical?0:90).reg(0), inherit:buttonStyle}));
			buttons.push(new zim.Button({icon:endIcon.clone().sca(.62).rot(list&&!list.vertical?180:-90).reg(0), inherit:buttonStyle}));
		}
		if (useRemove) buttons.push(new zim.Button({icon:addIcon.clone().rot(0).sca(.55), inherit:buttonStyle}));
		if (buttons.length==0) buttons = [""]
		this.zimTabs_constructor(width, width/buttons.length, buttons, backgroundColor, rollBackgroundColor, selectedBackgroundColor, selectedRollBackgroundColor, color, rollColor, selectedColor, selectedRollColor, false, spacing, true, false, corner, null, true, gradient, gloss, null, null, null, null, null, null, null, null, null, null, backdropColor);

		var that = this;
		that.list = list;
		that.type = "Organizer";

		that.setButtons = function() {
			if (usePosition) {
				that.buttons[1].icon.rotation = that.list&&!that.list.vertical?180:-90;
				that.buttons[2].icon.rotation = that.list&&!that.list.vertical?0:90;
				that.buttons[3].icon.rotation = that.list&&!that.list.vertical?0:90;
				that.buttons[4].icon.rotation = that.list&&!that.list.vertical?180:-90;
			}
		}

		var listEvent = false;
		var lastList = list;

		that.change(function (e) {
			// handle dynamically adding event to list, delayed list or changed list
			if ((!listEvent && that.list) || (that.list && that.list != lastList)) {
				if (that.list != lastList) {if (lastList) lastList.noChange();}
				that.list.change(function (e) {
					that.orgItem = that.list.selected;
					that.orgIndex = that.list.selectedIndex;
				});
				listEvent = true;
				lastList = that.list;
			}
			var val = e.target.selectedIndex;
			if (!useAdd) val++;
			if (!usePosition && (!useAdd || val>0)) val = 5;
			var badIndex = zot(that.list.selectedIndex) || that.list.selectedIndex<0;
			if (badIndex) that.currentValue = null;
			that.lastIndex = that.list.selectedIndex;
			switch(val) {
				case 0: // add
					if (autoAdd) {
						var index = Math.max(0,that.list.selectedIndex);
						that.add(index);
					}
					that.orgType = "add";
					break;
				case 1:  // up
					if (badIndex) break;
					if (autoPosition) {
						var index = that.list.selectedIndex;
						that.up(index);
					}
					that.orgType = "up";
					break;
				case 2:  // down
					if (badIndex) break;
					if (autoPosition) {
						var index = that.list.selectedIndex;
						that.down(index);
					}
					that.orgType = "down";
					break;
				case 3: // top
					if (badIndex) break;
					if (autoPosition) {
						var index = that.list.selectedIndex;
						that.toTop(index);
					}
					that.orgType = "top";
					break;
				case 4: // bottom
					if (badIndex) break;
					if (autoPosition) {
						var index = that.list.selectedIndex;
						that.toBottom(index);
					}
					that.orgType = "bottom";
					break;
				case 5: // remove
					if (badIndex) break;
					if (autoRemove) {
						var index = that.list.selectedIndex;
						that.remove(index);
					}
					that.orgType = "remove";
					break;
			}
		});

		this.add = function(index, item, clone) {
			if (zot(index)) index = that.lastIndex;
			if (zot(item)) item = "";
			if (addForward) {
				var index = Math.min(that.list.length, Math.max(0,that.list.selectedIndex)+1);
			} else {
				var index = Math.max(0,that.list.selectedIndex);
			}
			that.list.addAt(item, index, clone);
			that.list.selectedIndexPlusPosition = index;
			that.orgItem = that.list.selected;
			that.orgIndex = that.list.selectedIndex;
		}

		this.up = function(index) {
			if (zot(index)) index = that.lastIndex;
			var button = that.list.items[index];
			if (zot(button)) return;
			that.list.removeAt(1, index);
			that.list.addAt(button, index-1);
			that.list.selectedIndexPlusPosition = Math.max(0,index-1);
			that.orgItem = that.list.selected;
			that.orgIndex = that.list.selectedIndex;
		}

		this.down = function(index) {
			if (zot(index)) index = that.lastIndex;
			var button = that.list.items[index];
			if (zot(button)) return;
			that.list.removeAt(1, index);
			that.list.addAt(button, index+1);
			that.list.selectedIndexPlusPosition = Math.min(that.list.length-1,index+1);
			that.orgItem = that.list.selected;
			that.orgIndex = that.list.selectedIndex;
		}

		this.toTop = function(index) {
			if (zot(index)) index = that.lastIndex;
			var button = that.list.items[index];
			if (zot(button)) return;
			that.list.removeAt(1, index);
			that.list.addAt(button, 0);
			that.list.first();
			that.orgItem = that.list.selected;
			that.orgIndex = that.list.selectedIndex;
		}

		this.toBottom = function(index) {
			if (zot(index)) index = that.lastIndex;
			var button = that.list.items[index];
			if (zot(button)) return;
			that.list.removeAt(1, index);
			that.list.addAt(button, that.list.length);
			that.list.last();
			that.orgItem = that.list.selected;
			that.orgIndex = that.list.selectedIndex;
		}

		this.remove = function(index) {
			if (zot(index)) index = that.lastIndex;
			that.removedItem = that.list.selected;
			var index = Math.max(0,that.list.selectedIndex);
			that.list.removeAt(1, index);
			if (removeForward) {
				var index = Math.max(0,that.list.selectedIndex);
			} else {
				var index = Math.max(0,that.list.selectedIndex-1);
			}
			that.list.selectedIndexPlusPosition = Math.min(that.list.length-1, index);
			that.orgItem = that.list.selected;
			that.orgIndex = that.list.selectedIndex;
		}

		if (style!==false) zimStyleTransforms(this, DS);
		this.clone = function() {
			return that.cloneProps(new zim.Organizer(width, list, useAdd, useRemove, usePosition, autoAdd, autoRemove, autoPosition, addForward, removeForward, backgroundColor, rollBackgroundColor, selectedBackgroundColor, selectedRollBackgroundColor, color, rollColor, selectedColor, selectedRollColor, spacing, corner, keyEnabled, gradient, gloss, backdropColor, style, that.group, inherit));
		}
	}
	zim.extend(zim.Organizer, zim.Tabs, "clone", "zimTabs", false);
	//-67.3

/*--
zim.Loader = function(width, height, label, backgroundColor, rollBackgroundColor, color, rollColor, borderColor, borderWidth, corner, shadowColor, shadowBlur, hitPadding, gradient, gloss, dashed, backing, rollBacking, rollPersist, icon, rollIcon, toggle, toggleBacking, rollToggleBacking, toggleIcon, rollToggleIcon, toggleEvent, frame, style, group, inherit)

Loader
zim class - extends a zim.Button which extends a zim.Container

DESCRIPTION
Loader lets you upload images and access them as a Bitmap (available in the loaded event function)
Loader uses the HTML input type=file tag and overlays this with a createjs DOMElement.
Loader is a Button so can be displayed for the user to click on.
It defaults to a dashed line region as you can also drag and drop files to the loader.
You can also save an image using the save() method to a new browser window for the user to save

NOTE: as of ZIM 5.5.0 the zim namespace is no longer required (unless zns is set to true before running zim)

EXAMPLE
var loader = new Loader({
	frame:frame,
	label:"UPLOAD PIC OR DROP PICS HERE",
	width:700,
	height:400,
	corner:50
}).center(stage);
loader.on("loaded", function(e) {
	loop(e.bitmaps, function(bitmap){
		bitmap.centerReg(stage).drag();
	});
	loader.removeFrom(stage);
	stage.update();
});

// and to later save for instance in a button event:
saveButton.on("click") {
	loader.save(stage); // or some other container... can specify crop bounds too
}
END EXAMPLE

PARAMETERS
** supports DUO - parameters or single object with properties below
** supports OCT - parameter defaults can be set with STYLE control (like CSS)
width - (default 250) the width of the button
height - (default 70) the height of the button
label - (default "UPLOAD PIC") ZIM Label or plain text
backgroundColor - (default "rgba(0,0,0,.05)") background color of button (any CSS color)
rollBackgroundColor - (default "rgba(0,0,0,.1)") rollover color of button backbground
color - (default "rgba(0,0,0,.5)") text color of button (any CSS color)
rollColor - (default color) rollover text color of button
borderColor - (default rgba(0,0,0,.3)) the color of the border
borderWidth - (default 1) thickness of the border
corner - (default 0) the round of the corner (set to 0 for no corner)
	can also be an array of [topLeft, topRight, bottomRight, bottomLeft]
shadowColor - (default "rgba(0,0,0,.3)") set to -1 for no shadow
shadowBlur - (default 14) how blurred the shadow is if the shadow is set
hitPadding - (default 0) adds extra hit area to the button (good for mobile)
gradient - (default 0) 0 to 1 (try .3) adds a gradient to the button
gloss - (default 0) 0 to 1 (try .1) adds a gloss to the button
backing - (default null) a Display object for the backing of the button (eg. Shape, Bitmap, Container, Sprite)
	see ZIM Pizzazz module for a fun set of Button Shapes like Boomerangs, Ovals, Lightning Bolts, etc.
	https://zimjs.com/bits/view/pizzazz.html
rollBacking - (default null) a Display object for the backing of the rolled-on button
rollPersist - (default false) set to true to keep rollover state when button is pressed even if rolling off
icon - (default false) set to display object to add icon at the center of the button and remove label
	https://zimjs.com/bits/view/icons.html
rollIcon - (default false) set to display object to show icon on rollover
toggle - (default null) set to string to toggle with label or display object to toggle with icon or if no icon, the backing
rollToggle - (default null) set to display object to toggle with rollIcon or rollBacking if no icon
	there is no rollToggle for a label - that is handled by rollColor on the label
toggleEvent - (default mousedown for mobile and click for not mobile) what event causes the toggle
dashed - (default true) set to false to turn off the dashed for the border
frame - (default the zimDefaultFrame) a reference to the Frame (to scale and position the HTML tag)
style - (default true) set to false to ignore styles set with the STYLE - will receive original parameter defaults
group - (default null) set to String (or comma delimited String) so STYLE can set default styles to the group(s) (like a CSS class)
inherit - (default null) used internally but can receive an {} of styles directly

METHODS
resize() - call the resize event if the scale or position of the Loader is changed
	this will sync the location of the HTML input tag
	resize() is only needed if the scale or x, y of the Loader (or its container) is changed
	it is not needed for general window resizing - the Loader handles this
save(content, x, y, width, height, url, cached, cachedBounds, type, data) - save a picture (supports ZIM DUO)
	content - the Display object to be saved such as a Container, Bitmap, etc.
	x, y, width, height - the cropping bounds on that object otherwise defaults to 0,0,stageW,stageH
	cached - (default false) set to true if the object is currently already cached
	cachedBounds - if you are saving a different bounds than was previously cached
		setting the bounds here (createjs.Rectangle) will restore the cache to the previous bounds
	type - (default "png") set to "jpeg" for jpeg
	data - (default false) set to true to save as base64 data - thanks Andi Ermi for the request
		otherwise save returns the object for chaining

Button methods:
setBacking(type, newBacking) - dynamically set any type of backing for button (if null removes backing for that type)
	Backing types are: "backing", "rollBacking", "toggleBacking", "rollToggleBacking", "waitBacking", "rollWaitBacking"
	note - all backing will have a pattern property if a pattern is set as a backing
setIcon(type, newIcon) - dynamically set any type of icon for button (if null removes icon for that type)
	Icon types are: "icon", "rollIcon", "toggleIcon", "rollToggleIcon", "waitIcon", "rollWaitIcon"
toggle(state) - forces a toggle of label if toggle param is string, else toggles icon if icon is set or otherwise toggles backing
	state defaults to null so just toggles
	pass in true to go to the toggled state and false to go to the original state
hasProp(property as String) - returns true if property exists on object else returns false
clone() - makes a copy with properties such as x, y, etc. also copied
dispose() - removes from parent, removes event listeners - must still set outside references to null for garbage collection

ALSO: ZIM 4TH adds all the methods listed under Container (see above), such as:
drag(), hitTestRect(), animate(), sca(), reg(), mov(), center(), centerReg(),
addTo(), removeFrom(), loop(), outline(), place(), pos(), alp(), rot(), setMask(), etc.
ALSO: See the CreateJS Easel Docs for Container methods, such as:
on(), off(), getBounds(), setBounds(), cache(), uncache(), updateCache(), dispatchEvent(),
addChild(), removeChild(), addChildAt(), getChildAt(), contains(), removeAllChildren(), etc.

PROPERTIES
type - holds the class name as a String
tag - the HTML input tag of type file - used for uploading
group - used when the object is made to add STYLE with the group selector (like a CSS class)

Button properties:
** setting widths and heights adjusts scale not bounds and getting these uses the bounds dimension times the scale
width - gets or sets the width. Setting the width will scale the height to keep proportion (see widthOnly below)
height - gets or sets the height. Setting the height will scale the width to keep proportion (see heightOnly below)
widthOnly - gets or sets the width.  This sets only the width and may change the aspect ratio of the object
heightOnly - gets or sets the height.  This sets only the height and may change the aspect ratio of the object
text - references the text property of the Label object of the button
label - gives access to the label
backgroundColor - get or set non-rolled on backing color (if no backing specified)
rollBackgroundColor - get or set rolled on backing color
color - get or set non-rolled on text color (if no icon specified)
rollColor - get or set rolled on text color
backing - references the backing of the button
rollBacking - references the rollBacking (if set)
icon - references the icon of the button (if set)
rollIcon - references the rollIcon (if set)
toggleObj - references the toggle object (string or display object if set)
rollToggle - references the rollToggle (if set)
toggled - true if button is in toggled state, false if button is in original state
enabled - default is true - set to false to disable
rollPersist - default is false - set to true to keep rollover state when button is pressed even if rolling off
focus - get or set the focus property of the Button used for tabOrder
blendMode - how the object blends with what is underneath - such as "difference", "multiply", etc. same as CreateJS compositeOperation

ALSO: See the CreateJS Easel Docs for Container properties, such as:
x, y, rotation, scaleX, scaleY, regX, regY, skewX, skewY,
alpha, cursor, shadow, mouseChildren, mouseEnabled, parent, numChildren, etc.

ACTIONEVENT
This component is affected by the general ACTIONEVENT setting
The default is "mousedown" - if set to something else the component will act on click (press)

EVENTS
loaded - is dispatched when the image(s) are uploaded - the event object comes with the following properties:
	e.bitmaps - an array of Bitmap objects of the loaded images
	e.bitmap - the first Bitmap to be created from the loaded images
	e.lastBitmap - the last Bitmap to be created from the loaded images
	e.total - the total Bitmap objects to be created from the loaded images

ALSO: See the CreateJS Easel Docs for Container events, such as:
added, click, dblclick, mousedown, mouseout, mouseover, pressmove, pressup, removed, rollout, rollover
--*///+67.5

	zim.Loader = function(width, height, label, backgroundColor, rollBackgroundColor, color, rollColor, borderColor, borderRollColor, borderWidth, corner, shadowColor, shadowBlur, hitPadding, gradient, gloss, dashed, backing, rollBacking, rollPersist, icon, rollIcon, toggle, toggleBacking, rollToggleBacking, toggleIcon, rollToggleIcon, toggleEvent, frame, style, group, inherit) {
		var sig = "width, height, label, backgroundColor, rollBackgroundColor, color, rollColor, borderColor, borderRollColor, borderWidth, corner, shadowColor, shadowBlur, hitPadding, gradient, gloss, dashed, backing, rollBacking, rollPersist, icon, rollIcon, toggle, toggleBacking, rollToggleBacking, toggleIcon, rollToggleIcon, toggleEvent, frame, style, group, inherit";
		var duo; if (duo = zob(zim.Loader, arguments, sig, this)) return duo;
		z_d("67.5");
		this.group = group;
		var DS = style===false?{}:zim.getStyle("Loader", this.group, inherit);

		if (zot(width)) width = DS.width!=null?DS.width:250;
		if (zot(height)) height = DS.height!=null?DS.height:70;
		if (zot(backgroundColor)) backgroundColor = DS.backgroundColor!=null?DS.backgroundColor:"rgba(0,0,0,.05)";
		if (zot(rollBackgroundColor)) rollBackgroundColor = DS.rollBackgroundColor!=null?DS.rollBackgroundColor:"rgba(0,0,0,.1)";
		if (zot(color)) color = DS.color!=null?DS.color:"rgba(0,0,0,.5)";
		if (zot(rollColor)) rollColor = DS.rollColor!=null?DS.rollColor:color;
		if (zot(borderColor)) borderColor = DS.borderColor!=null?DS.borderColor:"rgba(0,0,0,.3)";
		if (zot(borderWidth)) borderWidth = DS.borderWidth!=null?DS.borderWidth:1;
		if (zot(dashed)) dashed = DS.dashed!=null?DS.dashed:true;
		if (zot(corner)) corner = DS.corner!=null?DS.corner:0;
		if (zot(label)) label = DS.label!=null?DS.label:new zim.Label({
			text:"UPLOAD PIC", color:color, rollColor:rollColor, valign:"center", align:"center",
			backing:"ignore", shadowColor:"ignore", shadowBlur:"ignore", backgroundColor:"ignore",
			group:this.group
		});
		if (zot(frame)) {
			if (zimDefaultFrame) {
				frame = zimDefaultFrame;
			} else {
				if (zon) {zog("zim.Loader - please provide a reference to zim Frame");} return;
			}
		}
		// this.zimButton_constructor();

		this.zimButton_constructor(width, height, label, backgroundColor, rollBackgroundColor, color, rollColor, borderColor, borderRollColor, borderWidth, corner, shadowColor, shadowBlur, hitPadding, gradient, gloss, dashed, backing, rollBacking, rollPersist, icon, rollIcon, toggle, toggleBacking, rollToggleBacking, toggleIcon, rollToggleIcon, toggleEvent, null, null, null, null, null, null, null, null, null, null, null, null, false);
		this.type = "Loader";
		var that = this;
		var stage = frame.stage;
		label = that.label;

		var uploadTag = that.tag = document.createElement("input");
		document.body.appendChild(uploadTag);
		uploadTag.setAttribute("type", "file");
		uploadTag.setAttribute("multiple", "multiple");
		uploadTag.setAttribute("aria-hidden", true);
		uploadTag.hidden = true;
		uploadTag.style.cssText = "border:thin solid grey; z-index:2; width:"+width+"px; height:" + height + "px; overflow:hidden; outline:none;"
			 + "position:absolute; left:0px; top:0px; display:none; cursor:pointer; opacity: 0; filter: alpha(opacity=0);"

		this.addEventListener('mousedown', function() { // added for zim.Accessibility
			uploadTag.click();
		});
		uploadTag.addEventListener('change', handleImage);
		var upload = new createjs.DOMElement(uploadTag);
		stage.addChild(upload);
		upload.alpha = 0;

		var pRatio = frame.retina?(window.devicePixelRatio || 1):1;
		this.resize = function() {
			if (!that.stage) {
				uploadTag.setAttribute("aria-hidden", true);
				uploadTag.hidden = true;
				uploadTag.style.display = "none";
				// uploadTag.previosSibling.hidden = true;
				// uploadTag.previosSibling.style.display = "none";
				return;
			}
			uploadTag.setAttribute("aria-hidden", false);
			uploadTag.hidden = false;
			uploadTag.style.display = "block";
			// uploadTag.previosSibling.hidden = false;
			// uploadTag.previosSibling.style.display = "block";
			setTimeout(function() {
				var point = that.localToGlobal(0, 0);
				if (frame.retina) {
					upload.x = frame.x/stage.scaleX + point.x/pRatio;
					upload.y = frame.y/stage.scaleY + point.y/pRatio;
					// CreateJS DOMElement is scaling tag as stage scales
					zim.sca(upload, that.scaleX/pRatio, that.scaleY/pRatio);
				} else {
					upload.x = frame.x + point.x * frame.scale;
					upload.y = frame.y + point.y * frame.scale;
					zim.sca(upload, frame.scale*that.scaleX, frame.scale*that.scaleY);
				}
				stage.update();
			}, 50);
			return that;
		}
		this.resize();
		that.on("added", function() {
			uploadTag.style.display = "block";
			uploadTag.hidden = false;
			uploadTag.style.display = "block";
			that.resize();
		});
		that.added(addedCallback);
		function addedCallback() {
			that.resize();
			setTimeout(function() {
				uploadTag.style.display = "block";
				uploadTag.hidden = false;
				uploadTag.style.display = "block";
			}, 50);
			that.on("added", addedCallback, null, true); // once
		}
		that.on("removed", function() {
			uploadTag.style.display = "none";
			uploadTag.hidden = true;
			uploadTag.style.display = "none";
		});
		frame.on("resize", that.resize);

		function handleImage(e) {
			var files;
			if (e.dataTransfer && e.dataTransfer.files && e.dataTransfer.files.length > 0) {
				files = e.dataTransfer.files;
			} else {
				files = e.target.files;
			}
			var bitmaps = [];
			var firstBitmap;
			var lastBitmap;
			for (var i=0; i<files.length; i++) {
				(function(file) {
					var reader = new FileReader();
					reader.onload = function(event){
						var img = new Image();
						img.onload = function(){
							var bitmap = new zim.Bitmap(img);
							bitmaps.push(bitmap);
							if (bitmaps.length == 1) firstBitmap = bitmap;
							if (bitmaps.length == files.length) {
								var e = new createjs.Event("loaded");
								e.bitmaps = bitmaps;
								e.bitmap = firstBitmap;
								e.lastBitmap = bitmap;
								e.total = bitmaps.length;
								that.dispatchEvent(e);
								uploadTag.value = "";
							}
						}
						img.src = event.target.result;
					}
					reader.readAsDataURL(file);
				})(files[i]);
			};
		}
		var xhr = new XMLHttpRequest();
		if (xhr.upload) {
			uploadTag.addEventListener("drop", function(e) {
				// first imageLoader change event triggers so remove event then add it again later
				uploadTag.removeEventListener('change', handleImage);
				handleImage(e);
				setInterval(function() {uploadTag.addEventListener('change', handleImage);}, 100);
			});
		}

		this.save = function(content, filename, x, y, width, height, cached, cachedBounds, type, data) {

			var sig = "content, filename, x, y, width, height, cached, cachedBounds, type, data";
			var duo; if (duo = zob(that.save, arguments, sig)) return duo;
			if (zot(content)) content = frame.stage;

			if (zot(type)) type = "png";
			if (zot(filename)) {
				filename = "saved_" + String(zim.makeID("numbers", 5)) + "." + type;
			} else {
				var parts = filename.split(".");
				if (parts.length == 1) {
					filename += "." + type;
				} else {
					var types = ["png","jpg","jpeg"];
					var ind = types.indexOf(parts[parts.length-1].toLowerCase());
					if (ind == -1) {
						filename += "." + type;
					} else {
						type = types[ind];
					}
				}
			}
			if (zot(x)) x = 0;
			if (zot(y)) y = 0;
			if (zot(width)) width = (content.getBounds && content.getBounds()) ? content.getBounds().width : frame.width;
			if (zot(height)) height = (content.getBounds && content.getBounds()) ? content.getBounds().height : frame.height;


			content.cache(x, y, width, height);

			if (data) {
				var image = content.cacheCanvas.toDataURL('image/' + type);
				if (cached) {
					if (cachedBounds) content.cache(cashedBound.x, cashedBound.y, cashedBound.width, cashedBound.height);
				} else {
					content.uncache();
				}
				return image;
			}
			// if (!zot(url)) {
			// 	zim.async(url+"?data="+content.cacheCanvas.toDataURL('image/jpeg'), loaderReply);
			// 	function loaderReply(result) {
			// 		var e = new createjs.Event("saved");
			// 		e.result = result;
			// 		that.dispatchEvent(e);
			// 	}
			// // or to a script using zim.async (currently untested - will test and provide examples soon)
			// // saved - is dispatched when a file is saved to a script (needs the url parameter) - event object includes:
			// // e.result - the message sent back from the server in the zim.async.loaderReply('message')
			// } else {
				// disabled by Chrome https://groups.google.com/a/chromium.org/forum/#!topic/blink-dev/GbVcuwg_QjM%5B1-25%5D
				// zgo(content.cacheCanvas.toDataURL('image/'+type), "_blank");

				// iframe option
				// var win = window.open();
				// win.document.write("<html><head><title>saved</title></head><body style='margin:0px;padding:0px;overflow:hidden'><iframe src="+content.cacheCanvas.toDataURL('image/'+type)+" frameborder=0 style='overflow:hidden;height:100%;width:100%' height=100% width=100%></iframe></body></html>");
				// win.document.close();

				// var win = window.open();
				// win.document.write("<html><head><title>saved</title><s"+"cript>function test(){document.getElementById('pic').src='" +content.cacheCanvas.toDataURL('image/'+type)+"';}</s"+"cript></head><body style='margin:0px;padding:0px;overflow:hidden'><iframe id=pic frameborder=0 style='overflow:hidden;height:100%;width:100%' height=100% width=100%></iframe></body></html>");
				// win.document.close();
				// win.test();

				// Thanks Frank Loss for the prompting
				// Thanks Ken for the fiddle guidance - https://jsfiddle.net/AbdiasSoftware/7PRNN/
				var isMsEdge = /Edge\/(\d)+/.test(navigator.userAgent);
				if (isMsEdge){
					var win = window.open();
					win.document.write("<html><head><title>saved</title></head><body style='margin:0px;padding:0px;overflow:hidden'><img src="+content.cacheCanvas.toDataURL('image/'+type)+"></body></html>");
					win.document.close();
				} else {
					var a = document.createElement("a");
					a.setAttribute("download", filename);
					a.setAttribute("href", content.cacheCanvas.toDataURL('image/'+type));
					document.body.appendChild(a);
					a.click();
					document.body.removeChild(a);
				}

				// img option
				// var win = window.open();
				// win.document.write("<html><head><title>saved</title></head><body style='margin:0px;padding:0px;overflow:hidden'><img src="+content.cacheCanvas.toDataURL('image/'+type)+"></body></html>");
				// win.document.close();

			// }
			if (cached) {
				if (cachedBounds) content.cache(cashedBound.x, cashedBound.y, cashedBound.width, cashedBound.height);
			} else {
				content.uncache();
			}

			return that;
		}

		if (style!==false) zimStyleTransforms(this, DS);
		this.clone = function() {
			var u = new zim.Loader(
				width, height, !zot(label)?label.clone():null, backgroundColor, rollBackgroundColor, color, rollColor, borderColor, borderWidth, corner, shadowColor, shadowBlur, hitPadding, gradient, gloss,
				!zot(backing)?backing.clone():null,
				!zot(rollBacking)?rollBacking.clone():null,
				rollPersist,
				!zot(icon)?icon.clone():null, !zot(rollIcon)?rollIcon.clone():null,
				toggle,
				!zot(toggleBacking)?toggleBacking.clone():null,
				!zot(rollToggleBacking)?rollToggleBacking.clone():null,
				!zot(toggleIcon)?toggleIcon.clone():null,
				!zot(rollToggleIcon)?rollToggleIcon.clone():null,
				toggleEvent, frame, style, this.group
			);
			return that.cloneProps(u);
		}
		this.dispose = function() {
			document.body.removeChild(uploadTag);
			this.zimButton_dispose();
			return true;
		}
	}
	zim.extend(zim.Loader, zim.Button, ["clone", "dispose"], "zimButton", false);
	//-67.5

/*--
zim.TextArea = function(width, height, size, padding, color, backgroundColor, borderColor, borderWidth, corner, shadowColor, shadowBlur, dashed, id, placeholder, readOnly, spellCheck, password, inputType, frame, expand, style, group, inherit)

TextArea
zim class - extends a zim.Container which extends a createjs.Container

DESCRIPTION
TextArea creates an input text field by overlaying an HTML TextArea.
The TextArea is then overlayed with the createjs DOMElement
and scaled and positioned with ZIM code. This can also be used if selectable text is required
Access to the HTML tag is provided with the TextArea tag property.
So CSS Styles can be applied to the HTML tag as with any HTML textarea tag
